# ```Cloudfeaster``` Scripts

## Development Environment Setup

### [install-dev-env-scripts.sh](install-dev-env-scripts.sh)

* ```install-dev-env-scripts.sh``` is used by spider repos in ```cfg4dev```
  to install the Cloudfeaster development environment
* below is example of how ```cfg4dev``` would use ```install-dev-env-scripts.sh```

```bash
pushd "$(git rev-parse --show-toplevel)" > /dev/null

export DEV_ENV_DOCKER_IMAGE=simonsdave/gaming-spiders-xeniel-dev-env:build

if [ -d ./env ]; then
    source ./env/bin/activate
else
    python3.9 -m pip install virtualenv

    virtualenv env
    source ./env/bin/activate

    python3.9 -m pip install --upgrade pip

    CLF_VERSION=v$(grep cloudfeaster== ./setup.py | sed -e "s|^[[:space:]]*['\"]cloudfeaster==||g" | sed -e "s|['\"].*$||g")
    curl -s -L "https://raw.githubusercontent.com/simonsdave/cloudfeaster/${CLF_VERSION}/bin/install-dev-env-scripts.sh" | bash -s --
    unset CLF_VERSION

    ./dev_env/build-docker-image.sh "${DEV_ENV_DOCKER_IMAGE}"
fi

export PATH="$PWD/bin":$PATH

popd > /dev/null
```

### [install-chrome.sh](install-chrome.sh)

* if the ```--chrome``` command line option is specified installs [Chrome](https://www.google.com/chrome/)
* if the ```--chromium``` command line option is specified installs [Chromium](https://www.chromium.org/Home)
* expecting ```install-chrome.sh``` to be used only by various Cloudfeaster
  scripts ie. it implements a private "API" so use at your own peril
  or, and preferred, don't use ```install-chrome.sh```

#### References

* [Chromium](https://www.chromium.org/Home)
* [High-Level Architecture](https://www.chromium.org/developers/design-documents/multi-process-architecture)
* [29 Mar '18 - What’s the Difference Between Chromium and Chrome?](https://www.howtogeek.com/202825/what%E2%80%99s-the-difference-between-chromium-and-chrome)
  * Chromium is an open-source browser project that forms the basis for the Chrome web browser.
  * The biggest difference between the two browsers is that, while Chrome is based on Chromium, Google also adds a number of proprietary features to Chrome like automatic updates and support for additional video formats.

### [install-chromedriver.sh](install-chromedriver.sh)

* installs the correct version of [ChromeDriver](http://chromedriver.chromium.org/)
  based on the version of [Chrome](https://www.google.com/chrome/)
  or [Chromium](https://www.chromium.org/Home) installed
* the "correct" [ChromeDriver](http://chromedriver.chromium.org/) version is based
  on data from [this](http://chromedriver.chromium.org/downloads) page
* expecting ```install-chromedriver.sh``` to be used only by only by Cloudfeaster
  ie. it implements a private "API" so use at your own peril or, and preferred,
  don't use ```install-chromedriver.sh```

## [CircleCI](https://circleci.com)

### [generate-circleci-config.py](generate-circleci-config.py)

* ```generate-circleci-config.py``` generates a ```.circleci/config.yaml```
  for a spider repo

### [check-consistent-clf-version.sh](check-consistent-clf-version.sh)

* in spider repos the Cloudfeaster version is mentioned in two places (i) ```setup.py```
  and (ii) ```.circleci/config.yaml```
* ```check-consistent-clf-version.sh``` is intended to be added to ```.circleci/config.yaml```
  and have a zero exit code if the two Cloudfeaster versions are the same or
  a non-zero exit code if the two Cloudfeaster versions are different

### [check-circleci-config.sh](check-circleci-config.sh)

* ```check-circleci-config.sh``` is intended to be inserted into ```.circleci/config.yaml```
  to confirm the repo's ```.circleci/config.yaml``` is the same as
  that generated by ```generate-circleci-config.py```

### [int-test-run-all-spiders-in-ci-pipeline.py](int-test-run-all-spiders-in-ci-pipeline.py)

* A spider CI pipeline builds a docker image containing spiders.
  Ideally the CI pipeline would run each of the spiders in the
  docker image ala the way the spider will be run in production.
* ```int-test-run-all-spiders-in-ci-pipeline.py``` runs ```spiders.py```
  to discover all spiders in a docker image and then spins up
  a docker container to run each spider.
* command line usage

```bash
~> int-test-run-all-spiders-in-ci-pipeline.py
        <#-spiders-2-run-at-same-time>
        <max-secs-for-spider-to-run>
        <output-dir>
        <docker-image>
~>
```

* Note re <#-spiders-2-run-at-same-time> - from trial and error
  it seems as though only a single spider can be run reliably.
  Assumption is that this is some kind of resource constraint.

## Running and Discovering Spiders

### [spiders.py](spiders.py)

* discover all spiders

### [run-all-spiders.sh](run-all-spiders.sh)

* for use by a spider author during spider development
* calls ```run-spider.sh``` for all spiders in a repo
* example of command line usage

```bash
(env) dave@Daves-New-New-Mac-Mini gaming-spiders % run-all-spiders.sh
/Users/dave/gaming-spiders/gaming_spiders/gamehouseonlinegames.py
/Users/dave/gaming-spiders/gaming_spiders/gamesonly.py
/Users/dave/gaming-spiders/gaming_spiders/hiddenobjectgames.py
/Users/dave/gaming-spiders/gaming_spiders/mahjonggames.py
/Users/dave/gaming-spiders/gaming_spiders/match3games.py
/Users/dave/gaming-spiders/gaming_spiders/mindgames.py
/Users/dave/gaming-spiders/gaming_spiders/miniclip.py
/Users/dave/gaming-spiders/gaming_spiders/msnonlinegames.py
/Users/dave/gaming-spiders/gaming_spiders/solitaireonline.py
/Users/dave/gaming-spiders/gaming_spiders/zygomatic.py
(env) dave@Daves-New-New-Mac-Mini gaming-spiders %
```

### [run-spider.sh](run-spider.sh)

* for use by a spider author during spider development
* runs a spider in a development docker container created
  from a docker image named by the DEV_ENV_DOCKER_IMAGE
  environment variable
* example of command line usage

```bash
(env) dave@Daves-New-New-Mac-Mini gaming-spiders % pwd
/Users/dave/gaming-spiders
(env) dave@Daves-New-New-Mac-Mini gaming-spiders % ls -la gaming_spiders/*.py
-rw-r--r--  1 dave  staff    22 26 Aug  2020 gaming_spiders/__init__.py
-rwxr-xr-x  1 dave  staff  1780 26 Jan 20:00 gaming_spiders/gamehouseonlinegames.py
-rwxr-xr-x  1 dave  staff  1256 26 Jan 19:58 gaming_spiders/gamesonly.py
-rwxr-xr-x  1 dave  staff   638 26 Aug  2020 gaming_spiders/hiddenobjectgames.py
-rwxr-xr-x  1 dave  staff   618 26 Aug  2020 gaming_spiders/mahjonggames.py
-rwxr-xr-x  1 dave  staff   614 26 Aug  2020 gaming_spiders/match3games.py
-rwxr-xr-x  1 dave  staff   606 26 Aug  2020 gaming_spiders/mindgames.py
-rwxr-xr-x  1 dave  staff  1363 26 Jan 22:04 gaming_spiders/miniclip.py
-rwxr-xr-x  1 dave  staff  1210 26 Jan 22:18 gaming_spiders/msnonlinegames.py
-rwxr-xr-x  1 dave  staff   630 26 Aug  2020 gaming_spiders/solitaireonline.py
-rw-r--r--  1 dave  staff  1397 26 Jan 20:11 gaming_spiders/zygomatic.py
(env) dave@Daves-New-New-Mac-Mini gaming-spiders % run-spider.sh miniclip.py | jq .
{
  "1": {
    "title": "1 8 Ball Pool",
    "link": "https://www.miniclip.com/games/8-ball-pool-multiplayer/en/#t-w-t-H"
  },
  "2": {
    "title": "2 Agar.io",
    "link": "https://www.miniclip.com/games/agar-io/en/#t-w-t-H"
  },
  "3": {
    "title": "3 Flip Master",
    "link": "https://www.miniclip.com/games/flip-master/en/#t-w-t-H"
  },
  "4": {
    "title": "4 Krunker.io",
    "link": "https://www.miniclip.com/games/krunkerio/en/#t-w-t-H"
  },
  "5": {
    "title": "5 Soccer Stars Mobile",
    "link": "https://www.miniclip.com/games/soccer-stars-mobile/en/#t-w-t-H"
  },
  "6": {
    "title": "6 Short Ride",
    "link": "https://www.miniclip.com/games/short-ride/en/#t-w-t-H"
  },
  "7": {
    "title": "7 Quick Fire Pool Instant",
    "link": "https://www.miniclip.com/games/quickfire-pool-instant/en/#t-w-t-H"
  },
  "8": {
    "title": "8 Bubble Trouble",
    "link": "https://www.miniclip.com/games/bubble-trouble/en/#t-w-t-H"
  },
  "9": {
    "title": "9 Tanki Online",
    "link": "https://www.miniclip.com/games/tanki-online/en/#t-w-t-H"
  },
  "10": {
    "title": "10 Head Ball 2",
    "link": "https://www.miniclip.com/games/head-ball-2/en/#t-w-t-H"
  },
  "_metadata": {
    "status": {
      "code": 0,
      "message": "Ok"
    },
    "spider": {
      "name": "miniclip.py",
      "version": "sha256:48c81ae8b86cbf71035905ebc0c4ead321b823fafe093dbf5624912808f4b954"
    },
    "crawlArgs": [],
    "crawlTime": {
      "started": "2021-03-02T16:32:56.198453+00:00",
      "durationInMs": 4157
    }
  },
  "_debug": {
    "screenshot": "/var/folders/zc/51nmqy_93559vqw_1y526y240000gn/T/tmp.0llGnGgS/screenshot.png",
    "crawlLog": "/var/folders/zc/51nmqy_93559vqw_1y526y240000gn/T/tmp.0llGnGgS/crawl-log.txt",
    "chromeDriverLog": "/var/folders/zc/51nmqy_93559vqw_1y526y240000gn/T/tmp.0llGnGgS/chromedriver-log.txt"
  }
}
(env) dave@Daves-New-New-Mac-Mini gaming-spiders % ls -la /var/folders/zc/51nmqy_93559vqw_1y526y240000gn/T/tmp.0llGnGgS
total 3112
drwx------    6 dave  staff      192  2 Mar 11:33 .
drwx------@ 104 dave  staff     3328  2 Mar 11:32 ..
-rw-------    1 dave  staff   170642  2 Mar 11:33 chromedriver-log.txt
-rw-------    1 dave  staff        0  2 Mar 11:32 crawl-log.txt
-rw-r--r--    1 dave  staff     1618  2 Mar 11:33 crawl-output.json
-rw-------    1 dave  staff  1414454  2 Mar 11:33 screenshot.png
(env) dave@Daves-New-New-Mac-Mini gaming-spiders %
```

## Utilities

### [get-clf-version.sh](get-clf-version.sh)

* A repeated pattern emerge where a shell script need to parse
  setup.py and extract the cloudfeaster version. ```get-clf-version.sh```
  centralizes implementation of the pattern.
