# Generated by Django 2.1.12 on 2020-01-21 12:27

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ActiveLearningProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('sampling_strategy', models.CharField(max_length=4)),
                ('rebuild', models.IntegerField()),
                ('log_dir', models.CharField(max_length=255)),
            ],
            options={
                'db_table': 'highlighter_activelearningproject',
            },
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.PositiveIntegerField()),
                ('end', models.PositiveIntegerField()),
                ('orig_string', models.CharField(blank=True, max_length=255, null=True)),
                ('status', models.CharField(blank=True, choices=[('del', 'deleted'), ('ap', 'approved')], max_length=4, null=True)),
            ],
            options={
                'db_table': 'highlighter_annotation',
            },
        ),
        migrations.CreateModel(
            name='AnnotationProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'db_table': 'highlighter_annotationproject',
            },
        ),
        migrations.CreateModel(
            name='MenuEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kind', models.CharField(choices=[('txt', 'Text field'), ('frm', 'Form'), ('m', 'menu entry'), ('fn', 'Javascript function')], default='txt', max_length=4)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'highlighter_menuentry',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('base_url', models.URLField(blank=True, null=True)),
                ('store_text', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'highlighter_project',
            },
        ),
        migrations.CreateModel(
            name='TextHigh',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('text_type', models.CharField(choices=[('ft', 'Full Text'), ('id', 'Text ID'), ('cl', 'Text Class')], default='cl', max_length=3)),
                ('uri', models.URLField(blank=True, null=True)),
                ('text', models.TextField(blank=True, null=True)),
                ('text_id', models.PositiveIntegerField(blank=True, null=True)),
                ('text_class', models.CharField(blank=True, max_length=255, null=True)),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_highlighter.Project')),
            ],
            options={
                'db_table': 'highlighter_texthigh',
            },
        ),
        migrations.CreateModel(
            name='VocabularyAPI',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('api_endpoint', models.CharField(blank=True, max_length=255, null=True)),
                ('method', models.CharField(choices=[('l', 'local'), ('o', 'open skos')], default='l', max_length=2)),
            ],
            options={
                'db_table': 'highlighter_vocabularyapi',
            },
        ),
        migrations.AddField(
            model_name='menuentry',
            name='api',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apis_highlighter.VocabularyAPI'),
        ),
        migrations.AddField(
            model_name='menuentry',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='parent_menuEntry', to='apis_highlighter.MenuEntry'),
        ),
        migrations.AddField(
            model_name='menuentry',
            name='project',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_highlighter.Project'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='annotation_project',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_highlighter.AnnotationProject'),
        ),
    ]
