"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnVolume = exports.CfnStorageVirtualMachine = exports.CfnSnapshot = exports.CfnFileSystem = exports.CfnDataRepositoryAssociation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-14T19:42:52.954Z","fingerprint":"J2G2uvovrjcmGeNUoYJY4SOzojYUA4fOz7k3niOGqa0="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnDataRepositoryAssociationProps`
 *
 * @param properties - the TypeScript properties of a `CfnDataRepositoryAssociationProps`
 *
 * @returns the result of the validation.
 */
function CfnDataRepositoryAssociationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchImportMetaDataOnCreate', cdk.validateBoolean)(properties.batchImportMetaDataOnCreate));
    errors.collect(cdk.propertyValidator('dataRepositoryPath', cdk.requiredValidator)(properties.dataRepositoryPath));
    errors.collect(cdk.propertyValidator('dataRepositoryPath', cdk.validateString)(properties.dataRepositoryPath));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.requiredValidator)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.validateString)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('fileSystemPath', cdk.requiredValidator)(properties.fileSystemPath));
    errors.collect(cdk.propertyValidator('fileSystemPath', cdk.validateString)(properties.fileSystemPath));
    errors.collect(cdk.propertyValidator('importedFileChunkSize', cdk.validateNumber)(properties.importedFileChunkSize));
    errors.collect(cdk.propertyValidator('s3', CfnDataRepositoryAssociation_S3PropertyValidator)(properties.s3));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDataRepositoryAssociationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation` resource
 *
 * @param properties - the TypeScript properties of a `CfnDataRepositoryAssociationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation` resource.
 */
// @ts-ignore TS6133
function cfnDataRepositoryAssociationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataRepositoryAssociationPropsValidator(properties).assertSuccess();
    return {
        DataRepositoryPath: cdk.stringToCloudFormation(properties.dataRepositoryPath),
        FileSystemId: cdk.stringToCloudFormation(properties.fileSystemId),
        FileSystemPath: cdk.stringToCloudFormation(properties.fileSystemPath),
        BatchImportMetaDataOnCreate: cdk.booleanToCloudFormation(properties.batchImportMetaDataOnCreate),
        ImportedFileChunkSize: cdk.numberToCloudFormation(properties.importedFileChunkSize),
        S3: cfnDataRepositoryAssociationS3PropertyToCloudFormation(properties.s3),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDataRepositoryAssociationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataRepositoryPath', 'DataRepositoryPath', cfn_parse.FromCloudFormation.getString(properties.DataRepositoryPath));
    ret.addPropertyResult('fileSystemId', 'FileSystemId', cfn_parse.FromCloudFormation.getString(properties.FileSystemId));
    ret.addPropertyResult('fileSystemPath', 'FileSystemPath', cfn_parse.FromCloudFormation.getString(properties.FileSystemPath));
    ret.addPropertyResult('batchImportMetaDataOnCreate', 'BatchImportMetaDataOnCreate', properties.BatchImportMetaDataOnCreate != null ? cfn_parse.FromCloudFormation.getBoolean(properties.BatchImportMetaDataOnCreate) : undefined);
    ret.addPropertyResult('importedFileChunkSize', 'ImportedFileChunkSize', properties.ImportedFileChunkSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.ImportedFileChunkSize) : undefined);
    ret.addPropertyResult('s3', 'S3', properties.S3 != null ? CfnDataRepositoryAssociationS3PropertyFromCloudFormation(properties.S3) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FSx::DataRepositoryAssociation`
 *
 * The configuration of a data repository association that links an Amazon FSx for Lustre file system to an Amazon S3 bucket or an Amazon File Cache resource to an Amazon S3 bucket or an NFS file system. The data repository association configuration object is returned in the response of the following operations:
 *
 * - `CreateDataRepositoryAssociation`
 * - `UpdateDataRepositoryAssociation`
 * - `DescribeDataRepositoryAssociations`
 *
 * Data repository associations are supported only for an Amazon FSx for Lustre file system with the `Persistent_2` deployment type and for an Amazon File Cache resource.
 *
 * @cloudformationResource AWS::FSx::DataRepositoryAssociation
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-datarepositoryassociation.html
 */
class CfnDataRepositoryAssociation extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::DataRepositoryAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDataRepositoryAssociation.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_CfnDataRepositoryAssociationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDataRepositoryAssociation);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dataRepositoryPath', this);
        cdk.requireProperty(props, 'fileSystemId', this);
        cdk.requireProperty(props, 'fileSystemPath', this);
        this.attrAssociationId = cdk.Token.asString(this.getAtt('AssociationId'));
        this.attrResourceArn = cdk.Token.asString(this.getAtt('ResourceARN'));
        this.dataRepositoryPath = props.dataRepositoryPath;
        this.fileSystemId = props.fileSystemId;
        this.fileSystemPath = props.fileSystemPath;
        this.batchImportMetaDataOnCreate = props.batchImportMetaDataOnCreate;
        this.importedFileChunkSize = props.importedFileChunkSize;
        this.s3 = props.s3;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::DataRepositoryAssociation", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDataRepositoryAssociationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDataRepositoryAssociation(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDataRepositoryAssociation.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dataRepositoryPath: this.dataRepositoryPath,
            fileSystemId: this.fileSystemId,
            fileSystemPath: this.fileSystemPath,
            batchImportMetaDataOnCreate: this.batchImportMetaDataOnCreate,
            importedFileChunkSize: this.importedFileChunkSize,
            s3: this.s3,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDataRepositoryAssociationPropsToCloudFormation(props);
    }
}
exports.CfnDataRepositoryAssociation = CfnDataRepositoryAssociation;
_a = JSII_RTTI_SYMBOL_1;
CfnDataRepositoryAssociation[_a] = { fqn: "@aws-cdk/aws-fsx.CfnDataRepositoryAssociation", version: "1.183.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDataRepositoryAssociation.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::DataRepositoryAssociation";
/**
 * Determine whether the given properties match those of a `AutoExportPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `AutoExportPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataRepositoryAssociation_AutoExportPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('events', cdk.requiredValidator)(properties.events));
    errors.collect(cdk.propertyValidator('events', cdk.listValidator(cdk.validateString))(properties.events));
    return errors.wrap('supplied properties not correct for "AutoExportPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.AutoExportPolicy` resource
 *
 * @param properties - the TypeScript properties of a `AutoExportPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.AutoExportPolicy` resource.
 */
// @ts-ignore TS6133
function cfnDataRepositoryAssociationAutoExportPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataRepositoryAssociation_AutoExportPolicyPropertyValidator(properties).assertSuccess();
    return {
        Events: cdk.listMapper(cdk.stringToCloudFormation)(properties.events),
    };
}
// @ts-ignore TS6133
function CfnDataRepositoryAssociationAutoExportPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('events', 'Events', cfn_parse.FromCloudFormation.getStringArray(properties.Events));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AutoImportPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `AutoImportPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataRepositoryAssociation_AutoImportPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('events', cdk.requiredValidator)(properties.events));
    errors.collect(cdk.propertyValidator('events', cdk.listValidator(cdk.validateString))(properties.events));
    return errors.wrap('supplied properties not correct for "AutoImportPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.AutoImportPolicy` resource
 *
 * @param properties - the TypeScript properties of a `AutoImportPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.AutoImportPolicy` resource.
 */
// @ts-ignore TS6133
function cfnDataRepositoryAssociationAutoImportPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataRepositoryAssociation_AutoImportPolicyPropertyValidator(properties).assertSuccess();
    return {
        Events: cdk.listMapper(cdk.stringToCloudFormation)(properties.events),
    };
}
// @ts-ignore TS6133
function CfnDataRepositoryAssociationAutoImportPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('events', 'Events', cfn_parse.FromCloudFormation.getStringArray(properties.Events));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3Property`
 *
 * @param properties - the TypeScript properties of a `S3Property`
 *
 * @returns the result of the validation.
 */
function CfnDataRepositoryAssociation_S3PropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoExportPolicy', CfnDataRepositoryAssociation_AutoExportPolicyPropertyValidator)(properties.autoExportPolicy));
    errors.collect(cdk.propertyValidator('autoImportPolicy', CfnDataRepositoryAssociation_AutoImportPolicyPropertyValidator)(properties.autoImportPolicy));
    return errors.wrap('supplied properties not correct for "S3Property"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.S3` resource
 *
 * @param properties - the TypeScript properties of a `S3Property`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::DataRepositoryAssociation.S3` resource.
 */
// @ts-ignore TS6133
function cfnDataRepositoryAssociationS3PropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataRepositoryAssociation_S3PropertyValidator(properties).assertSuccess();
    return {
        AutoExportPolicy: cfnDataRepositoryAssociationAutoExportPolicyPropertyToCloudFormation(properties.autoExportPolicy),
        AutoImportPolicy: cfnDataRepositoryAssociationAutoImportPolicyPropertyToCloudFormation(properties.autoImportPolicy),
    };
}
// @ts-ignore TS6133
function CfnDataRepositoryAssociationS3PropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoExportPolicy', 'AutoExportPolicy', properties.AutoExportPolicy != null ? CfnDataRepositoryAssociationAutoExportPolicyPropertyFromCloudFormation(properties.AutoExportPolicy) : undefined);
    ret.addPropertyResult('autoImportPolicy', 'AutoImportPolicy', properties.AutoImportPolicy != null ? CfnDataRepositoryAssociationAutoImportPolicyPropertyFromCloudFormation(properties.AutoImportPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnFileSystemProps`
 *
 * @param properties - the TypeScript properties of a `CfnFileSystemProps`
 *
 * @returns the result of the validation.
 */
function CfnFileSystemPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('fileSystemType', cdk.requiredValidator)(properties.fileSystemType));
    errors.collect(cdk.propertyValidator('fileSystemType', cdk.validateString)(properties.fileSystemType));
    errors.collect(cdk.propertyValidator('fileSystemTypeVersion', cdk.validateString)(properties.fileSystemTypeVersion));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('lustreConfiguration', CfnFileSystem_LustreConfigurationPropertyValidator)(properties.lustreConfiguration));
    errors.collect(cdk.propertyValidator('ontapConfiguration', CfnFileSystem_OntapConfigurationPropertyValidator)(properties.ontapConfiguration));
    errors.collect(cdk.propertyValidator('openZfsConfiguration', CfnFileSystem_OpenZFSConfigurationPropertyValidator)(properties.openZfsConfiguration));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('storageCapacity', cdk.validateNumber)(properties.storageCapacity));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('windowsConfiguration', CfnFileSystem_WindowsConfigurationPropertyValidator)(properties.windowsConfiguration));
    return errors.wrap('supplied properties not correct for "CfnFileSystemProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem` resource
 *
 * @param properties - the TypeScript properties of a `CfnFileSystemProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystemPropsValidator(properties).assertSuccess();
    return {
        FileSystemType: cdk.stringToCloudFormation(properties.fileSystemType),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        FileSystemTypeVersion: cdk.stringToCloudFormation(properties.fileSystemTypeVersion),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LustreConfiguration: cfnFileSystemLustreConfigurationPropertyToCloudFormation(properties.lustreConfiguration),
        OntapConfiguration: cfnFileSystemOntapConfigurationPropertyToCloudFormation(properties.ontapConfiguration),
        OpenZFSConfiguration: cfnFileSystemOpenZFSConfigurationPropertyToCloudFormation(properties.openZfsConfiguration),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        StorageCapacity: cdk.numberToCloudFormation(properties.storageCapacity),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        WindowsConfiguration: cfnFileSystemWindowsConfigurationPropertyToCloudFormation(properties.windowsConfiguration),
    };
}
// @ts-ignore TS6133
function CfnFileSystemPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fileSystemType', 'FileSystemType', cfn_parse.FromCloudFormation.getString(properties.FileSystemType));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('backupId', 'BackupId', properties.BackupId != null ? cfn_parse.FromCloudFormation.getString(properties.BackupId) : undefined);
    ret.addPropertyResult('fileSystemTypeVersion', 'FileSystemTypeVersion', properties.FileSystemTypeVersion != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemTypeVersion) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('lustreConfiguration', 'LustreConfiguration', properties.LustreConfiguration != null ? CfnFileSystemLustreConfigurationPropertyFromCloudFormation(properties.LustreConfiguration) : undefined);
    ret.addPropertyResult('ontapConfiguration', 'OntapConfiguration', properties.OntapConfiguration != null ? CfnFileSystemOntapConfigurationPropertyFromCloudFormation(properties.OntapConfiguration) : undefined);
    ret.addPropertyResult('openZfsConfiguration', 'OpenZFSConfiguration', properties.OpenZFSConfiguration != null ? CfnFileSystemOpenZFSConfigurationPropertyFromCloudFormation(properties.OpenZFSConfiguration) : undefined);
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('storageCapacity', 'StorageCapacity', properties.StorageCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacity) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('windowsConfiguration', 'WindowsConfiguration', properties.WindowsConfiguration != null ? CfnFileSystemWindowsConfigurationPropertyFromCloudFormation(properties.WindowsConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`
 *
 * The `AWS::FSx::FileSystem` resource is an Amazon FSx resource type that specifies an Amazon FSx file system. You can create any of the following supported file system types:
 *
 * - Amazon FSx for Lustre
 * - Amazon FSx for NetApp ONTAP
 * - Amazon FSx for OpenZFS
 * - Amazon FSx for Windows File Server
 *
 * @cloudformationResource AWS::FSx::FileSystem
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
class CfnFileSystem extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::FileSystem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnFileSystem.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_CfnFileSystemProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnFileSystem);
            }
            throw error;
        }
        cdk.requireProperty(props, 'fileSystemType', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.attrDnsName = cdk.Token.asString(this.getAtt('DNSName'));
        this.attrLustreMountName = cdk.Token.asString(this.getAtt('LustreMountName'));
        this.attrRootVolumeId = cdk.Token.asString(this.getAtt('RootVolumeId'));
        this.fileSystemType = props.fileSystemType;
        this.subnetIds = props.subnetIds;
        this.backupId = props.backupId;
        this.fileSystemTypeVersion = props.fileSystemTypeVersion;
        this.kmsKeyId = props.kmsKeyId;
        this.lustreConfiguration = props.lustreConfiguration;
        this.ontapConfiguration = props.ontapConfiguration;
        this.openZfsConfiguration = props.openZfsConfiguration;
        this.securityGroupIds = props.securityGroupIds;
        this.storageCapacity = props.storageCapacity;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::FileSystem", props.tags, { tagPropertyName: 'tags' });
        this.windowsConfiguration = props.windowsConfiguration;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::FSx::FileSystem\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnFileSystemPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFileSystem(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFileSystem.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            fileSystemType: this.fileSystemType,
            subnetIds: this.subnetIds,
            backupId: this.backupId,
            fileSystemTypeVersion: this.fileSystemTypeVersion,
            kmsKeyId: this.kmsKeyId,
            lustreConfiguration: this.lustreConfiguration,
            ontapConfiguration: this.ontapConfiguration,
            openZfsConfiguration: this.openZfsConfiguration,
            securityGroupIds: this.securityGroupIds,
            storageCapacity: this.storageCapacity,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            windowsConfiguration: this.windowsConfiguration,
        };
    }
    renderProperties(props) {
        return cfnFileSystemPropsToCloudFormation(props);
    }
}
exports.CfnFileSystem = CfnFileSystem;
_b = JSII_RTTI_SYMBOL_1;
CfnFileSystem[_b] = { fqn: "@aws-cdk/aws-fsx.CfnFileSystem", version: "1.183.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFileSystem.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::FileSystem";
/**
 * Determine whether the given properties match those of a `AuditLogConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AuditLogConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_AuditLogConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('auditLogDestination', cdk.validateString)(properties.auditLogDestination));
    errors.collect(cdk.propertyValidator('fileAccessAuditLogLevel', cdk.requiredValidator)(properties.fileAccessAuditLogLevel));
    errors.collect(cdk.propertyValidator('fileAccessAuditLogLevel', cdk.validateString)(properties.fileAccessAuditLogLevel));
    errors.collect(cdk.propertyValidator('fileShareAccessAuditLogLevel', cdk.requiredValidator)(properties.fileShareAccessAuditLogLevel));
    errors.collect(cdk.propertyValidator('fileShareAccessAuditLogLevel', cdk.validateString)(properties.fileShareAccessAuditLogLevel));
    return errors.wrap('supplied properties not correct for "AuditLogConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.AuditLogConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AuditLogConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.AuditLogConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemAuditLogConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_AuditLogConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AuditLogDestination: cdk.stringToCloudFormation(properties.auditLogDestination),
        FileAccessAuditLogLevel: cdk.stringToCloudFormation(properties.fileAccessAuditLogLevel),
        FileShareAccessAuditLogLevel: cdk.stringToCloudFormation(properties.fileShareAccessAuditLogLevel),
    };
}
// @ts-ignore TS6133
function CfnFileSystemAuditLogConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('auditLogDestination', 'AuditLogDestination', properties.AuditLogDestination != null ? cfn_parse.FromCloudFormation.getString(properties.AuditLogDestination) : undefined);
    ret.addPropertyResult('fileAccessAuditLogLevel', 'FileAccessAuditLogLevel', cfn_parse.FromCloudFormation.getString(properties.FileAccessAuditLogLevel));
    ret.addPropertyResult('fileShareAccessAuditLogLevel', 'FileShareAccessAuditLogLevel', cfn_parse.FromCloudFormation.getString(properties.FileShareAccessAuditLogLevel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClientConfigurationsProperty`
 *
 * @param properties - the TypeScript properties of a `ClientConfigurationsProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_ClientConfigurationsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clients', cdk.validateString)(properties.clients));
    errors.collect(cdk.propertyValidator('options', cdk.listValidator(cdk.validateString))(properties.options));
    return errors.wrap('supplied properties not correct for "ClientConfigurationsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.ClientConfigurations` resource
 *
 * @param properties - the TypeScript properties of a `ClientConfigurationsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.ClientConfigurations` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemClientConfigurationsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_ClientConfigurationsPropertyValidator(properties).assertSuccess();
    return {
        Clients: cdk.stringToCloudFormation(properties.clients),
        Options: cdk.listMapper(cdk.stringToCloudFormation)(properties.options),
    };
}
// @ts-ignore TS6133
function CfnFileSystemClientConfigurationsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clients', 'Clients', properties.Clients != null ? cfn_parse.FromCloudFormation.getString(properties.Clients) : undefined);
    ret.addPropertyResult('options', 'Options', properties.Options != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Options) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DiskIopsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DiskIopsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_DiskIopsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    return errors.wrap('supplied properties not correct for "DiskIopsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.DiskIopsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DiskIopsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.DiskIopsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemDiskIopsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_DiskIopsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Iops: cdk.numberToCloudFormation(properties.iops),
        Mode: cdk.stringToCloudFormation(properties.mode),
    };
}
// @ts-ignore TS6133
function CfnFileSystemDiskIopsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('mode', 'Mode', properties.Mode != null ? cfn_parse.FromCloudFormation.getString(properties.Mode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LustreConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LustreConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_LustreConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoImportPolicy', cdk.validateString)(properties.autoImportPolicy));
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('copyTagsToBackups', cdk.validateBoolean)(properties.copyTagsToBackups));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('dataCompressionType', cdk.validateString)(properties.dataCompressionType));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('driveCacheType', cdk.validateString)(properties.driveCacheType));
    errors.collect(cdk.propertyValidator('exportPath', cdk.validateString)(properties.exportPath));
    errors.collect(cdk.propertyValidator('importPath', cdk.validateString)(properties.importPath));
    errors.collect(cdk.propertyValidator('importedFileChunkSize', cdk.validateNumber)(properties.importedFileChunkSize));
    errors.collect(cdk.propertyValidator('perUnitStorageThroughput', cdk.validateNumber)(properties.perUnitStorageThroughput));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "LustreConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.LustreConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LustreConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.LustreConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemLustreConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_LustreConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutoImportPolicy: cdk.stringToCloudFormation(properties.autoImportPolicy),
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        CopyTagsToBackups: cdk.booleanToCloudFormation(properties.copyTagsToBackups),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DataCompressionType: cdk.stringToCloudFormation(properties.dataCompressionType),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        DriveCacheType: cdk.stringToCloudFormation(properties.driveCacheType),
        ExportPath: cdk.stringToCloudFormation(properties.exportPath),
        ImportPath: cdk.stringToCloudFormation(properties.importPath),
        ImportedFileChunkSize: cdk.numberToCloudFormation(properties.importedFileChunkSize),
        PerUnitStorageThroughput: cdk.numberToCloudFormation(properties.perUnitStorageThroughput),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemLustreConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoImportPolicy', 'AutoImportPolicy', properties.AutoImportPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.AutoImportPolicy) : undefined);
    ret.addPropertyResult('automaticBackupRetentionDays', 'AutomaticBackupRetentionDays', properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined);
    ret.addPropertyResult('copyTagsToBackups', 'CopyTagsToBackups', properties.CopyTagsToBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToBackups) : undefined);
    ret.addPropertyResult('dailyAutomaticBackupStartTime', 'DailyAutomaticBackupStartTime', properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined);
    ret.addPropertyResult('dataCompressionType', 'DataCompressionType', properties.DataCompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.DataCompressionType) : undefined);
    ret.addPropertyResult('deploymentType', 'DeploymentType', properties.DeploymentType != null ? cfn_parse.FromCloudFormation.getString(properties.DeploymentType) : undefined);
    ret.addPropertyResult('driveCacheType', 'DriveCacheType', properties.DriveCacheType != null ? cfn_parse.FromCloudFormation.getString(properties.DriveCacheType) : undefined);
    ret.addPropertyResult('exportPath', 'ExportPath', properties.ExportPath != null ? cfn_parse.FromCloudFormation.getString(properties.ExportPath) : undefined);
    ret.addPropertyResult('importPath', 'ImportPath', properties.ImportPath != null ? cfn_parse.FromCloudFormation.getString(properties.ImportPath) : undefined);
    ret.addPropertyResult('importedFileChunkSize', 'ImportedFileChunkSize', properties.ImportedFileChunkSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.ImportedFileChunkSize) : undefined);
    ret.addPropertyResult('perUnitStorageThroughput', 'PerUnitStorageThroughput', properties.PerUnitStorageThroughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerUnitStorageThroughput) : undefined);
    ret.addPropertyResult('weeklyMaintenanceStartTime', 'WeeklyMaintenanceStartTime', properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NfsExportsProperty`
 *
 * @param properties - the TypeScript properties of a `NfsExportsProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_NfsExportsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientConfigurations', cdk.listValidator(CfnFileSystem_ClientConfigurationsPropertyValidator))(properties.clientConfigurations));
    return errors.wrap('supplied properties not correct for "NfsExportsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.NfsExports` resource
 *
 * @param properties - the TypeScript properties of a `NfsExportsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.NfsExports` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemNfsExportsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_NfsExportsPropertyValidator(properties).assertSuccess();
    return {
        ClientConfigurations: cdk.listMapper(cfnFileSystemClientConfigurationsPropertyToCloudFormation)(properties.clientConfigurations),
    };
}
// @ts-ignore TS6133
function CfnFileSystemNfsExportsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientConfigurations', 'ClientConfigurations', properties.ClientConfigurations != null ? cfn_parse.FromCloudFormation.getArray(CfnFileSystemClientConfigurationsPropertyFromCloudFormation)(properties.ClientConfigurations) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OntapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OntapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_OntapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.requiredValidator)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('diskIopsConfiguration', CfnFileSystem_DiskIopsConfigurationPropertyValidator)(properties.diskIopsConfiguration));
    errors.collect(cdk.propertyValidator('endpointIpAddressRange', cdk.validateString)(properties.endpointIpAddressRange));
    errors.collect(cdk.propertyValidator('fsxAdminPassword', cdk.validateString)(properties.fsxAdminPassword));
    errors.collect(cdk.propertyValidator('preferredSubnetId', cdk.validateString)(properties.preferredSubnetId));
    errors.collect(cdk.propertyValidator('routeTableIds', cdk.listValidator(cdk.validateString))(properties.routeTableIds));
    errors.collect(cdk.propertyValidator('throughputCapacity', cdk.validateNumber)(properties.throughputCapacity));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "OntapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.OntapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OntapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.OntapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemOntapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_OntapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        DiskIopsConfiguration: cfnFileSystemDiskIopsConfigurationPropertyToCloudFormation(properties.diskIopsConfiguration),
        EndpointIpAddressRange: cdk.stringToCloudFormation(properties.endpointIpAddressRange),
        FsxAdminPassword: cdk.stringToCloudFormation(properties.fsxAdminPassword),
        PreferredSubnetId: cdk.stringToCloudFormation(properties.preferredSubnetId),
        RouteTableIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.routeTableIds),
        ThroughputCapacity: cdk.numberToCloudFormation(properties.throughputCapacity),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemOntapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('automaticBackupRetentionDays', 'AutomaticBackupRetentionDays', properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined);
    ret.addPropertyResult('dailyAutomaticBackupStartTime', 'DailyAutomaticBackupStartTime', properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined);
    ret.addPropertyResult('deploymentType', 'DeploymentType', cfn_parse.FromCloudFormation.getString(properties.DeploymentType));
    ret.addPropertyResult('diskIopsConfiguration', 'DiskIopsConfiguration', properties.DiskIopsConfiguration != null ? CfnFileSystemDiskIopsConfigurationPropertyFromCloudFormation(properties.DiskIopsConfiguration) : undefined);
    ret.addPropertyResult('endpointIpAddressRange', 'EndpointIpAddressRange', properties.EndpointIpAddressRange != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointIpAddressRange) : undefined);
    ret.addPropertyResult('fsxAdminPassword', 'FsxAdminPassword', properties.FsxAdminPassword != null ? cfn_parse.FromCloudFormation.getString(properties.FsxAdminPassword) : undefined);
    ret.addPropertyResult('preferredSubnetId', 'PreferredSubnetId', properties.PreferredSubnetId != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredSubnetId) : undefined);
    ret.addPropertyResult('routeTableIds', 'RouteTableIds', properties.RouteTableIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.RouteTableIds) : undefined);
    ret.addPropertyResult('throughputCapacity', 'ThroughputCapacity', properties.ThroughputCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.ThroughputCapacity) : undefined);
    ret.addPropertyResult('weeklyMaintenanceStartTime', 'WeeklyMaintenanceStartTime', properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OpenZFSConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OpenZFSConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_OpenZFSConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('copyTagsToBackups', cdk.validateBoolean)(properties.copyTagsToBackups));
    errors.collect(cdk.propertyValidator('copyTagsToVolumes', cdk.validateBoolean)(properties.copyTagsToVolumes));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.requiredValidator)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('diskIopsConfiguration', CfnFileSystem_DiskIopsConfigurationPropertyValidator)(properties.diskIopsConfiguration));
    errors.collect(cdk.propertyValidator('options', cdk.listValidator(cdk.validateString))(properties.options));
    errors.collect(cdk.propertyValidator('rootVolumeConfiguration', CfnFileSystem_RootVolumeConfigurationPropertyValidator)(properties.rootVolumeConfiguration));
    errors.collect(cdk.propertyValidator('throughputCapacity', cdk.validateNumber)(properties.throughputCapacity));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "OpenZFSConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.OpenZFSConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OpenZFSConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.OpenZFSConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemOpenZFSConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_OpenZFSConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        CopyTagsToBackups: cdk.booleanToCloudFormation(properties.copyTagsToBackups),
        CopyTagsToVolumes: cdk.booleanToCloudFormation(properties.copyTagsToVolumes),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        DiskIopsConfiguration: cfnFileSystemDiskIopsConfigurationPropertyToCloudFormation(properties.diskIopsConfiguration),
        Options: cdk.listMapper(cdk.stringToCloudFormation)(properties.options),
        RootVolumeConfiguration: cfnFileSystemRootVolumeConfigurationPropertyToCloudFormation(properties.rootVolumeConfiguration),
        ThroughputCapacity: cdk.numberToCloudFormation(properties.throughputCapacity),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemOpenZFSConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('automaticBackupRetentionDays', 'AutomaticBackupRetentionDays', properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined);
    ret.addPropertyResult('copyTagsToBackups', 'CopyTagsToBackups', properties.CopyTagsToBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToBackups) : undefined);
    ret.addPropertyResult('copyTagsToVolumes', 'CopyTagsToVolumes', properties.CopyTagsToVolumes != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToVolumes) : undefined);
    ret.addPropertyResult('dailyAutomaticBackupStartTime', 'DailyAutomaticBackupStartTime', properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined);
    ret.addPropertyResult('deploymentType', 'DeploymentType', cfn_parse.FromCloudFormation.getString(properties.DeploymentType));
    ret.addPropertyResult('diskIopsConfiguration', 'DiskIopsConfiguration', properties.DiskIopsConfiguration != null ? CfnFileSystemDiskIopsConfigurationPropertyFromCloudFormation(properties.DiskIopsConfiguration) : undefined);
    ret.addPropertyResult('options', 'Options', properties.Options != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Options) : undefined);
    ret.addPropertyResult('rootVolumeConfiguration', 'RootVolumeConfiguration', properties.RootVolumeConfiguration != null ? CfnFileSystemRootVolumeConfigurationPropertyFromCloudFormation(properties.RootVolumeConfiguration) : undefined);
    ret.addPropertyResult('throughputCapacity', 'ThroughputCapacity', properties.ThroughputCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.ThroughputCapacity) : undefined);
    ret.addPropertyResult('weeklyMaintenanceStartTime', 'WeeklyMaintenanceStartTime', properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RootVolumeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `RootVolumeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_RootVolumeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('copyTagsToSnapshots', cdk.validateBoolean)(properties.copyTagsToSnapshots));
    errors.collect(cdk.propertyValidator('dataCompressionType', cdk.validateString)(properties.dataCompressionType));
    errors.collect(cdk.propertyValidator('nfsExports', cdk.listValidator(CfnFileSystem_NfsExportsPropertyValidator))(properties.nfsExports));
    errors.collect(cdk.propertyValidator('readOnly', cdk.validateBoolean)(properties.readOnly));
    errors.collect(cdk.propertyValidator('recordSizeKiB', cdk.validateNumber)(properties.recordSizeKiB));
    errors.collect(cdk.propertyValidator('userAndGroupQuotas', cdk.listValidator(CfnFileSystem_UserAndGroupQuotasPropertyValidator))(properties.userAndGroupQuotas));
    return errors.wrap('supplied properties not correct for "RootVolumeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.RootVolumeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `RootVolumeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.RootVolumeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemRootVolumeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_RootVolumeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CopyTagsToSnapshots: cdk.booleanToCloudFormation(properties.copyTagsToSnapshots),
        DataCompressionType: cdk.stringToCloudFormation(properties.dataCompressionType),
        NfsExports: cdk.listMapper(cfnFileSystemNfsExportsPropertyToCloudFormation)(properties.nfsExports),
        ReadOnly: cdk.booleanToCloudFormation(properties.readOnly),
        RecordSizeKiB: cdk.numberToCloudFormation(properties.recordSizeKiB),
        UserAndGroupQuotas: cdk.listMapper(cfnFileSystemUserAndGroupQuotasPropertyToCloudFormation)(properties.userAndGroupQuotas),
    };
}
// @ts-ignore TS6133
function CfnFileSystemRootVolumeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('copyTagsToSnapshots', 'CopyTagsToSnapshots', properties.CopyTagsToSnapshots != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshots) : undefined);
    ret.addPropertyResult('dataCompressionType', 'DataCompressionType', properties.DataCompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.DataCompressionType) : undefined);
    ret.addPropertyResult('nfsExports', 'NfsExports', properties.NfsExports != null ? cfn_parse.FromCloudFormation.getArray(CfnFileSystemNfsExportsPropertyFromCloudFormation)(properties.NfsExports) : undefined);
    ret.addPropertyResult('readOnly', 'ReadOnly', properties.ReadOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadOnly) : undefined);
    ret.addPropertyResult('recordSizeKiB', 'RecordSizeKiB', properties.RecordSizeKiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.RecordSizeKiB) : undefined);
    ret.addPropertyResult('userAndGroupQuotas', 'UserAndGroupQuotas', properties.UserAndGroupQuotas != null ? cfn_parse.FromCloudFormation.getArray(CfnFileSystemUserAndGroupQuotasPropertyFromCloudFormation)(properties.UserAndGroupQuotas) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsIps', cdk.listValidator(cdk.validateString))(properties.dnsIps));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('fileSystemAdministratorsGroup', cdk.validateString)(properties.fileSystemAdministratorsGroup));
    errors.collect(cdk.propertyValidator('organizationalUnitDistinguishedName', cdk.validateString)(properties.organizationalUnitDistinguishedName));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('userName', cdk.validateString)(properties.userName));
    return errors.wrap('supplied properties not correct for "SelfManagedActiveDirectoryConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.SelfManagedActiveDirectoryConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.SelfManagedActiveDirectoryConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DnsIps: cdk.listMapper(cdk.stringToCloudFormation)(properties.dnsIps),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        FileSystemAdministratorsGroup: cdk.stringToCloudFormation(properties.fileSystemAdministratorsGroup),
        OrganizationalUnitDistinguishedName: cdk.stringToCloudFormation(properties.organizationalUnitDistinguishedName),
        Password: cdk.stringToCloudFormation(properties.password),
        UserName: cdk.stringToCloudFormation(properties.userName),
    };
}
// @ts-ignore TS6133
function CfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsIps', 'DnsIps', properties.DnsIps != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DnsIps) : undefined);
    ret.addPropertyResult('domainName', 'DomainName', properties.DomainName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainName) : undefined);
    ret.addPropertyResult('fileSystemAdministratorsGroup', 'FileSystemAdministratorsGroup', properties.FileSystemAdministratorsGroup != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemAdministratorsGroup) : undefined);
    ret.addPropertyResult('organizationalUnitDistinguishedName', 'OrganizationalUnitDistinguishedName', properties.OrganizationalUnitDistinguishedName != null ? cfn_parse.FromCloudFormation.getString(properties.OrganizationalUnitDistinguishedName) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('userName', 'UserName', properties.UserName != null ? cfn_parse.FromCloudFormation.getString(properties.UserName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserAndGroupQuotasProperty`
 *
 * @param properties - the TypeScript properties of a `UserAndGroupQuotasProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_UserAndGroupQuotasPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('id', cdk.validateNumber)(properties.id));
    errors.collect(cdk.propertyValidator('storageCapacityQuotaGiB', cdk.validateNumber)(properties.storageCapacityQuotaGiB));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "UserAndGroupQuotasProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.UserAndGroupQuotas` resource
 *
 * @param properties - the TypeScript properties of a `UserAndGroupQuotasProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.UserAndGroupQuotas` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemUserAndGroupQuotasPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_UserAndGroupQuotasPropertyValidator(properties).assertSuccess();
    return {
        Id: cdk.numberToCloudFormation(properties.id),
        StorageCapacityQuotaGiB: cdk.numberToCloudFormation(properties.storageCapacityQuotaGiB),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnFileSystemUserAndGroupQuotasPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', properties.Id != null ? cfn_parse.FromCloudFormation.getNumber(properties.Id) : undefined);
    ret.addPropertyResult('storageCapacityQuotaGiB', 'StorageCapacityQuotaGiB', properties.StorageCapacityQuotaGiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacityQuotaGiB) : undefined);
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `WindowsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `WindowsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_WindowsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('activeDirectoryId', cdk.validateString)(properties.activeDirectoryId));
    errors.collect(cdk.propertyValidator('aliases', cdk.listValidator(cdk.validateString))(properties.aliases));
    errors.collect(cdk.propertyValidator('auditLogConfiguration', CfnFileSystem_AuditLogConfigurationPropertyValidator)(properties.auditLogConfiguration));
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('copyTagsToBackups', cdk.validateBoolean)(properties.copyTagsToBackups));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('preferredSubnetId', cdk.validateString)(properties.preferredSubnetId));
    errors.collect(cdk.propertyValidator('selfManagedActiveDirectoryConfiguration', CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator)(properties.selfManagedActiveDirectoryConfiguration));
    errors.collect(cdk.propertyValidator('throughputCapacity', cdk.requiredValidator)(properties.throughputCapacity));
    errors.collect(cdk.propertyValidator('throughputCapacity', cdk.validateNumber)(properties.throughputCapacity));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "WindowsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.WindowsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `WindowsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.WindowsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemWindowsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_WindowsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ActiveDirectoryId: cdk.stringToCloudFormation(properties.activeDirectoryId),
        Aliases: cdk.listMapper(cdk.stringToCloudFormation)(properties.aliases),
        AuditLogConfiguration: cfnFileSystemAuditLogConfigurationPropertyToCloudFormation(properties.auditLogConfiguration),
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        CopyTagsToBackups: cdk.booleanToCloudFormation(properties.copyTagsToBackups),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        PreferredSubnetId: cdk.stringToCloudFormation(properties.preferredSubnetId),
        SelfManagedActiveDirectoryConfiguration: cfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties.selfManagedActiveDirectoryConfiguration),
        ThroughputCapacity: cdk.numberToCloudFormation(properties.throughputCapacity),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemWindowsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('activeDirectoryId', 'ActiveDirectoryId', properties.ActiveDirectoryId != null ? cfn_parse.FromCloudFormation.getString(properties.ActiveDirectoryId) : undefined);
    ret.addPropertyResult('aliases', 'Aliases', properties.Aliases != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Aliases) : undefined);
    ret.addPropertyResult('auditLogConfiguration', 'AuditLogConfiguration', properties.AuditLogConfiguration != null ? CfnFileSystemAuditLogConfigurationPropertyFromCloudFormation(properties.AuditLogConfiguration) : undefined);
    ret.addPropertyResult('automaticBackupRetentionDays', 'AutomaticBackupRetentionDays', properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined);
    ret.addPropertyResult('copyTagsToBackups', 'CopyTagsToBackups', properties.CopyTagsToBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToBackups) : undefined);
    ret.addPropertyResult('dailyAutomaticBackupStartTime', 'DailyAutomaticBackupStartTime', properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined);
    ret.addPropertyResult('deploymentType', 'DeploymentType', properties.DeploymentType != null ? cfn_parse.FromCloudFormation.getString(properties.DeploymentType) : undefined);
    ret.addPropertyResult('preferredSubnetId', 'PreferredSubnetId', properties.PreferredSubnetId != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredSubnetId) : undefined);
    ret.addPropertyResult('selfManagedActiveDirectoryConfiguration', 'SelfManagedActiveDirectoryConfiguration', properties.SelfManagedActiveDirectoryConfiguration != null ? CfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties.SelfManagedActiveDirectoryConfiguration) : undefined);
    ret.addPropertyResult('throughputCapacity', 'ThroughputCapacity', cfn_parse.FromCloudFormation.getNumber(properties.ThroughputCapacity));
    ret.addPropertyResult('weeklyMaintenanceStartTime', 'WeeklyMaintenanceStartTime', properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnSnapshotProps`
 *
 * @param properties - the TypeScript properties of a `CfnSnapshotProps`
 *
 * @returns the result of the validation.
 */
function CfnSnapshotPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('volumeId', cdk.requiredValidator)(properties.volumeId));
    errors.collect(cdk.propertyValidator('volumeId', cdk.validateString)(properties.volumeId));
    return errors.wrap('supplied properties not correct for "CfnSnapshotProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Snapshot` resource
 *
 * @param properties - the TypeScript properties of a `CfnSnapshotProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Snapshot` resource.
 */
// @ts-ignore TS6133
function cfnSnapshotPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnSnapshotPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        VolumeId: cdk.stringToCloudFormation(properties.volumeId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnSnapshotPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('volumeId', 'VolumeId', cfn_parse.FromCloudFormation.getString(properties.VolumeId));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FSx::Snapshot`
 *
 * A snapshot of an Amazon FSx for OpenZFS volume.
 *
 * @cloudformationResource AWS::FSx::Snapshot
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-snapshot.html
 */
class CfnSnapshot extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::Snapshot`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSnapshot.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_CfnSnapshotProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnSnapshot);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'volumeId', this);
        this.attrResourceArn = cdk.Token.asString(this.getAtt('ResourceARN'));
        this.name = props.name;
        this.volumeId = props.volumeId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::Snapshot", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnSnapshotPropsFromCloudFormation(resourceProperties);
        const ret = new CfnSnapshot(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnSnapshot.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            volumeId: this.volumeId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnSnapshotPropsToCloudFormation(props);
    }
}
exports.CfnSnapshot = CfnSnapshot;
_c = JSII_RTTI_SYMBOL_1;
CfnSnapshot[_c] = { fqn: "@aws-cdk/aws-fsx.CfnSnapshot", version: "1.183.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnSnapshot.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::Snapshot";
/**
 * Determine whether the given properties match those of a `CfnStorageVirtualMachineProps`
 *
 * @param properties - the TypeScript properties of a `CfnStorageVirtualMachineProps`
 *
 * @returns the result of the validation.
 */
function CfnStorageVirtualMachinePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('activeDirectoryConfiguration', CfnStorageVirtualMachine_ActiveDirectoryConfigurationPropertyValidator)(properties.activeDirectoryConfiguration));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.requiredValidator)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.validateString)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('rootVolumeSecurityStyle', cdk.validateString)(properties.rootVolumeSecurityStyle));
    errors.collect(cdk.propertyValidator('svmAdminPassword', cdk.validateString)(properties.svmAdminPassword));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnStorageVirtualMachineProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine` resource
 *
 * @param properties - the TypeScript properties of a `CfnStorageVirtualMachineProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine` resource.
 */
// @ts-ignore TS6133
function cfnStorageVirtualMachinePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStorageVirtualMachinePropsValidator(properties).assertSuccess();
    return {
        FileSystemId: cdk.stringToCloudFormation(properties.fileSystemId),
        Name: cdk.stringToCloudFormation(properties.name),
        ActiveDirectoryConfiguration: cfnStorageVirtualMachineActiveDirectoryConfigurationPropertyToCloudFormation(properties.activeDirectoryConfiguration),
        RootVolumeSecurityStyle: cdk.stringToCloudFormation(properties.rootVolumeSecurityStyle),
        SvmAdminPassword: cdk.stringToCloudFormation(properties.svmAdminPassword),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnStorageVirtualMachinePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fileSystemId', 'FileSystemId', cfn_parse.FromCloudFormation.getString(properties.FileSystemId));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('activeDirectoryConfiguration', 'ActiveDirectoryConfiguration', properties.ActiveDirectoryConfiguration != null ? CfnStorageVirtualMachineActiveDirectoryConfigurationPropertyFromCloudFormation(properties.ActiveDirectoryConfiguration) : undefined);
    ret.addPropertyResult('rootVolumeSecurityStyle', 'RootVolumeSecurityStyle', properties.RootVolumeSecurityStyle != null ? cfn_parse.FromCloudFormation.getString(properties.RootVolumeSecurityStyle) : undefined);
    ret.addPropertyResult('svmAdminPassword', 'SvmAdminPassword', properties.SvmAdminPassword != null ? cfn_parse.FromCloudFormation.getString(properties.SvmAdminPassword) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FSx::StorageVirtualMachine`
 *
 * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
 *
 * @cloudformationResource AWS::FSx::StorageVirtualMachine
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html
 */
class CfnStorageVirtualMachine extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::StorageVirtualMachine`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnStorageVirtualMachine.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_CfnStorageVirtualMachineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnStorageVirtualMachine);
            }
            throw error;
        }
        cdk.requireProperty(props, 'fileSystemId', this);
        cdk.requireProperty(props, 'name', this);
        this.attrResourceArn = cdk.Token.asString(this.getAtt('ResourceARN'));
        this.attrStorageVirtualMachineId = cdk.Token.asString(this.getAtt('StorageVirtualMachineId'));
        this.attrUuid = cdk.Token.asString(this.getAtt('UUID'));
        this.fileSystemId = props.fileSystemId;
        this.name = props.name;
        this.activeDirectoryConfiguration = props.activeDirectoryConfiguration;
        this.rootVolumeSecurityStyle = props.rootVolumeSecurityStyle;
        this.svmAdminPassword = props.svmAdminPassword;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::StorageVirtualMachine", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnStorageVirtualMachinePropsFromCloudFormation(resourceProperties);
        const ret = new CfnStorageVirtualMachine(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnStorageVirtualMachine.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            fileSystemId: this.fileSystemId,
            name: this.name,
            activeDirectoryConfiguration: this.activeDirectoryConfiguration,
            rootVolumeSecurityStyle: this.rootVolumeSecurityStyle,
            svmAdminPassword: this.svmAdminPassword,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnStorageVirtualMachinePropsToCloudFormation(props);
    }
}
exports.CfnStorageVirtualMachine = CfnStorageVirtualMachine;
_d = JSII_RTTI_SYMBOL_1;
CfnStorageVirtualMachine[_d] = { fqn: "@aws-cdk/aws-fsx.CfnStorageVirtualMachine", version: "1.183.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnStorageVirtualMachine.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::StorageVirtualMachine";
/**
 * Determine whether the given properties match those of a `ActiveDirectoryConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ActiveDirectoryConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnStorageVirtualMachine_ActiveDirectoryConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('netBiosName', cdk.validateString)(properties.netBiosName));
    errors.collect(cdk.propertyValidator('selfManagedActiveDirectoryConfiguration', CfnStorageVirtualMachine_SelfManagedActiveDirectoryConfigurationPropertyValidator)(properties.selfManagedActiveDirectoryConfiguration));
    return errors.wrap('supplied properties not correct for "ActiveDirectoryConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine.ActiveDirectoryConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ActiveDirectoryConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine.ActiveDirectoryConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnStorageVirtualMachineActiveDirectoryConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStorageVirtualMachine_ActiveDirectoryConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NetBiosName: cdk.stringToCloudFormation(properties.netBiosName),
        SelfManagedActiveDirectoryConfiguration: cfnStorageVirtualMachineSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties.selfManagedActiveDirectoryConfiguration),
    };
}
// @ts-ignore TS6133
function CfnStorageVirtualMachineActiveDirectoryConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('netBiosName', 'NetBiosName', properties.NetBiosName != null ? cfn_parse.FromCloudFormation.getString(properties.NetBiosName) : undefined);
    ret.addPropertyResult('selfManagedActiveDirectoryConfiguration', 'SelfManagedActiveDirectoryConfiguration', properties.SelfManagedActiveDirectoryConfiguration != null ? CfnStorageVirtualMachineSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties.SelfManagedActiveDirectoryConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnStorageVirtualMachine_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dnsIps', cdk.listValidator(cdk.validateString))(properties.dnsIps));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('fileSystemAdministratorsGroup', cdk.validateString)(properties.fileSystemAdministratorsGroup));
    errors.collect(cdk.propertyValidator('organizationalUnitDistinguishedName', cdk.validateString)(properties.organizationalUnitDistinguishedName));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('userName', cdk.validateString)(properties.userName));
    return errors.wrap('supplied properties not correct for "SelfManagedActiveDirectoryConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine.SelfManagedActiveDirectoryConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::StorageVirtualMachine.SelfManagedActiveDirectoryConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnStorageVirtualMachineSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnStorageVirtualMachine_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DnsIps: cdk.listMapper(cdk.stringToCloudFormation)(properties.dnsIps),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        FileSystemAdministratorsGroup: cdk.stringToCloudFormation(properties.fileSystemAdministratorsGroup),
        OrganizationalUnitDistinguishedName: cdk.stringToCloudFormation(properties.organizationalUnitDistinguishedName),
        Password: cdk.stringToCloudFormation(properties.password),
        UserName: cdk.stringToCloudFormation(properties.userName),
    };
}
// @ts-ignore TS6133
function CfnStorageVirtualMachineSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dnsIps', 'DnsIps', properties.DnsIps != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DnsIps) : undefined);
    ret.addPropertyResult('domainName', 'DomainName', properties.DomainName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainName) : undefined);
    ret.addPropertyResult('fileSystemAdministratorsGroup', 'FileSystemAdministratorsGroup', properties.FileSystemAdministratorsGroup != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemAdministratorsGroup) : undefined);
    ret.addPropertyResult('organizationalUnitDistinguishedName', 'OrganizationalUnitDistinguishedName', properties.OrganizationalUnitDistinguishedName != null ? cfn_parse.FromCloudFormation.getString(properties.OrganizationalUnitDistinguishedName) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('userName', 'UserName', properties.UserName != null ? cfn_parse.FromCloudFormation.getString(properties.UserName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnVolumeProps`
 *
 * @param properties - the TypeScript properties of a `CfnVolumeProps`
 *
 * @returns the result of the validation.
 */
function CfnVolumePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('ontapConfiguration', CfnVolume_OntapConfigurationPropertyValidator)(properties.ontapConfiguration));
    errors.collect(cdk.propertyValidator('openZfsConfiguration', CfnVolume_OpenZFSConfigurationPropertyValidator)(properties.openZfsConfiguration));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('volumeType', cdk.validateString)(properties.volumeType));
    return errors.wrap('supplied properties not correct for "CfnVolumeProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume` resource
 *
 * @param properties - the TypeScript properties of a `CfnVolumeProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume` resource.
 */
// @ts-ignore TS6133
function cfnVolumePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolumePropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        OntapConfiguration: cfnVolumeOntapConfigurationPropertyToCloudFormation(properties.ontapConfiguration),
        OpenZFSConfiguration: cfnVolumeOpenZFSConfigurationPropertyToCloudFormation(properties.openZfsConfiguration),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VolumeType: cdk.stringToCloudFormation(properties.volumeType),
    };
}
// @ts-ignore TS6133
function CfnVolumePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('backupId', 'BackupId', properties.BackupId != null ? cfn_parse.FromCloudFormation.getString(properties.BackupId) : undefined);
    ret.addPropertyResult('ontapConfiguration', 'OntapConfiguration', properties.OntapConfiguration != null ? CfnVolumeOntapConfigurationPropertyFromCloudFormation(properties.OntapConfiguration) : undefined);
    ret.addPropertyResult('openZfsConfiguration', 'OpenZFSConfiguration', properties.OpenZFSConfiguration != null ? CfnVolumeOpenZFSConfigurationPropertyFromCloudFormation(properties.OpenZFSConfiguration) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('volumeType', 'VolumeType', properties.VolumeType != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FSx::Volume`
 *
 * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
 *
 * @cloudformationResource AWS::FSx::Volume
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html
 */
class CfnVolume extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::Volume`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnVolume.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_CfnVolumeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnVolume);
            }
            throw error;
        }
        cdk.requireProperty(props, 'name', this);
        this.attrResourceArn = cdk.Token.asString(this.getAtt('ResourceARN'));
        this.attrUuid = cdk.Token.asString(this.getAtt('UUID'));
        this.attrVolumeId = cdk.Token.asString(this.getAtt('VolumeId'));
        this.name = props.name;
        this.backupId = props.backupId;
        this.ontapConfiguration = props.ontapConfiguration;
        this.openZfsConfiguration = props.openZfsConfiguration;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::Volume", props.tags, { tagPropertyName: 'tags' });
        this.volumeType = props.volumeType;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnVolumePropsFromCloudFormation(resourceProperties);
        const ret = new CfnVolume(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnVolume.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            backupId: this.backupId,
            ontapConfiguration: this.ontapConfiguration,
            openZfsConfiguration: this.openZfsConfiguration,
            tags: this.tags.renderTags(),
            volumeType: this.volumeType,
        };
    }
    renderProperties(props) {
        return cfnVolumePropsToCloudFormation(props);
    }
}
exports.CfnVolume = CfnVolume;
_e = JSII_RTTI_SYMBOL_1;
CfnVolume[_e] = { fqn: "@aws-cdk/aws-fsx.CfnVolume", version: "1.183.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnVolume.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::Volume";
/**
 * Determine whether the given properties match those of a `ClientConfigurationsProperty`
 *
 * @param properties - the TypeScript properties of a `ClientConfigurationsProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_ClientConfigurationsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clients', cdk.requiredValidator)(properties.clients));
    errors.collect(cdk.propertyValidator('clients', cdk.validateString)(properties.clients));
    errors.collect(cdk.propertyValidator('options', cdk.requiredValidator)(properties.options));
    errors.collect(cdk.propertyValidator('options', cdk.listValidator(cdk.validateString))(properties.options));
    return errors.wrap('supplied properties not correct for "ClientConfigurationsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.ClientConfigurations` resource
 *
 * @param properties - the TypeScript properties of a `ClientConfigurationsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.ClientConfigurations` resource.
 */
// @ts-ignore TS6133
function cfnVolumeClientConfigurationsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_ClientConfigurationsPropertyValidator(properties).assertSuccess();
    return {
        Clients: cdk.stringToCloudFormation(properties.clients),
        Options: cdk.listMapper(cdk.stringToCloudFormation)(properties.options),
    };
}
// @ts-ignore TS6133
function CfnVolumeClientConfigurationsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clients', 'Clients', cfn_parse.FromCloudFormation.getString(properties.Clients));
    ret.addPropertyResult('options', 'Options', cfn_parse.FromCloudFormation.getStringArray(properties.Options));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NfsExportsProperty`
 *
 * @param properties - the TypeScript properties of a `NfsExportsProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_NfsExportsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientConfigurations', cdk.requiredValidator)(properties.clientConfigurations));
    errors.collect(cdk.propertyValidator('clientConfigurations', cdk.listValidator(CfnVolume_ClientConfigurationsPropertyValidator))(properties.clientConfigurations));
    return errors.wrap('supplied properties not correct for "NfsExportsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.NfsExports` resource
 *
 * @param properties - the TypeScript properties of a `NfsExportsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.NfsExports` resource.
 */
// @ts-ignore TS6133
function cfnVolumeNfsExportsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_NfsExportsPropertyValidator(properties).assertSuccess();
    return {
        ClientConfigurations: cdk.listMapper(cfnVolumeClientConfigurationsPropertyToCloudFormation)(properties.clientConfigurations),
    };
}
// @ts-ignore TS6133
function CfnVolumeNfsExportsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientConfigurations', 'ClientConfigurations', cfn_parse.FromCloudFormation.getArray(CfnVolumeClientConfigurationsPropertyFromCloudFormation)(properties.ClientConfigurations));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OntapConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OntapConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_OntapConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('junctionPath', cdk.requiredValidator)(properties.junctionPath));
    errors.collect(cdk.propertyValidator('junctionPath', cdk.validateString)(properties.junctionPath));
    errors.collect(cdk.propertyValidator('securityStyle', cdk.validateString)(properties.securityStyle));
    errors.collect(cdk.propertyValidator('sizeInMegabytes', cdk.requiredValidator)(properties.sizeInMegabytes));
    errors.collect(cdk.propertyValidator('sizeInMegabytes', cdk.validateString)(properties.sizeInMegabytes));
    errors.collect(cdk.propertyValidator('storageEfficiencyEnabled', cdk.requiredValidator)(properties.storageEfficiencyEnabled));
    errors.collect(cdk.propertyValidator('storageEfficiencyEnabled', cdk.validateString)(properties.storageEfficiencyEnabled));
    errors.collect(cdk.propertyValidator('storageVirtualMachineId', cdk.requiredValidator)(properties.storageVirtualMachineId));
    errors.collect(cdk.propertyValidator('storageVirtualMachineId', cdk.validateString)(properties.storageVirtualMachineId));
    errors.collect(cdk.propertyValidator('tieringPolicy', CfnVolume_TieringPolicyPropertyValidator)(properties.tieringPolicy));
    return errors.wrap('supplied properties not correct for "OntapConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.OntapConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OntapConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.OntapConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnVolumeOntapConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_OntapConfigurationPropertyValidator(properties).assertSuccess();
    return {
        JunctionPath: cdk.stringToCloudFormation(properties.junctionPath),
        SecurityStyle: cdk.stringToCloudFormation(properties.securityStyle),
        SizeInMegabytes: cdk.stringToCloudFormation(properties.sizeInMegabytes),
        StorageEfficiencyEnabled: cdk.stringToCloudFormation(properties.storageEfficiencyEnabled),
        StorageVirtualMachineId: cdk.stringToCloudFormation(properties.storageVirtualMachineId),
        TieringPolicy: cfnVolumeTieringPolicyPropertyToCloudFormation(properties.tieringPolicy),
    };
}
// @ts-ignore TS6133
function CfnVolumeOntapConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('junctionPath', 'JunctionPath', cfn_parse.FromCloudFormation.getString(properties.JunctionPath));
    ret.addPropertyResult('securityStyle', 'SecurityStyle', properties.SecurityStyle != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityStyle) : undefined);
    ret.addPropertyResult('sizeInMegabytes', 'SizeInMegabytes', cfn_parse.FromCloudFormation.getString(properties.SizeInMegabytes));
    ret.addPropertyResult('storageEfficiencyEnabled', 'StorageEfficiencyEnabled', cfn_parse.FromCloudFormation.getString(properties.StorageEfficiencyEnabled));
    ret.addPropertyResult('storageVirtualMachineId', 'StorageVirtualMachineId', cfn_parse.FromCloudFormation.getString(properties.StorageVirtualMachineId));
    ret.addPropertyResult('tieringPolicy', 'TieringPolicy', properties.TieringPolicy != null ? CfnVolumeTieringPolicyPropertyFromCloudFormation(properties.TieringPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OpenZFSConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OpenZFSConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_OpenZFSConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('copyTagsToSnapshots', cdk.validateBoolean)(properties.copyTagsToSnapshots));
    errors.collect(cdk.propertyValidator('dataCompressionType', cdk.validateString)(properties.dataCompressionType));
    errors.collect(cdk.propertyValidator('nfsExports', cdk.listValidator(CfnVolume_NfsExportsPropertyValidator))(properties.nfsExports));
    errors.collect(cdk.propertyValidator('options', cdk.listValidator(cdk.validateString))(properties.options));
    errors.collect(cdk.propertyValidator('originSnapshot', CfnVolume_OriginSnapshotPropertyValidator)(properties.originSnapshot));
    errors.collect(cdk.propertyValidator('parentVolumeId', cdk.requiredValidator)(properties.parentVolumeId));
    errors.collect(cdk.propertyValidator('parentVolumeId', cdk.validateString)(properties.parentVolumeId));
    errors.collect(cdk.propertyValidator('readOnly', cdk.validateBoolean)(properties.readOnly));
    errors.collect(cdk.propertyValidator('recordSizeKiB', cdk.validateNumber)(properties.recordSizeKiB));
    errors.collect(cdk.propertyValidator('storageCapacityQuotaGiB', cdk.validateNumber)(properties.storageCapacityQuotaGiB));
    errors.collect(cdk.propertyValidator('storageCapacityReservationGiB', cdk.validateNumber)(properties.storageCapacityReservationGiB));
    errors.collect(cdk.propertyValidator('userAndGroupQuotas', cdk.listValidator(CfnVolume_UserAndGroupQuotasPropertyValidator))(properties.userAndGroupQuotas));
    return errors.wrap('supplied properties not correct for "OpenZFSConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.OpenZFSConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OpenZFSConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.OpenZFSConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnVolumeOpenZFSConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_OpenZFSConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CopyTagsToSnapshots: cdk.booleanToCloudFormation(properties.copyTagsToSnapshots),
        DataCompressionType: cdk.stringToCloudFormation(properties.dataCompressionType),
        NfsExports: cdk.listMapper(cfnVolumeNfsExportsPropertyToCloudFormation)(properties.nfsExports),
        Options: cdk.listMapper(cdk.stringToCloudFormation)(properties.options),
        OriginSnapshot: cfnVolumeOriginSnapshotPropertyToCloudFormation(properties.originSnapshot),
        ParentVolumeId: cdk.stringToCloudFormation(properties.parentVolumeId),
        ReadOnly: cdk.booleanToCloudFormation(properties.readOnly),
        RecordSizeKiB: cdk.numberToCloudFormation(properties.recordSizeKiB),
        StorageCapacityQuotaGiB: cdk.numberToCloudFormation(properties.storageCapacityQuotaGiB),
        StorageCapacityReservationGiB: cdk.numberToCloudFormation(properties.storageCapacityReservationGiB),
        UserAndGroupQuotas: cdk.listMapper(cfnVolumeUserAndGroupQuotasPropertyToCloudFormation)(properties.userAndGroupQuotas),
    };
}
// @ts-ignore TS6133
function CfnVolumeOpenZFSConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('copyTagsToSnapshots', 'CopyTagsToSnapshots', properties.CopyTagsToSnapshots != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshots) : undefined);
    ret.addPropertyResult('dataCompressionType', 'DataCompressionType', properties.DataCompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.DataCompressionType) : undefined);
    ret.addPropertyResult('nfsExports', 'NfsExports', properties.NfsExports != null ? cfn_parse.FromCloudFormation.getArray(CfnVolumeNfsExportsPropertyFromCloudFormation)(properties.NfsExports) : undefined);
    ret.addPropertyResult('options', 'Options', properties.Options != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Options) : undefined);
    ret.addPropertyResult('originSnapshot', 'OriginSnapshot', properties.OriginSnapshot != null ? CfnVolumeOriginSnapshotPropertyFromCloudFormation(properties.OriginSnapshot) : undefined);
    ret.addPropertyResult('parentVolumeId', 'ParentVolumeId', cfn_parse.FromCloudFormation.getString(properties.ParentVolumeId));
    ret.addPropertyResult('readOnly', 'ReadOnly', properties.ReadOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadOnly) : undefined);
    ret.addPropertyResult('recordSizeKiB', 'RecordSizeKiB', properties.RecordSizeKiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.RecordSizeKiB) : undefined);
    ret.addPropertyResult('storageCapacityQuotaGiB', 'StorageCapacityQuotaGiB', properties.StorageCapacityQuotaGiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacityQuotaGiB) : undefined);
    ret.addPropertyResult('storageCapacityReservationGiB', 'StorageCapacityReservationGiB', properties.StorageCapacityReservationGiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacityReservationGiB) : undefined);
    ret.addPropertyResult('userAndGroupQuotas', 'UserAndGroupQuotas', properties.UserAndGroupQuotas != null ? cfn_parse.FromCloudFormation.getArray(CfnVolumeUserAndGroupQuotasPropertyFromCloudFormation)(properties.UserAndGroupQuotas) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OriginSnapshotProperty`
 *
 * @param properties - the TypeScript properties of a `OriginSnapshotProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_OriginSnapshotPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('copyStrategy', cdk.requiredValidator)(properties.copyStrategy));
    errors.collect(cdk.propertyValidator('copyStrategy', cdk.validateString)(properties.copyStrategy));
    errors.collect(cdk.propertyValidator('snapshotArn', cdk.requiredValidator)(properties.snapshotArn));
    errors.collect(cdk.propertyValidator('snapshotArn', cdk.validateString)(properties.snapshotArn));
    return errors.wrap('supplied properties not correct for "OriginSnapshotProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.OriginSnapshot` resource
 *
 * @param properties - the TypeScript properties of a `OriginSnapshotProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.OriginSnapshot` resource.
 */
// @ts-ignore TS6133
function cfnVolumeOriginSnapshotPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_OriginSnapshotPropertyValidator(properties).assertSuccess();
    return {
        CopyStrategy: cdk.stringToCloudFormation(properties.copyStrategy),
        SnapshotARN: cdk.stringToCloudFormation(properties.snapshotArn),
    };
}
// @ts-ignore TS6133
function CfnVolumeOriginSnapshotPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('copyStrategy', 'CopyStrategy', cfn_parse.FromCloudFormation.getString(properties.CopyStrategy));
    ret.addPropertyResult('snapshotArn', 'SnapshotARN', cfn_parse.FromCloudFormation.getString(properties.SnapshotARN));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TieringPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `TieringPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_TieringPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('coolingPeriod', cdk.validateNumber)(properties.coolingPeriod));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "TieringPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.TieringPolicy` resource
 *
 * @param properties - the TypeScript properties of a `TieringPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.TieringPolicy` resource.
 */
// @ts-ignore TS6133
function cfnVolumeTieringPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_TieringPolicyPropertyValidator(properties).assertSuccess();
    return {
        CoolingPeriod: cdk.numberToCloudFormation(properties.coolingPeriod),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnVolumeTieringPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('coolingPeriod', 'CoolingPeriod', properties.CoolingPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.CoolingPeriod) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserAndGroupQuotasProperty`
 *
 * @param properties - the TypeScript properties of a `UserAndGroupQuotasProperty`
 *
 * @returns the result of the validation.
 */
function CfnVolume_UserAndGroupQuotasPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateNumber)(properties.id));
    errors.collect(cdk.propertyValidator('storageCapacityQuotaGiB', cdk.requiredValidator)(properties.storageCapacityQuotaGiB));
    errors.collect(cdk.propertyValidator('storageCapacityQuotaGiB', cdk.validateNumber)(properties.storageCapacityQuotaGiB));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "UserAndGroupQuotasProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::Volume.UserAndGroupQuotas` resource
 *
 * @param properties - the TypeScript properties of a `UserAndGroupQuotasProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::Volume.UserAndGroupQuotas` resource.
 */
// @ts-ignore TS6133
function cfnVolumeUserAndGroupQuotasPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnVolume_UserAndGroupQuotasPropertyValidator(properties).assertSuccess();
    return {
        Id: cdk.numberToCloudFormation(properties.id),
        StorageCapacityQuotaGiB: cdk.numberToCloudFormation(properties.storageCapacityQuotaGiB),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnVolumeUserAndGroupQuotasPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getNumber(properties.Id));
    ret.addPropertyResult('storageCapacityQuotaGiB', 'StorageCapacityQuotaGiB', cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacityQuotaGiB));
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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