# Generated by Django 3.1.6 on 2021-04-06 21:45

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("authentication", "0017_remove_fleetup_permission"),
        ("eveonline", "0014_auto_20210105_1413"),
        ("eveuniverse", "0005_type_materials_and_sections"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access the moonmining app"),
                    (
                        "extractions_access",
                        "Can access extractions and view owned moons",
                    ),
                    ("reports_access", "Can access reports"),
                    ("view_all_moons", "Can view all known moons"),
                    ("upload_moon_scan", "Can upload moon scans"),
                    ("add_refinery_owner", "Can add refinery owner"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Extraction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "started_at",
                    models.DateTimeField(help_text="when this extraction was started"),
                ),
                (
                    "auto_fracture_at",
                    models.DateTimeField(
                        help_text="when this extraction will be automatically fractured"
                    ),
                ),
                (
                    "canceled_at",
                    models.DateTimeField(
                        default=None,
                        help_text="when this extraction was canceled",
                        null=True,
                    ),
                ),
                (
                    "chunk_arrival_at",
                    models.DateTimeField(
                        db_index=True,
                        help_text="when this extraction is ready to be fractured",
                    ),
                ),
                (
                    "fractured_at",
                    models.DateTimeField(
                        default=None,
                        help_text="when this extraction was fractured",
                        null=True,
                    ),
                ),
                (
                    "is_jackpot",
                    models.BooleanField(
                        default=None,
                        help_text="Whether this is a jackpot extraction (calculated)",
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("ST", "started"),
                            ("CN", "canceled"),
                            ("RD", "ready"),
                            ("CP", "completed"),
                            ("UN", "undefined"),
                        ],
                        db_index=True,
                        default="UN",
                        max_length=2,
                    ),
                ),
                (
                    "value",
                    models.FloatField(
                        default=None,
                        help_text="Estimated value of this extraction (calculated)",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "canceled_by",
                    models.ForeignKey(
                        default=None,
                        help_text="Eve character who canceled this extraction",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "fractured_by",
                    models.ForeignKey(
                        default=None,
                        help_text="Eve character who fractured this extraction (if any)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Moon",
            fields=[
                (
                    "eve_moon",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="known_moon",
                        serialize=False,
                        to="eveuniverse.evemoon",
                    ),
                ),
                (
                    "products_updated_at",
                    models.DateTimeField(
                        default=None,
                        help_text="Time the last moon survey was uploaded",
                        null=True,
                    ),
                ),
                (
                    "rarity_class",
                    models.PositiveIntegerField(
                        choices=[
                            (0, ""),
                            (4, "R4"),
                            (8, "R8"),
                            (16, "R16"),
                            (32, "R32"),
                            (64, "R64"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "value",
                    models.FloatField(
                        db_index=True,
                        default=None,
                        help_text="Calculated value estimate",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                    ),
                ),
                (
                    "products_updated_by",
                    models.ForeignKey(
                        default=None,
                        help_text="User who uploaded the last moon survey",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Owner",
            fields=[
                (
                    "corporation",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="mining_corporation",
                        serialize=False,
                        to="eveonline.evecorporationinfo",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="disabled corporations are excluded from the update process",
                    ),
                ),
                (
                    "last_update_at",
                    models.DateTimeField(
                        default=None,
                        help_text="time of last successful update",
                        null=True,
                    ),
                ),
                (
                    "last_update_ok",
                    models.BooleanField(
                        default=None,
                        help_text="True if the last update was successful",
                        null=True,
                    ),
                ),
                (
                    "character_ownership",
                    models.ForeignKey(
                        default=None,
                        help_text="character used to sync this corporation from ESI",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EveOreType",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("eveuniverse.evetype",),
        ),
        migrations.CreateModel(
            name="Refinery",
            fields=[
                (
                    "id",
                    models.PositiveBigIntegerField(primary_key=True, serialize=False),
                ),
                ("name", models.CharField(db_index=True, max_length=150)),
                (
                    "eve_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "moon",
                    models.OneToOneField(
                        default=None,
                        help_text="The moon this refinery is anchored at (if any)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="refinery",
                        to="moonmining.moon",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Corporation that owns this refinery",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="refineries",
                        to="moonmining.owner",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("notification_id", models.PositiveBigIntegerField(verbose_name="id")),
                (
                    "created",
                    models.DateTimeField(
                        default=None,
                        help_text="Date when this notification was first received from ESI",
                        null=True,
                    ),
                ),
                ("details", models.JSONField(default=dict)),
                (
                    "notif_type",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="type of this notification as reported by ESI",
                        max_length=100,
                        verbose_name="type",
                    ),
                ),
                (
                    "is_read",
                    models.BooleanField(
                        default=None,
                        help_text="True when this notification has read in the eve client",
                        null=True,
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(
                        help_text="Date when this notification has last been updated from ESI"
                    ),
                ),
                ("timestamp", models.DateTimeField(db_index=True)),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Corporation that received this notification",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to="moonmining.owner",
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="MoonProduct",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amount",
                    models.FloatField(
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(1.0),
                        ]
                    ),
                ),
                (
                    "moon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="products",
                        to="moonmining.moon",
                    ),
                ),
                (
                    "ore_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="moonmining.eveoretype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ExtractionProduct",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "volume",
                    models.FloatField(
                        validators=[django.core.validators.MinValueValidator(0.0)]
                    ),
                ),
                (
                    "extraction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="products",
                        to="moonmining.extraction",
                    ),
                ),
                (
                    "ore_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="moonmining.eveoretype",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="extraction",
            name="refinery",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="extractions",
                to="moonmining.refinery",
            ),
        ),
        migrations.AddField(
            model_name="extraction",
            name="started_by",
            field=models.ForeignKey(
                default=None,
                help_text="Eve character who started this extraction",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveuniverse.eveentity",
            ),
        ),
        migrations.AddConstraint(
            model_name="notification",
            constraint=models.UniqueConstraint(
                fields=("owner", "notification_id"), name="functional_pk_notification"
            ),
        ),
        migrations.AddConstraint(
            model_name="moonproduct",
            constraint=models.UniqueConstraint(
                fields=("moon", "ore_type"), name="functional_pk_moonproduct"
            ),
        ),
        migrations.AddConstraint(
            model_name="extractionproduct",
            constraint=models.UniqueConstraint(
                fields=("extraction", "ore_type"),
                name="functional_pk_extractionproduct",
            ),
        ),
        migrations.AddConstraint(
            model_name="extraction",
            constraint=models.UniqueConstraint(
                fields=("refinery", "started_at"), name="functional_pk_extraction"
            ),
        ),
    ]
