#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open("README.md", encoding="utf-8") as readme_file:
    readme = readme_file.read()

with open("HISTORY.rst") as history_file:
    history = history_file.read()

requirements = [
    "requests",

]

test_requirements = []

setup(
    author="Jiang Chaodi",
    author_email="chaodi.jiang@fdsintl.com",
    python_requires=">=3.6",
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    description="python sdk for gocron",
    install_requires=requirements,
    license="MIT license",
    # long_description=readme + "\n\n" + history,
    include_package_data=True,
    keywords="pygocron",
    name="pygocron",
    packages=find_packages(include=["pygocron", "pygocron.*"]),
    test_suite="tests",
    tests_require=test_requirements,
    url="https://github.com/superjcd/pygocron",
    version="0.1.2",
    zip_safe=False,
)
