# Generated by Django 3.0 on 2019-12-20 11:33

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.crypto
import textrank.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='создана')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='обновлена')),
                ('name', models.CharField(error_messages={'unique': 'Такое название уже существует.'}, help_text='Обязательно. 50 символов и менее.', max_length=50, unique=True, verbose_name='название')),
                ('code', models.CharField(default=django.utils.crypto.get_random_string, error_messages={'unique': 'Такой код уже существует.'}, help_text='Обязательно. 32 символа и менее, уникальное значение.', max_length=32, unique=True, verbose_name='код группы')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Отключите, если группа не используется для анализа.', verbose_name='активная')),
                ('last_editor', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='последний редактор')),
            ],
            options={
                'verbose_name': 'группа ключевых слов',
                'verbose_name_plural': 'группы ключевых слов',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Keyword',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='создано')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='обновлено')),
                ('word', models.CharField(error_messages={'unique': 'Такое слово (сочетание) уже существует.'}, help_text='Обязательно. 100 символов и менее. Значение может содержать только буквы в нижнем регистре, цифры, символы дефиса, подчёркивания или знак +, а также начинаться и заканчиваться словом. Варианты: Ключевое слово (word1), цепочка слов (word1_word2_word3) или покрытие словами (word1+word2+word3).', max_length=100, unique=True, validators=[textrank.validators.UnicodeKeywordValidator()], verbose_name='слово')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Отключите, если слово не используется для анализа.', verbose_name='активное')),
            ],
            options={
                'verbose_name': 'ключевое слово',
                'verbose_name_plural': 'ключевые слова',
                'ordering': ('word',),
            },
        ),
        migrations.CreateModel(
            name='Weight',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='создан')),
                ('updated', models.DateTimeField(auto_now=True, db_index=True, verbose_name='обновлён')),
                ('value', models.PositiveSmallIntegerField(default=1, verbose_name='значение веса')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='weights', to='textrank.Group', verbose_name='группа')),
                ('keyword', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='weights', to='textrank.Keyword', verbose_name='ключевое слово')),
                ('last_editor', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='последний редактор')),
            ],
            options={
                'verbose_name': 'вес ключевого слова',
                'verbose_name_plural': 'веса ключевых слов',
                'ordering': ('-updated',),
                'unique_together': {('group', 'keyword')},
            },
        ),
        migrations.AddField(
            model_name='keyword',
            name='groups',
            field=models.ManyToManyField(editable=False, through='textrank.Weight', to='textrank.Group', verbose_name='группы'),
        ),
        migrations.AddField(
            model_name='keyword',
            name='last_editor',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='последний редактор'),
        ),
    ]
