from .checklist import ChecklistClassifier2


def evaluate(spec: dict, input: any, output: any):
    """
    Evaluate an output against a specification.

    Args:
        spec: The evaluation specification from the task.
        input: The input to the task.
        output: The output generated by the task.

    Returns:
        A dictionary containing the evaluation result.
    """

    # Set the minimum score required to pass
    min_score = spec.get('min_score', 1.0)

    evaluator = None
    if 'checklist' in spec:
        # Use the ChecklistClassifier2 for evaluation
        evaluator = ChecklistClassifier2()
        result = evaluator(output, spec['checklist'], input=input)
    else:
        raise ValueError("No evaluator specified")

    return {
        'score': result.score,
        'passed': result.score >= min_score,
        'details': result.metadata
    }
