"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbTarget = exports.AlbArnTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A single Application Load Balancer as the target for load balancing.
 *
 * @stability stable
 */
class AlbArnTarget {
    /**
     * Create a new alb target.
     *
     * @param albArn The ARN of the application load balancer to load balance to.
     * @param port The port on which the target is listening.
     * @stability stable
     */
    constructor(albArn, port) {
        this.albArn = albArn;
        this.port = port;
    }
    /**
     * Register this alb target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @stability stable
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.ALB,
            targetJson: { id: this.albArn, port: this.port },
        };
    }
}
exports.AlbArnTarget = AlbArnTarget;
_a = JSII_RTTI_SYMBOL_1;
AlbArnTarget[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbArnTarget", version: "1.141.0" };
/**
 * A single Application Load Balancer as the target for load balancing.
 *
 * @stability stable
 */
class AlbTarget extends AlbArnTarget {
    /**
     * @param alb The application load balancer to load balance to.
     * @param port The port on which the target is listening.
     * @stability stable
     */
    constructor(alb, port) {
        super(alb.loadBalancerArn, port);
    }
}
exports.AlbTarget = AlbTarget;
_b = JSII_RTTI_SYMBOL_1;
AlbTarget[_b] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-targets.AlbTarget", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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