import setuptools

with open('README.md') as readme_file:
    readme = readme_file.read()

with open('HISTORY.md') as history_file:
    history = history_file.read()

setuptools.setup(
    name='datacatalog-object-storage-processor',
    version='0.1.2',
    author='Marcelo Costa',
    author_email='mesmacosta@gmail.com',
    description='A package for performing Data Catalog operations on object storage solutions',
    platforms='Posix; MacOS X; Windows',
    packages=setuptools.find_packages(where='./src'),
    package_dir={'': 'src'},
    entry_points={
        'console_scripts': [
            'datacatalog-object-storage-processor = datacatalog_object_storage_processor:main',
        ],
    },
    include_package_data=True,
    install_requires=(
        'google-cloud-datacatalog>=1,<2',
        'google-cloud-storage',
        'pandas',
    ),
    setup_requires=('pytest-runner', ),
    tests_require=('pytest-cov', ),
    python_requires='>=3.6',
    license="MIT license",
    long_description=readme + '\n\n' + history,
    long_description_content_type='text/markdown',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Natural Language :: English',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
    url='https://github.com/mesmacosta/datacatalog-object-storage-processor',
    zip_safe=False,
)
