'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.length-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(t,_,n,o,r){o();t(1).__exportStar(t(2),n),t(91)},
function _(e,t,r,n,o){n(),r.__extends=i,r.__rest=c,r.__decorate=s,r.__param=u,r.__esDecorate=f,r.__runInitializers=l,r.__propKey=p,r.__setFunctionName=_,r.__metadata=y,r.__awaiter=d,r.__generator=h,r.__exportStar=v,r.__values=b,r.__read=w,r.__spread=m,r.__spreadArrays=g,r.__spreadArray=O,r.__await=j,r.__asyncGenerator=P,r.__asyncDelegator=S,r.__asyncValues=E,r.__makeTemplateObject=x,r.__importStar=D,r.__importDefault=R,r.__classPrivateFieldGet=k,r.__classPrivateFieldSet=A,r.__classPrivateFieldIn=F,r.__addDisposableResource=C,r.__disposeResources=G,r.__rewriteRelativeImportExtension=z;var a=function(e,t){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r])},a(e,t)};function i(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function r(){this.constructor=e}a(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}function c(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(e);o<n.length;o++)t.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(e,n[o])&&(r[n[o]]=e[n[o]])}return r}function s(e,t,r,n){var o,a=arguments.length,i=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(e,t,r,n);else for(var c=e.length-1;c>=0;c--)(o=e[c])&&(i=(a<3?o(i):a>3?o(t,r,i):o(t,r))||i);return a>3&&i&&Object.defineProperty(t,r,i),i}function u(e,t){return function(r,n){t(r,n,e)}}function f(e,t,r,n,o,a){function i(e){if(void 0!==e&&"function"!=typeof e)throw new TypeError("Function expected");return e}for(var c,s=n.kind,u="getter"===s?"get":"setter"===s?"set":"value",f=!t&&e?n.static?e:e.prototype:null,l=t||(f?Object.getOwnPropertyDescriptor(f,n.name):{}),p=!1,_=r.length-1;_>=0;_--){var y={};for(var d in n)y[d]="access"===d?{}:n[d];for(var d in n.access)y.access[d]=n.access[d];y.addInitializer=function(e){if(p)throw new TypeError("Cannot add initializers after decoration has completed");a.push(i(e||null))};var h=(0,r[_])("accessor"===s?{get:l.get,set:l.set}:l[u],y);if("accessor"===s){if(void 0===h)continue;if(null===h||"object"!=typeof h)throw new TypeError("Object expected");(c=i(h.get))&&(l.get=c),(c=i(h.set))&&(l.set=c),(c=i(h.init))&&o.unshift(c)}else(c=i(h))&&("field"===s?o.unshift(c):l[u]=c)}f&&Object.defineProperty(f,n.name,l),p=!0}function l(e,t,r){for(var n=arguments.length>2,o=0;o<t.length;o++)r=n?t[o].call(e,r):t[o].call(e);return n?r:void 0}function p(e){return"symbol"==typeof e?e:"".concat(e)}function _(e,t,r){return"symbol"==typeof t&&(t=t.description?"[".concat(t.description,"]"):""),Object.defineProperty(e,"name",{configurable:!0,value:r?"".concat(r," ",t):t})}function y(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)}function d(e,t,r,n){return new(r||(r=Promise))((function(o,a){function i(e){try{s(n.next(e))}catch(e){a(e)}}function c(e){try{s(n.throw(e))}catch(e){a(e)}}function s(e){var t;e.done?o(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(i,c)}s((n=n.apply(e,t||[])).next())}))}function h(e,t){var r,n,o,a={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]},i=Object.create(("function"==typeof Iterator?Iterator:Object).prototype);return i.next=c(0),i.throw=c(1),i.return=c(2),"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function c(c){return function(s){return function(c){if(r)throw new TypeError("Generator is already executing.");for(;i&&(i=0,c[0]&&(a=0)),a;)try{if(r=1,n&&(o=2&c[0]?n.return:c[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,c[1])).done)return o;switch(n=0,o&&(c=[2&c[0],o.value]),c[0]){case 0:case 1:o=c;break;case 4:return a.label++,{value:c[1],done:!1};case 5:a.label++,n=c[1],c=[0];continue;case 7:c=a.ops.pop(),a.trys.pop();continue;default:if(!(o=a.trys,(o=o.length>0&&o[o.length-1])||6!==c[0]&&2!==c[0])){a=0;continue}if(3===c[0]&&(!o||c[1]>o[0]&&c[1]<o[3])){a.label=c[1];break}if(6===c[0]&&a.label<o[1]){a.label=o[1],o=c;break}if(o&&a.label<o[2]){a.label=o[2],a.ops.push(c);break}o[2]&&a.ops.pop(),a.trys.pop();continue}c=t.call(e,a)}catch(e){c=[6,e],n=0}finally{r=o=0}if(5&c[0])throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}([c,s])}}}function v(e,t){for(var n in e)"default"===n||Object.prototype.hasOwnProperty.call(t,n)||(0,r.__createBinding)(t,e,n)}function b(e){var t="function"==typeof Symbol&&Symbol.iterator,r=t&&e[t],n=0;if(r)return r.call(e);if(e&&"number"==typeof e.length)return{next:function(){return e&&n>=e.length&&(e=void 0),{value:e&&e[n++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")}function w(e,t){var r="function"==typeof Symbol&&e[Symbol.iterator];if(!r)return e;var n,o,a=r.call(e),i=[];try{for(;(void 0===t||t-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(e){o={error:e}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function m(){for(var e=[],t=0;t<arguments.length;t++)e=e.concat(w(arguments[t]));return e}function g(){for(var e=0,t=0,r=arguments.length;t<r;t++)e+=arguments[t].length;var n=Array(e),o=0;for(t=0;t<r;t++)for(var a=arguments[t],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n}function O(e,t,r){if(r||2===arguments.length)for(var n,o=0,a=t.length;o<a;o++)!n&&o in t||(n||(n=Array.prototype.slice.call(t,0,o)),n[o]=t[o]);return e.concat(n||Array.prototype.slice.call(t))}function j(e){return this instanceof j?(this.v=e,this):new j(e)}function P(e,t,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(e,t||[]),a=[];return n=Object.create(("function"==typeof AsyncIterator?AsyncIterator:Object).prototype),i("next"),i("throw"),i("return",(function(e){return function(t){return Promise.resolve(t).then(e,u)}})),n[Symbol.asyncIterator]=function(){return this},n;function i(e,t){o[e]&&(n[e]=function(t){return new Promise((function(r,n){a.push([e,t,r,n])>1||c(e,t)}))},t&&(n[e]=t(n[e])))}function c(e,t){try{(r=o[e](t)).value instanceof j?Promise.resolve(r.value.v).then(s,u):f(a[0][2],r)}catch(e){f(a[0][3],e)}var r}function s(e){c("next",e)}function u(e){c("throw",e)}function f(e,t){e(t),a.shift(),a.length&&c(a[0][0],a[0][1])}}function S(e){var t,r;return t={},n("next"),n("throw",(function(e){throw e})),n("return"),t[Symbol.iterator]=function(){return this},t;function n(n,o){t[n]=e[n]?function(t){return(r=!r)?{value:j(e[n](t)),done:!1}:o?o(t):t}:o}}function E(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,r=e[Symbol.asyncIterator];return r?r.call(e):(e=b(e),t={},n("next"),n("throw"),n("return"),t[Symbol.asyncIterator]=function(){return this},t);function n(r){t[r]=e[r]&&function(t){return new Promise((function(n,o){(function(e,t,r,n){Promise.resolve(n).then((function(t){e({value:t,done:r})}),t)})(n,o,(t=e[r](t)).done,t.value)}))}}}function x(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e}r.__assign=function(){return r.__assign=Object.assign||function(e){for(var t,r=1,n=arguments.length;r<n;r++)for(var o in t=arguments[r])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e},r.__assign.apply(this,arguments)},r.__createBinding=Object.create?function(e,t,r,n){void 0===n&&(n=r);var o=Object.getOwnPropertyDescriptor(t,r);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,o)}:function(e,t,r,n){void 0===n&&(n=r),e[n]=t[r]};var T=Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t},I=function(e){return I=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t},I(e)};function D(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var n=I(e),o=0;o<n.length;o++)"default"!==n[o]&&(0,r.__createBinding)(t,e,n[o]);return T(t,e),t}function R(e){return e&&e.__esModule?e:{default:e}}function k(e,t,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!n:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(e):n?n.value:t.get(e)}function A(e,t,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!o:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(e,r):o?o.value=r:t.set(e,r),r}function F(e,t){if(null===t||"object"!=typeof t&&"function"!=typeof t)throw new TypeError("Cannot use 'in' operator on non-object");return"function"==typeof e?t===e:e.has(t)}function C(e,t,r){if(null!=t){if("object"!=typeof t&&"function"!=typeof t)throw new TypeError("Object expected.");var n,o;if(r){if(!Symbol.asyncDispose)throw new TypeError("Symbol.asyncDispose is not defined.");n=t[Symbol.asyncDispose]}if(void 0===n){if(!Symbol.dispose)throw new TypeError("Symbol.dispose is not defined.");n=t[Symbol.dispose],r&&(o=n)}if("function"!=typeof n)throw new TypeError("Object not disposable.");o&&(n=function(){try{o.call(this)}catch(e){return Promise.reject(e)}}),e.stack.push({value:t,dispose:n,async:r})}else r&&e.stack.push({async:!0});return t}var B="function"==typeof SuppressedError?SuppressedError:function(e,t,r){var n=new Error(r);return n.name="SuppressedError",n.error=e,n.suppressed=t,n};function G(e){function t(t){e.error=e.hasError?new B(t,e.error,"An error was suppressed during disposal."):t,e.hasError=!0}var r,n=0;return function o(){for(;r=e.stack.pop();)try{if(!r.async&&1===n)return n=0,e.stack.push(r),Promise.resolve().then(o);if(r.dispose){var a=r.dispose.call(r.value);if(r.async)return n|=2,Promise.resolve(a).then(o,(function(e){return t(e),o()}))}else n|=1}catch(e){t(e)}if(1===n)return e.hasError?Promise.reject(e.error):Promise.resolve();if(e.hasError)throw e.error}()}function z(e,t){return"string"==typeof e&&/^\.\.?\//.test(e)?e.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i,(function(e,r,n,o,a){return r?t?".jsx":".js":!n||o&&a?n+o+"."+a.toLowerCase()+"js":e})):e}r.default={__extends:i,__assign:r.__assign,__rest:c,__decorate:s,__param:u,__esDecorate:f,__runInitializers:l,__propKey:p,__setFunctionName:_,__metadata:y,__awaiter:d,__generator:h,__createBinding:r.__createBinding,__exportStar:v,__values:b,__read:w,__spread:m,__spreadArrays:g,__spreadArray:O,__await:j,__asyncGenerator:P,__asyncDelegator:S,__asyncValues:E,__makeTemplateObject:x,__importStar:D,__importDefault:R,__classPrivateFieldGet:k,__classPrivateFieldSet:A,__classPrivateFieldIn:F,__addDisposableResource:C,__disposeResources:G,__rewriteRelativeImportExtension:z}},
function _(e,o,s,t,l){t();const n=e(1);l("version",e(3).version),l("index",e(4).index),s.embed=n.__importStar(e(4)),s.protocol=n.__importStar(e(89));var r=e(20);l("logger",r.logger),l("set_log_level",r.set_log_level),l("settings",e(30).settings),l("Models",e(7).Models),l("documents",e(5).documents),l("safely",e(90).safely)},
function _(n,e,i,o,v){o(),i.version="3.9.0-dev.2"},
function _(e,o,t,n,r){n(),t.embed_item=async function(e,o){const t={},n=(0,_.uuid4)();t[n]=e.doc,null==o&&(o=e.target_id);const r={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n};await(0,u.defer)();const[s]=await k(t,[r]);return s},t.embed_items=async function(e,o,t,n){return await(0,u.defer)(),k(e,o,t,n)};const s=e(5),d=e(30),i=e(20),_=e(41),c=e(9),a=e(8),u=e(17),l=e(81),m=e(82),f=e(87);var w=e(81);r("add_document_standalone",w.add_document_standalone),r("index",w.index),r("add_document_from_session",e(82).add_document_from_session);var g=e(88);async function k(e,o,t,n){(0,a.isString)(e)&&(e=JSON.parse((0,_.unescape)(e)));const r={};for(const[o,t]of(0,c.entries)(e))r[o]=s.Document.from_json(t);const u=[];for(const e of o){const o=(0,f._resolve_element)(e),s=(0,f._resolve_root_elements)(e);if(null!=e.docid)u.push(await(0,l.add_document_standalone)(r[e.docid],o,s,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const r=(0,m._get_ws_url)(t,n);i.logger.debug(`embed: computed ws url: ${r}`);try{u.push(await(0,m.add_document_from_session)(r,e.token,o,s,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){if(d.settings.dev)throw e;console.error("Error rendering Bokeh items:",e)}}}}return u}r("embed_items_notebook",g.embed_items_notebook),r("kernels",g.kernels)},
function _(t,r,_,o,e){o();const n=t(1);n.__exportStar(t(6),_),n.__exportStar(t(42),_);const s=t(7),a=n.__importStar(t(53));(0,s.register_models)(a)},
function _(e,t,s,o,i){o();const _=e(1),n=e(7),l=e(3),r=e(20),a=e(15),c=e(47),h=e(33),d=e(48),m=e(50),u=e(16),f=e(8),g=e(27),p=e(10),v=e(9),w=_.__importStar(e(45)),y=e(51),b=e(12),k=e(52),z=e(53),S=e(79),D=e(80),E=e(80),M=e(42);d.Deserializer.register("model",S.decode_def);class j{constructor(e){this.subscribed_models=new Set,this.document=e}send_event(e){if(e.publish){const t=new M.MessageSentEvent(this.document,"bokeh_event",e);this.document._trigger_on_change(t)}this.document._trigger_on_event(e)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=j,j.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class C{get config(){return(0,b.assert)(null!=this._config,"configuration is missing"),this._config}set config(e){this.freeze_all_models((()=>this._config=e))}constructor(e={}){this._notified_idle=!1,this._hold_models_freeze=!1,this._recompute_timer=null,s.documents.push(this),this._init_timestamp=Date.now(),this._resolver=e.resolver??new c.ModelResolver(n.default_resolver),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._new_models=new Set,this._all_models_freeze_count=0,this._callbacks=new Map,this._document_callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new j(this),this.idle=new u.Signal0(this,"idle"),this._idle_roots=new WeakSet,this._interactive_timestamp=null,this._interactive_plot=null,this._recompute_timeout=e.recompute_timeout??3e4,null!=e.roots&&this._add_roots(...e.roots),this.on_message("bokeh_event",(e=>{(0,b.assert)(e instanceof D.ModelEvent),this.event_manager.trigger(e)})),this.config=new z.DocumentConfig}[g.equals](e,t){return this==e}get all_models(){return new Set(this._all_models.values())}get is_idle(){for(const e of this.roots())if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){!this._notified_idle&&this.roots().includes(e)&&(this._idle_roots.add(e),this.is_idle&&(r.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new E.DocumentReady),this.idle.emit(),this._notified_idle=!0))}clear({sync:e}={}){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0],{sync:e});this._config=void 0}finally{this._pop_all_models_freeze()}}interactive_start(e,t=null){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new E.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new E.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear({sync:!1});const{config:t}=this,s=(0,p.copy)(this._roots);this.clear({sync:!1});for(const e of[...s,t])if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!=this._all_models.size)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);e.config=t;for(const t of s)e.add_root(t);e.set_title(this._title)}freeze_all_models(e){this._push_all_models_freeze();try{e()}finally{this._pop_all_models_freeze()}}_push_all_models_freeze(){this._hold_models_freeze||(this._all_models_freeze_count+=1)}_pop_all_models_freeze(){this._hold_models_freeze||(this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models())}_cancel_recompute_all_models(){null!=this._recompute_timer&&(clearTimeout(this._recompute_timer),this._recompute_timer=null)}_schedule_recompute_all_models(){const e=this._recompute_timeout;isNaN(e)||e<=0?this._recompute_all_models():isFinite(e)&&(this._cancel_recompute_all_models(),this._recompute_timer=setTimeout((()=>{this._recompute_all_models()}),e))}_recompute_all_models(){this._cancel_recompute_all_models();let e=new Set;for(const t of this.all_roots)e=w.union(e,t.references());const t=new Set(this._all_models.values()),s=w.difference(t,e),o=w.difference(e,t),i=new Map;for(const t of e)i.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this),this._new_models.add(e);this._all_models=i}partially_update_all_models(e){const t=new Set;a.HasProps._value_record_references(e,t,{recursive:!1});for(const e of t)this._all_models.has(e.id)||(e.attach_document(this),this._new_models.add(e),this._all_models.set(e.id,e));this._schedule_recompute_all_models()}get all_roots(){const e=[...this._roots];return null!=this._config&&e.push(this._config),e}roots(){return this._roots}_add_roots(...e){if(0==(e=e.filter((e=>!this._roots.includes(e)))).length)return!1;this._push_all_models_freeze();try{this._roots.push(...e)}finally{this._pop_all_models_freeze()}return!0}_remove_root(e){const t=this._roots.indexOf(e);if(t<0)return!1;this._push_all_models_freeze();try{this._roots.splice(t,1)}finally{this._pop_all_models_freeze()}return!0}_set_title(e){const t=e!=this._title;return t&&(this._title=e),t}add_root(e,{sync:t}={}){if(this._add_roots(e)){const s=new M.RootAddedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}remove_root(e,{sync:t}={}){if(this._remove_root(e)){const s=new M.RootRemovedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}set_title(e,{sync:t}={}){if(this._set_title(e)){const s=new M.TitleChangedEvent(this,e);s.sync=t??!0,this._trigger_on_change(s)}}title(){return this._title}get_model_by_id(e){return this._all_models.get(e)??null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof k.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){this._message_callbacks.get(e)?.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof M.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_trigger_on_event(e){const t=this._document_callbacks.get(e.event_name);if(null!=t)for(const s of t)(0,y.execute)(s,this,e)}on_event(e,...t){const s=(0,f.isString)(e)?e:e.prototype.event_name,o=this._document_callbacks.get(s)??[],i=t;this._document_callbacks.set(s,[...o,...i])}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new h.Serializer({include_defaults:e}),s=t.encode(this.config),o=t.encode(this._roots);return{version:l.version,title:this._title,config:s,roots:o}}static from_json_string(e,t){const s=JSON.parse(e);return C.from_json(s,t)}static _handle_version(e){null==e.version&&r.logger.warn("'version' field is missing");const t=e.version??"0.0.0",s=m.Version.from(t),o=m.Version.from(l.version),i=`new document using Bokeh ${t} and BokehJS ${l.version}`;(0,g.is_equal)(s,o)?r.logger.debug(i):r.logger.warn(`Bokeh/BokehJS version mismatch: ${i}`)}static from_json(e,t){r.logger.debug("Creating Document from JSON"),C._handle_version(e);const s=new c.ModelResolver(n.default_resolver);if(null!=e.defs){new d.Deserializer(s).decode(e.defs)}const o=new C({resolver:s});o._push_all_models_freeze();const i=e=>t?.push(e);o.on_change(i,!0);const _=new d.Deserializer(s,o._all_models,(e=>e.attach_document(o))),l=_.decode(e.config);(0,b.assert)(l instanceof z.DocumentConfig||null==l),null!=l&&(o.config=l);const a=_.decode(e.roots),h=null!=e.callbacks?_.decode(e.callbacks):{};o.remove_on_change(i);for(const[e,t]of(0,v.entries)(h))o.on_event(e,...t);for(const e of a)o.add_root(e);return null!=e.title&&o.set_title(e.title),o._pop_all_models_freeze(),o}replace_with_json(e){C.from_json(e).destructively_move(this)}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new Map;for(const e of this._all_models.values())this._new_models.has(e)||t.set(e,e.ref());const s={events:new h.Serializer({references:t,binary:!0}).encode(e)};return this._new_models.clear(),s}apply_json_patch(e,t=new Map){const{_hold_models_freeze:s}=this;this._hold_models_freeze=!0;try{this._apply_json_patch(e,t)}finally{this._hold_models_freeze=s}this._schedule_recompute_all_models()}_apply_json_patch(e,t=new Map){const s=new d.Deserializer(this._resolver,this._all_models,(e=>{e.attach_document(this),this._new_models.add(e),this._all_models.set(e.id,e)})).decode(e.events,t);for(const e of s)switch(e.kind){case"MessageSent":{const{msg_type:t,msg_data:s}=e;this._trigger_on_message(t,s);break}case"ModelChanged":{const{model:t,attr:s,new:o}=e;t.setv({[s]:o},{sync:!1});break}case"ColumnDataChanged":{const{model:t,attr:s,data:o,cols:i}=e;if(null!=i){const e=(0,v.dict)(o),i=(0,v.dict)(t.property(s).get_value());for(const[t,s]of i)e.has(t)||e.set(t,s)}t.setv({data:o},{sync:!1,check_eq:!1});break}case"ColumnsStreamed":{const{model:t,attr:s,data:o,rollover:i}=e,_=t.property(s);t.stream_to(_,o,i,{sync:!1});break}case"ColumnsPatched":{const{model:t,attr:s,patches:o}=e,i=t.property(s);t.patch_to(i,o,{sync:!1});break}case"RootAdded":this.add_root(e.model,{sync:!1});break;case"RootRemoved":this.remove_root(e.model,{sync:!1});break;case"TitleChanged":this.set_title(e.title,{sync:!1});break;default:throw new Error(`unknown patch event type '${e.kind}'`)}}}s.Document=C,C.__name__="Document"},
function _(e,r,t,n,s){n(),t.register_models=function(e,r=!1){for(const s of(0,l.isArray)(e)?e:(0,o.values)(e))n=s,(0,l.isObject)(n)&&n.prototype instanceof u.HasProps&&t.default_resolver.register(s,r);var n};const l=e(8),o=e(9),i=e(8),u=e(15),f=e(47);t.default_resolver=new f.ModelResolver(null),t.Models=new Proxy(t.default_resolver,{get(e,r,t){if((0,i.isString)(r)){const t=e.get(r);if(null!=t)return t}return Reflect.get(e,r,t)},has(e,r){if((0,i.isString)(r)){if(null!=e.get(r))return!0}return Reflect.has(e,r)},ownKeys:e=>e.names,getOwnPropertyDescriptor(e,r){if((0,i.isString)(r)){const t=e.get(r);if(null!=t)return{configurable:!0,enumerable:!0,writable:!1,value:t}}return Reflect.getOwnPropertyDescriptor(e,r)}})},
function _(n,r,t,e,i){e(),t.is_undefined=function(n){return void 0===n},t.is_defined=function(n){return void 0!==n},t.is_nullish=u,t.isBoolean=c,t.isNumber=f,t.isInteger=function(n){return f(n)&&Number.isInteger(n)},t.isString=s,t.isSymbol=a,t.isPrimitive=function(n){return null===n||c(n)||f(n)||s(n)||a(n)},t.isFunction=function(n){switch(o.call(n)){case"[object Function]":case"[object AsyncFunction]":case"[object GeneratorFunction]":case"[object AsyncGeneratorFunction]":return!0;default:return!1}},t.isArray=l,t.isArrayOf=function(n,r){if(!l(n))return!1;for(const t of n)if(!r(t))return!1;return!0},t.isArrayableOf=function(n,r){if(!j(n))return!1;for(const t of n)if(!r(t))return!1;return!0},t.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},t.isObject=b,t.isBasicObject=function(n){return b(n)&&u(n.constructor)},t.isPlainObject=y,t.isDict=function(n){return n instanceof Map||y(n)},t.isIterable=A,t.isArrayable=j,t.is_ArrayBufferLike=function(n){return n instanceof ArrayBuffer||"undefined"!=typeof SharedArrayBuffer&&n instanceof SharedArrayBuffer};
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const{toString:o}=Object.prototype;function u(n){return null==n}function c(n){return!0===n||!1===n||"[object Boolean]"===o.call(n)}function f(n){return"[object Number]"===o.call(n)}function s(n){return"[object String]"===o.call(n)}function a(n){return"symbol"==typeof n}function l(n){return Array.isArray(n)}function b(n){const r=typeof n;return"function"===r||"object"===r&&!!n}function y(n){return b(n)&&(u(n.constructor)||n.constructor===Object)}function A(n){return b(n)&&Symbol.iterator in n}function j(n){return A(n)&&"length"in n}},
function _(e,t,n,s,i){var o;s(),n.to_object=function(e){return(0,r.isPlainObject)(e)?e:Object.fromEntries(e)},n.keys=a,n.values=u,n.entries=b,n.clone=function(e){return e instanceof Map?new Map(e):{...e}},n.merge=function(e,t){const n=new Map,s=[...e.keys(),...t.keys()];for(const i of s){const s=e.get(i),o=t.get(i),r=void 0===s?[]:s,a=void 0===o?[]:o;n.set(i,(0,c.union)(r,a))}return n},n.size=l,n.is_empty=function(e){return 0==l(e)},n.dict=function(e){return(0,r.isPlainObject)(e)?new h(e):e};const r=e(8),c=e(10);function a(e){return e instanceof Map?[...e.keys()]:Object.keys(e)}function u(e){return e instanceof Map?[...e.values()]:Object.values(e)}function b(e){return e instanceof Map?[...e.entries()]:Object.entries(e)}function l(e){return e instanceof Map?e.size:Object.keys(e).length}n.assign=Object.assign,n.extend=n.assign,n.typed_keys=Object.keys,n.typed_values=Object.values,n.typed_entries=Object.entries;const{hasOwnProperty:j}=Object.prototype;class h{constructor(e){this[o]="PlainObjectProxy",this.obj=e}clear(){for(const e of this.keys())delete this.obj[e]}delete(e){const t=this.has(e);return t&&delete this.obj[e],t}has(e){return j.call(this.obj,e)}get(e){return this.has(e)?this.obj[e]:void 0}set(e,t){return this.obj[e]=t,this}get size(){return l(this.obj)}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}*keys(){yield*a(this.obj)}*values(){yield*u(this.obj)}*entries(){yield*b(this.obj)}forEach(e,t){for(const[n,s]of this.entries())e.call(t,s,n,this)}}n.PlainObjectProxy=h,h.__name__="PlainObjectProxy"},
function _(n,t,e,r,o){r(),e.head=function(n){if(0!=n.length)return n[0];throw new Error("out of bounds access")},e.last=function(n){if(0!=n.length)return n[n.length-1];throw new Error("out of bounds access")},e.copy=a,e.concat=function(n){return[].concat(...n)},e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=(0,u.min)(n.map((n=>n.length))),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length;if(0==t)return[];const e=(0,u.min)(n.map((n=>n.length))),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=h,e.linspace=function(n,t,e=100){const r=1==e?0:(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+t*r;return o},e.logspace=function(n,t,e=100,r=10){const o=1==e?0:(t-n)/(e-1),c=new Array(e);for(let t=0;t<e;t++)c[t]=r**(n+t*o);return c},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return(0,u.min_by)(h(n.length),(t=>n[t]))},e.argmax=function(n){return(0,u.max_by)(h(n.length),(t=>n[t]))},e.argsort=function(n){const t=Array.from(n.keys());return t.sort(((t,e)=>n[t]-n[e])),t},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);(0,u.includes)(r,n)||(r.push(n),e.push(o))}return e},e._union=m,e.union=function(...n){return[...m(n)]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!(0,u.includes)(e,r)){for(const n of t)if(!(0,u.includes)(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=m(t);return(0,u.filter)(n,(n=>!e.has(n)))},e.symmetric_difference=function(n,t){const e=new Set(n),r=new Set(t),o=[];for(const n of e)r.has(n)||o.push(n);for(const n of r)e.has(n)||o.push(n);return o},e.remove_at=function(n,t){(0,i.assert)((0,s.isInteger)(t)&&t>=0);const e=a(n);return e.splice(t,1),e},e.remove=function(n,t){d(n,(n=>n==t))},e.remove_by=d,e.clear=function(n){n.splice(0,n.length)},e.split=function(n,t){const e=[],r=n.length;let o=0,c=0;for(;c<r;)n[c]===t?(e.push(n.slice(o,c)),o=++c):++c;return e.push(n.slice(o)),e},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=(0,c.randomIn)(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.elementwise=function(n,t,e){const r=Math.min(n.length,t.length),o=Array(r);for(let c=0;c<r;c++)o[c]=e(n[c],t[c]);return o},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){return new Array(t).fill(n)},e.resize=function(n,t,e){if(n.length>=t)return n.slice(0,t);{const r=new Array(t-n.length);return void 0!==e&&r.fill(e),n.concat(r)}};
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const c=n(11),i=n(12),s=n(8),u=n(13);var f=n(13);o("map",f.map),o("reduce",f.reduce),o("min",f.min),o("min_by",f.min_by),o("max",f.max),o("max_by",f.max_by),o("sum",f.sum),o("cumsum",f.cumsum),o("every",f.every),o("some",f.some),o("find",f.find),o("find_last",f.find_last),o("find_index",f.find_index),o("find_last_index",f.find_last_index),o("sorted_index",f.sorted_index),o("is_empty",f.is_empty),o("includes",f.includes),o("contains",f.contains),o("sort_by",f.sort_by);const{slice:l}=Array.prototype;function a(n){return l.call(n)}function h(n,t,e=1){(0,i.assert)(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:c}=Math,s=n<=t?e:-e,u=r(o(c(t-n)/e),0),f=new Array(u);for(let t=0;t<u;t++,n+=s)f[t]=n;return f}function m(n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return t}function d(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++}},
function _(n,t,r,o,e){o(),r.angle_norm=s,r.angle_dist=h,r.angle_between=function(n,t,r,o=!1){const e=h(t,r);if(0==e)return!1;if(e==2*u)return!0;const a=s(n),c=h(t,a)<=e&&h(a,r)<=e;return o?!c:c},r.randomIn=function(n,t){null==t&&(t=n,n=0);return n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(u/180)},r.degrees=function(n){return n/(u/180)},r.compute_angle=g,r.invert_angle=function(n,t,r="anticlock"){const o="anticlock"==r?1:-1;return-o*n/m(t)},r.to_radians_coeff=m,r.minmax=function(n,t){return n<=t?[n,t]:[t,n]},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.cycle=function(n,t,r){if(n>r)return t;if(n<t)return r;return n},r.log=function(n,t=Math.E){return Math.log(n)/Math.log(t)},r.gcd=_,r.lcm=function(n,...t){for(const r of t)n=Math.floor(n*r/_(n,r));return n},r.is_Floating=function(n){return(0,a.isObject)(n)&&r.float in n},r.factorial=M,r.hermite=function(n){const t=new Array(n+1);t.fill(0);const r=M(n);for(let o=0;o<=Math.floor(n/2);o++){const e=(-1)**o*r/(M(o)*M(n-2*o))*2**(n-2*o);t[2*o]=e}return t},r.eval_poly=function(n,t){const r=n.length-1;let o=0,e=1;for(let a=r;a>=0;a--)o+=e*n[a],e*=t;return o};const a=n(8),c=n(12),{PI:u,abs:i,sign:f,sqrt:l}=Math;function s(n){if(0==n)return 0;for(;n<=0;)n+=2*u;for(;n>2*u;)n-=2*u;return n}function h(n,t){return s(n-t)}function g(n,t,r="anticlock"){return-("anticlock"==r?1:-1)*n*m(t)}function m(n){switch(n){case"deg":return u/180;case"rad":return 1;case"grad":return u/200;case"turn":return 2*u}}function _(n,t){for(n=Math.abs(n),t=Math.abs(t);0!=t;)[n,t]=[t,n%t];return n}r.PI=u,r.abs=i,r.sqrt=l,r.resolve_angle=g,r.float=Symbol("float");class d{constructor(n,t){(0,c.assert)(0!=t,"Zero divisor");const r=_(n,t),o=f(n)*f(t);this.numer=o*i(n)/r,this.denom=i(t)/r}[r.float](){return this.numer/this.denom}toString(){return`${this.numer}/${this.denom}`}}function M(n){let t=1;for(let r=2;r<=n;r++)t*=r;return t}r.Fraction=d,d.__name__="Fraction",r.float32_epsilon=1.1920928955078125e-7},
function _(r,e,n,o,s){o(),n.assert=c,n.assert_debug=function(r,e){"undefined"!=typeof DEBUG&&DEBUG&&c(r,e)},n.unreachable=function(r){throw new t("unreachable code"+(null!=r?`: ${r}`:""))};class a extends Error{}n.AssertionError=a,a.__name__="AssertionError";class t extends Error{}function c(r,e){if(!(!0===r||!1!==r&&r()))throw new a(e??"Assertion failed")}n.UnreachableError=t,t.__name__="UnreachableError"},
function _(n,t,e,r,o){r(),e.is_empty=function(n){return 0==n.length},e.is_sorted=l,e.copy=s,e.splice=a,e.head=h,e.insert=function(n,t,e){return a(n,e,0,t)},e.append=function(n,t){return a(n,n.length,0,t)},e.prepend=function(n,t){return a(n,0,0,t)},e.index_of=function(n,t){return n.indexOf(t)},e.includes=g,e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.mul=function(n,t,e){const r=n.length,o=e??new n.constructor(r);for(let e=0;e<r;e++)o[e]=n[e]*t;return o},e.map=d,e.inplace_map=function(n,t,e){const r=n.length,o=e??n;for(let e=0;e<r;e++)o[e]=t(n[e],e)},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return h(r,o)},e.reduce=_,e.sort_by=function(n,t){const e=Array.from(n,((n,e)=>({index:e,key:t(n)})));return e.sort(((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r)return 1;if(e<r)return-1}return n.index-t.index})),d(n,((t,r)=>n[e[r].index]))},e.minmax2=function(n,t){let e,r,o=1/0,i=-1/0,c=1/0,u=-1/0;const f=Math.min(n.length,t.length);for(let l=0;l<f;l++)e=n[l],r=t[l],isNaN(e)||isNaN(r)||(e<o&&(o=e),e>i&&(i=e),r<c&&(c=r),r>u&&(u=r));return[o,i,c,u]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e,0);for(let o=1,i=n.length;o<i;o++){const i=n[o],c=t(i,o);c<r&&(e=i,r=c)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e,0);for(let o=1,i=n.length;o<i;o++){const i=n[o],c=t(i,o);c>r&&(e=i,r=c)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return _(n,((n,e,r)=>t[r]=n+e),0),t},e.every=function(n,t){for(const e of n)if(!t(e))return!1;return!0},e.some=function(n,t){for(const e of n)if(t(e))return!0;return!1},e.find=function(n,t){const r=(0,e.find_index)(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=(0,e.find_last_index)(n,t);return-1==r?void 0:n[r]},e.bisect_left_by=y,e.bisect_right_by=x,e.bisect_left=p,e.bisect_right=function(n,t,e=0,r){return x(n,t,(n=>n),e,r)},e.binary_search=function(n,t){const e=p(n,t);return e!=n.length&&n[e]==t?e:null},e.bin_counts=function(n,t){const r=t.length-1,o=Array(r).fill(0);for(let c=0;c<n.length;c++){const u=n[c],f=(0,e.sorted_index)(t,u);o[(0,i.clamp)(f-1,0,r-1)]+=1}return o},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)||0==t.length){o[i]=NaN;continue}const c=b(r,t);if(-1==c)o[i]=e[0];else if(c==t.length)o[i]=e[e.length-1];else if(c==t.length-1||t[c]==r)o[i]=e[c];else{const n=t[c],u=e[c],f=t[c+1],l=e[c+1];o[i]=w(r,n,u,f,l)}}return o},e.left_edge_index=b,e.norm=function(n,t,e){const r=e-t;return d(n,(n=>(n-t)/r))};const i=n(11),c=n(12);var u=n(14);o("min",u.min),o("max",u.max),o("minmax",u.minmax);const{floor:f}=Math;function l(n){const t=n.length;if(0==t)return!0;let e=n[0];for(let r=1;r<t;r++){const t=n[r];if(!(e<=t))return!1;e=t}return!0}function s(n){return Array.isArray(n)?n.slice():new n.constructor(n)}function a(n,t,e,...r){if(Array.isArray(n)){const o=s(n);return void 0===e?o.splice(t):o.splice(t,e,...r),o}const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,c=new n.constructor(i);let u=0;for(;u<t;u++)c[u]=n[u];for(const n of r)c[u++]=n;for(let r=t+e;r<o;r++)c[u++]=n[r];return c}function h(n,t){return a(n,t,n.length-t)}function g(n,t){return-1!==n.indexOf(t)}function d(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function _(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function m(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function y(n,t,e,r=0,o=n.length){for((0,c.assert_debug)((()=>l(n))),(0,c.assert)(0<=r&&o<=n.length);r<o;){const i=f((r+o)/2);e(n[i])<t?r=i+1:o=i}return r}function x(n,t,e,r=0,o=n.length){for((0,c.assert_debug)((()=>l(n))),(0,c.assert)(0<=r&&o<=n.length);r<o;){const i=f((r+o)/2);e(n[i])<=t?r=i+1:o=i}return r}function p(n,t,e=0,r){return y(n,t,(n=>n),e,r)}function w(n,t,e,r,o){const i=(o-e)/(r-t);let c=i*(n-t)+e;return isFinite(c)||(c=i*(n-r)+o,isFinite(c)||e!=o||(c=e)),c}function b(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;if(1==t.length)return 0;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.contains=g,e.find_index=m(1),e.find_last_index=m(-1),e.sorted_index=p},
function _(n,o,t,e,f){e(),t.iter=function*(n){(0,r.isIterable)(n)?yield*n:yield n},t.range=l,t.reverse=function*(n){const o=n.length;for(let t=0;t<o;t++)yield n[o-t-1]},t.enumerate=function*(n){let o=0;for(const t of n)yield[t,o++]},t.take=function*(n,o){(0,i.assert)(o>=0);let t=0;for(const e of n){if(!(t++<o))break;yield e}},t.skip=c,t.tail=function*(n){yield*c(n,1)},t.join=function*(n,o){let t=!0;for(const e of n)t?t=!1:null!=o&&(yield o()),yield*e},t.zip=function*(n,o){const t=n[Symbol.iterator](),e=o[Symbol.iterator]();for(;;){const n=t.next(),o=e.next();if(!0===n.done||!0===o.done)break;yield[n.value,o.value]}},t.interleave=function*(n,o){let t=!0;for(const e of n)t?t=!1:yield o(),yield e},t.map=function*(n,o){let t=0;for(const e of n)yield o(e,t++)},t.flat_map=function*(n,o){let t=0;for(const e of n)yield*o(e,t++)},t.filter=function*(n,o){let t=0;for(const e of n)o(e,t++)&&(yield e)},t.no_repeated=function*(n){let o=s;for(const t of n)t!==o&&(yield t),o=t},t.every=function(n,o){for(const t of n)if(!o(t))return!1;return!0},t.some=function(n,o){for(const t of n)if(o(t))return!0;return!1},t.combinations=u,t.subsets=function*(n){for(const o of l(n.length+1))yield*u(n,o)},t.min=function(n){let o=1/0;for(const t of n)!isNaN(t)&&t<o&&(o=t);return o},t.max=function(n){let o=-1/0;for(const t of n)!isNaN(t)&&t>o&&(o=t);return o},t.minmax=function(n){let o=1/0,t=-1/0;for(const e of n)isNaN(e)||(e<o&&(o=e),e>t&&(t=e));return[o,t]};const i=n(12),r=n(8);function*l(n,o,t=1){(0,i.assert)(t>0);const{abs:e,ceil:f,max:r}=Math;null==o&&(o=n,n=0);const l=n<=o?t:-t,c=r(f(e(o-n)/e(t)),0);for(let o=0;o<c;o++,n+=l)yield n}function*c(n,o){(0,i.assert)(o>=0);for(const t of n)0==o?yield t:o-=1}const s=Symbol("nothing");function*u(n,o){const t=n.length;if(o>t)return;const e=[...l(o)];for(yield e.map((o=>n[o]));;){let f;for(const n of l(o-1,-1))if(e[n]!=n+t-o){f=n;break}if(null==f)return;e[f]+=1;for(const n of l(f+1,o))e[n]=e[n-1]+1;yield e.map((o=>n[o]))}}},
function _(t,e,s,i,n){var r;i();const o=t(1),c=t(16),a=t(18),h=o.__importStar(t(19)),_=o.__importStar(t(22)),p=t(12),u=t(41),l=t(9),f=t(8),d=t(33),g=t(42),y=t(27),m=t(43),v=t(32),w=o.__importStar(t(22)),b=t(29),$=t(44),S=new WeakMap;class x extends((0,c.Signalable)()){get is_syncable(){return!0}get type(){return this.constructor.__qualified__}static get __qualified__(){let t=S.get(this);if(null==t){const{__module__:e,__name__:s}=this;t=null!=e?`${e}.${s}`:s,S.set(this,t)}return t}static set __qualified__(t){S.set(this,t)}get[Symbol.toStringTag](){return this.constructor.__qualified__}static _fix_default(t,e){if(void 0===t||t===h.unset)return()=>h.unset;if((0,f.isFunction)(t))return t;if((0,f.isPrimitive)(t))return()=>t;{const e=new v.Cloner;return()=>e.clone(t)}}static define(t){for(const[e,s]of(0,l.entries)((0,f.isFunction)(t)?t(w):t)){if(e in this.prototype._props)throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(e in this.prototype)throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,i,n={}]=s,r={type:t,default_value:this._fix_default(i,e),options:n};this.prototype._props={...this.prototype._props,[e]:r}}}static internal(t){const e={};for(const[s,i]of(0,l.entries)((0,f.isFunction)(t)?t(w):t)){const[t,n,r={}]=i;e[s]=[t,n,{...r,internal:!0}]}this.define(e)}static mixins(t){function e(t,e){const s={};for(const[i,n]of(0,l.entries)(e))s[t+i]=n;return s}const s={},i=[];for(const n of(0,f.isArray)(t)?t:[t])if((0,f.isArray)(n)){const[t,r]=n;(0,l.extend)(s,e(t,r)),i.push([t,r])}else{const t=n;(0,l.extend)(s,t),i.push(["",t])}this.define(s),this.prototype._mixins=[...this.prototype._mixins,...i]}static override(t){for(const[e,s]of(0,l.entries)(t)){const t=this._fix_default(s,e);if(!(e in this.prototype._props))throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const i=this.prototype._props[e],n={...this.prototype._props};n[e]={...i,default_value:t},this.prototype._props=n}}static override_options(t){for(const[e,s]of(0,l.entries)(t)){if(!(e in this.prototype._props))throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const t=this.prototype._props[e],i={...this.prototype._props,[e]:{...t,options:{...t.options,...s}}};this.prototype._props=i}}static toString(){return this.__qualified__}toString(){return`${this.type}(${this.id})`}property(t){if(t in this.properties)return this.properties[t];throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)e.is_unset||(t[e.attr]=e.get_value());return t}get dirty_attributes(){const t={};for(const e of this)!e.is_unset&&e.dirty&&(t[e.attr]=e.get_value());return t}[v.clone](t){const e=new Map;for(const s of this)s.dirty&&e.set(s.attr,t.clone(s.get_value()));return new this.constructor(e)}[y.equals](t,e){for(const s of this){const i=t.property(s.attr);if(!e.eq(s.get_value(),i.get_value()))return!1}return!0}[m.pretty](t){const e=t.token,s=[];for(const i of this)if(i.dirty){const n=i.get_value();s.push(`${i.attr}${e(":")} ${t.to_string(n)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${s.join(`${e(",")} `)}${e("}")}${e(")")}`}[d.serialize](t){const e=this.ref();t.add_ref(this,e);const s={};for(const e of this)if(e.syncable&&(t.include_defaults||e.dirty)&&(!e.readonly||!e.is_unset)){const i=e.get_value();s[e.attr]=t.encode(i)}const{type:i,id:n}=this,r={type:"object",name:i,id:n};return(0,l.is_empty)(s)?r:{...r,attributes:s}}constructor(t={}){super(),this.document=null,this.destroyed=new c.Signal0(this,"destroyed"),this.change=new c.Signal0(this,"change"),this.transformchange=new c.Signal0(this,"transformchange"),this.exprchange=new c.Signal0(this,"exprchange"),this.streaming=new c.Signal0(this,"streaming"),this.patching=new c.Signal(this,"patching"),this.properties={},this._watchers=new WeakMap,this._pending=!1,this._changing=!1;const e=(0,f.isPlainObject)(t)&&"id"in t;this.id=e?t.id:(0,u.unique_id)();for(const[t,{type:e,default_value:s,options:i}]of(0,l.entries)(this._props)){let n;if(e instanceof h.PropertyAlias){const s=this.properties[e.attr];if(void 0===s)throw new Error(`can't resolve ${e.attr} before ${t} to create an alias`);Object.defineProperty(this.properties,t,{get:()=>s,configurable:!1,enumerable:!1})}else n=e instanceof _.Kind?new h.PrimitiveProperty(this,t,e,s,i):new e(this,t,_.Any,s,i),this.properties[t]=n}e?(0,p.assert)(1==(0,l.keys)(t).length,"'id' cannot be used together with property initializers"):(this.initialize_props(t),this.finalize(),this.connect_signals())}initialize_props(t){const e=(0,l.dict)(t),s=new Set;for(const t of this){const i=e.get(t.attr);t.initialize(i),s.add(t.attr)}for(const[t,i]of e)s.has(t)||this.property(t).set_value(i)}finalize(){this.initialize()}initialize(){}assert_initialized(){for(const t of this)t.syncable&&!t.readonly&&t.get_value()}connect_signals(){for(const t of this){if(!(t instanceof h.VectorSpec||t instanceof h.ScalarSpec))continue;if(t.is_unset)continue;const e=t.get_value();null!=e.transform&&this.connect(e.transform.change,(()=>this.transformchange.emit())),(0,b.isExpr)(e)&&this.connect(e.expr.change,(()=>this.exprchange.emit()))}}disconnect_signals(){c.Signal.disconnect_receiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(t){const e=(new v.Cloner).clone(this);return null!=t&&e.setv(t),e}_clear_watchers(){this._watchers=new WeakMap}changed_for(t){const e=this._watchers.get(t);return this._watchers.set(t,!1),e??!0}_setv(t,e){const s=e.check_eq,i=new Set,n=this._changing;this._changing=!0;for(const[e,n]of t)!1!==s&&!e.is_unset&&(0,y.is_equal)(e.get_value(),n)||(e.set_value(n),i.add(e));i.size>0&&(this._clear_watchers(),this._pending=!0);for(const t of i)t.change.emit();if(!n){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}return i}setv(t,e={}){const s=(0,l.entries)(t);if(0==s.length)return;if(e.silent){this._clear_watchers();for(const[t,e]of s)this.properties[t].set_value(e);return}const i=new Map,n=new Map;for(const[t,e]of s){const s=this.properties[t];i.set(s,e),n.set(s,s.is_unset?void 0:s.get_value())}const r=this._setv(i,e),{document:o}=this;if(null!=o){const t=[];for(const[e,s]of n)r.has(e)&&t.push([e,s,e.get_value()]);for(const[e,s,i]of t)if(e.may_have_refs){o.partially_update_all_models(i);break}const s=e.sync??!0;this._push_changes(t,s)}}ref(){return{id:this.id}}*[Symbol.iterator](){yield*(0,l.values)(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}*own_properties(){const t=Object.getPrototypeOf(this),e=Object.getPrototypeOf(t),s=new Set((0,l.keys)(e._props));for(const t of this)s.has(t.attr)||(yield t)}static _value_record_references(t,e,s){if(!(0,f.isObject)(t)||!(0,a.may_have_refs)(t))return;const{recursive:i}=s;if(t instanceof r){if(!e.has(t)&&(e.add(t),i))for(const s of t.syncable_properties())if(!s.is_unset&&s.may_have_refs){const t=s.get_value();r._value_record_references(t,e,{recursive:i})}}else if((0,f.isIterable)(t))for(const s of t)r._value_record_references(s,e,{recursive:i});else if((0,f.isPlainObject)(t))for(const s of(0,l.values)(t))r._value_record_references(s,e,{recursive:i})}static references(t,e){const s=new Set;return r._value_record_references(t,s,e),s}references(){return r.references(this,{recursive:!0})}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document){if(this.document==t)return;throw new Error("models must be owned by only a single document")}this.document=t,this._doc_attached()}detach_document(){null!=this.document&&(this._doc_detached(),this.document=null)}_push_changes(t,e){if(!this.is_syncable)return;const{document:s}=this;if(null==s)return;const i=[];for(const[n,,r]of t)if(n.syncable){const t=new g.ModelChangedEvent(s,this,n.attr,r);t.sync=e,i.push(t)}if(0!=i.length){let t;1==i.length?[t]=i:t=new g.DocumentEventBatch(s,i),s._trigger_on_change(t)}}on_change(t,e){for(const s of(0,f.isArray)(t)?t:[t])this.connect(s.change,e)}stream_to(t,e,s,{sync:i}={}){const n=t.get_value();if((0,$.stream_to_columns)(n,e,s),this._clear_watchers(),t.set_value(n),this.streaming.emit(),null!=this.document){const n=new g.ColumnsStreamedEvent(this.document,this,t.attr,e,s);n.sync=i??!0,this.document._trigger_on_change(n)}}patch_to(t,e,{sync:s}={}){const i=t.get_value(),n=(0,$.patch_to_columns)(i,e);if(this._clear_watchers(),t.set_value(i),this.patching.emit([...n]),null!=this.document){const i=new g.ColumnsPatchedEvent(this.document,this,t.attr,e);i.sync=s??!0,this.document._trigger_on_change(i)}}}s.HasProps=x,(r=x).prototype._props={},r.prototype._mixins=[]},
function _(n,e,t,s,r){s(),t.Signalable=function(){return class{connect(n,e){return n.connect(e,this)}disconnect(n,e){return n.disconnect(e,this)}}};const l=n(17),i=n(10);class o{constructor(n,e){this.sender=n,this.name=e}connect(n,e=null){t.receivers_for_sender.has(this.sender)||t.receivers_for_sender.set(this.sender,[]);const s=t.receivers_for_sender.get(this.sender);if(null!=f(s,this,n,e))return!1;const r=e??n;u.has(r)||u.set(r,[]);const l=u.get(r),i={signal:this,slot:n,context:e};return s.push(i),l.push(i),!0}disconnect(n,e=null){const s=t.receivers_for_sender.get(this.sender);if(null==s||0===s.length)return!1;const r=f(s,this,n,e);if(null==r)return!1;const l=e??n,i=u.get(l);return r.signal=null,g(s),g(i),!0}emit(n){const e=t.receivers_for_sender.get(this.sender)??[];for(const{signal:t,slot:s,context:r}of e)t===this&&s.call(r,n,this.sender)}}t.Signal=o,o.__name__="Signal";class c extends o{emit(){super.emit(void 0)}}t.Signal0=c,c.__name__="Signal0",function(n){n.disconnect_between=function(n,e){const s=t.receivers_for_sender.get(n);if(null==s||0===s.length)return;const r=u.get(e);if(null!=r&&0!==r.length){for(const e of r){if(null==e.signal)return;e.signal.sender===n&&(e.signal=null)}g(s),g(r)}},n.disconnect_sender=function(n){const e=t.receivers_for_sender.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=n.context??n.slot;n.signal=null,g(u.get(e))}g(e)}},n.disconnect_receiver=function(n,e,s){const r=u.get(n);if(null!=r&&0!==r.length){for(const n of r){if(null==n.signal)return;if(null!=e&&n.slot!=e)continue;const r=n.signal.sender;null!=s&&s.has(r)||(n.signal=null,g(t.receivers_for_sender.get(r)))}g(r)}},n.disconnect_all=function(n){const e=t.receivers_for_sender.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;g(e)}const s=u.get(n);if(null!=s&&0!==s.length){for(const n of s)n.signal=null;g(s)}}}(o||(t.Signal=o={})),t.receivers_for_sender=new WeakMap;const u=new WeakMap;function f(n,e,t,s){return(0,i.find)(n,(n=>n.signal===e&&n.slot===t&&n.context===s))}const a=new Set;function g(n){0==a.size&&(async()=>{await(0,l.defer)(),function(){for(const n of a)(0,i.remove_by)(n,(n=>null==n.signal));a.clear()}()})(),a.add(n)}},
function _(e,n,t,o,r){o(),t.defer=function(){return new Promise((e=>{const n=a++;i.set(n,e),s.port2.postMessage(n)}))},t.delay=l,t.poll=async function(e,n=50,t=500){for(;!e()&&t>=0;)await l(n),t-=n},t.paint=function(){return new Promise((e=>{requestAnimationFrame((()=>e()))}))},t.idle=function(){return new Promise((e=>{requestIdleCallback((()=>e()))}))};const s=new MessageChannel,i=new Map;s.port1.onmessage=e=>{const n=e.data,t=i.get(n);if(null!=t)try{t()}finally{i.delete(n)}};let a=1;function l(e){return new Promise((n=>setTimeout(n,e)))}},
function _(n,r,s,e,t){e(),s.is_ref=function(n){return(0,i.isPlainObject)(n)&&"id"in n&&!("type"in n)},s.is_HasRefs=u,s.may_have_refs=function(n){if(f(n))return n[s.has_refs];const r=n.constructor;if(u(r))return r[s.has_refs];return!0};const i=n(8);function f(n){return s.has_refs in n}function u(n){return(0,i.isObject)(n)&&f(n)}s.has_refs=Symbol("has_refs")},
function _(e,t,r,n,a){n(),r.TextBaselineSpec=r.TextAlignSpec=r.FontStyleSpec=r.FontSizeSpec=r.FontSpec=r.LineDashSpec=r.LineCapSpec=r.LineJoinSpec=r.MarkerSpec=r.ExtMarkerType=r.ArraySpec=r.NullStringSpec=r.StringSpec=void 0,r.isSpec=C,r.use_theme=function(e=null){F=e},r.Alias=function(e){return new E(e)};const s=e(1),i=e(16),l=e(20),_=s.__importStar(e(21)),o=e(25),c=e(10),u=e(13),d=e(11),S=e(23),p=e(28),h=e(8),m=e(29),f=e(30),v=e(22),y=e(31),x=e(39),g=e(12),w=e(33),A=e(40);a("Uniform",A.Uniform),a("UniformScalar",A.UniformScalar),a("UniformVector",A.UniformVector);class z extends Error{}function b(e){try{return JSON.stringify(e)}catch{return e.toString()}}function C(e){return(0,h.isPlainObject)(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}r.ValidationError=z,z.__name__="ValidationError";let F=null;r.unset=Symbol("unset");class q extends Error{}r.UnsetValueError=q,q.__name__="UnsetValueError";class N{get syncable(){return!this.internal}get is_unset(){return this._value===r.unset}get initialized(){return this._initialized}initialize(e=r.unset){if(this._initialized)throw new Error("already initialized");let t=r.unset;if(e!==r.unset)t=e,this._dirty=!0;else{const e=this._default_override();if(e!==r.unset)t=e;else{let e=!1;if(null!=F){const r=F.get(this.obj,this.attr);void 0!==r&&(t=r,e=!0)}e||(t=this.default_value(this.obj))}}t!==r.unset?(null!=this.kind.coerce&&(t=this.kind.coerce(t)),this._update(t)):this._value=r.unset,this._initialized=!0}get_value(){if(this._value!==r.unset)return this._value;throw new q(`${this.obj}.${this.attr} is unset`)}set_value(e){this._initialized?(this._update(e),this._dirty=!0):this.initialize(e),x.diagnostics.report(this)}_default_override(){return r.unset}get dirty(){return this._dirty}constructor(e,t,n,a,s={}){this._value=r.unset,this._initialized=!1,this._dirty=!1,this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this.change=new i.Signal0(this.obj,"change"),this.internal=s.internal??!1,this.readonly=s.readonly??!1,this.convert=s.convert,this.on_update=s.on_update,this.may_have_refs=n.may_have_refs()}_update(e){if(this.validate(e),null!=this.convert){const t=this.convert(e,this.obj);void 0!==t&&(e=t)}this._value=e,this.on_update?.(e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, value: ${b(this._value)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new z(`${this.obj}.${this.attr} given invalid value: ${b(e)}`)}valid(e){return this.kind.valid(e)}}r.Property=N,N.__name__="Property";class E{constructor(e){this.attr=e}}r.PropertyAlias=E,E.__name__="PropertyAlias";class U extends N{}r.PrimitiveProperty=U,U.__name__="PrimitiveProperty";class $ extends U{_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.Font=$,$.__name__="Font";class j extends N{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(C(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[w.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}uniform(e){const t=this.get_value(),r=e.get_length()??1;if((0,m.isExpr)(t)){const{expr:n,transform:a}=t;let s=n.compute(e);return null!=a&&(s=a.compute(s)),s=this.materialize(s),this.scalar(s,r)}{const{value:e,transform:n}=t;let a=e;return null!=n&&(a=n.compute(a)),a=this.materialize(a),this.scalar(a,r)}}}r.ScalarSpec=j,j.__name__="ScalarSpec";class B extends j{}r.AnyScalar=B,B.__name__="AnyScalar";class D extends j{}r.DictScalar=D,D.__name__="DictScalar";class L extends j{}r.ColorScalar=L,L.__name__="ColorScalar";class T extends j{}r.NumberScalar=T,T.__name__="NumberScalar";class P extends j{}r.StringScalar=P,P.__name__="StringScalar";class V extends j{}r.NullStringScalar=V,V.__name__="NullStringScalar";class k extends j{}r.ArrayScalar=k,k.__name__="ArrayScalar";class J extends j{}r.LineJoinScalar=J,J.__name__="LineJoinScalar";class X extends j{}r.LineCapScalar=X,X.__name__="LineCapScalar";class Y extends j{}r.LineDashScalar=Y,Y.__name__="LineDashScalar";class M extends j{_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.FontScalar=M,M.__name__="FontScalar";class G extends j{}r.FontSizeScalar=G,G.__name__="FontSizeScalar";class I extends j{}r.FontStyleScalar=I,I.__name__="FontStyleScalar";class O extends j{}r.TextAlignScalar=O,O.__name__="TextAlignScalar";class R extends j{}r.TextBaselineScalar=R,R.__name__="TextBaselineScalar";class H extends N{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(C(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[w.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}v_materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}vector(e){return new A.UniformVector(e)}uniform(e){const t=this.get_value(),r=e.get_length()??1;if((0,m.isField)(t)){const{field:n,transform:a}=t;let s=e.get_column(n);if(null!=s)return null!=a&&(s=a.v_compute(s)),s=this.v_materialize(s),this.vector(s);{const e=`attempted to retrieve property array for nonexistent field '${n}'`;if(f.settings.force_fields)throw new Error(e);return l.logger.warn(e),this.scalar(null,r)}}if((0,m.isExpr)(t)){const{expr:r,transform:n}=t;let a=r.v_compute(e);return null!=n&&(a=n.v_compute(a)),a=this.v_materialize(a),this.vector(a)}if((0,m.isValue)(t)){const{value:e,transform:n}=t;let a=e;return null!=n&&(a=n.compute(a)),a=this.materialize(a),this.scalar(a,r)}(0,g.unreachable)()}array(e){let t;const r=e.get_length()??1,n=this.get_value();if((0,m.isField)(n)){const{field:a}=n,s=e.get_column(a);if(null!=s)t=this.normalize(s);else{const e=`attempted to retrieve property array for nonexistent field '${a}'`;if(f.settings.force_fields)throw new Error(e);l.logger.warn(e);const n=new Float64Array(r);n.fill(NaN),t=n}}else if((0,m.isExpr)(n)){const{expr:r}=n;t=this.normalize(r.v_compute(e))}else{const e=this.normalize([n.value])[0];if((0,h.isNumber)(e)){const n=new Float64Array(r);n.fill(e),t=n}else t=(0,c.repeat)(e,r)}const{transform:a}=n;return null!=a&&(t=a.v_compute(t)),t}}r.VectorSpec=H,H.__name__="VectorSpec";class K extends H{}r.DataSpec=K,K.__name__="DataSpec";class Q extends H{constructor(){super(...arguments),this._value=r.unset}_update(e){if(super._update(e),this._value!==r.unset){const{units:e}=this._value;if(null!=e&&!(0,c.includes)(this.valid_units,e))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${e}`)}}get units(){return this._value!==r.unset?this._value.units??this.default_units:this.default_units}set units(e){if(this._value===r.unset)throw new Error(`${this.obj}.${this.attr} is unset`);e!=this.default_units?this._value.units=e:delete this._value.units}}r.UnitsSpec=Q,Q.__name__="UnitsSpec";class W extends Q{array(e){return new Float64Array(super.array(e))}}r.NumberUnitsSpec=W,W.__name__="NumberUnitsSpec";class Z extends K{}r.BaseCoordinateSpec=Z,Z.__name__="BaseCoordinateSpec";class ee extends Z{}r.CoordinateSpec=ee,ee.__name__="CoordinateSpec";class te extends Z{}r.CoordinateSeqSpec=te,te.__name__="CoordinateSeqSpec";class re extends Z{}r.CoordinateSeqSeqSeqSpec=re,re.__name__="CoordinateSeqSeqSeqSpec";class ne extends ee{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSpec=ne,ne.__name__="XCoordinateSpec";class ae extends ee{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSpec=ae,ae.__name__="YCoordinateSpec";class se extends te{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSpec=se,se.__name__="XCoordinateSeqSpec";class ie extends te{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSpec=ie,ie.__name__="YCoordinateSeqSpec";class le extends re{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSeqSeqSpec=le,le.__name__="XCoordinateSeqSeqSeqSpec";class _e extends re{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSeqSeqSpec=_e,_e.__name__="YCoordinateSeqSeqSeqSpec";class oe extends W{get default_units(){return"rad"}get valid_units(){return[..._.AngleUnits]}materialize(e){return e*-(0,d.to_radians_coeff)(this.units)}v_materialize(e){const t=-(0,d.to_radians_coeff)(this.units),r=new Float32Array(e.length);return(0,u.mul)(e,t,r),r}array(e){throw new Error("not supported")}}r.AngleSpec=oe,oe.__name__="AngleSpec";class ce extends W{get default_units(){return"data"}get valid_units(){return[..._.SpatialUnits]}}r.DistanceSpec=ce,ce.__name__="DistanceSpec";class ue extends ce{materialize(e){return e??NaN}}r.NullDistanceSpec=ue,ue.__name__="NullDistanceSpec";class de extends K{v_materialize(e){return new Uint8Array(e)}array(e){return new Uint8Array(super.array(e))}}r.BooleanSpec=de,de.__name__="BooleanSpec";class Se extends K{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Int32Array(e)}array(e){return new Int32Array(super.array(e))}}r.IntSpec=Se,Se.__name__="IntSpec";class pe extends K{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Float64Array(e)}array(e){return new Float64Array(super.array(e))}}r.NumberSpec=pe,pe.__name__="NumberSpec";class he extends pe{valid(e){return(0,h.isNumber)(e)&&e>=0}}r.ScreenSizeSpec=he,he.__name__="ScreenSizeSpec";class me extends K{materialize(e){return(0,S.encode_rgba)((0,S.color2rgba)(e))}v_materialize(e){if(!(0,y.is_NDArray)(e))return this._from_css_array(e);if("uint32"==e.dtype&&1==e.dimension)return(0,p.to_big_endian)(e);if("uint8"==e.dtype&&1==e.dimension){const[t]=e.shape,r=new o.RGBAArray(4*t);let n=0;for(const t of e)r[n++]=t,r[n++]=t,r[n++]=t,r[n++]=255;return new o.ColorArray(r.buffer)}if("uint8"==e.dtype&&2==e.dimension){const[t,r]=e.shape;if(4==r)return new o.ColorArray(e.buffer);if(3==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=e[a++],n[s++]=e[a++],n[s++]=e[a++],n[s++]=255;return new o.ColorArray(n.buffer)}}else if("float32"!=e.dtype&&"float64"!=e.dtype||2!=e.dimension){if("object"==e.dtype&&1==e.dimension)return this._from_css_array(e)}else{const[t,r]=e.shape;if(3==r||4==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*(3==r?1:e[a++]);return new o.ColorArray(n.buffer)}}throw new Error("invalid color array")}_from_css_array(e){const t=e.length,r=new o.RGBAArray(4*t);let n=0;for(const t of e){const[e,a,s,i]=(0,S.color2rgba)(t);r[n++]=e,r[n++]=a,r[n++]=s,r[n++]=i}return new o.ColorArray(r.buffer)}vector(e){return new A.ColorUniformVector(e)}}r.ColorSpec=me,me.__name__="ColorSpec";class fe extends K{}r.NDArraySpec=fe,fe.__name__="NDArraySpec";class ve extends K{}r.AnySpec=ve,ve.__name__="AnySpec";class ye extends K{}r.StringSpec=ye,ye.__name__="StringSpec";class xe extends K{}r.NullStringSpec=xe,xe.__name__="NullStringSpec";class ge extends K{}r.ArraySpec=ge,ge.__name__="ArraySpec",r.ExtMarkerType=(0,v.PrefixedStr)("@");class we extends K{}r.MarkerSpec=we,we.__name__="MarkerSpec";class Ae extends K{}r.LineJoinSpec=Ae,Ae.__name__="LineJoinSpec";class ze extends K{}r.LineCapSpec=ze,ze.__name__="LineCapSpec";class be extends K{}r.LineDashSpec=be,be.__name__="LineDashSpec";class Ce extends K{_default_override(){return f.settings.dev?"Bokeh":r.unset}}r.FontSpec=Ce,Ce.__name__="FontSpec";class Fe extends K{}r.FontSizeSpec=Fe,Fe.__name__="FontSizeSpec";class qe extends K{}r.FontStyleSpec=qe,qe.__name__="FontStyleSpec";class Ne extends K{}r.TextAlignSpec=Ne,Ne.__name__="TextAlignSpec";class Ee extends K{}r.TextBaselineSpec=Ee,Ee.__name__="TextBaselineSpec"},
function _(e,l,o,t,n){t(),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}};const g=e(8),r=e(9),s=e(3),i={};class v{constructor(e,l,o){this.name=e,this.level=l,this.method=o}}o.LogLevel=v,v.__name__="LogLevel";class _{static get levels(){return Object.keys(_.log_levels)}static get(e,l=_.INFO){if(e.length>0)return e in i?i[e]:i[e]=new _(e,l);throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}constructor(e,l=_.INFO){this._name=e,this.set_level(l)}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof v)this._log_level=e;else{if(!_.log_levels.hasOwnProperty(e))throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=_.log_levels[e]}const l=`[${this._name}]`;for(const{level:e,method:o}of(0,r.values)(_.log_levels))e<this._log_level.level||this._log_level.level===_.OFF.level?this[o]=function(){}:this[o]=a(o,l);this.log=a("log",l)}log(...e){}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function a(e,l){const o=console[e];return(void 0!==o?o:console.log).bind(console,l)}function c(e){const l=o.logger.level;return(0,g.isString)(e)&&!(e in _.log_levels)?(o.logger.log(`unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),o.logger.log(`valid log levels are: ${_.levels.join(", ")}`)):(o.logger.log(`setting log level to: '${(0,g.isString)(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=_,_.__name__="Logger",_.TRACE=new v("trace",0,"trace"),_.DEBUG=new v("debug",1,"debug"),_.INFO=new v("info",2,"info"),_.WARN=new v("warn",6,"warn"),_.ERROR=new v("error",7,"error"),_.FATAL=new v("fatal",8,"error"),_.OFF=new v("off",9,"log"),_.log_levels={trace:_.TRACE,debug:_.DEBUG,info:_.INFO,warn:_.WARN,error:_.ERROR,fatal:_.FATAL,off:_.OFF},o.logger=_.get(`bokeh ${s.version}`)},
function _(e,o,n,t,i){t(),n.ToolName=n.ToolIcon=n.WindowAxis=n.VerticalAlign=n.UpdateMode=n.TooltipAttachment=n.LabelOrientation=n.TimedeltaResolutionType=n.TextureRepetition=n.TextBaseline=n.TextAlign=n.TapGesture=n.TapBehavior=n.StepMode=n.StartEnd=n.SpatialUnits=n.Sort=n.SizingMode=n.Side=n.SelectionMode=n.RegionSelectionMode=n.ScrollbarPolicy=void 0;const a=e(22);n.Align=(0,a.Enum)("start","center","end"),n.HAlign=(0,a.Enum)("left","center","right"),n.VAlign=(0,a.Enum)("top","center","bottom"),n.Anchor=(0,a.Enum)("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),n.AngleUnits=(0,a.Enum)("deg","rad","grad","turn"),n.AlternationPolicy=(0,a.Enum)("none","even","odd","every"),n.AxisLabelStandoffMode=(0,a.Enum)("tick_labels","axis"),n.BoxOrigin=(0,a.Enum)("corner","center"),n.ButtonType=(0,a.Enum)("default","primary","success","warning","danger","light"),n.CalendarPosition=(0,a.Enum)("auto","above","below"),n.Clock=(0,a.Enum)("12h","24h"),n.CoordinateUnits=(0,a.Enum)("canvas","screen","data"),n.ContextWhich=(0,a.Enum)("start","center","end","all"),n.Dimension=(0,a.Enum)("width","height"),n.Dimensions=(0,a.Enum)("width","height","both"),n.Direction=(0,a.Enum)("clock","anticlock"),n.Distribution=(0,a.Enum)("uniform","normal"),n.Face=(0,a.Enum)("front","back"),n.FlowMode=(0,a.Enum)("block","inline"),n.FontStyle=(0,a.Enum)("normal","italic","bold","bold italic"),n.HatchPatternType=(0,a.Enum)("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),n.BuiltinFormatter=(0,a.Enum)("raw","basic","numeral","printf","datetime"),n.HTTPMethod=(0,a.Enum)("POST","GET"),n.HexTileOrientation=(0,a.Enum)("pointytop","flattop"),n.HoverMode=(0,a.Enum)("mouse","hline","vline"),n.ImageOrigin=(0,a.Enum)("bottom_left","top_left","bottom_right","top_right"),n.LatLon=(0,a.Enum)("lat","lon"),n.LegendClickPolicy=(0,a.Enum)("none","hide","mute"),n.LegendLocation=n.Anchor,n.LineCap=(0,a.Enum)("butt","round","square"),n.LineDash=(0,a.Enum)("solid","dashed","dotted","dotdash","dashdot"),n.LineJoin=(0,a.Enum)("miter","round","bevel"),n.LinePolicy=(0,a.Enum)("prev","next","nearest","interp","none"),n.Location=(0,a.Enum)("above","below","left","right"),n.Logo=(0,a.Enum)("normal","grey"),n.MapType=(0,a.Enum)("satellite","roadmap","terrain","hybrid"),n.MarkerType=(0,a.Enum)("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),n.MutedPolicy=(0,a.Enum)("show","ignore"),n.Orientation=(0,a.Enum)("vertical","horizontal"),n.OutlineShapeName=(0,a.Enum)("none","box","rectangle","square","circle","ellipse","trapezoid","parallelogram","diamond","triangle"),n.OutputBackend=(0,a.Enum)("canvas","svg","webgl"),n.PaddingUnits=(0,a.Enum)("percent","absolute"),n.PanDirection=(0,a.Enum)("left","right","up","down","west","east","north","south"),n.Place=(0,a.Enum)("above","below","left","right","center"),n.PointPolicy=(0,a.Enum)("snap_to_data","follow_mouse","none"),n.RadiusDimension=(0,a.Enum)("x","y","max","min"),n.RenderLevel=(0,a.Enum)("image","underlay","glyph","guide","annotation","overlay"),n.ResetPolicy=(0,a.Enum)("standard","event_only"),n.ResolutionType=(0,a.Enum)("microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"),n.RoundingFunction=(0,a.Enum)("round","nearest","floor","rounddown","ceil","roundup"),n.ScrollbarPolicy=(0,a.Enum)("auto","visible","hidden"),n.RegionSelectionMode=(0,a.Enum)("replace","append","intersect","subtract","xor"),n.SelectionMode=(0,a.Enum)(...n.RegionSelectionMode,"toggle"),n.Side=(0,a.Enum)("above","below","left","right"),n.SizingMode=(0,a.Enum)("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed","inherit"),n.Sort=(0,a.Enum)("ascending","descending"),n.SpatialUnits=(0,a.Enum)("screen","data"),n.StartEnd=(0,a.Enum)("start","end"),n.StepMode=(0,a.Enum)("after","before","center"),n.TapBehavior=(0,a.Enum)("select","inspect"),n.TapGesture=(0,a.Enum)("tap","doubletap"),n.TextAlign=(0,a.Enum)("left","right","center"),n.TextBaseline=(0,a.Enum)("top","middle","bottom","alphabetic","hanging","ideographic"),n.TextureRepetition=(0,a.Enum)("repeat","repeat_x","repeat_y","no_repeat"),n.TimedeltaResolutionType=(0,a.Enum)("nanoseconds","microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days"),n.LabelOrientation=(0,a.Enum)("vertical","horizontal","parallel","normal"),n.TooltipAttachment=(0,a.Enum)("horizontal","vertical","left","right","above","below"),n.UpdateMode=(0,a.Enum)("replace","append"),n.VerticalAlign=(0,a.Enum)("top","middle","bottom"),n.WindowAxis=(0,a.Enum)("none","x","y"),n.ToolIcon=(0,a.Enum)("append_mode","arrow_down_to_bar","arrow_up_from_bar","auto_box_zoom","bold","box_edit","box_select","box_zoom","caret_down","caret_left","caret_right","caret_up","check","chevron_down","chevron_left","chevron_right","chevron_up","clear_selection","copy","crosshair","dark_theme","delete","freehand_draw","fullscreen","help","hover","intersect_mode","invert_selection","italic","lasso_select","light_theme","line_edit","maximize","minimize","pan","pin","point_draw","pointer","poly_draw","poly_edit","polygon_select","range","redo","replace_mode","reset","save","see_off","see_on","settings","square","square_check","subtract_mode","tap_select","text_align_center","text_align_left","text_align_right","undo","unknown","unpin","wheel_pan","wheel_zoom","x_box_select","x_box_zoom","x_grip","x_pan","xor_mode","y_box_select","y_box_zoom","y_grip","y_pan","zoom_in","zoom_out"),n.ToolName=(0,a.Enum)("auto_box_zoom","box_select","box_zoom","click","copy","crosshair","doubletap","examine","freehand_draw","fullscreen","help","hover","lasso_select","pan","pan_down","pan_east","pan_left","pan_north","pan_right","pan_south","pan_up","pan_west","poly_select","redo","reset","save","tap","undo","wheel_zoom","xbox_select","xbox_zoom","xcrosshair","xpan","xwheel_pan","xwheel_zoom","xzoom_in","xzoom_out","ybox_select","ybox_zoom","ycrosshair","ypan","ywheel_pan","ywheel_zoom","yzoom_in","yzoom_out","zoom_in","zoom_out")},
function _(t,e,r,n,s){n();const i=t(1).__importStar(t(8)),a=t(23),_=t(9),o=t(18),u=globalThis.Map,l=globalThis.Set,y=globalThis.Node;class d{}r.Kind=d,d.__name__="Kind",function(t){class e extends d{may_have_refs(){return!1}}e.__name__="Primitive",t.Primitive=e;class r extends e{valid(t){return void 0!==t}toString(){return"Any"}may_have_refs(){return!0}}r.__name__="Any",t.Any=r;class n extends e{valid(t){return void 0!==t}toString(){return"Unknown"}may_have_refs(){return!0}}n.__name__="Unknown",t.Unknown=n;class s extends e{valid(t){return i.isBoolean(t)}toString(){return"Bool"}}s.__name__="Bool",t.Bool=s;class c extends d{constructor(t){super(),this.obj_type=t}valid(t){return t instanceof this.obj_type}toString(){const t=this.obj_type;return`Ref(${t.__name__??t.toString()})`}may_have_refs(){const{obj_type:t}=this;return!(o.has_refs in t)||t[o.has_refs]}}c.__name__="Ref",t.Ref=c;class p extends d{valid(t){return i.isObject(t)}toString(){return"AnyRef"}may_have_refs(){return!0}}p.__name__="AnyRef",t.AnyRef=p;class h extends e{valid(t){return i.isNumber(t)}toString(){return"Float"}}h.__name__="Float",t.Float=h;class m extends h{valid(t){return super.valid(t)&&i.isInteger(t)}toString(){return"Int"}}m.__name__="Int",t.Int=m;class v extends h{valid(t){return super.valid(t)&&0<=t&&t<=1}toString(){return"Percent"}}v.__name__="Percent",t.Percent=v;class f extends d{constructor(t){super(),this.types=t,this.types=t}valid(t){return this.types.some((e=>e.valid(t)))}toString(){return`Or(${this.types.map((t=>t.toString())).join(", ")})`}may_have_refs(){return this.types.some((t=>t.may_have_refs()))}}f.__name__="Or",t.Or=f;class S extends d{constructor(t,e){super(),this.types=[t,e]}valid(t){return this.types.some((e=>e.valid(t)))}toString(){return`And(${this.types.map((t=>t.toString())).join(", ")})`}may_have_refs(){return this.types.some((t=>t.may_have_refs()))}}S.__name__="And",t.And=S;class g extends d{constructor(t){super(),this.types=t,this.types=t}valid(t){if(!i.isArray(t))return!1;for(let e=0;e<this.types.length;e++){const r=this.types[e],n=t[e];if(!r.valid(n))return!1}return!0}toString(){return`Tuple(${this.types.map((t=>t.toString())).join(", ")})`}may_have_refs(){return this.types.some((t=>t.may_have_refs()))}}g.__name__="Tuple",t.Tuple=g;class x extends d{constructor(t){super(),this.struct_type=t}valid(t){if(!i.isPlainObject(t))return!1;const e=new _.PlainObjectProxy(this.struct_type);for(const r of(0,_.keys)(t))if(!e.has(r))return!1;for(const[r,n]of e){const e=t[r];if(!n.valid(e))return!1}return!0}toString(){return`Struct({${(0,_.typed_entries)(this.struct_type).map((([t,e])=>`${t.toString()}: ${e}`)).join(", ")}})`}may_have_refs(){return(0,_.typed_values)(this.struct_type).some((t=>t.may_have_refs()))}}x.__name__="Struct",t.Struct=x;class b extends d{constructor(t){super(),this.struct_type=t}valid(t){if(!i.isPlainObject(t))return!1;const e=new _.PlainObjectProxy(t),r=new _.PlainObjectProxy(this.struct_type);for(const t of e.keys())if(!r.has(t))return!1;for(const[t,n]of r){const r=e.get(t);if(void 0!==r&&!n.valid(r))return!1}return!0}toString(){return`Struct({${(0,_.typed_entries)(this.struct_type).map((([t,e])=>`${t.toString()}?: ${e}`)).join(", ")}})`}may_have_refs(){return(0,_.typed_values)(this.struct_type).some((t=>t.may_have_refs()))}}b.__name__="PartialStruct",t.PartialStruct=b;class w extends d{constructor(t){super(),this.item_type=t}valid(t){return i.isIterable(t)}toString(){return`Iterable(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}w.__name__="Iterable",t.Iterable=w;class K extends d{constructor(t){super(),this.item_type=t}valid(t){return i.isArray(t)||i.isTypedArray(t)}toString(){return`Arrayable(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}K.__name__="Arrayable",t.Arrayable=K;class N extends d{constructor(t){super(),this.item_type=t}valid(t){return i.isArray(t)&&t.every((t=>this.item_type.valid(t)))}toString(){return`List(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}N.__name__="List",t.List=N;class P extends N{valid(t){return super.valid(t)&&0!=t.length}toString(){return`NonEmptyList(${this.item_type.toString()})`}}P.__name__="NonEmptyList",t.NonEmptyList=P;class A extends e{valid(t){return null===t}toString(){return"Null"}}A.__name__="Null",t.Null=A;class $ extends d{constructor(t){super(),this.base_type=t}valid(t){return null===t||this.base_type.valid(t)}toString(){return`Nullable(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}$.__name__="Nullable",t.Nullable=$;class j extends d{constructor(t){super(),this.base_type=t}valid(t){return void 0===t||this.base_type.valid(t)}toString(){return`Opt(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}j.__name__="Opt",t.Opt=j;class F extends d{valid(t){return t instanceof ArrayBuffer}toString(){return"Bytes"}may_have_refs(){return!1}}F.__name__="Bytes",t.Bytes=F;class O extends e{valid(t){return i.isString(t)}toString(){return"Str"}}O.__name__="Str",t.Str=O;class L extends e{constructor(t){super(),this.prefix=t}valid(t){return i.isString(t)&&t.startsWith(this.prefix)}toString(){return`PrefixedStr('${this.prefix}')`}}L.__name__="PrefixedStr",t.PrefixedStr=L;class k extends O{constructor(t){super(),this.regex=t}valid(t){return super.valid(t)&&this.regex.test(t)}toString(){return`Regex(${this.regex.toString()})`}}k.__name__="Regex",t.Regex=k;class R extends e{constructor(t){super(),this.values=new l(t)}valid(t){return this.values.has(t)}*[Symbol.iterator](){yield*this.values}toString(){return`Enum(${[...this.values].map((t=>t.toString())).join(", ")})`}}R.__name__="Enum",t.Enum=R;class B extends d{constructor(t){super(),this.item_type=t}valid(t){if(!(t instanceof u||i.isPlainObject(t)))return!1;for(const e of(0,_.values)(t))if(!this.item_type.valid(e))return!1;return!0}toString(){return`Dict(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}B.__name__="Dict",t.Dict=B;class I extends d{constructor(t,e){super(),this.key_type=t,this.item_type=e}valid(t){if(!(t instanceof u||i.isPlainObject(t)))return!1;for(const[e,r]of(0,_.entries)(t))if(!this.key_type.valid(e)||!this.item_type.valid(r))return!1;return!0}toString(){return`KeyVal(${this.key_type.toString()}, ${this.item_type.toString()})`}may_have_refs(){return this.key_type.may_have_refs()||this.item_type.may_have_refs()}}I.__name__="KeyVal",t.KeyVal=I;class C extends d{constructor(t,e){super(),this.key_type=t,this.item_type=e}coerce(t){return i.isPlainObject(t)&&(0,_.is_empty)(t)?new u:t}valid(t){if(!(t instanceof u))return!1;for(const[e,r]of t.entries())if(!this.key_type.valid(e)||!this.item_type.valid(r))return!1;return!0}toString(){return`Mapping(${this.key_type.toString()}, ${this.item_type.toString()})`}may_have_refs(){return this.key_type.may_have_refs()||this.item_type.may_have_refs()}}C.__name__="Mapping",t.Mapping=C;class E extends d{constructor(t){super(),this.item_type=t}valid(t){if(!(t instanceof l))return!1;for(const e of t)if(!this.item_type.valid(e))return!1;return!0}toString(){return`Set(${this.item_type.toString()})`}may_have_refs(){return this.item_type.may_have_refs()}}E.__name__="Set",t.Set=E;class T extends d{valid(t){return(0,a.is_Color)(t)}toString(){return"Color"}may_have_refs(){return!1}}T.__name__="Color",t.Color=T;class M extends O{toString(){return"CSSLength"}}M.__name__="CSSLength",t.CSSLength=M;class D extends d{constructor(t,e){super(),this.args_types=t,this.ret_type=e}valid(t){return i.isFunction(t)}toString(){const{args_types:t,ret_type:e}=this;return`Func((${null==t?"?":t.map((t=>t.toString())).join(", ")}), ${null==e?"?":e.toString()})`}may_have_refs(){return!1}}D.__name__="Func",t.Func=D;class U extends d{constructor(t){super(),this.base_type=t}valid(t){return this.base_type.valid(t)&&t>=0}toString(){return`NonNegative(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}U.__name__="NonNegative",t.NonNegative=U;class V extends d{constructor(t){super(),this.base_type=t}valid(t){return this.base_type.valid(t)&&t>0}toString(){return`Positive(${this.base_type.toString()})`}may_have_refs(){return this.base_type.may_have_refs()}}V.__name__="Positive",t.Positive=V;class z extends d{valid(t){return t instanceof y}toString(){return"Node"}may_have_refs(){return!1}}z.__name__="Node",t.Node=z}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Bool=new r.Kinds.Bool,r.Float=new r.Kinds.Float,r.Int=new r.Kinds.Int,r.Bytes=new r.Kinds.Bytes,r.Str=new r.Kinds.Str;r.PrefixedStr=t=>new r.Kinds.PrefixedStr(t);r.Regex=t=>new r.Kinds.Regex(t),r.Null=new r.Kinds.Null;r.Nullable=t=>new r.Kinds.Nullable(t);r.Opt=t=>new r.Kinds.Opt(t);r.Or=(...t)=>new r.Kinds.Or(t);r.And=(t,e)=>new r.Kinds.And(t,e);r.Tuple=(...t)=>new r.Kinds.Tuple(t);r.Struct=t=>new r.Kinds.Struct(t);r.PartialStruct=t=>new r.Kinds.PartialStruct(t);r.Iterable=t=>new r.Kinds.Iterable(t);r.Arrayable=t=>new r.Kinds.Arrayable(t);r.List=t=>new r.Kinds.List(t);r.NonEmptyList=t=>new r.Kinds.NonEmptyList(t);r.Dict=t=>new r.Kinds.Dict(t);r.KeyVal=(t,e)=>new r.Kinds.KeyVal(t,e);r.Mapping=(t,e)=>new r.Kinds.Mapping(t,e);r.Set=t=>new r.Kinds.Set(t);r.Enum=(...t)=>new r.Kinds.Enum(t);r.Ref=t=>new r.Kinds.Ref(t);r.AnyRef=()=>new r.Kinds.AnyRef;r.Func=(t,e)=>new r.Kinds.Func(t,e);r.Func0=t=>new r.Kinds.Func([],t),r.Node=new r.Kinds.Node;r.NonNegative=t=>new r.Kinds.NonNegative(t);r.Positive=t=>new r.Kinds.Positive(t),r.Percent=new r.Kinds.Percent,r.Alpha=r.Percent,r.Color=new r.Kinds.Color,r.Auto=(0,r.Enum)("auto"),r.CSSLength=new r.Kinds.CSSLength,r.FontSize=r.Str,r.Font=r.Str,r.Angle=r.Float,r.Boolean=r.Bool,r.String=r.Str,r.Number=r.Float,r.Array=r.List,r.Map=r.Mapping,r.Function=r.Func},
function _(n,r,t,e,s){e(),t.byte=a,t.transparent=f,t.encode_rgba=function([n,r,t,e]){return n<<24|r<<16|t<<8|e},t.decode_rgba=g,t.color2rgba=b,t.rgba2css=$,t.color2css=function(n,r){if(!(0,c.isString)(n)||null!=r&&1!=r){const[t,e,s,u]=b(n,r);return $([t,e,s,u])}return n},t.color2hex=function(n,r){const[t,e,s,u]=b(n,r),i=`#${d(t)}${d(e)}${d(s)}`;return 255==u?i:`${i}${d(u)}`},t.color2hexrgb=function(n){const[r,t,e]=b(n);return`#${d(r)}${d(t)}${d(e)}`},t.css4_parse=p,t.is_Color=function(n){if((0,c.isInteger)(n))return!0;if((0,c.isString)(n)&&null!=p(n))return!0;if((0,c.isArray)(n)&&(3==n.length||4==n.length))return!0;return!1},t.is_dark=function([n,r,t]){return 1-(.299*n+.587*r+.114*t)/255>=.6},t.brightness=function(n){const[r,t,e]=b(n);return l(.299*r**2+.587*t**2+.114*e**2)/255},t.luminance=function(n){const[r,t,e]=b(n);return(.2126*r**2.2+.7152*t**2.2+.0722*e**2.2)/255**2.2};const u=n(24),i=n(11),c=n(8),{round:o,sqrt:l}=Math;function a(n){return(0,i.clamp)(o(n),0,255)}function f(){return[0,0,0,0]}function g(n){return[n>>24&255,n>>16&255,n>>8&255,255&n]}function b(n,r=1){const[t,e,s,u]=(()=>{if(null==n)return[0,0,0,0];if((0,c.isInteger)(n))return g(n);if((0,c.isString)(n)){const[r,t,e,s]=p(n)??[0,0,0,0];return[r,t,e,a(255*s)]}if(2==n.length){const[r,t]=n;return b(r,t)}{const[r,t,e,s=1]=n;return[r,t,e,a(255*s)]}})();return[t,e,s,a(r*u)]}const h={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function d(n){return h[n>>4]+h[15&n]}function $([n,r,t,e]){return`rgb(${n} ${r} ${t}${255==e?"":" / "+e/255})`}const m=/^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/,N=/^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/,_=(()=>{const n=document.createElement("canvas");n.width=1,n.height=1;const r=n.getContext("2d"),t=r.createLinearGradient(0,0,1,1);return n=>{r.fillStyle=t,r.fillStyle=n;const e=r.fillStyle;return e!=t?e:null}})();function p(n){if(""==(n=n.trim().toLowerCase()))return null;if("transparent"==n)return[0,0,0,0];if((0,u.is_named_color)(n)){const[r,t,e,s]=g(u.named_colors[n]);return[r,t,e,s/255]}if("#"==n[0]){const r=Number(`0x${n.substring(1)}`);if(isNaN(r))return null;switch(n.length-1){case 3:{const n=r>>8&15,t=r>>4&15,e=15&r;return[n<<4|n,t<<4|t,e<<4|e,1]}case 4:{const n=r>>12&15,t=r>>8&15,e=r>>4&15,s=15&r;return[n<<4|n,t<<4|t,e<<4|e,(s<<4|s)/255]}case 6:return[r>>16&255,r>>8&255,255&r,1];case 8:return[r>>24&255,r>>16&255,r>>8&255,(255&r)/255]}}else if(n.startsWith("rgb")){const r=n.match(m)??n.match(N);if(null!=r?.groups){let{r:n,g:t,b:e,a:s="1"}=r.groups;const u=n.endsWith("%"),i=t.endsWith("%"),c=e.endsWith("%"),o=s.endsWith("%");if(!(u&&i&&c)&&(u||i||c))return null;u&&(n=n.slice(0,-1)),i&&(t=t.slice(0,-1)),c&&(e=e.slice(0,-1)),o&&(s=s.slice(0,-1));let l=Number(n),f=Number(t),g=Number(e),b=Number(s);return isNaN(l+f+g+b)?null:(u&&(l=l/100*255),i&&(f=f/100*255),c&&(g=g/100*255),b=o?b/100:b,l=a(l),f=a(f),g=a(g),[l,f,g,b])}}else{const r=_(n);if(null!=r)return p(r)}return null}},
function _(e,r,l,a,i){a(),l.is_named_color=function(e){return e in l.named_colors};l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199}},
function _(r,t,n,o,a){o(),n.infer_type=function(r,t){if(r instanceof Float64Array||r instanceof Array)return Float64Array;if(t instanceof Float64Array||t instanceof Array)return Float64Array;return Float32Array},n.to_screen=function(r){return r instanceof Float32Array?r:Float32Array.from(r)},n.GeneratorFunction=Object.getPrototypeOf((function*(){})).constructor,n.AsyncGeneratorFunction=Object.getPrototypeOf((async function*(){})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.ScreenArray=Float32Array,a("Indices",r(26).BitSet)},
function _(t,e,s,r,n){var i,o;r();const c=t(27),_=t(12),h=t(18),a=t(20);class l{constructor(t,e=0){this[i]="BitSet",this._count=null,this.size=t,this._nwords=Math.ceil(t/l._word_length),0==e||1==e?(this._array=new Uint32Array(this._nwords),1==e&&this._array.fill(4294967295)):((0,_.assert)(e.length==this._nwords,"Initializer size mismatch"),this._array=e)}clone(){return new l(this.size,new Uint32Array(this._array))}[(i=Symbol.toStringTag,o=h.has_refs,c.equals)](t,e){if(!e.eq(this.size,t.size))return!1;const{_nwords:s}=this,r=this.size%l._word_length,n=0==r?s:s-1;for(let e=0;e<n;e++)if(this._array[e]!=t._array[e])return!1;if(0==r)return!0;{const e=1<<r-1,s=e-1^e;return(this._array[n]&s)==(t._array[n]&s)}}static all_set(t){return new l(t,1)}static all_unset(t){return new l(t,0)}static from_indices(t,e){const s=new l(t);for(const t of e)s.set(t);return s}static from_booleans(t,e){const s=new l(t);let r=0;for(const n of e){if(r==t)break;n&&s.set(r),r+=1}return s}get_unchecked(t){const e=t>>>5,s=31&t;return 1==(this._array[e]>>s&1)}set_unchecked(t,e=!0){this._count=null;const s=t>>>5,r=31&t;e?this._array[s]|=1<<r:this._array[s]&=~(1<<r)}get(t){const{size:e}=this;return 0<=t&&t<e?this.get_unchecked(t):-e<=t&&t<=-1&&this.get_unchecked(e+t)}set(t,e=!0){const{size:s}=this;0<=t&&t<s?this.set_unchecked(t,e):-s<=t&&t<=-1?this.set_unchecked(s+t,e):a.logger.warn(`out of bounds access: index=${t>=0?t:s+t} >= size=${s}`)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:e,size:s}=this;let r=0;for(let n=0,i=0;i<e;i++){const e=t[i];if(0==e)n+=l._word_length;else for(let t=0;t<l._word_length&&n<s;t++,n++)1==(e>>>t&1)&&(r+=1)}return r}ones(){const t=new Array(this.count);let e=0;const{_array:s,_nwords:r,size:n}=this;for(let i=0,o=0;o<r;o++){const r=s[o];if(0!=r)for(let s=0;s<l._word_length&&i<n;s++,i++)1==(r>>>s&1)&&(t[e++]=i);else i+=l._word_length}return t}zeros(){const t=new Array(this.count);let e=0;const{_array:s,_nwords:r,size:n}=this;for(let i=0,o=0;o<r;o++){const r=s[o];if(4294967295!=r)for(let s=0;s<l._word_length&&i<n;s++,i++)r>>>s&1||(t[e++]=i);else i+=l._word_length}return t}_check_size(t){(0,_.assert)(this.size==t.size,`Size mismatch (${this.size} != ${t.size})`)}invert(){for(let t=0;t<this._nwords;t++)this._array[t]=~this._array[t]>>>0}add(t){this._check_size(t);for(let e=0;e<this._nwords;e++)this._array[e]|=t._array[e]}intersect(t){this._check_size(t);for(let e=0;e<this._nwords;e++)this._array[e]&=t._array[e]}subtract(t){this._check_size(t);for(let e=0;e<this._nwords;e++){const s=this._array[e],r=t._array[e];this._array[e]=(s^r)&s}}symmetric_subtract(t){this._check_size(t);for(let e=0;e<this._nwords;e++)this._array[e]^=t._array[e]}inversion(){const t=this.clone();return t.invert(),t}union(t){const e=this.clone();return e.add(t),e}intersection(t){const e=this.clone();return e.intersect(t),e}difference(t){const e=this.clone();return e.subtract(t),e}symmetric_difference(t){const e=this.clone();return e.symmetric_subtract(t),e}select(t){(0,_.assert)(this.size<=t.length,"Size mismatch");const e=this.count,s=new t.constructor(e),r=this.ones();let n=0;for(let e=0;e<r.length;e++)s[n++]=t[r[e]];return s}}s.BitSet=l,l.__name__="BitSet",l[o]=!1,l._word_length=32},
function _(t,e,r,s,n){s(),r.is_equal=function(t,e){return(new l).eq(t,e)},r.is_structurally_equal=function(t,e){return new l({structural:!0}).eq(t,e)},r.is_similar=function(t,e,r){return new f(r).eq(t,e)};const c=t(8),{hasOwnProperty:o}=Object.prototype;function a(t){return(0,c.isObject)(t)&&r.equals in t}r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const i=Object.prototype.toString;class u extends Error{}r.EqNotImplemented=u,u.__name__="EqNotImplemented";class l{constructor(t){this.a_stack=[],this.b_stack=[],this.structural=t?.structural??!1}eq(t,e){if(t===e||Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const s=i.call(t);if(s!=i.call(e))return!1;switch(s){case"[object Number]":return this.numbers(t,e);case"[object Symbol]":return t===e;case"[object RegExp]":case"[object String]":return`${t}`==`${e}`;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:n,b_stack:c}=this;let o=n.length;for(;o-- >0;)if(n[o]===t)return c[o]===e;n.push(t),c.push(e);const l=(()=>{if(a(t)&&a(e))return t[r.equals](e,this);switch(s){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object ArrayBuffer]":case"[object SharedArrayBuffer]":return this.array_buffers(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(`${t}`,`${e}`)}if("undefined"!=typeof Node&&t instanceof Node)return this.nodes(t,e);throw new u(`can't compare objects of type ${s}`)})();return n.pop(),c.pop(),l}numbers(t,e){return t===e||Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let s=0;s<r;s++)if(!this.eq(t[s],e[s]))return!1;return!0}array_buffers(t,e){return this.arrays(new Uint8Array(t),new Uint8Array(e))}iterables(t,e){const r=t[Symbol.iterator](),s=e[Symbol.iterator]();for(;;){const t=r.next(),e=s.next(),n=t.done??!1,c=e.done??!1;if(n&&c)return!0;if(n||c)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const[r,s]of t)if(!e.has(r)||!this.eq(s,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const s of r)if(!o.call(e,s)||!this.eq(t[s],e[s]))return!1;return!0}nodes(t,e){return this.structural?t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes)):t===e}}r.Comparator=l,l.__name__="Comparator";const{abs:b}=Math;class f extends l{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||b(t-e)<this.tolerance}}r.SimilarComparator=f,f.__name__="SimilarComparator"},
function _(n,t,i,e,r){e(),i.to_big_endian=function(n){if(i.is_little_endian){const t=new Uint32Array(n.length),i=new DataView(t.buffer);let e=0;for(const t of n)i.setUint32(e,t),e+=4;return t}return n},i.is_mobile="ontouchstart"in globalThis||"undefined"!=typeof navigator&&navigator.maxTouchPoints>0,i.is_little_endian=(()=>{const n=new ArrayBuffer(4),t=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let i=!0;return 10==t[4]&&11==t[5]&&12==t[6]&&13==t[7]&&(i=!1),i})(),i.BYTE_ORDER=i.is_little_endian?"little":"big"},
function _(n,i,r,t,e){t(),r.isValue=o,r.isField=s,r.isExpr=l,r.isVectorized=function(n){return o(n)||s(n)||l(n)};const u=n(8),f=n(9);function c(n,i){if(!(0,u.isPlainObject)(n))return!1;if(!(i in n))return!1;let r=(0,f.size)(n)-1;return"transform"in n&&(r-=1),"units"in n&&(r-=1),0==r}function o(n){return c(n,"value")}function s(n){return c(n,"field")}function l(n){return c(n,"expr")}},
function _(e,t,r,s,_){s();class i{constructor(){this._dev=!1,this._wireframe=!1,this._force_webgl=!1,this._force_fields=!1}set dev(e){this._dev=e}get dev(){return this._dev}set wireframe(e){this._wireframe=e}get wireframe(){return this._wireframe}set force_webgl(e){this._force_webgl=e}get force_webgl(){return this._force_webgl}set force_fields(e){this._force_fields=e}get force_fields(){return this._force_fields}}r.Settings=i,i.__name__="Settings",r.settings=new i},
function _(e,t,s,r,n){var a,i,h,u,o,l,c,p,y,_;r(),s.is_NDArray=O,s.ndarray=function(e,{dtype:t,shape:s}={}){null==t&&(t=(()=>{switch(!0){case e instanceof Uint8Array:return"uint8";case e instanceof Int8Array:return"int8";case e instanceof Uint16Array:return"uint16";case e instanceof Int16Array:return"int16";case e instanceof Uint32Array:return"uint32";case e instanceof Int32Array:return"int32";case e instanceof Float32Array:return"float32";case e instanceof Float64Array:return"float64";default:return(0,A.is_ArrayBufferLike)(e)?"float64":"object"}})());switch(t){case"bool":return new D(e,s);case"uint8":return new q(e,s);case"int8":return new b(e,s);case"uint16":return new U(e,s);case"int16":return new I(e,s);case"uint32":return new x(e,s);case"int32":return new z(e,s);case"float32":return new F(e,s);case"float64":return new j(e,s);case"object":return new B(e,s)}};const A=e(8),d=e(28),g=e(27),f=e(32),m=e(33),w=Symbol("__ndarray__");function N(e,t){return{type:"ndarray",array:t.encode("object"==e.dtype?Array.from(e):e.buffer),order:d.BYTE_ORDER,dtype:e.dtype,shape:e.shape}}class D extends Uint8Array{constructor(e,t){super(e),this[a]=!0,this.dtype="bool",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(a=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new D(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return 1==this[e]}}s.BoolNDArray=D,D.__name__="BoolNDArray";class q extends Uint8Array{constructor(e,t){super(e),this[i]=!0,this.dtype="uint8",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(i=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new q(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint8NDArray=q,q.__name__="Uint8NDArray";class b extends Int8Array{constructor(e,t){super(e),this[h]=!0,this.dtype="int8",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(h=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new b(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int8NDArray=b,b.__name__="Int8NDArray";class U extends Uint16Array{constructor(e,t){super(e),this[u]=!0,this.dtype="uint16",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(u=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new U(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint16NDArray=U,U.__name__="Uint16NDArray";class I extends Int16Array{constructor(e,t){super(e),this[o]=!0,this.dtype="int16",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(o=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new I(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int16NDArray=I,I.__name__="Int16NDArray";class x extends Uint32Array{constructor(e,t){super(e),this[l]=!0,this.dtype="uint32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(l=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new x(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Uint32NDArray=x,x.__name__="Uint32NDArray";class z extends Int32Array{constructor(e,t){super(e),this[c]=!0,this.dtype="int32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(c=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new z(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Int32NDArray=z,z.__name__="Int32NDArray";class F extends Float32Array{constructor(e,t){super(e),this[p]=!0,this.dtype="float32",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(p=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new F(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Float32NDArray=F,F.__name__="Float32NDArray";class j extends Float64Array{constructor(e,t){super(e),this[y]=!0,this.dtype="float64",this.shape=t??(O(e)?e.shape:[this.length]),this.dimension=this.shape.length}[(y=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new j(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}s.Float64NDArray=j,j.__name__="Float64NDArray";class B extends Array{get shape(){return this._shape??[this.length]}get dimension(){return this.shape.length}constructor(e,t){const s=(0,A.is_ArrayBufferLike)(e)?new Float64Array(e):e;if(super((0,A.isNumber)(s)?s:s.length),this[_]=!0,this.dtype="object",!(0,A.isNumber)(s))for(let e=0;e<s.length;e++)this[e]=s[e];this._shape=t??(O(s)?s.shape:void 0)}[(_=w,g.equals)](e,t){return t.eq(this.shape,e.shape)&&t.arrays(this,e)}[f.clone](e){return new B(this,e.clone(this.shape))}[m.serialize](e){return N(this,e)}get(e){return this[e]}}function O(e){return(0,A.isObject)(e)&&w in e}s.ObjectNDArray=B,B.__name__="ObjectNDArray"},
function _(n,e,t,o,r){o(),t.is_Cloneable=s;const i=n(9),c=n(8);function s(n){return(0,c.isObject)(n)&&t.clone in n}t.clone=Symbol("clone");class l extends Error{}t.CloningError=l,l.__name__="CloningError";class a{constructor(){}clone(n){if(s(n))return n[t.clone](this);if((0,c.isPrimitive)(n)||(0,c.isFunction)(n))return n;if((0,c.isArray)(n)){const e=n.length,t=new Array(e);for(let o=0;o<e;o++){const e=n[o];t[o]=this.clone(e)}return t}if((0,c.isPlainObject)(n)){const e={};for(const[t,o]of(0,i.entries)(n))e[t]=this.clone(o);return e}if(n instanceof Map)return new Map([...n].map((([n,e])=>[this.clone(n),this.clone(e)])));if(n instanceof Set)return new Set([...n].map((n=>this.clone(n))));throw new l(`${Object.prototype.toString.call(n)} is not cloneable`)}}t.Cloner=a,a.__name__="Cloner"},
function _(r,e,i,a,f){a();const o=r(1);var l=r(34);f("Serializer",l.Serializer),f("SerializationError",l.SerializationError),f("serialize",l.serialize);var t=r(35);f("Buffer",t.Buffer),f("Base64Buffer",t.Base64Buffer),o.__exportStar(r(38),i)},
function _(e,r,t,n,i){n();const s=e(12),a=e(9),c=e(8),o=e(14),u=e(28),l=e(35);t.serialize=Symbol("serialize");class f extends Error{}t.SerializationError=f,f.__name__="SerializationError";class y{constructor(e){this.value=e}to_json(){return JSON.stringify(this.value)}}y.__name__="Serialized";class d{constructor(e){this._circular=new WeakSet,this.binary=e?.binary??!1,this.include_defaults=e?.include_defaults??!1;const r=e?.references;this._references=null!=r?new Map(r):new Map}get_ref(e){return this._references.get(e)}add_ref(e,r){(0,s.assert)(!this._references.has(e)),this._references.set(e,r)}to_serializable(e){return new y(this.encode(e))}encode(e){const r=this.get_ref(e);if(null!=r)return r;if(!(0,c.isObject)(e))return this._encode(e);this._circular.has(e)&&this.error("circular reference"),this._circular.add(e);try{return this._encode(e)}finally{this._circular.delete(e)}}_encode(e){if(function(e){return(0,c.isObject)(e)&&t.serialize in e}(e))return e[t.serialize](this);if((0,c.isArray)(e)){const r=e.length,t=new Array(r);for(let n=0;n<r;n++){const r=e[n];t[n]=this.encode(r)}return t}if((0,c.isTypedArray)(e))return this._encode_typed_array(e);if(e instanceof ArrayBuffer){return{type:"bytes",data:this.binary?new l.Buffer(e):new l.Base64Buffer(e)}}if((0,c.isPlainObject)(e)){const r=(0,a.entries)(e);return 0==r.length?{type:"map"}:{type:"map",entries:[...(0,o.map)(r,(([e,r])=>[this.encode(e),this.encode(r)]))]}}if(null===e||(0,c.isBoolean)(e)||(0,c.isString)(e))return e;if((0,c.isNumber)(e))return isNaN(e)?{type:"number",value:"nan"}:isFinite(e)?e:{type:"number",value:(e<0?"-":"+")+"inf"};if(e instanceof Date){return{type:"date",iso:e.toISOString()}}if(e instanceof Set)return 0==e.size?{type:"set"}:{type:"set",entries:[...(0,o.map)(e.values(),(e=>this.encode(e)))]};if(e instanceof Map)return 0==e.size?{type:"map"}:{type:"map",entries:[...(0,o.map)(e.entries(),(([e,r])=>[this.encode(e),this.encode(r)]))]};if((0,c.isSymbol)(e)&&null!=e.description)return{type:"symbol",name:e.description};throw new f(`${Object.prototype.toString.call(e)} is not serializable`)}encode_struct(e){const r={};for(const[t,n]of(0,a.entries)(e))void 0!==n&&(r[t]=this.encode(n));return r}error(e){throw new f(e)}_encode_typed_array(e){const r=this.encode(e.buffer),t=(()=>{switch(e.constructor){case Uint8Array:return"uint8";case Int8Array:return"int8";case Uint16Array:return"uint16";case Int16Array:return"int16";case Uint32Array:return"uint32";case Int32Array:return"int32";case Float32Array:return"float32";case Float64Array:return"float64";default:this.error(`can't serialize typed array of type '${e[Symbol.toStringTag]}'`)}})();return{type:"typed_array",array:r,order:u.BYTE_ORDER,dtype:t}}}t.Serializer=d,d.__name__="Serializer"},
function _(e,f,r,s,t){s();const u=e(36),_=e(27);class a{constructor(e){this.buffer=e}to_base64(){return(0,u.buffer_to_base64)(this.buffer)}[_.equals](e,f){return f.eq(this.buffer,e.buffer)}}r.Buffer=a,a.__name__="Buffer";class n extends a{toJSON(){return this.to_base64()}}r.Base64Buffer=n,n.__name__="Base64Buffer"},
function _(n,t,e,o,r){o(),e.b64encode=a,e.b64decode=i,e.buffer_to_base64=function(n){const t=new Uint8Array(n);return a((0,c.gzipSync)(t,{mtime:0}))},e.base64_to_buffer=function(n){const t=i(n);return(0,c.gunzipSync)(t).buffer},e.swap=function(n,t){switch(t){case"uint16":case"int16":!function(n){const t=new Uint8Array(n);for(let n=0,e=t.length;n<e;n+=2){const e=t[n];t[n]=t[n+1],t[n+1]=e}}(n);break;case"uint32":case"int32":case"float32":!function(n){const t=new Uint8Array(n);for(let n=0,e=t.length;n<e;n+=4){let e=t[n];t[n]=t[n+3],t[n+3]=e,e=t[n+1],t[n+1]=t[n+2],t[n+2]=e}}(n);break;case"float64":!function(n){const t=new Uint8Array(n);for(let n=0,e=t.length;n<e;n+=8){let e=t[n];t[n]=t[n+7],t[n+7]=e,e=t[n+1],t[n+1]=t[n+6],t[n+6]=e,e=t[n+2],t[n+2]=t[n+5],t[n+5]=e,e=t[n+3],t[n+3]=t[n+4],t[n+4]=e}}(n)}};const c=n(37);function a(n){const t=Array.from(n).map((n=>String.fromCharCode(n)));return btoa(t.join(""))}function i(n){const t=atob(n),e=t.length,o=new Uint8Array(e);for(let n=0,r=e;n<r;n++)o[n]=t.charCodeAt(n);return o}},
function _(t,n,r,i,e){i(),r.deflate=At,r.deflateSync=Ct,r.inflate=Ut,r.inflateSync=It,r.gzip=Zt,r.compress=Zt,r.gzipSync=Ot,r.compressSync=Ot,r.gunzip=Lt,r.gunzipSync=$t,r.zlib=function(t,n,r){r||(r=n,n={});"function"!=typeof r&&O(7);return ft(t,n,[it,at,function(){return[Bt]}],(function(t){return ut(Bt(t.data[0],t.data[1]))}),4,r)},r.zlibSync=Bt,r.unzlib=Rt,r.unzlibSync=Wt,r.decompress=function(t,n,r){r||(r=n,n={});"function"!=typeof r&&O(7);return 31==t[0]&&139==t[1]&&8==t[2]?Lt(t,n,r):8!=(15&t[0])||t[0]>>4>7||(t[0]<<8|t[1])%31?Ut(t,n,r):Rt(t,n,r)},r.decompressSync=function(t,n){return 31==t[0]&&139==t[1]&&8==t[2]?$t(t,n):8!=(15&t[0])||t[0]>>4>7||(t[0]<<8|t[1])%31?It(t,n):Wt(t,n)},r.strToU8=rn,r.strFromU8=en,r.zip=function(t,n,r){r||(r=n,n={});"function"!=typeof r&&O(7);var i={};Jt(t,"",i,n);var e=Object.keys(i),o=e.length,s=0,u=0,h=o,f=new Array(o),c=[],l=function(){for(var t=0;t<c.length;++t)c[t]()},p=function(t,n){wn((function(){r(t,n)}))};wn((function(){p=r}));var v=function(){var t=new a(u+22),n=s,r=u-s;u=0;for(var i=0;i<h;++i){var e=f[i];try{var o=e.c.length;fn(t,u,e,e.f,e.u,o);var c=30+e.f.length+hn(e.extra),l=u+c;t.set(e.c,l),fn(t,s,e,e.f,e.u,o,u,e.m),s+=16+c+(e.m?e.m.length:0),u=l+o}catch(t){return p(t,null)}}cn(t,s,f.length,r,n),p(null,t)};o||v();for(var d=function(t){var n=e[t],r=i[n],a=r[0],h=r[1],d=J(),g=a.length;d.p(a);var y=rn(n),m=y.length,b=h.comment,w=b&&rn(b),z=w&&w.length,k=hn(h.extra),S=0==h.level?0:8,M=function(r,i){if(r)l(),p(r,null);else{var e=i.length;f[t]=V(h,{size:g,crc:d.d(),c:i,f:y,m:w,u:m!=n.length||w&&b.length!=z,compression:S}),s+=30+m+k+e,u+=76+2*(m+k)+(z||0)+e,--o||v()}};if(m>65535&&M(O(11,0,1),null),S)if(g<16e4)try{M(null,Ct(a,h))}catch(t){M(t,null)}else c.push(At(a,h,M));else M(null,a)},g=0;g<h;++g)d(g);return l},r.zipSync=function(t,n){n||(n={});var r={},i=[];Jt(t,"",r,n);var e=0,o=0;for(var s in r){var u=r[s],h=u[0],f=u[1],c=0==f.level?0:8,l=(M=rn(s)).length,p=f.comment,v=p&&rn(p),d=v&&v.length,g=hn(f.extra);l>65535&&O(11);var y=c?Ct(h,f):h,m=y.length,b=J();b.p(h),i.push(V(f,{size:h.length,crc:b.d(),c:y,f:M,m:v,u:l!=s.length||v&&p.length!=d,o:e,compression:c})),e+=30+l+g+m,o+=76+2*(l+g)+(d||0)+m}for(var w=new a(o+22),z=e,k=o-e,S=0;S<i.length;++S){var M=i[S];fn(w,M.o,M,M.f,M.u,M.c.length);var x=30+M.f.length+hn(M.extra);w.set(M.c,M.o+x),fn(w,e,M,M.f,M.u,M.c.length,M.o,M.m),e+=16+x+(M.m?M.m.length:0)}return cn(w,e,i.length,k,z),w},r.unzip=function(t,n,r){r||(r=n,n={});"function"!=typeof r&&O(7);var i=[],e=function(){for(var t=0;t<i.length;++t)i[t]()},o={},s=function(t,n){wn((function(){r(t,n)}))};wn((function(){s=r}));for(var u=t.length-22;101010256!=vt(t,u);--u)if(!u||t.length-u>65558)return s(O(13,0,1),null),e;var h=pt(t,u+8);if(h){var f=h,c=vt(t,u+16),l=4294967295==c||65535==f;if(l){var p=vt(t,u-12);(l=101075792==vt(t,p))&&(f=h=vt(t,p+32),c=vt(t,p+48))}for(var v=n&&n.filter,d=function(n){var r=sn(t,c,l),u=r[0],f=r[1],p=r[2],d=r[3],g=r[4],y=r[5],m=an(t,y);c=g;var b=function(t,n){t?(e(),s(t,null)):(n&&(o[d]=n),--h||s(null,o))};if(!v||v({name:d,size:f,originalSize:p,compression:u}))if(u)if(8==u){var w=t.subarray(m,m+f);if(p<524288||f>.8*p)try{b(null,It(w,{out:new a(p)}))}catch(t){b(t,null)}else i.push(Ut(w,{size:p},b))}else b(O(14,"unknown compression type "+u,1),null);else b(null,E(t,m,m+f));else b(null,null)},g=0;g<f;++g)d()}else s(null,{});return e},r.unzipSync=function(t,n){for(var r={},i=t.length-22;101010256!=vt(t,i);--i)(!i||t.length-i>65558)&&O(13);var e=pt(t,i+8);if(!e)return{};var o=vt(t,i+16),s=4294967295==o||65535==e;if(s){var u=vt(t,i-12);(s=101075792==vt(t,u))&&(e=vt(t,u+32),o=vt(t,u+48))}for(var h=n&&n.filter,f=0;f<e;++f){var c=sn(t,o,s),l=c[0],p=c[1],v=c[2],d=c[3],g=c[4],y=c[5],m=an(t,y);o=g,h&&!h({name:d,size:p,originalSize:v,compression:l})||(l?8==l?r[d]=It(t.subarray(m,m+p),{out:new a(v)}):O(14,"unknown compression type "+l):r[d]=E(t,m,m+p))}return r};var o={},a=Uint8Array,s=Uint16Array,u=Int32Array,h=new a([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),f=new a([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),c=new a([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),l=function(t,n){for(var r=new s(31),i=0;i<31;++i)r[i]=n+=1<<t[i-1];var e=new u(r[30]);for(i=1;i<30;++i)for(var o=r[i];o<r[i+1];++o)e[o]=o-r[i]<<5|i;return{b:r,r:e}},p=l(h,2),v=p.b,d=p.r;v[28]=258,d[258]=28;for(var g=l(f,0),y=g.b,m=g.r,b=new s(32768),w=0;w<32768;++w){var z=(43690&w)>>1|(21845&w)<<1;z=(61680&(z=(52428&z)>>2|(13107&z)<<2))>>4|(3855&z)<<4,b[w]=((65280&z)>>8|(255&z)<<8)>>1}var k=function(t,n,r){for(var i=t.length,e=0,o=new s(n);e<i;++e)t[e]&&++o[t[e]-1];var a,u=new s(n);for(e=1;e<n;++e)u[e]=u[e-1]+o[e-1]<<1;if(r){a=new s(1<<n);var h=15-n;for(e=0;e<i;++e)if(t[e])for(var f=e<<4|t[e],c=n-t[e],l=u[t[e]-1]++<<c,p=l|(1<<c)-1;l<=p;++l)a[b[l]>>h]=f}else for(a=new s(i),e=0;e<i;++e)t[e]&&(a[e]=b[u[t[e]-1]++]>>15-t[e]);return a},S=new a(288);for(w=0;w<144;++w)S[w]=8;for(w=144;w<256;++w)S[w]=9;for(w=256;w<280;++w)S[w]=7;for(w=280;w<288;++w)S[w]=8;var M=new a(32);for(w=0;w<32;++w)M[w]=5;var x=k(S,9,0),A=k(S,9,1),C=k(M,5,0),T=k(M,5,1),D=function(t){for(var n=t[0],r=1;r<t.length;++r)t[r]>n&&(n=t[r]);return n},U=function(t,n,r){var i=n/8|0;return(t[i]|t[i+1]<<8)>>(7&n)&r},I=function(t,n){var r=n/8|0;return(t[r]|t[r+1]<<8|t[r+2]<<16)>>(7&n)},F=function(t){return(t+7)/8|0},E=function(t,n,r){return(null==n||n<0)&&(n=0),(null==r||r>t.length)&&(r=t.length),new a(t.subarray(n,r))};r.FlateErrorCode={UnexpectedEOF:0,InvalidBlockType:1,InvalidLengthLiteral:2,InvalidDistance:3,StreamFinished:4,NoStreamHandler:5,InvalidHeader:6,NoCallback:7,InvalidUTF8:8,ExtraFieldTooLong:9,InvalidDate:10,FilenameTooLong:11,StreamFinishing:12,InvalidZipData:13,UnknownCompressionMethod:14};var Z=["unexpected EOF","invalid block type","invalid length/literal","invalid distance","stream finished","no stream handler",,"no callback","invalid UTF-8 data","extra field too long","date not in range 1980-2099","filename too long","stream finishing","invalid zip data"],O=function(t,n,r){var i=new Error(n||Z[t]);if(i.code=t,Error.captureStackTrace&&Error.captureStackTrace(i,O),!r)throw i;return i},q=function(t,n,r,i){var e=t.length,o=i?i.length:0;if(!e||n.f&&!n.l)return r||new a(0);var s=!r,u=s||2!=n.i,l=n.i;s&&(r=new a(3*e));var p=function(t){var n=r.length;if(t>n){var i=new a(Math.max(2*n,t));i.set(r),r=i}},d=n.f||0,g=n.p||0,m=n.b||0,b=n.l,w=n.d,z=n.m,S=n.n,M=8*e;do{if(!b){d=U(t,g,1);var x=U(t,g+1,3);if(g+=3,!x){var C=t[(R=F(g)+4)-4]|t[R-3]<<8,Z=R+C;if(Z>e){l&&O(0);break}u&&p(m+C),r.set(t.subarray(R,Z),m),n.b=m+=C,n.p=g=8*Z,n.f=d;continue}if(1==x)b=A,w=T,z=9,S=5;else if(2==x){var q=U(t,g,31)+257,G=U(t,g+10,15)+4,L=q+U(t,g+5,31)+1;g+=14;for(var $=new a(L),j=new a(19),H=0;H<G;++H)j[c[H]]=U(t,g+3*H,7);g+=3*G;var B=D(j),N=(1<<B)-1,P=k(j,B,1);for(H=0;H<L;){var R,W=P[U(t,g,N)];if(g+=15&W,(R=W>>4)<16)$[H++]=R;else{var Y=0,_=0;for(16==R?(_=3+U(t,g,3),g+=2,Y=$[H-1]):17==R?(_=3+U(t,g,7),g+=3):18==R&&(_=11+U(t,g,127),g+=7);_--;)$[H++]=Y}}var J=$.subarray(0,q),K=$.subarray(q);z=D(J),S=D(K),b=k(J,z,1),w=k(K,S,1)}else O(1);if(g>M){l&&O(0);break}}u&&p(m+131072);for(var Q=(1<<z)-1,V=(1<<S)-1,X=g;;X=g){var tt=(Y=b[I(t,g)&Q])>>4;if((g+=15&Y)>M){l&&O(0);break}if(Y||O(2),tt<256)r[m++]=tt;else{if(256==tt){X=g,b=null;break}var nt=tt-254;if(tt>264){var rt=h[H=tt-257];nt=U(t,g,(1<<rt)-1)+v[H],g+=rt}var it=w[I(t,g)&V],et=it>>4;it||O(3),g+=15&it;K=y[et];if(et>3){rt=f[et];K+=I(t,g)&(1<<rt)-1,g+=rt}if(g>M){l&&O(0);break}u&&p(m+131072);var ot=m+nt;if(m<K){var at=o-K,st=Math.min(K,ot);for(at+m<0&&O(3);m<st;++m)r[m]=i[at+m]}for(;m<ot;++m)r[m]=r[m-K]}}n.l=b,n.p=X,n.b=m,n.f=d,b&&(d=1,n.m=z,n.d=w,n.n=S)}while(!d);return m!=r.length&&s?E(r,0,m):r.subarray(0,m)},G=function(t,n,r){r<<=7&n;var i=n/8|0;t[i]|=r,t[i+1]|=r>>8},L=function(t,n,r){r<<=7&n;var i=n/8|0;t[i]|=r,t[i+1]|=r>>8,t[i+2]|=r>>16},$=function(t,n){for(var r=[],i=0;i<t.length;++i)t[i]&&r.push({s:i,f:t[i]});var e=r.length,o=r.slice();if(!e)return{t:W,l:0};if(1==e){var u=new a(r[0].s+1);return u[r[0].s]=1,{t:u,l:1}}r.sort((function(t,n){return t.f-n.f})),r.push({s:-1,f:25001});var h=r[0],f=r[1],c=0,l=1,p=2;for(r[0]={s:-1,f:h.f+f.f,l:h,r:f};l!=e-1;)h=r[r[c].f<r[p].f?c++:p++],f=r[c!=l&&r[c].f<r[p].f?c++:p++],r[l++]={s:-1,f:h.f+f.f,l:h,r:f};var v=o[0].s;for(i=1;i<e;++i)o[i].s>v&&(v=o[i].s);var d=new s(v+1),g=j(r[l-1],d,0);if(g>n){i=0;var y=0,m=g-n,b=1<<m;for(o.sort((function(t,n){return d[n.s]-d[t.s]||t.f-n.f}));i<e;++i){var w=o[i].s;if(!(d[w]>n))break;y+=b-(1<<g-d[w]),d[w]=n}for(y>>=m;y>0;){var z=o[i].s;d[z]<n?y-=1<<n-d[z]++-1:++i}for(;i>=0&&y;--i){var k=o[i].s;d[k]==n&&(--d[k],++y)}g=n}return{t:new a(d),l:g}},j=function(t,n,r){return-1==t.s?Math.max(j(t.l,n,r+1),j(t.r,n,r+1)):n[t.s]=r},H=function(t){for(var n=t.length;n&&!t[--n];);for(var r=new s(++n),i=0,e=t[0],o=1,a=function(t){r[i++]=t},u=1;u<=n;++u)if(t[u]==e&&u!=n)++o;else{if(!e&&o>2){for(;o>138;o-=138)a(32754);o>2&&(a(o>10?o-11<<5|28690:o-3<<5|12305),o=0)}else if(o>3){for(a(e),--o;o>6;o-=6)a(8304);o>2&&(a(o-3<<5|8208),o=0)}for(;o--;)a(e);o=1,e=t[u]}return{c:r.subarray(0,i),n}},B=function(t,n){for(var r=0,i=0;i<n.length;++i)r+=t[i]*n[i];return r},N=function(t,n,r){var i=r.length,e=F(n+2);t[e]=255&i,t[e+1]=i>>8,t[e+2]=255^t[e],t[e+3]=255^t[e+1];for(var o=0;o<i;++o)t[e+o+4]=r[o];return 8*(e+4+i)},P=function(t,n,r,i,e,o,a,u,l,p,v){G(n,v++,r),++e[256];for(var d=$(e,15),g=d.t,y=d.l,m=$(o,15),b=m.t,w=m.l,z=H(g),A=z.c,T=z.n,D=H(b),U=D.c,I=D.n,F=new s(19),E=0;E<A.length;++E)++F[31&A[E]];for(E=0;E<U.length;++E)++F[31&U[E]];for(var Z=$(F,7),O=Z.t,q=Z.l,j=19;j>4&&!O[c[j-1]];--j);var P,R,W,Y,_=p+5<<3,J=B(e,S)+B(o,M)+a,K=B(e,g)+B(o,b)+a+14+3*j+B(F,O)+2*F[16]+3*F[17]+7*F[18];if(l>=0&&_<=J&&_<=K)return N(n,v,t.subarray(l,l+p));if(G(n,v,1+(K<J)),v+=2,K<J){P=k(g,y,0),R=g,W=k(b,w,0),Y=b;var Q=k(O,q,0);G(n,v,T-257),G(n,v+5,I-1),G(n,v+10,j-4),v+=14;for(E=0;E<j;++E)G(n,v+3*E,O[c[E]]);v+=3*j;for(var V=[A,U],X=0;X<2;++X){var tt=V[X];for(E=0;E<tt.length;++E){var nt=31&tt[E];G(n,v,Q[nt]),v+=O[nt],nt>15&&(G(n,v,tt[E]>>5&127),v+=tt[E]>>12)}}}else P=x,R=S,W=C,Y=M;for(E=0;E<u;++E){var rt=i[E];if(rt>255){L(n,v,P[(nt=rt>>18&31)+257]),v+=R[nt+257],nt>7&&(G(n,v,rt>>23&31),v+=h[nt]);var it=31&rt;L(n,v,W[it]),v+=Y[it],it>3&&(L(n,v,rt>>5&8191),v+=f[it])}else L(n,v,P[rt]),v+=R[rt]}return L(n,v,P[256]),v+R[256]},R=new u([65540,131080,131088,131104,262176,1048704,1048832,2114560,2117632]),W=new a(0),Y=function(t,n,r,i,e,o){var c=o.z||t.length,l=new a(i+c+5*(1+Math.ceil(c/7e3))+e),p=l.subarray(i,l.length-e),v=o.l,g=7&(o.r||0);if(n){g&&(p[0]=o.r>>3);for(var y=R[n-1],b=y>>13,w=8191&y,z=(1<<r)-1,k=o.p||new s(32768),S=o.h||new s(z+1),M=Math.ceil(r/3),x=2*M,A=function(n){return(t[n]^t[n+1]<<M^t[n+2]<<x)&z},C=new u(25e3),T=new s(288),D=new s(32),U=0,I=0,Z=o.i||0,O=0,q=o.w||0,G=0;Z+2<c;++Z){var L=A(Z),$=32767&Z,j=S[L];if(k[$]=j,S[L]=$,q<=Z){var H=c-Z;if((U>7e3||O>24576)&&(H>423||!v)){g=P(t,p,0,C,T,D,I,O,G,Z-G,g),O=U=I=0,G=Z;for(var B=0;B<286;++B)T[B]=0;for(B=0;B<30;++B)D[B]=0}var W=2,Y=0,_=w,J=$-j&32767;if(H>2&&L==A(Z-J))for(var K=Math.min(b,H)-1,Q=Math.min(32767,Z),V=Math.min(258,H);J<=Q&&--_&&$!=j;){if(t[Z+W]==t[Z+W-J]){for(var X=0;X<V&&t[Z+X]==t[Z+X-J];++X);if(X>W){if(W=X,Y=J,X>K)break;var tt=Math.min(J,X-2),nt=0;for(B=0;B<tt;++B){var rt=Z-J+B&32767,it=rt-k[rt]&32767;it>nt&&(nt=it,j=rt)}}}J+=($=j)-(j=k[$])&32767}if(Y){C[O++]=268435456|d[W]<<18|m[Y];var et=31&d[W],ot=31&m[Y];I+=h[et]+f[ot],++T[257+et],++D[ot],q=Z+W,++U}else C[O++]=t[Z],++T[t[Z]]}}for(Z=Math.max(Z,q);Z<c;++Z)C[O++]=t[Z],++T[t[Z]];g=P(t,p,v,C,T,D,I,O,G,Z-G,g),v||(o.r=7&g|p[g/8|0]<<3,g-=7,o.h=S,o.p=k,o.i=Z,o.w=q)}else{for(Z=o.w||0;Z<c+v;Z+=65535){var at=Z+65535;at>=c&&(p[g/8|0]=v,at=c),g=N(p,g+1,t.subarray(Z,at))}o.i=c}return E(l,0,i+F(g)+e)},_=function(){for(var t=new Int32Array(256),n=0;n<256;++n){for(var r=n,i=9;--i;)r=(1&r&&-306674912)^r>>>1;t[n]=r}return t}(),J=function(){var t=-1;return{p:function(n){for(var r=t,i=0;i<n.length;++i)r=_[255&r^n[i]]^r>>>8;t=r},d:function(){return~t}}},K=function(){var t=1,n=0;return{p:function(r){for(var i=t,e=n,o=0|r.length,a=0;a!=o;){for(var s=Math.min(a+2655,o);a<s;++a)e+=i+=r[a];i=(65535&i)+15*(i>>16),e=(65535&e)+15*(e>>16)}t=i,n=e},d:function(){return(255&(t%=65521))<<24|(65280&t)<<8|(255&(n%=65521))<<8|n>>8}}},Q=function(t,n,r,i,e){if(!e&&(e={l:1},n.dictionary)){var o=n.dictionary.subarray(-32768),s=new a(o.length+t.length);s.set(o),s.set(t,o.length),t=s,e.w=o.length}return Y(t,null==n.level?6:n.level,null==n.mem?e.l?Math.ceil(1.5*Math.max(8,Math.min(13,Math.log(t.length)))):20:12+n.mem,r,i,e)},V=function(t,n){var r={};for(var i in t)r[i]=t[i];for(var i in n)r[i]=n[i];return r},X=function(t,n,r){for(var i=t(),e=t.toString(),o=e.slice(e.indexOf("[")+1,e.lastIndexOf("]")).replace(/\s+/g,"").split(","),a=0;a<i.length;++a){var s=i[a],u=o[a];if("function"==typeof s){n+=";"+u+"=";var h=s.toString();if(s.prototype)if(-1!=h.indexOf("[native code]")){var f=h.indexOf(" ",8)+1;n+=h.slice(f,h.indexOf("(",f))}else for(var c in n+=h,s.prototype)n+=";"+u+".prototype."+c+"="+s.prototype[c].toString();else n+=h}else r[u]=s}return n},tt=[],nt=function(t,n,r,i){if(!tt[r]){for(var e="",a={},s=t.length-1,u=0;u<s;++u)e=X(t[u],e,a);tt[r]={c:X(t[s],e,a),e:a}}var h=V({},tt[r].e);return function(t,n,r,i,e){var a=new Worker(o[n]||(o[n]=URL.createObjectURL(new Blob([t+';addEventListener("error",function(e){e=e.error;postMessage({$e$:[e.message,e.code,e.stack]})})'],{type:"text/javascript"}))));return a.onmessage=function(t){var n=t.data,r=n.$e$;if(r){var i=new Error(r[0]);i.code=r[1],i.stack=r[2],e(i,null)}else e(null,n)},a.postMessage(r,i),a}(tt[r].c+";onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage="+n.toString()+"}",r,h,function(t){var n=[];for(var r in t)t[r].buffer&&n.push((t[r]=new t[r].constructor(t[r])).buffer);return n}(h),i)},rt=function(){return[a,s,u,h,f,c,v,y,A,T,b,Z,k,D,U,I,F,E,O,q,It,ut,ht]},it=function(){return[a,s,u,h,f,c,d,m,x,S,C,M,b,R,W,k,G,L,$,j,H,B,N,P,F,E,Y,Q,Ct,ut]},et=function(){return[yt,wt,gt,J,_]},ot=function(){return[mt,bt]},at=function(){return[zt,gt,K]},st=function(){return[kt]},ut=function(t){return postMessage(t,[t.buffer])},ht=function(t){return t&&{out:t.size&&new a(t.size),dictionary:t.dictionary}},ft=function(t,n,r,i,e,o){var a=nt(r,i,e,(function(t,n){a.terminate(),o(t,n)}));return a.postMessage([t,n],n.consume?[t.buffer]:[]),function(){a.terminate()}},ct=function(t){return t.ondata=function(t,n){return postMessage([t,n],[t.buffer])},function(n){n.data.length?(t.push(n.data[0],n.data[1]),postMessage([n.data[0].length])):t.flush()}},lt=function(t,n,r,i,e,o,a){var s,u=nt(t,i,e,(function(t,r){t?(u.terminate(),n.ondata.call(n,t)):Array.isArray(r)?1==r.length?(n.queuedSize-=r[0],n.ondrain&&n.ondrain(r[0])):(r[1]&&u.terminate(),n.ondata.call(n,t,r[0],r[1])):a(r)}));u.postMessage(r),n.queuedSize=0,n.push=function(t,r){n.ondata||O(5),s&&n.ondata(O(4,0,1),null,!!r),n.queuedSize+=t.length,u.postMessage([t,s=r],[t.buffer])},n.terminate=function(){u.terminate()},o&&(n.flush=function(){u.postMessage([])})},pt=function(t,n){return t[n]|t[n+1]<<8},vt=function(t,n){return(t[n]|t[n+1]<<8|t[n+2]<<16|t[n+3]<<24)>>>0},dt=function(t,n){return vt(t,n)+4294967296*vt(t,n+4)},gt=function(t,n,r){for(;r;++n)t[n]=r,r>>>=8},yt=function(t,n){var r=n.filename;if(t[0]=31,t[1]=139,t[2]=8,t[8]=n.level<2?4:9==n.level?2:0,t[9]=3,0!=n.mtime&&gt(t,4,Math.floor(new Date(n.mtime||Date.now())/1e3)),r){t[3]=8;for(var i=0;i<=r.length;++i)t[i+10]=r.charCodeAt(i)}},mt=function(t){31==t[0]&&139==t[1]&&8==t[2]||O(6,"invalid gzip data");var n=t[3],r=10;4&n&&(r+=2+(t[10]|t[11]<<8));for(var i=(n>>3&1)+(n>>4&1);i>0;i-=!t[r++]);return r+(2&n)},bt=function(t){var n=t.length;return(t[n-4]|t[n-3]<<8|t[n-2]<<16|t[n-1]<<24)>>>0},wt=function(t){return 10+(t.filename?t.filename.length+1:0)},zt=function(t,n){var r=n.level,i=0==r?0:r<6?1:9==r?3:2;if(t[0]=120,t[1]=i<<6|(n.dictionary&&32),t[1]|=31-(t[0]<<8|t[1])%31,n.dictionary){var e=K();e.p(n.dictionary),gt(t,2,e.d())}},kt=function(t,n){return(8!=(15&t[0])||t[0]>>4>7||(t[0]<<8|t[1])%31)&&O(6,"invalid zlib data"),(t[1]>>5&1)==+!n&&O(6,"invalid zlib data: "+(32&t[1]?"need":"unexpected")+" dictionary"),2+(t[1]>>3&4)};function St(t,n){return"function"==typeof t&&(n=t,t={}),this.ondata=n,t}var Mt=function(){function t(t,n){if("function"==typeof t&&(n=t,t={}),this.ondata=n,this.o=t||{},this.s={l:0,i:32768,w:32768,z:32768},this.b=new a(98304),this.o.dictionary){var r=this.o.dictionary.subarray(-32768);this.b.set(r,32768-r.length),this.s.i=32768-r.length}}return t.prototype.p=function(t,n){this.ondata(Q(t,this.o,0,0,this.s),n)},t.prototype.push=function(t,n){this.ondata||O(5),this.s.l&&O(4);var r=t.length+this.s.z;if(r>this.b.length){if(r>2*this.b.length-32768){var i=new a(-32768&r);i.set(this.b.subarray(0,this.s.z)),this.b=i}var e=this.b.length-this.s.z;this.b.set(t.subarray(0,e),this.s.z),this.s.z=this.b.length,this.p(this.b,!1),this.b.set(this.b.subarray(-32768)),this.b.set(t.subarray(e),32768),this.s.z=t.length-e+32768,this.s.i=32766,this.s.w=32768}else this.b.set(t,this.s.z),this.s.z+=t.length;this.s.l=1&n,(this.s.z>this.s.w+8191||n)&&(this.p(this.b,n||!1),this.s.w=this.s.i,this.s.i-=2)},t.prototype.flush=function(){this.ondata||O(5),this.s.l&&O(4),this.p(this.b,!1),this.s.w=this.s.i,this.s.i-=2},t}();r.Deflate=Mt;var xt=function(){return function(t,n){lt([it,function(){return[ct,Mt]}],this,St.call(this,t,n),(function(t){var n=new Mt(t.data);onmessage=ct(n)}),6,1)}}();function At(t,n,r){return r||(r=n,n={}),"function"!=typeof r&&O(7),ft(t,n,[it],(function(t){return ut(Ct(t.data[0],t.data[1]))}),0,r)}function Ct(t,n){return Q(t,n||{},0,0)}r.AsyncDeflate=xt;var Tt=function(){function t(t,n){"function"==typeof t&&(n=t,t={}),this.ondata=n;var r=t&&t.dictionary&&t.dictionary.subarray(-32768);this.s={i:0,b:r?r.length:0},this.o=new a(32768),this.p=new a(0),r&&this.o.set(r)}return t.prototype.e=function(t){if(this.ondata||O(5),this.d&&O(4),this.p.length){if(t.length){var n=new a(this.p.length+t.length);n.set(this.p),n.set(t,this.p.length),this.p=n}}else this.p=t},t.prototype.c=function(t){this.s.i=+(this.d=t||!1);var n=this.s.b,r=q(this.p,this.s,this.o);this.ondata(E(r,n,this.s.b),this.d),this.o=E(r,this.s.b-32768),this.s.b=this.o.length,this.p=E(this.p,this.s.p/8|0),this.s.p&=7},t.prototype.push=function(t,n){this.e(t),this.c(n)},t}();r.Inflate=Tt;var Dt=function(){return function(t,n){lt([rt,function(){return[ct,Tt]}],this,St.call(this,t,n),(function(t){var n=new Tt(t.data);onmessage=ct(n)}),7,0)}}();function Ut(t,n,r){return r||(r=n,n={}),"function"!=typeof r&&O(7),ft(t,n,[rt],(function(t){return ut(It(t.data[0],ht(t.data[1])))}),1,r)}function It(t,n){return q(t,{i:2},n&&n.out,n&&n.dictionary)}r.AsyncInflate=Dt;var Ft=function(){function t(t,n){this.c=J(),this.l=0,this.v=1,Mt.call(this,t,n)}return t.prototype.push=function(t,n){this.c.p(t),this.l+=t.length,Mt.prototype.push.call(this,t,n)},t.prototype.p=function(t,n){var r=Q(t,this.o,this.v&&wt(this.o),n&&8,this.s);this.v&&(yt(r,this.o),this.v=0),n&&(gt(r,r.length-8,this.c.d()),gt(r,r.length-4,this.l)),this.ondata(r,n)},t.prototype.flush=function(){Mt.prototype.flush.call(this)},t}();r.Gzip=Ft,r.Compress=Ft;var Et=function(){return function(t,n){lt([it,et,function(){return[ct,Mt,Ft]}],this,St.call(this,t,n),(function(t){var n=new Ft(t.data);onmessage=ct(n)}),8,1)}}();function Zt(t,n,r){return r||(r=n,n={}),"function"!=typeof r&&O(7),ft(t,n,[it,et,function(){return[Ot]}],(function(t){return ut(Ot(t.data[0],t.data[1]))}),2,r)}function Ot(t,n){n||(n={});var r=J(),i=t.length;r.p(t);var e=Q(t,n,wt(n),8),o=e.length;return yt(e,n),gt(e,o-8,r.d()),gt(e,o-4,i),e}r.AsyncGzip=Et,r.AsyncCompress=Et;var qt=function(){function t(t,n){this.v=1,this.r=0,Tt.call(this,t,n)}return t.prototype.push=function(t,n){if(Tt.prototype.e.call(this,t),this.r+=t.length,this.v){var r=this.p.subarray(this.v-1),i=r.length>3?mt(r):4;if(i>r.length){if(!n)return}else this.v>1&&this.onmember&&this.onmember(this.r-r.length);this.p=r.subarray(i),this.v=0}Tt.prototype.c.call(this,n),!this.s.f||this.s.l||n||(this.v=F(this.s.p)+9,this.s={i:0},this.o=new a(0),this.push(new a(0),n))},t}();r.Gunzip=qt;var Gt=function(){return function(t,n){var r=this;lt([rt,ot,function(){return[ct,Tt,qt]}],this,St.call(this,t,n),(function(t){var n=new qt(t.data);n.onmember=function(t){return postMessage(t)},onmessage=ct(n)}),9,0,(function(t){return r.onmember&&r.onmember(t)}))}}();function Lt(t,n,r){return r||(r=n,n={}),"function"!=typeof r&&O(7),ft(t,n,[rt,ot,function(){return[$t]}],(function(t){return ut($t(t.data[0],t.data[1]))}),3,r)}function $t(t,n){var r=mt(t);return r+8>t.length&&O(6,"invalid gzip data"),q(t.subarray(r,-8),{i:2},n&&n.out||new a(bt(t)),n&&n.dictionary)}r.AsyncGunzip=Gt;var jt=function(){function t(t,n){this.c=K(),this.v=1,Mt.call(this,t,n)}return t.prototype.push=function(t,n){this.c.p(t),Mt.prototype.push.call(this,t,n)},t.prototype.p=function(t,n){var r=Q(t,this.o,this.v&&(this.o.dictionary?6:2),n&&4,this.s);this.v&&(zt(r,this.o),this.v=0),n&&gt(r,r.length-4,this.c.d()),this.ondata(r,n)},t.prototype.flush=function(){Mt.prototype.flush.call(this)},t}();r.Zlib=jt;var Ht=function(){return function(t,n){lt([it,at,function(){return[ct,Mt,jt]}],this,St.call(this,t,n),(function(t){var n=new jt(t.data);onmessage=ct(n)}),10,1)}}();function Bt(t,n){n||(n={});var r=K();r.p(t);var i=Q(t,n,n.dictionary?6:2,4);return zt(i,n),gt(i,i.length-4,r.d()),i}r.AsyncZlib=Ht;var Nt=function(){function t(t,n){Tt.call(this,t,n),this.v=t&&t.dictionary?2:1}return t.prototype.push=function(t,n){if(Tt.prototype.e.call(this,t),this.v){if(this.p.length<6&&!n)return;this.p=this.p.subarray(kt(this.p,this.v-1)),this.v=0}n&&(this.p.length<4&&O(6,"invalid zlib data"),this.p=this.p.subarray(0,-4)),Tt.prototype.c.call(this,n)},t}();r.Unzlib=Nt;var Pt=function(){return function(t,n){lt([rt,st,function(){return[ct,Tt,Nt]}],this,St.call(this,t,n),(function(t){var n=new Nt(t.data);onmessage=ct(n)}),11,0)}}();function Rt(t,n,r){return r||(r=n,n={}),"function"!=typeof r&&O(7),ft(t,n,[rt,st,function(){return[Wt]}],(function(t){return ut(Wt(t.data[0],ht(t.data[1])))}),5,r)}function Wt(t,n){return q(t.subarray(kt(t,n&&n.dictionary),-4),{i:2},n&&n.out,n&&n.dictionary)}r.AsyncUnzlib=Pt;var Yt=function(){function t(t,n){this.o=St.call(this,t,n)||{},this.G=qt,this.I=Tt,this.Z=Nt}return t.prototype.i=function(){var t=this;this.s.ondata=function(n,r){t.ondata(n,r)}},t.prototype.push=function(t,n){if(this.ondata||O(5),this.s)this.s.push(t,n);else{if(this.p&&this.p.length){var r=new a(this.p.length+t.length);r.set(this.p),r.set(t,this.p.length)}else this.p=t;this.p.length>2&&(this.s=31==this.p[0]&&139==this.p[1]&&8==this.p[2]?new this.G(this.o):8!=(15&this.p[0])||this.p[0]>>4>7||(this.p[0]<<8|this.p[1])%31?new this.I(this.o):new this.Z(this.o),this.i(),this.s.push(this.p,n),this.p=null)}},t}();r.Decompress=Yt;var _t=function(){function t(t,n){Yt.call(this,t,n),this.queuedSize=0,this.G=Gt,this.I=Dt,this.Z=Pt}return t.prototype.i=function(){var t=this;this.s.ondata=function(n,r,i){t.ondata(n,r,i)},this.s.ondrain=function(n){t.queuedSize-=n,t.ondrain&&t.ondrain(n)}},t.prototype.push=function(t,n){this.queuedSize+=t.length,Yt.prototype.push.call(this,t,n)},t}();r.AsyncDecompress=_t;var Jt=function(t,n,r,i){for(var e in t){var o=t[e],s=n+e,u=i;Array.isArray(o)&&(u=V(i,o[1]),o=o[0]),o instanceof a?r[s]=[o,u]:(r[s+="/"]=[new a(0),u],Jt(o,s,r,i))}},Kt="undefined"!=typeof TextEncoder&&new TextEncoder,Qt="undefined"!=typeof TextDecoder&&new TextDecoder,Vt=0;try{Qt.decode(W,{stream:!0}),Vt=1}catch(t){}var Xt=function(t){for(var n="",r=0;;){var i=t[r++],e=(i>127)+(i>223)+(i>239);if(r+e>t.length)return{s:n,r:E(t,r-1)};e?3==e?(i=((15&i)<<18|(63&t[r++])<<12|(63&t[r++])<<6|63&t[r++])-65536,n+=String.fromCharCode(55296|i>>10,56320|1023&i)):n+=1&e?String.fromCharCode((31&i)<<6|63&t[r++]):String.fromCharCode((15&i)<<12|(63&t[r++])<<6|63&t[r++]):n+=String.fromCharCode(i)}},tn=function(){function t(t){this.ondata=t,Vt?this.t=new TextDecoder:this.p=W}return t.prototype.push=function(t,n){if(this.ondata||O(5),n=!!n,this.t)return this.ondata(this.t.decode(t,{stream:!0}),n),void(n&&(this.t.decode().length&&O(8),this.t=null));this.p||O(4);var r=new a(this.p.length+t.length);r.set(this.p),r.set(t,this.p.length);var i=Xt(r),e=i.s,o=i.r;n?(o.length&&O(8),this.p=null):this.p=o,this.ondata(e,n)},t}();r.DecodeUTF8=tn;var nn=function(){function t(t){this.ondata=t}return t.prototype.push=function(t,n){this.ondata||O(5),this.d&&O(4),this.ondata(rn(t),this.d=n||!1)},t}();function rn(t,n){if(n){for(var r=new a(t.length),i=0;i<t.length;++i)r[i]=t.charCodeAt(i);return r}if(Kt)return Kt.encode(t);var e=t.length,o=new a(t.length+(t.length>>1)),s=0,u=function(t){o[s++]=t};for(i=0;i<e;++i){if(s+5>o.length){var h=new a(s+8+(e-i<<1));h.set(o),o=h}var f=t.charCodeAt(i);f<128||n?u(f):f<2048?(u(192|f>>6),u(128|63&f)):f>55295&&f<57344?(u(240|(f=65536+(1047552&f)|1023&t.charCodeAt(++i))>>18),u(128|f>>12&63),u(128|f>>6&63),u(128|63&f)):(u(224|f>>12),u(128|f>>6&63),u(128|63&f))}return E(o,0,s)}function en(t,n){if(n){for(var r="",i=0;i<t.length;i+=16384)r+=String.fromCharCode.apply(null,t.subarray(i,i+16384));return r}if(Qt)return Qt.decode(t);var e=Xt(t),o=e.s;return(r=e.r).length&&O(8),o}r.EncodeUTF8=nn;var on=function(t){return 1==t?3:t<6?2:9==t?1:0},an=function(t,n){return n+30+pt(t,n+26)+pt(t,n+28)},sn=function(t,n,r){var i=pt(t,n+28),e=en(t.subarray(n+46,n+46+i),!(2048&pt(t,n+8))),o=n+46+i,a=vt(t,n+20),s=r&&4294967295==a?un(t,o):[a,vt(t,n+24),vt(t,n+42)],u=s[0],h=s[1],f=s[2];return[pt(t,n+10),u,h,e,o+pt(t,n+30)+pt(t,n+32),f]},un=function(t,n){for(;1!=pt(t,n);n+=4+pt(t,n+2));return[dt(t,n+12),dt(t,n+4),dt(t,n+20)]},hn=function(t){var n=0;if(t)for(var r in t){var i=t[r].length;i>65535&&O(9),n+=i+4}return n},fn=function(t,n,r,i,e,o,a,s){var u=i.length,h=r.extra,f=s&&s.length,c=hn(h);gt(t,n,null!=a?33639248:67324752),n+=4,null!=a&&(t[n++]=20,t[n++]=r.os),t[n]=20,n+=2,t[n++]=r.flag<<1|(o<0&&8),t[n++]=e&&8,t[n++]=255&r.compression,t[n++]=r.compression>>8;var l=new Date(null==r.mtime?Date.now():r.mtime),p=l.getFullYear()-1980;if((p<0||p>119)&&O(10),gt(t,n,p<<25|l.getMonth()+1<<21|l.getDate()<<16|l.getHours()<<11|l.getMinutes()<<5|l.getSeconds()>>1),n+=4,-1!=o&&(gt(t,n,r.crc),gt(t,n+4,o<0?-o-2:o),gt(t,n+8,r.size)),gt(t,n+12,u),gt(t,n+14,c),n+=16,null!=a&&(gt(t,n,f),gt(t,n+6,r.attrs),gt(t,n+10,a),n+=14),t.set(i,n),n+=u,c)for(var v in h){var d=h[v],g=d.length;gt(t,n,+v),gt(t,n+2,g),t.set(d,n+4),n+=4+g}return f&&(t.set(s,n),n+=f),n},cn=function(t,n,r,i,e){gt(t,n,101010256),gt(t,n+8,r),gt(t,n+10,r),gt(t,n+12,i),gt(t,n+16,e)},ln=function(){function t(t){this.filename=t,this.c=J(),this.size=0,this.compression=0}return t.prototype.process=function(t,n){this.ondata(null,t,n)},t.prototype.push=function(t,n){this.ondata||O(5),this.c.p(t),this.size+=t.length,n&&(this.crc=this.c.d()),this.process(t,n||!1)},t}();r.ZipPassThrough=ln;var pn=function(){function t(t,n){var r=this;n||(n={}),ln.call(this,t),this.d=new Mt(n,(function(t,n){r.ondata(null,t,n)})),this.compression=8,this.flag=on(n.level)}return t.prototype.process=function(t,n){try{this.d.push(t,n)}catch(t){this.ondata(t,null,n)}},t.prototype.push=function(t,n){ln.prototype.push.call(this,t,n)},t}();r.ZipDeflate=pn;var vn=function(){function t(t,n){var r=this;n||(n={}),ln.call(this,t),this.d=new xt(n,(function(t,n,i){r.ondata(t,n,i)})),this.compression=8,this.flag=on(n.level),this.terminate=this.d.terminate}return t.prototype.process=function(t,n){this.d.push(t,n)},t.prototype.push=function(t,n){ln.prototype.push.call(this,t,n)},t}();r.AsyncZipDeflate=vn;var dn=function(){function t(t){this.ondata=t,this.u=[],this.d=1}return t.prototype.add=function(t){var n=this;if(this.ondata||O(5),2&this.d)this.ondata(O(4+8*(1&this.d),0,1),null,!1);else{var r=rn(t.filename),i=r.length,e=t.comment,o=e&&rn(e),s=i!=t.filename.length||o&&e.length!=o.length,u=i+hn(t.extra)+30;i>65535&&this.ondata(O(11,0,1),null,!1);var h=new a(u);fn(h,0,t,r,s,-1);var f=[h],c=function(){for(var t=0,r=f;t<r.length;t++){var i=r[t];n.ondata(null,i,!1)}f=[]},l=this.d;this.d=0;var p=this.u.length,v=V(t,{f:r,u:s,o,t:function(){t.terminate&&t.terminate()},r:function(){if(c(),l){var t=n.u[p+1];t?t.r():n.d=1}l=1}}),d=0;t.ondata=function(r,i,e){if(r)n.ondata(r,i,e),n.terminate();else if(d+=i.length,f.push(i),e){var o=new a(16);gt(o,0,134695760),gt(o,4,t.crc),gt(o,8,d),gt(o,12,t.size),f.push(o),v.c=d,v.b=u+d+16,v.crc=t.crc,v.size=t.size,l&&v.r(),l=1}else l&&c()},this.u.push(v)}},t.prototype.end=function(){var t=this;2&this.d?this.ondata(O(4+8*(1&this.d),0,1),null,!0):(this.d?this.e():this.u.push({r:function(){1&t.d&&(t.u.splice(-1,1),t.e())},t:function(){}}),this.d=3)},t.prototype.e=function(){for(var t=0,n=0,r=0,i=0,e=this.u;i<e.length;i++){r+=46+(h=e[i]).f.length+hn(h.extra)+(h.o?h.o.length:0)}for(var o=new a(r+22),s=0,u=this.u;s<u.length;s++){var h=u[s];fn(o,t,h,h.f,h.u,-h.c-2,n,h.o),t+=46+h.f.length+hn(h.extra)+(h.o?h.o.length:0),n+=h.b}cn(o,t,this.u.length,r,n),this.ondata(null,o,!0),this.d=2},t.prototype.terminate=function(){for(var t=0,n=this.u;t<n.length;t++){n[t].t()}this.d=2},t}();r.Zip=dn;var gn=function(){function t(){}return t.prototype.push=function(t,n){this.ondata(null,t,n)},t.compression=0,t}();r.UnzipPassThrough=gn;var yn=function(){function t(){var t=this;this.i=new Tt((function(n,r){t.ondata(null,n,r)}))}return t.prototype.push=function(t,n){try{this.i.push(t,n)}catch(t){this.ondata(t,null,n)}},t.compression=8,t}();r.UnzipInflate=yn;var mn=function(){function t(t,n){var r=this;n<32e4?this.i=new Tt((function(t,n){r.ondata(null,t,n)})):(this.i=new Dt((function(t,n,i){r.ondata(t,n,i)})),this.terminate=this.i.terminate)}return t.prototype.push=function(t,n){this.i.terminate&&(t=E(t,0)),this.i.push(t,n)},t.compression=8,t}();r.AsyncUnzipInflate=mn;var bn=function(){function t(t){this.onfile=t,this.k=[],this.o={0:gn},this.p=W}return t.prototype.push=function(t,n){var r=this;if(this.onfile||O(5),this.p||O(4),this.c>0){var i=Math.min(this.c,t.length),e=t.subarray(0,i);if(this.c-=i,this.d?this.d.push(e,!this.c):this.k[0].push(e),(t=t.subarray(i)).length)return this.push(t,n)}else{var o=0,s=0,u=void 0,h=void 0;this.p.length?t.length?((h=new a(this.p.length+t.length)).set(this.p),h.set(t,this.p.length)):h=this.p:h=t;for(var f=h.length,c=this.c,l=c&&this.d,p=function(){var t,n=vt(h,s);if(67324752==n){o=1,u=s,v.d=null,v.c=0;var i=pt(h,s+6),e=pt(h,s+8),a=2048&i,l=8&i,p=pt(h,s+26),d=pt(h,s+28);if(f>s+30+p+d){var g=[];v.k.unshift(g),o=2;var y,m=vt(h,s+18),b=vt(h,s+22),w=en(h.subarray(s+30,s+=30+p),!a);4294967295==m?(t=l?[-2]:un(h,s),m=t[0],b=t[1]):l&&(m=-1),s+=d,v.c=m;var z={name:w,compression:e,start:function(){if(z.ondata||O(5),m){var t=r.o[e];t||z.ondata(O(14,"unknown compression type "+e,1),null,!1),(y=m<0?new t(w):new t(w,m,b)).ondata=function(t,n,r){z.ondata(t,n,r)};for(var n=0,i=g;n<i.length;n++){var o=i[n];y.push(o,!1)}r.k[0]==g&&r.c?r.d=y:y.push(W,!0)}else z.ondata(null,W,!0)},terminate:function(){y&&y.terminate&&y.terminate()}};m>=0&&(z.size=m,z.originalSize=b),v.onfile(z)}return"break"}if(c){if(134695760==n)return u=s+=12+(-2==c&&8),o=3,v.c=0,"break";if(33639248==n)return u=s-=4,o=3,v.c=0,"break"}},v=this;s<f-4;++s){if("break"===p())break}if(this.p=W,c<0){var d=o?h.subarray(0,u-12-(-2==c&&8)-(134695760==vt(h,u-16)&&4)):h.subarray(0,s);l?l.push(d,!!o):this.k[+(2==o)].push(d)}if(2&o)return this.push(h.subarray(s),n);this.p=h.subarray(s)}n&&(this.c&&O(13),this.p=null)},t.prototype.register=function(t){this.o[t.compression]=t},t}();r.Unzip=bn;var wn="function"==typeof queueMicrotask?queueMicrotask:"function"==typeof setTimeout?setTimeout:function(t){t()}},
function _(n,c,f,i,o){i()},
function _(s,t,e,n,i){n();class c{constructor(){this.listeners=new Set}connect(s){this.listeners.add(s)}disconnect(s){this.listeners.delete(s)}report(s){for(const t of this.listeners)t(s)}}e.Diagnostics=c,c.__name__="Diagnostics",e.diagnostics=new c},
function _(r,t,e,a,s){a(),e.min=function(r){return r.is_Scalar()?r.value:l.min(r.array)},e.max=function(r){return r.is_Scalar()?r.value:l.max(r.array)},e.some=function(r,t){return r.is_Scalar()?t(r.value):l.some(r.array,t)},e.every=function(r,t){return r.is_Scalar()?t(r.value):l.every(r.array,t)};const n=r(1),i=r(27),l=n.__importStar(r(13));class u{is_Scalar(){return this.is_scalar}is_Vector(){return!this.is_scalar}}e.Uniform=u,u.__name__="Uniform";class o extends u{constructor(r,t){super(),this.is_scalar=!0,this.value=r,this.length=t}get(r){return this.value}*[Symbol.iterator](){const{length:r,value:t}=this;for(let e=0;e<r;e++)yield t}select(r){return new o(this.value,r.count)}[i.equals](r,t){return t.eq(this.length,r.length)&&t.eq(this.value,r.value)}map(r){return new o(r(this.value),this.length)}unique(){return[this.value]}}e.UniformScalar=o,o.__name__="UniformScalar";class c extends u{constructor(r){super(),this.is_scalar=!1,this.array=r,this.length=this.array.length}get(r){return this.array[r]}*[Symbol.iterator](){yield*this.array}select(r){const t=r.select(this.array);return new this.constructor(t)}[i.equals](r,t){return t.eq(this.length,r.length)&&t.eq(this.array,r.array)}map(r){return new c(l.map(this.array,r))}unique(){return[...new Set(this.array)]}}e.UniformVector=c,c.__name__="UniformVector";class h extends c{constructor(r){super(r),this.array=r,this._view=new DataView(r.buffer)}get(r){return this._view.getUint32(4*r)}*[Symbol.iterator](){const r=this.length;for(let t=0;t<r;t++)yield this.get(t)}copy_buffer(){return this.array.buffer.slice()}}e.ColorUniformVector=h,h.__name__="ColorUniformVector"},
function _(e,t,r,n,u){n(),r.uuid4=s,r.unique_id=function(e){const t=c.settings.dev?"j"+a++:s();return null!=e?`${e}-${t}`:t},r.escape=function(e){return e.replace(/(?:[&<>"'`])/g,(e=>{switch(e){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return e}}))},r.unescape=function(e){return e.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,((e,t)=>{switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},r.use_strict=function(e){return`'use strict';\n${e}`},r.to_fixed=function(e,t){return e.toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")},r.insert_text_on_position=function(e,t,r){const n=[];return n.push(e.slice(0,t)),n.push(r),n.push(e.slice(t)),n.join("")};const c=e(30);function s(){const e=new Array(32),t="0123456789ABCDEF";for(let r=0;r<32;r++)e[r]=t[Math.floor(16*Math.random())];return e[12]="4",e[16]=t[3&e[16].charCodeAt(0)|8],e.join("")}let a=1e3},
function _(e,t,s,n,a){n();const i=e(27),r=e(33);class d{constructor(e){this.sync=!0,this.document=e}get[Symbol.toStringTag](){return this.constructor.__name__}[i.equals](e,t){return t.eq(this.document,e.document)}}s.DocumentEvent=d,d.__name__="DocumentEvent";class o extends d{constructor(e,t){super(e),this.events=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.events,e.events)}}s.DocumentEventBatch=o,o.__name__="DocumentEventBatch";class l extends d{}s.DocumentChangedEvent=l,l.__name__="DocumentChangedEvent";class h extends l{constructor(e,t,s){super(e),this.kind="MessageSent",this.msg_type=t,this.msg_data=s}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.msg_type,e.msg_type)&&t.eq(this.msg_data,e.msg_data)}[r.serialize](e){return{kind:this.kind,msg_type:this.msg_type,msg_data:e.encode(this.msg_data)}}}s.MessageSentEvent=h,h.__name__="MessageSentEvent";class u extends l{constructor(e,t,s,n){super(e),this.kind="ModelChanged",this.model=t,this.attr=s,this.value=n}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.value,e.value)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,new:e.encode(this.value)}}}s.ModelChangedEvent=u,u.__name__="ModelChangedEvent";class m extends l{constructor(e,t,s,n,a){super(e),this.kind="ColumnDataChanged",this.model=t,this.attr=s,this.data=n,this.cols=a}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.cols,e.cols)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),cols:this.cols}}}s.ColumnDataChangedEvent=m,m.__name__="ColumnDataChangedEvent";class c extends l{constructor(e,t,s,n,a){super(e),this.kind="ColumnsStreamed",this.model=t,this.attr=s,this.data=n,this.rollover=a}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.rollover,e.rollover)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),rollover:this.rollover}}}s.ColumnsStreamedEvent=c,c.__name__="ColumnsStreamedEvent";class _ extends l{constructor(e,t,s,n){super(e),this.kind="ColumnsPatched",this.model=t,this.attr=s,this.patches=n}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.patches,e.patches)}[r.serialize](e){return{kind:this.kind,attr:this.attr,model:this.model.ref(),patches:e.encode(this.patches)}}}s.ColumnsPatchedEvent=_,_.__name__="ColumnsPatchedEvent";class q extends l{constructor(e,t){super(e),this.kind="TitleChanged",this.title=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.title,e.title)}[r.serialize](e){return{kind:this.kind,title:this.title}}}s.TitleChangedEvent=q,q.__name__="TitleChangedEvent";class v extends l{constructor(e,t){super(e),this.kind="RootAdded",this.model=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:e.encode(this.model)}}}s.RootAddedEvent=v,v.__name__="RootAddedEvent";class p extends l{constructor(e,t){super(e),this.kind="RootRemoved",this.model=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:this.model.ref()}}}s.RootRemovedEvent=p,p.__name__="RootRemovedEvent"},
function _(t,r,i,e,n){e(),i.to_string=function(t,r){return new c(r).to_string(t)};const s=t(8),o=t(9);i.pretty=Symbol("pretty");class c{constructor(t){this.visited=new Set,this.precision=t?.precision}to_string(t){if((0,s.isObject)(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return(0,s.isObject)(t)&&i.pretty in t}(t)?t[i.pretty](this):(0,s.isBoolean)(t)?this.boolean(t):(0,s.isNumber)(t)?this.number(t):(0,s.isString)(t)?this.string(t):(0,s.isArray)(t)?this.array(t):(0,s.isIterable)(t)?this.iterable(t):(0,s.isPlainObject)(t)?this.object(t):(0,s.isSymbol)(t)?this.symbol(t):t instanceof ArrayBuffer?this.array_buffer(t):`${t}`}token(t){return t}boolean(t){return`${t}`}number(t){return null!=this.precision?t.toFixed(this.precision):`${t}`}string(t){const r=t.includes("'"),i=t.includes('"');return r&&i?`\`${t.replace(/`/g,"\\`")}\``:i?`'${t}'`:`"${t}"`}symbol(t){return t.toString()}array(t){const r=this.token,i=[];for(const r of t)i.push(this.to_string(r));return`${r("[")}${i.join(`${r(",")} `)}${r("]")}`}iterable(t){const r=this.token,i=Object(t)[Symbol.toStringTag]??"Object",e=this.array(t);return`${i}${r("(")}${e}${r(")")}`}object(t){const r=this.token,i=[];for(const[e,n]of(0,o.entries)(t))i.push(`${e}${r(":")} ${this.to_string(n)}`);return`${r("{")}${i.join(`${r(",")} `)}${r("}")}`}array_buffer(t){return`ArrayBuffer(#${t.byteLength})`}}i.Printer=c,c.__name__="Printer"},
function _(t,r,n,e,o){e(),n.stream_to_column=a,n.slice=f,n.patch_to_column=p,n.stream_to_columns=function(t,r,n){const e=(0,u.dict)(t);for(const[t,o]of(0,u.dict)(r)){const r=e.get(t)??[];e.set(t,a(r,o,n))}},n.patch_to_columns=function(t,r){const n=(0,u.dict)(t);let e=new Set;for(const[t,o]of(0,u.dict)(r)){const r=n.get(t)??[];e=(0,l.union)(e,p(r,o))}return e};const s=t(1),c=t(8),u=t(9),l=t(45),i=s.__importStar(t(46));function a(t,r,n){if((0,c.isArray)(t)&&(0,c.isArray)(r)){const e=t.concat(r);return null!=n&&e.length>n?e.slice(-n):e}const e=t.length+r.length;if(null!=n&&e>n){const o=e-n,s=t.length,u=(()=>{if(t.length<n){const e=new((()=>{if((0,c.isTypedArray)(t))return t.constructor;if((0,c.isTypedArray)(r))return r.constructor;throw new Error("unsupported array types")})())(n);return e.set(t,0),e}return t})();for(let t=o,r=s;t<r;t++)u[t-o]=u[t];for(let t=0,n=r.length;t<n;t++)u[t+(s-o)]=r[t];return u}{const n=(()=>{if((0,c.isTypedArray)(t))return t;if((0,c.isTypedArray)(r))return new r.constructor(t);throw new Error("unsupported array types")})();return i.concat(n,r)}}function f(t,r){let n,e,o;return(0,c.isNumber)(t)?(n=t,o=t+1,e=1):(n=null!=t.start?t.start:0,o=null!=t.stop?t.stop:r,e=null!=t.step?t.step:1),[n,o,e]}function p(t,r){const n=new Set;let e=!1;for(const[o,s]of r){let r,u,l,i;if((0,c.isArray)(o)){const[e]=o;n.add(e),r=t[e].shape,u=t[e],i=s,2===o.length?(r=[1,r[0]],l=[o[0],0,o[1]]):l=o}else(0,c.isNumber)(o)?(i=[s],n.add(o)):(i=s,e=!0),l=[0,0,o],r=[1,t.length],u=t;let a=0;const[p,d,y]=f(l[1],r[0]),[h,_,g]=f(l[2],r[1]);for(let t=p;t<d;t+=y)for(let o=h;o<_;o+=g)e&&n.add(o),u[t*r[1]+o]=i[a],a++}return n}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(e,s,t,n,o){n();class r{constructor(e,s=[]){this._known_models=new Map,this.parent=e;for(const e of s)this.register(e)}get(e){return this._known_models.get(e)??this.parent?.get(e)??null}register(e,s=!1){const t=e.__qualified__;s||null==this.get(t)?this._known_models.set(t,e):console.warn(`Model '${t}' was already registered with this resolver`)}get names(){return[...this._known_models.keys()].sort()}}t.ModelResolver=r,r.__name__="ModelResolver"},
function _(e,r,t,s,n){s();const i=e(20),d=e(18),o=e(31),a=e(9),c=e(10),_=e(28),u=e(36),l=e(8),f=e(49),h=new Map;class y extends Error{}t.DeserializationError=y,y.__name__="DeserializationError";class p{static register(e,r){if(h.has(e))throw new Error(`'${e}' already registered for decoding`);h.set(e,r)}constructor(e,r=new Map,t){this._decoding=!1,this._buffers=new Map,this._finalizable=new Set,this.resolver=e,this.references=r,this.finalize=t}decode(e,r){if(null!=r)for(const[e,t]of r)this._buffers.set(e,t);if(this._decoding)return this._decode(e);let t;this._decoding=!0;const s=(()=>{try{return this._decode(e)}finally{t=new Set(this._finalizable),this._decoding=!1,this._buffers.clear(),this._finalizable.clear()}})();for(const e of t)this.finalize?.(e),e.finalize(),e.assert_initialized();for(const e of t)e.connect_signals();return s}_decode(e){if((0,l.isArray)(e))return this._decode_plain_array(e);if(!(0,l.isPlainObject)(e))return e;if(!(0,l.isString)(e.type))return(0,l.isString)(e.id)?this._decode_ref(e):this._decode_plain_object(e);{const r=h.get(e.type);if(null!=r)return r(e,this);switch(e.type){case"ref":return this._decode_ref(e);case"symbol":return this._decode_symbol(e);case"number":return this._decode_number(e);case"array":return this._decode_array(e);case"set":return this._decode_set(e);case"map":return this._decode_map(e);case"bytes":return this._decode_bytes(e);case"slice":return this._decode_slice(e);case"date":return this._decode_date(e);case"value":return this._decode_value(e);case"field":return this._decode_field(e);case"expr":return this._decode_expr(e);case"typed_array":return this._decode_typed_array(e);case"ndarray":return this._decode_ndarray(e);case"object":return(0,l.isString)(e.id)?this._decode_object_ref(e):this._decode_object(e);default:this.error(`unable to decode an object of type '${e.type}'`)}}}_decode_symbol(e){this.error(`can't resolve named symbol '${e.name}'`)}_decode_number(e){if("value"in e){const{value:r}=e;if((0,l.isString)(r))switch(r){case"nan":return NaN;case"+inf":return 1/0;case"-inf":return-1/0}else if((0,l.isNumber)(r))return r}this.error(`invalid number representation '${e}'`)}_decode_plain_array(e){return(0,c.map)(e,(e=>this._decode(e)))}_decode_plain_object(e){const r={};for(const[t,s]of(0,a.entries)(e))r[t]=this._decode(s);return r}_decode_array(e){const r=[];for(const t of e.entries??[])r.push(this._decode(t));return r}_decode_set(e){const r=new Set;for(const t of e.entries??[])r.add(this._decode(t));return r}_decode_map(e){const r=(0,c.map)(e.entries??[],(([e,r])=>[this._decode(e),this._decode(r)]));return r.every((([e,r])=>(0,l.isString)(e)))?Object.fromEntries(r):new Map(r)}_decode_bytes(e){const{data:r}=e;if(!(0,d.is_ref)(r))return(0,l.isString)(r)?(0,u.base64_to_buffer)(r):r.buffer;{const e=this._buffers.get(r.id);if(null!=e)return e;this.error(`buffer for id=${r.id} not found`)}}_decode_slice(e){const r=this._decode(e.start),t=this._decode(e.stop),s=this._decode(e.step);return new f.Slice({start:r,stop:t,step:s})}_decode_date(e){const r=this._decode(e.iso);return new Date(r)}_decode_value(e){return{value:this._decode(e.value),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_field(e){return{field:this._decode(e.field),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_expr(e){return{expr:this._decode(e.expr),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_typed_array(e){const{array:r,order:t,dtype:s}=e,n=this._decode(r);switch(t!=_.BYTE_ORDER&&(0,u.swap)(n,s),s){case"uint8":return new Uint8Array(n);case"int8":return new Int8Array(n);case"uint16":return new Uint16Array(n);case"int16":return new Int16Array(n);case"uint32":return new Uint32Array(n);case"int32":return new Int32Array(n);case"float32":return new Float32Array(n);case"float64":return new Float64Array(n);default:this.error(`unsupported dtype '${s}'`)}}_decode_ndarray(e){const{array:r,order:t,dtype:s,shape:n}=e,i=this._decode(r);return i instanceof ArrayBuffer&&t!=_.BYTE_ORDER&&(0,u.swap)(i,s),(0,o.ndarray)(i,{dtype:s,shape:n})}_decode_object(e){const{name:r,attributes:t}=e,s=this._resolve_type(r);return null!=t?new s(this._decode(t)):new s}_decode_ref(e){const r=this.references.get(e.id);if(null!=r)return r;this.error(`reference ${e.id} isn't known`)}_decode_object_ref(e){const{id:r,name:t,attributes:s}=e,n=this.references.get(r);if(null==n){const e=new(this._resolve_type(t))({id:r});this.references.set(r,e);const n=this._decode(s??{});return e.initialize_props(n),this._finalizable.add(e),e}if(n.type==t){const e=this._decode(s??{});return n.setv(e,{sync:!1}),n}this.error(`type mismatch for an existing reference '${n}', expected '${t}'`)}error(e){throw new y(e)}warning(e){i.logger.warn(e)}_resolve_type(e){const r=this.resolver.get(e);if(null!=r)return r;this.error(`could not resolve type '${e}', which could be due to a widget or a custom model not being registered before first usage`)}}t.Deserializer=p,p.__name__="Deserializer"},
function _(t,s,e,i,n){i();const c=t(33);class l{constructor({start:t,stop:s,step:e}={}){this.start=t??null,this.stop=s??null,this.step=e??null}[c.serialize](t){return{type:"slice",start:t.encode(this.start),stop:t.encode(this.stop),step:t.encode(this.step)}}}e.Slice=l,l.__name__="Slice"},
function _(e,r,s,t,i){t();const a=e(27),n=/^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(?:(?<type>-dev\.|-rc\.|.dev|rc)(?<revision>\d+))?(?:\+(?<build>\d+)\..+)?$/;var o;(o=s.ReleaseType||(s.ReleaseType={}))[o.Dev=0]="Dev",o[o.Candidate=1]="Candidate",o[o.Release=2]="Release";class c{constructor(e,r,t,i=s.ReleaseType.Release,a=0,n=0){this.major=e,this.minor=r,this.patch=t,this.type=i,this.revision=a,this.build=n}static from(e){return function(e){const r=n.exec(e);if(null==r||null==r.groups)return null;const{groups:t}=r,i=Number(t.major),a=Number(t.minor),o=Number(t.patch),l=(()=>{switch(t.type){case"-dev.":case".dev":return s.ReleaseType.Dev;case"-rc.":case"rc":return s.ReleaseType.Candidate;default:return s.ReleaseType.Release}})(),u=void 0===t.revision?0:Number(t.revision),d=void 0===t.build?0:Number(t.build);return new c(i,a,o,l,u,d)}(e)}toString(){const{major:e,minor:r,patch:t,type:i,revision:a,build:n}=this;let o=`${e}.${r}.${t}`;switch(i){case s.ReleaseType.Dev:o+=`-dev.${a}`;case s.ReleaseType.Candidate:o+=`-rc.${a}`;case s.ReleaseType.Release:}return 0!=n&&(o+=`+${n}`),o}[a.equals](e){const{major:r,minor:s,patch:t,type:i,revision:a}=this;return r==e.major&&s==e.minor&&t==e.patch&&i==e.type&&a==e.revision}}s.Version=c,c.__name__="Version"},
function _(n,e,c,t,u){t(),c.execute=function(n,e,...c){return(0,i.isFunction)(n)?n(e,...c):n.execute(e,...c)},c.execute_sync=function(n,e,...c){return(0,i.isFunction)(n)?n(e,...c):n.execute_sync(e,...c)};const i=n(8)},
function _(e,t,s,n,c){var i;n();const a=e(15),r=e(8),l=e(9),o=e(27),_=e(20),h=e(51);class u extends a.HasProps{get is_syncable(){return this.syncable}[o.equals](e,t){return(!!t.structural||t.eq(this.id,e.id))&&super[o.equals](e,t)}constructor(e){super(e)}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(()=>this._update_property_callbacks())),this.connect(this.properties.js_event_callbacks.change,(()=>this._update_event_callbacks())),this.connect(this.properties.subscribed_events.change,(()=>this._update_event_callbacks()))}_process_event(e){for(const t of(0,l.dict)(this.js_event_callbacks).get(e.event_name)??[])(0,h.execute)(t,e);null!=this.document&&this.subscribed_events.has(e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):_.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of(0,l.dict)(this.js_property_callbacks)){const n=s.map((e=>()=>(0,h.execute)(e,this)));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){super._doc_attached(),0==this.js_event_callbacks.size&&0==this.subscribed_events.size||this._update_event_callbacks()}_doc_detached(){super._doc_detached(),this.document?.event_manager.subscribed_models.delete(this)}select(e){if((0,r.isString)(e))return[...this.references()].filter((t=>t instanceof i&&t.name===e));if((0,r.isPlainObject)(e)&&"type"in e)return[...this.references()].filter((t=>t.type==e.type));if(e.prototype instanceof a.HasProps)return[...this.references()].filter((t=>t instanceof e));throw new Error(`invalid selector ${e}`)}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`found multiple objects matching the given selector ${e}`)}}get_one(e){const t=this.select_one(e);if(null!=t)return t;throw new Error(`could not find any objects matching the given selector ${e}`)}on_event(e,t){const s=(0,r.isString)(e)?e:e.prototype.event_name,n=(0,l.dict)(this.js_event_callbacks),c=n.get(s)??[];n.set(s,[...c,t])}}s.Model=u,i=u,u.__name__="Model",i.define((({Any:e,Unknown:t,Bool:s,Str:n,List:c,Set:i,Dict:a,Nullable:r})=>({tags:[c(t),[]],name:[r(n),null],js_property_callbacks:[a(c(e)),{}],js_event_callbacks:[a(c(e)),{}],subscribed_events:[i(n),new globalThis.Set],syncable:[s,!0]})))},
function _(n,o,t,e,i){var c;e();const s=n(52),f=n(54);class a extends s.Model{constructor(n){super(n)}}t.DocumentConfig=a,c=a,a.__name__="DocumentConfig",c.define((({Bool:n,Ref:o,Nullable:t})=>({reconnect_session:[n,!0],notify_connection_status:[n,!0],notifications:[t(o(f.Notifications)),()=>new f.Notifications]})))},
function _(e,n,t,i,o){var c;i();const s=e(1),l=e(55),_=e(61),a=e(16),r=s.__importStar(e(70)),d=s.__importStar(e(76)),m=s.__importStar(e(77)),h=s.__importStar(e(78));t.notifications_el=(()=>{const e=(0,_.div)(),n=e.attachShadow({mode:"open"});new _.InlineStyleSheet(r.default).install(n),new _.InlineStyleSheet(d.default).install(n),new _.InlineStyleSheet(m.default).install(n),new _.InlineStyleSheet(h.default).install(n);const t=(0,_.div)({class:"entries"});return n.append(t),(0,_.dom_ready)().then((()=>document.body.append(e))),t})();class u extends l.UIElementView{constructor(){super(...arguments),this._connection_el=null,this._connection_timer=null}initialize(){super.initialize(),this.model.push.connect((e=>{const n=(0,_.div)({class:"close",title:"Close"}),i=(0,_.div)({class:e.type},e.text,n);t.notifications_el.append(i);const o=()=>i.remove();n.addEventListener("click",o);const c=e.timeout??5e3;isFinite(c)&&setTimeout(o,c)}));const{document:e}=this.model;null!=e&&(e.on_event("connection_lost",((n,i)=>{if(!e.config.notify_connection_status)return;this._connection_el?.remove(),null!=this._connection_timer&&(clearTimeout(this._connection_timer),this._connection_timer=null);const{timeout:o}=i;if(null==o){const e=(0,_.span)({class:"try"},"Try");e.addEventListener("click",(()=>{this._connection_el?.remove(),i.reconnect()}));const n=(0,_.div)({class:"close",title:"Close"});n.addEventListener("click",(()=>this._connection_el?.remove())),this._connection_el=(0,_.div)({class:"error"},"Client connection was lost permanently. ",e," to reconnect manually.",n),t.notifications_el.append(this._connection_el)}else{let e=o;const n=(0,_.span)(),i=()=>{const t=Math.max(0,Math.round(e/1e3));n.textContent=0==t?"Reconnecting now.":`Reconnection will be attempted in ${t} s.`};i(),this._connection_el=(0,_.div)({class:"error"},"Client connection was lost. ",n),t.notifications_el.append(this._connection_el),this._connection_timer=setInterval((()=>{e-=1e3,i()}),1e3)}})),e.on_event("client_reconnected",((n,i)=>{e.config.notify_connection_status&&(this._connection_el?.remove(),null!=this._connection_timer&&(clearTimeout(this._connection_timer),this._connection_timer=null),this._connection_el=(0,_.div)({class:"success"},"Client connect was reestablished."),t.notifications_el.append(this._connection_el),this._connection_timer=setTimeout((()=>this._connection_el?.remove()),5e3))})))}}t.NotificationsView=u,u.__name__="NotificationsView";class p extends l.UIElement{constructor(e){super(e),this.push=new a.Signal(this,"push")}}t.Notifications=p,c=p,p.__name__="Notifications",c.prototype.default_view=u,c.define((()=>({})))},
function _(e,t,s,i,n){var r;i();const o=e(1),l=e(56),_=e(69),h=e(61),u=e(71),a=e(62),d=e(8),p=e(17),c=o.__importDefault(e(75)),{round:b,floor:y}=Math;class x extends l.StyledElementView{constructor(){super(...arguments),this.display=new h.InlineStyleSheet("","display"),this._bbox=new a.BBox,this._context_menu=null,this._resized=!1,this._is_displayed=!1}computed_stylesheets(){return[...super.computed_stylesheets(),this.display]}stylesheets(){return[...super.stylesheets(),c.default]}update_style(){this.style.clear()}box_sizing(){return{width_policy:"auto",height_policy:"auto",width:null,height:null,aspect_ratio:null}}get bbox(){return this._bbox}update_bbox(){return this._update_bbox()}_update_bbox(){const e=(()=>{if(this.el.isConnected){if(null!=this.el.offsetParent)return!0;{const{position:e,display:t}=getComputedStyle(this.el);return"fixed"==e&&"none"!=t}}return!1})(),t=e?(()=>{const e=this.el.getBoundingClientRect(),{left:t,top:s}=(()=>{if(null!=this.parent){const t=this.parent.el.getBoundingClientRect();return{left:e.left-t.left,top:e.top-t.top}}return{left:0,top:0}})();return new a.BBox({left:b(t),top:b(s),width:y(e.width),height:y(e.height)})})():new a.BBox,s=!this._bbox.equals(t);return this._bbox=t,this._is_displayed=e,s}_provide_context_menu(){return null}initialize(){super.initialize(),this._resize_observer=new ResizeObserver((e=>this.after_resize())),this._resize_observer.observe(this.el,{box:"border-box"})}async lazy_initialize(){await super.lazy_initialize();const e=(()=>{const{context_menu:e}=this.model;return"auto"==e?this._provide_context_menu():e})();null!=e&&(this._context_menu=await(0,_.build_view)(e,{parent:this}))}connect_signals(){super.connect_signals();const{visible:e}=this.model.properties;this.on_change(e,(()=>this._update_visible())),this.el.addEventListener("contextmenu",(e=>this.show_context_menu(e)))}get_context_menu(e){return this._context_menu}show_context_menu(e){if(!e.shiftKey){const t=this.el.getBoundingClientRect(),s=e.x-t.x,i=e.y-t.y,n=this.get_context_menu({x:s,y:i});null!=n&&n.show({x:s,y:i})&&(e.stopPropagation(),e.preventDefault())}}remove(){this._resize_observer.disconnect(),this._context_menu?.remove(),super.remove()}_after_resize(){}after_resize(){this._resized=!0,this.update_bbox()&&this._after_resize(),this.finish()}render(){super.render(),this._apply_visible()}_after_render(){this.update_style(),this.update_bbox()}after_render(){super.after_render(),this._after_render(),this._has_finished||(this.is_displayed?(0,p.defer)().then((()=>{this._resized||this.finish()})):this.force_finished())}get is_displayed(){return this._is_displayed}_apply_visible(){this.model.visible?this.display.clear():this.display.replace(":host { display: none; }")}_update_visible(){this._apply_visible()}export(e="auto",t=!0){const s="auto"==e||"png"==e?"canvas":"svg",i=new u.CanvasLayer(s,t),{width:n,height:r}=this.bbox;return i.resize(n,r),i}resolve_symbol(e){const t=this.bbox.resolve(e.symbol),{offset:s}=e;if((0,d.isNumber)(t))return t+s;{const{x:e,y:i}=t;return{x:e+s,y:i+s}}}}s.UIElementView=x,x.__name__="UIElementView";class f extends l.StyledElement{constructor(e){super(e)}}s.UIElement=f,r=f,f.__name__="UIElement",r.define((({Bool:e,AnyRef:t,Nullable:s,Or:i,Auto:n})=>({visible:[e,!0],context_menu:[s(i(t(),n)),null]})))},
function _(e,s,t,l,i){var _;l();const a=e(52),r=e(57),h=e(59),n=e(60),c=e(64),y=e(63),o=e(61),p=e(9),d=e(8),u=e(22);t.StylesLike=(0,u.Or)((0,u.Dict)((0,u.Nullable)(u.Str)),(0,u.Ref)(h.Styles)),t.StyleSheets=(0,u.List)((0,u.Or)((0,u.Ref)(n.StyleSheet),u.Str,(0,u.Dict)(t.StylesLike))),t.CSSVariables=(0,u.Dict)((0,u.Or)((0,u.Ref)(r.Node),u.Str));class S extends c.DOMComponentView{constructor(){super(...arguments),this.style=new o.InlineStyleSheet("","style"),this.parent_style=new o.InlineStyleSheet("","parent",!0)}computed_stylesheets(){return[...super.computed_stylesheets(),this.style,this.parent_style]}connect_signals(){super.connect_signals();const{html_attributes:e,html_id:s,styles:t,css_classes:l,css_variables:i,stylesheets:_}=this.model.properties;this.on_change([e,s,l,t],(()=>this._apply_html_attributes())),this.on_transitive_change(i,(()=>this._apply_html_attributes())),this.on_transitive_change(_,(()=>this._update_stylesheets()))}*_css_classes(){yield*super._css_classes(),yield*this.model.css_classes}*_css_variables(){yield*super._css_variables();for(const[e,s]of(0,p.entries)(this.model.css_variables))if(s instanceof r.Node){const t=this.resolve_coordinate(s);(0,d.isNumber)(t)?yield[e,`${t}px`]:(0,d.isString)(t)&&(yield[e,t])}else yield[e,s]}user_stylesheets(){return[...super.user_stylesheets(),...this._user_stylesheets()]}*_user_stylesheets(){for(const e of this.model.stylesheets)e instanceof n.StyleSheet?yield e.underlying():yield new o.InlineStyleSheet(e)}_apply_html_attributes(){for(const e of this._applied_html_attributes)this.el.removeAttribute(e);this._applied_html_attributes=[],this._update_css_classes();for(const[e,s]of(0,p.entries)(this.model.html_attributes))if("class"==e){const e=s.split(/ +/);this._applied_css_classes.push(...e),this.class_list.add(...e)}else this.el.setAttribute(e,s),this._applied_html_attributes.push(e);const e=this.model.html_id;null!=e&&(this.el.setAttribute("id",e),this._applied_html_attributes.push("id")),this._apply_styles(),this._update_css_variables()}_apply_styles(){(0,y.apply_styles)(this.el.style,this.model.styles)}}t.StyledElementView=S,S.__name__="StyledElementView";class m extends a.Model{constructor(e){super(e)}}t.StyledElement=m,_=m,m.__name__="StyledElement",_.define({html_attributes:[(0,u.Dict)(u.Str),{}],html_id:[(0,u.Nullable)(u.Str),null],css_classes:[(0,u.List)(u.Str),[]],css_variables:[t.CSSVariables,{}],styles:[t.StylesLike,{}],stylesheets:[t.StyleSheets,[]]})},
function _(t,e,r,n,o){var s;n();const a=t(58),i=t(52),_=t(22);r.ImplicitTarget=(0,_.Enum)("canvas","plot","frame","parent"),r.NodeTarget=(0,_.Or)((0,_.Ref)(i.Model),r.ImplicitTarget);class h{constructor(t,e=!1){this._left=null,this._right=null,this._top=null,this._bottom=null,this.target=t,this.frozen=e}_node(t){const{target:e,frozen:r}=this,n=new l({target:e,symbol:t});return r&&(this[`_${t}`]=n),n}get left(){return this._left??this._node("left")}get right(){return this._right??this._node("right")}get top(){return this._top??this._node("top")}get bottom(){return this._bottom??this._node("bottom")}freeze(){return new h(this.target,!0)}}r.BoxNodes=h,h.__name__="BoxNodes";class l extends a.Coordinate{constructor(t){super(t)}static get frame(){return this._frame_nodes}static get canvas(){return this._canvas_nodes}}r.Node=l,s=l,l.__name__="Node",s.define((({Str:t,Int:e})=>({target:[r.NodeTarget],symbol:[t],offset:[e,0]}))),l._frame_nodes=new h("frame"),l._canvas_nodes=new h("canvas")},
function _(o,n,e,t,s){t();const c=o(52);class r extends c.Model{constructor(o){super(o)}}e.Coordinate=r,r.__name__="Coordinate"},
function _(l,n,u,_,e){var t;_();const o=l(52);class r extends o.Model{constructor(l){super(l)}}u.Styles=r,t=r,r.__name__="Styles",t.define((({Str:l,Nullable:n})=>({align_content:[n(l),null],align_items:[n(l),null],align_self:[n(l),null],alignment_baseline:[n(l),null],all:[n(l),null],animation:[n(l),null],animation_delay:[n(l),null],animation_direction:[n(l),null],animation_duration:[n(l),null],animation_fill_mode:[n(l),null],animation_iteration_count:[n(l),null],animation_name:[n(l),null],animation_play_state:[n(l),null],animation_timing_function:[n(l),null],aspect_ratio:[n(l),null],backface_visibility:[n(l),null],background:[n(l),null],background_attachment:[n(l),null],background_clip:[n(l),null],background_color:[n(l),null],background_image:[n(l),null],background_origin:[n(l),null],background_position:[n(l),null],background_position_x:[n(l),null],background_position_y:[n(l),null],background_repeat:[n(l),null],background_size:[n(l),null],baseline_shift:[n(l),null],block_size:[n(l),null],border:[n(l),null],border_block_end:[n(l),null],border_block_end_color:[n(l),null],border_block_end_style:[n(l),null],border_block_end_width:[n(l),null],border_block_start:[n(l),null],border_block_start_color:[n(l),null],border_block_start_style:[n(l),null],border_block_start_width:[n(l),null],border_bottom:[n(l),null],border_bottom_color:[n(l),null],border_bottom_left_radius:[n(l),null],border_bottom_right_radius:[n(l),null],border_bottom_style:[n(l),null],border_bottom_width:[n(l),null],border_collapse:[n(l),null],border_color:[n(l),null],border_image:[n(l),null],border_image_outset:[n(l),null],border_image_repeat:[n(l),null],border_image_slice:[n(l),null],border_image_source:[n(l),null],border_image_width:[n(l),null],border_inline_end:[n(l),null],border_inline_end_color:[n(l),null],border_inline_end_style:[n(l),null],border_inline_end_width:[n(l),null],border_inline_start:[n(l),null],border_inline_start_color:[n(l),null],border_inline_start_style:[n(l),null],border_inline_start_width:[n(l),null],border_left:[n(l),null],border_left_color:[n(l),null],border_left_style:[n(l),null],border_left_width:[n(l),null],border_radius:[n(l),null],border_right:[n(l),null],border_right_color:[n(l),null],border_right_style:[n(l),null],border_right_width:[n(l),null],border_spacing:[n(l),null],border_style:[n(l),null],border_top:[n(l),null],border_top_color:[n(l),null],border_top_left_radius:[n(l),null],border_top_right_radius:[n(l),null],border_top_style:[n(l),null],border_top_width:[n(l),null],border_width:[n(l),null],bottom:[n(l),null],box_shadow:[n(l),null],box_sizing:[n(l),null],break_after:[n(l),null],break_before:[n(l),null],break_inside:[n(l),null],caption_side:[n(l),null],caret_color:[n(l),null],clear:[n(l),null],clip:[n(l),null],clip_path:[n(l),null],clip_rule:[n(l),null],color:[n(l),null],color_interpolation:[n(l),null],color_interpolation_filters:[n(l),null],column_count:[n(l),null],column_fill:[n(l),null],column_gap:[n(l),null],column_rule:[n(l),null],column_rule_color:[n(l),null],column_rule_style:[n(l),null],column_rule_width:[n(l),null],column_span:[n(l),null],column_width:[n(l),null],columns:[n(l),null],content:[n(l),null],counter_increment:[n(l),null],counter_reset:[n(l),null],cursor:[n(l),null],direction:[n(l),null],display:[n(l),null],dominant_baseline:[n(l),null],empty_cells:[n(l),null],fill:[n(l),null],fill_opacity:[n(l),null],fill_rule:[n(l),null],filter:[n(l),null],flex:[n(l),null],flex_basis:[n(l),null],flex_direction:[n(l),null],flex_flow:[n(l),null],flex_grow:[n(l),null],flex_shrink:[n(l),null],flex_wrap:[n(l),null],float:[n(l),null],flood_color:[n(l),null],flood_opacity:[n(l),null],font:[n(l),null],font_family:[n(l),null],font_feature_settings:[n(l),null],font_kerning:[n(l),null],font_size:[n(l),null],font_size_adjust:[n(l),null],font_stretch:[n(l),null],font_style:[n(l),null],font_synthesis:[n(l),null],font_variant:[n(l),null],font_variant_caps:[n(l),null],font_variant_east_asian:[n(l),null],font_variant_ligatures:[n(l),null],font_variant_numeric:[n(l),null],font_variant_position:[n(l),null],font_weight:[n(l),null],gap:[n(l),null],glyph_orientation_vertical:[n(l),null],grid:[n(l),null],grid_area:[n(l),null],grid_auto_columns:[n(l),null],grid_auto_flow:[n(l),null],grid_auto_rows:[n(l),null],grid_column:[n(l),null],grid_column_end:[n(l),null],grid_column_gap:[n(l),null],grid_column_start:[n(l),null],grid_gap:[n(l),null],grid_row:[n(l),null],grid_row_end:[n(l),null],grid_row_gap:[n(l),null],grid_row_start:[n(l),null],grid_template:[n(l),null],grid_template_areas:[n(l),null],grid_template_columns:[n(l),null],grid_template_rows:[n(l),null],height:[n(l),null],hyphens:[n(l),null],image_orientation:[n(l),null],image_rendering:[n(l),null],inline_size:[n(l),null],justify_content:[n(l),null],justify_items:[n(l),null],justify_self:[n(l),null],left:[n(l),null],letter_spacing:[n(l),null],lighting_color:[n(l),null],line_break:[n(l),null],line_height:[n(l),null],list_style:[n(l),null],list_style_image:[n(l),null],list_style_position:[n(l),null],list_style_type:[n(l),null],margin:[n(l),null],margin_block_end:[n(l),null],margin_block_start:[n(l),null],margin_bottom:[n(l),null],margin_inline_end:[n(l),null],margin_inline_start:[n(l),null],margin_left:[n(l),null],margin_right:[n(l),null],margin_top:[n(l),null],marker:[n(l),null],marker_end:[n(l),null],marker_mid:[n(l),null],marker_start:[n(l),null],mask:[n(l),null],mask_composite:[n(l),null],mask_image:[n(l),null],mask_position:[n(l),null],mask_repeat:[n(l),null],mask_size:[n(l),null],mask_type:[n(l),null],max_block_size:[n(l),null],max_height:[n(l),null],max_inline_size:[n(l),null],max_width:[n(l),null],min_block_size:[n(l),null],min_height:[n(l),null],min_inline_size:[n(l),null],min_width:[n(l),null],object_fit:[n(l),null],object_position:[n(l),null],opacity:[n(l),null],order:[n(l),null],orphans:[n(l),null],outline:[n(l),null],outline_color:[n(l),null],outline_offset:[n(l),null],outline_style:[n(l),null],outline_width:[n(l),null],overflow:[n(l),null],overflow_anchor:[n(l),null],overflow_wrap:[n(l),null],overflow_x:[n(l),null],overflow_y:[n(l),null],overscroll_behavior:[n(l),null],overscroll_behavior_block:[n(l),null],overscroll_behavior_inline:[n(l),null],overscroll_behavior_x:[n(l),null],overscroll_behavior_y:[n(l),null],padding:[n(l),null],padding_block_end:[n(l),null],padding_block_start:[n(l),null],padding_bottom:[n(l),null],padding_inline_end:[n(l),null],padding_inline_start:[n(l),null],padding_left:[n(l),null],padding_right:[n(l),null],padding_top:[n(l),null],page_break_after:[n(l),null],page_break_before:[n(l),null],page_break_inside:[n(l),null],paint_order:[n(l),null],perspective:[n(l),null],perspective_origin:[n(l),null],place_content:[n(l),null],place_items:[n(l),null],place_self:[n(l),null],pointer_events:[n(l),null],position:[n(l),null],quotes:[n(l),null],resize:[n(l),null],right:[n(l),null],rotate:[n(l),null],row_gap:[n(l),null],ruby_align:[n(l),null],ruby_position:[n(l),null],scale:[n(l),null],scroll_behavior:[n(l),null],shape_rendering:[n(l),null],stop_color:[n(l),null],stop_opacity:[n(l),null],stroke:[n(l),null],stroke_dasharray:[n(l),null],stroke_dashoffset:[n(l),null],stroke_linecap:[n(l),null],stroke_linejoin:[n(l),null],stroke_miterlimit:[n(l),null],stroke_opacity:[n(l),null],stroke_width:[n(l),null],tab_size:[n(l),null],table_layout:[n(l),null],text_align:[n(l),null],text_align_last:[n(l),null],text_anchor:[n(l),null],text_combine_upright:[n(l),null],text_decoration:[n(l),null],text_decoration_color:[n(l),null],text_decoration_line:[n(l),null],text_decoration_style:[n(l),null],text_emphasis:[n(l),null],text_emphasis_color:[n(l),null],text_emphasis_position:[n(l),null],text_emphasis_style:[n(l),null],text_indent:[n(l),null],text_justify:[n(l),null],text_orientation:[n(l),null],text_overflow:[n(l),null],text_rendering:[n(l),null],text_shadow:[n(l),null],text_transform:[n(l),null],text_underline_position:[n(l),null],top:[n(l),null],touch_action:[n(l),null],transform:[n(l),null],transform_box:[n(l),null],transform_origin:[n(l),null],transform_style:[n(l),null],transition:[n(l),null],transition_delay:[n(l),null],transition_duration:[n(l),null],transition_property:[n(l),null],transition_timing_function:[n(l),null],translate:[n(l),null],unicode_bidi:[n(l),null],user_select:[n(l),null],vertical_align:[n(l),null],visibility:[n(l),null],white_space:[n(l),null],widows:[n(l),null],width:[n(l),null],will_change:[n(l),null],word_break:[n(l),null],word_spacing:[n(l),null],word_wrap:[n(l),null],writing_mode:[n(l),null],z_index:[n(l),null]})))},
function _(e,t,n,l,r){var s,i;l();const u=e(1),S=e(52),_=u.__importStar(e(61));class d extends S.Model{constructor(e){super(e)}}n.StyleSheet=d,d.__name__="StyleSheet";class h extends d{constructor(e){super(e)}underlying(){return new _.InlineStyleSheet(this.css)}}n.InlineStyleSheet=h,s=h,h.__name__="InlineStyleSheet",s.define((({Str:e})=>({css:[e]})));class o extends d{constructor(e){super(e)}underlying(){return new _.ImportedStyleSheet(this.url)}}n.ImportedStyleSheet=o,i=o,o.__name__="ImportedStyleSheet",i.define((({Str:e})=>({url:[e]})));class y extends h{constructor(e){super(e),this._underlying=null}underlying(){return null==this._underlying&&(this._underlying=new _.GlobalInlineStyleSheet(this.css)),this._underlying}}n.GlobalInlineStyleSheet=y,y.__name__="GlobalInlineStyleSheet";class c extends o{constructor(e){super(e),this._underlying=null}underlying(){return null==this._underlying&&(this._underlying=new _.GlobalImportedStyleSheet(this.url)),this._underlying}}n.GlobalImportedStyleSheet=c,c.__name__="GlobalImportedStyleSheet"},
function _(t,e,n,o,i){o(),n.textarea=n.template=n.td=n.tbody=n.table=n.sup=n.summary=n.sub=n.style=n.strong=n.span=n.source=n.small=n.slot=n.select=n.section=n.search=n.script=n.samp=n.s=n.ruby=n.rt=n.rp=n.q=n.progress=n.pre=n.picture=n.p=n.output=n.option=n.optgroup=n.ol=n.object=n.noscript=n.nav=n.meter=n.meta=n.menu=n.mark=n.map=n.main=n.link=n.li=n.legend=n.label=n.kbd=n.ins=n.input=n.img=n.iframe=void 0,n.supports_adopted_stylesheets=n.GlobalImportedStyleSheet=n.ImportedStyleSheet=n.GlobalInlineStyleSheet=n.InlineStyleSheet=n.StyleSheet=n.MouseButton=n.ClassList=n.wbr=n.video=n.ul=n.u=n.track=n.tr=n.title=n.time=n.thead=n.th=n.tfoot=void 0,n.create_element=function(t,e,...n){return d(t)(e,...n)},n.createSVGElement=function(t,e=null,...n){const o=document.createElementNS("http://www.w3.org/2000/svg",t);for(const[t,n]of(0,l.entries)(e??{}))null!=n&&!1!==n&&o.setAttribute(t,n);function i(t){if((0,s.isString)(t))o.appendChild(document.createTextNode(t));else if(t instanceof Node)o.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)o.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)i(e);else i(t);return o},n.text=u,n.nbsp=function(){return u("\xa0")},n.prepend=function(t,...e){const n=t.firstChild;for(const o of e)t.insertBefore(o,n)},n.empty=function(t,e=!1){let n;for(;null!=(n=t.firstChild);)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.contains=function(t,e){let n=e;for(;null!=n.parentNode;){const e=n.parentNode;if(e==t)return!0;n=e instanceof ShadowRoot?e.host:e}return!1},n.display=function(t,e=!0){t.style.display=e?"":"none"},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset_bbox=function(t){const{top:e,left:n,width:o,height:i}=t.getBoundingClientRect();return new r.BBox({left:n+scrollX-document.documentElement.clientLeft,top:e+scrollY-document.documentElement.clientTop,width:o,height:i})},n.parent=function(t,e){let n=t;for(;null!=(n=n.parentElement);)if(n.matches(e))return n;return null},n.extents=p,n.size=f,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:o,bottom:i}}=p(t),{width:s,height:l}=f(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+o+i)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:o}=p(t);let i=0,s=0;for(const l of(t.shadowRoot??t).children){const t=l.getBoundingClientRect();i=Math.max(i,Math.ceil(t.left-e-o.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-o.top+t.height))}return{width:i,height:s}},n.bounding_box=function(t){const{x:e,y:n,width:o,height:i}=t.getBoundingClientRect();return new r.BBox({x:e,y:n,width:o,height:i})},n.box_size=function(t){const{width:e,height:n}=t.getBoundingClientRect();return{width:e,height:n}},n.position=function(t,e,n){const{style:o}=t;if(o.left=`${e.x}px`,o.top=`${e.y}px`,o.width=`${e.width}px`,o.height=`${e.height}px`,null==n)o.margin="";else{const{top:t,right:e,bottom:i,left:s}=n;o.margin=`${t}px ${e}px ${i}px ${s}px`}},n.classes=function(t){return new m(t.classList)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e));n?t.setAttribute(e,"true"):t.removeAttribute(e)},n.dom_ready=async function(){if("loading"==document.readyState)return new Promise(((t,e)=>{document.addEventListener("DOMContentLoaded",(()=>t()),{once:!0})}))},n.px=function(t){return(0,s.isNumber)(t)?`${t}px`:t},n.has_focus=function(t){const e=t.getRootNode();return(e instanceof ShadowRoot||e instanceof Document)&&e.activeElement===t};const s=t(8),l=t(9),r=t(62),a=t(63),c=t(20),d=t=>(e={},...n)=>{const o=document.createElement(t);if((0,s.isPlainObject)(e)?e={...e}:(n=[e,...n],e={}),null!=e.class){const t=(0,s.isString)(e.class)?e.class.split(/\s+/):e.class;for(const e of t)null!=e&&o.classList.add(e);delete e.class}if(null!=e.style&&((0,s.isString)(e.style)?o.setAttribute("style",e.style):(0,a.apply_styles)(o.style,e.style),delete e.style),null!=e.data){for(const[t,n]of(0,l.entries)(e.data))null!=n&&(o.dataset[t]=n);delete e.data}for(const[t,n]of(0,l.entries)(e))null!=n&&((0,s.isBoolean)(n)?o.toggleAttribute(t,n):(0,s.isNumber)(n)?o.setAttribute(t,`${n}`):(0,s.isString)(n)?o.setAttribute(t,n):c.logger.warn(`unable to set attribute: ${t} = ${n}`));function i(t){if((0,s.isString)(t))o.append(document.createTextNode(t));else if(t instanceof Node)o.append(t);else if(t instanceof NodeList||t instanceof HTMLCollection)o.append(...t);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)i(e);else i(t);return o};function u(t){return document.createTextNode(t)}function h(t){const e=parseFloat(t);return isFinite(e)?e:0}function p(t){const e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function f(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.a=d("a"),n.abbr=d("abbr"),n.address=d("address"),n.area=d("area"),n.article=d("article"),n.aside=d("aside"),n.audio=d("audio"),n.b=d("b"),n.base=d("base"),n.bdi=d("bdi"),n.bdo=d("bdo"),n.blockquote=d("blockquote"),n.body=d("body"),n.br=d("br"),n.button=d("button"),n.canvas=d("canvas"),n.caption=d("caption"),n.cite=d("cite"),n.code=d("code"),n.col=d("col"),n.colgroup=d("colgroup"),n.data=d("data"),n.datalist=d("datalist"),n.dd=d("dd"),n.del=d("del"),n.details=d("details"),n.dfn=d("dfn"),n.dialog=d("dialog"),n.div=d("div"),n.dl=d("dl"),n.dt=d("dt"),n.em=d("em"),n.embed=d("embed"),n.fieldset=d("fieldset"),n.figcaption=d("figcaption"),n.figure=d("figure"),n.footer=d("footer"),n.form=d("form"),n.h1=d("h1"),n.h2=d("h2"),n.h3=d("h3"),n.h4=d("h4"),n.h5=d("h5"),n.h6=d("h6"),n.head=d("head"),n.header=d("header"),n.hgroup=d("hgroup"),n.hr=d("hr"),n.html=d("html"),n.i=d("i"),n.iframe=d("iframe"),n.img=d("img"),n.input=d("input"),n.ins=d("ins"),n.kbd=d("kbd"),n.label=d("label"),n.legend=d("legend"),n.li=d("li"),n.link=d("link"),n.main=d("main"),n.map=d("map"),n.mark=d("mark"),n.menu=d("menu"),n.meta=d("meta"),n.meter=d("meter"),n.nav=d("nav"),n.noscript=d("noscript"),n.object=d("object"),n.ol=d("ol"),n.optgroup=d("optgroup"),n.option=d("option"),n.output=d("output"),n.p=d("p"),n.picture=d("picture"),n.pre=d("pre"),n.progress=d("progress"),n.q=d("q"),n.rp=d("rp"),n.rt=d("rt"),n.ruby=d("ruby"),n.s=d("s"),n.samp=d("samp"),n.script=d("script"),n.search=d("search"),n.section=d("section"),n.select=d("select"),n.slot=d("slot"),n.small=d("small"),n.source=d("source"),n.span=d("span"),n.strong=d("strong"),n.style=d("style"),n.sub=d("sub"),n.summary=d("summary"),n.sup=d("sup"),n.table=d("table"),n.tbody=d("tbody"),n.td=d("td"),n.template=d("template"),n.textarea=d("textarea"),n.tfoot=d("tfoot"),n.th=d("th"),n.thead=d("thead"),n.time=d("time"),n.title=d("title"),n.tr=d("tr"),n.track=d("track"),n.u=d("u"),n.ul=d("ul"),n.video=d("video"),n.wbr=d("wbr");class m{constructor(t){this.class_list=t}get values(){const t=[];for(let e=0;e<this.class_list.length;e++){const n=this.class_list.item(e);null!=n&&t.push(n)}return t}has(t){return this.class_list.contains(t)}add(...t){for(const e of t)this.class_list.add(e);return this}remove(...t){for(const e of t)(0,s.isArray)(e)?e.forEach((t=>this.class_list.remove(t))):this.class_list.remove(e);return this}clear(){for(const t of this.values)this.class_list.remove(t);return this}toggle(t,e){return this.class_list.toggle(t,e)}}var g;n.ClassList=m,m.__name__="ClassList",(g=n.MouseButton||(n.MouseButton={}))[g.None=0]="None",g[g.Primary=1]="Primary",g[g.Secondary=2]="Secondary",g[g.Auxiliary=4]="Auxiliary",g[g.Left=1]="Left",g[g.Right=2]="Right",g[g.Middle=4]="Middle";class b{install(t){t.append(this.el)}uninstall(){this.el.remove()}}n.StyleSheet=b,b.__name__="StyleSheet";class y extends b{constructor(t,e,o=!1){super(),this.el=(0,n.style)(),this.persistent=o,(0,s.isString)(t)?this._update(t):null!=t&&this._update((0,a.compose_stylesheet)(t)),null!=e&&(this.el.dataset.css=e)}get css(){return this.el.textContent}_update(t){this.el.textContent=t}clear(){this.replace("")}_to_css(t,e){return null==e?t:(0,a.compose_stylesheet)({[t]:e})}replace(t,e){this._update(this._to_css(t,e))}prepend(t,e){this._update(`${this._to_css(t,e)}\n${this.css}`)}append(t,e){this._update(`${this.css}\n${this._to_css(t,e)}`)}remove(){this.el.remove()}}n.InlineStyleSheet=y,y.__name__="InlineStyleSheet";class _ extends y{install(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalInlineStyleSheet=_,_.__name__="GlobalInlineStyleSheet";class S extends b{constructor(t){super(),this.el=(0,n.link)({rel:"stylesheet",href:t})}replace(t){this.el.href=t}remove(){this.el.remove()}}n.ImportedStyleSheet=S,S.__name__="ImportedStyleSheet";class x extends S{install(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalImportedStyleSheet=x,x.__name__="GlobalImportedStyleSheet",n.supports_adopted_stylesheets="adoptedStyleSheets"in ShadowRoot.prototype},
function _(t,e,r,i,n){i(),r.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},r.full=function(){return{x0:-1/0,y0:-1/0,x1:1/0,y1:1/0}},r.x_range=y,r.y_range=_,r.positive_x=function(){return y(Number.MIN_VALUE,1/0)},r.negative_x=function(){return y(-1/0,-Number.MIN_VALUE)},r.positive_y=function(){return _(Number.MIN_VALUE,1/0)},r.negative_y=function(){return _(-1/0,-Number.MIN_VALUE)},r.union=function(t,e){return{x0:a(t.x0,e.x0),x1:p(t.x1,e.x1),y0:a(t.y0,e.y0),y1:p(t.y1,e.y1)}},r.isXY=function(t){return(0,c.isPlainObject)(t)&&"x"in t&&"y"in t};const h=t(25),s=t(27),o=t(13),c=t(8),{min:u,max:g,round:x}=Math;function y(t,e){return{x0:t,y0:-1/0,x1:e,y1:1/0}}function _(t,e){return{x0:-1/0,y0:t,x1:1/0,y1:e}}function a(t,e){return isNaN(t)?e:isNaN(e)?t:u(t,e)}function p(t,e){return isNaN(t)?e:isNaN(e)?t:g(t,e)}class l{constructor(t,e=!1){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:e,y0:r,x1:i,y1:n}=t;if(isFinite(e+r+i+n)){if(!(e<=i&&r<=n))throw new Error(`invalid bbox {x0: ${e}, y0: ${r}, x1: ${i}, y1: ${n}}`);this.x0=e,this.y0=r,this.x1=i,this.y1=n}else this.x0=NaN,this.y0=NaN,this.x1=NaN,this.y1=NaN}else if("x"in t){const{x:e,y:r,width:i,height:n,origin:h="top_left"}=t;if(!(i>=0&&n>=0))throw new Error(`invalid bbox {x: ${e}, y: ${r}, width: ${i}, height: ${n}}`);const s=(()=>{switch(h){case"left":return"center_left";case"right":return"center_right";case"top":return"top_center";case"bottom":return"bottom_center";case"center":return"center_center";default:return h}})(),[o,c]=s.split("_",2),u=(()=>{switch(o){case"top":return 0;case"center":return.5;case"bottom":return 1}})(),g=e-(()=>{switch(c){case"left":return 0;case"center":return.5;case"right":return 1}})()*i,x=r-u*n,y=g+i,_=x+n;this.x0=g,this.y0=x,this.x1=y,this.y1=_}else{let r,i,n,h;if("width"in t)if("left"in t)r=t.left,i=r+t.width;else if("right"in t)i=t.right,r=i-t.width;else{const e=t.width/2;r=t.hcenter-e,i=t.hcenter+e}else r=t.left,i=t.right;if("height"in t)if("top"in t)n=t.top,h=n+t.height;else if("bottom"in t)h=t.bottom,n=h-t.height;else{const e=t.height/2;n=t.vcenter-e,h=t.vcenter+e}else n=t.top,h=t.bottom;if(r>i||n>h){if(!e)throw new Error(`invalid bbox {left: ${r}, top: ${n}, right: ${i}, bottom: ${h}}`);r>i&&(r=i),n>h&&(n=h)}this.x0=r,this.y0=n,this.x1=i,this.y1=h}}static from_lrtb({left:t,right:e,top:r,bottom:i}){return new l({x0:u(t,e),y0:u(r,i),x1:g(t,e),y1:g(r,i)})}static from_rect({x0:t,y0:e,x1:r,y1:i}){return new l({x0:u(t,r),y0:u(e,i),x1:g(t,r),y1:g(e,i)})}static empty(){return new l({x0:0,y0:0,x1:0,y1:0})}static invalid(){return new l({x0:NaN,y0:NaN,x1:NaN,y1:NaN})}clone(){return new l(this)}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}[s.equals](t,e){return e.eq(this.x0,t.x0)&&e.eq(this.y0,t.y0)&&e.eq(this.x1,t.x1)&&e.eq(this.y1,t.y1)}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get is_valid(){const{x0:t,x1:e,y0:r,y1:i}=this;return isFinite(t+e+r+i)}get is_empty(){const{x0:t,x1:e,y0:r,y1:i}=this;return 0==t&&0==e&&0==r&&0==i}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return{x:this.x0,y:this.y0}}get p1(){return{x:this.x1,y:this.y1}}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get size(){return{width:this.width,height:this.height}}get rect(){const{x0:t,y0:e,x1:r,y1:i}=this;return{p0:{x:t,y:e},p1:{x:r,y:e},p2:{x:r,y:i},p3:{x:t,y:i}}}get box(){const{x:t,y:e,width:r,height:i}=this;return{x:t,y:e,width:r,height:i}}get lrtb(){const{left:t,right:e,top:r,bottom:i}=this;return{left:t,right:e,top:r,bottom:i}}get args(){const{x:t,y:e,width:r,height:i}=this;return[t,e,r,i]}get x_range(){return{start:this.x0,end:this.x1}}get y_range(){return{start:this.y0,end:this.y1}}get h_range(){return this.x_range}get v_range(){return this.y_range}get ranges(){return[this.x_range,this.y_range]}get aspect(){return this.width/this.height}get x_center(){return(this.left+this.right)/2}get y_center(){return(this.top+this.bottom)/2}get hcenter(){return this.x_center}get vcenter(){return this.y_center}get area(){return this.width*this.height}resolve(t){switch(t){case"top_left":return this.top_left;case"top_center":return this.top_center;case"top_right":return this.top_right;case"center_left":return this.center_left;case"center_center":return this.center_center;case"center_right":return this.center_right;case"bottom_left":return this.bottom_left;case"bottom_center":return this.bottom_center;case"bottom_right":return this.bottom_right;case"center":return this.center;case"top":return this.top;case"left":return this.left;case"right":return this.right;case"bottom":return this.bottom;case"width":return this.width;case"height":return this.height;default:return{x:NaN,y:NaN}}}get top_left(){return{x:this.left,y:this.top}}get top_center(){return{x:this.hcenter,y:this.top}}get top_right(){return{x:this.right,y:this.top}}get center_left(){return{x:this.left,y:this.vcenter}}get center_center(){return{x:this.hcenter,y:this.vcenter}}get center_right(){return{x:this.right,y:this.vcenter}}get bottom_left(){return{x:this.left,y:this.bottom}}get bottom_center(){return{x:this.hcenter,y:this.bottom}}get bottom_right(){return{x:this.right,y:this.bottom}}get center(){return{x:this.hcenter,y:this.vcenter}}round(){return new l({x0:x(this.x0),x1:x(this.x1),y0:x(this.y0),y1:x(this.y1)})}relative(){const{width:t,height:e}=this;return new l({x:0,y:0,width:t,height:e})}relative_to(t){const{x:e,y:r,width:i,height:n}=this;return new l({x:e-t.x,y:r-t.y,width:i,height:n})}translate(t,e){const{x:r,y:i,width:n,height:h}=this;return new l({x:t+r,y:e+i,width:n,height:h})}scale(t){return new l({x0:this.x0*t,x1:this.x1*t,y0:this.y0*t,y1:this.y1*t})}relativize(t,e){return[t-this.x,e-this.y]}contains(t,e){return this.x0<=t&&t<=this.x1&&this.y0<=e&&e<=this.y1}clip(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]}grow_by(t){return new l({left:this.left-t,right:this.right+t,top:this.top-t,bottom:this.bottom+t})}shrink_by(t){return new l({left:this.left+t,right:this.right-t,top:this.top+t,bottom:this.bottom-t},!0)}union(t){return new l({x0:u(this.x0,t.x0),y0:u(this.y0,t.y0),x1:g(this.x1,t.x1),y1:g(this.y1,t.y1)})}intersection(t){return this.intersects(t)?new l({x0:g(this.x0,t.x0),y0:g(this.y0,t.y0),x1:u(this.x1,t.x1),y1:u(this.y1,t.y1)}):null}intersects(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)}get x_percent(){const t=this;return this._x_percent??(this._x_percent={compute:e=>t.left+e*t.width,invert:e=>(e-t.left)/t.width,v_compute(e){const{left:r,width:i}=t;return new h.ScreenArray((0,o.map)(e,(t=>r+t*i)))},v_invert(e){const{left:r,width:i}=t;return(0,o.map)(e,(t=>(t-r)/i))},get source_range(){return t.x_range},get target_range(){return t.x_range}})}get y_percent(){const t=this;return this._y_percent??(this._y_percent={compute:e=>t.top+e*t.height,invert:e=>(e-t.top)/t.height,v_compute(e){const{top:r,height:i}=t;return new h.ScreenArray((0,o.map)(e,(t=>r+t*i)))},v_invert(e){const{top:r,height:i}=t;return(0,o.map)(e,(t=>(t-r)/i))},get source_range(){return t.y_range},get target_range(){return t.y_range}})}get x_screen(){const t=this;return this._x_screen??(this._x_screen={compute:e=>t.left+e,invert:e=>e-t.left,v_compute(e){const{left:r}=t;return new h.ScreenArray((0,o.map)(e,(t=>r+t)))},v_invert(e){const{left:r}=t;return(0,o.map)(e,(t=>t-r))},get source_range(){return t.x_range},get target_range(){return t.x_range}})}get y_screen(){const t=this;return this._y_screen??(this._y_screen={compute:e=>t.top+e,invert:e=>e-t.top,v_compute(e){const{top:r}=t;return new h.ScreenArray((0,o.map)(e,(t=>r+t)))},v_invert(e){const{top:r}=t;return(0,o.map)(e,(t=>t-r))},get source_range(){return t.y_range},get target_range(){return t.y_range}})}get x_view(){const t=this;return this._x_view??(this._x_view={compute:e=>t.left+e,invert:e=>e-t.left,v_compute(e){const{left:r}=t;return new h.ScreenArray((0,o.map)(e,(t=>r+t)))},v_invert(e){const{left:r}=t;return(0,o.map)(e,(t=>t-r))},get source_range(){return t.x_range},get target_range(){return t.x_range}})}get y_view(){const t=this;return this._y_view??(this._y_view={compute:e=>t.bottom-e,invert:e=>t.bottom-e,v_compute(e){const{bottom:r}=t;return new h.ScreenArray((0,o.map)(e,(t=>r-t)))},v_invert(e){const{bottom:r}=t;return(0,o.map)(e,(t=>r-t))},get source_range(){return t.y_range},get target_range(){return{start:t.bottom,end:t.top}}})}get xview(){return this.x_view}get yview(){return this.y_view}}r.BBox=l,l.__name__="BBox"},
function _(n,t,e,o,r){o(),e.apply_styles=function(n,t){for(const[e,o]of u(t))(0,c.isString)(o)?n.setProperty(e,o):n.removeProperty(e)},e.compose_stylesheet=function(n){const t=[];for(const[e,o]of(0,i.entries)(n)){t.push(`${e} {`);for(const[n,e]of u(o))(0,c.isString)(e)&&0!=e.length&&t.push(`  ${n}: ${e};`);t.push("}")}return t.join("\n")};const s=n(20),i=n(9),c=n(8),l=document.createElement("div").style;function f(n){if(n.startsWith("--"))return n;const t=n.replaceAll(/_/g,"-").replaceAll(/[A-Z]/g,(n=>`-${n.toLowerCase()}`));if(t in l)return t;const e=`-webkit-${t}`;if(e in l)return e;const o=`-moz-${t}`;return o in l?o:(s.logger.warn(`unknown CSS property '${n}'`),null)}function*u(n){if((0,c.isPlainObject)(n)||n instanceof Map)for(const[t,e]of(0,i.entries)(n)){const n=f(t);null!=n&&(yield[n,e])}else for(const t of n.own_properties())if(t.dirty){const n=f(t.attr);null!=n&&(yield[n,t.get_value()])}}},
function _(s,e,t,i,_){i();const l=s(1),r=s(65),a=s(61),h=s(8),n=s(12),c=l.__importDefault(s(70));class p extends r.View{constructor(){super(...arguments),this._was_built=!1}get bbox(){}serializable_state(){const s=super.serializable_state(),{bbox:e}=this;return null!=e?{...s,bbox:e.round()}:s}get children_el(){return this.shadow_el??this.el}initialize(){super.initialize(),this.el=this._create_element()}remove(){this.el.remove(),super.remove()}stylesheets(){return[]}css_classes(){return[]}rerender(){this.render(),this.r_after_render()}render_to(s){this.render(),s.appendChild(this.el)}after_render(){this.reposition()}r_after_render(){for(const s of this.children())s instanceof p&&s.r_after_render();this.after_render(),this._was_built=!0}_create_element(){return(0,a.create_element)(this.constructor.tag_name,{role:this.constructor.aria_role})}reposition(s){}build(s){(0,n.assert)(this.is_root),this.render_to(s),this.r_after_render(),this.notify_finished()}rendering_target(){return null}}t.DOMView=p,p.__name__="DOMView",p.tag_name="div";class o extends p{initialize(){super.initialize(),this.class_list=new a.ClassList(this.el.classList)}get self_target(){return this.el}}t.DOMElementView=o,o.__name__="DOMElementView";class d extends o{constructor(){super(...arguments),this._base_style=new a.InlineStyleSheet(c.default,"base"),this._css_vars=new a.InlineStyleSheet("","vars"),this._applied_html_attributes=[],this._applied_stylesheets=[],this._applied_css_classes=[]}get self_target(){return this.shadow_el}initialize(){super.initialize(),this.shadow_el=this.el.attachShadow({mode:"open"})}stylesheets(){return[...super.stylesheets(),this._base_style]}static_stylesheets(){return this.stylesheets()}computed_stylesheets(){return[this._css_vars]}user_stylesheets(){return[]}empty(){(0,a.empty)(this.shadow_el),this.class_list.clear(),this._applied_css_classes=[],this._applied_stylesheets=[];for(const s of this.computed_stylesheets())s.persistent||s.clear()}render(){this.empty(),this._update_stylesheets(),this._apply_html_attributes()}_apply_html_attributes(){this._update_css_classes()}reposition(s){this._update_css_variables()}*_stylesheets(){yield*this.static_stylesheets(),yield*this.computed_stylesheets(),yield*this.user_stylesheets()}*_css_classes(){yield`bk-${this.model.type.replace(/\./g,"-")}`,yield*this.css_classes()}*_css_variables(){}_apply_stylesheets(s){const e=s.map((s=>(0,h.isString)(s)?new a.InlineStyleSheet(s):s));this._applied_stylesheets.push(...e),e.forEach((s=>s.install(this.shadow_el)))}_apply_css_classes(s){this._applied_css_classes.push(...s),this.class_list.add(...s)}_update_stylesheets(){this._applied_stylesheets.forEach((s=>s.uninstall())),this._applied_stylesheets=[],this._apply_stylesheets([...this._stylesheets()])}_update_css_classes(){this.class_list.remove(this._applied_css_classes),this._applied_css_classes=[],this._apply_css_classes([...this._css_classes()])}_update_css_variables(){const s=[];for(const[e,t]of this._css_variables()){const i=e.startsWith("--")?e:`--${e}`;s.push(`${i}: ${t};\n`)}0==s.length?this._css_vars.clear():this._css_vars.replace(`:host {\n${s}}`)}}t.DOMComponentView=d,d.__name__="DOMComponentView"},
function _(e,t,s,i,r){i();const n=e(15),o=e(16),l=e(8),a=e(57),h=e(66),_=e(67),c=e(68),d=e(27);class u{get ready(){return this._ready}_await_ready(e){this._ready=this._ready.then((()=>e)),this.root!=this&&(this.root._ready=this.root._ready.then((()=>this._ready)))}connect(e,t){let s=this._slots.get(t);return null==s&&(s=(e,s)=>{this._await_ready(Promise.resolve(t.call(this,e,s)))},this._slots.set(t,s)),e.connect(s,this)}disconnect(e,t){return e.disconnect(t,this)}constructor(e){this.removed=new o.Signal0(this,"removed"),this.views=new c.ViewQuery(this),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._destroyed=!1,this._has_finished=!1,this._idle_notified=!1;const{model:t,parent:s,owner:i}=e;this.model=t,this.parent=(0,l.isFunction)(s)?s(this.model):s,null==this.parent?(this.root=this,this.owner=i??new c.ViewManager([this])):(this.root=this.parent.root,this.owner=this.root.owner)}initialize(){}async lazy_initialize(){}remove(){this.disconnect_signals(),this.owner.remove(this),this.removed.emit(),this._destroyed=!0}get is_destroyed(){return this._destroyed}toString(){return`${this.model.type}View(${this.model.id})`}[d.equals](e,t){return Object.is(this,e)}*children(){}mark_finished(){this._has_finished=!0}force_finished(){this.mark_finished()}finish(){this.mark_finished(),this.notify_finished()}notify_finished(){if(this.is_root){if(!this._idle_notified&&this.has_finished()){const{document:e}=this.model;null!=e&&(this._idle_notified=!0,e.notify_idle(this.model))}}else this.root.notify_finished()}serializable_children(){return[...this.children()].filter((e=>e.model.is_syncable))}serializable_state(){const e=this.serializable_children().map((e=>e.serializable_state())).filter((e=>null!=e.bbox&&e.bbox.is_valid&&!e.bbox.is_empty));return{type:this.model.type,children:e}}get is_root(){return null==this.parent}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){o.Signal.disconnect_receiver(this)}on_change(e,t){for(const s of(0,l.isArray)(e)?e:[e])this.connect(s.change,t)}on_transitive_change(e,t,{recursive:s=!1,signal:i=e=>e.change}={}){const r=()=>{const t=e.is_unset?[]:e.get_value();return n.HasProps.references(t,{recursive:s})},o=e=>{for(const s of e)this.connect(i(s),(()=>t()))},l=e=>{for(const s of e)this.disconnect(i(s),(()=>t()))};let a=r();o(a),this.on_change(e,(()=>{l(a),a=r(),o(a),t()}))}cursor(e,t){return null}resolve_frame(){return null}resolve_canvas(){return null}resolve_plot(){return null}resolve_target(e){if(!(0,l.isString)(e)){const t=[this.root];for(;;){const s=t.shift();if(null==s)break;if(s.model==e)return s;t.push(...s.children())}return null}{const t=e=>{let t=this;for(;null!=t;){const s=e(t);if(null!=s)return s;t=t.parent}return null};switch(e){case"parent":return this.parent;case"frame":return t((e=>e.resolve_frame()));case"canvas":return t((e=>e.resolve_canvas()));case"plot":return t((e=>e.resolve_plot()))}}}resolve_symbol(e){return{x:NaN,y:NaN}}resolve_node(e){const t=this.resolve_target(e.target);return null!=t?t.resolve_symbol(e):{x:NaN,y:NaN}}resolve_coordinate(e){if(e instanceof h.XY){let t=this;for(;null!=t&&null==t.resolve_xy;)t=t.parent;return t?.resolve_xy?.(e)??{x:NaN,y:NaN}}if(e instanceof _.Indexed){let t=this;for(;null!=t&&null==t.resolve_indexed;)t=t.parent;return t?.resolve_indexed?.(e)??{x:NaN,y:NaN}}return e instanceof a.Node?this.resolve_node(e):{x:NaN,y:NaN}}resolve_as_xy(e){const t=this.resolve_coordinate(e);return(0,l.isNumber)(t)?{x:NaN,y:NaN}:t}resolve_as_scalar(e,t){const s=this.resolve_coordinate(e);return(0,l.isNumber)(s)?s:s[t]}}s.View=u,u.__name__="View"},
function _(n,e,o,t,s){var a;t();const c=n(58);class r extends c.Coordinate{constructor(n){super(n)}}o.XY=r,a=r,r.__name__="XY",a.define((({Float:n})=>({x:[n],y:[n]})))},
function _(e,n,d,r,t){var o;r();const s=e(58);class c extends s.Coordinate{constructor(e){super(e)}}d.Indexed=c,o=c,c.__name__="Indexed",o.define((({Int:e,AnyRef:n})=>({index:[e],renderer:[n()]})))},
function _(e,t,i,r,n){r();const o=e(69);class s{*all_views(){yield*this.query((()=>!0))}*query(e){const t=new Set;function*i(r){if(!t.has(r)){t.add(r),e(r)&&(yield r);for(const e of r.children())yield*i(e)}}for(const e of this)yield*i(e)}query_one(e){for(const t of this.query(e))return t;return null}*find(e){yield*this.query((t=>t.model==e))}*find_by_id(e){yield*this.query((t=>t.model.id==e))}find_one(e){for(const t of this.find(e))return t;return null}find_one_by_id(e){for(const t of this.find_by_id(e))return t;return null}get_one(e){const t=this.find_one(e);if(null!=t)return t;throw new Error(`cannot find a view for ${e}`)}get_one_by_id(e){const t=this.find_one_by_id(e);if(null!=t)return t;throw new Error(`cannot find a view for a model with '${e}' identity`)}find_all(e){return[...this.find(e)]}find_all_by_id(e){return[...this.find_by_id(e)]}select(e){return e.map((e=>this.find_one(e))).filter((e=>null!=e))}}s.__name__="AbstractViewQuery";class l extends s{constructor(e){super(),this.view=e}*[Symbol.iterator](){yield this.view}toString(){return`ViewQuery(${this.view})`}}i.ViewQuery=l,l.__name__="ViewQuery";class d extends s{constructor(e=[],t){super(),this.global=t,this._roots=new Set(e)}toString(){return`ViewManager(${[...this._roots].map((e=>`${e}`)).join(", ")})`}async build_view(e,t=null){const i=await(0,o.build_view)(e,{owner:this,parent:t});return null==t&&this.add(i),i}get(e){for(const t of this._roots)if(t.model==e)return t;return null}get_by_id(e){for(const t of this._roots)if(t.model.id==e)return t;return null}add(e){this._roots.add(e),this.global?.add(e)}delete(e){this._roots.delete(e),this.global?.delete(e)}remove(e){this.delete(e)}clear(){for(const e of this)e.remove()}get roots(){return[...this._roots]}*[Symbol.iterator](){yield*this._roots}}i.ViewManager=d,d.__name__="ViewManager"},
function _(e,n,t,o,i){o(),t.build_view=async function(e,n={parent:null},t=e=>e.default_view){const o=await a(t(e),e,n);return o.connect_signals(),o},t.build_views=async function(e,n,t={parent:null},o=e=>e.default_view){const i=(0,s.difference)([...e.keys()],n),c=[];for(const n of i){const t=e.get(n);null!=t&&(e.delete(n),c.push(t),t.remove())}const r=[],l=n.filter((n=>!e.has(n)));for(const n of l){const i=await a(o(n),n,t);e.set(n,i),r.push(i)}for(const e of r)e.connect_signals();return{created:r,removed:c}},t.remove_views=function(e){for(const[n,t]of e)t.remove(),e.delete(n)},t.traverse_views=function(e,n){const t=new Set,o=[...e];for(;;){const e=o.shift();if(void 0===e)break;t.has(e)||(t.add(e),o.push(...e.children()),n(e))}};const s=e(10),c=e(12);async function a(e,n,t){(0,c.assert)(null!=e,"model doesn't implement a view");const o=new e({...t,model:n});return o.initialize(),await o.lazy_initialize(),o}},
function _(o,r,e,i,t){i(),e.default=":host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:var(--bokeh-font-size, 12px);--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;--bokeh-top-level:10000;--color:#18191D;--background-color:#fff;--hover-color:#F9F9F9;--disabled-color:#747679;--border-color:#BBBBBD;--divider-color:#D7D7D8;--shortcut-color:#747679;--highlight-color:#65A2CB;--active-bg:#C3DBEB;--active-fg:#267BB6;--inactive-bg:#EBEBEB;--inactive-fg:#9A9B9D;--icon-color:var(--bokeh-icon-color, #747679);--icon-color-disabled:var(--bokeh-icon-color-disabled, #D7D7D8);--error:#D14250;--inverted-color:#fff;--placeholder-color:#9A9B9D;--surface-background-color:#EBEBEB;--disabled-background-color:#EBEBEB;--input-focus-border-color:#65A2CB;--input-focus-halo-color:rgba(101, 162, 203, 0.6);--border-style:solid;--border-width:1px;--border:var(--border-color) var(--border-style) var(--border-width);--box-shadow-color:rgba(0, 0, 0, 0.175);--box-shadow-inset:inset 0 3px 5px rgba(0, 0, 0, 0.125);--box-shadow-x-symmetric:0 6px 12px var(--box-shadow-color);--box-shadow:2px 4px 8px var(--box-shadow-color);--divider-width:1px;--divider:1px var(--divider-color) solid;--outline-color:#BBBBBD;--outline-style:dotted;--outline-width:1px;--outline:var(--outline-color) var(--outline-style) var(--outline-width);}:host{box-sizing:border-box;font-family:var(--base-font);font-size:var(--font-size);line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre,code,tt{font-family:var(--mono-font);margin:0;}"},
function _(t,e,i,s,a){s(),i.is_Exportable=function(t){return(0,o.isObject)(t)&&i.exportable in t};const n=t(72),r=t(62),h=t(61),o=t(8);i.exportable=Symbol("exportable");class c{get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}get pixel_ratio(){return this._pixel_ratio}constructor(t,e){switch(this._pixel_ratio=1,this.bbox=new r.BBox,this.backend=t,this.hidpi=e,t){case"webgl":case"canvas":{this._el=this._canvas=(0,h.canvas)({class:"bk-layer"});const t=this.canvas.getContext("2d");if(null==t)throw new Error("unable to obtain 2D rendering context");this._ctx=t,e&&(this._pixel_ratio=devicePixelRatio);break}case"svg":{const t=new n.SVGRenderingContext2D;this._ctx=t,this._canvas=t.get_svg(),this._el=(0,h.div)({class:"bk-layer"});this._el.attachShadow({mode:"open"}).appendChild(this._canvas);break}}Object.assign(this._ctx,{layer:this,rect_bbox(t){const{x:e,y:i,width:s,height:a}=t;this.rect(e,i,s,a)}})}get pixel_ratio_changed(){return!(!this.hidpi||"canvas"!=this.backend&&"webgl"!=this.backend)&&this.pixel_ratio!=devicePixelRatio}resize(t,e){const i=this.bbox.width!=t||this.bbox.height!=e,{pixel_ratio_changed:s}=this;if(!i&&!s)return;s&&(this._pixel_ratio=devicePixelRatio),this.bbox=new r.BBox({left:0,top:0,width:t,height:e});const{target:a}=this;a.width=t*this.pixel_ratio,a.height=e*this.pixel_ratio}get target(){return this._ctx instanceof n.SVGRenderingContext2D?this._ctx:this.canvas}undo_transform(t){const{ctx:e}=this,i=e.getTransform();e.resetTransform();try{t(e)}finally{e.setTransform(i)}}prepare(){const{ctx:t,hidpi:e,pixel_ratio:i}=this;return t.save(),e&&(t.scale(i,i),t.translate(.5,.5)),this.clear(),t}clear(){const{x:t,y:e,width:i,height:s}=this.bbox;this.ctx.clearRect(t,e,i,s)}finish(){this.ctx.restore()}to_blob(){const{_canvas:t}=this;if(t instanceof HTMLCanvasElement)return new Promise(((e,i)=>{t.toBlob((t=>null!=t?e(t):i()),"image/png")}));{const t=this._ctx.get_serialized_svg(!0),e=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(e)}}}i.CanvasLayer=c,c.__name__="CanvasLayer"},
function _(t,e,i,s,r){s();const n=t(73),a=t(8),o=t(23),l=t(9),h=t(74),_=t(11),c=t(61);function p(t){const e={left:"start",right:"end",center:"middle",start:"start",end:"end"};return t in e?e[t]:e.start}function u(t){const e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return t in e?e[t]:e.alphabetic}const d=function(t,e){const i=new Map,s=t.split(",");e=e??10;for(let t=0;t<s.length;t+=2){const r=`&${s[t+1]};`,n=parseInt(s[t],e);i.set(r,`&#${n};`)}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),m={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"},direction:{canvas:"inherit"},font:{canvas:"10px sans-serif"},fontKerning:{canvas:"auto"},fontStretch:{canvas:"normal"},fontVariantCaps:{canvas:"normal"},letterSpacing:{canvas:"0px"},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},textRendering:{canvas:"auto"},wordSpacing:{canvas:"0px"}};function f(t){if(function(t){return"undefined"!=typeof VideoFrame&&t instanceof VideoFrame}(t))return[t.codedWidth,t.codedHeight];{function e(t){return(0,a.isNumber)(t)?t:t.baseVal.value}const{width:i,height:s}=t;return[e(i),e(s)]}}class g{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){if("linearGradient"===this.__root.nodeName&&this.__root.getAttribute("x1")===this.__root.getAttribute("x2")&&this.__root.getAttribute("y1")===this.__root.getAttribute("y2"))return;if("radialGradient"===this.__root.nodeName&&this.__root.getAttribute("cx")===this.__root.getAttribute("fx")&&this.__root.getAttribute("cy")===this.__root.getAttribute("fy")&&this.__root.getAttribute("r")===this.__root.getAttribute("r0"))return;const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",`${t}`),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,r,n,a]=t;i.setAttribute("stop-color",`rgb(${s},${r},${n})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}g.__name__="CanvasGradient";class b{constructor(t,e){this.__root=t,this.__ctx=e}setTransform(t){throw new Error("not implemented")}}b.__name__="CanvasPattern";class v{get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",`${t}`)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",`${t}`)}constructor(t){this.__currentDefaultPath="",this.__currentPosition=null,this.globalAlpha=1,this._transform=new n.AffineTransform,this._clip_path=null,this.__document=t?.document??document,null!=t?.ctx?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.reset(),this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__currentElement=this.__root,this.width=t?.width??500,this.height=t?.height??500,this.__ids=new Set,this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}_random_string(){let t;do{t=v.__random.choices(12,"ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz").join("")}while(this.__ids.has(t));return t}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const r=Object.keys(e);for(const t of r)s.setAttribute(t,`${e[t]}`);return s}__setDefaultStyles(){for(const[t,e]of(0,l.typed_entries)(m))this[t]=e.canvas}__applyStyleState(t){for(const[e,i]of(0,l.typed_entries)(t))this[e]=i}__getStyleState(){const t={};for(const[e,i]of(0,l.typed_entries)(m))t[e]=this[e];return t}__applyStyleToCurrentElement(t){const e=this.__currentElement;for(const[i,s]of(0,l.typed_entries)(m)){const r=this[i];if(null!=s.apply&&s.apply.includes(t))if(r instanceof b){for(const t of[...r.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids.add(e),this.__defs.appendChild(t)}const t=r.__root.getAttribute("id");e.setAttribute(s.apply,`url(#${t})`)}else if(r instanceof g){const t=r.__root.getAttribute("id");e.setAttribute(s.apply,`url(#${t})`)}else if(s.svg!==r)if("stroke"!==s.svgAttr&&"fill"!==s.svgAttr||!(0,a.isString)(r)||-1===r.indexOf("rgb")){let n=s.svgAttr;if("globalAlpha"===i&&(n=`${t}-${s.svgAttr}`,null!=e.getAttribute(n)))continue;e.setAttribute(n,`${r}`)}else{const[t,i,n,a]=(0,o.css4_parse)(r)??(0,o.transparent)(),l=a*this.globalAlpha;e.setAttribute(s.svgAttr,`rgb(${t},${i},${n})`),e.setAttribute(`${s.svgAttr}-opacity`,`${l}`)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(t)for(const[t,i]of d){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}isContextLost(){return!1}reset(){this.__setDefaultStyles(),this.__stack=[]}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}_apply_global_alpha(t){1!=this.globalAlpha&&t.setAttribute("opacity",`${this.globalAlpha}`)}_apply_clip_path(t){null!=this._clip_path&&t.setAttribute("clip-path",this._clip_path)}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,e??t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,r,n){isFinite(t+e+i+s+r+n)&&this._transform.transform(t,e,i,s,r,n)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()}__init_element(){const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=""==this.__currentDefaultPath?"":" ";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return""!=this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))return;const[a,o]=this._transform.apply(r,n),[l,h]=this._transform.apply(t,e),[_,c]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${_} ${c} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[r,n]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(r,n,`Q ${a} ${o} ${r} ${n}`)}arcTo(t,e,i,s,r){if(!isFinite(t+e+i+s+r))return;if(null==this.__currentPosition)return;const n=this._transform.inverse(),[a,o]=n.apply(this.__currentPosition.x,this.__currentPosition.y);if(r<0)throw new Error(`IndexSizeError: The radius provided (${r}) is negative.`);if(a===t&&o===e||t===i&&e===s||0===r)return void this.lineTo(t,e);function l([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const h=l([a-t,o-e]),_=l([i-t,s-e]);if(h[0]*_[1]==h[1]*_[0])return void this.lineTo(t,e);const c=h[0]*_[0]+h[1]*_[1],p=Math.acos(Math.abs(c)),u=l([h[0]+_[0],h[1]+_[1]]),d=r/Math.sin(p/2),m=t+d*u[0],f=e+d*u[1],g=[-h[1],h[0]],b=[_[1],-_[0]];function v(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const A=v(g),y=v(b);this.lineTo(m+g[0]*r,f+g[1]*r),this.arc(m,f,r,A,y)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(t,e){let i=null;if(t instanceof Path2D)i=t;else{if(null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=e&&"nonzero"!=e&&this.__currentElement.setAttribute("fill-rule",e),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&(this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e),this.closePath())}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){(0,c.empty)(this.__defs),(0,c.empty)(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const r=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(r),this.__root.appendChild(r)}roundRect(t,e,i,s,r){throw new Error("not implemented")}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[r,n]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),l=this.__createElement("linearGradient",{id:this._random_string(),x1:`${r}px`,x2:`${a}px`,y1:`${n}px`,y2:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new g(l,this)}createRadialGradient(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[l,h]=this._transform.apply(s,r),_=this.__createElement("radialGradient",{id:this._random_string(),cx:`${l}px`,cy:`${h}px`,r:`${n}px`,r0:`${i}px`,fx:`${a}px`,fy:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new g(_,this)}createConicGradient(t,e,i){throw Error("not implemented")}__parseFont(){const[,t,e,i,s,,r]=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);return{style:t??"normal",size:s??"10px",family:r??"sans-serif",weight:i??"normal",decoration:e??"normal"}}__applyText(t,e,i,s){const r=this.__parseFont(),n=this.__createElement("text",{"font-family":r.family,"font-size":r.size,"font-style":r.style,"font-weight":r.weight,"text-decoration":r.decoration,x:e,y:i,"text-anchor":p(this.textAlign),"dominant-baseline":u(this.textBaseline)},!0);n.appendChild(this.__document.createTextNode(t)),this._apply_transform(n),this.__currentElement=n,this.__applyStyleToCurrentElement(s);const a=(()=>{if(null!=this._clip_path){const t=this.__createElement("g");return t.setAttribute("clip-path",this._clip_path),t.appendChild(n),t}return n})();this.__root.appendChild(a)}fillText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,r,n=!1){this.ellipse(t,e,i,i,0,s,r,n)}ellipse(t,e,i,s,r,a,o,l=!1){if(!isFinite(t+e+i+s+r+a+o))return;if(i<0||s<0)throw new DOMException("IndexSizeError, radius can't be negative");const h=l?o-a:a-o;a%=2*Math.PI,o%=2*Math.PI;const c=(new n.AffineTransform).translate(t,e).rotate(r),p=i*Math.cos(a),u=s*Math.sin(a),[d,m]=c.apply(p,u);this.lineTo(d,m);const f=180*r/Math.PI,g=l?0:1;if(Math.abs(a-o)<2*_.float32_epsilon&&!(Math.abs(h)<2*_.float32_epsilon&&h<0)){const[t,e]=this._transform.apply(d,m),r=i*Math.cos(a+Math.PI),n=s*Math.sin(a+Math.PI),[o,l]=c.apply(r,n),[h,_]=this._transform.apply(o,l);this.__addPathCommand(t,e,`A ${i} ${s} ${f} 0 ${g} ${h} ${_} A ${i} ${s} ${f} 0 ${g} ${t} ${e}`)}else{const t=i*Math.cos(o),e=s*Math.sin(o),[r,n]=c.apply(t,e);let h=o-a;h<0&&(h+=2*Math.PI);const _=l!==h>Math.PI?1:0,[p,u]=this._transform.apply(r,n);this.__addPathCommand(p,u,`A ${i} ${s} ${f} ${_} ${g} ${p} ${u}`)}}clip(t,e){let i=null;if(t instanceof Path2D)i=t;else{if(null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");const s=this.__createElement("clipPath"),r=this._random_string();this.__applyCurrentDefaultPath(),null!=e&&this.__currentElement.setAttribute("clip-rule",e),s.setAttribute("id",r),s.appendChild(this.__currentElement),this.__defs.appendChild(s),this._clip_path=`url(#${r})`}drawImage(t,...e){let i,s,r,n,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0;const[_,c]=f(t);r=l=_,n=h=c}else if(4==e.length){if([i,s,r,n]=e,!isFinite(i+s+r+n))return;a=0,o=0;const[_,c]=f(t);l=_,h=c}else{if(8!==e.length)throw new Error(`Invalid number of arguments passed to drawImage: ${arguments.length}`);if([a,o,l,h,i,s,r,n]=e,!isFinite(a+o+l+h+i+s+r+n))return}const _=this.__root,c=this._transform.clone().translate(i,s);if(t instanceof v||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;if(c.is_identity&&1==this.globalAlpha&&null==this._clip_path)i=_;else{if(i=this.__createElement("g"),_.appendChild(i),null!=this._clip_path&&(this._apply_clip_path(i),!c.is_identity)){const t=i;i=this.__createElement("g"),t.appendChild(i)}this._apply_transform(i,c),this._apply_global_alpha(i)}for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids.add(t),this.__defs.appendChild(e.cloneNode(!0))}}else i.appendChild(t.cloneNode(!0))}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`),0!=a||0!=o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=r,e.height=n;e.getContext("2d").drawImage(t,a,o,l,h,0,0,r,n),t=e}this._apply_transform(e,c);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");if(e.setAttribute("href",i),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`);const i=this.__document.createElement("canvas");i.width=r,i.height=n;const s=i.getContext("2d");if(s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,r,n),t=i,this._apply_transform(e,c),e.setAttribute("href",t.toDataURL()),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=this._random_string(),[r,n]=f(t);if(i.setAttribute("id",s),i.setAttribute("width",`${r}`),i.setAttribute("height",`${n}`),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttribute("href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof v){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}return new b(i,this)}getLineDash(){const{lineDash:t}=this;return(0,a.isString)(t)?t.split(",").map((t=>parseInt(t))):t??[]}setLineDash(t){t.length>0?this.lineDash=t.join(","):this.lineDash=null}getTransform(){return this._transform.to_DOMMatrix()}setTransform(...t){let e;e=(0,a.isNumber)(t[0])?new DOMMatrix(t):t[0]instanceof DOMMatrix?t[0]:new DOMMatrix(Object.values(null==t[0])),this._transform=n.AffineTransform.from_DOMMatrix(e)}resetTransform(){this._transform=new n.AffineTransform}isPointInPath(...t){throw new Error("not implemented")}isPointInStroke(...t){throw new Error("not implemented")}createImageData(...t){throw new Error("not implemented")}getImageData(t,e,i,s){throw new Error("not implemented")}putImageData(...t){throw new Error("not implemented")}drawFocusIfNeeded(...t){throw new Error("not implemented")}scrollPathIntoView(...t){throw new Error("not implemented")}}i.SVGRenderingContext2D=v,v.__name__="SVGRenderingContext2D",v.__random=h.random},
function _(t,r,s,e,i){e(),s.rotate_around=function(t,r,s){if(0==s)return t;{const e=new o;e.rotate_around(r.x,r.y,s);const[i,n]=e.apply(t.x,t.y);return{x:i,y:n}}};const n=t(27),{sin:a,cos:h}=Math;class o{constructor(t=1,r=0,s=0,e=1,i=0,n=0){this.a=t,this.b=r,this.c=s,this.d=e,this.e=i,this.f=n}toString(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return`matrix(${t}, ${r}, ${s}, ${e}, ${i}, ${n})`}static from_DOMMatrix(t){const{a:r,b:s,c:e,d:i,e:n,f:a}=t;return new o(r,s,e,i,n,a)}to_DOMMatrix(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return new DOMMatrix([t,r,s,e,i,n])}clone(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return new o(t,r,s,e,i,n)}[n.equals](t,r){return r.eq(this.a,t.a)&&r.eq(this.b,t.b)&&r.eq(this.c,t.c)&&r.eq(this.d,t.d)&&r.eq(this.e,t.e)&&r.eq(this.f,t.f)}reset(){this.a=1,this.b=0,this.c=0,this.d=1,this.e=0,this.f=0}get is_identity(){const{a:t,b:r,c:s,d:e,e:i,f:n}=this;return 1==t&&0==r&&0==s&&1==e&&0==i&&0==n}apply_point(t){const[r,s]=this.apply(t.x,t.y);return{x:r,y:s}}apply_rect(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}}apply(t,r){const{a:s,b:e,c:i,d:n,e:a,f:h}=this;return[s*t+i*r+a,e*t+n*r+h]}iv_apply(t,r){const{a:s,b:e,c:i,d:n,e:a,f:h}=this,o=t.length;for(let c=0;c<o;c++){const o=t[c],p=r[c];t[c]=s*o+i*p+a,r[c]=e*o+n*p+h}}transform(t,r,s,e,i,n){const{a,b:h,c:o,d:c,e:p,f}=this;return this.a=a*t+o*r,this.c=a*s+o*e,this.e=a*i+o*n+p,this.b=h*t+c*r,this.d=h*s+c*e,this.f=h*i+c*n+f,this}translate(t,r){return this.transform(1,0,0,1,t,r)}scale(t,r){return this.transform(t,0,0,r,0,0)}skew(t,r){return this.transform(1,r,t,1,0,0)}rotate(t){if(0==t)return this;const r=a(t),s=h(t);return this.transform(s,r,-r,s,0,0)}rotate_ccw(t){return this.rotate(-t)}rotate_around(t,r,s){return this.translate(t,r),this.rotate(s),this.translate(-t,-r),this}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}inverse(){return o.from_DOMMatrix(this.to_DOMMatrix().inverse())}}s.AffineTransform=o,o.__name__="AffineTransform"},
function _(t,e,n,s,r){s();const{PI:o,log:a,sin:_,cos:i,sqrt:m,floor:l}=Math;n.MAX_INT32=2147483647;class d{float(){return(this.integer()-1)/(n.MAX_INT32-1)}floats(t,e=0,n=1){const s=new Array(t);for(let r=0;r<t;r++)s[r]=e+this.float()*(n-e);return s}choices(t,e){const n=e.length,s=new Array(t);for(let r=0;r<t;r++)s[r]=e[this.integer()%n];return s}uniform(t,e){return t+(this.float()-.5)*e}uniforms(t,e,n){return Float64Array.from({length:n},(()=>this.uniform(t,e)))}normal(t,e){return this.normals(t,e,1)[0]}normals(t,e,n){const[s,r]=[t,e],l=new Float64Array(n);for(let t=0;t<n;t+=2){const e=this.float(),d=this.float(),h=m(-2*a(e));l[t]=s+r*(h*i(2*o*d)),t+1<n&&(l[t+1]=s+r*(h*_(2*o*d)))}return l}}n.AbstractRandom=d,d.__name__="AbstractRandom";class h extends d{integer(){return l(Math.random()*n.MAX_INT32)}}n.SystemRandom=h,h.__name__="SystemRandom";class c extends d{constructor(t){super(),this._seed=t%n.MAX_INT32,this._seed<=0&&(this._seed+=n.MAX_INT32-1)}integer(){return this._seed=48271*this._seed%n.MAX_INT32,this._seed}}n.LCGRandom=c,c.__name__="LCGRandom";class f extends c{}n.Random=f,f.__name__="Random",n.random=new f(Date.now())},
function _(t,e,o,i,n){i(),o.default=":host{position:relative;pointer-events:auto;}"},
function _(o,e,i,t,r){t(),i.tool_icon_dark_theme=i.tool_icon_light_theme=i.tool_icon_list=i.tool_icon_square_check=i.tool_icon_square=i.tool_icon_check=i.tool_icon_text_align_right=i.tool_icon_text_align_center=i.tool_icon_text_align_left=i.tool_icon_italic=i.tool_icon_bold=i.tool_icon_delete=i.tool_icon_pointer=i.tool_icon_unpin=i.tool_icon_pin=i.tool_icon_maximize=i.tool_icon_minimize=i.tool_icon_arrow_up_from_bar=i.tool_icon_arrow_down_to_bar=i.tool_icon_y_grip=i.tool_icon_x_grip=i.tool_icon_see_off=i.tool_icon_see_on=i.tool_icon_caret_right=i.tool_icon_caret_left=i.tool_icon_caret_down=i.tool_icon_caret_up=i.tool_icon_chevron_right=i.tool_icon_chevron_left=void 0,i.tool_icon_copy="bk-tool-icon-copy",i.tool_icon_open="bk-tool-icon-open",i.tool_icon_replace_mode="bk-tool-icon-replace-mode",i.tool_icon_toggle_mode="bk-tool-icon-toggle-mode",i.tool_icon_append_mode="bk-tool-icon-append-mode",i.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",i.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",i.tool_icon_xor_mode="bk-tool-icon-xor-mode",i.tool_icon_invert_selection="bk-tool-icon-invert-selection",i.tool_icon_clear_selection="bk-tool-icon-clear-selection",i.tool_icon_box_select="bk-tool-icon-box-select",i.tool_icon_x_box_select="bk-tool-icon-x-box-select",i.tool_icon_y_box_select="bk-tool-icon-y-box-select",i.tool_icon_box_zoom="bk-tool-icon-box-zoom",i.tool_icon_x_box_zoom="bk-tool-icon-x-box-zoom",i.tool_icon_y_box_zoom="bk-tool-icon-y-box-zoom",i.tool_icon_auto_box_zoom="bk-tool-icon-auto-box-zoom",i.tool_icon_zoom_in="bk-tool-icon-zoom-in",i.tool_icon_zoom_out="bk-tool-icon-zoom-out",i.tool_icon_help="bk-tool-icon-help",i.tool_icon_hover="bk-tool-icon-hover",i.tool_icon_crosshair="bk-tool-icon-crosshair",i.tool_icon_lasso_select="bk-tool-icon-lasso-select",i.tool_icon_pan="bk-tool-icon-pan",i.tool_icon_x_pan="bk-tool-icon-x-pan",i.tool_icon_y_pan="bk-tool-icon-y-pan",i.tool_icon_pan_left="bk-tool-icon-pan-left",i.tool_icon_pan_right="bk-tool-icon-pan-right",i.tool_icon_pan_up="bk-tool-icon-pan-up",i.tool_icon_pan_down="bk-tool-icon-pan-down",i.tool_icon_range="bk-tool-icon-range",i.tool_icon_polygon_select="bk-tool-icon-polygon-select",i.tool_icon_redo="bk-tool-icon-redo",i.tool_icon_reset="bk-tool-icon-reset",i.tool_icon_save="bk-tool-icon-save",i.tool_icon_tap_select="bk-tool-icon-tap-select",i.tool_icon_undo="bk-tool-icon-undo",i.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",i.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",i.tool_icon_box_edit="bk-tool-icon-box-edit",i.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",i.tool_icon_poly_draw="bk-tool-icon-poly-draw",i.tool_icon_point_draw="bk-tool-icon-point-draw",i.tool_icon_poly_edit="bk-tool-icon-poly-edit",i.tool_icon_line_edit="bk-tool-icon-line-edit",i.tool_icon_settings="bk-tool-icon-settings",i.tool_icon_unknown="bk-tool-icon-unknown",i.tool_icon_fullscreen="bk-tool-icon-fullscreen",i.tool_icon_chevron_up="bk-tool-icon-chevron-up",i.tool_icon_chevron_down="bk-tool-icon-chevron-down",i.tool_icon_chevron_left="bk-tool-icon-chevron-left",i.tool_icon_chevron_right="bk-tool-icon-chevron-right",i.tool_icon_caret_up="bk-tool-icon-caret-up",i.tool_icon_caret_down="bk-tool-icon-caret-down",i.tool_icon_caret_left="bk-tool-icon-caret-left",i.tool_icon_caret_right="bk-tool-icon-caret-right",i.tool_icon_see_on="bk-tool-icon-see-on",i.tool_icon_see_off="bk-tool-icon-see-off",i.tool_icon_x_grip="bk-tool-icon-x-grip",i.tool_icon_y_grip="bk-tool-icon-y-grip",i.tool_icon_arrow_down_to_bar="bk-tool-icon-arrow-down-to-bar",i.tool_icon_arrow_up_from_bar="bk-tool-icon-arrow-up-from-bar",i.tool_icon_minimize="bk-tool-icon-minimize",i.tool_icon_maximize="bk-tool-icon-maximize",i.tool_icon_pin="bk-tool-icon-pin",i.tool_icon_unpin="bk-tool-icon-unpin",i.tool_icon_pointer="bk-tool-icon-pointer",i.tool_icon_delete="bk-tool-icon-delete",i.tool_icon_bold="bk-tool-icon-bold",i.tool_icon_italic="bk-tool-icon-italic",i.tool_icon_text_align_left="bk-tool-icon-text-align-left",i.tool_icon_text_align_center="bk-tool-icon-text-align-center",i.tool_icon_text_align_right="bk-tool-icon-text-align-right",i.tool_icon_check="bk-tool-icon-check",i.tool_icon_square="bk-tool-icon-square",i.tool_icon_square_check="bk-tool-icon-square-check",i.tool_icon_list="bk-tool-icon-list",i.tool_icon_light_theme="bk-tool-icon-light-theme",i.tool_icon_dark_theme="bk-tool-icon-dark-theme",i.default='.bk-tool-icon-copy{background-color:var(--icon-color);mask-image:var(--bokeh-icon-copy);-webkit-mask-image:var(--bokeh-icon-copy);}.bk-tool-icon-open{background-color:var(--icon-color);mask-image:var(--bokeh-icon-open);-webkit-mask-image:var(--bokeh-icon-open);}.bk-tool-icon-replace-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-replace-mode);-webkit-mask-image:var(--bokeh-icon-replace-mode);}.bk-tool-icon-toggle-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-toggle-mode);-webkit-mask-image:var(--bokeh-icon-toggle-mode);}.bk-tool-icon-append-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-append-mode);-webkit-mask-image:var(--bokeh-icon-append-mode);}.bk-tool-icon-intersect-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-intersect-mode);-webkit-mask-image:var(--bokeh-icon-intersect-mode);}.bk-tool-icon-subtract-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-subtract-mode);-webkit-mask-image:var(--bokeh-icon-subtract-mode);}.bk-tool-icon-xor-mode{background-color:var(--icon-color);mask-image:var(--bokeh-icon-xor-mode);-webkit-mask-image:var(--bokeh-icon-xor-mode);}.bk-tool-icon-invert-selection{background-color:var(--icon-color);mask-image:var(--bokeh-icon-invert-selection);-webkit-mask-image:var(--bokeh-icon-invert-selection);}.bk-tool-icon-clear-selection{background-color:var(--icon-color);mask-image:var(--bokeh-icon-clear-selection);-webkit-mask-image:var(--bokeh-icon-clear-selection);}.bk-tool-icon-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-select);-webkit-mask-image:var(--bokeh-icon-box-select);}.bk-tool-icon-x-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-select);-webkit-mask-image:var(--bokeh-icon-x-box-select);}.bk-tool-icon-y-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-select);-webkit-mask-image:var(--bokeh-icon-y-box-select);}.bk-tool-icon-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-zoom);-webkit-mask-image:var(--bokeh-icon-box-zoom);}.bk-tool-icon-x-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-zoom);-webkit-mask-image:var(--bokeh-icon-x-box-zoom);}.bk-tool-icon-y-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-zoom);-webkit-mask-image:var(--bokeh-icon-y-box-zoom);}.bk-tool-icon-auto-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-auto-box-zoom);-webkit-mask-image:var(--bokeh-icon-auto-box-zoom);}.bk-tool-icon-zoom-in{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-in);-webkit-mask-image:var(--bokeh-icon-zoom-in);}.bk-tool-icon-zoom-out{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-out);-webkit-mask-image:var(--bokeh-icon-zoom-out);}.bk-tool-icon-help{background-color:var(--icon-color);mask-image:var(--bokeh-icon-help);-webkit-mask-image:var(--bokeh-icon-help);}.bk-tool-icon-hover{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hover);-webkit-mask-image:var(--bokeh-icon-hover);}.bk-tool-icon-crosshair{background-color:var(--icon-color);mask-image:var(--bokeh-icon-crosshair);-webkit-mask-image:var(--bokeh-icon-crosshair);}.bk-tool-icon-lasso-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-lasso-select);-webkit-mask-image:var(--bokeh-icon-lasso-select);}.bk-tool-icon-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan);-webkit-mask-image:var(--bokeh-icon-pan);}.bk-tool-icon-x-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-pan);-webkit-mask-image:var(--bokeh-icon-x-pan);}.bk-tool-icon-y-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-pan);-webkit-mask-image:var(--bokeh-icon-y-pan);}.bk-tool-icon-pan-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-left);-webkit-mask-image:var(--bokeh-icon-pan-left);}.bk-tool-icon-pan-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-right);-webkit-mask-image:var(--bokeh-icon-pan-right);}.bk-tool-icon-pan-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-up);-webkit-mask-image:var(--bokeh-icon-pan-up);}.bk-tool-icon-pan-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-down);-webkit-mask-image:var(--bokeh-icon-pan-down);}.bk-tool-icon-range{background-color:var(--icon-color);mask-image:var(--bokeh-icon-range);-webkit-mask-image:var(--bokeh-icon-range);}.bk-tool-icon-polygon-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-polygon-select);-webkit-mask-image:var(--bokeh-icon-polygon-select);}.bk-tool-icon-redo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-redo);-webkit-mask-image:var(--bokeh-icon-redo);}.bk-tool-icon-reset{background-color:var(--icon-color);mask-image:var(--bokeh-icon-reset);-webkit-mask-image:var(--bokeh-icon-reset);}.bk-tool-icon-save{background-color:var(--icon-color);mask-image:var(--bokeh-icon-save);-webkit-mask-image:var(--bokeh-icon-save);}.bk-tool-icon-tap-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-tap-select);-webkit-mask-image:var(--bokeh-icon-tap-select);}.bk-tool-icon-undo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-undo);-webkit-mask-image:var(--bokeh-icon-undo);}.bk-tool-icon-wheel-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-wheel-pan);-webkit-mask-image:var(--bokeh-icon-wheel-pan);}.bk-tool-icon-wheel-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-wheel-zoom);-webkit-mask-image:var(--bokeh-icon-wheel-zoom);}.bk-tool-icon-box-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-edit);-webkit-mask-image:var(--bokeh-icon-box-edit);}.bk-tool-icon-freehand-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-freehand-draw);-webkit-mask-image:var(--bokeh-icon-freehand-draw);}.bk-tool-icon-poly-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-poly-draw);-webkit-mask-image:var(--bokeh-icon-poly-draw);}.bk-tool-icon-point-draw{background-color:var(--icon-color);mask-image:var(--bokeh-icon-point-draw);-webkit-mask-image:var(--bokeh-icon-point-draw);}.bk-tool-icon-poly-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-poly-edit);-webkit-mask-image:var(--bokeh-icon-poly-edit);}.bk-tool-icon-line-edit{background-color:var(--icon-color);mask-image:var(--bokeh-icon-line-edit);-webkit-mask-image:var(--bokeh-icon-line-edit);}.bk-tool-icon-settings{background-color:var(--icon-color);mask-image:var(--bokeh-icon-settings);-webkit-mask-image:var(--bokeh-icon-settings);}.bk-tool-icon-unknown{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unknown);-webkit-mask-image:var(--bokeh-icon-unknown);}.bk-tool-icon-fullscreen{background-color:var(--icon-color);mask-image:var(--bokeh-icon-fullscreen);-webkit-mask-image:var(--bokeh-icon-fullscreen);}.bk-tool-icon-chevron-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}.bk-tool-icon-chevron-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-tool-icon-chevron-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}.bk-tool-icon-chevron-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}.bk-tool-icon-caret-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-up);-webkit-mask-image:var(--bokeh-icon-caret-up);}.bk-tool-icon-caret-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-down);-webkit-mask-image:var(--bokeh-icon-caret-down);}.bk-tool-icon-caret-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-left);-webkit-mask-image:var(--bokeh-icon-caret-left);}.bk-tool-icon-caret-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);}.bk-tool-icon-see-on{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-on);-webkit-mask-image:var(--bokeh-icon-see-on);}.bk-tool-icon-see-off{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-off);-webkit-mask-image:var(--bokeh-icon-see-off);}.bk-tool-icon-x-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-grip);-webkit-mask-image:var(--bokeh-icon-x-grip);}.bk-tool-icon-y-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-arrow-down-to-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}.bk-tool-icon-arrow-up-from-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-tool-icon-minimize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-tool-icon-maximize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}.bk-tool-icon-pin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}.bk-tool-icon-unpin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-tool-icon-pointer{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hand-pointing);-webkit-mask-image:var(--bokeh-icon-hand-pointing);}.bk-tool-icon-delete{background-color:var(--icon-color);mask-image:var(--bokeh-icon-trash);-webkit-mask-image:var(--bokeh-icon-trash);}.bk-tool-icon-bold{background-color:var(--icon-color);mask-image:var(--bokeh-icon-bold);-webkit-mask-image:var(--bokeh-icon-bold);}.bk-tool-icon-italic{background-color:var(--icon-color);mask-image:var(--bokeh-icon-italic);-webkit-mask-image:var(--bokeh-icon-italic);}.bk-tool-icon-text-align-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-left);-webkit-mask-image:var(--bokeh-icon-text-align-left);}.bk-tool-icon-text-align-center{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-center);-webkit-mask-image:var(--bokeh-icon-text-align-center);}.bk-tool-icon-text-align-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-right);-webkit-mask-image:var(--bokeh-icon-text-align-right);}.bk-tool-icon-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);}.bk-tool-icon-square{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square);-webkit-mask-image:var(--bokeh-icon-square);}.bk-tool-icon-square-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square-check);-webkit-mask-image:var(--bokeh-icon-square-check);}.bk-tool-icon-list{background-color:var(--icon-color);mask-image:var(--bokeh-icon-list);-webkit-mask-image:var(--bokeh-icon-list);}.bk-tool-icon-light-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-light-theme);-webkit-mask-image:var(--bokeh-icon-light-theme);}.bk-tool-icon-dark-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-dark-theme);-webkit-mask-image:var(--bokeh-icon-dark-theme);}:host{--bokeh-icon-question-mark:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%208a3.5%203%200%200%201%203.5%20-3h1a3.5%203%200%200%201%203.5%203a3%203%200%200%201%20-2%203a3%204%200%200%200%20-2%204%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2219%22%20x2%3D%2212%22%20y2%3D%2219.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-help:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2217%22%20x2%3D%2212%22%20y2%3D%2217.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2013.5a1.5%201.5%200%200%201%201%20-1.5a2.6%202.6%200%201%200%20-3%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%206l-12%2012%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%206l12%2012%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-settings:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M10.325%204.317c.426%20-1.756%202.924%20-1.756%203.35%200a1.724%201.724%200%200%200%202.573%201.066c1.543%20-.94%203.31%20.826%202.37%202.37a1.724%201.724%200%200%200%201.065%202.572c1.756%20.426%201.756%202.924%200%203.35a1.724%201.724%200%200%200%20-1.066%202.573c.94%201.543%20-.826%203.31%20-2.37%202.37a1.724%201.724%200%200%200%20-2.572%201.065c-.426%201.756%20-2.924%201.756%20-3.35%200a1.724%201.724%200%200%200%20-2.573%20-1.066c-1.543%20.94%20-3.31%20-.826%20-2.37%20-2.37a1.724%201.724%200%200%200%20-1.065%20-2.572c-1.756%20-.426%20-1.756%20-2.924%200%20-3.35a1.724%201.724%200%200%200%201.066%20-2.573c-.94%20-1.543%20.826%20-3.31%202.37%20-2.37c1%20.608%202.296%20.07%202.572%20-1.065z%22%3E%3C%2Fpath%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%223%22%3E%3C%2Fcircle%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unknown:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14%203v4a1%201%200%200%200%201%201h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2021h-10a2%202%200%200%201%20-2%20-2v-14a2%202%200%200%201%202%20-2h7l5%205v11a2%202%200%200%201%20-2%202z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2017v.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2014a1.5%201.5%200%201%200%20-1.14%20-2.474%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-fullscreen:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%223%22%20y%3D%2216%22%20width%3D%225%22%20height%3D%225%22%20rx%3D%221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012v-6a2%202%200%200%201%202%20-2h12a2%202%200%200%201%202%202v12a2%202%200%200%201%20-2%202h-6%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%208h4v4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208l-5%205%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-save:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2017v2a2%202%200%200%200%202%202h12a2%202%200%200%200%202%20-2v-2%22%20%2F%3E%0A%20%20%3Cpolyline%20points%3D%227%2011%2012%2016%2017%2011%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%224%22%20x2%3D%2212%22%20y2%3D%2216%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-copy:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228%22%20y%3D%228%22%20width%3D%2212%22%20height%3D%2212%22%20rx%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208v-2a2%202%200%200%200%20-2%20-2h-8a2%202%200%200%200%20-2%202v8a2%202%200%200%200%202%202h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-open:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%204h3l2%202h5a2%202%200%200%201%202%202v7a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2017v2a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-tap-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%2212%22%20x2%3D%226%22%20y2%3D%2212%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%223%22%20x2%3D%2212%22%20y2%3D%226%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%227.8%22%20x2%3D%225.6%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2216.2%22%20y1%3D%227.8%22%20x2%3D%2218.4%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%2216.2%22%20x2%3D%225.6%22%20y2%3D%2218.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012l9%203l-4%202l-2%204l-3%20-9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-lasso-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.028%2013.252c-.657%20-.972%20-1.028%20-2.078%20-1.028%20-3.252c0%20-3.866%204.03%20-7%209%20-7s9%203.134%209%207s-4.03%207%20-9%207c-1.913%200%20-3.686%20-.464%20-5.144%20-1.255%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%225%22%20cy%3D%2215%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2017c0%201.42%20.316%202.805%201%204%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-polygon-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M21.0003%2011.341L18.6863%204.27072L5.18848%205.42767L4.03152%2019.6968L12.664%2018.2014%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.7174%2018.8084C14.7166%2018.9614%2014.7627%2019.111%2014.8494%2019.2371C14.936%2019.3631%2015.0592%2019.4597%2015.2023%2019.5138C15.3455%2019.5679%2015.5017%2019.5769%2015.6501%2019.5396C15.7985%2019.5024%2015.9319%2019.4207%2016.0326%2019.3054L17.7357%2017.7103L20.0454%2021.3822C20.092%2021.4564%2020.1528%2021.5206%2020.2243%2021.5713C20.2957%2021.6219%2020.3765%2021.658%2020.4619%2021.6774C20.5473%2021.6969%2020.6357%2021.6993%2020.722%2021.6846C20.8084%2021.6699%2020.891%2021.6383%2020.9651%2021.5917L21.7486%2021.0989C21.8227%2021.0522%2021.8869%2020.9914%2021.9376%2020.92C21.9883%2020.8485%2022.0243%2020.7678%2022.0438%2020.6824C22.0632%2020.597%2022.0657%2020.5086%2022.051%2020.4222C22.0362%2020.3359%2022.0047%2020.2533%2021.958%2020.1791L19.6484%2016.5073L21.8358%2015.6655C21.9833%2015.6247%2022.1147%2015.5397%2022.2125%2015.422C22.3103%2015.3044%2022.3698%2015.1596%2022.383%2015.0071C22.3961%2014.8547%2022.3624%2014.7018%2022.2862%2014.5691C22.21%2014.4364%2022.095%2014.3302%2021.9567%2014.2647L14.2205%2010L14.7174%2018.8084Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2015h-8v3.586a1%201%200%200%201%20-1.707%20.707l-6.586%20-6.586a1%201%200%200%201%200%20-1.414l6.586%20-6.586a1%201%200%200%201%201.707%20.707v3.586h8a1%201%200%200%201%201%201v4a1%201%200%200%201%20-1%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%209h8v-3.586a1%201%200%200%201%201.707%20-.707l6.586%206.586a1%201%200%200%201%200%201.414l-6.586%206.586a1%201%200%200%201%20-1.707%20-.707v-3.586h-8a1%201%200%200%201%20-1%20-1v-4a1%201%200%200%201%201%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2020v-8h-3.586a1%201%200%200%201%20-.707%20-1.707l6.586%20-6.586a1%201%200%200%201%201.414%200l6.586%206.586a1%201%200%200%201%20-.707%201.707h-3.586v8a1%201%200%200%201%20-1%201h-4a1%201%200%200%201%20-1%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204v8h3.586a1%201%200%200%201%20.707%201.707l-6.586%206.586a1%201%200%200%201%20-1.414%200l-6.586%20-6.586a1%201%200%200%201%20.707%20-1.707h3.586v-8a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-wheel-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14.5%207L17%209.5M17%209.5L14.5%2012M17%209.5H12M4.5%207L2%209.5M2%209.5L4.5%2012M2%209.5H7M7%2014.5L9.5%2017M9.5%2017L12%2014.5M9.5%2017V12M12%204.5L9.5%202M9.5%202L7%204.5M9.5%202V7%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015.1519C15.5%2014.5812%2015.7267%2014.0338%2016.1303%2013.6303C16.5338%2013.2267%2017.0812%2013%2017.6519%2013H19.8037C20.3744%2013%2020.9218%2013.2267%2021.3253%2013.6303C21.7289%2014.0338%2021.9556%2014.5812%2021.9556%2015.1519V20.5315C21.9556%2021.1022%2021.7289%2021.6496%2021.3253%2022.0531C20.9218%2022.4567%2020.3744%2022.6834%2019.8037%2022.6834H17.6519C17.0812%2022.6834%2016.5338%2022.4567%2016.1303%2022.0531C15.7267%2021.6496%2015.5%2021.1022%2015.5%2020.5315V15.1519Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.7278%2016V18.0541Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.7278%2016V18.0541M15.5%2015.1519C15.5%2014.5812%2015.7267%2014.0338%2016.1303%2013.6303C16.5338%2013.2267%2017.0812%2013%2017.6519%2013H19.8037C20.3744%2013%2020.9218%2013.2267%2021.3253%2013.6303C21.7289%2014.0338%2021.9556%2014.5812%2021.9556%2015.1519V20.5315C21.9556%2021.1022%2021.7289%2021.6496%2021.3253%2022.0531C20.9218%2022.4567%2020.3744%2022.6834%2019.8037%2022.6834H17.6519C17.0812%2022.6834%2016.5338%2022.4567%2016.1303%2022.0531C15.7267%2021.6496%2015.5%2021.1022%2015.5%2020.5315V15.1519Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-auto-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-wheel-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8.681%2020.8339V14.1905M4.80569%204.77905C4.29678%205.28797%203.89309%205.89213%203.61767%206.55706C3.34225%207.22199%203.20049%207.93465%203.20049%208.65436C3.20049%209.37407%203.34225%2010.0867%203.61767%2010.7517C3.89309%2011.4166%204.29678%2012.0208%204.80569%2012.5297C5.31461%2013.0386%205.91877%2013.4423%206.5837%2013.7177C7.24863%2013.9931%207.96129%2014.1349%208.681%2014.1349C9.40071%2014.1349%2010.1134%2013.9931%2010.7783%2013.7177C11.4432%2013.4423%2012.0474%2013.0386%2012.5563%2012.5297C13.0652%2012.0208%2013.4689%2011.4166%2013.7443%2010.7517C14.0198%2010.0867%2014.1615%209.37407%2014.1615%208.65436C14.1615%207.93465%2014.0198%207.22199%2013.7443%206.55706C13.4689%205.89213%2013.0652%205.28797%2012.5563%204.77905C12.0474%204.27014%2011.4432%203.86645%2010.7783%203.59103C10.1134%203.31561%209.40071%203.17385%208.681%203.17385C7.96129%203.17385%207.24863%203.31561%206.5837%203.59103C5.91877%203.86645%205.31461%204.27014%204.80569%204.77905Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.1824%2013.8968C15.1824%2013.3711%2015.3912%2012.867%2015.7629%2012.4953C16.1346%2012.1236%2016.6388%2011.9147%2017.1644%2011.9147H19.1465C19.6721%2011.9147%2020.1763%2012.1236%2020.548%2012.4953C20.9197%2012.867%2021.1285%2013.3711%2021.1285%2013.8968V18.8519C21.1285%2019.3775%2020.9197%2019.8817%2020.548%2020.2534C20.1763%2020.6251%2019.6721%2020.8339%2019.1465%2020.8339H17.1644C16.6388%2020.8339%2016.1346%2020.6251%2015.7629%2020.2534C15.3912%2019.8817%2015.1824%2019.3775%2015.1824%2018.8519V13.8968Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.1555%2013.8968V16.6519Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.1555%2013.8968V16.6519M15.1824%2013.8968C15.1824%2013.3711%2015.3912%2012.867%2015.7629%2012.4953C16.1346%2012.1236%2016.6388%2011.9147%2017.1644%2011.9147H19.1465C19.6721%2011.9147%2020.1763%2012.1236%2020.548%2012.4953C20.9197%2012.867%2021.1285%2013.3711%2021.1285%2013.8968V18.8519C21.1285%2019.3775%2020.9197%2019.8817%2020.548%2020.2534C20.1763%2020.6251%2019.6721%2020.8339%2019.1465%2020.8339H17.1644C16.6388%2020.8339%2016.1346%2020.6251%2015.7629%2020.2534C15.3912%2019.8817%2015.1824%2019.3775%2015.1824%2018.8519V13.8968Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5.90637%208.8085H11.4556M8.681%206.03387V11.5831%22%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%205V5.00874M8.5%205V5.00874M12%205V5.00874M15.5%205V5.00874M19%205V5.00874M5%2018.9913V19M8.5%2018.9913V19M12%2018.9913V19M19%2011.9956V12.0044M19%208.49781V8.50656M5%2015.4934V15.5022M5%2011.9956V12.0044M5%208.49781V8.50656%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M18.42%2015.6151C18.615%2015.4201%2018.8465%2015.2654%2019.1013%2015.1599C19.3561%2015.0543%2019.6292%2015%2019.905%2015C20.1808%2015%2020.4539%2015.0543%2020.7087%2015.1599C20.9635%2015.2654%2021.195%2015.4201%2021.39%2015.6151C21.585%2015.8101%2021.7397%2016.0416%2021.8452%2016.2964C21.9508%2016.5512%2022.0051%2016.8243%2022.0051%2017.1001C22.0051%2017.3759%2021.9508%2017.649%2021.8452%2017.9038C21.7397%2018.1586%2021.585%2018.3901%2021.39%2018.5851L18%2022.0051H15V19.0051L18.42%2015.6151Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-poly-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17.6568%2014.1213L17.3033%209.52513M15.182%205.98959L12%204.92893M8.818%205.98959L5.63602%2012.7071M7.05024%2014.8284L15.5355%2016.2426M18.3639%208.46447C17.9889%208.83954%2017.4802%209.05025%2016.9497%209.05025C16.4193%209.05025%2015.9106%208.83954%2015.5355%208.46447C15.1604%208.08939%2014.9497%207.58069%2014.9497%207.05025C14.9497%206.51982%2015.1604%206.01111%2015.5355%205.63604C15.9106%205.26097%2016.4193%205.05025%2016.9497%205.05025C17.4802%205.05025%2017.9889%205.26097%2018.3639%205.63604C18.739%206.01111%2018.9497%206.51982%2018.9497%207.05025C18.9497%207.58069%2018.739%208.08939%2018.3639%208.46447ZM11.2929%205.63604C10.9178%206.01111%2010.4091%206.22183%209.87866%206.22183C9.34823%206.22183%208.83952%206.01111%208.46445%205.63604C8.08938%205.26097%207.87866%204.75226%207.87866%204.22183C7.87866%203.69139%208.08938%203.18269%208.46445%202.80761C8.83952%202.43254%209.34823%202.22183%209.87866%202.22183C10.4091%202.22183%2010.9178%202.43254%2011.2929%202.80761C11.6679%203.18269%2011.8787%203.69139%2011.8787%204.22183C11.8787%204.75226%2011.6679%205.26097%2011.2929%205.63604ZM19.0711%2017.6569C18.696%2018.0319%2018.1873%2018.2426%2017.6568%2018.2426C17.1264%2018.2426%2016.6177%2018.0319%2016.2426%2017.6569C15.8676%2017.2818%2015.6568%2016.7731%2015.6568%2016.2426C15.6568%2015.7122%2015.8676%2015.2035%2016.2426%2014.8284C16.6177%2014.4534%2017.1264%2014.2426%2017.6568%2014.2426C18.1873%2014.2426%2018.696%2014.4534%2019.0711%2014.8284C19.4461%2015.2035%2019.6568%2015.7122%2019.6568%2016.2426C19.6568%2016.7731%2019.4461%2017.2818%2019.0711%2017.6569ZM6.34313%2016.2426C5.96806%2016.6177%205.45935%2016.8284%204.92892%2016.8284C4.39848%2016.8284%203.88978%2016.6177%203.5147%2016.2426C3.13963%2015.8676%202.92892%2015.3589%202.92892%2014.8284C2.92892%2014.298%203.13963%2013.7893%203.5147%2013.4142C3.88978%2013.0391%204.39848%2012.8284%204.92892%2012.8284C5.45935%2012.8284%205.96806%2013.0391%206.34313%2013.4142C6.7182%2013.7893%206.92892%2014.298%206.92892%2014.8284C6.92892%2015.3589%206.7182%2015.8676%206.34313%2016.2426Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17.4057%2012.7025C17.6284%2012.4798%2017.8928%2012.3031%2018.1838%2012.1826C18.4748%2012.062%2018.7867%2012%2019.1016%2012C19.4166%2012%2019.7285%2012.062%2020.0194%2012.1826C20.3104%2012.3031%2020.5748%2012.4798%2020.7975%2012.7025C21.0202%2012.9252%2021.1969%2013.1896%2021.3174%2013.4806C21.438%2013.7715%2021.5%2014.0834%2021.5%2014.3984C21.5%2014.7133%2021.438%2015.0252%2021.3174%2015.3162C21.1969%2015.6072%2021.0202%2015.8716%2020.7975%2016.0943L18.8618%2018.0471L16.9261%2020H13.5V16.5739L17.4057%2012.7025Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-line-edit:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2213.9036%22%20cy%3D%224.82583%22%20r%3D%222%22%20transform%3D%22rotate(47.4551%2013.9036%204.82583)%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%224.32583%22%20cy%3D%2213.616%22%20r%3D%222%22%20transform%3D%22rotate(47.4551%204.32583%2013.616)%22%20%2F%3E%0A%20%20%3Crect%20x%3D%2212.4301%22%20y%3D%226.17816%22%20width%3D%220%22%20height%3D%229%22%20transform%3D%22rotate(47.4551%2012.4301%206.17816)%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13.9404%2020.4782C13.9736%2020.6275%2014.0517%2020.7631%2014.1643%2020.8668C14.2768%2020.9705%2014.4183%2021.0373%2014.5699%2021.0582C14.7214%2021.0792%2014.8758%2021.0533%2015.0122%2020.984C15.1486%2020.9148%2015.2606%2020.8054%2015.3331%2020.6707L16.6395%2018.7373L19.7069%2021.8046C19.7688%2021.8666%2019.8424%2021.9157%2019.9233%2021.9492C20.0042%2021.9827%2020.0909%2022%2020.1785%2022C20.2661%2022%2020.3528%2021.9827%2020.4338%2021.9492C20.5147%2021.9157%2020.5882%2021.8666%2020.6502%2021.8046L21.3046%2021.1502C21.3666%2021.0882%2021.4157%2021.0147%2021.4492%2020.9338C21.4827%2020.8528%2021.5%2020.7661%2021.5%2020.6785C21.5%2020.5909%2021.4827%2020.5042%2021.4492%2020.4233C21.4157%2020.3424%2021.3666%2020.2688%2021.3046%2020.2069L18.2373%2017.1395L20.1832%2015.8331C20.3179%2015.7605%2020.4272%2015.6485%2020.4965%2015.512C20.5657%2015.3756%2020.5915%2015.2212%2020.5705%2015.0696C20.5495%2014.9181%2020.4826%2014.7765%2020.3789%2014.6641C20.2751%2014.5516%2020.1394%2014.4735%2019.9901%2014.4404L11.5%2012L13.9404%2020.4782Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-clear-selection:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%205V5.00874M8.5%205V5.00874M12%205V5.00874M15.5%205V5.00874M19%205V5.00874M5%2018.9913V19M8.5%2018.9913V19M12%2018.9913V19M19%2011.9956V12.0044M19%208.49781V8.50656M5%2015.4934V15.5022M5%2011.9956V12.0044M5%208.49781V8.50656%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%224%204%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015L21.5%2021Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M21.5%2015L15.5%2021Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15.5%2015L21.5%2021M21.5%2015L15.5%2021%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-invert-selection:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%204.5V19L8.46484%2015.5352C7.56002%2014.6303%207%2013.3807%207%2012C7%209.23858%209.23858%207%2012%207C13.3807%207%2014.6303%207.56002%2015.5352%208.46484L19.5%204.5H5Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8.46484%2015.5352C9.36967%2016.44%2010.6193%2017%2012%2017C14.7614%2017%2017%2014.7614%2017%2012C17%2010.6193%2016.44%209.36967%2015.5352%208.46484L8.46484%2015.5352Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3.99997%205.77778C3.99997%205.30628%204.18727%204.8541%204.52067%204.5207C4.85407%204.1873%205.30625%204%205.77775%204H18.2222C18.6937%204%2019.1459%204.1873%2019.4793%204.5207C19.8127%204.8541%2020%205.30628%2020%205.77778V18.2222C20%2018.6937%2019.8127%2019.1459%2019.4793%2019.4793C19.1459%2019.8127%2018.6937%2020%2018.2222%2020H5.77775C5.30625%2020%204.85407%2019.8127%204.52067%2019.4793C4.18727%2019.1459%203.99997%2018.6937%203.99997%2018.2222V5.77778Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4.29477%2019.6812L19.7451%204.23096%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-point-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%223.73807%22%20cy%3D%2217.2381%22%20r%3D%222%22%20transform%3D%22rotate(7.30509%203.73807%2017.2381)%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2219.7381%22%20cy%3D%228.23807%22%20r%3D%222%22%20transform%3D%22rotate(7.30509%2019.7381%208.23807)%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M11.3341%209.83406C11.9487%209.21945%2012.3268%208.40774%2012.4019%207.5418C12.477%206.67586%2012.2443%205.81118%2011.7447%205.09993C11.245%204.38868%2010.5106%203.87645%209.67048%203.65338C8.83039%203.43031%207.93855%203.51071%207.15191%203.88042C6.36526%204.25013%205.73423%204.88545%205.36986%205.67459C5.00549%206.46372%204.93114%207.35609%205.1599%208.19464C5.38865%209.03319%205.90585%209.76418%206.62047%2010.259C7.33509%2010.7538%208.20133%2010.9806%209.06675%2010.8997V8.30035L11.3341%209.83406Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M11.3341%209.83406C11.9382%209.22991%2012.3142%208.43497%2012.3979%207.58468C12.4817%206.7344%2012.268%205.88138%2011.7933%205.17098C11.3187%204.46057%2010.6123%203.93673%209.79474%203.68872C8.97713%203.4407%208.09882%203.48385%207.30946%203.81081C6.5201%204.13777%205.86853%204.72832%205.46577%205.48183C5.06301%206.23534%204.93398%207.1052%205.10067%207.94318C5.26735%208.78116%205.71944%209.53542%206.3799%2010.0774C7.04035%2010.6195%207.86832%2010.9157%208.72272%2010.9157%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.30866%2018.2265C9.30141%2018.3958%209.34612%2018.5633%209.4368%2018.7065C9.52748%2018.8498%209.65978%2018.9618%209.81596%2019.0277C9.97215%2019.0936%2010.1447%2019.1101%2010.3106%2019.0751C10.4765%2019.0401%2010.6276%2018.9552%2010.7439%2018.8318L12.6964%2017.1374L15.0994%2021.2995C15.1479%2021.3835%2015.2125%2021.4572%2015.2895%2021.5163C15.3664%2021.5753%2015.4543%2021.6187%2015.5481%2021.6438C15.6418%2021.6689%2015.7396%2021.6753%2015.8358%2021.6627C15.932%2021.65%2016.0248%2021.6185%2016.1088%2021.57L16.9969%2021.0572C17.0809%2021.0087%2017.1546%2020.9441%2017.2136%2020.8671C17.2727%2020.7902%2017.316%2020.7023%2017.3412%2020.6085C17.3663%2020.5148%2017.3727%2020.417%2017.36%2020.3208C17.3474%2020.2246%2017.3159%2020.1318%2017.2673%2020.0478L14.8644%2015.8857L17.3214%2015.0456C17.4864%2015.0066%2017.6355%2014.918%2017.7487%2014.7919C17.8619%2014.6657%2017.9338%2014.5079%2017.9548%2014.3396C17.9758%2014.1714%2017.9448%2014.0008%2017.866%2013.8507C17.7872%2013.7006%2017.6644%2013.5781%2017.5141%2013.4998L9.12817%208.45374L9.30866%2018.2265Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-poly-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8.41421%2010.4142C8.03914%2010.7893%207.53043%2011%207%2011C6.46957%2011%205.96086%2010.7893%205.58579%2010.4142C5.21071%2010.0391%205%209.53043%205%209C5%208.46957%205.21071%207.96086%205.58579%207.58579C5.96086%207.21071%206.46957%207%207%207C7.53043%207%208.03914%207.21071%208.41421%207.58579C8.78929%207.96086%209%208.46957%209%209C9%209.53043%208.78929%2010.0391%208.41421%2010.4142ZM8.41421%2010.4142L10%2012M15.5858%2015.5858C15.9609%2015.2107%2016.4696%2015%2017%2015C17.5304%2015%2018.0391%2015.2107%2018.4142%2015.5858C18.7893%2015.9609%2019%2016.4696%2019%2017C19%2017.5304%2018.7893%2018.0391%2018.4142%2018.4142C18.0391%2018.7893%2017.5304%2019%2017%2019C16.4696%2019%2015.9609%2018.7893%2015.5858%2018.4142C15.2107%2018.0391%2015%2017.5304%2015%2017C15%2016.4696%2015.2107%2015.9609%2015.5858%2015.5858ZM15.5858%2015.5858L13.2431%2014.3522M8.5%207.5L10.25%206L11.2679%205M15%204.5L18%206M19.5%209L18%2015M11%204C11%204.53043%2011.2107%205.03914%2011.5858%205.41421C11.9609%205.78929%2012.4696%206%2013%206C13.5304%206%2014.0391%205.78929%2014.4142%205.41421C14.7893%205.03914%2015%204.53043%2015%204C15%203.46957%2014.7893%202.96086%2014.4142%202.58579C14.0391%202.21071%2013.5304%202%2013%202C12.4696%202%2011.9609%202.21071%2011.5858%202.58579C11.2107%202.96086%2011%203.46957%2011%204ZM18%207C18%207.53043%2018.2107%208.03914%2018.5858%208.41421C18.9609%208.78929%2019.4696%209%2020%209C20.5304%209%2021.0391%208.78929%2021.4142%208.41421C21.7893%208.03914%2022%207.53043%2022%207C22%206.46957%2021.7893%205.96086%2021.4142%205.58579C21.0391%205.21071%2020.5304%205%2020%205C19.4696%205%2018.9609%205.21071%2018.5858%205.58579C18.2107%205.96086%2018%206.46957%2018%207Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.6386%2020.3576C10.6105%2020.5046%2010.5382%2020.6394%2010.4313%2020.7441C10.3244%2020.8487%2010.1881%2020.9182%2010.0406%2020.9431C9.89312%2020.9681%209.74152%2020.9474%209.60615%2020.8837C9.47077%2020.82%209.35811%2020.7165%209.28326%2020.587L7.9493%2018.7362L5.04245%2021.8246C4.98375%2021.8869%204.91335%2021.9371%204.83526%2021.9723C4.75717%2022.0074%204.67292%2022.0268%204.58732%2022.0294C4.50172%2022.032%204.41644%2022.0177%204.33637%2021.9874C4.25629%2021.957%204.18298%2021.9112%204.12062%2021.8525L3.46166%2021.2322C3.3993%2021.1735%203.34911%2021.1031%203.31395%2021.0251C3.2788%2020.947%203.25937%2020.8627%203.25678%2020.7771C3.25419%2020.6915%203.26848%2020.6062%203.29885%2020.5262C3.32921%2020.4461%203.37505%2020.3728%203.43375%2020.3104L6.3406%2017.222L4.40026%2016.0029C4.26645%2015.9359%204.15631%2015.8297%204.08462%2015.6984C4.01293%2015.5671%203.98311%2015.417%203.99917%2015.2682C4.01522%2015.1195%204.07639%2014.9792%204.17446%2014.8662C4.27253%2014.7532%204.40281%2014.6729%204.54781%2014.6361L12.7726%2012L10.6386%2020.3576Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-freehand-draw:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.5%2018C4.5%2019.6667%204.5%2022%208.5%2020C13.5%2017.5%2013.5%2020%2013.5%2021%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5.20734%2016.0852H4.20734V17.0852H5.20734V16.0852ZM8.62197%2016.0852V17.0852H9.0362L9.32909%2016.7923L8.62197%2016.0852ZM17.5854%207.12183L18.2925%207.82893L18.2925%207.82893L17.5854%207.12183ZM15.8781%203V2V3ZM14.1708%203.70719L13.4636%203.00009L13.4636%203.00009L14.1708%203.70719ZM5.20734%2012.6706L4.50023%2011.9635L4.20734%2012.2564V12.6706H5.20734ZM14.0242%203.8537C13.6337%203.46317%2013.0005%203.46317%2012.61%203.8537C12.2195%204.24422%2012.2195%204.87739%2012.61%205.26791L14.0242%203.8537ZM16.0246%208.68254C16.4151%209.07307%2017.0483%209.07307%2017.4388%208.68254C17.8294%208.29202%2017.8294%207.65885%2017.4388%207.26833L16.0246%208.68254ZM7.19493%2010.683C6.80441%2010.2924%206.17124%2010.2924%205.78072%2010.683C5.39019%2011.0735%205.39019%2011.7067%205.78072%2012.0972L7.19493%2010.683ZM13.7439%2010.9633L14.451%2011.6704L14.451%2011.6704L13.7439%2010.9633ZM5.20734%2016.0852V17.0852H8.62197V16.0852V15.0852H5.20734V16.0852ZM17.5854%207.12183L18.2925%207.82893C18.9328%207.18859%2019.2926%206.32009%2019.2926%205.41451H18.2926H17.2926C17.2926%205.78966%2017.1436%206.14945%2016.8783%206.41472L17.5854%207.12183ZM18.2926%205.41451H19.2926C19.2926%204.50893%2018.9328%203.64043%2018.2925%203.00009L17.5854%203.70719L16.8783%204.4143C17.1436%204.67957%2017.2926%205.03936%2017.2926%205.41451H18.2926ZM17.5854%203.70719L18.2925%203.00009C17.6521%202.35974%2016.7837%202%2015.8781%202L15.8781%203L15.8781%204C16.2532%204%2016.613%204.14903%2016.8783%204.4143L17.5854%203.70719ZM15.8781%203V2C14.9725%202%2014.104%202.35974%2013.4636%203.00009L14.1708%203.70719L14.8779%204.4143C15.1431%204.14903%2015.5029%204%2015.8781%204V3ZM14.1708%203.70719L13.4636%203.00009L4.50023%2011.9635L5.20734%2012.6706L5.91444%2013.3777L14.8779%204.4143L14.1708%203.70719ZM5.20734%2012.6706H4.20734V16.0852H5.20734H6.20734V12.6706H5.20734ZM13.3171%204.5608L12.61%205.26791L16.0246%208.68254L16.7317%207.97544L17.4388%207.26833L14.0242%203.8537L13.3171%204.5608ZM13.7439%2010.9633L14.451%2011.6704L18.2925%207.82893L17.5854%207.12183L16.8783%206.41472L13.0368%2010.2562L13.7439%2010.9633ZM8.62197%2016.0852L9.32909%2016.7923L10.6096%2015.5118L9.90246%2014.8047L9.19534%2014.0976L7.91485%2015.3782L8.62197%2016.0852ZM6.48782%2011.3901L5.78072%2012.0972L9.19535%2015.5118L9.90246%2014.8047L10.6096%2014.0976L7.19493%2010.683L6.48782%2011.3901ZM13.7439%2010.9633L13.0368%2010.2562L9.19536%2014.0976L9.90246%2014.8047L10.6096%2015.5118L14.451%2011.6704L13.7439%2010.9633Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-append-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-intersect-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228.08807%22%20y%3D%228.02829%22%20width%3D%227.93701%22%20height%3D%227.93702%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015L15%209M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6ZM4%2010C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H14C14.5304%208%2015.0391%208.21071%2015.4142%208.58579C15.7893%208.96086%2016%209.46957%2016%2010V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-subtract-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.26016%2019.6422V9.19123L7.92544%208.39874L8.91606%2015.9274L16.0485%2016.1751L15.5532%2019.9394L4.26016%2019.6422Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%2016V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H8M8%206C8%205.46957%208.21071%204.96086%208.58579%204.58579C8.96086%204.21071%209.46957%204%2010%204H18C18.5304%204%2019.0391%204.21071%2019.4142%204.58579C19.7893%204.96086%2020%205.46957%2020%206V14C20%2014.5304%2019.7893%2015.0391%2019.4142%2015.4142C19.0391%2015.7893%2018.5304%2016%2018%2016H10C9.46957%2016%208.96086%2015.7893%208.58579%2015.4142C8.21071%2015.0391%208%2014.5304%208%2014V6Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-xor-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15.9778%208.01522H8.10718V4.50302H19.7862V15.8436H15.9778V8.01522Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8.06036%2016.03H15.931V19.5422H4.25198V8.20167H8.06036V16.03Z%22%20fill%3D%22currentColor%22%20fill-opacity%3D%220.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%2016V18C16%2018.5304%2015.7893%2019.0391%2015.4142%2019.4142C15.0391%2019.7893%2014.5304%2020%2014%2020H6C5.46957%2020%204.96086%2019.7893%204.58579%2019.4142C4.21071%2019.0391%204%2018.5304%204%2018V10C4%209.46957%204.21071%208.96086%204.58579%208.58579C4.96086%208.21071%205.46957%208%206%208H8M16%2016H18C18.5304%2016%2019.0391%2015.7893%2019.4142%2015.4142C19.7893%2015.0391%2020%2014.5304%2020%2014V6C20%205.46957%2019.7893%204.96086%2019.4142%204.58579C19.0391%204.21071%2018.5304%204%2018%204H10C9.46957%204%208.96086%204.21071%208.58579%204.58579C8.21071%204.96086%208%205.46957%208%206V8M16%2016V14M16%2016H14M8%208H10M8%208V10M8%2014V16H10M14%208H16V10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-replace-mode:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M21%2011V8C21%207.46957%2020.7893%206.96086%2020.4142%206.58579C20.0391%206.21071%2019.5304%206%2019%206H13M13%206L16%209M13%206L16%203M3%2013V16C3%2016.5304%203.21071%2017.0391%203.58579%2017.4142C3.96086%2017.7893%204.46957%2018%205%2018H11M11%2018L8%2015M11%2018L8%2021M3%204C3%203.73478%203.10536%203.48043%203.29289%203.29289C3.48043%203.10536%203.73478%203%204%203H8C8.26522%203%208.51957%203.10536%208.70711%203.29289C8.89464%203.48043%209%203.73478%209%204V8C9%208.26522%208.89464%208.51957%208.70711%208.70711C8.51957%208.89464%208.26522%209%208%209H4C3.73478%209%203.48043%208.89464%203.29289%208.70711C3.10536%208.51957%203%208.26522%203%208V4ZM15%2016C15%2015.7348%2015.1054%2015.4804%2015.2929%2015.2929C15.4804%2015.1054%2015.7348%2015%2016%2015H20C20.2652%2015%2020.5196%2015.1054%2020.7071%2015.2929C20.8946%2015.4804%2021%2015.7348%2021%2016V20C21%2020.2652%2020.8946%2020.5196%2020.7071%2020.7071C20.5196%2020.8946%2020.2652%2021%2020%2021H16C15.7348%2021%2015.4804%2020.8946%2015.2929%2020.7071C15.1054%2020.5196%2015%2020.2652%2015%2020V16Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-toggle-mode:url("data:image/svg+xml,%3Csvg%20width%3D%2233%22%20height%3D%2232%22%20viewBox%3D%220%200%2033%2032%22%20fill%3D%22none%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%3E%0A%3Crect%20x%3D%220.5%22%20width%3D%2232%22%20height%3D%2232%22%20fill%3D%22url(%23pattern0_195_301)%22%2F%3E%0A%3Cdefs%3E%0A%3Cpattern%20id%3D%22pattern0_195_301%22%20patternContentUnits%3D%22objectBoundingBox%22%20width%3D%221%22%20height%3D%221%22%3E%0A%3Cuse%20xlink%3Ahref%3D%22%23image0_195_301%22%20transform%3D%22scale(0.03125)%22%2F%3E%0A%3C%2Fpattern%3E%0A%3Cimage%20id%3D%22image0_195_301%22%20width%3D%2232%22%20height%3D%2232%22%20preserveAspectRatio%3D%22none%22%20xlink%3Ahref%3D%22data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADP3pUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHja7ZZbsiMnDIbfWUWWgCRAYjlcq2YHWX5%2B6HYf2%2BOpiieepxyoRrRQC6EPsN34%2B8d0f6GwZ3YhqqWckkcJOWQu6Jg%2FStkt%2BbDbXfgcwvuD3l0DDJVAyvFq6bS%2F6elycIiCXrxzZO0cqI8DOZz%2B7cnROZGsiFYU%2FXSUT0fCxwCdDsqxLJ%2By6f0S6jhkv63EjsetRvRY%2Bs3J83tQZK9HKIV5CIlHK3IGIOsJTgo6abfCh7rAVNEGuUWChLzK01UyIpor1PDS6IHK1aPXevdMK%2FBpIk9JTpd8qXcUX1PZqb%2BbOdjZ40d9tsOV80%2FZX8%2Bc3eZeM1ZRQkKq07mo21J2D3YVU6ypzcFf8oonwoXumlENu7qBWvfNV9RGmRi4JgXqVGjS2LJRQ4iBh2NdJ4Uby1aaKGduYEeLmgSarJKli4Fo29iD8BUL7Wmzb27PZpi5E0yZ4IzwydvVvfvBnOsoEHm7coW4cPoXB1pplNXCDERonkmNO8G3%2BlwWVwHBuLK8jkhGYuvhokb6uglkgxYYRsjjuJD20wFShKkjgiEBAVAjiZTIK7MSIZEGQAWh4wBxBQGKkTuC5CCSwMZ4TY1PlLYpR4baQY%2FLDCQiTpyCTZYCWCFE7B8Nhj1UosQQY0xRo8UcS5IUUkwpaVqXYlHR4DRqUlXTrMXEgkVLpmaWrWTOgksz5pQ1W865FMxZ4Lng6wKDUipXqaFGV1PVajXX0rB9WmixpabNWm6lc5eO%2B6Onrt167mXQwFYaYcSRhg4beZSJrTbFzTDjTFOnzTzLRe3E%2BlN9gxqd1HiTWoZ6UYNW9eaC1nUSFzMAw68IgbguBNjQvJh5oxB4kVvMfGacisgIMi5mnRYxEAyDOE66sXN8EF3k%2FhM3p%2BGBG%2F8uObfQvUnuZ26vqPX1M9Q2seMUrqR6wekbOVlhQ0T4sVsdfy%2Fds%2BJ35bejb0ffjv5vjkYtqzdcSF8vL%2Fo10x%2BNqJZRMNcSp9aVxL7srv%2BSpw0E%2FkL9O%2B%2FuI%2BEgGveRcCDdR8JBFO4j4dh29H44e3%2BsbXLXd78YWPvnrTW7D5yOb0fvOsL%2FkOz%2BAVNjw%2BbixfXWAAABhGlDQ1BJQ0MgcHJvZmlsZQAAeJx9kT1Iw0AcxV9TtSIVRTuIOGSoThZERRy1CkWoEGqFVh1MLv0QmjQkKS6OgmvBwY%2FFqoOLs64OroIg%2BAHi7OCk6CIl%2Fi8ptIjx4Lgf7%2B497t4BQq3ENKttDNB020wl4mImuyKGXtGBIPoQRq%2FMLGNWkpLwHV%2F3CPD1Lsaz%2FM%2F9ObrVnMWAgEg8wwzTJl4nntq0Dc77xBFWlFXic%2BJRky5I%2FMh1xeM3zgWXBZ4ZMdOpOeIIsVhoYaWFWdHUiCeJo6qmU76Q8VjlvMVZK1VY4578heGcvrzEdZpDSGABi5AgQkEFGyjBRoxWnRQLKdqP%2B%2FgHXb9ELoVcG2DkmEcZGmTXD%2F4Hv7u18hPjXlI4DrS%2FOM7HMBDaBepVx%2Fk%2Bdpz6CRB8Bq70pr9cA6Y%2FSa82tegR0LMNXFw3NWUPuNwBBp4M2ZRdKUhTyOeB9zP6pizQfwt0rXq9NfZx%2BgCkqavkDXBwCIwUKHvN592drb39e6bR3w%2F9qXJ4zBnVPwAADRppVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw%2FeHBhY2tldCBiZWdpbj0i77u%2FIiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8%2BCjx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDQuNC4wLUV4aXYyIj4KIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI%2BCiAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZUV2ZW50IyIKICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgIHhtbG5zOkdJTVA9Imh0dHA6Ly93d3cuZ2ltcC5vcmcveG1wLyIKICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIgogICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIgogICB4bXBNTTpEb2N1bWVudElEPSJnaW1wOmRvY2lkOmdpbXA6MjFjNTkwNzMtOTc1Zi00ZjAxLTljMDktYzY2NWY3NTBhMDA2IgogICB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjdhODY1NGM1LTZiYTktNDkwMi1iZWNmLTAyMGE3Y2I1MTI5NCIKICAgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ4bXAuZGlkOmNmNDY3MmE2LTRjN2ItNDAwYi04N2U4LWExMjFjY2ZlZjI1YSIKICAgZGM6Rm9ybWF0PSJpbWFnZS9wbmciCiAgIEdJTVA6QVBJPSIyLjAiCiAgIEdJTVA6UGxhdGZvcm09IkxpbnV4IgogICBHSU1QOlRpbWVTdGFtcD0iMTcxNzQzODY2NDU5OTYwMiIKICAgR0lNUDpWZXJzaW9uPSIyLjEwLjMwIgogICB0aWZmOk9yaWVudGF0aW9uPSIxIgogICB4bXA6Q3JlYXRvclRvb2w9IkdJTVAgMi4xMCI%2BCiAgIDx4bXBNTTpIaXN0b3J5PgogICAgPHJkZjpTZXE%2BCiAgICAgPHJkZjpsaQogICAgICBzdEV2dDphY3Rpb249InNhdmVkIgogICAgICBzdEV2dDpjaGFuZ2VkPSIvIgogICAgICBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjAyOTk4NWE4LThlMjItNGI2NS1hNTQwLTE3MWI2NjU3YTYxOCIKICAgICAgc3RFdnQ6c29mdHdhcmVBZ2VudD0iR2ltcCAyLjEwIChMaW51eCkiCiAgICAgIHN0RXZ0OndoZW49IjIwMjQtMDYtMDNUMjA6MTc6NDQrMDI6MDAiLz4KICAgIDwvcmRmOlNlcT4KICAgPC94bXBNTTpIaXN0b3J5PgogIDwvcmRmOkRlc2NyaXB0aW9uPgogPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8%2BrdIyIAAAAAZiS0dEAP8A%2FwD%2FoL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB%2BgGAxIRLNWVUewAAAB9SURBVFjDY2AYBaNggAEjNsGFy1b%2BR%2BbHR4UzUlMcGTANymBZuGzlf3TX08o8ptFUOJoGBtrxTNS2HFd%2Bp7kDyLF80KYZkiyhieXEWkas5VTLBciVDLXinOREiGwhNRIcCzmaBiSlj9YFw7Y9wEJK8Uppm3C0RTQKRgE2AAByVIRiIg%2Bg0AAAAABJRU5ErkJggg%3D%3D%22%2F%3E%0A%3C%2Fdefs%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-in:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2210%22%20y1%3D%227%22%20x2%3D%2210%22%20y2%3D%2213%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-out:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-undo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2014L5%2010M5%2010L9%206M5%2010H16C17.0609%2010%2018.0783%2010.4214%2018.8284%2011.1716C19.5786%2011.9217%2020%2012.9391%2020%2014C20%2015.0609%2019.5786%2016.0783%2018.8284%2016.8284C18.0783%2017.5786%2017.0609%2018%2016%2018H15%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-redo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2013L19%209M19%209L15%205M19%209L8%209C6.93913%209%205.92172%209.42143%205.17157%2010.1716C4.42143%2010.9217%204%2011.9391%204%2013C4%2014.0609%204.42143%2015.0783%205.17157%2015.8284C5.92172%2016.5786%206.93913%2017%208%2017H9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-reset:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3.06006%2013.0001C3.30547%2015.1939%204.34865%2017.2211%205.9912%2018.696C7.63374%2020.1709%209.76108%2020.9907%2011.9686%2020.9995C14.1762%2021.0082%2016.3099%2020.2053%2017.9641%2018.7434C19.6183%2017.2816%2020.6775%2015.2628%2020.9403%2013.0709C21.2031%2010.879%2020.6511%208.66702%2019.3894%206.85557C18.1276%205.04412%2016.2441%203.75958%2014.0971%203.24624C11.95%202.7329%209.68922%203.02658%207.74457%204.07141C5.79993%205.11625%204.30712%206.83937%203.55006%208.91306M3%204.00098V9.00098H8M11%2012C11%2012.2652%2011.1054%2012.5196%2011.2929%2012.7071C11.4804%2012.8946%2011.7348%2013%2012%2013C12.2652%2013%2012.5196%2012.8946%2012.7071%2012.7071C12.8946%2012.5196%2013%2012.2652%2013%2012C13%2011.7348%2012.8946%2011.4804%2012.7071%2011.2929C12.5196%2011.1054%2012.2652%2011%2012%2011C11.7348%2011%2011.4804%2011.1054%2011.2929%2011.2929C11.1054%2011.4804%2011%2011.7348%2011%2012Z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hover:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2020l-3%20-3h-2a3%203%200%200%201%20-3%20-3v-6a3%203%200%200%201%203%20-3h10a3%203%200%200%201%203%203v6a3%203%200%200%201%20-3%203h-2l-3%203%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%229%22%20x2%3D%2216%22%20y2%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%2213%22%20x2%3D%2214%22%20y2%3D%2213%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-crosshair:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M20%2012h-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2020v-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%204v4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%2015%2012%209%2018%2015%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%209%2012%2015%2018%209%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%2215%206%209%2012%2015%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%229%206%2015%2012%209%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(180%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(270%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(90%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-on:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2012c-2.667%204.667%20-6%207%20-10%207s-7.333%20-2.333%20-10%20-7c2.667%20-4.667%206%20-7%2010%20-7s7.333%202.333%2010%207%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-off:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%223%22%20x2%3D%2221%22%20y2%3D%2221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.584%2010.587a2%202%200%200%200%202.828%202.83%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.363%205.365a9.466%209.466%200%200%201%202.637%20-.365c4%200%207.333%202.333%2010%207c-.778%201.361%20-1.612%202.524%20-2.503%203.488m-2.14%201.861c-1.631%201.1%20-3.415%201.651%20-5.357%201.651c-4%200%20-7.333%20-2.333%20-10%20-7c1.369%20-2.395%202.913%20-4.175%204.632%20-5.341%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-cursor-rotate:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%3E%0A%20%20%3Cg%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%224%22%20stroke%3D%22white%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%222%22%20stroke%3D%22black%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A") 12 12, auto;--bokeh-icon-x-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-down-to-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l0%20-10%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l4%20-4%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l-4%20-4%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-up-from-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%204l0%2010%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l-4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-minimize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2019v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%209h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-maximize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%208v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2016v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%204h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%2020h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-4%204l-4%201.5l-1.5%201.5l7%207l1.5%20-1.5l1.5%20-4l4%20-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unpin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203l18%2018%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-3.249%203.249m-2.57%201.433l-2.181%20.818l-1.5%201.5l7%207l1.5%20-1.5l.82%20-2.186m1.43%20-2.563l3.25%20-3.251%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hand-pointing:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%2013v-8.5a1.5%201.5%200%200%201%203%200v7.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M11%2011.5v-2a1.5%201.5%200%201%201%203%200v2.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2010.5a1.5%201.5%200%200%201%203%200v1.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M17%2011.5a1.5%201.5%200%200%201%203%200v4.5a6%206%200%200%201%20-6%206h-2h.208a6%206%200%200%201%20-5.012%20-2.7a69.74%2069.74%200%200%201%20-.196%20-.3c-.312%20-.479%20-1.407%20-2.388%20-3.286%20-5.728a1.5%201.5%200%200%201%20.536%20-2.022a1.867%201.867%200%200%201%202.28%20.28l1.47%201.47%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-trash:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%207l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M10%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%207l1%2012a2%202%200%200%200%202%202h8a2%202%200%200%200%202%20-2l1%20-12%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%207v-3a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201v3%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-bold:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M7%205h6a3.5%203.5%200%200%201%200%207h-6z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2012h1a3.5%203.5%200%200%201%200%207h-7v-7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-italic:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M11%205l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M7%2019l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14%205l-4%2014%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-center:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%2012l8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l12%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l5%205l10%20-10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l2%202l4%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-list:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%206l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%206l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2018l0%20.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-range:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M16.375%2014.625L19%2012M19%2012L16.375%209.375M19%2012H12H5M5%2012L7.625%209.375M5%2012L7.625%2014.625%22%20%2F%3E%0A%20%20%3Crect%20x%3D%222%22%20y%3D%226%22%20width%3D%220%22%20height%3D%2212%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%20%20%3Crect%20x%3D%2222%22%20y%3D%226%22%20width%3D%220%22%20height%3D%2212%22%20stroke-width%3D%223%22%20stroke-dasharray%3D%220.01%203.5%22%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-light-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2012m-4%200a4%204%200%201%200%208%200a4%204%200%201%200%20-8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h1m8%20-9v1m8%208h1m-9%208v1m-6.4%20-15.4l.7%20.7m12.1%20-.7l-.7%20.7m0%2011.4l.7%20.7m-12.1%20-.7l-.7%20.7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-dark-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%203c.132%200%20.263%200%20.393%200a7.5%207.5%200%200%200%207.92%2012.446a9%209%200%201%201%20-8.313%20-12.454z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");}'},
function _(r,e,b,o,a){o(),b.btn="bk-btn",b.active="bk-active",b.btn_default="bk-btn-default",b.btn_primary="bk-btn-primary",b.btn_success="bk-btn-success",b.btn_warning="bk-btn-warning",b.btn_danger="bk-btn-danger",b.btn_light="bk-btn-light",b.btn_group="bk-btn-group",b.vertical="bk-vertical",b.horizontal="bk-horizontal",b.dropdown_toggle="bk-dropdown-toggle",b.default=":host{--file:#fff;--file-border:#ccc;--file-hover:#f5f5f5;--file-hover-border:#b8b8b8;--file-active:#ebebeb;--file-active-border:#adadad;--file-disabled:#e6e6e6;--file-disabled-border:#ccc;--default:#fff;--default-border:#ccc;--default-hover:#f5f5f5;--default-hover-border:#b8b8b8;--default-active:#ebebeb;--default-active-border:#adadad;--default-disabled:#e6e6e6;--default-disabled-border:#ccc;--primary:#428bca;--primary-border:#357ebd;--primary-hover:#3681c1;--primary-hover-border:#2c699e;--primary-active:#3276b1;--primary-active-border:#285e8e;--primary-disabled:#506f89;--primary-disabled-border:#357ebd;--success:#5cb85c;--success-border:#4cae4c;--success-hover:#4eb24e;--success-hover-border:#409240;--success-active:#47a447;--success-active-border:#398439;--success-disabled:#667b66;--success-disabled-border:#4cae4c;--warning:#f0ad4e;--warning-border:#eea236;--warning-hover:#eea43b;--warning-hover-border:#e89014;--warning-active:#ed9c28;--warning-active-border:#d58512;--warning-disabled:#c89143;--warning-disabled-border:#eea236;--danger:#d9534f;--danger-border:#d43f3a;--danger-hover:#d5433e;--danger-hover-border:#bd2d29;--danger-active:#d2322d;--danger-active-border:#ac2925;--danger-disabled:#a55350;--danger-disabled-border:#d43f3a;--light:#fff;--light-border:#ccc;--light-hover:#f5f5f5;--light-hover-border:#b8b8b8;--light-active:#ebebeb;--light-active-border:#adadad;--light-disabled:#e6e6e6;--light-disabled-border:#ccc;}.bk-btn,::file-selector-button{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:var(--padding-vertical) var(--padding-horizontal);font-size:var(--font-size);border:var(--border-width) var(--border-style) transparent;border-radius:var(--border-radius);outline:0;outline-offset:-5px;user-select:none;-webkit-user-select:none;}.bk-btn:hover,::file-selector-button:hover,.bk-btn:focus,::file-selector-button:focus{text-decoration:none;}.bk-btn:active,::file-selector-button:active,.bk-active.bk-btn,.bk-active::file-selector-button{background-image:none;box-shadow:var(--box-shadow-inset);}.bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}::file-selector-button{color:var(--color);background-color:var(--file);border-color:var(--file-border);}::file-selector-button:hover{background-color:var(--file-hover);border-color:var(--file-hover-border);}.bk-active::file-selector-button{background-color:var(--file-active);border-color:var(--file-active-border);}::file-selector-button[disabled],::file-selector-button[disabled]:hover,::file-selector-button[disabled]:focus,::file-selector-button[disabled]:active,.bk-active::file-selector-button[disabled]{background-color:var(--file-disabled);border-color:var(--file-disabled-border);}::file-selector-button:focus,::file-selector-button:active{outline:var(--outline);}.bk-btn-default{color:var(--color);background-color:var(--default);border-color:var(--default-border);}.bk-btn-default:hover{background-color:var(--default-hover);border-color:var(--default-hover-border);}.bk-active.bk-btn-default{background-color:var(--default-active);border-color:var(--default-active-border);}.bk-btn-default[disabled],.bk-btn-default[disabled]:hover,.bk-btn-default[disabled]:focus,.bk-btn-default[disabled]:active,.bk-active.bk-btn-default[disabled]{background-color:var(--default-disabled);border-color:var(--default-disabled-border);}.bk-btn-default:focus,.bk-btn-default:active{outline:var(--outline);}.bk-btn-primary{color:var(--inverted-color);background-color:var(--primary);border-color:var(--primary-border);}.bk-btn-primary:hover{background-color:var(--primary-hover);border-color:var(--primary-hover-border);}.bk-active.bk-btn-primary{background-color:var(--primary-active);border-color:var(--primary-active-border);}.bk-btn-primary[disabled],.bk-btn-primary[disabled]:hover,.bk-btn-primary[disabled]:focus,.bk-btn-primary[disabled]:active,.bk-active.bk-btn-primary[disabled]{background-color:var(--primary-disabled);border-color:var(--primary-disabled-border);}.bk-btn-primary:focus,.bk-btn-primary:active{outline:var(--outline);}.bk-btn-success{color:var(--inverted-color);background-color:var(--success);border-color:var(--success-border);}.bk-btn-success:hover{background-color:var(--success-hover);border-color:var(--success-hover-border);}.bk-active.bk-btn-success{background-color:var(--success-active);border-color:var(--success-active-border);}.bk-btn-success[disabled],.bk-btn-success[disabled]:hover,.bk-btn-success[disabled]:focus,.bk-btn-success[disabled]:active,.bk-active.bk-btn-success[disabled]{background-color:var(--success-disabled);border-color:var(--success-disabled-border);}.bk-btn-success:focus,.bk-btn-success:active{outline:var(--outline);}.bk-btn-warning{color:var(--inverted-color);background-color:var(--warning);border-color:var(--warning-border);}.bk-btn-warning:hover{background-color:var(--warning-hover);border-color:var(--warning-hover-border);}.bk-active.bk-btn-warning{background-color:var(--warning-active);border-color:var(--warning-active-border);}.bk-btn-warning[disabled],.bk-btn-warning[disabled]:hover,.bk-btn-warning[disabled]:focus,.bk-btn-warning[disabled]:active,.bk-active.bk-btn-warning[disabled]{background-color:var(--warning-disabled);border-color:var(--warning-disabled-border);}.bk-btn-warning:focus,.bk-btn-warning:active{outline:var(--outline);}.bk-btn-danger{color:var(--inverted-color);background-color:var(--danger);border-color:var(--danger-border);}.bk-btn-danger:hover{background-color:var(--danger-hover);border-color:var(--danger-hover-border);}.bk-active.bk-btn-danger{background-color:var(--danger-active);border-color:var(--danger-active-border);}.bk-btn-danger[disabled],.bk-btn-danger[disabled]:hover,.bk-btn-danger[disabled]:focus,.bk-btn-danger[disabled]:active,.bk-active.bk-btn-danger[disabled]{background-color:var(--danger-disabled);border-color:var(--danger-disabled-border);}.bk-btn-danger:focus,.bk-btn-danger:active{outline:var(--outline);}.bk-btn-light{color:var(--color);background-color:var(--light);border-color:var(--light-border);border-color:transparent;}.bk-btn-light:hover{background-color:var(--light-hover);border-color:var(--light-hover-border);}.bk-active.bk-btn-light{background-color:var(--light-active);border-color:var(--light-active-border);}.bk-btn-light[disabled],.bk-btn-light[disabled]:hover,.bk-btn-light[disabled]:focus,.bk-btn-light[disabled]:active,.bk-active.bk-btn-light[disabled]{background-color:var(--light-disabled);border-color:var(--light-disabled-border);}.bk-btn-light:focus,.bk-btn-light:active{outline:var(--outline);}.bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-btn-group:not(.bk-vertical),.bk-btn-group.bk-horizontal{flex-direction:row;}.bk-btn-group.bk-vertical{flex-direction:column;}.bk-btn-group > .bk-btn{flex-grow:1;}.bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:var(--padding-vertical) calc(var(--padding-horizontal)/2);}"},
function _(e,r,o,t,a){t(),o.default=":host{position:fixed;left:50%;top:0.5em;transform:translate(-50%, 0);width:max-content;height:max-content;max-width:50%;}:host > .entries:empty{display:none;}.entries{display:flex;flex-direction:column;flex-wrap:nowrap;gap:0.5em;}.entries > *{padding:0.5em;border:1px solid gray;border-radius:0.5em;}.error{background-color:var(--danger);border-color:var(--danger-border);}.success{background-color:var(--success);border-color:var(--success-border);}.try{font-weight:bold;cursor:pointer;}.try:hover{text-decoration:underline;}.close{display:inline-block;vertical-align:middle;margin-left:1em;width:1em;height:1em;cursor:pointer;mask-image:var(--bokeh-icon-x);-webkit-mask-image:var(--bokeh-icon-x);mask-size:contain;-webkit-mask-size:contain;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-color:black;}.close:hover{background-color:var(--hover-color);}"},
function _(e,n,r,t,o){t(),r.decode_def=function(e,n){var r;function t(e){if((0,a.isString)(e))switch(e){case"Any":return u.Any;case"Unknown":return u.Unknown;case"Bool":return u.Bool;case"Float":return u.Float;case"Int":return u.Int;case"Bytes":return u.Bytes;case"Str":return u.Str;case"Null":return u.Null}else switch(e[0]){case"Regex":{const[,n,r]=e;return u.Regex(new RegExp(n,r))}case"Nullable":{const[,n]=e;return u.Nullable(t(n))}case"Or":{const[,n,...r]=e;return u.Or(t(n),...r.map(t))}case"Tuple":{const[,n,...r]=e;return u.Tuple(t(n),...r.map(t))}case"List":{const[,n]=e;return u.List(t(n))}case"Struct":{const[,...n]=e,r=n.map((([e,n])=>[e,t(n)]));return u.Struct((0,i.to_object)(r))}case"Dict":{const[,n]=e;return u.Dict(t(n))}case"Mapping":{const[,n,r]=e;return u.Mapping(t(n),t(r))}case"Enum":{const[,...n]=e;return u.Enum(...n)}case"Ref":{const[,r]=e,t=n.resolver.get(r.id);if(null!=t)return u.Ref(t);throw new Error(`${r.id} wasn't defined before referencing it`)}case"AnyRef":return u.AnyRef()}}const o=(()=>{const r=e.extends?.id??"Model";if("Model"==r)return c.Model;const t=n.resolver.get(r);if(null!=t)return t;throw new Error(`base model ${r} of ${e.name} is not defined`)})(),l=(r=class extends o{},s.__setFunctionName(r,"model"),r.__qualified__=e.name,r);function d(e){return void 0===e?e:n.decode(e)}for(const n of e.properties??[]){const e=t(n.kind);l.define({[n.name]:[e,d(n.default)]})}for(const n of e.overrides??[])l.override({[n.name]:d(n.default)});return n.resolver.register(l),l};const s=e(1),c=e(52),u=s.__importStar(e(22)),a=e(8),i=e(9)},
function _(e,t,s,n,a){var _,r,l,o,c,u,i,v,m,d,p,h,x,y,g,E,P,f,R,M,k,C,S,D,b,L,O,U,I,w,T;n(),s.server_event=function(e){return t=>{if($.has(e))throw new Error(`'${e}' event is already registered`);$.set(e,t),t.prototype.event_name=e,t.prototype.publish=!1}};var B=this&&this.__decorate||function(e,t,s,n){var a,_=arguments.length,r=_<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,s,n);else for(var l=e.length-1;l>=0;l--)(a=e[l])&&(r=(_<3?a(r):_>3?a(t,s,r):a(t,s))||r);return _>3&&r&&Object.defineProperty(t,s,r),r};const j=e(52),z=e(8),A=e(12),G=e(33),V=e(48),W=e(27);function q(e){return t=>{t.prototype.event_name=e}}V.Deserializer.register("event",((e,t)=>{const s=$.get(e.name);if(void 0!==s&&null!=s.from_values){const n=t.decode(e.values);return(0,A.assert)((0,z.isPlainObject)(n)),s.from_values(n)}t.error(`deserialization of '${e.name}' event is not supported`)}));const $=new Map;class F{[G.serialize](e){const{event_name:t,event_values:s}=this;return{type:"event",name:t,values:e.encode(s)}}[W.equals](e,t){return this.event_name==e.event_name&&t.eq(this.event_values,e.event_values)}}s.BokehEvent=F,_=F,F.__name__="BokehEvent",_.prototype.publish=!0;class H extends F{constructor(){super(...arguments),this.origin=null}get event_values(){return{model:this.origin}}}s.ModelEvent=H,H.__name__="ModelEvent";class J extends H{constructor(e){super(),this.values=e}get event_values(){return{...super.event_values,...this.values}}static from_values(e){const t=(()=>{if("model"in e){const{model:t}=e;return(0,A.assert)(null===t||t instanceof j.Model),delete e.model,t}return null})(),s=new this(e);return s.origin=t,s}}s.UserEvent=J,J.__name__="UserEvent";class K extends F{}s.DocumentEvent=K,K.__name__="DocumentEvent";let N=((r=class extends K{get event_values(){return{}}}).__name__="DocumentReady",r);s.DocumentReady=N,s.DocumentReady=N=B([q("document_ready")],N);class Q extends K{}s.ConnectionEvent=Q,Q.__name__="ConnectionEvent";class X extends Q{constructor(e,t,s){super(),this.timestamp=Date.now(),this.connection=e,this.attempts=t,this.timeout=s}get event_values(){const{timestamp:e,attempts:t,timeout:s}=this;return{timestamp:e,attempts:t,timeout:s}}reconnect(){this.connection.deref()?.reconnect()}}s.ConnectionLost=X,l=X,X.__name__="ConnectionLost",l.prototype.event_name="connection_lost",l.prototype.publish=!1;class Y extends Q{get event_values(){return{}}}s.ClientReconnected=Y,o=Y,Y.__name__="ClientReconnected",o.prototype.event_name="client_reconnected";let Z=((c=class extends H{constructor(e,t){super(),this.model=e,this.value=t}get event_values(){const{value:e}=this;return{...super.event_values,value:e}}}).__name__="AxisClick",c);s.AxisClick=Z,s.AxisClick=Z=B([q("axis_click")],Z);let ee=((u=class extends H{}).__name__="ButtonClick",u);s.ButtonClick=ee,s.ButtonClick=ee=B([q("button_click")],ee);let te=((i=class extends H{constructor(e,t){super(),this.model=e,this.item=t}get event_values(){const{item:e}=this;return{...super.event_values,item:e}}}).__name__="LegendItemClick",i);s.LegendItemClick=te,s.LegendItemClick=te=B([q("legend_item_click")],te);let se=((v=class extends H{constructor(e){super(),this.item=e}get event_values(){const{item:e}=this;return{...super.event_values,item:e}}}).__name__="MenuItemClick",v);s.MenuItemClick=se,s.MenuItemClick=se=B([q("menu_item_click")],se);let ne=((m=class extends H{constructor(e){super(),this.value=e}get event_values(){const{value:e}=this;return{...super.event_values,value:e}}}).__name__="ValueSubmit",m);s.ValueSubmit=ne,s.ValueSubmit=ne=B([q("value_submit")],ne);class ae extends H{}s.UIEvent=ae,ae.__name__="UIEvent";let _e=((d=class extends ae{}).__name__="LODStart",d);s.LODStart=_e,s.LODStart=_e=B([q("lodstart")],_e);let re=((p=class extends ae{}).__name__="LODEnd",p);s.LODEnd=re,s.LODEnd=re=B([q("lodend")],re);let le=((h=class extends ae{constructor(e,t,s,n){super(),this.x0=e,this.x1=t,this.y0=s,this.y1=n}get event_values(){const{x0:e,x1:t,y0:s,y1:n}=this;return{...super.event_values,x0:e,x1:t,y0:s,y1:n}}}).__name__="RangesUpdate",h);s.RangesUpdate=le,s.RangesUpdate=le=B([q("rangesupdate")],le);let oe=((x=class extends ae{constructor(e,t){super(),this.geometry=e,this.final=t}get event_values(){const{geometry:e,final:t}=this;return{...super.event_values,geometry:e,final:t}}}).__name__="SelectionGeometry",x);s.SelectionGeometry=oe,s.SelectionGeometry=oe=B([q("selectiongeometry")],oe);let ce=((y=class extends ae{}).__name__="Reset",y);s.Reset=ce,s.Reset=ce=B([q("reset")],ce);class ue extends ae{constructor(e,t,s,n,a){super(),this.sx=e,this.sy=t,this.x=s,this.y=n,this.modifiers=a}get event_values(){const{sx:e,sy:t,x:s,y:n,modifiers:a}=this;return{...super.event_values,sx:e,sy:t,x:s,y:n,modifiers:a}}}s.PointEvent=ue,ue.__name__="PointEvent";let ie=((g=class extends ue{constructor(e,t,s,n,a,_,r){super(e,t,s,n,r),this.delta_x=a,this.delta_y=_}get event_values(){const{delta_x:e,delta_y:t}=this;return{...super.event_values,delta_x:e,delta_y:t}}}).__name__="Pan",g);s.Pan=ie,s.Pan=ie=B([q("pan")],ie);let ve=((E=class extends ue{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.scale=a}get event_values(){const{scale:e}=this;return{...super.event_values,scale:e}}}).__name__="Pinch",E);s.Pinch=ve,s.Pinch=ve=B([q("pinch")],ve);let me=((P=class extends ue{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.rotation=a}get event_values(){const{rotation:e}=this;return{...super.event_values,rotation:e}}}).__name__="Rotate",P);s.Rotate=me,s.Rotate=me=B([q("rotate")],me);let de=((f=class extends ue{constructor(e,t,s,n,a,_){super(e,t,s,n,_),this.delta=a}get event_values(){const{delta:e}=this;return{...super.event_values,delta:e}}}).__name__="MouseWheel",f);s.MouseWheel=de,s.MouseWheel=de=B([q("wheel")],de);let pe=((R=class extends ue{}).__name__="MouseMove",R);s.MouseMove=pe,s.MouseMove=pe=B([q("mousemove")],pe);let he=((M=class extends ue{}).__name__="MouseEnter",M);s.MouseEnter=he,s.MouseEnter=he=B([q("mouseenter")],he);let xe=((k=class extends ue{}).__name__="MouseLeave",k);s.MouseLeave=xe,s.MouseLeave=xe=B([q("mouseleave")],xe);let ye=((C=class extends ue{}).__name__="Tap",C);s.Tap=ye,s.Tap=ye=B([q("tap")],ye);let ge=((S=class extends ue{}).__name__="DoubleTap",S);s.DoubleTap=ge,s.DoubleTap=ge=B([q("doubletap")],ge);let Ee=((D=class extends ue{}).__name__="Press",D);s.Press=Ee,s.Press=Ee=B([q("press")],Ee);let Pe=((b=class extends ue{}).__name__="PressUp",b);s.PressUp=Pe,s.PressUp=Pe=B([q("pressup")],Pe);let fe=((L=class extends ue{}).__name__="PanStart",L);s.PanStart=fe,s.PanStart=fe=B([q("panstart")],fe);let Re=((O=class extends ue{}).__name__="PanEnd",O);s.PanEnd=Re,s.PanEnd=Re=B([q("panend")],Re);let Me=((U=class extends ue{}).__name__="PinchStart",U);s.PinchStart=Me,s.PinchStart=Me=B([q("pinchstart")],Me);let ke=((I=class extends ue{}).__name__="PinchEnd",I);s.PinchEnd=ke,s.PinchEnd=ke=B([q("pinchend")],ke);let Ce=((w=class extends ue{}).__name__="RotateStart",w);s.RotateStart=Ce,s.RotateStart=Ce=B([q("rotatestart")],Ce);let Se=((T=class extends ue{}).__name__="RotateEnd",T);s.RotateEnd=Se,s.RotateEnd=Se=B([q("rotateend")],Se)},
function _(e,n,t,i,o){i(),t.add_document_standalone=async function(e,n,i=[],o=!1){(0,c.assert)(null==e.views_manager);const s=new r.ViewManager([],t.index);async function d(t){const o=await s.build_view(t);if(o instanceof l.DOMView){const a=e.all_roots.indexOf(t),r=i[a]??n;o.build(r)}return o}async function f(n){if(null!=n.default_view){const e=await d(n);t.index.add(e)}else e.notify_idle(n)}e.views_manager=s;for(const n of e.all_roots)await f(n);const{notifications:u}=e.config;null!=u&&await d(u);o&&(window.document.title=e.title());return e.on_change((e=>{e instanceof a.RootAddedEvent?f(e.model):e instanceof a.RootRemovedEvent?function(e){const n=s.get(e);n?.remove()}(e.model):o&&e instanceof a.TitleChangedEvent&&(window.document.title=e.title)})),s};const a=e(5),r=e(68),l=e(64),s=e(8),c=e(12);t.index=new Proxy(new r.ViewManager,{get(e,n){if((0,s.isString)(n)){const t=e.get_by_id(n);if(null!=t)return t}return Reflect.get(e,n)},has(e,n){if((0,s.isString)(n)){if(null!=e.get_by_id(n))return!0}return Reflect.has(e,n)},ownKeys:e=>e.roots.map((e=>e.model.id)),getOwnPropertyDescriptor(e,n){if((0,s.isString)(n)){const t=e.get_by_id(n);if(null!=t)return{configurable:!0,enumerable:!0,writable:!1,value:t}}return Reflect.getOwnPropertyDescriptor(e,n)}})},
function _(e,t,n,o,s){o(),n._get_ws_url=function(e,t){void 0===t&&function(e){if(null===e)return!1;if("IFRAME"===e.tagName.toUpperCase())return!0;return!1}(frameElement)&&void 0!==frameElement.dataset.absoluteUrl&&(t=frameElement.dataset.absoluteUrl);let n;null!=t?(n=document.createElement("a"),n.href=t):n=window.location;const o="https:"==n.protocol?"wss:":"ws:";null!=e?"/"==e&&(e=""):e=n.pathname.replace(/\/+$/,"");return`${o}//${n.host}${e}/ws`},n.add_document_from_session=async function(e,t,n,o=[],s=!1){const i=window.location.search.substring(1);let u;try{u=await function(e,t,n){const o=(0,a.parse_token)(t).session_id;c.has(e)||c.set(e,new Map);const s=c.get(e);s.has(o)||s.set(o,(0,a.pull_session)(e,t,n));return s.get(o)}(e,t,i)}catch(e){const n=(0,a.parse_token)(t).session_id;throw r.logger.error(`Failed to load Bokeh session ${n}: ${e}`),e}return(0,l.add_document_standalone)(u.document,n,o,s)};const a=e(83),r=e(20),l=e(81);const c=new Map},
function _(e,t,n,s,o){s(),n.parse_token=g,n.pull_session=function(e,t,n){return new p(e,t,n).connect()};const r=e(80),i=e(20),c=e(5),l=e(84),_=e(85),h=e(86),a=e(12);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let d=0;function g(e){let t=e.split(".")[0];const n=t.length%4;return 0!=n&&(t+="=".repeat(4-n)),JSON.parse(atob(t.replace(/_/g,"/").replace(/-/g,"+")))}let u=!1;addEventListener("beforeunload",(()=>{u=!0}));class p{get reconnection_attempts(){return 5-this._reconnection_attempts_left}constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,t=n.DEFAULT_TOKEN,s=null){this._number=d++,this.socket=null,this.session=null,this.closed_permanently=!1,this._reconnection_attempts_left=5,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new _.Receiver,this.url=e,this.token=t,this.args_string=s,this.id=g(t).session_id.split(".")[0],i.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async reconnect(){this._try_reconnect(!0)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=`${this.url}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`?${this.args_string}`),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise(((e,t)=>{(0,a.assert)(null!=this.socket),this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,t),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,t),this.socket.onerror=()=>this._on_error(t)}))}catch(e){throw i.logger.error(`websocket creation failed to url: ${this.url}`),i.logger.error(` - ${e}`),e}}close(){this.closed_permanently||(i.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed())}_try_reconnect(e=!1){this.closed_permanently?i.logger.info(`Websocket connection ${this._number} permanently disconnected, will not attempt to reconnect`):!e&&this._reconnection_attempts_left<=0?i.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to automatically reconnect`):this.socket?.readyState!==WebSocket.OPEN&&this.socket?.readyState!==WebSocket.CONNECTING&&(this._reconnection_attempts_left-=1,i.logger.debug(`Attempting to reconnect websocket ${this._number}, ${this._reconnection_attempts_left} attempts left`),this.connect().then((()=>{i.logger.info(`Reconnected websocket ${this._number}`),this._reconnection_attempts_left=5,this.session?.document.event_manager.send_event(new r.ClientReconnected)})).catch((e=>{i.logger.debug(`Could not reconnect ${this._number}, ${e}`)})))}_schedule_reconnect(e){if(null==this.session)return;const{document:t}=this.session,n=t.config.reconnect_session&&this._reconnection_attempts_left>0,s=n?e:null,o=new r.ConnectionLost(new WeakRef(this),this.reconnection_attempts,s);t.event_manager.send_event(o),n&&setTimeout((()=>this._try_reconnect()),e)}send(e){null!=this.socket?e.send(this.socket):i.logger.error("not connected so cannot send",e)}async send_with_reply(e){const t=await new Promise(((t,n)=>{this._pending_replies.set(e.msgid(),{resolve:t,reject:n}),this.send(e)}));if("ERROR"==t.msgtype())throw new Error(`Error reply ${t.content.text}`);return t}async _pull_doc_json(){const e=l.Message.create("PULL-DOC-REQ",{},{}),t=await this.send_with_reply(e);if(!("doc"in t.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return t.content.doc}async _repull_session_doc(e,t){i.logger.debug(null!=this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)i.logger.debug("Got new document after connection was already closed"),t(new Error("The connection has been closed"));else{const t=[],s=c.Document.from_json(n,t);this.session=new h.ClientSession(this,s);for(const e of t)s._trigger_on_change(e);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],i.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),i.logger.debug("Updated existing session with new pulled doc"),e(this.session)}catch(e){console.trace(e),i.logger.error(`Failed to repull session ${e}`),t(e instanceof Error?e:`${e}`)}}_on_open(e,t){i.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,t)}}_on_message(e){null==this._current_handler&&i.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(`${e}`)}const t=this._receiver.message;if(null!=t){const e=t.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(t)}}_reconnect_delay(){const e=5-this._reconnection_attempts_left;return 0==e?0:1e3*2**e}_on_close(e,t){i.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach((e=>e.reject("Disconnected"))),this._pending_replies.clear(),this.closed_permanently||u||(i.logger.debug(`Pending schedule_reconnect for ${this._number}`),this._schedule_reconnect(this._reconnect_delay())),t(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){i.logger.debug(`Websocket error on socket ${this._number}`);const t="Could not open websocket";i.logger.error(`Failed to connect to Bokeh server: ${t}`),e(new Error(t))}_close_bad_protocol(e){i.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,t,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(t,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const t=e.reqid(),n=this._pending_replies.get(t);null!=n?(this._pending_replies.delete(t),n.resolve(e)):null!=this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=p,p.__name__="ClientConnection"},
function _(e,s,t,r,n){r();const i=e(33),a=e(41),h=e(12);class f{get buffers(){return this._buffers}constructor(e,s,t){this._buffers=new Map,this.header=e,this.metadata=s,this.content=t}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new f(r,n,i)}assemble_buffer(e,s){const t=this.header.num_buffers??0;if(t<=this._buffers.size)throw new Error(`too many buffers received, expecting ${t}`);const{id:r}=JSON.parse(e);this._buffers.set(r,s)}static create(e,s,t){const r=f.create_header(e);return new f(r,s,t)}static create_header(e){return{msgid:(0,a.unique_id)(),msgtype:e}}complete(){const{num_buffers:e}=this.header;return null==e||this._buffers.size==e}send(e){(0,h.assert)(null==this.header.num_buffers);const s=[],t=JSON.stringify(this.content,((e,t)=>{if(t instanceof i.Buffer){const e={id:`${s.length}`};return s.push([e,t.buffer]),e}return t})),r=s.length;r>0&&(this.header.num_buffers=r);const n=JSON.stringify(this.header),a=JSON.stringify(this.metadata);e.send(n),e.send(a),e.send(t);for(const[t,r]of s)e.send(JSON.stringify(t)),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=f,f.__name__="Message"},
function _(t,e,s,_,r){_();const i=t(84),h=t(8),a=t(12);class n{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(t){this._current_consumer(t)}_HEADER(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT}_CONTENT(t){this._assume_text(t),this._fragments.push(t);const[e,s,_]=this._fragments;(0,a.assert)(null!=e&&null!=s&&null!=_),this._partial=i.Message.assemble(e,s,_),this._check_complete()}_BUFFER_HEADER(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(t){this._assume_binary(t),(0,a.assert)(null!=this._partial&&null!=this._buf_header),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()}_assume_text(t){if(!(0,h.isString)(t))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=n,n.__name__="Receiver"},
function _(e,n,t,s,c){s();const o=e(5),i=e(84),_=e(20);class r{constructor(e,n){this._document_listener=e=>{this._document_changed(e)},this._connection=e,this.document=n,this.document.on_change(this._document_listener,!0)}get id(){return this._connection.id}handle(e){const n=e.msgtype();switch(n){case"PATCH-DOC":this._handle_patch(e);break;case"OK":this._handle_ok(e);break;case"ERROR":this._handle_error(e);break;default:_.logger.debug(`Doing nothing with message '${n}'`)}}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=i.Message.create("SERVER-INFO-REQ",{},{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){const n=(e instanceof o.DocumentEventBatch?e.sync?e.events:[]:[e]).filter((e=>e.sync));if(0==n.length)return;const t=this.document.create_json_patch(n),s=i.Message.create("PATCH-DOC",{},t);this._connection.send(s)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers)}_handle_ok(e){_.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){_.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}t.ClientSession=r,r.__name__="ClientSession"},
function _(n,e,o,t,r){t(),o._resolve_element=function(n){const{elementid:e}=n;return null!=e?s(e):document.body},o._resolve_root_elements=function(n){const e=[];if(null!=n.root_ids&&null!=n.roots)for(const o of n.root_ids)e.push(s(n.roots[o]));return e};const i=n(61),l=n(8);function s(n){let e=(0,l.isString)(n)?document.getElementById(n):n;if(null==e)throw new Error(`Error rendering Bokeh model: could not find ${(0,l.isString)(n)?`#${n}`:n} HTML tag`);if(!(0,i.contains)(document.body,e))throw new Error(`Error rendering Bokeh model: element ${(0,l.isString)(n)?`#${n}`:n} must be under <body>`);if(e instanceof HTMLElement&&"SCRIPT"==e.tagName){const n=(0,i.div)();e.replaceWith(n),e=n}return e}},
function _(e,o,t,n,r){n(),t.embed_items_notebook=async function(e,o){if(1!=(0,l.size)(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=s.Document.from_json((0,l.values)(e)[0]);for(const e of o){null!=e.notebook_comms_target&&m(e.notebook_comms_target,t);const o=(0,a._resolve_element)(e),n=(0,a._resolve_root_elements)(e);await(0,g.add_document_standalone)(t,o,n);for(const e of n)e instanceof HTMLElement&&e.removeAttribute("id")}};const s=e(5),i=e(85),c=e(20),l=e(9),g=e(81),a=e(87);function f(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function m(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){c.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,(t=>{c.logger.info(`Registering Jupyter comms for target ${e}`);const n=new i.Receiver;t.on_msg(f.bind(o,n))}))}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){c.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,(t=>{c.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new i.Receiver;t.onMsg=f.bind(o,n)}))}catch(e){c.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){c.logger.info(`Registering Google Colab comms for target ${e}`);const t=google.colab.kernel.comms;try{t.registerTarget(e,(async t=>{c.logger.info(`Registering Google Colab comms for target ${e}`);const n=new i.Receiver;for await(const e of t.messages){const t={data:e.data},r=[];for(const o of e.buffers??[])r.push(new DataView(o));const s={content:t,buffers:r};f.bind(o)(n,s)}}))}catch(e){c.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}t.kernels={}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(84),o),a.__exportStar(t(85),o)},
function _(e,t,o,l,n){l(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",(()=>s.removeChild(t)));const l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));const n=document.createElement("pre");n.style.whiteSpace="unset",n.style.overflowX="auto",n.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(l),t.appendChild(n);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&null!=e.stack?e.stack:`${e}`),t)return;throw e}}},
function _(t,r,o,_,e){_();const s=t(1),i=t(7),m=s.__importStar(t(92));(0,i.register_models)(m);const n=s.__importStar(t(559));(0,i.register_models)(n)},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(93),r),e.__exportStar(t(278),r),e.__exportStar(t(352),r),e.__exportStar(t(362),r),e.__exportStar(t(363),r),e.__exportStar(t(367),r),e.__exportStar(t(368),r),e.__exportStar(t(377),r),e.__exportStar(t(256),r),e.__exportStar(t(386),r),e.__exportStar(t(428),r),e.__exportStar(t(429),r),e.__exportStar(t(433),r),e.__exportStar(t(434),r),e.__exportStar(t(284),r),e.__exportStar(t(453),r),e.__exportStar(t(455),r),e.__exportStar(t(456),r),e.__exportStar(t(465),r),e.__exportStar(t(471),r),e.__exportStar(t(472),r),e.__exportStar(t(271),r),e.__exportStar(t(474),r),e.__exportStar(t(269),r),e.__exportStar(t(477),r),e.__exportStar(t(478),r),e.__exportStar(t(483),r),e.__exportStar(t(213),r),e.__exportStar(t(488),r),e.__exportStar(t(497),r),e.__exportStar(t(501),r),e.__exportStar(t(512),r)},
function _(e,a,o,r,n){r();const t=e(1);n("AreaVisuals",e(94).AreaVisuals),n("Annotation",e(96).Annotation),n("Arrow",e(140).Arrow),n("ArrowHead",e(182).ArrowHead),n("OpenHead",e(182).OpenHead),n("NormalHead",e(182).NormalHead),n("TeeHead",e(182).TeeHead),n("VeeHead",e(182).VeeHead),n("BaseColorBar",e(184).BaseColorBar),n("Band",e(273).Band);var l=e(275);n("BoxAnnotation",l.BoxAnnotation),n("BoxInteractionHandles",l.BoxInteractionHandles),n("ColorBar",e(277).ColorBar),n("ContourColorBar",e(294).ContourColorBar),n("Label",e(295).Label),n("LabelSet",e(296).LabelSet),n("Legend",e(297).Legend),n("LegendItem",e(298).LegendItem),n("PolyAnnotation",e(300).PolyAnnotation),n("ScaleBar",e(301).ScaleBar);var i=e(302);n("Metric",i.Metric),n("ReciprocalMetric",i.ReciprocalMetric),n("MetricLength",i.MetricLength),n("ReciprocalMetricLength",i.ReciprocalMetricLength),n("ImperialLength",i.ImperialLength),n("Angular",i.Angular),n("SizeBar",e(303).SizeBar),n("Slope",e(344).Slope),n("Span",e(345).Span),n("TextAnnotation",e(186).TextAnnotation),n("Title",e(185).Title),n("ToolbarPanel",e(334).ToolbarPanel),n("Whisker",e(346).Whisker),t.__exportStar(e(347),o)},
function _(e,r,n,s,o){var a;s();const i=e(1),l=e(52),t=i.__importStar(e(95));class _ extends l.Model{constructor(e){super(e)}clone(e){return super.clone(e)}}n.AreaVisuals=_,a=_,_.__name__="AreaVisuals",a.mixins([t.Line,t.Fill,t.Hatch,["hover_",t.Line],["hover_",t.Fill],["hover_",t.Hatch]])},
function _(l,e,a,t,o){t(),a.attrs_of=function(l,e,a,t=!1){const o={};for(const c of(0,i.keys)(a)){const a=`${e}${c}`,r=l[a];o[(0,h.isString)(t)?`${t}${c}`:t?a:c]=r}return o};const c=l(1),r=c.__importStar(l(19)),n=l(21),_=c.__importStar(l(22)),i=l(9),h=l(8);a.Line={line_color:[_.Nullable(_.Color),"black"],line_alpha:[_.Alpha,1],line_width:[_.Float,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[_.Or(n.LineDash,_.Array(_.Float)),[]],line_dash_offset:[_.Float,0]},a.Fill={fill_color:[_.Nullable(_.Color),"gray"],fill_alpha:[_.Alpha,1]},a.Image={global_alpha:[_.Alpha,1]},a.Hatch={hatch_color:[_.Nullable(_.Color),"black"],hatch_alpha:[_.Alpha,1],hatch_scale:[_.Float,12],hatch_pattern:[_.Nullable(_.Or(n.HatchPatternType,_.Str)),null],hatch_weight:[_.Float,1],hatch_extra:[_.Dict(_.AnyRef()),{}]},a.Text={text_color:[_.Nullable(_.Color),"#444444"],text_outline_color:[_.Nullable(_.Color),null],text_alpha:[_.Alpha,1],text_font:[r.Font,"helvetica"],text_font_size:[_.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[_.Float,1.2]},a.LineScalar={line_color:[r.ColorScalar,"black"],line_alpha:[r.NumberScalar,1],line_width:[r.NumberScalar,1],line_join:[r.LineJoinScalar,"bevel"],line_cap:[r.LineCapScalar,"butt"],line_dash:[r.LineDashScalar,[]],line_dash_offset:[r.NumberScalar,0]},a.FillScalar={fill_color:[r.ColorScalar,"gray"],fill_alpha:[r.NumberScalar,1]},a.ImageScalar={global_alpha:[r.NumberScalar,1]},a.HatchScalar={hatch_color:[r.ColorScalar,"black"],hatch_alpha:[r.NumberScalar,1],hatch_scale:[r.NumberScalar,12],hatch_pattern:[r.NullStringScalar,null],hatch_weight:[r.NumberScalar,1],hatch_extra:[r.DictScalar,{}]},a.TextScalar={text_color:[r.ColorScalar,"#444444"],text_outline_color:[r.ColorScalar,null],text_alpha:[r.NumberScalar,1],text_font:[r.FontScalar,"helvetica"],text_font_size:[r.FontSizeScalar,"16px"],text_font_style:[r.FontStyleScalar,"normal"],text_align:[r.TextAlignScalar,"left"],text_baseline:[r.TextBaselineScalar,"bottom"],text_line_height:[r.NumberScalar,1.2]},a.LineVector={line_color:[r.ColorSpec,"black"],line_alpha:[r.NumberSpec,1],line_width:[r.NumberSpec,1],line_join:[r.LineJoinSpec,"bevel"],line_cap:[r.LineCapSpec,"butt"],line_dash:[r.LineDashSpec,[]],line_dash_offset:[r.NumberSpec,0]},a.FillVector={fill_color:[r.ColorSpec,"gray"],fill_alpha:[r.NumberSpec,1]},a.ImageVector={global_alpha:[r.NumberSpec,1]},a.HatchVector={hatch_color:[r.ColorSpec,"black"],hatch_alpha:[r.NumberSpec,1],hatch_scale:[r.NumberSpec,12],hatch_pattern:[r.NullStringSpec,null],hatch_weight:[r.NumberSpec,1],hatch_extra:[r.DictScalar,{}]},a.TextVector={text_color:[r.ColorSpec,"#444444"],text_outline_color:[r.ColorSpec,null],text_alpha:[r.NumberSpec,1],text_font:[r.FontSpec,"helvetica"],text_font_size:[r.FontSizeSpec,"16px"],text_font_style:[r.FontStyleSpec,"normal"],text_align:[r.TextAlignSpec,"left"],text_baseline:[r.TextBaselineSpec,"bottom"],text_line_height:[r.NumberSpec,1.2]}},
function _(t,e,n,i,o){var s;i();const r=t(97);class l extends r.CompositeRendererView{get bbox(){return super.bbox??this.layout?.bbox}get_size(){if(this.displayed){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,(()=>{null!=this.layout&&(this.layout.visible=this.model.visible,this.plot_view.request_layout())}))}get needs_clip(){return null==this.layout}}n.AnnotationView=l,l.__name__="AnnotationView";class h extends r.CompositeRenderer{constructor(t){super(t)}}n.Annotation=h,s=h,h.__name__="Annotation",s.override({level:"annotation"})},
function _(e,t,r,s,i){var n;s();const _=e(98),d=e(55),o=e(130),a=e(69),l=e(22),h=e(131);r.ElementLike=(0,l.Or)((0,l.Ref)(d.UIElement),(0,l.Ref)(o.DOMNode));class m extends _.RendererView{constructor(){super(...arguments),this._renderer_views=new Map,this._element_views=new Map,this._computed_renderers=[],this._computed_elements=[]}get renderer_views(){return this.computed_renderer_views}get element_views(){return this.computed_element_views}*children(){yield*super.children(),yield*this.renderer_views,yield*this.element_views}async lazy_initialize(){await super.lazy_initialize(),await this._build_renderers(),await this._build_elements()}get computed_renderers(){return[...this.model.renderers,...this._computed_renderers]}get computed_renderer_views(){return this.computed_renderers.map((e=>this._renderer_views.get(e))).filter((e=>null!=e))}async _build_renderers(){return await(0,a.build_views)(this._renderer_views,this.computed_renderers,{parent:this.plot_view})}get computed_elements(){return[...this.model.elements,...this._computed_elements]}get computed_element_views(){return this.computed_elements.map((e=>this._element_views.get(e))).filter((e=>null!=e))}async _build_elements(){return await(0,a.build_views)(this._element_views,this.computed_elements,{parent:e=>e instanceof h.LayoutDOM?null:this.plot_view})}async _update_renderers(){await this._build_renderers()}async _update_elements(){const{created:e}=await this._build_elements(),t=new Set(e);for(const e of this.element_views){const r=t.has(e),s=e.rendering_target()??this.self_target;r?e.render_to(s):s.append(e.el)}this.r_after_render()}render(){super.render();for(const e of this.element_views){const t=e.rendering_target()??this.self_target;e.render_to(t)}}remove(){(0,a.remove_views)(this._renderer_views),(0,a.remove_views)(this._element_views),super.remove()}connect_signals(){super.connect_signals();const{renderers:e,elements:t}=this.model.properties;this.on_change(e,(async()=>{await this._update_renderers()})),this.on_change(t,(async()=>{await this._update_elements()}))}paint(e){if(super.paint(e),this.displayed&&this.is_renderable)for(const t of this.computed_renderer_views)t.paint(e);const{displayed:t}=this;for(const e of this.element_views)e.reposition(t)}has_finished(){if(!super.has_finished())return!1;for(const e of this.renderer_views)if(!e.has_finished())return!1;for(const e of this.element_views)if(!e.has_finished())return!1;return!0}}r.CompositeRendererView=m,m.__name__="CompositeRendererView";class u extends _.Renderer{constructor(e){super(e)}}r.CompositeRenderer=u,n=u,u.__name__="CompositeRenderer",n.define((({List:e,Ref:t})=>({renderers:[e(t(_.Renderer)),[]],elements:[e(r.ElementLike),[]]})))},
function _(e,t,n,i,s){var r;i();const o=e(1),l=e(56),a=e(69),_=o.__importStar(e(99)),u=e(21),h=e(8),p=e(12),d=e(107),c=e(122),m=e(129),g=e(61);class v extends l.StyledElementView{constructor(){super(...arguments),this._panel=null,this.position=new g.InlineStyleSheet("","position"),this._context_menu=null,this._custom_coordinates=null}get panel(){return this._panel}set panel(e){this._panel=e}computed_stylesheets(){return[...super.computed_stylesheets(),this.position]}rendering_target(){return this.plot_view.canvas_view.underlays_el}get context_menu(){return this._context_menu}get coordinates(){const{_coordinates:e}=this;return null!=e?e:this._coordinates=this._initialize_coordinates()}set coordinates(e){this._custom_coordinates=e}initialize(){super.initialize(),this.visuals=new _.Visuals(this)}async lazy_initialize(){await super.lazy_initialize();const{context_menu:e}=this.model;null!=e&&(this._context_menu=await(0,a.build_view)(e,{parent:this.plot_view}))}remove(){this._context_menu?.remove(),super.remove()}connect_signals(){super.connect_signals();const{group:e}=this.model;null!=e&&this.on_change(e.properties.visible,(()=>{this.model.visible=e.visible}));const{x_range_name:t,y_range_name:n}=this.model.properties;this.on_change([t,n],(()=>delete this._coordinates)),this.connect(this.plot_view.frame.model.change,(()=>delete this._coordinates))}_initialize_coordinates(){if(null!=this._custom_coordinates)return this._custom_coordinates;const{coordinates:e}=this.model,{frame:t}=this.plot_view;if(null!=e)return e.get_transform(t);{const{x_range_name:e,y_range_name:n}=this.model,i=t.x_scales.get(e),s=t.y_scales.get(n);return(0,p.assert)(null!=i,`missing '${e}' range`),(0,p.assert)(null!=s,`missing '${n}' range`),new d.CoordinateTransform(i,s)}}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:t}=this.canvas;return"overlay"==this.model.level?e:t}get canvas(){return this.plot_view.canvas_view}request_paint(){this.plot_view.request_paint(this)}request_layout(){this.plot_view.request_layout()}notify_finished(){this.plot_view.notify_finished()}notify_finished_after_paint(){this.plot_view.notify_finished_after_paint()}get needs_clip(){return!1}get has_webgl(){return!1}get displayed(){return this.model.visible}get is_renderable(){return!0}get is_dual_renderer(){return!1}paint(e){this.update_geometry(),this.compute_geometry(),this.update_position(),this.displayed&&this.is_renderable&&this._paint(e),this.mark_finished()}renderer_view(e){}update_geometry(){}compute_geometry(){}update_position(){const{bbox:e,position:t}=this;null!=e&&e.is_valid?null!=this.panel?t.replace(`\n        :host {\n          position: relative;\n          width:    ${e.width}px;\n          height:   ${e.height}px;\n        }\n        `):t.replace(`\n        :host {\n          position: absolute;\n          left:     ${e.left}px;\n          top:      ${e.top}px;\n          width:    ${e.width}px;\n          height:   ${e.height}px;\n        }\n        `):t.replace("\n      :host {\n        display: none;\n      }\n      ")}resolve_frame(){return this.plot_view.frame}resolve_canvas(){return this.plot_view.canvas}resolve_plot(){return this.plot_view}resolve_symbol(e){const{bbox:t}=this;if(null==t)return{x:NaN,y:NaN};{const n=t.resolve(e.symbol),{offset:i}=e;if((0,h.isNumber)(n))return n+i;{const{x:e,y:t}=n;return{x:e+i,y:t+i}}}}get attribution(){return null}}n.RendererView=v,v.__name__="RendererView";class y extends l.StyledElement{constructor(e){super(e)}}n.Renderer=y,r=y,y.__name__="Renderer",r.define((({Bool:e,Str:t,Ref:n,Nullable:i})=>({group:[i(n(m.RendererGroup)),null],level:[u.RenderLevel,"image"],visible:[e,!0],x_range_name:[t,"default"],y_range_name:[t,"default"],coordinates:[i(n(d.CoordinateMapping)),null],propagate_hover:[e,!1],context_menu:[i(n(c.Menu)),null]})))},
function _(e,a,r,t,c){t();const n=e(1),l=e(100);c("Line",l.Line),c("LineScalar",l.LineScalar),c("LineVector",l.LineVector);const s=e(102);c("Fill",s.Fill),c("FillScalar",s.FillScalar),c("FillVector",s.FillVector);const i=e(103);c("Text",i.Text),c("TextScalar",i.TextScalar),c("TextVector",i.TextVector);const o=e(104);c("Hatch",o.Hatch),c("HatchScalar",o.HatchScalar),c("HatchVector",o.HatchVector);const u=e(106);c("Image",u.Image),c("ImageScalar",u.ImageScalar),c("ImageVector",u.ImageVector);const V=n.__importStar(e(95)),S=e(101);c("VisualProperties",S.VisualProperties),c("VisualUniforms",S.VisualUniforms);class m{*[Symbol.iterator](){yield*this._visuals}constructor(e){this._visuals=[];for(const[a,r]of e.model._mixins){const t=(()=>{switch(r){case V.Line:return new l.Line(e,a);case V.LineScalar:return new l.LineScalar(e,a);case V.LineVector:return new l.LineVector(e,a);case V.Fill:return new s.Fill(e,a);case V.FillScalar:return new s.FillScalar(e,a);case V.FillVector:return new s.FillVector(e,a);case V.Text:return new i.Text(e,a);case V.TextScalar:return new i.TextScalar(e,a);case V.TextVector:return new i.TextVector(e,a);case V.Hatch:return new o.Hatch(e,a);case V.HatchScalar:return new o.HatchScalar(e,a);case V.HatchVector:return new o.HatchVector(e,a);case V.Image:return new u.Image(e,a);case V.ImageScalar:return new u.ImageScalar(e,a);case V.ImageVector:return new u.ImageVector(e,a);default:throw new Error("unknown visual")}})();t instanceof S.VisualProperties&&t.update(),this._visuals.push(t),Object.defineProperty(this,a+t.type,{get:()=>t,configurable:!1,enumerable:!0})}}}r.Visuals=m,m.__name__="Visuals"},
function _(e,t,i,s,l){s(),i.resolve_line_dash=c;const n=e(1),a=e(101),_=n.__importStar(e(95)),h=e(21),o=e(23),r=e(8);function c(e){if((0,r.isArray)(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(r.isInteger)}}class u extends a.VisualProperties{get doit(){const e=this.get_line_color(),t=this.get_line_alpha(),i=this.get_line_width();return!(null==e||0==t||0==i)}apply(e,t){const{doit:i}=this;return i&&(this.set_value(e),null!=t?e.stroke(t):e.stroke()),i}values(){return{color:this.get_line_color(),alpha:this.get_line_alpha(),width:this.get_line_width(),join:this.get_line_join(),cap:this.get_line_cap(),dash:this.get_line_dash(),offset:this.get_line_dash_offset()}}computed_values(){const e=this.get_line_color(),t=this.get_line_alpha();return{color:(0,o.color2css)(e,t),width:this.get_line_width(),join:this.get_line_join(),cap:this.get_line_cap(),dash:this.get_line_dash(),offset:this.get_line_dash_offset()}}set_value(e){const{color:t,width:i,join:s,cap:l,dash:n,offset:a}=this.computed_values();e.strokeStyle=t,e.lineWidth=i,e.lineJoin=s,e.lineCap=l,e.setLineDash(c(n)),e.lineDashOffset=a}get_line_color(){const e=this._get_css_value("line-color");return""!=e?e:this.line_color.get_value()}get_line_alpha(){const e=this._get_css_value("line-alpha");if(""!=e){const t=Number(e);if(isFinite(t))return t}return this.line_alpha.get_value()}get_line_width(){const e=this._get_css_value("line-width");if(""!=e){const t=Number(e);if(isFinite(t))return t}return this.line_width.get_value()}get_line_join(){const e=this._get_css_value("line-join");return h.LineJoin.valid(e)?e:this.line_join.get_value()}get_line_cap(){const e=this._get_css_value("line-cap");return h.LineCap.valid(e)?e:this.line_cap.get_value()}get_line_dash(){const e=this._get_css_value("line-dash");return h.LineDash.valid(e)?e:this.line_dash.get_value()}get_line_dash_offset(){const e=this._get_css_value("line-dash-offset");if(""!=e){const t=Number(e);if(isFinite(t))return t}return this.line_dash_offset.get_value()}}i.Line=u,u.__name__="Line";class d extends a.VisualUniforms{get doit(){const e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)}apply(e,t){const{doit:i}=this;return i&&(this.set_value(e),null!=t?e.stroke(t):e.stroke()),i}values(){return{color:this.line_color.value,alpha:this.line_alpha.value,width:this.line_width.value,join:this.line_join.value,cap:this.line_cap.value,dash:this.line_dash.value,offset:this.line_dash_offset.value}}set_value(e){const t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.setLineDash(c(this.line_dash.value)),e.lineDashOffset=this.line_dash_offset.value}}i.LineScalar=d,d.__name__="LineScalar";class p extends a.VisualUniforms{get doit(){const{line_color:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{line_alpha:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{line_width:i}=this;return!i.is_Scalar()||0!=i.value}v_doit(e){return 0!=this.line_color.get(e)&&(0!=this.line_alpha.get(e)&&0!=this.line_width.get(e))}apply(e,t,i){const s=this.v_doit(t);return s&&(this.set_vectorize(e,t),null!=i?e.stroke(i):e.stroke()),s}values(e){return{color:this.line_color.get(e),alpha:this.line_alpha.get(e),width:this.line_width.get(e),join:this.line_join.get(e),cap:this.line_cap.get(e),dash:this.line_dash.get(e),offset:this.line_dash_offset.get(e)}}set_vectorize(e,t){const i=this.line_color.get(t),s=this.line_alpha.get(t),l=this.line_width.get(t),n=this.line_join.get(t),a=this.line_cap.get(t),_=this.line_dash.get(t),h=this.line_dash_offset.get(t);e.strokeStyle=(0,o.color2css)(i,s),e.lineWidth=l,e.lineJoin=n,e.lineCap=a,e.setLineDash(c(_)),e.lineDashOffset=h}}i.LineVector=p,p.__name__="LineVector",u.prototype.type="line",u.prototype.attrs=Object.keys(_.Line),d.prototype.type="line",d.prototype.attrs=Object.keys(_.LineScalar),p.prototype.type="line",p.prototype.attrs=Object.keys(_.LineVector)},
function _(t,s,e,i,o){i();class r{*[Symbol.iterator](){yield*this._props}constructor(t,s=""){this.obj=t,this.prefix=s,this.css_prefix=`--bk-${s.replaceAll("_","-")}`;const e=this;this._props=[];for(const i of this.attrs){const o=t.model.properties[s+i];o.change.connect((()=>this.update())),e[i]=o,this._props.push(o)}}update(){}_get_css_value(t){return getComputedStyle(this.obj.el).getPropertyValue(`${this.css_prefix}${t}`)}}e.VisualProperties=r,r.__name__="VisualProperties";class p{*[Symbol.iterator](){for(const t of this.attrs)yield this.obj.model.properties[this.prefix+t]}constructor(t,s=""){this.obj=t,this.prefix=s;for(const e of this.attrs)Object.defineProperty(this,e,{get:()=>t[s+e]})}update(){}}e.VisualUniforms=p,p.__name__="VisualUniforms"},
function _(l,t,e,i,o){i();const s=l(1),a=l(101),r=s.__importStar(l(95)),_=l(23);class c extends a.VisualProperties{get doit(){const l=this.get_fill_color(),t=this.get_fill_alpha();return!(null==l||0==t)}apply(l,t,e="nonzero"){const{doit:i}=this;if(i)if(this.set_value(l),t instanceof Path2D){const i=t;l.fill(i,e)}else l.fill(t??e);return i}values(){return{color:this.get_fill_color(),alpha:this.get_fill_alpha()}}computed_values(){const l=this.get_fill_color(),t=this.get_fill_alpha();return{color:(0,_.color2css)(l,t)}}set_value(l){const{color:t}=this.computed_values();l.fillStyle=t}get_fill_color(){const l=this._get_css_value("fill-color");return""!=l?l:this.fill_color.get_value()}get_fill_alpha(){const l=this._get_css_value("fill-alpha");if(""!=l){const t=Number(l);if(isFinite(t))return t}return this.fill_alpha.get_value()}}e.Fill=c,c.__name__="Fill";class n extends a.VisualUniforms{get doit(){const l=this.fill_color.value,t=this.fill_alpha.value;return!(0==l||0==t)}apply(l,t,e="nonzero"){const{doit:i}=this;if(i)if(this.set_value(l),t instanceof Path2D){const i=t;l.fill(i,e)}else l.fill(t??e);return i}values(){return{color:this.fill_color.value,alpha:this.fill_alpha.value}}set_value(l){const t=this.fill_color.value,e=this.fill_alpha.value;l.fillStyle=(0,_.color2css)(t,e)}}e.FillScalar=n,n.__name__="FillScalar";class f extends a.VisualUniforms{get doit(){const{fill_color:l}=this;if(l.is_Scalar()&&0==l.value)return!1;const{fill_alpha:t}=this;return!t.is_Scalar()||0!=t.value}v_doit(l){return 0!=this.fill_color.get(l)&&0!=this.fill_alpha.get(l)}apply(l,t,e,i="nonzero"){const o=this.v_doit(t);if(o)if(this.set_vectorize(l,t),e instanceof Path2D){const t=e;l.fill(t,i)}else l.fill(e??i);return o}values(l){return{color:this.fill_color.get(l),alpha:this.fill_alpha.get(l)}}set_vectorize(l,t){const e=this.fill_color.get(t),i=this.fill_alpha.get(t);l.fillStyle=(0,_.color2css)(e,i)}}e.FillVector=f,f.__name__="FillVector",c.prototype.type="fill",c.prototype.attrs=Object.keys(r.Fill),n.prototype.type="fill",n.prototype.attrs=Object.keys(r.FillScalar),f.prototype.type="fill",f.prototype.attrs=Object.keys(r.FillVector)},
function _(t,e,s,_,i){_();const l=t(1),o=t(101),n=l.__importStar(t(95)),a=t(21),h=t(23),r=new Map;function x(t,e){const s=r.get(t);if(null==s){const s=new WeakSet([e]);r.set(t,s)}else{if(s.has(e))return;s.add(e)}const{fonts:_}=document;_.check(t)||_.load(t).then((()=>e.request_paint()))}class u extends o.VisualProperties{get doit(){const t=this.get_text_color(),e=this.get_text_alpha();return!(null==t||0==e)}update(){if(!this.doit)return;x(this.font_value(),this.obj)}values(){return{color:this.get_text_color(),outline_color:this.get_text_outline_color(),alpha:this.get_text_alpha(),font:this.get_text_font(),font_size:this.get_text_font_size(),font_style:this.get_text_font_style(),align:this.get_text_align(),baseline:this.get_text_baseline(),line_height:this.get_text_line_height()}}computed_values(){const t=this.get_text_color(),e=this.get_text_outline_color(),s=this.get_text_alpha();return{color:(0,h.color2css)(t,s),outline_color:(0,h.color2css)(e,s),font:this.font_value(),text_align:this.get_text_align(),text_baseline:this.get_text_baseline(),line_height:this.get_text_line_height()}}set_value(t){const{color:e,outline_color:s,font:_,text_align:i,text_baseline:l}=this.computed_values();t.fillStyle=e,t.strokeStyle=s,t.font=_,t.textAlign=i,t.textBaseline=l}font_value(){return`${this.get_text_font_style()} ${this.get_text_font_size()} ${this.get_text_font()}`}get_text_color(){const t=this._get_css_value("text-color");return""!=t?t:this.text_color.get_value()}get_text_outline_color(){const t=this._get_css_value("text-outline-color");return""!=t?t:this.text_outline_color.get_value()}get_text_alpha(){const t=this._get_css_value("text-alpha");if(""!=t){const e=Number(t);if(isFinite(e))return e}return this.text_alpha.get_value()}get_text_font(){const t=this._get_css_value("text-font");return""!=t?t:this.text_font.get_value()}get_text_font_size(){const t=this._get_css_value("text-font-size");return""!=t?t:this.text_font_size.get_value()}get_text_font_style(){const t=this._get_css_value("text-font-style");return a.FontStyle.valid(t)?t:this.text_font_style.get_value()}get_text_align(){const t=this._get_css_value("text-align");return a.TextAlign.valid(t)?t:this.text_align.get_value()}get_text_baseline(){const t=this._get_css_value("text-baseline");return a.TextBaseline.valid(t)?t:this.text_baseline.get_value()}get_text_line_height(){const t=this._get_css_value("line-height");if(""!=t){const e=Number(t);if(isFinite(e))return e}return this.text_line_height.get_value()}}s.Text=u,u.__name__="Text";class c extends o.VisualUniforms{get doit(){const t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)}update(){if(!this.doit)return;x(this.font_value(),this.obj)}values(){return{color:this.text_color.value,outline_color:this.text_outline_color.value,alpha:this.text_alpha.value,font:this.text_font.value,font_size:this.text_font_size.value,font_style:this.text_font_style.value,align:this.text_align.value,baseline:this.text_baseline.value,line_height:this.text_line_height.value}}set_value(t){const e=this.text_color.value,s=this.text_alpha.value,_=this.text_outline_color.value,i=this.font_value(),l=this.text_align.value,o=this.text_baseline.value;t.fillStyle=(0,h.color2css)(e,s),t.strokeStyle=(0,h.color2css)(_,s),t.font=i,t.textAlign=l,t.textBaseline=o}font_value(){return`${this.text_font_style.value} ${this.text_font_size.value} ${this.text_font.value}`}}s.TextScalar=c,c.__name__="TextScalar";class g extends o.VisualUniforms{_assert_font(t){x(this.font_value(t),this.obj)}values(t){return this._assert_font(t),{color:this.text_color.get(t),outline_color:this.text_outline_color.get(t),alpha:this.text_alpha.get(t),font:this.text_font.get(t),font_size:this.text_font_size.get(t),font_style:this.text_font_style.get(t),align:this.text_align.get(t),baseline:this.text_baseline.get(t),line_height:this.text_line_height.get(t)}}get doit(){const{text_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{text_alpha:e}=this;return!e.is_Scalar()||0!=e.value}v_doit(t){return 0!=this.text_color.get(t)&&0!=this.text_alpha.get(t)}apply(t,e){const s=this.v_doit(e);return s&&this.set_vectorize(t,e),s}set_vectorize(t,e){this._assert_font(e);const s=this.text_color.get(e),_=this.text_outline_color.get(e),i=this.text_alpha.get(e),l=this.font_value(e),o=this.text_align.get(e),n=this.text_baseline.get(e);t.fillStyle=(0,h.color2css)(s,i),t.strokeStyle=(0,h.color2css)(_,i),t.font=l,t.textAlign=o,t.textBaseline=n}font_value(t){return`${this.text_font_style.get(t)} ${this.text_font_size.get(t)} ${this.text_font.get(t)}`}}s.TextVector=g,g.__name__="TextVector",u.prototype.type="text",u.prototype.attrs=Object.keys(n.Text),c.prototype.type="text",c.prototype.attrs=Object.keys(n.TextScalar),g.prototype.type="text",g.prototype.attrs=Object.keys(n.TextVector)},
function _(t,e,a,h,i){h();const r=t(1),s=t(101),c=t(105),n=r.__importStar(t(19)),_=r.__importStar(t(95)),o=t(9);class l extends s.VisualProperties{constructor(){super(...arguments),this._update_iteration=0}update(){if(this._update_iteration++,this._hatch_image=null,!this.doit)return;const t=this.get_hatch_color(),e=this.get_hatch_alpha(),a=this.get_hatch_scale(),h=this.get_hatch_pattern(),i=this.get_hatch_weight(),r=t=>{this._hatch_image=t},s=(0,o.dict)(this.get_hatch_extra()).get(h);if(null!=s){const h=s.get_pattern(t,e,a,i);if(h instanceof Promise){const{_update_iteration:t}=this;h.then((e=>{this._update_iteration==t&&(r(e),this.obj.request_paint())}))}else r(h)}else{const s=this.obj.canvas.create_layer(),n=(0,c.get_pattern)(s,h,t,e,a,i);r(n)}}get doit(){const t=this.get_hatch_color(),e=this.get_hatch_alpha(),a=this.get_hatch_pattern();return!(null==t||0==e||" "==a||"blank"==a||null==a)}apply(t,e,a="nonzero"){const{doit:h}=this;return h&&(this.set_value(t),t.layer.undo_transform((()=>{if(e instanceof Path2D){const h=e;t.fill(h,a)}else t.fill(e??a)}))),h}set_value(t){const e=this.pattern(t);t.fillStyle=e??"transparent"}pattern(t){const e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.get_hatch_pattern(),e=(0,o.dict)(this.get_hatch_extra()).get(t);if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}get_hatch_color(){const t=this._get_css_value("hatch-color");return""!=t?t:this.hatch_color.get_value()}get_hatch_alpha(){const t=this._get_css_value("hatch-alpha");if(""!=t){const e=Number(t);if(isFinite(e))return e}return this.hatch_alpha.get_value()}get_hatch_scale(){const t=this._get_css_value("hatch-scale");if(""!=t){const e=Number(t);if(isFinite(e))return e}return this.hatch_scale.get_value()}get_hatch_pattern(){const t=this._get_css_value("hatch-pattern");return""!=t?"none"==t?null:t:this.hatch_pattern.get_value()}get_hatch_weight(){const t=this._get_css_value("hatch-weight");if(""!=t){const e=Number(t);if(isFinite(e))return e}return this.hatch_weight.get_value()}get_hatch_extra(){return this.hatch_extra.get_value()}}a.Hatch=l,l.__name__="Hatch";class u extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(0==t||0==e||" "==a||"blank"==a||null==a)}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new n.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=this.hatch_color.value,a=this.hatch_alpha.value,h=this.hatch_scale.value,i=this.hatch_pattern.value,r=this.hatch_weight.value,s=e=>{this._hatch_image=new n.UniformScalar(e,t)},_=(0,o.dict)(this.hatch_extra.value).get(i);if(null!=_){const t=_.get_pattern(e,a,h,r);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(s(t),this.obj.request_paint())}))}else s(t)}else{const t=this.obj.canvas.create_layer(),n=(0,c.get_pattern)(t,i,e,a,h,r);s(n)}}get doit(){return this._static_doit}apply(t,e,a="nonzero"){const{doit:h}=this;return h&&(this.set_value(t),t.layer.undo_transform((()=>{if(e instanceof Path2D){const h=e;t.fill(h,a)}else t.fill(e??a)}))),h}set_value(t){t.fillStyle=this.pattern(t)??"transparent"}pattern(t){const e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.value;if(null!=t){const e=(0,o.dict)(this.hatch_extra.value).get(t);if(null!=e)switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}return"repeat"}}a.HatchScalar=u,u.__name__="HatchScalar";class p extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const{hatch_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{hatch_alpha:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{hatch_pattern:a}=this;if(a.is_Scalar()){const t=a.value;if(" "==t||"blank"==t||null==t)return!1}return!0}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new n.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=(t,e,a,h,i,r)=>{const s=(0,o.dict)(this.hatch_extra.value).get(t);if(null!=s){const t=s.get_pattern(e,a,h,i);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(r(t),this.obj.request_paint())}))}else r(t)}else{const s=this.obj.canvas.create_layer(),n=(0,c.get_pattern)(s,t,e,a,h,i);r(n)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){const a=this.hatch_color.value,h=this.hatch_alpha.value,i=this.hatch_scale.value;e(this.hatch_pattern.value,a,h,i,this.hatch_weight.value,(e=>{this._hatch_image=new n.UniformScalar(e,t)}))}else{const a=new Array(t);a.fill(null),this._hatch_image=new n.UniformVector(a);for(let h=0;h<t;h++){const t=this.hatch_color.get(h),i=this.hatch_alpha.get(h),r=this.hatch_scale.get(h);e(this.hatch_pattern.get(h),t,i,r,this.hatch_weight.get(h),(t=>{a[h]=t}))}}}get doit(){return this._static_doit}v_doit(t){if(!this.doit)return!1;if(0==this.hatch_color.get(t))return!1;if(0==this.hatch_alpha.get(t))return!1;const e=this.hatch_pattern.get(t);return" "!=e&&"blank"!=e&&null!=e}apply(t,e,a,h="nonzero"){const i=this.v_doit(e);return i&&(this.set_vectorize(t,e),t.layer.undo_transform((()=>{if(a instanceof Path2D){const e=a;t.fill(e,h)}else t.fill(a??h)}))),i}set_vectorize(t,e){t.fillStyle=this.pattern(t,e)??"transparent"}pattern(t,e){const a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))}repetition(t){const e=this.hatch_pattern.get(t);if(null!=e){const t=(0,o.dict)(this.hatch_extra.value).get(e);if(null!=t)switch(t.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}return"repeat"}}a.HatchVector=p,p.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(_.Hatch),u.prototype.type="hatch",u.prototype.attrs=Object.keys(_.HatchScalar),p.prototype.type="hatch",p.prototype.attrs=Object.keys(_.HatchVector)},
function _(e,o,a,r,s){r(),a.get_pattern=function(e,o,r,s,k,_){return e.resize(k,k),e.prepare(),function(e,o,r,s,k,_){const T=k,h=T/2,v=h/2,d=(0,n.color2css)(r,s);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=_,a.hatch_aliases[o]??o){case"blank":break;case"dot":e.arc(h,h,h/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(h,h,h/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,T,h);break;case"vertical_line":t(e,T,h);break;case"cross":l(e,T,h),t(e,T,h);break;case"horizontal_dash":l(e,h,h);break;case"vertical_dash":t(e,h,h);break;case"spiral":{const o=T/30;e.moveTo(h,h);for(let a=0;a<360;a++){const r=.1*a,s=h+o*r*Math.cos(r),i=h+o*r*Math.sin(r);e.lineTo(s,i)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-v,T),e.lineTo(v+.5,0),e.stroke(),e.moveTo(v+.5,T),e.lineTo(3*v+.5,0),e.stroke(),e.moveTo(3*v+.5,T),e.lineTo(5*v+.5,0),e.stroke();break;case"left_diagonal_line":e.moveTo(v+.5,T),e.lineTo(.5-v,0),e.stroke(),e.moveTo(3*v+.5,T),e.lineTo(v+.5,0),e.stroke(),e.moveTo(5*v+.5,T),e.lineTo(3*v+.5,0),e.stroke();break;case"diagonal_cross":c(e,T);break;case"right_diagonal_dash":e.moveTo(v+.5,3*v+.5),e.lineTo(3*v+.5,v+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(v+.5,v+.5),e.lineTo(3*v+.5,3*v+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,v),e.lineTo(h,3*v),e.lineTo(T,v),e.stroke();break;case"vertical_wave":e.moveTo(v,0),e.lineTo(3*v,h),e.lineTo(v,T),e.stroke();break;case"criss_cross":c(e,T),l(e,T,h),t(e,T,h);break;default:i.logger.warn(`unknown hatch pattern: ${o}`)}}(e.ctx,o,r,s,k,_),e.canvas};const i=e(20),n=e(23);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function t(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function c(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"}},
function _(a,t,e,l,s){l();const o=a(1),r=a(101),p=o.__importStar(a(95));class _ extends r.VisualProperties{get doit(){return!(0==this.global_alpha.get_value())}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.get_value()}}set_value(a){const t=this.global_alpha.get_value();a.globalAlpha=t}}e.Image=_,_.__name__="Image";class i extends r.VisualUniforms{get doit(){return!(0==this.global_alpha.value)}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.value}}set_value(a){const t=this.global_alpha.value;a.globalAlpha=t}}e.ImageScalar=i,i.__name__="ImageScalar";class g extends r.VisualUniforms{get doit(){const{global_alpha:a}=this;return!a.is_Scalar()||0!=a.value}v_doit(a){return 0!=this.global_alpha.get(a)}apply(a,t){const e=this.v_doit(t);return e&&this.set_vectorize(a,t),e}values(a){return{alpha:this.global_alpha.get(a)}}set_vectorize(a,t){const e=this.global_alpha.get(t);a.globalAlpha=e}}e.ImageVector=g,g.__name__="ImageVector",_.prototype.type="image",_.prototype.attrs=Object.keys(p.Image),i.prototype.type="image",i.prototype.attrs=Object.keys(p.ImageScalar),g.prototype.type="image",g.prototype.attrs=Object.keys(p.ImageVector)},
function _(e,a,s,t,r){var c;t();const n=e(52),_=e(108),o=e(113),i=e(115),g=e(116),l=e(117),u=e(110),h=e(118),y=e(121);class x{constructor(e,a){this.x_scale=e,this.y_scale=a,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}map_to_screen(e,a){return[this.x_scale.v_compute(e),this.y_scale.v_compute(a)]}map_from_screen(e,a){return[this.x_scale.v_invert(e),this.y_scale.v_invert(a)]}}s.CoordinateTransform=x,x.__name__="CoordinateTransform";class p extends n.Model{constructor(e){super(e)}get x_ranges(){return new Map([["default",this.x_source]])}get y_ranges(){return new Map([["default",this.y_source]])}_get_scale(e,a,s){if(e instanceof y.FactorRange!=a instanceof g.CategoricalScale)throw new Error(`Range ${e.type} is incompatible is Scale ${a.type}`);a instanceof i.LogScale&&e instanceof h.DataRange1d&&(e.scale_hint="log");const t=a.clone();return t.setv({source_range:e,target_range:s}),t}get_transform(e){const{x_source:a,x_scale:s,x_target:t}=this,r=this._get_scale(a,s,t),{y_source:c,y_scale:n,y_target:_}=this,o=this._get_scale(c,n,_),i=new l.CompositeScale({source_scale:r,source_range:r.source_range,target_scale:e.x_scale,target_range:e.x_target}),g=new l.CompositeScale({source_scale:o,source_range:o.source_range,target_scale:e.y_scale,target_range:e.y_target});return new x(i,g)}}s.CoordinateMapping=p,c=p,p.__name__="CoordinateMapping",c.define((({Ref:e})=>({x_source:[e(u.Range),()=>new h.DataRange1d],y_source:[e(u.Range),()=>new h.DataRange1d],x_scale:[e(_.Scale),()=>new o.LinearScale],y_scale:[e(_.Scale),()=>new o.LinearScale],x_target:[e(u.Range)],y_target:[e(u.Range)]})))},
function _(e,t,r,n,s){var _;n();const a=e(109),c=e(110),o=e(111),i=e(25);class u extends a.Transform{constructor(e){super(e)}compute(e){return this.s_compute(e)}v_compute(e){const t=new i.ScreenArray(e.length),{s_compute:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}invert(e){return this.s_invert(e)}v_invert(e){const t=new Float64Array(e.length),{s_invert:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}r_compute(e,t){const{s_compute:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}r_invert(e,t){const{s_invert:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}}r.Scale=u,_=u,u.__name__="Scale",_.internal((({Ref:e})=>({source_range:[e(c.Range)],target_range:[e(o.Range1d)]})))},
function _(n,s,o,r,c){r();const e=n(52);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(t,e,n,l,s){var a;l();const i=t(52),u=t(22),r=t(14),o=(0,u.Nullable)((0,u.Or)((0,u.Tuple)((0,u.Nullable)(u.Float),(0,u.Nullable)(u.Float)),u.Auto));class d extends i.Model{constructor(t){super(t),this.have_updated_interactively=!1,this.frames=new Set}get computed_bounds(){return this._computed_bounds}get is_reversed(){return this.start>this.end}get is_valid(){return isFinite(this.min)&&isFinite(this.max)}get interval(){return[this.start,this.end]}get span(){return Math.abs(this.end-this.start)}get linked_plots(){return new Set((0,r.map)(this.frames,(t=>t.parent)))}}n.Range=d,a=d,d.__name__="Range",a.define((({Float:t,Nullable:e})=>({bounds:[o,null,{on_update(t,e){const[n,l]="auto"==t||null==t?[null,null]:t;e._computed_bounds=[n??-1/0,l??1/0]}}],min_interval:[e(t),null],max_interval:[e(t),null]})))},
function _(t,e,s,n,r){var a;n();const i=t(112);class _ extends i.NumericalRange{constructor(t){super(t)}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this._computed_bounds=[t,e]}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new a({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new a({start:e,end:s})}}s.Range1d=_,a=_,_.__name__="Range1d",a.define((({Float:t,Nullable:e})=>({reset_start:[e(t),null,{on_update(t,e){e._reset_start=t??e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=t??e.end}}]}))),a.override({start:0,end:1})},
function _(n,e,t,c,r){var o;c();const a=n(1),s=n(110),u=a.__importStar(n(19)),_=n(11);class m extends s.Range{constructor(n){super(n)}}t.NumericalRange=m,o=m,m.__name__="NumericalRange",o.define((({Float:n})=>({start:[n,u.unset,{convert(n,e){const[t,c]=e.computed_bounds;return(0,_.clamp)(n,t,c)}}],end:[n,u.unset,{convert(n,e){const[t,c]=e.computed_bounds;return(0,_.clamp)(n,t,c)}}]})))},
function _(t,e,n,r,s){r();const a=t(114);class _ extends a.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e]=this._linear_compute_state();return n=>t*n+e}get s_invert(){const[t,e]=this._linear_compute_state();return n=>(n-e)/t}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,n=this.target_range.start,r=(this.target_range.end-n)/(e-t);return[r,-r*t+n]}}n.LinearScale=_,_.__name__="LinearScale"},
function _(n,c,o,s,e){s();const t=n(108);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,e,s,a,r){a();const o=t(114);class n extends o.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e,s,a]=this._compute_state();return r=>{if(0==s)return 0;{const o=(Math.log(r)-a)/s;return isFinite(o)?o*t+e:NaN}}}get s_invert(){const[t,e,s,a]=this._compute_state();return r=>{const o=(r-e)/t;return Math.exp(s*o+a)}}_get_safe_factor(t,e){let s=t<0?0:t,a=e<0?0:e;if(s==a)if(0==s)[s,a]=[1,10];else{const t=Math.log10(s);s=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[s,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,s=this.target_range.start,a=this.target_range.end-s,[r,o]=this._get_safe_factor(t,e);let n,c;0==r?(n=Math.log(o),c=0):(n=Math.log(o/r),c=Math.log(r));return[a,s,n,c]}}s.LogScale=n,n.__name__="LogScale"},
function _(t,e,c,a,s){a();const n=t(108),r=t(113),{_linear_compute_state:o}=r.LinearScale.prototype;class l extends n.Scale{constructor(t){super(t)}get s_compute(){const[t,e]=o.call(this),c=this.source_range;return a=>t*c.synthetic(a)+e}get s_invert(){const[t,e]=o.call(this);return c=>(c-e)/t}}c.CategoricalScale=l,l.__name__="CategoricalScale"},
function _(e,t,s,c,r){var n;c();const _=e(108),o=e(13);class a extends _.Scale{constructor(e){super(e)}get s_compute(){const e=this.source_scale.s_compute,t=this.target_scale.s_compute;return s=>t(e(s))}get s_invert(){const e=this.source_scale.s_invert,t=this.target_scale.s_invert;return s=>e(t(s))}compute(e){return this.s_compute(e)}v_compute(e){const{s_compute:t}=this;return(0,o.map)(e,t)}invert(e){return this.s_invert(e)}v_invert(e){const{s_invert:t}=this;return(0,o.map)(e,t)}}s.CompositeScale=a,n=a,a.__name__="CompositeScale",n.define((({Ref:e})=>({source_scale:[e(_.Scale)],target_scale:[e(_.Scale)]})))},
function _(t,i,n,a,e){var s;a(),n.is_auto_ranged=function(t){return n.auto_ranged in t};const l=t(1),_=t(119),o=t(21),r=t(14),d=t(11),h=t(20),u=l.__importStar(t(62)),g=t(120);n.auto_ranged=Symbol("auto_ranged");class p extends _.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}initialize(){super.initialize(),this._initial_start=isNaN(this.start)?null:this.start,this._initial_end=isNaN(this.end)?null:this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t}=this,i=(0,r.flat_map)(this.linked_plots,(t=>t.auto_ranged_renderers.map((t=>t.model))));return(0,g.compute_renderers)(0==t.length?"auto":t,[...i])}_compute_plot_bounds(t,i){let n=u.empty();for(const a of t){const t=i.get(a);null==t||!a.visible&&this.only_visible||(n=u.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=u.empty();let a=t.x1-t.x0;a<=0&&(a=1);let e=t.y1-t.y0;e<=0&&(e=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=s+.5*a,n.x0=s-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n}_compute_min_max(t,i){let n,a,e=u.empty();for(const[i,n]of t)i.model.visible&&(e=u.union(e,n));return[n,a]=0==i?[e.x0,e.x1]:[e.y0,e.y1],[n,a]}_compute_range(t,i){const{range_padding:n}=this,a=this.min_interval??0,e=this.max_interval??1/0;let s,l;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let _,o;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,h.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,h.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)o=this.default_span+.001,_=Math.log10(t);else{let a,e;"percent"==this.range_padding_units?(a=Math.log10(t),e=Math.log10(i),o=(e-a)*(1+n)):(a=Math.log10(t-n),e=Math.log10(i+n),o=e-a),_=(a+e)/2}o=(0,d.clamp)(o,a,e),s=10**(_-o/2),l=10**(_+o/2)}else{let _;_=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n,_=(0,d.clamp)(_,a,e);const o=(i+t)/2;s=o-_/2,l=o+_/2}let _=1;this.flipped&&([s,l]=[l,s],_=-1);const o=this.follow_interval;return null!=o&&Math.abs(s-l)>o&&("start"==this.follow?l=s+_*o:"end"==this.follow&&(s=l-_*o)),[s,l]}update(t,i,n,a){if(this.have_updated_interactively)return;const e=this.computed_renderers();let s=this._compute_plot_bounds(e,t);null!=a&&(s=this.adjust_bounds_for_aspect(s,a)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.entries(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);let d=!1;"auto"==this.bounds&&(this._computed_bounds=[o,r],d=!0);const[h,u]=[this.start,this.end];if(o!=h||r!=u){const t={};o!=h&&(t.start=o),r!=u&&(t.end=r),this.setv(t),d=!1}d&&this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=p,s=p,p.__name__="DataRange1d",s.define((({Bool:t,Float:i,Nullable:n})=>({range_padding:[i,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(o.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]}))),s.internal((({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]})))},
function _(e,a,n,r,t){var s;r();const c=e(112);class o extends c.NumericalRange{constructor(e){super(e)}}n.DataRange=o,s=o,o.__name__="DataRange",s.define((({List:e,AnyRef:a,Or:n,Auto:r})=>({renderers:[n(e(a()),r),[]]}))),s.override({start:NaN,end:NaN})},
function _(n,e,r,t,u){t(),r.compute_renderers=function(n,e){return"auto"==n?e:n??[]}},
function _(t,e,n,r,s){var i;r(),n.map_one_level=_,n.map_two_levels=f,n.map_three_levels=m;const a=t(1),o=t(110),c=t(21),p=t(22),g=a.__importStar(t(19)),u=t(16),l=t(25),h=t(10),d=t(8);function _(t,e,n=0){const r=new Map;for(let s=0;s<t.length;s++){const i=t[s];if(r.has(i))throw new Error(`duplicate factor or subfactor: ${i}`);r.set(i,{value:.5+s*(1+e)+n})}return{mapping:r,inner_padding:(t.length-1)*e}}function f(t,e,n,r=0){const s=new Map,i=new Map;for(const[e,n]of t){const t=i.get(e)??[];i.set(e,[...t,n])}let a=r,o=0;for(const[t,r]of i){const i=r.length,c=_(r,n,a);o+=c.inner_padding;const p=(0,h.sum)(r.map((t=>c.mapping.get(t).value)));s.set(t,{value:p/i,mapping:c.mapping}),a+=i+e+c.inner_padding}const c=(i.size-1)*e+o;return{mapping:s,tops:[...s.keys()],inner_padding:c}}function m(t,e,n,r,s=0){const i=new Map,a=new Map;for(const[e,n,r]of t){const t=a.get(e)??[];a.set(e,[...t,[n,r]])}let o=s,c=0;for(const[t,s]of a){const a=s.length,p=f(s,n,r,o);c+=p.inner_padding;const g=(0,h.sum)(s.map((([t])=>p.mapping.get(t).value)));i.set(t,{value:g/a,mapping:p.mapping}),o+=a+e+p.inner_padding}const p=[];for(const[t,e]of i)for(const n of e.mapping.keys())p.push([t,n]);const g=(a.size-1)*e+c;return{mapping:i,tops:[...i.keys()],mids:p,inner_padding:g}}n.L1Factor=p.Str,n.L2Factor=(0,p.Tuple)(p.Str,p.Str),n.L3Factor=(0,p.Tuple)(p.Str,p.Str,p.Str),n.L1FactorSeq=(0,p.List)(n.L1Factor),n.L2FactorSeq=(0,p.List)(n.L2Factor),n.L3FactorSeq=(0,p.List)(n.L3Factor),n.L1OffsetFactor=(0,p.Tuple)(p.Str,p.Float),n.L2OffsetFactor=(0,p.Tuple)(p.Str,p.Str,p.Float),n.L3OffsetFactor=(0,p.Tuple)(p.Str,p.Str,p.Str,p.Float),n.Factor=(0,p.Or)(n.L1Factor,n.L2Factor,n.L3Factor),n.FactorSeq=(0,p.Or)(n.L1FactorSeq,n.L2FactorSeq,n.L3FactorSeq),n.OffsetFactor=(0,p.Or)(n.L1OffsetFactor,n.L2OffsetFactor,n.L3OffsetFactor),n.FactorLike=(0,p.Or)(p.Float,n.Factor,n.OffsetFactor);const F=t=>(0,d.isString)(t),v=t=>(0,d.isArray)(t)&&2==t.length&&(0,d.isString)(t[0])&&(0,d.isString)(t[1]),S=t=>(0,d.isArray)(t)&&3==t.length&&(0,d.isString)(t[0])&&(0,d.isString)(t[1])&&(0,d.isString)(t[2]);class L{constructor({levels:t,mapping:e,tops:n=null,mids:r=null,inner_padding:s}){this.levels=t,this.mapping=e,this.tops=n,this.mids=r,this.inner_padding=s}static compute_levels(t){if((0,h.every)(t,F))return 1;if((0,h.every)(t,v))return 2;if((0,h.every)(t,S))return 3;throw TypeError("factor levels are inconsistent")}static for(t){switch(this.compute_levels(t.factors)){case 1:return new y(t);case 2:return new w(t);case 3:return new O(t)}}map(t){if((0,d.isNumber)(t))return t;const[e,n]=(()=>{if((0,d.isString)(t))return[[t],0];const e=t[t.length-1];return(0,d.isNumber)(e)?[t.slice(0,-1),e]:[t,0]})();if(e.length>this.levels)throw new Error(`Attempted to map ${e.length} levels of factors with an L${this.levels}FactorMap`);return this.lookup_value(e)+n}lookup_value(t){return this.lookup_entry(t)?.value??NaN}}n.FactorMapper=L,L.__name__="FactorMapper";class y extends L{constructor(t){const{factors:e,factor_padding:n}=t;super({levels:1,..._(e,n)})}lookup_entry(t){const[e]=t;return this.mapping.get(e)??null}}y.__name__="L1FactorMapper";class w extends L{constructor(t){const{factors:e,group_padding:n,factor_padding:r}=t;super({levels:2,...f(e,n,r)})}lookup_entry(t){if(1==t.length){const[e]=t;return this.mapping.get(e)??null}{const[e,n]=t;return this.mapping.get(e)?.mapping.get(n)??null}}}w.__name__="L2FactorMapper";class O extends L{constructor(t){const{factors:e,group_padding:n,subgroup_padding:r,factor_padding:s}=t;super({levels:3,...m(e,n,r,s)})}lookup_entry(t){if(1==t.length){const[e]=t;return this.mapping.get(e)??null}if(2==t.length){const[e,n]=t;return this.mapping.get(e)?.mapping.get(n)??null}{const[e,n,r]=t;return this.mapping.get(e)?.mapping.get(n)?.mapping.get(r)??null}}}O.__name__="L3FactorMapper";class b extends o.Range{constructor(t){super(t),this.invalidate_synthetic=new u.Signal0(this,"invalidate_synthetic")}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this.configure()}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,(()=>this.reset())),this.connect(this.properties.factor_padding.change,(()=>this.reset())),this.connect(this.properties.group_padding.change,(()=>this.reset())),this.connect(this.properties.subgroup_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding_units.change,(()=>this.reset()))}reset(){this.configure(),this.invalidate_synthetic.emit()}synthetic(t){return this.mapper.map(t)}v_synthetic(t){return l.ScreenArray.from(t,(t=>this.synthetic(t)))}factor(t){for(const e of this.factors){const n=this.mapper.map(e);if(t>=n-.5&&t<n+.5)return e}return null}compute_bounds(t){const e=this.factors.length+t,n=(()=>{switch(this.range_padding_units){case"percent":return e*this.range_padding/2;case"absolute":return this.range_padding}})();return[-n,e+n]}configure(){this.mapper=L.for(this);const[t,e]=this.compute_bounds(this.mapper.inner_padding);this.setv({start:t,end:e},{silent:!0}),"auto"==this.bounds&&(this._computed_bounds=[t,e])}}n.FactorRange=b,i=b,b.__name__="FactorRange",i.define((({Float:t})=>({factors:[n.FactorSeq,[]],factor_padding:[t,0],subgroup_padding:[t,.8],group_padding:[t,1.4],range_padding:[t,0],range_padding_units:[c.PaddingUnits,"percent"],start:[t,g.unset,{readonly:!0}],end:[t,g.unset,{readonly:!0}]})))},
function _(e,t,i,s,n){var o;s();const u=e(1),l=e(55),_=e(123),r=e(126),d=e(127),h=e(8),m=e(61),c=e(22),a=e(69),p=e(10),v=e(51),w=u.__importStar(e(128)),f=w,y=u.__importDefault(e(76));function g(e){return(0,h.isFunction)(e)?e():e}i.MenuItemLike=(0,c.Or)((0,c.Ref)(_.MenuItem),(0,c.Ref)(r.DividerItem),c.Null);class k extends l.UIElementView{constructor(){super(...arguments),this._menu_views=new Map,this._menu_items=[],this._open=!1,this._item_click=e=>{if(!g(e.disabled)){const{action:t}=e;null!=t&&(0,v.execute)(t,this.model,{item:e}),this.hide()}},this._on_mousedown=e=>{e.composedPath().includes(this.el)||this.prevent_hide?.(e)||this.hide()},this._on_keydown=e=>{if("Escape"===e.key)this.hide()},this._on_blur=()=>{this.hide()}}*children(){yield*super.children(),yield*this._menu_views.values()}get menu_items(){const e=this._menu_items,{reversed:t}=this.model;return t?(0,p.reversed)(e):e}_compute_menu_items(){return this.model.items}_update_menu_items(){this._menu_items=this._compute_menu_items()}get is_empty(){return 0==this.menu_items.length}initialize(){super.initialize(),this._update_menu_items()}async lazy_initialize(){await super.lazy_initialize();const e=this.menu_items.filter((e=>e instanceof _.MenuItem)).map((e=>e.menu)).filter((e=>null!=e));await(0,a.build_views)(this._menu_views,e,{parent:this})}connect_signals(){super.connect_signals();const{items:e}=this.model.properties;this.on_change(e,(()=>this._update_menu_items()))}get is_open(){return this._open}remove(){this._unlisten(),(0,a.remove_views)(this._menu_views),super.remove()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}stylesheets(){return[...super.stylesheets(),w.default,y.default]}render(){super.render();const e=this.menu_items,t=[];if(0!=e.length)for(const i of e)if(i instanceof _.MenuItem){const s=(0,m.div)({class:f.check}),n=(0,m.div)({class:f.label},i.label),o=(0,m.div)({class:f.shortcut},i.shortcut),u=(0,m.div)({class:f.chevron}),l=(()=>{const{icon:e}=i;if(null!=e){const t=(0,m.div)({class:f.icon});return(0,d.apply_icon)(t,e),t}return null})(),r=(0,m.div)({class:f.item,title:i.tooltip,tabIndex:0},s,l,n,o,u),h=null!=i.menu&&!this._menu_views.get(i.menu).is_empty;r.classList.toggle(f.menu,h),r.classList.toggle(f.disabled,g(i.disabled)),null!=i.checked&&(r.classList.add(f.checkable),r.classList.toggle(f.checked,g(i.checked)));const c=e=>{if(null!=e.menu){this._menu_views.get(e.menu)._show_submenu(r)}},a=e=>{if(null!=e.menu){this._menu_views.get(e.menu).hide()}};function p(e){const{currentTarget:t,target:i}=e;return t instanceof Node&&i instanceof Node&&t.contains(i)}r.addEventListener("click",(e=>{p(e)?this._item_click(i):this.hide()})),r.addEventListener("keydown",(e=>{if("Enter"===e.key)this._item_click(i)}));const{menu:v}=i;null!=v&&(r.addEventListener("pointerenter",(()=>{c(i)})),r.addEventListener("pointerleave",(()=>{a(i)}))),this.shadow_el.append(r),t.push({item:i,el:r})}else{const w=(0,m.div)({class:f.divider});this.shadow_el.append(w)}}_show_submenu(e){if(this.is_empty)return void this.hide();this.render(),e.append(this.el);const{style:t}=this.el;t.left="100%",t.top="0",this._listen(),this._open=!0}show(e){if(this.is_empty)return this.hide(),!1;const{parent:t}=this;if(null==t)return this.hide(),!1;this.render();(t.el.shadowRoot??t.el).append(this.el);const{style:i}=this.el;return i.left=(0,m.px)(e.x),i.top=(0,m.px)(e.y),this._listen(),this._open=!0,!0}hide(){this._open&&(this._open=!1,this._unlisten(),this.el.remove())}}i.MenuView=k,k.__name__="MenuView";class L extends l.UIElement{constructor(e){super(e)}}i.Menu=L,o=L,L.__name__="Menu",o.prototype.default_view=k,o.define((({Bool:e,List:t})=>({items:[t(i.MenuItemLike),[]],reversed:[e,!1]})))},
function _(l,n,e,u,c){var o;u();const t=l(52),a=l(124),s=l(125);class i extends t.Model{constructor(l){super(l)}}e.MenuItem=i,o=i,i.__name__="MenuItem",o.define((({Bool:l,Str:n,Nullable:e,AnyRef:u,Ref:c,Func:o,Func0:t,Or:i})=>({checked:[e(i(l,t(l))),null],icon:[e(a.IconLike),null],label:[n],tooltip:[e(n),null],shortcut:[e(n),null],menu:[e(u()),null],disabled:[i(l,t(l)),!1],action:[e(i(c(s.Callback),o())),null]})))},
function _(t,n,e,r,i){r();const g=t(1),a=t(22),h=g.__importStar(t(21));e.Length=(0,a.NonNegative)(a.Int);var o;e.HAnchor=(0,a.Or)(h.Align,h.HAlign,a.Percent),e.VAnchor=(0,a.Or)(h.Align,h.VAlign,a.Percent),e.Anchor=(0,a.Or)(h.Anchor,(0,a.Tuple)(e.HAnchor,e.VAnchor)),e.AutoAnchor=(0,a.Or)(a.Auto,h.Anchor,(0,a.Tuple)((0,a.Or)(e.HAnchor,a.Auto),(0,a.Or)(e.VAnchor,a.Auto))),e.TextAnchor=(0,a.Or)(e.Anchor,a.Auto),e.Padding=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length),(o=e.Length,(0,a.PartialStruct)({x:o,y:o})),(0,a.Tuple)(e.Length,e.Length,e.Length,e.Length),(t=>(0,a.PartialStruct)({left:t,right:t,top:t,bottom:t}))(e.Length)),e.BorderRadius=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length,e.Length,e.Length),(0,a.PartialStruct)({top_left:e.Length,top_right:e.Length,bottom_right:e.Length,bottom_left:e.Length})),e.Index=(0,a.NonNegative)(a.Int),e.Span=(0,a.NonNegative)(a.Int);e.GridChild=t=>(0,a.Tuple)((0,a.Ref)(t),e.Index,e.Index,(0,a.Opt)(e.Span),(0,a.Opt)(e.Span)),e.GridSpacing=(0,a.Or)(e.Length,(0,a.Tuple)(e.Length,e.Length)),e.TrackAlign=(0,a.Enum)("start","center","end","auto"),e.TrackSize=a.Str,e.TrackSizing=(0,a.PartialStruct)({size:e.TrackSize,align:e.TrackAlign}),e.TrackSizingLike=(0,a.Or)(e.TrackSize,e.TrackSizing),e.TracksSizing=(0,a.Or)(e.TrackSizingLike,(0,a.List)(e.TrackSizingLike),(0,a.Mapping)(a.Int,e.TrackSizingLike)),e.IconLike=(0,a.Or)(h.ToolIcon,(0,a.PrefixedStr)("--"),(0,a.PrefixedStr)("."),(0,a.PrefixedStr)("data:image"))},
function _(c,a,l,n,s){n();const e=c(52);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,t,n,s,c){s();const i=e(52);class o extends i.Model{constructor(e){super(e)}}n.DividerItem=o,o.__name__="DividerItem"},
function _(t,e,r,n,o){n(),r.normalized_anchor=u,r.anchor=l,r.text_anchor=function(t,e,r){if("auto"!=t)return l(t);return l([(()=>{switch(e){case"left":return"start";case"center":return"center";case"right":return"end"}})(),(()=>{switch(r){case"alphabetic":case"ideographic":case"hanging":case"middle":return"center";case"top":return"start";case"bottom":return"end"}})()])},r.padding=function(t){if((0,i.isNumber)(t))return{left:t,right:t,top:t,bottom:t};if(!(0,i.isPlainObject)(t)){if(2==t.length){const[e=0,r=0]=t;return{left:e,right:e,top:r,bottom:r}}{const[e=0,r=0,n=0,o=0]=t;return{left:e,right:r,top:n,bottom:o}}}if("x"in t||"y"in t){const{x:e=0,y:r=0}=t;return{left:e,right:e,top:r,bottom:r}}if("left"in t||"right"in t||"top"in t||"bottom"in t){const{left:e=0,right:r=0,top:n=0,bottom:o=0}=t;return{left:e,right:r,top:n,bottom:o}}(0,s.unreachable)()},r.border_radius=function(t){if((0,i.isNumber)(t))return{top_left:t,top_right:t,bottom_right:t,bottom_left:t};if((0,i.isPlainObject)(t))return{top_left:t.top_left??0,top_right:t.top_right??0,bottom_right:t.bottom_right??0,bottom_left:t.bottom_left??0};{const[e=0,r=0,n=0,o=0]=t;return{top_left:e,top_right:r,bottom_right:n,bottom_left:o}}},r.apply_icon=function(t,e){if(e.startsWith("data:image")){const r=`url("${encodeURI(e)}")`;t.style.backgroundImage=r}else if(e.startsWith("--"))t.style.backgroundImage=`var(${e})`;else if(e.startsWith(".")){const r=e.substring(1);t.classList.add(r)}else if(c.ToolIcon.valid(e)){const r=`bk-tool-icon-${e.replace(/_/g,"-")}`;t.classList.add(r)}else a.logger.warn(`unable to resolve icon: ${e}`)};const c=t(21),i=t(8),s=t(12),a=t(20);function u(t){if("auto"==t)return{x:"auto",y:"auto"};const e=(()=>{switch(t){case"top":return"top_center";case"bottom":return"bottom_center";case"left":return"center_left";case"center":return"center_center";case"right":return"center_right";default:return t}})();if((0,i.isString)(e)){const[t,r]=e.split("_");return{x:r,y:t}}{const[t,r]=e;return{x:t,y:r}}}function l(t){const{x:e,y:r}=u(t);return{x:(()=>{switch(e){case"start":case"left":return 0;case"center":return.5;case"end":case"right":return 1;default:return e}})(),y:(()=>{switch(r){case"start":case"top":return 0;case"center":return.5;case"end":case"bottom":return 1;default:return r}})()}}},
function _(e,o,r,i,t){i(),r.item="bk-item",r.divider="bk-divider",r.check="bk-check",r.icon="bk-icon",r.label="bk-label",r.shortcut="bk-shortcut",r.chevron="bk-chevron",r.disabled="bk-disabled",r.menu="bk-menu",r.checkable="bk-checkable",r.checked="bk-checked",r.default=":host{position:absolute;display:inline-grid;grid-template-columns:repeat(5, max-content);grid-template-rows:auto;user-select:none;-webkit-user-select:none;cursor:pointer;width:auto;height:auto;z-index:var(--bokeh-top-level);font-size:var(--font-size);background-color:var(--background-color);border:1px solid var(--border-color);border-radius:var(--border-radius);box-shadow:var(--box-shadow);}.bk-item,.bk-divider{position:relative;display:grid;grid-template-columns:subgrid;grid-column:span 5;align-items:center;}.bk-check{grid-column:1;}.bk-icon{grid-column:2;}.bk-label{grid-column:3;}.bk-shortcut{grid-column:4;}.bk-chevron{grid-column:5;}.bk-divider{cursor:default;overflow:hidden;background-color:var(--divider-color);height:1px;margin:1px 5px;}.bk-item{padding:0.5em;}.bk-item:hover{background-color:var(--hover-color);}.bk-item:focus,.bk-item:focus-visible{outline:1px dotted var(--highlight-color);outline-offset:-1px;}.bk-item::-moz-focus-inner{border:0;}.bk-item.bk-disabled{color:var(--disabled-color);cursor:not-allowed;}.bk-item.bk-disabled .bk-icon{color:var(--icon-color-disabled);}.bk-item:first-of-type{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}.bk-item:last-of-type{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}.bk-icon{position:relative;width:16px;height:16px;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-size:100% 100%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}.bk-label{padding:0 0.5em;}.bk-shortcut{text-align:right;font-size:90%;color:var(--shortcut-color);}.bk-chevron{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;width:12px;height:12px;}.bk-item:not(.bk-menu) .bk-chevron{display:none;}.bk-item.bk-checkable .bk-check{width:16px;height:16px;}.bk-item.bk-checkable.bk-checked .bk-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;}"},
function _(e,r,n,o,s){var c;o();const d=e(52);class t extends d.Model{constructor(e){super(e)}}n.RendererGroup=t,c=t,t.__name__="RendererGroup",c.define((({Bool:e})=>({visible:[e,!0]})))},
function _(e,o,_,d,s){d();const n=e(64),c=e(52);class t extends n.DOMView{}_.DOMNodeView=t,t.__name__="DOMNodeView";class M extends c.Model{constructor(e){super(e)}}_.DOMNode=M,M.__name__="DOMNode",M.__module__="bokeh.models.dom"},
function _(t,e,i,s,l){var a;s();const o=t(132),n=t(20),r=t(16),h=t(21),u=t(61),_=t(8),c=t(14),d=t(69),f=t(135),p=t(71),m=t(12);class y extends o.PaneView{constructor(){super(...arguments),this._child_views=new Map,this.mouseenter=new r.Signal(this,"mouseenter"),this.mouseleave=new r.Signal(this,"mouseleave"),this.disabled=new r.Signal(this,"disabled"),this._auto_width="fit-content",this._auto_height="fit-content",this._layout_computed=!1}get is_layout_root(){return this.is_root||!(this.parent instanceof y)}_after_resize(){super._after_resize(),this.is_layout_root&&!this._was_built?(n.logger.warn(`${this} wasn't built properly`),this.render(),this.r_after_render()):this.compute_layout()}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const t of this.child_views)t.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.el.addEventListener("mouseenter",(t=>{this.mouseenter.emit(t)})),this.el.addEventListener("mouseleave",(t=>{this.mouseleave.emit(t)})),this.parent instanceof y&&this.connect(this.parent.disabled,(t=>{this.disabled.emit(t||this.model.disabled)}));const t=this.model.properties;this.on_change(t.disabled,(()=>{this.disabled.emit(this.model.disabled)})),this.on_change([t.css_classes,t.stylesheets,t.width,t.height,t.min_width,t.min_height,t.max_width,t.max_height,t.margin,t.width_policy,t.height_policy,t.flow_mode,t.sizing_mode,t.aspect_ratio,t.visible],(()=>this.invalidate_layout()))}*children(){yield*super.children(),yield*this.child_views}get child_views(){return this.child_models.map((t=>this._child_views.get(t))).filter((t=>null!=t))}get layoutable_views(){return this.child_views.filter((t=>t instanceof y))}async build_child_views(){const{created:t,removed:e}=await(0,d.build_views)(this._child_views,this.child_models,{parent:this});for(const t of e)this._resize_observer.unobserve(t.el);for(const e of t)this._resize_observer.observe(e.el,{box:"border-box"});return t}render(){super.render();for(const t of this.child_views){const e=t.rendering_target()??this.shadow_el;t.render_to(e)}}rerender(){super.rerender(),this.update_layout(),this.compute_layout()}_update_children(){}async update_children(){const t=await this.build_child_views(),e=new Set(t),i=Array.from(this.shadow_el.children).flatMap((t=>{const e=this.child_views.find((e=>e.el===t));return void 0===e?[]:[e]}));let s=null;for(let t=0;t<i.length&&i[t]===this.child_views[t];t++)s=t;for(const[t,i]of(0,c.enumerate)(this.child_views)){const l=e.has(t),a=t.rendering_target()??this.self_target;l?t.render_to(a):(null===s||i>s)&&a.append(t.el)}this.r_after_render(),this._update_children(),this.invalidate_layout()}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flow"}}_update_layout(){function t(t,e,i,s){switch(t){case"auto":return null!=e?(0,u.px)(e):i;case"fixed":return null!=e?(0,u.px)(e):"fit-content";case"fit":return"fit-content";case"min":return"min-content";case"max":return null==s?"100%":`calc(100% - ${s})`}}function e(t){return(0,_.isNumber)(t)?(0,u.px)(t):`${t.percent}%`}const i={},s=this._intrinsic_display();i.display=function(t){const{inner:e,outer:i}=t;switch(`${e} ${i}`){case"block flow":return"block";case"inline flow":return"inline";case"block flow-root":return"flow-root";case"inline flow-root":return"inline-block";case"block flex":return"flex";case"inline flex":return"inline-flex";case"block grid":return"grid";case"inline grid":return"inline-grid";case"block table":return"table";case"inline table":return"inline-table";default:(0,m.unreachable)()}}(s);const l=this.box_sizing(),{width_policy:a,height_policy:o,width:n,height:r,aspect_ratio:h}=l,c=(()=>{if("auto"==h){if(null!=n&&null!=r)return n/r}else if((0,_.isNumber)(h))return h;return null})();"auto"==h?i.aspect_ratio=null!=n&&null!=r?`${n} / ${r}`:"auto":(0,_.isNumber)(h)&&(i.aspect_ratio=`${h}`);const{margin:d}=this.model,f=(()=>{if(null!=d){if((0,_.isNumber)(d))return i.margin=(0,u.px)(d),{width:(0,u.px)(2*d),height:(0,u.px)(2*d)};if(2==d.length){const[t,e]=d;return i.margin=`${(0,u.px)(t)} ${(0,u.px)(e)}`,{width:(0,u.px)(2*e),height:(0,u.px)(2*t)}}{const[t,e,s,l]=d;return i.margin=`${(0,u.px)(t)} ${(0,u.px)(e)} ${(0,u.px)(s)} ${(0,u.px)(l)}`,{width:(0,u.px)(l+e),height:(0,u.px)(t+s)}}}return{width:null,height:null}})(),[p,y]=(()=>{const e=t(a,n,this._auto_width,f.width),i=t(o,r,this._auto_height,f.height);if(null!=h){if(a!=o)return"fixed"==a?[e,"auto"]:"fixed"==o?["auto",i]:"max"==a?[e,"auto"]:"max"==o?["auto",i]:["auto","auto"];if("fixed"!=a&&"fixed"!=o&&null!=c)return c>=1?[e,"auto"]:["auto",i]}return[e,i]})();i.width=p,i.height=y;const{min_width:w,max_width:g}=this.model,{min_height:b,max_height:x}=this.model;null!=w&&(i.min_width=e(w)),null!=b&&(i.min_height=e(b)),this.is_layout_root?(null!=g&&(i.max_width=e(g)),null!=x&&(i.max_height=e(x))):(null!=g?i.max_width=`min(${e(g)}, 100%)`:"fixed"!=a&&(i.max_width="100%"),null!=x?i.max_height=`min(${e(x)}, 100%)`:"fixed"!=o&&(i.max_height="100%"));const{resizable:v}=this.model;if(!1!==v){const t=(()=>{switch(v){case"width":return"horizontal";case"height":return"vertical";case!0:case"both":return"both"}})();i.resize=t,i.overflow="auto"}this.style.append(":host",i)}update_layout(){this.update_style();for(const t of this.child_views)t.parent_style.clear();for(const t of this.layoutable_views)t.update_layout();this._update_layout()}get is_managed(){return this.parent instanceof y}_measure_layout(){}measure_layout(){for(const t of this.layoutable_views)t.measure_layout();this._measure_layout()}compute_layout(){this.parent instanceof y?this.parent.compute_layout():(this.measure_layout(),this.update_bbox(),this._compute_layout(),this.after_layout()),this._layout_computed=!0}_compute_layout(){if(null!=this.layout){this.layout.compute(this.bbox.size);for(const t of this.layoutable_views)null==t.layout?t._compute_layout():t._propagate_layout()}else for(const t of this.layoutable_views)t._compute_layout()}_propagate_layout(){for(const t of this.layoutable_views)null==t.layout&&t._compute_layout()}update_bbox(){for(const t of this.layoutable_views)t.update_bbox();const t=super.update_bbox();return null!=this.layout&&(this.layout.visible=this.is_displayed),t}_after_layout(){}after_layout(){for(const t of this.layoutable_views)t.after_layout();this._after_layout()}_after_render(){this.is_managed||this.invalidate_layout()}invalidate_layout(){this.parent instanceof y?this.parent.invalidate_layout():(this.update_layout(),this.compute_layout())}invalidate_render(){this.render(),this.r_after_render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;if(this.is_layout_root&&!this._layout_computed)return!1;for(const t of this.child_views)if(!t.has_finished())return!1;return!0}box_sizing(){let{width_policy:t,height_policy:e,aspect_ratio:i}=this.model;const{sizing_mode:s}=this.model;if(null!=s)if("inherit"==s){if(this.parent instanceof y){const s=this.parent.box_sizing();t=s.width_policy,e=s.height_policy,null==i&&(i=s.aspect_ratio)}}else if("fixed"==s)t=e="fixed";else if("stretch_both"==s)t=e="max";else if("stretch_width"==s)t="max";else if("stretch_height"==s)e="max";else switch(null==i&&(i="auto"),s){case"scale_width":t="max",e="min";break;case"scale_height":t="min",e="max";break;case"scale_both":t="max",e="max"}const[l,a]=(()=>{const{align:t}=this.model;return"auto"==t?[void 0,void 0]:(0,_.isArray)(t)?t:[t,t]})(),{width:o,height:n}=this.model;return{width_policy:t,height_policy:e,width:o,height:n,aspect_ratio:i,halign:l,valign:a}}export(t="auto",e=!0){const i=(()=>{switch(t){case"auto":case"png":return"canvas";case"svg":return"svg"}})(),s=new p.CanvasLayer(i,e),{x:l,y:a,width:o,height:n}=this.bbox;s.resize(o,n);const r=getComputedStyle(this.el).backgroundColor;s.ctx.fillStyle=r,s.ctx.fillRect(l,a,o,n);for(const i of this.child_views){const l=i.export(t,e),{x:a,y:o}=i.bbox.scale(s.pixel_ratio);s.ctx.drawImage(l.canvas,a,o)}return s}}i.LayoutDOMView=y,y.__name__="LayoutDOMView";class w extends o.Pane{constructor(t){super(t)}}i.LayoutDOM=w,a=w,w.__name__="LayoutDOM",a.define((t=>{const{Bool:e,Float:i,Auto:s,Tuple:l,Or:a,Null:o,Nullable:n}=t,r=l(i,i),u=l(i,i,i,i);return{width:[n(i),null],height:[n(i),null],min_width:[n(i),null],min_height:[n(i),null],max_width:[n(i),null],max_height:[n(i),null],margin:[n(a(i,r,u)),null],width_policy:[a(f.SizingPolicy,s),"auto"],height_policy:[a(f.SizingPolicy,s),"auto"],aspect_ratio:[a(i,s,o),null],flow_mode:[h.FlowMode,"block"],sizing_mode:[n(h.SizingMode),null],disabled:[e,!1],align:[a(h.Align,l(h.Align,h.Align),s),"auto"],resizable:[a(e,h.Dimensions),!1]}}))},
function _(e,t,n,s,i){var r;s();const _=e(55),l=e(130),a=e(133),m=e(69),o=e(22);n.ElementLike=(0,o.Or)((0,o.Ref)(_.UIElement),(0,o.Ref)(l.DOMNode),(0,o.Ref)(a.HTML));class h extends _.UIElementView{constructor(){super(...arguments),this._element_views=new Map}get elements(){return this.model.elements}get element_views(){return this.elements.map((e=>this._element_views.get(e))).filter((e=>null!=e))}*children(){yield*super.children(),yield*this.element_views}async lazy_initialize(){await super.lazy_initialize(),await this._build_elements()}async _build_elements(){return await(0,m.build_views)(this._element_views,this.elements,{parent:this})}async _update_elements(){const{created:e}=await this._build_elements(),t=new Set(e);for(const e of this.element_views){const n=t.has(e),s=e.rendering_target()??this.self_target;n?e.render_to(s):s.append(e.el)}this.r_after_render()}remove(){(0,m.remove_views)(this._element_views),super.remove()}connect_signals(){super.connect_signals();const{elements:e}=this.model.properties;this.on_change(e,(async()=>{await this._update_elements()}))}render(){super.render();for(const e of this.element_views){const t=e.rendering_target()??this.self_target;e.render_to(t)}}has_finished(){if(!super.has_finished())return!1;for(const e of this.element_views)if(!e.has_finished())return!1;return!0}}n.PaneView=h,h.__name__="PaneView";class d extends _.UIElement{constructor(e){super(e)}}n.Pane=d,r=d,d.__name__="Pane",r.prototype.default_view=h,r.define((({List:e})=>({elements:[e(n.ElementLike),[]]})))},
function _(e,t,r,s,i){var n;s();const o=e(134),a=e(55),l=e(69),d=e(61),c=e(12),f=e(8),_=e(22),h=(0,_.Or)((0,_.Ref)(o.DOMElement),(0,_.Ref)(a.UIElement)),u=_.Str;class p extends o.DOMElementView{constructor(){super(...arguments),this._refs=new Map}get refs(){const{html:e,refs:t}=this.model;return[...(0,f.isArray)(e)?e.filter((e=>!(0,f.isString)(e))):[],...t]}async _update_refs(){await(0,l.build_views)(this._refs,this.refs)}*children(){yield*super.children(),yield*this._refs.values()}async lazy_initialize(){await super.lazy_initialize(),await this._update_refs()}remove(){(0,l.remove_views)(this._refs),super.remove()}connect_signals(){super.connect_signals();const{refs:e,html:t}=this.model.properties;this.on_change([e,t],(async()=>{await this._update_refs(),this.render()}))}render(){super.render();const e=(()=>{const{html:e}=this.model;return(0,f.isArray)(e)?e.map((e=>(0,f.isString)(e)?e:`<ref id="${e.id}"></ref>`)).join(""):e})(),t=(()=>(0,f.isString)(e)?this.parse_html(e):[e])();this.el.append(...t),this.finish()}parse_html(e){const t=(new DOMParser).parseFromString(e,"text/html"),r=t.createNodeIterator(t,NodeFilter.SHOW_ELEMENT,(e=>"ref"==e.nodeName.toLowerCase()?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT));let s;e:for(;null!=(s=r.nextNode());){(0,c.assert)(s instanceof Element);const e=s.getAttribute("id");if(null!=e){for(const[t,r]of this._refs)if(t.id==e){r.render(),s.replaceWith(r.el);continue e}s.replaceWith((0,d.span)(`<not found: id=${e}>`));continue}const t=s.getAttribute("name");if(null==t);else{for(const[e,r]of this._refs)if(e.name==t){r.render(),s.replaceWith(r.el);continue e}s.replaceWith((0,d.span)(`<not found: name=${t}>`))}}return[...t.body.childNodes]}}r.HTMLView=p,p.__name__="HTMLView";class m extends o.DOMElement{constructor(e){super(e)}}r.HTML=m,n=m,m.__name__="HTML",n.prototype.default_view=p,n.define((({Node:e,List:t,Or:r})=>({html:[r(e,u,t(r(u,h)))],refs:[t(h),[]]})))},
function _(e,t,i,s,n){var l;s();const r=e(130),c=e(56),d=e(55),h=e(69),o=e(8),a=e(63),_=e(61);class u extends r.DOMNodeView{constructor(){super(...arguments),this.child_views=new Map}get bbox(){return(0,_.bounding_box)(this.el).relative()}get self_target(){return this.el}*children(){yield*super.children(),yield*this.child_views.values()}async lazy_initialize(){await super.lazy_initialize();const e=this.model.children.filter((e=>!(0,o.isString)(e)));await(0,h.build_views)(this.child_views,e,{parent:this})}remove(){(0,h.remove_views)(this.child_views),super.remove()}connect_signals(){super.connect_signals();const{children:e,style:t}=this.model.properties;this.on_change(e,(async()=>{await this._update_children()})),this.on_change(t,(()=>{this.el.removeAttribute("style"),(0,a.apply_styles)(this.el.style,this.model.style)}))}async _build_children(){const e=this.model.children.filter((e=>!(0,o.isString)(e)));return await(0,h.build_views)(this.child_views,e,{parent:this})}async _update_children(){const{created:e}=await this._build_children(),t=new Set(e);for(const e of this.model.children)if((0,o.isString)(e)){const t=document.createTextNode(e);this.self_target.append(t)}else{const i=this.child_views.get(e);if(null==i)continue;const s=t.has(i),n=i.rendering_target()??this.self_target;s?i.render_to(n):n.append(i.el)}this.r_after_render()}render(){(0,_.empty)(this.el),(0,a.apply_styles)(this.el.style,this.model.style);for(const e of this.model.children)if((0,o.isString)(e)){const t=document.createTextNode(e);this.el.append(t)}else{const t=this.child_views.get(e);if(null==t)continue;const i=t.rendering_target()??this.self_target;t.render_to(i)}this.finish()}}i.DOMElementView=u,u.__name__="DOMElementView";class p extends r.DOMNode{constructor(e){super(e)}}i.DOMElement=p,l=p,p.__name__="DOMElement",l.define((({Str:e,List:t,Or:i,Ref:s})=>({style:[c.StylesLike,{}],children:[t(i(e,s(r.DOMNode),s(d.UIElement))),[]]})))},
function _(a,t,o,e,i){e();var u=a(136);i("Sizeable",u.Sizeable),i("SizingPolicy",u.SizingPolicy);var l=a(137);i("Layoutable",l.Layoutable),i("ContentLayoutable",l.ContentLayoutable),i("ElementLayout",l.ElementLayout),i("TextLayout",l.TextLayout),i("FixedLayout",l.FixedLayout);var n=a(138);i("HStack",n.HStack),i("VStack",n.VStack);var y=a(139);i("Grid",y.Grid),i("Row",y.Row),i("Column",y.Column)},
function _(h,t,i,e,w){e();const n=h(22),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=(0,n.Enum)("fixed","fit","min","max")},
function _(i,t,e,h,s){h();const n=i(136),r=i(62),_=i(8),g=i(12),{abs:o,min:l,max:a,round:d}=Math;class u{constructor(){this.absolute=!1,this.position={left:0,top:0},this._bbox=new r.BBox,this._inner_bbox=new r.BBox,this._sizing=null,this._dirty=!1,this._handlers=[]}*[Symbol.iterator](){}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return(0,g.assert)(null!=this._sizing),this._sizing}set dirty(i){this._dirty=i}get dirty(){return this._dirty}get visible(){return this.sizing.visible}set visible(i){this.sizing.visible!=i&&(this.sizing.visible=i,this._dirty=!0)}set_sizing(i={}){const t=i.width_policy??"fit",e=i.width,h=i.min_width,s=i.max_width,n=i.height_policy??"fit",r=i.height,_=i.min_height,g=i.max_height,o=i.aspect,l=i.margin??{top:0,right:0,bottom:0,left:0},a=i.visible??!0,d=i.halign??"start",u=i.valign??"start";this._sizing={width_policy:t,min_width:h,width:e,max_width:s,height_policy:n,min_height:_,height:r,max_height:g,aspect:o,margin:l,visible:a,halign:d,valign:u,size:{width:e,height:r}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){const{fixup_geometry:e}=this;null!=e&&([i,t]=e(i,t)),this._set_geometry(i,t??i);for(const i of this._handlers)i(this._bbox,this._inner_bbox)}on_resize(i){this._handlers.push(i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:e}){const{aspect:h}=this.sizing;if(null!=h){const{width_policy:s,height_policy:n}=this.sizing,r=(i,t)=>{const e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=d(t/h),r=d(e*h),_=e;o(i.width-s)+o(i.height-n)<=o(i.width-r)+o(i.height-_)?(t=s,e=n):(t=r,e=_)}else r(s,n)?e=d(t/h):t=d(e*h);else"fixed"==s?e=d(t/h):"fixed"==n&&(t=d(e*h))}return{width:t,height:e}}measure(i){if(null==this._sizing&&this.set_sizing(),!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,e=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,h=new n.Sizeable(i).shrink_by(this.sizing.margin).map(t,e),s=this._measure(h),r=this.clip_size(s,h),_=t(r.width),g=e(r.height),o=this.apply_aspect(h,{width:_,height:g});return{...s,...o}}_compute(i){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:e,height:h}=t,{left:s,top:n}=this.position,_=new r.BBox({left:s,top:n,width:e,height:h});let g;if(null!=t.inner){const{left:i,top:s,right:n,bottom:_}=t.inner;g=new r.BBox({left:i,top:s,right:e-n,bottom:h-_})}return{outer:_,inner:g}}compute(i={}){const{outer:t,inner:e}=this._compute(i);this.set_geometry(t,e)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_size(i,t){function e(i,t,e,h){return null==e?e=0:(0,_.isNumber)(e)||(e=d(e.percent*t)),null==h?h=1/0:(0,_.isNumber)(h)||(h=d(h.percent*t)),a(e,l(i,h))}return{width:e(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:e(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}}has_size_changed(){const{_dirty:i}=this;return this._dirty=!1,i}}e.Layoutable=u,u.__name__="Layoutable";class c extends u{_measure(i){const t=this._content_size(),e=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return e.width;case"max":return a(t.width,e.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return e.height;case"max":return a(t.height,e.height)}})()}}}e.ContentLayoutable=c,c.__name__="ContentLayoutable";class w extends c{constructor(i){super(),this.el=i}_content_size(){const{width:i,height:t}=this.el.getBoundingClientRect();return new n.Sizeable({width:i,height:t})}}e.ElementLayout=w,w.__name__="ElementLayout";class x extends c{constructor(i){super(),this.text=i}_content_size(){return new n.Sizeable(this.text.size())}}e.TextLayout=x,x.__name__="TextLayout";class b extends c{constructor(i={}){super(),this.size=i}_content_size(){return new n.Sizeable(this.size)}}e.FixedLayout=b,b.__name__="FixedLayout"},
function _(t,e,h,i,r){i();const s=t(137),o=t(62),{max:n,round:c}=Math;class a extends s.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}}h.Stack=a,a.__name__="Stack";class l extends a{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e+=i.width,h=n(h,i.height)}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t.top:0;let h=this.absolute?t.left:0;const{height:i}=t;for(const t of this.children){const{width:r}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({left:h,width:r,top:e,height:i})),h+=r}}}}h.HStack=l,l.__name__="HStack";class d extends a{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e=n(e,i.width),h+=i.height}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t.left:0;let h=this.absolute?t.top:0;const{width:i}=t;for(const t of this.children){const r=t.measure({width:0,height:0}),{height:s}=r;t.set_geometry(new o.BBox({top:h,height:s,left:e,width:i})),h+=s}}}}h.VStack=d,d.__name__="VStack";class g extends s.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}_measure(t){const{width_policy:e,height_policy:h}=this.sizing,{min:i,max:r}=Math;let s=0,o=0;for(const e of this.children){const{width:h,height:i}=e.measure(t);s=r(s,h),o=r(o,i)}return{width:(()=>{const{width:h}=this.sizing;if(t.width==1/0)return"fixed"==e?h??s:s;switch(e){case"fixed":return h??s;case"min":return s;case"fit":return null!=h?i(t.width,h):t.width;case"max":return null!=h?r(t.width,h):t.width}})(),height:(()=>{const{height:e}=this.sizing;if(t.height==1/0)return"fixed"==h?e??o:o;switch(h){case"fixed":return e??o;case"min":return o;case"fit":return null!=e?i(t.height,e):t.height;case"max":return null!=e?r(t.height,e):t.height}})()}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new o.BBox);else{const e=this.absolute?t:t.relative(),{left:h,right:i,top:r,bottom:s}=e,n=c(e.vcenter),a=c(e.hcenter);for(const e of this.children){const{margin:c,halign:l="start",valign:d="start"}=e.sizing,{width:g,height:u,inner:_}=e.measure(t),w=(()=>{switch(`${d}_${l}`){case"start_start":return new o.BBox({left:h+c.left,top:r+c.top,width:g,height:u});case"start_center":return new o.BBox({hcenter:a,top:r+c.top,width:g,height:u});case"start_end":return new o.BBox({right:i-c.right,top:r+c.top,width:g,height:u});case"center_start":return new o.BBox({left:h+c.left,vcenter:n,width:g,height:u});case"center_center":return new o.BBox({hcenter:a,vcenter:n,width:g,height:u});case"center_end":return new o.BBox({right:i-c.right,vcenter:n,width:g,height:u});case"end_start":return new o.BBox({left:h+c.left,bottom:s-c.bottom,width:g,height:u});case"end_center":return new o.BBox({hcenter:a,bottom:s-c.bottom,width:g,height:u});case"end_end":return new o.BBox({right:i-c.right,bottom:s-c.bottom,width:g,height:u})}})(),m=null==_?w:new o.BBox({left:w.left+_.left,top:w.top+_.top,right:w.right-_.right,bottom:w.bottom-_.bottom});e.set_geometry(w,m)}}}}h.NodeLayout=g,g.__name__="NodeLayout"},
function _(t,i,s,e,o){e();const n=t(136),r=t(137),h=t(8),l=t(62),c=t(10),{max:a,round:p}=Math;class g{constructor(t){this._map=new Map,this.def=t}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}s.DefaultMap=g,g.__name__="DefaultMap";class _{constructor(){this._items=[],this._nrows=0,this._ncols=0}get size(){return this._items.length}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter((({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1)).map((({data:t})=>t))}row(t){return this._items.filter((({span:i})=>i.r0<=t&&t<=i.r1)).map((({data:t})=>t))}col(t){return this._items.filter((({span:i})=>i.c0<=t&&t<=i.c1)).map((({data:t})=>t))}*[Symbol.iterator](){yield*this._items}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new _;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}s.Container=_,_.__name__="Container";class f extends r.Layoutable{*[Symbol.iterator](){for(const{layout:t}of this.items)yield t}constructor(t=[]){super(),this.rows="auto",this.cols="auto",this.spacing=0,this.items=t}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}_init(){super._init();const t=new _;for(const{layout:i,row:s,col:e,row_span:o=1,col_span:n=1}of this.items)if(i.sizing.visible){const r=s,h=e,l=s+o-1,c=e+n-1;t.add({r0:r,c0:h,r1:l,c1:c},i)}const{nrows:i,ncols:s}=t,e=new Array(i);for(let s=0;s<i;s++){const i=(()=>{const t=(0,h.isPlainObject)(this.rows)?this.rows[s]??this.rows["*"]:this.rows;return null==t?{policy:"auto"}:(0,h.isNumber)(t)?{policy:"fixed",height:t}:(0,h.isString)(t)?{policy:t}:t})(),o=i.align??"auto";"fixed"==i.policy?e[s]={policy:"fixed",height:i.height,align:o}:"min"==i.policy?e[s]={policy:"min",align:o}:"fit"==i.policy||"max"==i.policy?e[s]={policy:i.policy,flex:i.flex??1,align:o}:(0,c.some)(t.row(s),(t=>t.is_height_expanding()))?e[s]={policy:"max",flex:1,align:o}:e[s]={policy:"min",align:o}}const o=new Array(s);for(let i=0;i<s;i++){const s=(()=>{const t=(0,h.isPlainObject)(this.cols)?this.cols[i]??this.cols["*"]:this.cols;return null==t?{policy:"auto"}:(0,h.isNumber)(t)?{policy:"fixed",width:t}:(0,h.isString)(t)?{policy:t}:t})(),e=s.align??"auto";"fixed"==s.policy?o[i]={policy:"fixed",width:s.width,align:e}:"min"==s.policy?o[i]={policy:"min",align:e}:"fit"==s.policy||"max"==s.policy?o[i]={policy:s.policy,flex:s.flex??1,align:e}:(0,c.some)(t.col(i),(t=>t.is_width_expanding()))?o[i]={policy:"max",flex:1,align:e}:o[i]={policy:"min",align:e}}const[n,r]=(0,h.isNumber)(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:t,nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:(0,c.sum)(t)+(s-1)*o,width:(0,c.sum)(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:r,rspacing:h,cspacing:l}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const g=new Array(e);for(let t=0;t<e;t++){const i=r[t];g[t]="fixed"==i.policy?i.width:0}const f=new _;i.foreach(((i,s)=>{const{r0:e,c0:_,r1:d,c1:w}=i,m=(d-e)*h,u=(w-_)*l;let y=0;for(let i=e;i<=d;i++)y+=t(i,_).height;y+=m;let x=0;for(let i=_;i<=w;i++)x+=t(e,i).width;x+=u;const z=s.measure({width:x,height:y});f.add(i,{layout:s,size_hint:z});const b=new n.Sizeable(z).grow_by(s.sizing.margin);b.height-=m,b.width-=u;const B=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?b.height-=i.height:B.push(t)}if(b.height>0){const t=p(b.height/B.length);for(const i of B)c[i]=a(c[i],t)}const S=[];for(let t=_;t<=w;t++){const i=r[t];"fixed"==i.policy?b.width-=i.width:S.push(t)}if(b.width>0){const t=p(b.width/S.length);for(const i of S)g[i]=a(g[i],t)}}));return{size:this._measure_totals(c,g),row_heights:c,col_widths:g,size_hints:f}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,h=this._measure_cells(((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}}));let l;l="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;let c,g=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?g+=i.flex:l-=h.row_heights[t]}if(l-=(i-1)*n,0!=g&&l>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=p(l*(i.flex/g));l-=s,h.row_heights[t]=s,g-=i.flex}}else if(l<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-l;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=h.row_heights[o],e=p(s/t);h.row_heights[o]=a(i-e,0),s-=e>i?i:e,t--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;let _=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?_+=i.flex:c-=h.col_widths[t]}if(c-=(s-1)*r,0!=_&&c>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=p(c*(i.flex/_));c-=s,h.col_widths[t]=s,_-=i.flex}}else if(c<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-c;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=h.col_widths[e],o=p(i/t);h.col_widths[e]=a(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:f,col_widths:d,size_hints:w}=this._measure_cells(((t,i)=>({width:h.col_widths[i],height:h.row_heights[t]})));return{size:this._measure_totals(f,d),row_heights:f,col_widths:d,size_hints:w}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:r,col_widths:h,size_hints:c}=this._measure_grid(t),_=this._state.rows.map(((t,i)=>({...t,top:0,height:r[i],get bottom(){return this.top+this.height}}))),f=this._state.cols.map(((t,i)=>({...t,left:0,width:h[i],get right(){return this.left+this.width}}))),d=c.map(((t,i)=>({...i,outer:new l.BBox,inner:new l.BBox})));for(let i=0,e=this.absolute?t.top:this.position.top;i<s;i++){const t=_[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:this.position.left;i<e;i++){const t=f[i];t.left=s,s+=t.width+n}d.foreach((({r0:t,c0:i,r1:s,c1:e},r)=>{const{layout:h,size_hint:c}=r,{sizing:a}=h,{width:g,height:d}=c,w=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=f[e].width;return s}(i,e),m=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=_[e].height;return s}(t,s),u=i==e&&"auto"!=f[i].align?f[i].align:a.halign,y=t==s&&"auto"!=_[t].align?_[t].align:a.valign;let x=f[i].left;"start"==u?x+=a.margin.left:"center"==u?x+=p((w-g)/2):"end"==u&&(x+=w-a.margin.right-g);let z=_[t].top;"start"==y?z+=a.margin.top:"center"==y?z+=p((m-d)/2):"end"==y&&(z+=m-a.margin.bottom-d),r.outer=new l.BBox({left:x,top:z,width:g,height:d})}));const w=_.map((()=>({start:new g((()=>0)),end:new g((()=>0))}))),m=f.map((()=>({start:new g((()=>0)),end:new g((()=>0))})));d.foreach((({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(w[t].start.apply(n.top,(t=>a(t,r.top))),w[s].end.apply(_[s].bottom-n.bottom,(t=>a(t,r.bottom))),m[i].start.apply(n.left,(t=>a(t,r.left))),m[e].end.apply(f[e].right-n.right,(t=>a(t,r.right))))})),d.foreach((({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:r}=o,h=t=>{const i=this.absolute?r:r.relative(),s=i.left+t.left,e=i.top+t.top,o=i.right-t.right,n=i.bottom-t.bottom;return new l.BBox({left:s,top:e,right:o,bottom:n})};if(null!=n.inner){let l=h(n.inner);const c=w[t].start.get(r.top),a=w[s].end.get(_[s].bottom-r.bottom),p=m[i].start.get(r.left),g=m[e].end.get(f[e].right-r.right);try{l=h({top:c,bottom:a,left:p,right:g})}catch{}o.inner=l}else o.inner=r})),d.foreach(((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)}))}}s.Grid=f,f.__name__="Grid";class d extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:0,col:i}))),this.rows="fit"}}s.Row=d,d.__name__="Row";class w extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:i,col:0}))),this.cols="fit"}}s.Column=w,w.__name__="Column"},
function _(t,e,s,a,n){var r;a();const i=t(1),_=t(141),o=t(182),l=t(95),d=t(21),c=t(25),h=t(69),u=t(25),p=i.__importStar(t(19)),v=t(11);class y extends _.DataAnnotationView{*children(){yield*super.children();const{start:t,end:e}=this;null!=t&&(yield t),null!=e&&(yield e)}async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model;null!=t&&(this.start=await(0,h.build_view)(t,{parent:this})),null!=e&&(this.end=await(0,h.build_view)(e,{parent:this}))}set_data(t){super.set_data(t);const e=u.Indices.all_set(this._x_start.length);this.start?.set_data(t,e),this.end?.set_data(t,e)}remove(){this.start?.remove(),this.end?.remove(),super.remove()}map_data(){const{frame:t}=this.plot_view,[e,s]=(()=>{switch(this.model.start_units){case"canvas":return[new c.ScreenArray(this._x_start),new c.ScreenArray(this._y_start)];case"screen":return[t.bbox.xview.v_compute(this._x_start),t.bbox.yview.v_compute(this._y_start)];case"data":return[this.coordinates.x_scale.v_compute(this._x_start),this.coordinates.y_scale.v_compute(this._y_start)]}})(),[a,n]=(()=>{switch(this.model.end_units){case"canvas":return[new c.ScreenArray(this._x_end),new c.ScreenArray(this._y_end)];case"screen":return[t.bbox.xview.v_compute(this._x_end),t.bbox.yview.v_compute(this._y_end)];case"data":return[this.coordinates.x_scale.v_compute(this._x_end),this.coordinates.y_scale.v_compute(this._y_end)]}})();this._sx_start=e,this._sy_start=s,this._sx_end=a,this._sy_end=n;const r=e.length,i=this._angles=new c.ScreenArray(r);for(let t=0;t<r;t++)i[t]=Math.PI/2+(0,v.atan2)([e[t],s[t]],[a[t],n[t]])}_paint_data(t){const{start:e,end:s}=this,{_sx_start:a,_sy_start:n,_sx_end:r,_sy_end:i,_angles:_}=this,{x:o,y:l,width:d,height:c}=this.plot_view.frame.bbox;for(let h=0,u=a.length;h<u;h++)null!=s&&(t.save(),t.translate(r[h],i[h]),t.rotate(_[h]),s.paint(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],n[h]),t.rotate(_[h]+Math.PI),e.paint(t,h),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(o,l,d,c),null!=s&&(t.save(),t.translate(r[h],i[h]),t.rotate(_[h]),s.clip(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],n[h]),t.rotate(_[h]+Math.PI),e.clip(t,h),t.restore()),t.closePath(),t.clip()),t.beginPath(),t.moveTo(a[h],n[h]),t.lineTo(r[h],i[h]),this.visuals.line.apply(t,h),t.restore())}}s.ArrowView=y,y.__name__="ArrowView";class w extends _.DataAnnotation{constructor(t){super(t)}}s.Arrow=w,r=w,w.__name__="Arrow",r.prototype.default_view=y,r.mixins(l.LineVector),r.define((({Ref:t,Nullable:e})=>({x_start:[p.XCoordinateSpec,{field:"x_start"}],y_start:[p.YCoordinateSpec,{field:"y_start"}],start_units:[d.CoordinateUnits,"data"],start:[e(t(o.ArrowHead)),null],x_end:[p.XCoordinateSpec,{field:"x_end"}],y_end:[p.YCoordinateSpec,{field:"y_end"}],end_units:[d.CoordinateUnits,"data"],end:[e(t(o.ArrowHead)),()=>new o.OpenHead]})))},
function _(t,n,e,s,a){var o;s();const i=t(1),c=t(96),_=t(142),r=t(147),l=t(148),h=i.__importStar(t(19));class d extends c.AnnotationView{constructor(){super(...arguments),this._initial_set_data=!1}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),this._rerender()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}_rerender(){this.request_paint()}set_data(t){const n=this;for(const e of this.model)if(e instanceof h.VectorSpec||e instanceof h.ScalarSpec)if(e instanceof h.BaseCoordinateSpec){const s=e.array(t);n[`_${e.attr}`]=s}else{const s=e.uniform(t);n[`${e.attr}`]=s}this.plot_model.use_map&&(null!=n._x&&l.inplace.project_xy(n._x,n._y),null!=n._xs&&l.inplace.project_xsys(n._xs,n._ys));for(const t of this.visuals)t.update()}_paint(t){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this._paint_data(t)}}e.DataAnnotationView=d,d.__name__="DataAnnotationView";class u extends c.Annotation{constructor(t){super(t)}}e.DataAnnotation=u,o=u,u.__name__="DataAnnotation",o.define((({Ref:t})=>({source:[t(_.ColumnarDataSource),()=>new r.ColumnDataSource]})))},
function _(t,e,n,s,r){var i;s();const a=t(20),c=t(143),o=t(16),l=t(12),u=t(10),h=t(31),d=t(9),f=t(8),g=t(145),_=t(144),p=t(146);class y extends p.DataSource{get_array(t){const e=(0,d.dict)(this.data);let n=e.get(t);return null==n?e.set(t,n=[]):(0,f.isArray)(n)||e.set(t,n=Array.from(n)),n}constructor(t){super(t),this.selection_manager=new c.SelectionManager(this)}initialize(){super.initialize(),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect")}get inferred_defaults(){const t=new Map;for(const[e,n]of(0,d.entries)(this.data)){const s=(()=>{if((0,h.is_NDArray)(n))switch(n.dtype){case"bool":return!1;case"uint8":case"int8":case"uint16":case"int16":case"uint32":case"int32":case"float32":case"float64":return 0;case"object":return null}else if((0,f.isArray)(n)&&0!=n.length){const[t]=n;if(null===t)return null;if((0,f.isBoolean)(t))return!1;if((0,f.isNumber)(t))return 0;if((0,f.isString)(t))return"";if((0,f.isArray)(t))return[]}})();void 0!==s&&t.set(e,s)}return t}get(t){const e=this.get_column(t);return(0,l.assert)(null!=e,`unknown column '${t}' in ${this}`),e}set(t,e){(0,d.dict)(this.data).set(t,e)}get_column(t){return(0,d.dict)(this.data).get(t)??null}get_row(t){const e=(0,f.isNumber)(t)?t:t.index,n={};for(const[t,s]of(0,d.entries)(this.data))n[t]=s[e];return n}columns(){return(0,d.keys)(this.data)}get_length(t=!0){const e=(0,u.uniq)((0,d.values)(this.data).map((t=>(0,h.is_NDArray)(t)?t.shape[0]:t.length)));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return a.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){return this.get_length()??0}clear(){const t=(0,d.clone)(this.data),e=(0,d.dict)(t);for(const[t,n]of e){const s=new n.constructor(0);e.set(t,s)}this.data=t}stream(t,e,{sync:n}={}){this.stream_to(this.properties.data,t,e,{sync:n})}patch(t,{sync:e}={}){this.patch_to(this.properties.data,t,{sync:e})}}n.ColumnarDataSource=y,i=y,y.__name__="ColumnarDataSource",i.define((({Ref:t,Dict:e,Unknown:n})=>({default_values:[e(n),{}],selection_policy:[t(g.SelectionPolicy),()=>new g.UnionRenderers]}))),i.internal((({AnyRef:t})=>({inspected:[t(),()=>new _.Selection]})))},
function _(e,t,s,o,c){o();const n=e(144);function i(e){return"GlyphRenderer"==e.model.type}function r(e){return"GraphRenderer"==e.model.type}class l{constructor(e){this.inspectors=new Map,this.source=e}select(e,t,s,o="replace"){const c=[],n=[];for(const t of e)i(t)?c.push(t):r(t)&&n.push(t);let l=!1;for(const e of n){const c=e.model.selection_policy.hit_test(t,e);l=l||e.model.selection_policy.do_selection(c,e.model,s,o)}if(c.length>0){const e=this.source.selection_policy.hit_test(t,c);l=l||this.source.selection_policy.do_selection(e,this.source,s,o)}return l}inspect(e,t){let s=!1;if(i(e)){const o=e.hit_test(t);if(null!=o){s=!o.is_empty();const c=this.get_or_create_inspector(e.model);c.update(o,!0,"replace"),this.source.setv({inspected:c},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(r(e)){const o=e.model.inspection_policy.hit_test(t,e);s=e.model.inspection_policy.do_inspection(o,t,e,!1,"replace")}return s}invert(e){const t=this.source.get_length();null!=t&&(this.source.selected.invert(t),null!=e&&this.get_or_create_inspector(e.model).invert(t))}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new n.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=l,l.__name__="SelectionManager"},
function _(i,e,s,n,t){var c;n();const d=i(52),h=i(10),l=i(9),_=i(22),a=i(13);s.OpaqueIndices=(0,_.Arrayable)(_.Int),s.MultiIndices=(0,_.Mapping)(_.Int,s.OpaqueIndices),s.ImageIndex=(0,_.Struct)({index:_.Int,i:_.Int,j:_.Int,flat_index:_.Int}),s.ImageIndices=(0,_.List)(s.ImageIndex);class u extends d.Model{constructor(i){super(i)}get_view(){return this.view}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.update_through_replacement(i);break;case"toggle":this.update_through_toggle(i);break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i);break;case"xor":this.update_through_symmetric_difference(i)}}invert(i){const e=new Set(this.indices),s=[];for(let n=0;n<i;n++)e.has(n)||s.push(n);this.indices=s}clear(){this.indices=[],this.line_indices=[],this.multiline_indices=new Map,this.image_indices=[],this.view=null,this.selected_glyphs=[]}map(i){return new c({...this.attributes,indices:(0,a.map)(this.indices,i),multiline_indices:new Map((0,a.map)([...this.multiline_indices.entries()],(([e,s])=>[i(e),s]))),image_indices:this.image_indices.map((e=>({...e,index:i(e.index)})))})}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}_union_image_indices(...i){const e=new Map,s=new Map,n=[];for(const t of i)for(const i of t){const{index:t,i:c,j:d}=i,h=e.get(t),l=s.get(t);null!=h&&null!=l?h.has(c)&&l.has(d)||(n.push(i),h.add(c),l.add(d)):(n.push(i),e.set(t,new Set([c])),s.set(t,new Set([d])))}return n}update_through_replacement(i){this.indices=i.indices,this.line_indices=i.line_indices,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices,this.view=i.view,this.selected_glyphs=i.selected_glyphs}update_through_toggle(i){this.indices=(0,h.difference)(i.indices,this.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_union(i){this.indices=(0,h.union)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=(0,h.intersection)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=(0,h.difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}update_through_symmetric_difference(i){this.indices=(0,h.symmetric_difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.image_indices=this._union_image_indices(this.image_indices,i.image_indices),this.view=i.view,this.multiline_indices=(0,l.merge)(i.multiline_indices,this.multiline_indices)}}s.Selection=u,c=u,u.__name__="Selection",c.define({indices:[s.OpaqueIndices,[]],line_indices:[s.OpaqueIndices,[]],multiline_indices:[s.MultiIndices,new Map],image_indices:[s.ImageIndices,[]]}),c.internal((({List:i,AnyRef:e,Nullable:s})=>({selected_glyphs:[i(e()),[]],view:[s(e()),null]})))},
function _(e,t,n,s,o){s();const r=e(52);class c extends r.Model{do_selection(e,t,n,s){return null!=e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(e,n,c,o,t){var a;o();const r=e(52),s=e(144);class l extends r.Model{constructor(e){super(e)}}c.DataSource=l,a=l,l.__name__="DataSource",a.define((({Ref:e})=>({selected:[e(s.Selection),()=>new s.Selection,{readonly:!0}]})))},
function _(a,n,o,e,r){var t;e();const c=a(142);class u extends c.ColumnarDataSource{constructor(a){super(a)}}o.ColumnDataSource=u,t=u,u.__name__="ColumnDataSource",t.define((({Unknown:a,Dict:n,Arrayable:o})=>({data:[n(o(a)),{}]})))},
function _(n,t,e,o,r){o(),e.clip_mercator=function(n,t,e){const[o,r]=_[e];return[h(n,o),g(t,r)]},e.in_bounds=function(n,t){const[e,o]=p[t];return e<n&&n<o},e.project_xy=m,e.project_xsys=function(n,t){const e=g(n.length,t.length),o=new Array(e),r=new Array(e);for(let c=0;c<e;c++){const[e,i]=m(n[c],t[c]);o[c]=e,r[c]=i}return[o,r]};const c=n(1),i=c.__importDefault(n(149)),l=c.__importDefault(n(150)),a=n(25),s=new l.default("GOOGLE"),u=new l.default("WGS84"),f=(0,i.default)(u,s);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:g,max:h}=Math;function m(n,t){const o=g(n.length,t.length),r=(0,a.infer_type)(n,t),c=new r(o),i=new r(o);return e.inplace.project_xy(n,t,c,i),[c,i]}!function(n){function t(n,t,o,r){const c=g(n.length,t.length);o=o??n,r=r??t;for(let i=0;i<c;i++){const c=n[i],l=t[i],[a,s]=e.wgs84_mercator.compute(c,l);o[i]=a,r[i]=s}}n.project_xy=t,n.project_xsys=function(n,e,o,r){const c=g(n.length,e.length);o=o??n,r=r??e;for(let i=0;i<c;i++)t(n[i],e[i],o[i],r[i])}}(e.inplace||(e.inplace={}))},
function _(e,n,t,r,o){r();const a=e(1),i=a.__importDefault(e(150)),c=a.__importDefault(e(176));var u=(0,i.default)("WGS84");function f(e,n,t,r){var o,a,i;return Array.isArray(t)?(o=(0,c.default)(e,n,t,r)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(t.splice(3)):[o.x,o.y,t[2]].concat(t.splice(3)):[o.x,o.y].concat(t.splice(2)):[o.x,o.y]):(a=(0,c.default)(e,n,t,r),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;a[r]=t[r]})),a)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:(0,i.default)(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t,r){return f(e,n,t,r)},inverse:function(t,r){return f(n,e,t,r)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const l=t(1),u=l.__importDefault(t(151)),r=l.__importDefault(t(162)),d=l.__importDefault(t(163)),o=t(171),f=l.__importDefault(t(173)),p=l.__importDefault(t(174)),m=l.__importDefault(t(158)),n=t(175);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=(0,u.default)(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=(0,m.default)(f.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=(0,o.sphere)(a.a,a.b,a.rf,a.ellps,a.sphere),d=(0,o.eccentricity)(l.a,l.b,l.rf,a.R_A),_=(0,n.getNadgrids)(a.nadgrids),c=a.datum||(0,p.default)(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);(0,r.default)(this,a),(0,r.default)(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,n,u,e){u();const f=t(1),i=f.__importDefault(t(152)),a=f.__importDefault(t(159)),o=f.__importDefault(t(154)),l=f.__importDefault(t(158));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=(0,a.default)(t);if(function(t){var r=(0,l.default)(t,"authority");if(r){var n=(0,l.default)(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=(0,l.default)(t,"extension");if(r)return(0,l.default)(r,"proj4")}(r);return n?(0,o.default)(n):r}return function(t){return"+"===t[0]}(t)?(0,o.default)(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=f.__importDefault(t(153)),l=f.__importDefault(t(154)),u=f.__importDefault(t(159));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=(0,l.default)(arguments[1]):o[t]=(0,u.default)(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}(0,a.default)(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a(),o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r:function(t){u.a=u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=(0,l.default)(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=(0,l.default)(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase());return u};const e=t(1),r=t(155),i=e.__importDefault(t(156)),f=e.__importDefault(t(157)),l=e.__importDefault(t(158))},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a(),t.default=function(e,r){if(e[r])return e[r];var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;for(;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]};var o=/[\s_\-\/\(\)]/g},
function _(e,a,t,o,n){o(),t.default=function(e){var a=(0,d.default)(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var n={};return(0,i.sExpr)(a,n),function(e){"GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION;if(e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var n=[e.AXIS[t][0].toLowerCase(),e.AXIS[t][1].toLowerCase()];-1!==n[0].indexOf("north")||("y"===n[0]||"lat"===n[0])&&"north"===n[1]?a+="n":-1!==n[0].indexOf("south")||("y"===n[0]||"lat"===n[0])&&"south"===n[1]?a+="s":-1!==n[0].indexOf("east")||("x"===n[0]||"lon"===n[0])&&"east"===n[1]?a+="e":-1===n[0].indexOf("west")&&("x"!==n[0]&&"lon"!==n[0]||"west"!==n[1])||(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;"GEOGCS"===e.type&&(r=e);r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93"));e.b&&!isFinite(e.b)&&(e.b=e.a);function l(a){return a*(e.to_meter||1)}[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",_],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",_],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",_],["lat0","latitude_of_origin",_],["lat0","standard_parallel_1",_],["lat1","standard_parallel_1",_],["lat2","standard_parallel_2",_],["azimuth","Azimuth"],["alpha","azimuth",_],["srsCode","name"]].forEach((function(a){return t=e,o=a,n=o[0],r=o[1],void(!(n in t)&&r in t&&(t[n]=t[r],3===o.length&&(t[n]=o[2](t[n]))));var t,o,n,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc);e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName?!e.lat_ts&&e.lat0&&"Polar_Stereographic"===e.projName&&(e.lat_ts=e.lat0,e.lat0=_(e.lat0>0?90:-90)):(e.lat0=_(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(n),n};const r=e(1);var l=.017453292519943295;const d=r.__importDefault(e(160)),i=e(161);function _(e){return e*l}},
function _(t,e,r,i,s){i(),r.default=function(t){return new c(t).output()};var h=1,o=/\s/,n=/[A-Za-z]/,a=/[A-Za-z84_]/,u=/[,\]]/,d=/[\d\.E\-\+]/;function c(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=h}c.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;o.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case h:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},c.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(u.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},c.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=h)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=h,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},c.prototype.number=function(t){if(!d.test(t)){if(u.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},c.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},c.prototype.keyword=function(t){if(a.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=h)}if(!u.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},c.prototype.neutral=function(t){if(n.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(d.test(t))return this.word=t,void(this.state=3);if(!u.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},c.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e(),a.add=s,a.get=l,a.start=v;const r=t(1),f=r.__importDefault(t(164)),u=r.__importDefault(t(170));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h(),s.init=f,s.forward=_,s.inverse=M;const e=t(1),r=e.__importDefault(t(165)),n=e.__importDefault(t(166)),l=e.__importDefault(t(168)),u=e.__importDefault(t(169)),o=t(155);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=(0,r.default)(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=(0,l.default)(this.e,a,e);i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=(0,u.default)(this.e,e)))return null}return i=(0,n.default)(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a(),u.default=function(t){return Math.abs(t)<=o.SPI?t:t-(0,_.default)(t)*o.TWO_PI};const e=t(1),o=t(155),_=e.__importDefault(t(167))},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o(),a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o};const c=t(155)},
function _(t,a,n,r,f){r(),n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999};const h=t(155)},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a(),e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u);return{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=(0,c.default)(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}e&&!r&&(r=(1-1/e)*t);(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t);return{a:t,b:r,rf:e,sphere:n}};const f=t(1),i=t(155),u=f.__importStar(t(172)),c=f.__importDefault(t(158))},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk80ign={a:6378249.2,b:6356515,rf:293.4660213,ellipseName:"Clarke 1880 (IGN)"},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var i={};s.default=i,i.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},i.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},i.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},i.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},i.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},i.potsdam={towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},i.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},i.hermannskogel={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},i.militargeographische_institut={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Militar-Geographische Institut"},i.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},i.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},i.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},i.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},i.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},i.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},i.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},i.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},i.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const d=a(155);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r(),n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;e=t.getInt32(8,!0),11!==e&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r),o=function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var o=g(t,r,n),a=f(t,r,o,n),c=Math.round(1+(o.upperLongitude-o.lowerLongitude)/o.longitudeInterval),s=Math.round(1+(o.upperLatitude-o.lowerLatitude)/o.latitudeInterval);i.push({ll:[l(o.lowerLongitude),l(o.lowerLatitude)],del:[l(o.longitudeInterval),l(o.latitudeInterval)],lim:[c,s],count:o.gridNodeCount,cvs:d(a)}),r+=176+16*o.gridNodeCount}return i}(n,i,r),c={header:i,subgrids:o};return u[t]=c,c},n.getNadgrids=function(t){if(void 0===t)return null;return t.split(",").map(o)};var u={};function o(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function l(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[l(t.longitudeShift),l(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function f(t,e,n,r){for(var i=e+176,u=[],o=0;o<n.gridNodeCount;o++){var l={latitudeShift:t.getFloat32(i+16*o,r),longitudeShift:t.getFloat32(i+16*o+4,r),latitudeAccuracy:t.getFloat32(i+16*o+8,r),longitudeAccuracy:t.getFloat32(i+16*o+12,r)};u.push(l)}return u}},
function _(t,e,a,r,u){r(),a.default=function t(e,a,r,u){var m;r=Array.isArray(r)?(0,n.default)(r):{x:r.x,y:r.y,z:r.z,m:r.m};var y=void 0!==r.z;(0,i.default)(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM||t.datum.datum_type===_.PJD_GRIDSHIFT)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM||e.datum.datum_type===_.PJD_GRIDSHIFT)&&"WGS84"!==t.datumCode}(e,a)&&(m=new f.default("WGS84"),r=t(e,m,r,u),e=m);u&&"enu"!==e.axis&&(r=(0,o.default)(e,!1,r));if("longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;e.from_greenwich&&(r.x+=e.from_greenwich);if(!(r=(0,d.default)(e.datum,a.datum,r)))return;a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0});"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0}));if(u&&"enu"!==a.axis)return(0,o.default)(a,!0,r);r&&!y&&delete r.z;return r};const m=t(1),_=t(155),d=m.__importDefault(t(177)),o=m.__importDefault(t(179)),f=m.__importDefault(t(150)),n=m.__importDefault(t(180)),i=m.__importDefault(t(181))},
function _(r,e,t,a,i){a(),t.default=function(r,e,t){if((0,o.compareDatums)(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED);if(i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;t=(0,o.geodeticToGeocentric)(t,i,a),d(r.datum_type)&&(t=(0,o.geocentricToWgs84)(t,r.datum_type,r.datum_params));d(e.datum_type)&&(t=(0,o.geocentricFromWgs84)(t,e.datum_type,e.datum_params));if(t=(0,o.geocentricToGeodetic)(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT){if(0!==s(e,!0,t))return}return t},t.applyGridShift=s;const l=r(1),n=r(155),o=r(178),u=l.__importDefault(r(166));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[];r:for(var o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid)for(var d=u.grid.subgrids,s=0,f=d.length;s<f;s++){var x=d[s],m=(Math.abs(x.del[1])+Math.abs(x.del[0]))/1e4,N=x.ll[0]-m,c=x.ll[1]-m,_=x.ll[0]+(x.lim[0]-1)*x.del[0]+m,g=x.ll[1]+(x.lim[1]-1)*x.del[1]+m;if(!(c>a.y||N>a.x||g<a.y||_<a.x)&&(i=y(a,e,x),!isNaN(i.x)))break r}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=(0,u.default)(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=(0,u.default)(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],c=e.cvs[t][1],_=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+_*x,u.y=v*s+g*f+S*c+_*m,u}},
function _(a,t,r,m,s){m(),r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}n>Math.PI&&(n-=2*Math.PI);return s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h,f=1e-12,I=a.x,F=a.y,H=a.z?a.z:0;if(s=Math.sqrt(I*I+F*F),_=Math.sqrt(I*I+F*F+H*H),s/r<f){if(c=0,_/r<f)return x=u.HALF_PI,h=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(F,I);e=H/_,n=s/_,d=1/Math.sqrt(1-t*(2-t)*n*n),P=n*(1-t)*d,y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(h=s*P+H*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return x=Math.atan(M/Math.abs(z)),{x:c,y:x,z:h}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}};const u=a(155)},
function _(e,a,i,s,n){s(),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,f=i.z||0,u={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=f,n="z"),e.axis[r]){case"e":case"n":u[n]=s;break;case"w":case"s":u[n]=-s;break;case"u":void 0!==i[n]&&(u.z=s);break;case"d":void 0!==i[n]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};n.length>2&&(t.z=n[2]);n.length>3&&(t.m=n[3]);return t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,s,t,o){var l,a,n,c,r;t();const _=e(1),p=e(183),d=e(95),T=_.__importStar(e(19));class h extends p.MarkingView{}s.ArrowHeadView=h,h.__name__="ArrowHeadView";class v extends p.Marking{constructor(e){super(e)}}s.ArrowHead=v,l=v,v.__name__="ArrowHead",l.define((()=>({size:[T.NumberSpec,25]})));class m extends h{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,0),e.lineTo(.5*s,s)}paint(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),this.visuals.line.apply(e,i)}}s.OpenHeadView=m,m.__name__="OpenHeadView";class u extends v{constructor(e){super(e)}}s.OpenHead=u,a=u,u.__name__="OpenHead",a.prototype.default_view=m,a.mixins(d.LineVector);class V extends h{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(.5*s,s)}paint(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.hatch.apply(e,i),this.visuals.line.apply(e,i)}}s.NormalHeadView=V,V.__name__="NormalHeadView";class H extends v{constructor(e){super(e)}}s.NormalHead=H,n=H,H.__name__="NormalHead",n.prototype.default_view=V,n.mixins([d.LineVector,d.FillVector,d.HatchVector]),n.override({fill_color:"black"});class w extends h{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.lineTo(.5*s,s)}paint(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.hatch.apply(e,i),this.visuals.line.apply(e,i)}}s.VeeHeadView=w,w.__name__="VeeHeadView";class x extends v{constructor(e){super(e)}}s.VeeHead=x,c=x,x.__name__="VeeHead",c.prototype.default_view=w,c.mixins([d.LineVector,d.FillVector,d.HatchVector]),c.override({fill_color:"black"});class g extends h{paint(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,0),e.lineTo(-.5*s,0),this.visuals.line.apply(e,i)}clip(e,i){}}s.TeeHeadView=g,g.__name__="TeeHeadView";class y extends v{constructor(e){super(e)}}s.TeeHead=y,r=y,y.__name__="TeeHead",r.prototype.default_view=g,r.mixins(d.LineVector)},
function _(t,e,n,i,s){var a;i();const r=t(1),o=t(52),c=t(64),_=r.__importStar(t(99)),p=r.__importStar(t(19));class u extends c.DOMComponentView{initialize(){super.initialize(),this.visuals=new _.Visuals(this)}request_paint(){this.parent.request_paint()}get canvas(){return this.parent.canvas}set_data(t,e){const n=this;for(const i of this.model){if(!(i instanceof p.VectorSpec||i instanceof p.ScalarSpec))continue;const s=i.uniform(t).select(e);n[`${i.attr}`]=s}}}n.MarkingView=u,u.__name__="MarkingView";class l extends o.Model{constructor(t){super(t)}}n.Marking=l,a=l,l.__name__="Marking",a.define((({})=>({})))},
function _(t,e,i,o,a){var r;o();const n=t(1),_=t(96),s=t(185),l=t(198),h=t(202),c=t(207),p=t(204),u=t(213),m=t(205),d=t(256),f=t(206),g=t(269),w=t(271),b=t(188),y=t(21),x=n.__importStar(t(95)),v=t(135),k=t(138),j=t(272),z=t(187),B=t(69),S=t(62),L=t(8);class T extends _.AnnotationView{get orientation(){return this._orientation}*children(){yield*super.children(),yield this._axis_view,yield this._title_view}initialize(){super.initialize();const{ticker:t,formatter:e}=this.model;this._ticker="auto"!=t?t:this._create_ticker(),this._formatter="auto"!=e?e:this._create_formatter(),this._major_range=this._create_major_range(),this._major_scale=this._create_major_scale(),this._minor_range=new w.Range1d({start:0,end:1}),this._minor_scale=new g.LinearScale,this._frame=new l.CartesianFrame({x_scale:this._major_scale,y_scale:this._minor_scale,x_range:this._major_range,y_range:this._minor_range}),this._axis=this._create_axis(),this._apply_axis_properties(),this._title=new s.Title,this._apply_title_properties()}async lazy_initialize(){await super.lazy_initialize();const t=this,e={get parent(){return t.parent},get root(){return t.root},get frame(){return t._frame_view},get frame_view(){return t._frame_view},get canvas_view(){return t.parent.canvas_view},request_layout(){t.layout.dirty=!0,t.parent.request_layout()},request_paint(){t.parent.request_paint(t)},notify_finished_after_paint(){t.parent.notify_finished_after_paint()}};this._frame_view=await(0,B.build_view)(this._frame,{parent:e}),this._axis_view=await(0,B.build_view)(this._axis,{parent:e}),this._title_view=await(0,B.build_view)(this._title,{parent:e})}remove(){this._title_view.remove(),this._axis_view.remove(),super.remove()}_apply_axis_properties(){const t={ticker:this._ticker,formatter:this._formatter,major_label_standoff:this.model.label_standoff,axis_line_color:null,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,...x.attrs_of(this.model,"major_label_",x.Text,!0),...x.attrs_of(this.model,"major_tick_",x.Line,!0),...x.attrs_of(this.model,"minor_tick_",x.Line,!0)};this._axis.setv(t)}_apply_title_properties(){const t={text:this.model.title??"",standoff:this.model.title_standoff,...x.attrs_of(this.model,"title_",x.Text,!1)};this._title.setv(t)}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this._apply_title_properties(),this._apply_axis_properties()})),this.connect(this._ticker.change,(()=>this.request_paint())),this.connect(this._formatter.change,(()=>this.request_paint()))}_update_frame(){const[t,e,i,o]=(()=>"horizontal"==this.orientation?[this._major_scale,this._minor_scale,this._major_range,this._minor_range]:[this._minor_scale,this._major_scale,this._minor_range,this._major_range])();this._frame.setv({x_scale:t,y_scale:e,x_range:i,y_range:o})}update_layout(){const{location:t,width:e,height:i,padding:o,margin:a}=this.model,[r,n]=(()=>{if(!(0,L.isString)(t))return["end","start"];switch(t){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}})(),_=this._orientation=(()=>{const{orientation:t}=this.model;return"auto"==t?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==n||"end"==n||"center"==r?"vertical":"horizontal":t})();this._update_frame();const s=new k.NodeLayout,l=new k.VStack,h=new k.VStack,c=new k.HStack,p=new k.HStack;s.absolute=!0,l.absolute=!0,h.absolute=!0,c.absolute=!0,p.absolute=!0,s.on_resize((t=>this._frame_view.set_geometry(t)));const u=new j.BorderLayout;this._inner_layout=u,u.absolute=!0,u.center_panel=s,u.top_panel=l,u.bottom_panel=h,u.left_panel=c,u.right_panel=p;const m={left:o,right:o,top:o,bottom:o},d=(()=>{if(null==this.panel){if((0,L.isString)(t))return{left:a,right:a,top:a,bottom:a};{const[e,i]=t;return{left:e,right:a,top:a,bottom:i}}}if(!(0,L.isString)(t)){const[e,i]=t;return u.fixup_geometry=(t,o)=>{const a=t,r=this.layout.bbox,{width:n,height:_}=t;if(t=new S.BBox({left:r.left+e,bottom:r.bottom-i,width:n,height:_}),null!=o){const e=t.left-a.left,i=t.top-a.top,{left:r,top:n,width:_,height:s}=o;o=new S.BBox({left:r+e,top:n+i,width:_,height:s})}return[t,o]},{left:e,right:0,top:0,bottom:i}}u.fixup_geometry=(t,e)=>{const i=t;if("horizontal"==_){const{top:e,width:i,height:o}=t;if("end"==n){const{right:a}=this.layout.bbox;t=new S.BBox({right:a,top:e,width:i,height:o})}else if("center"==n){const{hcenter:a}=this.layout.bbox;t=new S.BBox({hcenter:Math.round(a),top:e,width:i,height:o})}}else{const{left:e,width:i,height:o}=t;if("end"==r){const{bottom:a}=this.layout.bbox;t=new S.BBox({left:e,bottom:a,width:i,height:o})}else if("center"==r){const{vcenter:a}=this.layout.bbox;t=new S.BBox({left:e,vcenter:Math.round(a),width:i,height:o})}}if(null!=e){const o=t.left-i.left,a=t.top-i.top,{left:r,top:n,width:_,height:s}=e;e=new S.BBox({left:r+o,top:n+a,width:_,height:s})}return[t,e]}})();let f,g,w,b;if(u.padding=m,null!=this.panel)f="max",g=void 0,w=void 0,b=void 0;else if("auto"==("horizontal"==_?e:i)){f="fixed";const t=this._get_major_size_factor();null!=t&&(g=25*t),w={percent:.3},b={percent:.8}}else f="fit",g=void 0;if("horizontal"==_){const t="auto"==e?void 0:e,o="auto"==i?25:i;u.set_sizing({width_policy:f,height_policy:"min",width:g,min_width:w,max_width:b,halign:n,valign:r,margin:d}),u.center_panel.set_sizing({width_policy:"auto"==e?"fit":"fixed",height_policy:"fixed",width:t,height:o})}else{const t="auto"==e?25:e,o="auto"==i?void 0:i;u.set_sizing({width_policy:"min",height_policy:f,height:g,min_height:w,max_height:b,halign:n,valign:r,margin:d}),u.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==i?"fit":"fixed",width:t,height:o})}l.set_sizing({width_policy:"fit",height_policy:"min"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),c.set_sizing({width_policy:"min",height_policy:"fit"}),p.set_sizing({width_policy:"min",height_policy:"fit"});const{_title_view:y}=this;"horizontal"==_?(y.panel=new z.SidePanel("above"),y.update_layout(),l.children.push(y.layout)):(y.panel=new z.SidePanel("left"),y.update_layout(),c.children.push(y.layout));const{panel:x}=this,B=null!=x&&_==x.orientation?x.side:"horizontal"==_?"below":"right",T=(()=>{switch(B){case"above":return l;case"below":return h;case"left":return c;case"right":return p}})(),{_axis_view:q}=this;if(q.panel=new z.SidePanel(B),q.update_layout(),null!=q.layout&&T.children.push(q.layout),null!=this.panel){const t=new v.Grid([{layout:u,row:0,col:0}]);t.absolute=!0,"horizontal"==_?t.set_sizing({width_policy:"max",height_policy:"min"}):t.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=t}else this.layout=this._inner_layout;const{visible:A}=this.model;this.layout.sizing.visible=A}_create_axis(){return new c.LinearAxis}_create_formatter(){return new d.BasicTickFormatter}_create_major_range(){return new w.Range1d({start:0,end:1})}_create_major_scale(){return new g.LinearScale}_create_ticker(){return new u.BasicTicker}_get_major_size_factor(){return null}_paint(t){t.save(),this._paint_bbox(t,this._inner_layout.bbox),this._paint_colors(t,this._inner_layout.center_panel.bbox),this._title_view.paint(t),this._axis_view.paint(t),t.restore()}_paint_bbox(t,e){const{x:i,y:o}=e;let{width:a,height:r}=e;i+a>=this.parent.canvas_view.bbox.width&&(a-=1),o+r>=this.parent.canvas_view.bbox.height&&(r-=1),t.save(),t.beginPath(),t.rect(i,o,a,r),this.visuals.background_fill.apply(t),this.visuals.background_hatch.apply(t),this.visuals.border_line.apply(t),t.restore()}}i.BaseColorBarView=T,T.__name__="BaseColorBarView";class q extends _.Annotation{constructor(t){super(t)}}i.BaseColorBar=q,r=q,q.__name__="BaseColorBar",r.mixins([["major_label_",x.Text],["title_",x.Text],["major_tick_",x.Line],["minor_tick_",x.Line],["border_",x.Line],["bar_",x.Line],["background_",x.Fill],["background_",x.Hatch]]),r.define((({Float:t,Str:e,Tuple:i,Or:o,Ref:a,Auto:r,Nullable:n})=>({location:[o(y.Anchor,i(t,t)),"top_right"],orientation:[o(y.Orientation,r),"auto"],title:[n(o(e,a(b.BaseText))),null],title_standoff:[t,2],width:[o(t,r),"auto"],height:[o(t,r),"auto"],ticker:[o(a(p.Ticker),r),"auto"],formatter:[o(a(m.TickFormatter),r),"auto"],major_label_overrides:[h.LabelOverrides,new Map],major_label_policy:[a(f.LabelingPolicy),()=>new f.NoOverlap],label_standoff:[t,5],margin:[t,30],padding:[t,10],major_tick_in:[t,5],major_tick_out:[t,0],minor_tick_in:[t,0],minor_tick_out:[t,0]}))),r.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,t,i,a,s){var o;a();const r=e(1),n=e(186),c=e(21),l=r.__importStar(e(127));class h extends n.TextAnnotationView{_get_position(){const e=this.model.offset,t=this.model.standoff/2,{align:i,vertical_align:a}=this.model;let s,o;const{bbox:r}=this.layout;switch(this.panel.side){case"above":case"below":switch(a){case"top":o=r.top+t;break;case"middle":o=r.vcenter;break;case"bottom":o=r.bottom-t}switch(i){case"left":s=r.left+e;break;case"center":s=r.hcenter;break;case"right":s=r.right-e}break;case"left":switch(a){case"top":s=r.left+t;break;case"middle":s=r.hcenter;break;case"bottom":s=r.right-t}switch(i){case"left":o=r.bottom-e;break;case"center":o=r.vcenter;break;case"right":o=r.top+e}break;case"right":switch(a){case"top":s=r.right-t;break;case"middle":s=r.hcenter;break;case"bottom":s=r.left+t}switch(i){case"left":o=r.top+e;break;case"center":o=r.vcenter;break;case"right":o=r.bottom-e}}return{sx:s,sy:o}}get anchor(){const{align:e,vertical_align:t}=this.model;return l.text_anchor("auto",e,t)}get origin(){return this._get_position()}get angle(){return this.panel.get_label_angle_heuristic("parallel")}_get_size(){const e=e=>0==e?0:2+e+this.model.standoff,{width:t,height:i}=super._get_size();return this.panel.is_horizontal?{width:t,height:e(i)}:{width:e(t),height:i}}}i.TitleView=h,h.__name__="TitleView";class _ extends n.TextAnnotation{constructor(e){super(e)}}i.Title=_,o=_,_.__name__="Title",o.prototype.default_view=h,o.define((({Float:e})=>({vertical_align:[c.VerticalAlign,"bottom"],align:[c.TextAlign,"left"],offset:[e,0],standoff:[e,10]}))),o.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1})},
function _(t,i,e,s,n){var a;s();const r=t(1),o=t(96),d=t(187),_=t(188),h=t(69),l=t(8),c=t(189),u=t(124),g=r.__importStar(t(127)),p=t(62),x=t(197),w=r.__importStar(t(95));class y extends o.AnnotationView{*children(){yield*super.children(),yield this._text_view}async lazy_initialize(){await super.lazy_initialize(),await this._init_text()}async _init_text(){const{text:t}=this.model,i=(0,l.isString)(t)?(0,c.parse_delimited_string)(t):t;this._text_view=await(0,h.build_view)(i,{parent:this})}update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size()),!1):void 0}connect_signals(){super.connect_signals();const{text:t}=this.model.properties;this.on_change(t,(async()=>{this._text_view.remove(),await this._init_text()})),this.connect(this.model.change,(()=>this.request_paint()))}remove(){this._text_view.remove(),super.remove()}has_finished(){return!!super.has_finished()&&!!this._text_view.has_finished()}get displayed(){return super.displayed&&""!=this._text_view.model.text&&this.visuals.text.doit}get padding(){return g.padding(this.model.padding)}get border_radius(){return g.border_radius(this.model.border_radius)}_get_size(){if(!this.displayed)return{width:0,height:0};const t=this._text_view.graphics();t.angle=this.angle,t.align="auto",t.visuals=this.visuals.text.values();const i=t.size(),{padding:e}=this;return{width:i.width+e.left+e.right,height:i.height+e.top+e.bottom}}compute_geometry(){super.compute_geometry();const t=this._text_view.graphics();t.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},t.angle=0,t.align="auto",t.visuals=this.visuals.text.values();const i=t.size(),{sx:e,sy:s}=this.origin,{anchor:n,padding:a,border_radius:r,angle:o}=this,d=i.width+a.left+a.right,_=i.height+a.top+a.bottom;this._text_box=t,this._rect={sx:e,sy:s,width:d,height:_,angle:o,anchor:n,padding:a,border_radius:r}}_paint(t){const{sx:i,sy:e,width:s,height:n,angle:a,anchor:r,padding:o,border_radius:d}=this._rect,_=this._text_box,h=r.x*s,l=r.y*n;t.translate(i,e),t.rotate(a),t.translate(-h,-l);const{background_fill:c,background_hatch:u,border_line:g,text:w}=this.visuals;if(c.doit||u.doit||g.doit){t.beginPath();const i=new p.BBox({x:0,y:0,width:s,height:n});(0,x.round_rect)(t,i,d),c.apply(t),u.apply(t),g.apply(t)}if(w.doit){const{left:i,top:e}=o;t.translate(i,e),_.paint(t),t.translate(-i,-e)}t.translate(h,l),t.rotate(-a),t.translate(-i,-e)}}e.TextAnnotationView=y,y.__name__="TextAnnotationView";class v extends o.Annotation{constructor(t){super(t)}}e.TextAnnotation=v,a=v,v.__name__="TextAnnotation",a.mixins([w.Text,["border_",w.Line],["background_",w.Fill],["background_",w.Hatch]]),a.define((({Str:t,Or:i,Ref:e})=>({text:[i(t,e(_.BaseText)),""],padding:[u.Padding,0],border_radius:[u.BorderRadius,0]}))),a.override({border_line_color:null,background_fill_color:null})},
function _(t,e,i,l,a){l();const r=t(136),o=t(137),n=t(8),s=Math.PI/2,h={above:{parallel:0,normal:-s,horizontal:0,vertical:-s},below:{parallel:0,normal:s,horizontal:0,vertical:s},left:{parallel:-s,normal:0,horizontal:0,vertical:-s},right:{parallel:s,normal:0,horizontal:0,vertical:s}},c={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},_={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},g={above:"right",below:"left",left:"right",right:"left"},b={above:"left",below:"right",left:"right",right:"left"};class d{constructor(t,e){this.side=t,this.face=(()=>{if(null!=e&&"auto"!=e)return e;switch(this.side){case"left":case"above":return"front";case"right":case"below":return"back"}})(),this.dimension="above"==this.side||"below"==this.side?0:1,this.orientation=0==this.dimension?"horizontal":"vertical",this.is_horizontal=0==this.dimension,this.is_vertical=1==this.dimension,this.normals=(()=>{const t="front"==this.face?-1:1;switch(this.side){case"left":case"right":return[t,0];case"above":case"below":return[0,t]}})()}get face_adjusted_side(){const{side:t,face:e}=this;switch(t){case"left":case"right":return"front"==e?"left":"right";case"above":case"below":return"front"==e?"above":"below"}}get_label_text_heuristics(t){const e=this.face_adjusted_side;return(0,n.isString)(t)?{vertical_align:c[e][t],align:_[e][t]}:{vertical_align:"center",align:(t<0?g:b)[e]}}get_label_angle_heuristic(t){if((0,n.isString)(t)){const e=this.face_adjusted_side;return h[e][t]}return-t}}i.SidePanel=d,d.__name__="SidePanel";class f extends o.ContentLayoutable{constructor(t,e,i=!1){super(),this.panel=t,this.get_size=e,this.rotate=i,this.panel.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){const{width:t,height:e}=this.get_size();return!this.rotate||this.panel.is_horizontal?new r.Sizeable({width:t,height:e}):new r.Sizeable({width:e,height:t})}has_size_changed(){const{width:t,height:e}=this._content_size();return this.panel.is_horizontal?this.bbox.height!=e:this.bbox.width!=t}}i.SideLayout=f,f.__name__="SideLayout"},
function _(e,s,t,a,n){var _;a();const x=e(52),c=e(65);class i extends c.View{}t.BaseTextView=i,i.__name__="BaseTextView";class o extends x.Model{constructor(e){super(e)}}t.BaseText=o,_=o,o.__name__="BaseText",_.define((({Str:e})=>({text:[e]})))},
function _(n,e,t,i,r){i(),t.parse_delimited_string=function(n){const e=[];for(const t of c){const i=d(t.start),r=d(t.end),o=new RegExp(`${i}([^]*?)${r}`,"gm");for(const i of n.matchAll(o)){const{index:n}=i,[r,o]=i;e.push({index:n,outer:r,inner:o,delim:t})}}if(e.length>0){if(1==e.length){const[t]=e,i=t.index,r=t.outer.length;if(0==i&&r==n.length){const n=t.inner;return new o.TeX({text:n,inline:t.delim.inline})}}let t="",i=0;for(const r of(0,s.sort_by)(e,(n=>n.index))){const e=r.index;i<=e&&(t+=0!=e?`\\text{${n.slice(i,e)}}${r.inner}`:`${r.inner}`,i=e+r.outer.length)}return t+=i<n.length?`\\text{${n.slice(i)}}`:"",new o.TeX({text:t,inline:!1})}return new l.PlainText({text:n})};const o=n(190),l=n(196),s=n(10),c=[{start:"$$",end:"$$",inline:!1},{start:"\\[",end:"\\]",inline:!1},{start:"\\(",end:"\\)",inline:!0}];function d(n){return n.split("").map((n=>`\\${n}`)).join("")}},
function _(t,e,s,i,n){var h,o,r;i();const a=t(9),_=t(8),l=t(191),c=t(23),d=t(192),u=t(193),g=t(41),x=t(73),f=t(62),p=t(188),m=t(194);class y extends p.BaseTextView{constructor(){super(...arguments),this._position={sx:0,sy:0},this.align="left",this._x_anchor="left",this._y_anchor="center",this._base_font_size=13,this.font_size_scale=1,this.svg_image=null}graphics(){return this}infer_text_height(){return"ascent_descent"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}_rect(){const{width:t,height:e}=this._size(),{x:s,y:i}=this._computed_position();return new f.BBox({x:s,y:i,width:t,height:e}).rect}set position(t){this._position=t}get position(){return this._position}get text(){return this.model.text}get provider(){return m.default_provider}async lazy_initialize(){await super.lazy_initialize(),"not_started"==this.provider.status&&await this.provider.fetch()}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.text,(()=>this.load_image()))}set visuals(t){const e=t.color,s=t.alpha,i=t.font_style;let n=t.font_size;const h=t.font,{font_size_scale:o,_base_font_size:r}=this,a=(0,u.parse_css_font_size)(n);if(null!=a){let{value:t,unit:e}=a;t*=o,"em"==e&&0!=r&&(t*=r,e="px"),n=`${t}${e}`}const _=`${i} ${n} ${h}`;this.font=_,this.color=(0,c.color2css)(e,s);const l=t.align;this._x_anchor=l;const d=t.baseline;this._y_anchor=(()=>{switch(d){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position,o=(0,u.font_metrics)(this.font);return{x:s-(()=>{if((0,_.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,_.isNumber)(h))return h*e;switch(h){case"top":return o.height>e?e-(-this.valign-o.descent)-o.height:0;case"center":case"baseline":return.5*e;case"bottom":return o.height>e?e+o.descent+this.valign:e}})()}}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(null==s||0==s)return{width:t,height:e};{const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}}get_image_dimensions(){const t=(0,u.font_metrics)(this.font),e=this.svg_element.getAttribute("style")?.split(";");if(null!=e){const s=new Map;e.forEach((t=>{const[e,i]=t.split(":");""!=e.trim()&&s.set(e.trim(),i.trim())}));const i=(0,u.parse_css_length)(s.get("vertical-align"));"ex"==i?.unit?this.valign=i.value*t.x_height:"px"==i?.unit&&(this.valign=i.value)}const s=(()=>{const t=this.svg_element.getAttribute("width"),e=this.svg_element.getAttribute("height");return{width:null!=t&&t.endsWith("ex")?parseFloat(t):1,height:null!=e&&e.endsWith("ex")?parseFloat(e):1}})();return{width:t.x_height*s.width,height:t.x_height*s.height}}get truncated_text(){return this.model.text.length>6?`${this.model.text.substring(0,6)}...`:this.model.text}_size(){if(null==this.svg_image)return"failed"==this.provider.status||"not_started"==this.provider.status?{width:(0,d.text_width)(this.truncated_text,this.font),height:(0,u.font_metrics)(this.font).height}:{width:this._base_font_size,height:this._base_font_size};const t=(0,u.font_metrics)(this.font);let{width:e,height:s}=this.get_image_dimensions();s=Math.max(s,t.height);return{width:e*("%"==this.width?.unit?this.width.value:1),height:s*("%"==this.height?.unit?this.height.value:1)}}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),h=Math.min(t.y,e.y,s.y,i.y),o=Math.max(t.x,e.x,s.x,i.x),r=Math.max(t.y,e.y,s.y,i.y);return new f.BBox({left:n,right:o,top:h,bottom:r})}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:s,sy:i}=this.position,n=new x.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}async request_image(){if(null==this.provider.MathJax)return;const t=this._process_text();if(null==t)return void(this._has_finished=!0);const e=t.children[0];this.svg_element=e,e.setAttribute("font",this.font),e.setAttribute("stroke",this.color);const s=e.outerHTML,i=`data:image/svg+xml;utf-8,${encodeURIComponent(s)}`;this.svg_image=await(0,l.load_image)(i)}async load_image(){await this.request_image(),this.parent.request_layout()}paint(t){null==this.svg_image&&("not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>this.load_image())),"loaded"==this.provider.status&&this.load_image()),t.save();const{sx:e,sy:s}=this.position,{angle:i}=this;null!=i&&0!=i&&(t.translate(e,s),t.rotate(i),t.translate(-e,-s));const{x:n,y:h}=this._computed_position();if(null!=this.svg_image){const{width:e,height:s}=this.get_image_dimensions();t.drawImage(this.svg_image,n,h,e,s)}else"failed"!=this.provider.status&&"not_started"!=this.provider.status||(t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.truncated_text,n,h+(0,u.font_metrics)(this.font).ascent));t.restore(),this._has_finished||"failed"!=this.provider.status&&null==this.svg_image||(this._has_finished=!0,this.parent.notify_finished_after_paint())}}s.MathTextView=y,y.__name__="MathTextView";class v extends p.BaseText{constructor(t){super(t)}}s.MathText=v,v.__name__="MathText";class b extends y{get styled_text(){return this.text}_process_text(){}_size(){return{width:(0,d.text_width)(this.text,this.font),height:(0,u.font_metrics)(this.font).height}}paint(t){t.save();const{sx:e,sy:s}=this.position,{angle:i}=this;null!=i&&0!=i&&(t.translate(e,s),t.rotate(i),t.translate(-e,-s));const{x:n,y:h}=this._computed_position();t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.text,n,h+(0,u.font_metrics)(this.font).ascent),t.restore(),this._has_finished=!0,this.parent.notify_finished_after_paint()}}s.AsciiView=b,b.__name__="AsciiView";class w extends v{constructor(t){super(t)}}s.Ascii=w,h=w,w.__name__="Ascii",h.prototype.default_view=b;class M extends y{get styled_text(){let t=this.text.trim(),e=t.match(/<math(.*?[^?])?>/s);return null==e?this.text.trim():(t=(0,g.insert_text_on_position)(t,t.indexOf(e[0])+e[0].length,`<mstyle displaystyle="true" mathcolor="${(0,c.color2hexrgb)(this.color)}" ${this.font.includes("bold")?'mathvariant="bold"':""}>`),e=t.match(/<\/[^>]*?math.*?>/s),null==e?this.text.trim():(0,g.insert_text_on_position)(t,t.indexOf(e[0]),"</mstyle>"))}_process_text(){const t=(0,u.font_metrics)(this.font);return this.provider.MathJax?.mathml2svg(this.styled_text,{em:this.base_font_size,ex:t.x_height})}}s.MathMLView=M,M.__name__="MathMLView";class z extends v{constructor(t){super(t)}}s.MathML=z,o=z,z.__name__="MathML",o.prototype.default_view=M;class T extends y{get styled_text(){const[t,e,s]=(0,c.color2rgba)(this.color);return`\\color[RGB]{${t}, ${e}, ${s}} ${this.font.includes("bold")?`\\boldsymbol{${this.text}}`:this.text}`}_process_text(){const t=(0,u.font_metrics)(this.font);return this.provider.MathJax?.tex2svg(this.styled_text,{display:!this.model.inline,em:this.base_font_size,ex:t.x_height},(0,a.to_object)(this.model.macros))}}s.TeXView=T,T.__name__="TeXView";class $ extends v{constructor(t){super(t)}}s.TeX=$,r=$,$.__name__="TeX",r.prototype.default_view=T,r.define((({Bool:t,Float:e,Str:s,Dict:i,Tuple:n,Or:h})=>({macros:[i(h(s,n(s,e))),{}],inline:[t,!1]})))},
function _(i,e,t,s,n){s(),t.load_image=async function(i,e){return new o(i,e).promise};const a=i(20);class o{constructor(i,e={}){this.image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e,n=(()=>{if(i instanceof ArrayBuffer){const e=new Blob([i],{type:"image/png"});return URL.createObjectURL(e)}return i})();this.promise=new Promise(((i,o)=>{this.image.crossOrigin="anonymous";let r=0;this.image.onerror=()=>{if(++r==t){const i=`unable to load ${n} image after ${t} attempts`;if(a.logger.warn(i),null==this.image.crossOrigin)return void e.failed?.();a.logger.warn(`attempting to load ${n} without a cross origin policy`),this.image.crossOrigin=null,r=0}setTimeout((()=>this.image.src=n),s)},this.image.onload=()=>{this._finished=!0,e.loaded?.(this.image),i(this.image)},this.image.src=n}))}get finished(){return this._finished}}t.ImageLoader=o,o.__name__="ImageLoader"},
function _(t,e,s,i,n){i();const h=t(62),o=t(193),a=t(10),r=t(8),c=t(73),_=t(23);s.text_width=(()=>{const t=document.createElement("canvas").getContext("2d");let e="";return(s,i)=>(i!=e&&(e=i,t.font=i),t.measureText(s).width)})();class l{constructor(){this._position={sx:0,sy:0},this.font_size_scale=1,this.align="left",this._base_font_size=13,this._x_anchor="left",this._y_anchor="center"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}set position(t){this._position=t}get position(){return this._position}infer_text_height(){return"ascent_descent"}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),a=Math.max(t.x,e.x,s.x,i.x),r=Math.max(t.y,e.y,s.y,i.y);return new h.BBox({left:n,right:a,top:o,bottom:r})}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(null==s||0==s)return{width:t,height:e};{const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:s,sy:i}=this.position,n=new c.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}}s.GraphicsBox=l,l.__name__="GraphicsBox";class x extends l{set visuals(t){const e=t.color,s=t.alpha,i=t.outline_color,n=t.font_style;let h=t.font_size;const a=t.font,{font_size_scale:r,base_font_size:c}=this,l=(0,o.parse_css_font_size)(h);if(null!=l){let{value:t,unit:e}=l;t*=r,"em"==e&&0!=c&&(t*=c,e="px"),h=`${t}${e}`}const x=`${n} ${h} ${a}`;this.font=x,this.color=(0,_.color2css)(e,s),this.outline_color=(0,_.color2css)(i,s),this.line_height=t.line_height;const u=t.align;this._visual_align=u,this._x_anchor=u;const p=t.baseline;this._y_anchor=(()=>{switch(p){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}constructor({text:t}){super(),this._visual_align="left",this.text=t}infer_text_height(){if(this.text.includes("\n"))return"ascent_descent";{function t(t){for(const e of new Set(t))if(!("0"<=e&&e<="9"))switch(e){case",":case".":case"+":case"-":case"\u2212":case"e":continue;default:return!1}return!0}return t(this.text)?"cap":"ascent_descent"}}_text_line(t){const e=this.text_height_metric??this.infer_text_height(),s=(()=>{switch(e){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}})(),i=(()=>{switch(e){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}})();return{height:s+i,ascent:s,descent:i}}get nlines(){return this.text.split("\n").length}_size(){const{font:t}=this,e=(0,o.font_metrics)(t),i=(this.line_height-1)*e.height,n=""==this.text,h=this.text.split("\n"),r=h.length,c=h.map((e=>(0,s.text_width)(e,t))),_=this._text_line(e).height*r,l="%"==this.width?.unit?this.width.value:1,x="%"==this.height?.unit?this.height.value:1;return{width:(0,a.max)(c)*l,height:n?0:(_+i*(r-1))*x,metrics:e}}_computed_position(t,e,s){const{width:i,height:n}=t,{sx:h,sy:o,x_anchor:a=this._x_anchor,y_anchor:c=this._y_anchor}=this.position;return{x:h-(()=>{if((0,r.isNumber)(a))return a*i;switch(a){case"left":return 0;case"center":return.5*i;case"right":return i}})(),y:o-(()=>{if((0,r.isNumber)(c))return c*n;switch(c){case"top":return 0;case"center":return.5*n;case"bottom":return n;case"baseline":if(1!=s)return.5*n;switch(this.text_height_metric??this.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}})()}}_rect(){const{width:t,height:e,metrics:s}=this._size(),i=this.text.split("\n").length,{x:n,y:o}=this._computed_position({width:t,height:e},s,i);return new h.BBox({x:n,y:o,width:t,height:e}).rect}paint(t){const{font:e}=this,i=(0,o.font_metrics)(e),n=(this.line_height-1)*i.height,h=this.text.split("\n"),r=h.length,c=h.map((t=>(0,s.text_width)(t,e))),_=this._text_line(i),l=_.height*r,x="%"==this.width?.unit?this.width.value:1,u="%"==this.height?.unit?this.height.value:1,p=(0,a.max)(c)*x,f=(l+n*(r-1))*u;t.save(),t.fillStyle=this.color,t.strokeStyle=this.outline_color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";const{sx:g,sy:d}=this.position,{align:b}=this,{angle:m}=this;null!=m&&0!=m&&(t.translate(g,d),t.rotate(m),t.translate(-g,-d));let{x:y,y:w}=this._computed_position({width:p,height:f},i,r);if("justify"==b)for(let i=0;i<r;i++){let o=y;const r=h[i].split(" "),c=r.length,l=r.map((t=>(0,s.text_width)(t,e))),x=(p-(0,a.sum)(l))/(c-1);for(let e=0;e<c;e++)t.fillText(r[e],o,w),t.strokeText(r[e],o,w),o+=l[e]+x;w+=_.height+n}else for(let e=0;e<r;e++){const s=y+(()=>{switch("auto"==b?this._visual_align:b){case"left":return 0;case"center":return.5*(p-c[e]);case"right":return p-c[e]}})(),i=h[e],o=w+_.ascent;t.fillText(i,s,o),t.strokeText(i,s,o),w+=_.height+n}t.restore()}}s.TextBox=x,x.__name__="TextBox";class u extends l{constructor(t,e){super(),this.base=t,this.expo=e}get children(){return[this.base,this.expo]}set base_font_size(t){super.base_font_size=t,this.base.base_font_size=t,this.expo.base_font_size=t}set position(t){this._position=t;const e=this.base.size(),s=this.expo.size(),i=this._shift_scale()*e.height,n=Math.max(e.height,i+s.height);this.base.position={sx:0,x_anchor:"left",sy:n,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:i,y_anchor:"bottom"}}get position(){return this._position}set visuals(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t}_shift_scale(){if(this.base instanceof x&&1==this.base.nlines){const{x_height:t,cap_height:e}=(0,o.font_metrics)(this.base.font);return t/e}return 2/3}infer_text_height(){return this.base.infer_text_height()}_rect(){const t=this.base.bbox(),e=this.expo.bbox(),s=t.union(e),{x:i,y:n}=this._computed_position();return s.translate(i,n).rect}_size(){const t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}}paint(t){t.save();const{angle:e}=this;if(null!=e&&0!=e){const{sx:s,sy:i}=this.position;t.translate(s,i),t.rotate(e),t.translate(-s,-i)}const{x:s,y:i}=this._computed_position();t.translate(s,i),this.base.paint(t),this.expo.paint(t),t.restore()}paint_bbox(t){super.paint_bbox(t);const{x:e,y:s}=this._computed_position();t.save(),t.translate(e,s);for(const e of this.children)e.paint_bbox(t);t.restore()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position;return{x:s-(()=>{if((0,r.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,r.isNumber)(h))return h*e;switch(h){case"top":return 0;case"center":case"baseline":return.5*e;case"bottom":return e}})()}}}s.BaseExpo=u,u.__name__="BaseExpo";class p{constructor(t){this.items=t}set base_font_size(t){for(const e of this.items)e.base_font_size=t}get length(){return this.items.length}set visuals(t){for(const e of this.items)e.visuals=t;const e={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},s=(0,a.max_by)(this.items.map((t=>t.infer_text_height())),(t=>e[t]));for(const t of this.items)t.text_height_metric=s}set angle(t){for(const e of this.items)e.angle=t}max_size(){let t=0,e=0;for(const s of this.items){const i=s.size();t=Math.max(t,i.width),e=Math.max(e,i.height)}return{width:t,height:e}}}s.GraphicsBoxes=p,p.__name__="GraphicsBoxes"},
function _(n,t,e,o,s){o(),e.font_metrics=function(n){let t=f.get(n);if(null==t){const e=document.fonts.check(n);t={font:a(n)},e&&f.set(n,t)}return t.font},e.parse_css_font_size=function(n){const t=n.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=t){const[,n,,e]=t,o=Number(n);if(isFinite(o))return{value:o,unit:e}}return null},e.parse_css_length=function(n){const t=n.match(/^\s*(-?\d+(\.\d+)?)(\w+)\s*$/);if(null!=t){const[,n,,e]=t,o=Number(n);if(isFinite(o))return{value:o,unit:e}}return null};const c=n(12),u=n(61),i=(()=>{const n=("undefined"!=typeof OffscreenCanvas?new OffscreenCanvas(0,0):(0,u.canvas)({width:0,height:0})).getContext("2d");return(0,c.assert)(null!=n,"can't obtain 2d context"),n})();function a(n){const t=i;t.font=n;const e=t.measureText("M"),o=t.measureText("x"),s=t.measureText("\xc5\u015ag|"),c=void 0!==s.fontBoundingBoxAscent?s.fontBoundingBoxAscent:s.actualBoundingBoxAscent,u=void 0!==s.fontBoundingBoxDescent?s.fontBoundingBoxDescent:s.actualBoundingBoxDescent;return{height:c+u,ascent:c,descent:u,cap_height:e.actualBoundingBoxAscent,x_height:o.actualBoundingBoxAscent}}const f=new Map},
function _(t,e,a,r,n){var s,i=this&&this.__createBinding||(Object.create?function(t,e,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(e,a);n&&!("get"in n?!e.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return e[a]}}),Object.defineProperty(t,r,n)}:function(t,e,a,r){void 0===r&&(r=a),t[r]=e[a]}),o=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),d=this&&this.__importStar||(s=function(t){return s=Object.getOwnPropertyNames||function(t){var e=[];for(var a in t)Object.prototype.hasOwnProperty.call(t,a)&&(e[e.length]=a);return e},s(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var a=s(t),r=0;r<a.length;r++)"default"!==a[r]&&i(e,t,a[r]);return o(e,t),e});r();const u=t(16),l=t(195);class c{constructor(){this.ready=new u.Signal0(this,"ready"),this.status="not_started"}}a.MathJaxProvider=c,c.__name__="MathJaxProvider";class h extends c{get MathJax(){return null}async fetch(){this.status="failed"}}a.NoProvider=h,h.__name__="NoProvider";class _ extends c{get MathJax(){return"undefined"!=typeof MathJax?MathJax:null}async fetch(){const t=document.createElement("script");t.src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js",t.onload=()=>{this.status="loaded",this.ready.emit()},t.onerror=()=>{this.status="failed"},this.status="loading",document.head.appendChild(t)}}a.CDNProvider=_,_.__name__="CDNProvider";class f extends c{get MathJax(){return this._mathjax}async fetch(){this.status="loading";try{const e=await(0,l.load_module)(Promise.resolve().then((()=>d(t(735)))));this.status=null==e?"failed":"loaded",this._mathjax=e,this.ready.emit()}catch(t){this.status="failed"}}}a.BundleProvider=f,f.__name__="BundleProvider",a.default_provider=new f},
function _(n,r,o,t,c){t(),o.load_module=async function(n){try{return await n}catch(n){if((r=n)instanceof Error&&"code"in r&&"MODULE_NOT_FOUND"===n.code)return null;throw n}var r}},
function _(e,t,i,n,s){var a;n();const x=e(188),_=e(192);class l extends x.BaseTextView{initialize(){super.initialize(),this._has_finished=!0}graphics(){return new _.TextBox({text:this.model.text})}}i.PlainTextView=l,l.__name__="PlainTextView";class r extends x.BaseText{constructor(e){super(e)}}i.PlainText=r,a=r,r.__name__="PlainText",a.prototype.default_view=l},
function _(t,o,e,i,n){i(),e.round_rect=function(t,o,e){let{top_left:i,top_right:n,bottom_right:c,bottom_left:h}=e;if(0!=i||0!=n||0!=c||0!=h){const{left:e,right:l,top:r,bottom:T,width:f,height:a}=o,_=Math.min(f/(i+n),a/(n+c),f/(c+h),a/(i+h));_<1&&(i*=_,n*=_,c*=_,h*=_),t.moveTo(e+i,r),t.lineTo(l-n,r),0!=n&&t.arcTo(l,r,l,r+n,n),t.lineTo(l,T-c),0!=c&&t.arcTo(l,T,l-c,T,c),t.lineTo(e+h,T),0!=h&&t.arcTo(e,T,e,T-h,h),t.lineTo(e,r+i),0!=i&&t.arcTo(e,r,e+i,r,i),t.closePath()}else{const{left:e,top:i,width:n,height:c}=o;t.rect(e,i,n,c)}}},
function _(e,s,t,a,r){var _;a();const n=e(1),i=e(199),g=e(116),c=e(115),l=e(108),o=e(113),h=e(110),u=e(111),x=e(118),y=e(121),f=e(9),p=e(12),d=n.__importStar(e(201));class m extends i.CanvasPanelView{constructor(){super(...arguments),this._x_ranges=new Map,this._y_ranges=new Map,this._x_scales=new Map,this._y_scales=new Map}initialize(){super.initialize(),this._configure_scales()}remove(){this._unregister_frame(),super.remove()}stylesheets(){return[...super.stylesheets(),d.default]}connect_signals(){super.connect_signals();const{x_range:e,y_range:s,x_scale:t,y_scale:a,extra_x_ranges:r,extra_y_ranges:_,extra_x_scales:n,extra_y_scales:i}=this.model.properties;this.on_change([e,s,t,a,r,_,n,i],(()=>{this._configure_scales()}))}_get_ranges(e,s){return new Map([...(0,f.entries)(s),["default",e]])}_get_scales(e,s,t,a){const r=new Map([...(0,f.entries)(s),["default",e]]),_=new Map;for(const[s,n]of t){if(n instanceof y.FactorRange!=e instanceof g.CategoricalScale)throw new Error(`'${n.type}' is incompatible '${e.type}'`);e instanceof c.LogScale&&n instanceof x.DataRange1d&&(n.scale_hint="log");const t=(r.get(s)??e).clone();t.setv({source_range:n,target_range:a}),_.set(s,t)}return _}_configure_ranges(){const{bbox:e}=this;this._x_target=new u.Range1d({start:e.left,end:e.right}),this._y_target=new u.Range1d({start:e.bottom,end:e.top})}_configure_scales(){const{x_range:e,y_range:s,extra_x_ranges:t,extra_y_ranges:a}=this.model,{x_scale:r,y_scale:_,extra_x_scales:n,extra_y_scales:i}=this.model;(0,p.assert)(r.properties.source_range.is_unset&&r.properties.target_range.is_unset),(0,p.assert)(_.properties.source_range.is_unset&&_.properties.target_range.is_unset),this._configure_ranges(),this._unregister_frame(),this._x_ranges=this._get_ranges(e,t),this._y_ranges=this._get_ranges(s,a),this._register_frame(),this._x_scales=this._get_scales(r,n,this._x_ranges,this._x_target),this._y_scales=this._get_scales(_,i,this._y_ranges,this._y_target),this._x_scale=this._x_scales.get("default"),this._y_scale=this._y_scales.get("default"),this.mark_finished()}_update_scales(){this._configure_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}_register_frame(){for(const e of this.ranges.values())e.frames.add(this)}_unregister_frame(){for(const e of this.ranges.values())e.frames.delete(this)}set_geometry(e){super.set_geometry(e),this._update_scales()}get x_range(){return this.model.x_range}get y_range(){return this.model.y_range}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get ranges(){return new Set([...this.x_ranges.values(),...this.y_ranges.values()])}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get scales(){return new Set([...this.x_scales.values(),...this.y_scales.values()])}get x_scale(){return this._x_scale}get y_scale(){return this._y_scale}}t.CartesianFrameView=m,m.__name__="CartesianFrameView";class w extends i.CanvasPanel{constructor(e){super(e)}}t.CartesianFrame=w,_=w,w.__name__="CartesianFrame",_.prototype.default_view=m,_.define((({Bool:e,Float:s,Dict:t,Ref:a})=>({x_range:[a(h.Range),()=>new x.DataRange1d],y_range:[a(h.Range),()=>new x.DataRange1d],x_scale:[a(l.Scale),()=>new o.LinearScale],y_scale:[a(l.Scale),()=>new o.LinearScale],extra_x_ranges:[t(a(h.Range)),{}],extra_y_ranges:[t(a(h.Range)),{}],extra_x_scales:[t(a(l.Scale)),{}],extra_y_scales:[t(a(l.Scale)),{}],match_aspect:[e,!1],aspect_scale:[s,1]})))},
function _(e,t,s,n,i){var o;n();const r=e(1),a=e(56),l=e(61),_=e(62),p=e(21),d=e(22),h=e(8),c=r.__importStar(e(200));class u extends a.StyledElementView{constructor(){super(...arguments),this._bbox=new _.BBox,this.position=new l.InlineStyleSheet("","position")}get bbox(){return this._bbox}stylesheets(){return[...super.stylesheets(),c.default,this.position]}rendering_target(){return this.model.inner?this.parent.frame_view.shadow_el:this.parent.canvas_view.events_el}render(){super.render(),this.class_list.add(c[this.model.place])}set_geometry(e){this._bbox=e,this._update_position(),this.mark_finished()}_update_position(){const{bbox:e,position:t}=this;e.is_valid||t.replace("\n      :host {\n        display: none;\n      }\n      ")}resolve_symbol(e){const t=this.bbox.resolve(e.symbol),{offset:s}=e;if((0,h.isNumber)(t))return t+s;{const{x:e,y:n}=t;return{x:e+s,y:n+s}}}}s.CanvasPanelView=u,u.__name__="CanvasPanelView";class b extends a.StyledElement{constructor(e){super(e)}}s.CanvasPanel=b,o=b,b.__name__="CanvasPanel",o.prototype.default_view=u,o.define({place:[p.Place],inner:[d.Bool,!1]})},
function _(t,e,o,r,a){r(),o.above="bk-above",o.below="bk-below",o.left="bk-left",o.right="bk-right",o.center="bk-center",o.default=":host{position:relative;pointer-events:none;}:host{align-items:start;justify-items:start;}:host(.bk-above),:host(.bk-below){display:grid;grid-auto-flow:row;grid-template-rows:auto;grid-template-columns:100%;}:host(.bk-left),:host(.bk-right){display:grid;grid-auto-flow:column;grid-template-rows:100%;grid-template-columns:auto;}:host(.bk-above){grid-area:above;}:host(.bk-below){grid-area:below;}:host(.bk-left){grid-area:left;}:host(.bk-right){grid-area:right;}:host(.bk-center){grid-area:center;}:host(.bk-center){overflow:hidden;}"},
function _(t,e,a,n,o){n(),a.default=':host{display:grid;grid-template-areas:".    above  .    " "left center right" ".    below  .    ";grid-template-rows:max-content 1fr max-content;grid-template-columns:max-content 1fr max-content;}'},
function _(t,e,i,s,a){var l;s();const n=t(1),o=t(203),r=t(204),_=t(205),h=t(206),c=t(80),d=n.__importStar(t(95)),u=t(21),b=t(25),m=t(187),x=t(10),f=t(9),g=t(8),p=t(192),v=t(121),w=t(188),k=t(69),j=t(12),y=t(8),z=t(62),M=t(189),T=t(22);i.LabelOverrides=(0,T.Or)((0,T.Dict)((0,T.Or)(T.Str,(0,T.Ref)(w.BaseText))),(0,T.Mapping)((0,T.Or)(T.Str,T.Float),(0,T.Or)(T.Str,(0,T.Ref)(w.BaseText))));const{abs:A}=Math;class L extends o.GuideRendererView{constructor(){super(...arguments),this._axis_label_view=null,this._major_label_views=new Map}get panel(){return this._panel}set panel(t){this._panel=new m.SidePanel(t.side,this.model.face)}get bbox(){if(null!=this.layout&&null==this.model.fixed_location)return this.layout.bbox;if(this.is_renderable){const{extents:t}=this,e=Math.round(t.tick+t.tick_label+t.axis_label);let{sx0:i,sy0:s,sx1:a,sy1:l}=this.rule_scoords;const{dimension:n,face:o}=this;return 0==n?"front"==o?s-=e:l+=e:"front"==o?i-=e:a+=e,z.BBox.from_lrtb({left:i,top:s,right:a,bottom:l})}return new z.BBox}*children(){yield*super.children(),null!=this._axis_label_view&&(yield this._axis_label_view),yield*this._major_label_views.values()}async lazy_initialize(){await super.lazy_initialize(),await this._init_axis_label(),await this._init_major_labels()}async _init_axis_label(){const{axis_label:t}=this.model;if(null!=t){const e=(0,y.isString)(t)?(0,M.parse_delimited_string)(t):t;this._axis_label_view=await(0,k.build_view)(e,{parent:this})}else this._axis_label_view=null}async _init_major_labels(){for(const[t,e]of(0,f.dict)(this.model.major_label_overrides)){const i=(0,y.isString)(e)?(0,M.parse_delimited_string)(e):e;this._major_label_views.set(t,await(0,k.build_view)(i,{parent:this}))}}update_layout(){this.layout=new m.SideLayout(this.panel,(()=>this.get_size()),!0),this.layout.on_resize((()=>{this._coordinates=void 0}))}get_size(){const{visible:t,fixed_location:e}=this.model;if(t&&null==e&&this.is_renderable){const{extents:t}=this;return{width:0,height:Math.round(t.tick+t.tick_label+t.axis_label)}}return{width:0,height:0}}get is_renderable(){const[t,e]=this.ranges;return super.is_renderable&&t.is_valid&&e.is_valid&&t.span>0&&e.span>0}interactive_hit(t,e){return this.bbox.contains(t,e)}on_hit(t,e){const i=this._hit_value(t,e);return null!=i&&(this.model.trigger_event(new c.AxisClick(this.model,i)),!0)}_paint(t){const{tick_coords:e,extents:i}=this;this._draw_background(t,i),this._draw_rule(t,i),this._draw_major_ticks(t,i,e),this._draw_minor_ticks(t,i,e),this._draw_major_labels(t,i,e),this._draw_axis_label(t,i,e)}connect_signals(){super.connect_signals();const{axis_label:t,major_label_overrides:e}=this.model.properties;this.on_change(t,(async()=>{this._axis_label_view?.remove(),await this._init_axis_label()})),this.on_change(e,(async()=>{for(const t of this._major_label_views.values())t.remove();await this._init_major_labels()})),this.connect(this.model.change,(()=>this.plot_view.request_layout()))}get needs_clip(){return null!=this.model.fixed_location}_draw_background(t,e){if(!this.visuals.background_fill.doit&&!this.visuals.background_hatch.doit)return;t.beginPath();const{x:i,y:s,width:a,height:l}=this.bbox;t.rect(i,s,a,l),this.visuals.background_fill.apply(t),this.visuals.background_hatch.apply(t)}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const{sx0:i,sy0:s,sx1:a,sy1:l}=this.rule_scoords;t.beginPath(),t.moveTo(i,s),t.lineTo(a,l),this.visuals.axis_line.apply(t)}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,l)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,l)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,n=e.tick+this.model.major_label_standoff,o=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,l,n,o)}_axis_label_extent(){if(null==this._axis_label_view)return 0;const t=this._axis_label_view.graphics(),e=this.model.axis_label_orientation;t.visuals=this.visuals.axis_label_text.values(),t.angle=this.panel.get_label_angle_heuristic(e),t.base_font_size=this.plot_view.base_font_size;const i=t.size(),s=0==this.dimension?i.height:i.width,a=(()=>{switch(this.model.axis_label_standoff_mode){case"tick_labels":return 0;case"axis":return(0,x.sum)(this._tick_label_extents())+this._tick_extent()}})(),l=this.model.axis_label_standoff-a;return s>0?l+s+3:0}_draw_axis_label(t,e,i){if(null==this._axis_label_view)return;const[s,a]=(()=>{const{bbox:t}=this,{side:e,face:i}=this.panel,[s]=this.ranges,{axis_label_align:a}=this.model;switch(e){case"above":case"below":{const[e,l]=(()=>{switch(a){case"start":return s.is_reversed?[t.right,"right"]:[t.left,"left"];case"center":return[t.hcenter,"center"];case"end":return s.is_reversed?[t.left,"left"]:[t.right,"right"]}})(),[n,o]="front"==i?[t.bottom,"bottom"]:[t.top,"top"];return[e,n,l,o]}case"left":case"right":{const[e,l]=(()=>{switch(a){case"start":return s.is_reversed?[t.top,"top"]:[t.bottom,"bottom"];case"center":return[t.vcenter,"center"];case"end":return s.is_reversed?[t.bottom,"bottom"]:[t.top,"top"]}})(),[n,o]="front"==i?[t.right,"right"]:[t.left,"left"];return[n,e,o,l]}}})(),[l,n]=this.normals,o=this.model.axis_label_orientation,r=this.model.axis_label_standoff_mode,_=(()=>{switch(r){case"tick_labels":return e.tick+e.tick_label;case"axis":return 0}})(),h=this.model.axis_label_standoff+_,{vertical_align:c,align:d}=this.panel.get_label_text_heuristics(o),u={sx:s+l*h,sy:a+n*h,x_anchor:d,y_anchor:c},b=this._axis_label_view.graphics();b.visuals=this.visuals.axis_label_text.values(),b.angle=this.panel.get_label_angle_heuristic(o),b.base_font_size=this.plot_view.base_font_size,b.position=u,b.align=d,b.paint(t)}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[l,n]=this.scoords(e),[o,r]=this.normals,[_,h]=[o*-i,r*-i],[c,d]=[o*s,r*s];a.set_value(t),t.beginPath();for(let e=0;e<l.length;e++){const i=Math.round(l[e]+c),s=Math.round(n[e]+d),a=Math.round(l[e]+_),o=Math.round(n[e]+h);t.moveTo(i,s),t.lineTo(a,o)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,l){if(!l.doit||0==e.length)return;const[n,o]=this.scoords(i),[r,_]=this.normals,h=r*a,c=_*a,{vertical_align:d,align:u}=this.panel.get_label_text_heuristics(s),m=this.panel.get_label_angle_heuristic(s);e.visuals=l.values(),e.angle=m,e.base_font_size=this.plot_view.base_font_size;for(let t=0;t<e.length;t++){const i=e.items[t];i.position={sx:n[t]+h,sy:o[t]+c,x_anchor:u,y_anchor:d},i instanceof p.TextBox&&(i.align=u)}const x=e.length,f=b.Indices.all_set(x),{items:g}=e,v=g.map((t=>t.bbox())),w=(()=>{const[t]=this.ranges;return t.is_reversed?0==this.dimension?(t,e)=>v[t].left-v[e].right:(t,e)=>v[e].top-v[t].bottom:0==this.dimension?(t,e)=>v[e].left-v[t].right:(t,e)=>v[t].top-v[e].bottom})(),{major_label_policy:k}=this.model,j=k.filter(f,v,w),y=[...j];if(0!=y.length){const t=this.canvas.bbox,e=e=>{const i=v[e];if(i.left<0){const t=-i.left,{position:s}=g[e];g[e].position={...s,sx:s.sx+t}}else if(i.right>t.width){const s=i.right-t.width,{position:a}=g[e];g[e].position={...a,sx:a.sx-s}}},i=e=>{const i=v[e];if(i.top<0){const t=-i.top,{position:s}=g[e];g[e].position={...s,sy:s.sy+t}}else if(i.bottom>t.height){const s=i.bottom-t.height,{position:a}=g[e];g[e].position={...a,sy:a.sy-s}}},s=y[0],a=y[y.length-1];0==this.dimension?(e(s),e(a)):(i(s),i(a))}for(const e of j){g[e].paint(t)}}_tick_extent(){const{major:t,minor:e}=this.tick_coords,i=this.dimension;return Math.max(0==t[i].length?0:this.model.major_tick_out,0==e[i].length?0:this.model.minor_tick_out)}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,s,a)]}get extents(){const t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:(0,x.sum)(t),axis_label:this._axis_label_extent()}}_oriented_labels_extent(t,e,i,s){if(0==t.length||!s.doit)return 0;const a=this.panel.get_label_angle_heuristic(e);t.visuals=s.values(),t.angle=a,t.base_font_size=this.plot_view.base_font_size;const l=t.max_size(),n=0==this.dimension?l.height:l.width;return n>0?i+n+3:0}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.format_graphics(t,this),{_major_label_views:i}=this,s=new Set;for(let a=0;a<t.length;a++){const l=i.get(t[a]);null!=l&&(s.add(l),e[a]=l.graphics())}for(const t of this._major_label_views.values())s.has(t)||(t._has_finished=!0);return new p.GraphicsBoxes(e)}scoords(t){const[e,i]=t,[s,a]=this.coordinates.map_to_screen(e,i);if(null!=this.model.fixed_location)return[[...s],[...a]];{const{bbox:t}=this,{face:e}=this.panel;if(this.panel.is_vertical){const i="front"==e?t.right:t.left;return[(0,x.repeat)(i,s.length),[...a]]}{const i="front"==e?t.bottom:t.top;return[[...s],(0,x.repeat)(i,a.length)]}}}get ranges(){const t=this.dimension,e=1-t,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,l]=e,[n,o]=i,{min:r,max:_}=Math;return A(a-l)>A(n-o)?(t=_(r(a,l),n),s=r(_(a,l),o)):(t=r(a,l),s=_(a,l)),[t,s]}}get rule_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[t][0]=Math.max(s,i.min),l[t][1]=Math.min(a,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l}get rule_scoords(){const[[t,e],[i,s]]=this.scoords(this.rule_coords);return{sx0:Math.round(t),sy0:Math.round(i),sx1:Math.round(e),sy1:Math.round(s)}}get tick_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc),n=l.major,o=l.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[t].push(n[i]),r[e].push(this.loc));for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(_[t].push(o[i]),_[e].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if((0,g.isNumber)(t))return t;const[,e]=this.ranges;if(e instanceof v.FactorRange)return e.synthetic(t);(0,j.unreachable)()}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}get face(){return this.panel.face}remove(){this._axis_label_view?.remove();for(const t of this._major_label_views.values())t.remove();super.remove()}has_finished(){if(!super.has_finished())return!1;if(null!=this._axis_label_view&&!this._axis_label_view.has_finished())return!1;for(const t of this._major_label_views.values())if(!t.has_finished())return!1;return!0}}i.AxisView=L,L.__name__="AxisView";class S extends o.GuideRenderer{constructor(t){super(t)}}i.Axis=S,l=S,S.__name__="Axis",l.mixins([["axis_",d.Line],["major_tick_",d.Line],["minor_tick_",d.Line],["major_label_",d.Text],["axis_label_",d.Text],["background_",d.Fill],["background_",d.Hatch]]),l.define((({Any:t,Int:e,Float:s,Str:a,Ref:l,Tuple:n,Or:o,Nullable:c,Auto:d,Enum:b})=>({dimension:[o(b(0,1),d),"auto"],face:[o(u.Face,d),"auto"],bounds:[o(n(s,s),d),"auto"],ticker:[l(r.Ticker)],formatter:[l(_.TickFormatter)],axis_label:[c(o(a,l(w.BaseText))),null],axis_label_standoff:[e,5],axis_label_standoff_mode:[u.AxisLabelStandoffMode,"tick_labels"],axis_label_orientation:[o(u.LabelOrientation,s),"parallel"],axis_label_align:[u.Align,"center"],major_label_standoff:[e,5],major_label_orientation:[o(u.LabelOrientation,s),"horizontal"],major_label_overrides:[i.LabelOverrides,new Map],major_label_policy:[l(h.LabelingPolicy),()=>new h.AllLabels],major_tick_in:[s,2],major_tick_out:[s,6],minor_tick_in:[s,0],minor_tick_out:[s,4],fixed_location:[c(o(s,t)),null]}))),l.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic",background_fill_color:null})},
function _(e,r,d,n,i){var s;n();const _=e(98);class u extends _.RendererView{}d.GuideRendererView=u,u.__name__="GuideRendererView";class c extends _.Renderer{constructor(e){super(e)}}d.GuideRenderer=c,s=c,c.__name__="GuideRenderer",s.override({level:"guide"})},
function _(c,e,n,s,o){s();const r=c(52);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,e,c){e();const a=t(52),m=t(192);class n extends a.Model{constructor(t){super(t)}format_graphics(t,o){return this.doFormat(t,o).map((t=>new m.TextBox({text:t})))}compute(t,o){return this.doFormat([t],o??{loc:0})[0]}v_compute(t,o){return this.doFormat(t,o??{loc:0})}}r.TickFormatter=n,n.__name__="TickFormatter"},
function _(e,n,s,t,i){var c,l;t();const r=e(52),o=e(9),a=e(41),u=e(8),d=e(25);class _ extends r.Model{constructor(e){super(e)}}s.LabelingPolicy=_,_.__name__="LabelingPolicy";class f extends _{constructor(e){super(e)}filter(e,n,s){return e}}s.AllLabels=f,f.__name__="AllLabels";class m extends _{constructor(e){super(e)}filter(e,n,s){const{min_distance:t}=this;let i=null;for(const n of e)null!=i&&s(i,n)<t?e.unset(n):i=n;return e}}s.NoOverlap=m,c=m,m.__name__="NoOverlap",c.define((({Float:e})=>({min_distance:[e,5]})));class v extends _{constructor(e){super(e)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}get func(){const e=(0,a.use_strict)(this.code);return new d.GeneratorFunction("indices","bboxes","distance",...this.names,e)}filter(e,n,s){const t=Object.create(null),i=this.func.call(t,e,n,s,...this.values);let c=i.next();if(c.done&&void 0!==c.value){const{value:n}=c;return n instanceof d.Indices?n:void 0===n?e:(0,u.isIterable)(n)?d.Indices.from_indices(e.size,n):d.Indices.all_unset(e.size)}{const n=[];do{n.push(c.value),c=i.next()}while(!c.done);return d.Indices.from_indices(e.size,n)}}}s.CustomLabelingPolicy=v,l=v,v.__name__="CustomLabelingPolicy",l.define((({Unknown:e,Str:n,Dict:s})=>({args:[s(e),{}],code:[n,""]})))},
function _(e,i,s,n,r){var t;n();const a=e(208),o=e(209),c=e(210);class _ extends a.ContinuousAxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class u extends a.ContinuousAxis{constructor(e){super(e)}}s.LinearAxis=u,t=u,u.__name__="LinearAxis",t.prototype.default_view=_,t.override({ticker:()=>new c.BasicTicker,formatter:()=>new o.BasicTickFormatter})},
function _(s,n,t,i,e){i();const o=s(202);class u extends o.AxisView{_hit_value(s,n){const[t]=this.ranges,{start:i,end:e,span:o}=t;switch(this.dimension){case 0:{const{x0:n,width:t}=this.bbox;return o*(s-n)/t+i}case 1:{const{y0:s,height:t}=this.bbox;return e-o*(n-s)/t}}}}t.ContinuousAxisView=u,u.__name__="ContinuousAxisView";class c extends o.Axis{constructor(s){super(s)}}t.ContinuousAxis=c,c.__name__="ContinuousAxis"},
function _(i,t,e,o,n){var r;o(),e.unicode_replace=_;const s=i(205),c=i(41);function _(i){let t="";for(const e of i)t+="-"==e?"\u2212":e;return t}class a extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,o=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const n of i){const i=Math.abs(n);if(!(i<=o)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map((i=>_(i.toExponential(e)))):i.map((i=>_((0,c.to_fixed)(i,e))))}_auto_precision(i,t){const e=new Array(i.length),o=this.last_precision<=15;i:for(let n=this.last_precision;o?n<=15:n>=1;o?n++:n--){if(t){e[0]=i[0].toExponential(n);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=n;break}e[0]=(0,c.to_fixed)(i[0],n);for(let t=1;t<i.length;t++)if(e[t]=(0,c.to_fixed)(i[t],n),e[t]==e[t-1])continue i;this.last_precision=n;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),o="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,o)}}e.BasicTickFormatter=a,r=a,a.__name__="BasicTickFormatter",r.define((({Bool:i,Int:t,Auto:e,Or:o})=>({precision:[o(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]})))},
function _(c,e,s,i,n){i();const r=c(211);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(t,e,s,a,i){var n;a();const r=t(212),_=t(10),l=t(11);class h extends r.ContinuousTicker{constructor(t){super(t)}get_min_interval(){return this.min_interval}get_max_interval(){return this.max_interval??1/0}get extended_mantissas(){const t=(0,_.nth)(this.mantissas,-1)/this.base,e=(0,_.nth)(this.mantissas,0)*this.base;return[t,...this.mantissas,e]}get base_factor(){return 0==this.get_min_interval()?1:this.get_min_interval()}get_interval(t,e,s){const a=e-t,i=this.get_ideal_interval(t,e,s),n=Math.floor((0,l.log)(i/this.base_factor,this.base)),r=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map((t=>Math.abs(s-a/(t*r)))),o=h[(0,_.argmin)(m)]*r;return(0,l.clamp)(o,this.get_min_interval(),this.get_max_interval())}}s.AdaptiveTicker=h,n=h,h.__name__="AdaptiveTicker",n.define((({Float:t,List:e,Nullable:s})=>({base:[t,10],mantissas:[e(t),[1,2,5]],min_interval:[t,0],max_interval:[s(t),null]})))},
function _(t,n,i,s,e){var o;s();const r=t(204),c=t(10);class _ extends r.Ticker{constructor(t){super(t)}get_ticks(t,n,i,s){return this.get_ticks_no_defaults(t,n,s,this.desired_num_ticks)}get_ticks_no_defaults(t,n,i,s){const e=this.get_interval(t,n,s),o=Math.floor(t/e),r=Math.ceil(n/e);let _;_=isFinite(o)&&isFinite(r)?(0,c.range)(o,r+1):[];const u=_.map((t=>t*e)).filter((i=>t<=i&&i<=n)),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const i=e/a,s=(0,c.range)(0,a).map((t=>t*i));for(const i of s.slice(1)){const s=u[0]-i;t<=s&&s<=n&&f.push(s)}for(const i of u)for(const e of s){const s=i+e;t<=s&&s<=n&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,n,i){return(n-t)/i}}i.ContinuousTicker=_,o=_,_.__name__="ContinuousTicker",o.define((({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]})))},
function _(e,i,r,c,T){c(),T("AdaptiveTicker",e(211).AdaptiveTicker),T("BasicTicker",e(210).BasicTicker),T("CategoricalTicker",e(214).CategoricalTicker),T("CompositeTicker",e(215).CompositeTicker),T("ContinuousTicker",e(212).ContinuousTicker),T("CustomJSTicker",e(216).CustomJSTicker),T("DatetimeTicker",e(217).DatetimeTicker),T("DaysTicker",e(218).DaysTicker),T("FixedTicker",e(223).FixedTicker),T("LogTicker",e(224).LogTicker),T("MercatorTicker",e(225).MercatorTicker),T("MonthsTicker",e(221).MonthsTicker),T("SingleIntervalTicker",e(219).SingleIntervalTicker),T("Ticker",e(204).Ticker),T("TimedeltaTicker",e(226).TimedeltaTicker),T("YearsTicker",e(222).YearsTicker),T("BinnedTicker",e(227).BinnedTicker)},
function _(t,c,o,s,e){s();const r=t(204);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(o.mapper.tops??[],o,t,c),mids:this._collect(o.mapper.mids??[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,e,i,s,r){var n;s();const _=t(212),a=t(10);class c extends _.ContinuousTicker{constructor(t){super(t)}get min_intervals(){return this.tickers.map((t=>t.get_min_interval()))}get max_intervals(){return this.tickers.map((t=>t.get_max_interval()))}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const s=e-t;if(0==s)return this.tickers[0];const r=this.get_ideal_interval(t,e,i),n=[(0,a.sorted_index)(this.min_intervals,r)-1,(0,a.sorted_index)(this.max_intervals,r)],_=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map((t=>Math.abs(i-s/t)));let c;if((0,a.is_empty)(_.filter((t=>!isNaN(t)))))c=this.tickers[0];else{const t=n[(0,a.argmin)(_)];c=this.tickers[t]}return c}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,s){return this.get_best_ticker(t,e,s).get_ticks_no_defaults(t,e,i,s)}}i.CompositeTicker=c,n=c,c.__name__="CompositeTicker",n.define((({NonEmptyList:t,Ref:e})=>({tickers:[t(e(_.ContinuousTicker))]})))},
function _(t,s,r,n,e){var i;n();const o=t(204),c=t(121),a=t(9),m=t(41);class _ extends o.Ticker{constructor(t){super(t)}get names(){return(0,a.keys)(this.args)}get values(){return(0,a.values)(this.args)}get_ticks(t,s,r,n){const e={start:t,end:s,range:r,cross_loc:n},i=this.major_ticks(e);if(r instanceof c.FactorRange)return{major:i,minor:[],tops:[],mids:[]};const o={major_ticks:i,...e};return{major:i,minor:this.minor_ticks(o)}}major_ticks(t){if(""==this.major_code)return[];const s=(0,m.use_strict)(this.major_code);return new Function("cb_data",...this.names,s)(t,...this.values)}minor_ticks(t){if(""==this.minor_code)return[];const s=(0,m.use_strict)(this.minor_code);return new Function("cb_data",...this.names,s)(t,...this.values)}}r.CustomJSTicker=_,i=_,_.__name__="CustomJSTicker",i.define((({Unknown:t,Str:s,Dict:r})=>({args:[r(t),{}],major_code:[s,""],minor_code:[s,""]})))},
function _(e,n,i,a,s){var r;a();const t=e(10),c=e(211),m=e(215),_=e(218),k=e(221),o=e(222),T=e(220);class w extends m.CompositeTicker{constructor(e){super(e)}}i.DatetimeTicker=w,r=w,w.__name__="DatetimeTicker",r.override({num_minor_ticks:0,tickers:()=>[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:(0,t.range)(1,32)}),new _.DaysTicker({days:(0,t.range)(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:(0,t.range)(0,12,1)}),new k.MonthsTicker({months:(0,t.range)(0,12,2)}),new k.MonthsTicker({months:(0,t.range)(0,12,4)}),new k.MonthsTicker({months:(0,t.range)(0,12,6)}),new o.YearsTicker({})]})},
function _(t,e,n,s,o){var a;s();const i=t(219),r=t(220),c=t(10);class _ extends i.BaseSingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*r.ONE_DAY:this.interval=31*r.ONE_DAY}get_ticks_no_defaults(t,e,n,s){const o=function(t,e){const n=(0,r.last_month_no_later_than)(new Date(t)),s=(0,r.last_month_no_later_than)(new Date(e));s.setUTCMonth(s.getUTCMonth()+1);const o=[],a=n;for(;o.push((0,r.copy_date)(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>s););return o}(t,e),a=this.days;return{major:(0,c.concat)(o.map((t=>((t,e)=>{const n=t.getUTCMonth(),s=[];for(const o of a){const a=(0,r.copy_date)(t);a.setUTCDate(o),new Date(a.getTime()+e/2).getUTCMonth()==n&&s.push(a)}return s})(t,this.interval)))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.DaysTicker=_,a=_,_.__name__="DaysTicker",a.define((({Int:t,List:e})=>({days:[e(t),[]]}))),a.override({num_minor_ticks:0})},
function _(e,n,t,r,i){var a;r();const l=e(212);class s extends l.ContinuousTicker{constructor(e){super(e)}get_interval(e,n,t){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}t.BaseSingleIntervalTicker=s,s.__name__="BaseSingleIntervalTicker";class _ extends s{constructor(e){super(e)}}t.SingleIntervalTicker=_,a=_,_.__name__="SingleIntervalTicker",a.define((({Float:e})=>({interval:[e]})))},
function _(t,_,e,n,N){function O(t){return new Date(t.getTime())}function E(t){const _=O(t);return _.setUTCDate(1),_.setUTCHours(0),_.setUTCMinutes(0),_.setUTCSeconds(0),_.setUTCMilliseconds(0),_}n(),e.copy_date=O,e.last_month_no_later_than=E,e.last_year_no_later_than=function(t){const _=E(t);return _.setUTCMonth(0),_},e.ONE_NANO=1e-6,e.ONE_MICRO=.001,e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY},
function _(t,e,n,a,s){var r;a();const i=t(219),o=t(220),l=t(10);class _ extends i.BaseSingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH}get_ticks_no_defaults(t,e,n,a){const s=function(t,e){const n=(0,o.last_year_no_later_than)(new Date(t)),a=(0,o.last_year_no_later_than)(new Date(e));a.setUTCFullYear(a.getUTCFullYear()+1);const s=[],r=n;for(;s.push((0,o.copy_date)(r)),r.setUTCFullYear(r.getUTCFullYear()+1),!(r>a););return s}(t,e),r=this.months;return{major:(0,l.concat)(s.map((t=>r.map((e=>{const n=(0,o.copy_date)(t);return n.setUTCMonth(e),n}))))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.MonthsTicker=_,r=_,_.__name__="MonthsTicker",r.define((({Int:t,List:e})=>({months:[e(t),[]]})))},
function _(e,t,a,r,_){r();const n=e(210),s=e(219),i=e(220);class c extends s.BaseSingleIntervalTicker{constructor(e){super(e),this.interval=i.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,r){const _=(0,i.last_year_no_later_than)(new Date(e)).getUTCFullYear(),n=(0,i.last_year_no_later_than)(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(_,n,a,r).major.map((e=>Date.UTC(e,0,1))).filter((a=>e<=a&&a<=t)),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(t,e,r,i,n){var s;i();const _=t(212);class c extends _.ContinuousTicker{constructor(t){super(t)}get_ticks_no_defaults(t,e,r,i){return{major:[...this.ticks],minor:[...this.minor_ticks]}}get_interval(t,e,r){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}r.FixedTicker=c,s=c,c.__name__="FixedTicker",s.define((({Float:t,Arrayable:e})=>({ticks:[e(t),[]],minor_ticks:[e(t),[]]})))},
function _(t,o,e,s,i){var n;s();const r=t(211),a=t(10);class f extends r.AdaptiveTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,e,s){const i=this.num_minor_ticks,n=[],r=this.base,f=Math.log(t)/Math.log(r),c=Math.log(o)/Math.log(r),l=c-f;let h;if(isFinite(l)&&0!=l)if(l<2){const e=this.get_interval(t,o,s),r=Math.floor(t/e),f=Math.ceil(o/e);if(h=(0,a.range)(r,f+1).filter((t=>0!=t)).map((t=>t*e)).filter((e=>t<=e&&e<=o)),i>0&&h.length>0){const t=e/i,o=(0,a.range)(0,i).map((o=>o*t));for(const t of o.slice(1))n.push(h[0]-t);for(const t of h)for(const e of o)n.push(t+e)}}else{const e=1e-6,s=1-Math.sign(f)*e,l=1+Math.sign(c)*e,g=Math.ceil(f*s),M=Math.floor(c*l),m=Math.ceil((M-g)/9);if(h=(0,a.range)(g-1,M+1,1).map((t=>r**t)).filter((e=>t<=e&&e<=o)).filter(((t,o)=>o%m==0)),i>0&&h.length>0){const t=r**m/i,o=(0,a.range)(1,i+1).map((o=>o*t)),e=Math.max(...o);for(const t of o)n.push(h[0]*(t/e));for(const t of h)for(const e of o)n.push(t*e)}}else h=[];return{major:h.filter((e=>t<=e&&e<=o)),minor:n.filter((e=>t<=e&&e<=o))}}}e.LogTicker=f,n=f,f.__name__="LogTicker",n.override({mantissas:[1,5]})},
function _(t,o,n,s,r){var e;s();const i=t(210),c=t(21),_=t(148);class a extends i.BasicTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,n,s){if(null==this.dimension)throw new Error(`${this}.dimension wasn't configured`);return[t,o]=(0,_.clip_mercator)(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,s):this._get_ticks_lat(t,o,n,s)}_get_ticks_lon(t,o,n,s){const[r]=_.wgs84_mercator.invert(t,n),[e,i]=_.wgs84_mercator.invert(o,n),c=super.get_ticks_no_defaults(r,e,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,s){const[,r]=_.wgs84_mercator.invert(n,t),[e,i]=_.wgs84_mercator.invert(n,o),c=super.get_ticks_no_defaults(r,i,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=a,e=a,a.__name__="MercatorTicker",e.define((({Nullable:t})=>({dimension:[t(c.LatLon),null]})))},
function _(i,e,n,a,t){var s;a();const _=i(211),r=i(215),m=i(220);class c extends r.CompositeTicker{constructor(i){super(i)}}n.TimedeltaTicker=c,s=c,c.__name__="TimedeltaTicker",s.override({num_minor_ticks:0,tickers:()=>[new _.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*m.ONE_MILLI,num_minor_ticks:0}),new _.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:m.ONE_SECOND,max_interval:30*m.ONE_MINUTE,num_minor_ticks:0}),new _.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:m.ONE_HOUR,max_interval:12*m.ONE_HOUR,num_minor_ticks:0}),new _.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:m.ONE_DAY,max_interval:null,num_minor_ticks:0})]})},
function _(e,n,t,r,i){var o;r();const a=e(204),s=e(228),c=e(13);class _ extends a.Ticker{constructor(e){super(e)}get_ticks(e,n,t,r){const{binning:i}=this.mapper.metrics,o=Math.max(0,(0,c.left_edge_index)(e,i)),a=Math.min((0,c.left_edge_index)(n,i)+1,i.length-1),s=[];for(let e=o;e<=a;e++)s.push(i[e]);const{num_major_ticks:_}=this,m=[],h="auto"==_?s.length:_,l=Math.max(1,Math.floor(s.length/h));for(let e=0;e<s.length;e+=l)m.push(s[e]);return{major:m,minor:[]}}}t.BinnedTicker=_,o=_,_.__name__="BinnedTicker",o.define((({Float:e,Ref:n,Or:t,Auto:r})=>({mapper:[n(s.ScanningColorMapper)],num_major_ticks:[t(e,r),8]})))},
function _(n,i,e,t,a){t();const o=n(229),_=n(13);class r extends o.ContinuousColorMapper{constructor(n){super(n)}index_to_value(n){return this._scan_data.binning[n]}value_to_index(n,i){const e=this._scan_data;return n<e.binning[0]?-1:n>e.binning[e.binning.length-1]?i:(0,_.left_edge_index)(n,e.binning)}}e.ScanningColorMapper=r,r.__name__="ScanningColorMapper"},
function _(t,o,e,n,l){var s;n();const i=t(230),c=t(232),a=t(10),h=t(8);class r extends i.ColorMapper{constructor(t){super(t),this._scan_data=null}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,(()=>this.update_data())),this.connect(t.data_source.selected.change,(()=>this.update_data()))},{high:o,low:e,high_color:n,low_color:l,palette:s,nan_color:i}=this.properties;this.on_change([o,e,n,l,s,i],(()=>this.update_data())),this.connect(this.properties.domain.change,(()=>t())),t()}update_data(){const{domain:t,palette:o}=this,e=[...this._collect(t)];this._scan_data=this.scan(e,o.length),this.metrics_change.emit(),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[o,e]of t)for(const t of(0,h.isArray)(e)?e:[e]){if(o.view.properties.indices.is_unset)continue;const e=o.data_source.get_column(t);if(null==e)continue;let n=o.view.indices.select(e);const l=o.view.masked,s=o.data_source.selected.indices;let i;if(null!=l&&s.length>0?i=(0,a.intersection)([...l],s):null!=l?i=[...l]:s.length>0&&(i=s),null!=i&&(n=(0,a.map)(i,(t=>n[t]))),n.length>0&&!(0,h.isNumber)(n[0]))for(const t of n)yield*t;else yield*n}}_v_compute(t,o,e,n){const{nan_color:l}=n;let{low_color:s,high_color:i}=n;null==s&&(s=e[0]),null==i&&(i=e[e.length-1]);const{domain:c}=this,h=(0,a.is_empty)(c)?t:[...this._collect(c)];this._scan_data=this.scan(h,e.length),this.metrics_change.emit();for(let n=0,c=t.length;n<c;n++){const c=t[n];isNaN(c)?o[n]=l:o[n]=this.cmap(c,e,s,i)}}_colors(t){return{...super._colors(t),low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0}}cmap(t,o,e,n){const l=this.value_to_index(t,o.length);return l<0?e:l>=o.length?n:o[l]}}e.ContinuousColorMapper=r,s=r,r.__name__="ContinuousColorMapper",s.define((({Float:t,Str:o,Ref:e,Color:n,Or:l,Tuple:s,List:i,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(n),null],low_color:[a(n),null],domain:[i(s(e(c.GlyphRenderer),l(o,i(o)))),[]]})))},
function _(t,e,n,r,o){var i;r(),n.convert_to_uint32_color=u,n.convert_to_uint32_palette=h;const a=t(231),c=t(16),_=t(25),s=t(23),l=t(28),p=t(31);function u(t){return(0,s.encode_rgba)((0,s.color2rgba)(t))}function h(t){const e=new Uint32Array(t.length);for(let n=0,r=t.length;n<r;n++)e[n]=u(t[n]);return e}class g extends a.Mapper{constructor(t){super(t)}initialize(){super.initialize(),this.metrics_change=new c.Signal0(this,"metrics_change")}v_compute(t){const e=new Uint32Array(t.length);return this._v_compute(t,e,h(this.palette),this._colors(u)),new p.Uint32NDArray(e)}get rgba_mapper(){const t=this,e=h(this.palette),n=this._colors(u);return{v_compute(r){const o=(0,p.is_NDArray)(r)&&3==r.dimension?r.shape[2]:1,i=new _.ColorArray(r.length/o);return t._v_compute(r,i,e,n),new Uint8ClampedArray((0,l.to_big_endian)(i).buffer)}}}_colors(t){return{nan_color:t(this.nan_color)}}}n.ColorMapper=g,i=g,g.__name__="ColorMapper",i.define((({Color:t,List:e})=>({palette:[e(t)],nan_color:[t,"gray"]})))},
function _(r,e,n,s,o){s();const p=r(109);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(e,t,i,s,l){var h;s();const n=e(233),a=e(234),o=e(244),_=e(245),c=e(248),d=e(249),p=e(250),r=e(236),g=e(142),y=e(251),u=e(25),m=e(13),v=e(9),w=e(69),f=e(27),b=e(121),V=e(241),z={fill:{},line:{}},x={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},G={fill:{fill_alpha:.2},line:{}},R={fill:{fill_alpha:.2},line:{}};class k extends n.DataRendererView{get glyph_view(){return this.glyph}*children(){yield*super.children(),yield this.cds_view,yield this.glyph,yield this.selection_glyph,yield this.nonselection_glyph,null!=this.hover_glyph&&(yield this.hover_glyph),yield this.muted_glyph,yield this.decimated_glyph}get data_source(){return this.model.properties.data_source}async lazy_initialize(){await super.lazy_initialize(),this.cds_view=await(0,w.build_view)(this.model.view,{parent:this});const e=this.model.glyph;this.glyph=await this.build_glyph_view(e);const t="fill"in this.glyph.visuals,i="line"in this.glyph.visuals,s={...e.attributes};function l(l){const h=(0,v.clone)(s);return t&&(0,v.extend)(h,l.fill),i&&(0,v.extend)(h,l.line),new e.constructor(h)}function h(e,t){return t instanceof r.Glyph?t:l("auto"==t?e:{fill:{},line:{}})}delete s.id;let{selection_glyph:n,nonselection_glyph:a,hover_glyph:o,muted_glyph:_}=this.model;n=h(z,n),this.selection_glyph=await this.build_glyph_view(n),a=h(G,a),this.nonselection_glyph=await this.build_glyph_view(a),null!=o&&(this.hover_glyph=await this.build_glyph_view(o)),_=h(R,_),this.muted_glyph=await this.build_glyph_view(_);const c=h(x,"auto");this.decimated_glyph=await this.build_glyph_view(c),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),this.hover_glyph?.set_base(this.glyph),this.muted_glyph.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),await this.set_data()}async build_glyph_view(e){return(0,w.build_view)(e,{parent:this})}remove(){this.cds_view.remove(),this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),this.hover_glyph?.remove(),this.muted_glyph.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals();const e=()=>this.request_paint(),t=()=>this.update_data();this.connect(this.model.change,e),this.connect(this.glyph.model.change,t),this.connect(this.selection_glyph.model.change,t),this.connect(this.nonselection_glyph.model.change,t),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,t),this.connect(this.muted_glyph.model.change,t),this.connect(this.decimated_glyph.model.change,t),this.connect(this.model.data_source.change,t),this.connect(this.model.data_source.streaming,t),this.connect(this.model.data_source.patching,(e=>this.update_data(e))),this.connect(this.model.data_source.selected.change,e),this.connect(this.model.data_source._select,e),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(()=>{const{inspected:t}=this.model.data_source,i={indices:t.indices,line_indices:t.line_indices,multiline_indices:t.multiline_indices,image_indices:t.image_indices,selected_glyphs:t.selected_glyphs};(0,f.is_equal)(this._previous_inspected,i)||(this._previous_inspected=i,e())})),this.connect(this.model.properties.view.change,(async()=>{this.cds_view.remove(),this.cds_view=await(0,w.build_view)(this.model.view,{parent:this}),await t()})),this.connect(this.model.view.properties.indices.change,t),this.connect(this.model.view.properties.masked.change,(async()=>await this.set_visuals())),this.connect(this.model.properties.visible.change,(()=>this.plot_view.invalidate_dataranges=!0));const{x_ranges:i,y_ranges:s}=this.plot_view.frame;for(const[,e]of i)e instanceof b.FactorRange&&this.connect(e.invalidate_synthetic,t);for(const[,e]of s)e instanceof b.FactorRange&&this.connect(e.invalidate_synthetic,t);const{transformchange:l,exprchange:h}=this.model.glyph;this.connect(l,t),this.connect(h,t)}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}async update_data(e){await this.set_data(e),this.request_paint()}async set_data(e){const t=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:i}=this;await this.glyph.set_data(t,i,e),await this.decimated_glyph.set_data(t,i,e),await this.selection_glyph.set_data(t,i,e),await this.nonselection_glyph.set_data(t,i,e),await(this.hover_glyph?.set_data(t,i,e)),await this.muted_glyph.set_data(t,i,e),await this.set_visuals(),this._update_masked_indices();const{lod_factor:s}=this.plot_model,l=this.all_indices.count;this.decimated=new u.Indices(l);for(let e=0;e<l;e+=s)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0}async set_visuals(){const e=this.model.data_source,{all_indices:t}=this;this.glyph.set_visuals(e,t),this.glyph.after_visuals(),await this.glyph.after_lazy_visuals(),this.decimated_glyph.set_visuals(e,t),this.decimated_glyph.after_visuals(),await this.decimated_glyph.after_lazy_visuals(),this.selection_glyph.set_visuals(e,t),this.selection_glyph.after_visuals(),await this.selection_glyph.after_lazy_visuals(),this.nonselection_glyph.set_visuals(e,t),this.nonselection_glyph.after_visuals(),await this.nonselection_glyph.after_lazy_visuals(),this.hover_glyph?.set_visuals(e,t),this.hover_glyph?.after_visuals(),await(this.hover_glyph?.after_lazy_visuals()),this.muted_glyph.set_visuals(e,t),this.muted_glyph.after_visuals(),await this.muted_glyph.after_lazy_visuals()}map_data(){this.glyph.map_data(),this.decimated_glyph.map_data(),this.selection_glyph.map_data(),this.nonselection_glyph.map_data(),this.hover_glyph?.map_data(),this.muted_glyph.map_data()}get bbox(){return this.glyph.bbox}get has_webgl(){return this.glyph.has_webgl()}_paint(e){const{has_webgl:t}=this;this.map_data();const i=this.all_indices.ones();let s=this._update_masked_indices().ones();const{selected:l}=this.model.data_source,h=(()=>l.is_empty()?[]:this.glyph instanceof a.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(s):l.indices)(),{inspected:n}=this.model.data_source;this._previous_inspected={indices:n.indices,line_indices:n.line_indices,multiline_indices:n.multiline_indices,image_indices:n.image_indices,selected_glyphs:n.selected_glyphs};const r=new Set((()=>n.is_empty()?[]:null!=n.selected_glyph?this.model.view.convert_indices_from_subset(s):n.indices.length>0?n.indices:Object.keys(n.multiline_indices).map((e=>parseInt(e))))()),g=0===r.size?[]:(0,m.filter)(s,(e=>r.has(i[e]))),{lod_threshold:y}=this.plot_model;let u,v,w;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!t&&null!=y&&i.length>y?(s=[...this.decimated],u=this.decimated_glyph,v=this.decimated_glyph,w=this.selection_glyph):(u=this.model.muted?this.muted_glyph:this.glyph,v=this.nonselection_glyph,w=this.selection_glyph),null!=this.hover_glyph&&0!=g.length){const e=new Set(s);for(const t of g)e.delete(t);s=[...e]}if(e.save(),0==h.length)if(this.glyph instanceof a.LineView)null!=this.hover_glyph&&0!=g.length?this.hover_glyph.paint(e,this.model.view.convert_indices_from_subset(g)):u.paint(e,i);else if(this.glyph instanceof o.PatchView||this.glyph instanceof c.HAreaView||this.glyph instanceof p.VAreaView||this.glyph instanceof d.VAreaStepView||this.glyph instanceof _.HAreaStepView)if(0==n.selected_glyphs.length||null==this.hover_glyph)u.paint(e,i);else for(const t of n.selected_glyphs)t==this.glyph.model&&this.hover_glyph.paint(e,i);else u.paint(e,s),null!=this.hover_glyph&&0!=g.length&&this.hover_glyph.paint(e,g);else{const t=new Set(h),l=new Array,n=new Array;if(this.glyph instanceof a.LineView)for(const e of i)t.has(e)?l.push(e):n.push(e);else for(const e of s)t.has(i[e])?l.push(e):n.push(e);v.paint(e,n),w.paint(e,l),null!=this.hover_glyph&&(this.glyph instanceof a.LineView?this.hover_glyph.paint(e,this.model.view.convert_indices_from_subset(g)):this.hover_glyph.paint(e,g))}e.restore()}get_reference_point(e,t){if(null!=e){const i=this.model.data_source.get_column(e);if(null!=i)for(const[e,s]of this.model.view.indices_map)if(i[e]==t)return s}return 0}draw_legend(e,t,i,s,l,h,n,a){if(0==this.glyph.data_size)return;const o=(()=>{if(null==a)return this.get_reference_point(h,n);{const{indices_map:e}=this.model.view;return e.get(a)}})();null!=o&&this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=k,k.__name__="GlyphRendererView";class S extends n.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.data_source.selection_manager}add_decoration(e,t){const i=new V.Decoration({marking:e,node:t}),s=[this.glyph,this.selection_glyph,this.nonselection_glyph,this.hover_glyph,this.muted_glyph];for(const e of s)e instanceof r.Glyph&&(e.decorations=[...e.decorations,i]);return i}}i.GlyphRenderer=S,h=S,S.__name__="GlyphRenderer",h.prototype.default_view=k,h.define((({Bool:e,Auto:t,Or:i,Ref:s,Null:l,Nullable:h})=>({data_source:[s(g.ColumnarDataSource)],view:[s(y.CDSView),()=>new y.CDSView],glyph:[s(r.Glyph)],hover_glyph:[h(s(r.Glyph)),null],nonselection_glyph:[i(s(r.Glyph),t,l),"auto"],selection_glyph:[i(s(r.Glyph),t,l),"auto"],muted_glyph:[i(s(r.Glyph),t,l),"auto"],muted:[e,!1]})))},
function _(e,r,n,t,s){var a,o;t();const _=e(98),i=e(118);class c extends _.RendererView{constructor(){super(...arguments),this[a]=!0}get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}bounds(e="none"){return this.glyph_view.bounds(e)}log_bounds(){return this.glyph_view.log_bounds()}}n.DataRendererView=c,a=i.auto_ranged,c.__name__="DataRendererView";class d extends _.Renderer{constructor(e){super(e)}get selection_manager(){return this.get_selection_manager()}}n.DataRenderer=d,o=d,d.__name__="DataRenderer",o.override({level:"glyph"})},
function _(e,t,i,n,s){var l;n();const o=e(1),r=e(235),_=e(242),h=o.__importStar(e(95)),a=o.__importStar(e(243)),c=e(144);class d extends r.XYGlyphView{async load_glglyph(){const{LineGL:t}=await Promise.resolve().then((()=>o.__importStar(e(591))));return t}_paint(e,t,i){const{sx:n,sy:s}={...this,...i},l=this.parent.nonselection_glyph==this;let o=null;const r=e=>null!=o&&e-o!=1;let _=!0;e.beginPath();for(const i of t){const t=n[i],h=s[i];l&&!_&&null!=o&&i-o>1&&isFinite(n[o+1]+s[o+1])&&e.lineTo(n[o+1],s[o+1]),isFinite(t+h)?(_||r(i)?(l&&i>0&&isFinite(n[i-1]+s[i-1])?(e.moveTo(n[i-1],s[i-1]),e.lineTo(t,h)):e.moveTo(t,h),_=!1):e.lineTo(t,h),o=i):_=!0}if(l&&!_&&null!=o){const t=n.length;o<t-1&&isFinite(n[o+1]+s[o+1])&&e.lineTo(n[o+1],s[o+1])}this.visuals.line.set_value(e),e.stroke()}_hit_point(e){const t=new c.Selection,i={x:e.sx,y:e.sy};let n=9999;const s=Math.max(2,this.line_width.value/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},o={x:this.sx[e+1],y:this.sy[e+1]},r=a.dist_to_segment(i,l,o);r<s&&r<n&&(n=r,t.add_to_selected_glyphs(this.model),t.view=this,t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e;let n,s;"v"==e.direction?(n=this.renderer.yscale.invert(i),s=this.y):(n=this.renderer.xscale.invert(t),s=this.x);const l=[];for(let e=0,t=s.length-1;e<t;e++){const t=s[e],i=s[e+1];(t<=n&&n<=i||i<=n&&n<=t)&&l.push(e)}const o=new c.Selection;return 0!=l.length&&(o.add_to_selected_glyphs(this.model),o.view=this,o.line_indices=l),o}get_interpolation_hit(e,t){const[i,n,s,l]=[this.x[e],this.y[e],this.x[e+1],this.y[e+1]];return(0,_.line_interpolation)(this.renderer,t,i,n,s,l)}draw_legend_for_index(e,t,i){(0,_.generic_line_scalar_legend)(this.visuals,e,t)}}i.LineView=d,d.__name__="LineView";class y extends r.XYGlyph{constructor(e){super(e)}}i.Line=y,l=y,y.__name__="Line",l.prototype.default_view=d,l.mixins(h.LineScalar)},
function _(e,t,s,i,_){var n;i();const a=e(1).__importStar(e(19)),o=e(236);class r extends o.GlyphView{_project_data(){this._project_xy("x",this.x,"y",this.y)}_index_data(e){const{x:t,y:s,data_size:i}=this;for(let _=0;_<i;_++)e.add_point(t[_],s[_])}scenterxy(e){return[this.sx[e],this.sy[e]]}}s.XYGlyphView=r,r.__name__="XYGlyphView";class y extends o.Glyph{constructor(e){super(e)}}s.XYGlyph=y,n=y,y.__name__="XYGlyph",n.define((()=>({x:[a.XCoordinateSpec,{field:"x"}],y:[a.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,i,s,n){var r;s();const a=e(1),_=a.__importStar(e(19)),o=a.__importStar(e(62)),h=a.__importStar(e(99)),c=a.__importStar(e(40)),l=e(30),d=e(64),u=e(52),f=e(69),p=e(20),y=e(25),g=e(8),x=e(237),b=e(10),m=e(13),w=e(148),S=e(27),v=e(238),z=e(12),q=e(62),$=e(121),C=e(144),N=e(241),{abs:j,ceil:A}=Math;i.inherit=Symbol("inherit");class V extends d.DOMComponentView{constructor(){super(...arguments),this._can_use_webgl=!1,this._index=null,this._data_size=null,this._nohit_warned=new Set,this.decorations=new Map,this._base=null}get renderer(){return this.parent}has_webgl(){return null!=this.glglyph&&this._can_use_webgl}_compute_can_use_webgl(){return!0}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(`${this}.index_data() wasn't called`)}get data_size(){const{base:e}=this;if(null!=e)return e.data_size;{const{_data_size:e}=this;if(null!=e)return e;throw new Error(`${this}.set_data() wasn't called`)}}initialize(){super.initialize(),this.visuals=new h.Visuals(this)}*children(){yield*super.children(),yield*this.decorations.values()}async lazy_initialize(){await super.lazy_initialize(),await(0,f.build_views)(this.decorations,this.model.decorations,{parent:this.parent});const{webgl:e}=this.canvas;if(null!=e&&null!=this.load_glglyph){const t=await this.load_glglyph();this.glglyph=new t(e.regl_wrapper,this)}}request_paint(){this.parent.request_paint()}get canvas(){return this.renderer.parent.canvas_view}paint(e,t,i){if(this.has_webgl())this.glglyph.render(e,t,this.base??this);else{if(null!=this.canvas.webgl&&l.settings.force_webgl)throw new Error(`${this} doesn't support webgl rendering`);this._paint(e,t,i)}}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(e="none"){switch(e){case"none":return this._bounds(this.index.bbox);case"x":{const e=this.renderer.coordinates.x_source;if(isNaN(e.start)||isNaN(e.end))return this._bounds(this.index.bbox);const t=o.x_range(e.start,e.end),{x0:i,y0:s,x1:n,y1:r}=this.index.bounds(t);return isFinite(s+r)?this._bounds({x0:i,y0:s,x1:n,y1:r}):this._bounds(this.index.bbox)}case"y":{const e=this.renderer.coordinates.y_source;if(isNaN(e.start)||isNaN(e.end))return this._bounds(this.index.bbox);const t=o.y_range(e.start,e.end),{x0:i,y0:s,x1:n,y1:r}=this.index.bounds(t);return isFinite(i+n)?this._bounds({x0:i,y0:s,x1:n,y1:r}):this._bounds(this.index.bbox)}}}log_bounds(){const{x0:e,x1:t}=this.index.bounds(o.positive_x()),{y0:i,y1:s}=this.index.bounds(o.positive_y());return this._bounds({x0:e,y0:i,x1:t,y1:s})}get_anchor_point(e,t,[i,s]){switch(e){case"center":case"center_center":{const[e,n]=this.scenterxy(t,i,s);return{x:e,y:n}}default:return null}}sdist(e,t,i,s="edge",n=!1){const r=t.length,a=new y.ScreenArray(r),_=e.s_compute;if("center"==s)for(let e=0;e<r;e++){const s=t[e],n=i.get(e)/2,r=_(s-n),o=_(s+n);a[e]=j(o-r)}else for(let e=0;e<r;e++){const s=t[e],n=_(s),r=_(s+i.get(e));a[e]=j(r-n)}return n&&(0,m.inplace_map)(a,(e=>A(e))),a}draw_legend_for_index(e,t,i){}hit_test(e){const t=(()=>{switch(e.type){case"point":return this._hit_point?.(e);case"span":return this._hit_span?.(e);case"rect":return this._hit_rect?.(e);case"poly":return this._hit_poly?.(e)}})();return null!=t?t:(this._nohit_warned.has(e.type)||(p.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null)}_hit_rect_against_index(e){const{sx0:t,sx1:i,sy0:s,sy1:n}=e,[r,a]=this.renderer.coordinates.x_scale.r_invert(t,i),[_,o]=this.renderer.coordinates.y_scale.r_invert(s,n),h=[...this.index.indices({x0:r,x1:a,y0:_,y1:o})];return new C.Selection({indices:h})}_project_xy(e,t,i,s){const n=this._is_inherited(e),r=this._is_inherited(i);if(n||r){if(!n||!r){const[n,r]=(0,w.project_xy)(t,s);this._define_attr(e,n),this._define_attr(i,r)}}else w.inplace.project_xy(t,s)}_project_data(){}*_iter_visuals(){for(const e of this.visuals)for(const t of e)(t instanceof _.VectorSpec||t instanceof _.ScalarSpec)&&(yield t)}get base(){return this._base}set_base(e){e!=this&&e instanceof this.constructor?this._base=e:this._base=null}_define_or_inherit_attr(e,t){const s=t();s===i.inherit?this._inherit_attr(e):this._define_attr(e,s)}_define_attr(e,t){Object.defineProperty(this,e,{configurable:!0,enumerable:!0,value:t}),this._define_inherited(e,!1)}_inherit_attr(e){const{base:t}=this;(0,z.assert)(null!=t),this._inherit_from(e,t)}_inherit_from(e,t){Object.defineProperty(this,e,{configurable:!0,enumerable:!0,get:()=>t[e]}),this._define_inherited(e,!0)}_define_inherited(e,t){Object.defineProperty(this,`inherited_${e}`,{configurable:!0,enumerable:!0,value:t})}_can_inherit_from(e,t){if(null==t)return!1;const i=t.model.property(e.attr),s=e.get_value(),n=i.get_value();try{return(0,S.is_equal)(s,n)}catch(e){if(e instanceof S.EqNotImplemented)return!1;throw e}}_is_inherited(e){return this[`inherited_${(0,g.isString)(e)?e:e.attr}`]}set_visuals(e,t){for(const i of this._iter_visuals()){const{base:s}=this;if(null!=s&&this._can_inherit_from(i,s))this._inherit_from(i.attr,s);else{const s=i.uniform(e).select(t);this._define_attr(i.attr,s)}}for(const e of this.visuals)e.update();this.has_webgl()&&this.glglyph.set_visuals_changed()}_transform_array(e,t){if(e instanceof _.CoordinateSeqSpec){if(!(null==this.renderer.data_source.get_value().get_length())&&!(0,b.every)(t,g.isArrayable)){const t=`expected a 2-d array for ${this.model.type}.${e.attr}`;throw p.logger.error(t),new Error(t)}}const{x_source:i,y_source:s}=this.renderer.coordinates,n="x"==e.dimension?i:s;if(n instanceof $.FactorRange)if(e instanceof _.CoordinateSpec)t=n.v_synthetic(t);else if(e instanceof _.CoordinateSeqSpec)for(let e=0;e<t.length;e++)t[e]=n.v_synthetic(t[e]);else _.CoordinateSeqSeqSeqSpec;let r;return r=e instanceof _.CoordinateSeqSpec?x.RaggedArray.from(t,Float64Array):(_.CoordinateSeqSeqSeqSpec,t),r}async set_data(e,t,i){const s=new Set(this._iter_visuals()),{base:n}=this;this._data_size=t.count;for(const i of this.model)if((i instanceof _.VectorSpec||i instanceof _.ScalarSpec)&&!s.has(i))if(null!=n&&this._can_inherit_from(i,n))this._inherit_from(i.attr,n),(i instanceof _.DistanceSpec||i instanceof _.ScreenSizeSpec)&&this._inherit_from(`max_${i.attr}`,n);else if(i instanceof _.BaseCoordinateSpec){const s=this._transform_array(i,t.select(i.array(e)));this._define_attr(i.attr,s)}else{const s=i.uniform(e).select(t);if(this._define_attr(i.attr,s),i instanceof _.DistanceSpec||i instanceof _.ScreenSizeSpec){const e=c.max(s);this._define_attr(`max_${i.attr}`,e)}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(i??null),await this._set_lazy_data(i??null);for(const i of this.decorations.values())i.marking.set_data(e,t);null!=this.glglyph&&(this._can_use_webgl=this._compute_can_use_webgl()),this.has_webgl()&&this.glglyph.set_data_changed(),null==n&&this.index_data()}_set_data(e){}async _set_lazy_data(e){}after_visuals(){}async after_lazy_visuals(){}get _index_size(){return this.data_size}index_data(){const e=new v.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null==this._mask_data?y.Indices.all_set(this.data_size):this._mask_data()}map_data(){const{x_scale:e,y_scale:t}=this.renderer.coordinates,{base:i}=this,s=i=>{const s="x"==i.dimension?e:t,n=this[i.attr];return n instanceof x.RaggedArray?new x.RaggedArray(n.offsets,s.v_compute(n.data)):s.v_compute(n)};for(const e of this.model)if(e instanceof _.BaseCoordinateSpec)if(null!=i&&this._is_inherited(e))this._inherit_from(`s${e.attr}`,i);else{const t=s(e);this._define_attr(`s${e.attr}`,t)}this._map_data(),this.has_webgl()&&this.glglyph.set_data_mapped()}_map_data(){}get bbox(){if(null==this.base){const{x0:e,y0:t,x1:i,y1:s}=this.index.bbox,{x_scale:n,y_scale:r}=this.renderer.coordinates,[a,_]=n.r_compute(e,i),[o,h]=r.r_compute(t,s);return q.BBox.from_rect({x0:a,y0:o,x1:_,y1:h})}}}i.GlyphView=V,V.__name__="GlyphView";class E extends u.Model{constructor(e){super(e)}}i.Glyph=E,r=E,E.__name__="Glyph",r.define((({List:e,Ref:t})=>({decorations:[e(t(N.Decoration)),[]]})))},
function _(t,s,e,r,a){var n;r();const o=t(27),h=t(12);class i{constructor(t,s){this.offsets=t,this.data=s}[(n=Symbol.toStringTag,o.equals)](t,s){return s.arrays(this.offsets,t.offsets)&&s.arrays(this.data,t.data)}get length(){return this.offsets.length}clone(){return new i(this.offsets.slice(),this.data.slice())}static from(t,s){const e=t.length;let r=0;const a=(()=>{const s=new Uint32Array(e);for(let a=0;a<e;a++){const e=t[a].length;s[a]=r,r+=e}return r<256?new Uint8Array(s):r<65536?new Uint16Array(s):s})(),n=new s(r);for(let s=0;s<e;s++)n.set(t[s],a[s]);return new i(a,n)}*[Symbol.iterator](){const{offsets:t,length:s}=this;for(let e=0;e<s;e++)yield this.data.subarray(t[e],t[e+1])}_check_bounds(t){(0,h.assert)(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:s}=this;return this.data.subarray(s[t],s[t+1])}set(t,s){this._check_bounds(t),this.data.set(s,this.offsets[t])}}e.RaggedArray=i,i.__name__="RaggedArray",i[n]="RaggedArray"},
function _(i,n,e,t,s){t();const d=i(1).__importDefault(i(239)),x=i(25),a=i(62);class r{constructor(i){this.index=null,i>0&&(this.index=new d.default(i))}add_rect(i,n,e,t){isFinite(i+n+e+t)?this.index?.add(i,n,e,t):this.add_empty()}add_point(i,n){isFinite(i+n)?this.index?.add(i,n,i,n):this.add_empty()}add_empty(){this.index?.add(1/0,1/0,-1/0,-1/0)}finish(){this.index?.finish()}_normalize(i){let{x0:n,y0:e,x1:t,y1:s}=i;return n>t&&isFinite(n+t)&&([n,t]=[t,n]),e>s&&isFinite(e+s)&&([e,s]=[s,e]),{x0:n,y0:e,x1:t,y1:s}}get bbox(){if(null==this.index)return(0,a.empty)();{const{minX:i,minY:n,maxX:e,maxY:t}=this.index;return{x0:i,y0:n,x1:e,y1:t}}}indices(i){if(null==this.index)return new x.Indices(0);const{x0:n,y0:e,x1:t,y1:s}=this._normalize(i),d=new x.Indices(this.index.numItems);return this.index.search(n,e,t,s,(i=>(d.set_unchecked(i),!1))),d}bounds(i){if(null==this.index)return(0,a.empty)();const{x0:n,y0:e,x1:t,y1:s}=this._normalize(i),d=(0,a.empty)();return this.index.search(n,e,t,s,((i,x,a,r,h)=>(x>=n&&x<d.x0&&(d.x0=x),r<=t&&r>d.x1&&(d.x1=r),a>=e&&a<d.y0&&(d.y0=a),h<=s&&h>d.y1&&(d.y1=h),!1))),d}}e.SpatialIndex=r,r.__name__="SpatialIndex"},
function _(t,s,i,e,n){e();const o=t(1).__importDefault(t(240)),h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class r{static from(t,s=0){if(s%8!=0)throw new Error("byteOffset must be 8-byte aligned.");if(!t||void 0===t.byteLength||t.buffer)throw new Error("Data must be an instance of ArrayBuffer or SharedArrayBuffer.");const[i,e]=new Uint8Array(t,s+0,2);if(251!==i)throw new Error("Data does not appear to be in a Flatbush format.");const n=e>>4;if(3!==n)throw new Error(`Got v${n} data when expected v3.`);const o=h[15&e];if(!o)throw new Error("Unrecognized array type.");const[a]=new Uint16Array(t,s+2,1),[m]=new Uint32Array(t,s+4,1);return new r(m,a,o,void 0,t,s)}constructor(t,s=16,i=Float64Array,e=ArrayBuffer,n,r=0){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535),this.byteOffset=r;let a=t,m=a;this._levelBounds=[4*a];do{a=Math.ceil(a/this.nodeSize),m+=a,this._levelBounds.push(4*m)}while(1!==a);this.ArrayType=i,this.IndexArrayType=m<16384?Uint16Array:Uint32Array;const _=h.indexOf(i),d=4*m*i.BYTES_PER_ELEMENT;if(_<0)throw new Error(`Unexpected typed array class: ${i}.`);if(n)this.data=n,this._boxes=new i(n,r+8,4*m),this._indices=new this.IndexArrayType(n,r+8+d,m),this._pos=4*m,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1];else{const n=this.data=new e(8+d+m*this.IndexArrayType.BYTES_PER_ELEMENT);this._boxes=new i(n,8,4*m),this._indices=new this.IndexArrayType(n,8+d,m),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(n,0,2).set([251,48+_]),new Uint16Array(n,2,1)[0]=s,new Uint32Array(n,4,1)[0]=t}this._queue=new o.default}add(t,s,i=t,e=s){const n=this._pos>>2,o=this._boxes;return this._indices[n]=n,o[this._pos++]=t,o[this._pos++]=s,o[this._pos++]=i,o[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),n}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);const t=this._boxes;if(this.numItems<=this.nodeSize)return t[this._pos++]=this.minX,t[this._pos++]=this.minY,t[this._pos++]=this.maxX,void(t[this._pos++]=this.maxY);const s=this.maxX-this.minX||1,i=this.maxY-this.minY||1,e=new Uint32Array(this.numItems);for(let n=0,o=0;n<this.numItems;n++){const h=t[o++],r=t[o++],a=t[o++],m=t[o++],_=Math.floor(65535*((h+a)/2-this.minX)/s),f=Math.floor(65535*((r+m)/2-this.minY)/i);e[n]=d(_,f)}m(e,t,this._indices,0,this.numItems-1,this.nodeSize);for(let s=0,i=0;s<this._levelBounds.length-1;s++){const e=this._levelBounds[s];for(;i<e;){const s=i;let n=t[i++],o=t[i++],h=t[i++],r=t[i++];for(let s=1;s<this.nodeSize&&i<e;s++)n=Math.min(n,t[i++]),o=Math.min(o,t[i++]),h=Math.max(h,t[i++]),r=Math.max(r,t[i++]);this._indices[this._pos>>2]=s,t[this._pos++]=n,t[this._pos++]=o,t[this._pos++]=h,t[this._pos++]=r}}}search(t,s,i,e,n){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let o=this._boxes.length-4;const h=[],r=[];for(;void 0!==o;){const m=Math.min(o+4*this.nodeSize,a(o,this._levelBounds));for(let a=o;a<m;a+=4){const m=this._boxes[a];if(i<m)continue;const _=this._boxes[a+1];if(e<_)continue;const d=this._boxes[a+2];if(t>d)continue;const f=this._boxes[a+3];if(s>f)continue;const l=0|this._indices[a>>2];o>=4*this.numItems?h.push(l):(void 0===n||n(l,m,_,d,f))&&r.push(l)}o=h.pop()}return r}neighbors(t,s,i=1/0,e=1/0,n){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let o=this._boxes.length-4;const h=this._queue,r=[],m=e*e;t:for(;void 0!==o;){const e=Math.min(o+4*this.nodeSize,a(o,this._levelBounds));for(let i=o;i<e;i+=4){const e=0|this._indices[i>>2],r=this._boxes[i],a=this._boxes[i+1],_=this._boxes[i+2],d=this._boxes[i+3],f=t<r?r-t:t>_?t-_:0,l=s<a?a-s:s>d?s-d:0,c=f*f+l*l;c>m||(o>=4*this.numItems?h.push(e<<1,c):(void 0===n||n(e))&&h.push(1+(e<<1),c))}for(;h.length&&1&h.peek();){if(h.peekValue()>m)break t;if(r.push(h.pop()>>1),r.length===i)break t}o=h.length?h.pop()>>1:void 0}return h.clear(),r}}function a(t,s){let i=0,e=s.length-1;for(;i<e;){const n=i+e>>1;s[n]>t?e=n:i=n+1}return s[i]}function m(t,s,i,e,n,o){if(Math.floor(e/o)>=Math.floor(n/o))return;const h=t[e],r=t[e+n>>1],a=t[n];let d=a;const f=Math.max(h,r);a>f?d=f:f===h?d=Math.max(r,a):f===r&&(d=Math.max(h,a));let l=e-1,c=n+1;for(;;){do{l++}while(t[l]<d);do{c--}while(t[c]>d);if(l>=c)break;_(t,s,i,l,c)}m(t,s,i,e,c,o),m(t,s,i,c+1,n,o)}function _(t,s,i,e,n){const o=t[e];t[e]=t[n],t[n]=o;const h=4*e,r=4*n,a=s[h],m=s[h+1],_=s[h+2],d=s[h+3];s[h]=s[r],s[h+1]=s[r+1],s[h+2]=s[r+2],s[h+3]=s[r+3],s[r]=a,s[r+1]=m,s[r+2]=_,s[r+3]=d;const f=i[e];i[e]=i[n],i[n]=f}function d(t,s){let i=t^s,e=65535^i,n=65535^(t|s),o=t&(65535^s),h=i|e>>1,r=i>>1^i,a=n>>1^e&o>>1^n,m=i&n>>1^o>>1^o;i=h,e=r,n=a,o=m,h=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&n>>2^e&o>>2,m^=e&n>>2^(i^e)&o>>2,i=h,e=r,n=a,o=m,h=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&n>>4^e&o>>4,m^=e&n>>4^(i^e)&o>>4,i=h,e=r,n=a,o=m,a^=i&n>>8^e&o>>8,m^=e&n>>8^(i^e)&o>>8,i=a^a>>1,e=m^m>>1;let _=t^s,d=e|65535^(_|i);return _=16711935&(_|_<<8),_=252645135&(_|_<<4),_=858993459&(_|_<<2),_=1431655765&(_|_<<1),d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),(d<<1|_)>>>0}i.default=r},
function _(t,s,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(t,s){let i=this.length++;for(;i>0;){const t=i-1>>1,h=this.values[t];if(s>=h)break;this.ids[i]=this.ids[t],this.values[i]=h,i=t}this.ids[i]=t,this.values[i]=s}pop(){if(0===this.length)return;const t=this.ids,s=this.values,i=t[0],h=--this.length;if(h>0){const i=t[h],e=s[h];let l=0;const n=h>>1;for(;l<n;){const i=1+(l<<1),n=i+1,r=i+(+(n<h)&+(s[n]<s[i]));if(s[r]>=e)break;t[l]=t[r],s[l]=s[r],l=r}t[l]=i,s[l]=e}return i}peek(){return this.length>0?this.ids[0]:void 0}peekValue(){return this.length>0?this.values[0]:void 0}shrink(){this.ids.length=this.values.length=this.length}}},
function _(e,i,n,a,t){var r;a();const o=e(183),s=e(52),d=e(65),l=e(69);class c extends d.View{*children(){yield*super.children(),yield this.marking}async lazy_initialize(){await super.lazy_initialize(),this.marking=await(0,l.build_view)(this.model.marking,{parent:this.parent})}}n.DecorationView=c,c.__name__="DecorationView";class _ extends s.Model{constructor(e){super(e)}}n.Decoration=_,r=_,_.__name__="Decoration",r.prototype.default_view=c,r.define((({Enum:e,Ref:i})=>({marking:[i(o.Marking)],node:[e("start","middle","end")]})))},
function _(e,n,t,a,i){a(),t.generic_line_scalar_legend=function(e,n,{x0:t,x1:a,y0:i,y1:l}){n.save(),n.beginPath(),n.moveTo(t,(i+l)/2),n.lineTo(a,(i+l)/2),e.line.apply(n),n.restore()},t.generic_line_vector_legend=r,t.generic_line_legend=r,t.generic_area_scalar_legend=function(e,n,{x0:t,x1:a,y0:i,y1:l}){const r=.1*Math.abs(a-t),c=.1*Math.abs(l-i),_=t+r,o=a-r,s=i+c,y=l-c;n.beginPath(),n.rect(_,s,o-_,y-s),e.fill.apply(n),e.hatch?.apply(n),e.line?.apply(n)},t.generic_area_vector_legend=c,t.generic_area_legend=c,t.line_interpolation=function(e,n,t,a,i,r){const{sx:c,sy:_}=n;let o,s,y,p;"point"==n.type?([y,p]=e.yscale.r_invert(_-1,_+1),[o,s]=e.xscale.r_invert(c-1,c+1)):"v"==n.direction?([y,p]=e.yscale.r_invert(_,_),[o,s]=[Math.min(t-1,i-1),Math.max(t+1,i+1)]):([o,s]=e.xscale.r_invert(c,c),[y,p]=[Math.min(a-1,r-1),Math.max(a+1,r+1)]);const{x:g,y:h}=l.check_2_segments_intersect(o,y,s,p,t,a,i,r);return[g,h]};const l=e(1).__importStar(e(243));function r(e,n,{x0:t,x1:a,y0:i,y1:l},r){n.save(),n.beginPath(),n.moveTo(t,(i+l)/2),n.lineTo(a,(i+l)/2),e.line.apply(n,r),n.restore()}function c(e,n,{x0:t,x1:a,y0:i,y1:l},r){const c=.1*Math.abs(a-t),_=.1*Math.abs(l-i),o=t+c,s=a-c,y=i+_,p=l-_;n.beginPath(),n.rect(o,y,s-o,p-y),e.fill.apply(n,r),e.hatch?.apply(n,r),e.line?.apply(n,r)}},
function _(t,n,e,r,i){function o(t,n,e,r){let i=!1,o=e[e.length-1],u=r[r.length-1];for(let l=0;l<e.length;l++){const h=e[l],s=r[l];u<n!=s<n&&o+(n-u)/(s-u)*(h-o)<t&&(i=!i),o=h,u=s}return i}function u(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function l(t,n,e){const r=u(n,e);if(0==r)return u(t,n);const i=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/r;if(i<0)return u(t,n);if(i>1)return u(t,e);return u(t,{x:n.x+i*(e.x-n.x),y:n.y+i*(e.y-n.y)})}function h(t,n,e,r,i,o,u,l){const h=(l-o)*(e-t)-(u-i)*(r-n);if(0==h)return{hit:!1,x:null,y:null};{let s=n-o,f=t-i;const c=(e-t)*s-(r-n)*f;s=((u-i)*s-(l-o)*f)/h,f=c/h;return{hit:s>0&&s<1&&f>0&&f<1,x:t+s*(e-t),y:n+s*(r-n)}}}r(),e.point_in_poly=o,e.point_in_ellipse=function(t,n,e,r,i,o,u){const l=(Math.cos(e)/i)**2+(Math.sin(e)/r)**2,h=2*Math.cos(e)*Math.sin(e)*((1/i)**2-(1/r)**2),s=(Math.cos(e)/r)**2+(Math.sin(e)/i)**2;return l*(t-o)**2+h*(t-o)*(n-u)+s*(n-u)**2<=1},e.dist_2_pts=u,e.dist_to_segment_squared=l,e.dist_to_segment=function(t,n,e){return Math.sqrt(l(t,n,e))},e.check_2_segments_intersect=h,e.vertex_overlap=function(t,n,e,r){for(let i=0;i<t.length;i++)if(o(t[i],n[i],e,r))return!0;for(let i=0;i<e.length;i++)if(o(e[i],r[i],t,n))return!0;return!1},e.edge_intersection=function(t,n,e,r){for(let i=0;i<t.length-1;i++){for(let o=0;o<e.length-1;o++)if(h(t[i],n[i],t[i+1],n[i+1],e[o],r[o],e[o+1],r[o+1]).hit)return!0;if(h(t[i],n[i],t[i+1],n[i+1],e[e.length-1],r[e.length-1],e[0],r[0]).hit)return!0}if(h(t[t.length-1],n[t.length-1],t[0],n[0],e[e.length-1],r[e.length-1],e[0],r[0]).hit)return!0;return!1}},
function _(t,s,i,e,a){var l;e();const n=t(1),_=t(235),o=t(242),c=n.__importStar(t(243)),h=n.__importStar(t(95)),r=t(144);class p extends _.XYGlyphView{_paint(t,s,i){const{sx:e,sy:a}={...this,...i};let l=!0;t.beginPath();for(const i of s){const s=e[i],n=a[i];isFinite(s+n)?l?(t.moveTo(s,n),l=!1):t.lineTo(s,n):(t.closePath(),l=!0)}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)}draw_legend_for_index(t,s,i){(0,o.generic_area_scalar_legend)(this.visuals,t,s)}_hit_point(t){const s=new r.Selection;return c.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(s.add_to_selected_glyphs(this.model),s.view=this),s}}i.PatchView=p,p.__name__="PatchView";class d extends _.XYGlyph{constructor(t){super(t)}}i.Patch=d,l=d,d.__name__="Patch",l.prototype.default_view=p,l.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])},
function _(e,t,i,s,n){var o;s();const _=e(1),r=e(246),a=_.__importStar(e(243)),l=_.__importStar(e(19)),h=e(21),c=e(247),p=e(144);class d extends r.AreaView{_index_data(e){const{min:t,max:i}=Math,{x1:s,x2:n,y:o}=this;for(let _=0;_<this.data_size;_++){const r=s[_],a=n[_],l=o[_];e.add_rect(t(r,a),l,i(r,a),l)}}_step_path(e,t,i,s,n,o){let _=i[n],r=s[n];const a=n<o?1:-1;for(let l=n+a;l!=o;l+=a){switch(t){case"before":e.lineTo(i[l],r),e.lineTo(i[l],s[l]);break;case"after":e.lineTo(_,s[l]),e.lineTo(i[l],s[l]);break;case"center":{const t=(r+s[l])/2;e.lineTo(_,t),e.lineTo(i[l],t),e.lineTo(i[l],s[l]);break}}_=i[l],r=s[l]}}_paint(e,t,i){const{sx1:s,sx2:n,sy:o}={...this,...i},_=this.model.step_mode,r=(0,c.flip_step_mode)(this.model.step_mode);e.beginPath(),e.moveTo(s[0],o[0]),this._step_path(e,_,s,o,0,o.length),this._step_path(e,r,n,o,o.length,-1),e.closePath(),this.visuals.fill.apply(e),this.visuals.hatch.apply(e)}scenterxy(e){return[(this.sx1[e]+this.sx2[e])/2,this.sy[e]]}_line_selection_for(e){return new p.Selection({line_indices:[e],selected_glyphs:[this.model],view:this})}_hit_point_before(e){const{sy:t,sx1:i,sx2:s}=this;for(let n=1;n<this.data_size;n++){const o=[i[n],i[n],s[n],s[n]],_=[t[n-1],t[n],t[n],t[n-1]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_after(e){const{sy:t,sx1:i,sx2:s}=this;for(let n=0;n<this.data_size-1;n++){const o=[i[n],i[n],s[n],s[n]],_=[t[n],t[n+1],t[n+1],t[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_center(e){const{sy:t,sx1:i,sx2:s}=this;for(let n=0;n<this.data_size;n++){const o=(t[n-1]+t[n])/2,_=(t[n]+t[n+1])/2,r=[i[n],i[n],s[n],s[n]],l=(()=>0==n?[t[n],_,_,t[n]]:n==this.data_size-1?[o,t[n],t[n],o]:[o,_,_,o])();if(a.point_in_poly(e.sx,e.sy,r,l))return this._line_selection_for(n)}return new p.Selection}_hit_point(e){switch(this.model.step_mode){case"before":return this._hit_point_before(e);case"after":return this._hit_point_after(e);case"center":return this._hit_point_center(e)}}}i.HAreaStepView=d,d.__name__="HAreaStepView";class f extends r.Area{constructor(e){super(e)}}i.HAreaStep=f,o=f,f.__name__="HAreaStep",o.prototype.default_view=d,o.define((({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}],step_mode:[h.StepMode,"before"]})))},
function _(e,a,r,_,s){var n;_();const i=e(1),l=e(236),c=e(242),t=i.__importStar(e(95));class d extends l.GlyphView{draw_legend_for_index(e,a,r){(0,c.generic_area_scalar_legend)(this.visuals,e,a)}}r.AreaView=d,d.__name__="AreaView";class o extends l.Glyph{constructor(e){super(e)}}r.Area=o,n=o,o.__name__="Area",n.mixins([t.FillScalar,t.HatchScalar])},
function _(e,r,t,n,c){n(),t.flip_step_mode=function(e){switch(e){case"before":return"after";case"after":return"before";case"center":return"center"}}},
function _(t,s,e,i,n){var a;i();const o=t(1),h=t(246),r=o.__importStar(t(243)),l=o.__importStar(t(19)),_=t(144);class c extends h.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this.x1[n],a=this.x2[n],o=this.y[n];t.add_rect(s(i,a),o,e(i,a),o)}}_paint(t,s,e){const{sx1:i,sx2:n,sy:a}={...this,...e};t.beginPath();for(let s=0,e=i.length;s<e;s++)t.lineTo(i[s],a[s]);for(let s=n.length-1;s>=0;s--)t.lineTo(n[s],a[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}_hit_point(t){const s=this.sy.length,e=new _.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx1[i],this.sx1[i+1],this.sx2[i+1],this.sx2[i]],n=[this.sy[i],this.sy[i+1],this.sy[i+1],this.sy[i]];if(r.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}scenterxy(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]}}e.HAreaView=c,c.__name__="HAreaView";class d extends h.Area{constructor(t){super(t)}}e.HArea=d,a=d,d.__name__="HArea",a.prototype.default_view=c,a.define((({})=>({x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,i,s,n){var o;s();const _=e(1),r=e(246),a=_.__importStar(e(243)),l=_.__importStar(e(19)),h=e(21),c=e(247),p=e(144);class d extends r.AreaView{_index_data(e){const{min:t,max:i}=Math,{x:s,y1:n,y2:o}=this;for(let _=0;_<this.data_size;_++){const r=s[_],a=n[_],l=o[_];e.add_rect(r,t(a,l),r,i(a,l))}}_step_path(e,t,i,s,n,o){let _=i[n],r=s[n];const a=n<o?1:-1;for(let l=n+a;l!=o;l+=a){switch(t){case"before":e.lineTo(_,s[l]),e.lineTo(i[l],s[l]);break;case"after":e.lineTo(i[l],r),e.lineTo(i[l],s[l]);break;case"center":{const t=(_+i[l])/2;e.lineTo(t,r),e.lineTo(t,s[l]),e.lineTo(i[l],s[l]);break}}_=i[l],r=s[l]}}_paint(e,t,i){const{sx:s,sy1:n,sy2:o}={...this,...i},_=this.model.step_mode,r=(0,c.flip_step_mode)(this.model.step_mode);e.beginPath(),e.moveTo(s[0],n[0]),this._step_path(e,_,s,n,0,s.length),this._step_path(e,r,s,o,s.length,-1),e.closePath(),this.visuals.fill.apply(e),this.visuals.hatch.apply(e)}scenterxy(e){return[this.sx[e],(this.sy1[e]+this.sy2[e])/2]}_line_selection_for(e){return new p.Selection({line_indices:[e],selected_glyphs:[this.model],view:this})}_hit_point_before(e){const{sx:t,sy1:i,sy2:s}=this;for(let n=1;n<this.data_size;n++){const o=[t[n-1],t[n],t[n],t[n-1]],_=[i[n],i[n],s[n],s[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_after(e){const{sx:t,sy1:i,sy2:s}=this;for(let n=0;n<this.data_size-1;n++){const o=[t[n],t[n+1],t[n+1],t[n]],_=[i[n],i[n],s[n],s[n]];if(a.point_in_poly(e.sx,e.sy,o,_))return this._line_selection_for(n)}return new p.Selection}_hit_point_center(e){const{sx:t,sy1:i,sy2:s}=this;for(let n=0;n<this.data_size;n++){const o=(t[n-1]+t[n])/2,_=(t[n]+t[n+1])/2,r=(()=>0==n?[t[n],_,_,t[n]]:n==this.data_size-1?[o,t[n],t[n],o]:[o,_,_,o])(),l=[i[n],i[n],s[n],s[n]];if(a.point_in_poly(e.sx,e.sy,r,l))return this._line_selection_for(n)}return new p.Selection}_hit_point(e){switch(this.model.step_mode){case"before":return this._hit_point_before(e);case"after":return this._hit_point_after(e);case"center":return this._hit_point_center(e)}}}i.VAreaStepView=d,d.__name__="VAreaStepView";class f extends r.Area{constructor(e){super(e)}}i.VAreaStep=f,o=f,f.__name__="VAreaStep",o.prototype.default_view=d,o.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}],step_mode:[h.StepMode,"before"]})))},
function _(t,s,e,i,n){var a;i();const o=t(1),h=t(246),r=o.__importStar(t(243)),l=o.__importStar(t(19)),_=t(144);class c extends h.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this.x[n],a=this.y1[n],o=this.y2[n];t.add_rect(i,s(a,o),i,e(a,o))}}_paint(t,s,e){const{sx:i,sy1:n,sy2:a}={...this,...e};t.beginPath();for(let s=0,e=n.length;s<e;s++)t.lineTo(i[s],n[s]);for(let s=a.length-1;s>=0;s--)t.lineTo(i[s],a[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}scenterxy(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]}_hit_point(t){const s=this.sx.length,e=new _.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx[i],this.sx[i+1],this.sx[i+1],this.sx[i]],n=[this.sy1[i],this.sy1[i+1],this.sy2[i+1],this.sy2[i]];if(r.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}}e.VAreaView=c,c.__name__="VAreaView";class y extends h.Area{constructor(t){super(t)}}e.VArea=y,a=y,y.__name__="VArea",a.prototype.default_view=c,a.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y1:[l.YCoordinateSpec,{field:"y1"}],y2:[l.YCoordinateSpec,{field:"y2"}]})))},
function _(e,t,i,n,s){var c;n();const a=e(52),o=e(65),r=e(25),l=e(252),_=e(253),d=e(254);class h extends o.View{initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals();const e=()=>{this.compute_indices()},t=t=>{this.connect(t.change,e)},i=t=>{this.disconnect(t.change,e)};let{filter:n}=this.model;t(n),this.on_change(this.model.properties.filter,(()=>{i(n),n=this.model.filter,t(n),e()}));const s=t=>{this.connect(t.change,e),this.connect(t.streaming,e),this.connect(t.patching,e),this.connect(t.properties.data.change,e)},c=t=>{this.disconnect(t.change,e),this.disconnect(t.streaming,e),this.disconnect(t.patching,e),this.disconnect(t.properties.data.change,e)};let a=this.parent.data_source.get_value();s(a),this.on_change(this.parent.data_source,(()=>{c(a),a=this.parent.data_source.get_value(),s(a),e()}))}compute_indices(){const e=this.parent.data_source.get_value(),t=e.get_length()??1,i=r.Indices.all_set(t),n=this.model.filter.compute_indices(e);i.intersect(n),this.model.indices=i,this.model._indices_map_to_subset()}}i.CDSViewView=h,h.__name__="CDSViewView";class p extends a.Model{constructor(e){super(e)}_indices_map_to_subset(){this._indices=[...this.indices],this.indices_map=new Map;const{_indices:e,indices_map:t}=this,i=e.length;for(let n=0;n<i;n++)t.set(e[n],n)}convert_selection_from_subset(e){return e.map((e=>this._indices[e]))}convert_selection_to_subset(e){return e.map((e=>this.indices_map.get(e)))}convert_indices_from_subset(e){return e.map((e=>this._indices[e]))}get filters(){const{filter:e}=this;return e instanceof d.IntersectionFilter?e.operands:e instanceof _.AllIndices?[]:[e]}set filters(e){0==e.length?this.filter=new _.AllIndices:1==e.length?this.filter=e[0]:this.filter=new d.IntersectionFilter({operands:e})}}i.CDSView=p,c=p,p.__name__="CDSView",c.prototype.default_view=h,c.define((({Ref:e})=>({filter:[e(l.Filter),()=>new _.AllIndices]}))),c.internal((({Int:e,Mapping:t,Ref:i,Nullable:n})=>({indices:[i(r.Indices)],indices_map:[t(e,e),new Map],masked:[n(i(r.Indices)),null]})))},
function _(e,t,n,s,c){s();const o=e(52);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(e,n,s,t,c){t();const l=e(252),_=e(25);class i extends l.Filter{constructor(e){super(e)}compute_indices(e){const n=e.get_length()??1;return _.Indices.all_set(n)}}s.AllIndices=i,i.__name__="AllIndices"},
function _(e,t,n,s,c){s();const i=e(255);class o extends i.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.intersect(t)}}n.IntersectionFilter=o,o.__name__="IntersectionFilter"},
function _(e,t,n,s,o){var i;s();const c=e(252),r=e(25);class a extends c.Filter{constructor(e){super(e)}connect_signals(){super.connect_signals();const e=()=>{this.change.emit()},t=t=>{for(const n of t)this.connect(n.change,e)},n=t=>{for(const n of t)this.disconnect(n.change,e)};let s=(()=>{const{operands:e}=this.properties;return e.is_unset?[]:e.get_value()})();t(s),this.on_change(this.properties.operands,(()=>{n(s),s=this.operands,t(s)}))}compute_indices(e){const{operands:t}=this;if(0==t.length){const t=e.get_length()??1;return r.Indices.all_set(t)}{const[n,...s]=t.map((t=>t.compute_indices(e)));for(const e of s)this._inplace_op(n,e);return n}}}n.CompositeFilter=a,i=a,a.__name__="CompositeFilter",i.define((({List:e,Ref:t})=>({operands:[e(t(c.Filter))]})))},
function _(t,r,a,e,i){e(),i("BasicTickFormatter",t(209).BasicTickFormatter),i("CategoricalTickFormatter",t(257).CategoricalTickFormatter),i("DatetimeTickFormatter",t(258).DatetimeTickFormatter),i("CustomJSTickFormatter",t(263).CustomJSTickFormatter),i("LogTickFormatter",t(264).LogTickFormatter),i("MercatorTickFormatter",t(265).MercatorTickFormatter),i("NumeralTickFormatter",t(266).NumeralTickFormatter),i("PrintfTickFormatter",t(267).PrintfTickFormatter),i("TickFormatter",t(205).TickFormatter),i("TimedeltaTickFormatter",t(268).TimedeltaTickFormatter)},
function _(t,r,o,c,a){c();const e=t(205),n=t(10);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return(0,n.copy)(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(e,t,s,n,o){var r;n(),s._get_resolution=h,s._mktime=m,s._strftime=d,s._us=f;const i=e(21),l=e(12),c=e(259),u=e(8),_=e(205),a=e(220);function h(e,t){const s=1.1*e*1e3,n=1e3*t;return s<a.ONE_MILLI?"microseconds":s<a.ONE_SECOND?"milliseconds":s<a.ONE_MINUTE?n>=a.ONE_MINUTE?"minsec":"seconds":s<a.ONE_HOUR?n>=a.ONE_HOUR?"hourmin":"minutes":s<a.ONE_DAY?"hours":s<a.ONE_MONTH?"days":s<a.ONE_YEAR?"months":"years"}function m(e){return(0,c.datetime)(e,"%Y %m %d %H %M %S").split(/\s+/).map((e=>parseInt(e,10)))}function d(e,t){const s=(0,c.sprintf)("$1%06d",f(e));return-1==(t=t.replace(/((^|[^%])(%%)*)%f/,s)).indexOf("%")?t:(0,c.datetime)(e,t)}function f(e){let t=Math.round(e/1e3%1*1e6);return e<0&&(t=(1e6+t)%1e6),t}s.resolution_order=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],s.tm_index_for_resolution={microseconds:0,milliseconds:0,seconds:5,minsec:4,minutes:4,hourmin:3,hours:3,days:0,months:0,years:0};class p extends _.TickFormatter{constructor(e){super(e)}doFormat(e,t,s){if(0==e.length)return[];const n=Math.abs(e[e.length-1]-e[0])/1e3,o=n/(e.length-1),r=(0,u.is_undefined)(s)?h(o,n):s;let i=[];for(const t of e){const e=this._compute_label(t,r);i.push(e)}if(this.hide_repeats&&(i=this._hide_repeating_labels(i)),null==this.context)return i;const l=this._compute_context_labels(e,r);return this._build_full_labels(i,l)}_compute_label(e,t){const n=d(e,this[t]),o=m(e),r=s.resolution_order.indexOf(t);let i=t,l=n;if(this.boundary_scaling){let n=!1,c=r,u=t;for(;0==o[s.tm_index_for_resolution[s.resolution_order[c]]]&&(c+=1,c!=s.resolution_order.length);){if(("minsec"==t||"hourmin"==t)&&!n){if("minsec"==t&&0==o[4]&&0!=o[5]||"hourmin"==t&&0==o[3]&&0!=o[4]){u=s.resolution_order[r-1],l=d(e,this[u]);break}n=!0}u=s.resolution_order[c],l=d(e,this[u])}i=u}const{strip_leading_zeros:c}=this;if((0,u.isBoolean)(c)&&c||(0,u.isArray)(c)&&c.includes(i)){const e=l.replace(/^0+/g,"");return e==l||Number.isInteger(Number(e[0]))?e:`0${e}`}return l}_compute_context_labels(e,t){const{context:s}=this;(0,l.assert)(null!=s);const n=[];if((0,u.isString)(s))for(const t of e)n.push(d(t,s));else n.push(...s.doFormat(e,{loc:0},t));const o=this.context_which,r=n.length;for(let e=0;e<n.length;e++)("start"==o&&0!=e||"end"==o&&e!=r-1||"center"==o&&e!=Math.floor(r/2))&&(n[e]="");return n}_build_full_labels(e,t){const s=this.context_location,n=[];if(t.every((e=>""===e)))return e;for(let o=0;o<e.length;o++){const r=e[o],i=t[o],l=(()=>{switch(s){case"above":return`${i}\n${r}`;case"below":return`${r}\n${i}`;case"left":return""==i?r:`${i} ${r}`;case"right":return""==i?r:`${r} ${i}`}})();n.push(l)}return n}_hide_repeating_labels(e){if(e.length<=1)return e;const t=[e[0]];let s=0;for(let n=1;n<e.length;n++)e[s]==e[n]?t.push(""):(t.push(e[n]),s=n);return t}}s.DatetimeTickFormatter=p,r=p,p.__name__="DatetimeTickFormatter",r.define((({Bool:e,Nullable:t,Or:s,Ref:n,Str:o,Arrayable:l})=>({microseconds:[o,"%fus"],milliseconds:[o,"%3Nms"],seconds:[o,"%Ss"],minsec:[o,":%M:%S"],minutes:[o,":%M"],hourmin:[o,"%H:%M"],hours:[o,"%Hh"],days:[o,"%m/%d"],months:[o,"%m/%Y"],years:[o,"%Y"],strip_leading_zeros:[s(e,l(i.ResolutionType)),!1],boundary_scaling:[e,!0],hide_repeats:[e,!1],context:[t(s(o,n(r))),null],context_which:[i.ContextWhich,"start"],context_location:[i.Location,"below"]})))},
function _(r,e,n,t,i){t(),n.datetime=h,n.sprintf=g,n.basic_formatter=T,n.get_formatter=b,n._get_column_value=M,n.get_value=$,n.replace_placeholders_html=function(r,e,t,i,u={}){const s=E(r,((r,s,a,l,o)=>{const c=$(r,s,e,t,u);if("safe"==a){const r=A.safe(c);return r instanceof I?r.html:(0,_.escape)(`${r}`)}{const r=(()=>{if(null==c)return n.MISSING;if((0,m.isNumber)(c)&&isNaN(c))return"NaN";return`${b(o,a,i)(c,a??"",u)}`})();return(0,_.escape)(r)}})),a=new DOMParser;return[...a.parseFromString(s,"text/html").body.childNodes]},n.replace_placeholders=function(r,e,t,i,u={},s){let a,l;(0,m.isString)(r)?(a=r,l=!1):(a=r.html,l=!0);if(a=E(a,((r,a,o,c,f)=>{const N=$(r,a,e,t,u);if("safe"==o)return l=!0,null==N?n.MISSING:(0,m.isNumber)(N)&&isNaN(N)?"NaN":`${N}`;{const r=(()=>{if(null==N)return n.MISSING;if((0,m.isNumber)(N)&&isNaN(N))return"NaN";return`${b(f,o,i)(N,o??"",u)}`})();return null!=s?s(r):r}})),l){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a},n.process_placeholders=E;const u=r(1),s=u.__importStar(r(260)),a=r(261),l=u.__importDefault(r(262)),o=r(20),c=r(9),f=r(31),m=r(8),N=r(43),_=r(41),p=r(12),{abs:S}=Math;n.DEFAULT_FORMATTERS={raw:(r,e,n)=>(0,N.to_string)(r),basic:(r,e,n)=>T(r,e,n),numeral:(r,e,n)=>s.format(r,e),datetime:(r,e,n)=>h(r,e),printf:(r,e,n)=>g(e,r)};class d{}function h(r,e){return(0,m.isNumber)(r)&&isFinite(r)?(0,l.default)(r,e):"NaN"}function g(r,...e){return(0,a.sprintf)(r,...e)}function T(r,e,n){if((0,m.isNumber)(r)){return g(Number.isInteger(r)?"%d":.1<S(r)&&S(r)<1e3?"%0.3f":"%0.3e",r)}return(0,m.isString)(r)?r:`${r}`}function b(r,e,t){if(null==e)return n.DEFAULT_FORMATTERS.basic;if(null!=t){const e=(0,c.dict)(t).get(r);if(null!=e){if((0,m.isString)(e)){if(e in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[e];throw new Error(`Unknown tooltip field formatter type '${e}'`)}return function(r,n,t){return e.format(r,n,t)}}}return n.DEFAULT_FORMATTERS.numeral}function M(r,e,n){const t=e.get_column(r);if(null==t)return null;if(null==n)return null;if((0,m.isNumber)(n))return t[n];const i=t[n.index];if((0,m.isTypedArray)(i)||(0,m.isArray)(i)){if((0,m.isArray)(i[0])){return i[n.j][n.i]}return(0,f.is_NDArray)(i)&&3==i.dimension?i.slice(n.flat_index*i.shape[2],(n.flat_index+1)*i.shape[2]):i[n.flat_index]}return i}function $(r,e,t,i,u){switch(r){case"$":return function(r,e){return r in e?e[r]:(o.logger.warn(`unknown special variable '$${r}'`),n.MISSING)}(e,u);case"@":return M(e,t,i);case"@$":return"name"==e&&(0,m.isString)(u.name)?M(u.name,t,i):null}}n.Skip=d,d.__name__="Skip",n.MISSING="???";class I{constructor(r){this.html=r}}I.__name__="HTML";const A={safe:(r,...e)=>((0,p.assert)(0==e.length),null==r?n.MISSING:(0,m.isNumber)(r)&&isNaN(r)?"NaN":new I(`${r}`))};const F=/(@\$|@|\$)((?:[\p{Letter}\p{Number}_]+)|(?:\{(?:[^{}]+)\}))(?:\{([^{}]+)\})?/gu;function E(r,e){let t=0;return r.replace(F,((r,i,u,s)=>{const a=u.replace(/^{/,"").replace(/}$/,"").trim(),l=`${i}${u}`;return e(i,a,s,t++,l)??n.MISSING}))}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,c="en-US",u=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){var r;return r=n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),u=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[c].currency.position?(h=o[c].currency.symbol,o[c].currency.spaceSeparated&&(h=" "+h+" ")):o[c].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[c].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[c].currency.symbol),i=i.join("")):i=i+d+o[c].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(u,f)+1,i.splice(r,0,o[c].currency.symbol+d),i=i.join("")):i=o[c].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<u||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[c].currency.symbol+d),i=i.join("")):i=o[c].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[c].currency.symbol),i=i.join("")):i=i+d+o[c].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");r=m(e,n,t),r.indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t),r}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==u)return u;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[c].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[c].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[c].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[c].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[c].ordinal&&(L+=o[c].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[c].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[c].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){c=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return c;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return c;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[c];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[c];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){u="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,c,u,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{u=a.cultureData(n)}catch(e){u=a.cultureData(a.culture())}return i=u.currency.symbol,l=u.abbreviations,t=u.delimiters.decimal,r="."===u.delimiters.thousands?"\\.":u.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(c=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(c):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(c)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(c)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,r??Math.round)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(t){return function(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}(function(n){if(i[n])return i[n];var t,r=n,s=[],a=0;for(;r;){if(null!==(t=e.text.exec(r)))s.push(t[0]);else if(null!==(t=e.modulo.exec(r)))s.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");s.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return i[n]=s}(t),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}var i=Object.create(null);void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(t,e,s,n,r){var c;n();const a=t(205),i=t(9),o=t(41);class u extends a.TickFormatter{constructor(t){super(t)}get names(){return(0,i.keys)(this.args)}get values(){return(0,i.values)(this.args)}_make_func(){const t=(0,o.use_strict)(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const s=this._make_func().bind({});return t.map(((t,e,n)=>`${s(t,e,n,...this.values)}`))}}s.CustomJSTickFormatter=u,c=u,u.__name__="CustomJSTickFormatter",c.define((({Unknown:t,Str:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))},
function _(e,t,n,r,o){var i;r();const s=e(205),a=e(209),c=e(224),l=e(192),{abs:u,log:x,round:_}=Math;class p extends s.TickFormatter{constructor(e){super(e)}initialize(){super.initialize(),this.basic_formatter=new a.BasicTickFormatter}format_graphics(e,t){if(0==e.length)return[];const n=this.ticker?.base??10,r=this._exponents(e,n);return null==r?this.basic_formatter.format_graphics(e,t):r.map((e=>{if(u(e)<this.min_exponent){const t=new l.TextBox({text:(0,a.unicode_replace)(`${n**e}`)}),r=new l.TextBox({text:""});return new l.BaseExpo(t,r)}{const t=new l.TextBox({text:(0,a.unicode_replace)(`${n}`)}),r=new l.TextBox({text:(0,a.unicode_replace)(`${e}`)});return new l.BaseExpo(t,r)}}))}_exponents(e,t){let n=null;const r=[];for(const o of e){const e=_(x(o)/x(t));if(n==e)return null;n=e,r.push(e)}return r}doFormat(e,t){if(0==e.length)return[];const n=this.ticker?.base??10,r=this._exponents(e,n);return null==r?this.basic_formatter.doFormat(e,t):r.map((e=>u(e)<this.min_exponent?(0,a.unicode_replace)(`${n**e}`):(0,a.unicode_replace)(`${n}^${e}`)))}}n.LogTickFormatter=p,i=p,p.__name__="LogTickFormatter",i.define((({Int:e,Ref:t,Nullable:n})=>({ticker:[n(t(c.LogTicker)),null],min_exponent:[e,0]})))},
function _(r,t,e,o,n){var i;o();const c=r(209),s=r(21),a=r(148);class l extends c.BasicTickFormatter{constructor(r){super(r)}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=a.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=a.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=l,i=l,l.__name__="MercatorTickFormatter",i.define((({Nullable:r})=>({dimension:[r(s.LatLon),null]})))},
function _(r,n,t,o,e){var a;o();const u=r(1).__importStar(r(260)),c=r(205),i=r(21);class s extends c.TickFormatter{constructor(r){super(r)}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,n){const{format:t,language:o,_rounding_fn:e}=this;return r.map((r=>u.format(r,t,o,e)))}}t.NumeralTickFormatter=s,a=s,s.__name__="NumeralTickFormatter",a.define((({Str:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[i.RoundingFunction,"round"]})))},
function _(t,r,n,o,a){var e;o();const i=t(205),s=t(259);class c extends i.TickFormatter{constructor(t){super(t)}doFormat(t,r){return t.map((t=>(0,s.sprintf)(this.format,t)))}}n.PrintfTickFormatter=c,e=c,c.__name__="PrintfTickFormatter",e.define((({Str:t})=>({format:[t,"%s"]})))},
function _(t,n,e,s,r){var o;s(),e._get_resolution=h,e._str_timedelta=d,e._days=f,e._hours=m,e._minutes=N,e._seconds=g,e._ms=p,e._us=O,e._ns=E;const i=t(21),l=t(12),u=t(259),c=t(8),_=t(205),a=t(220);function h(t,n){const e=1.1*t*1e3,s=1e3*n;return e<a.ONE_MICRO?"nanoseconds":e<a.ONE_MILLI?"microseconds":e<a.ONE_SECOND?"milliseconds":e<a.ONE_MINUTE?s>=a.ONE_MINUTE?"minsec":"seconds":e<a.ONE_HOUR?s>=a.ONE_HOUR?"hourmin":"minutes":e<a.ONE_DAY?"hours":"days"}function d(t,n){for(const[s,r]of Object.entries(e.formatting_map)){const e=new RegExp(`((^|[^%])(%%)*)${s}`);e.test(n)&&(n=n.replace(e,`$1${r(t)}`))}return n}function f(t,n){return b(M(t,a.ONE_DAY,n),n)}function m(t,n){return b(M(t,a.ONE_HOUR,n),n)}function N(t,n){return b(M(t,a.ONE_MINUTE,n),n)}function g(t,n){return b(M(t,a.ONE_SECOND,n),n)}function p(t,n){return b(M(t,a.ONE_MILLI,n),n)}function O(t,n){return b(M(t,a.ONE_MICRO,n),n)}function E(t,n){return b(M(t,a.ONE_NANO,n),n)}function b(t,n){return null!==n?(0,u.sprintf)(`%0${(""+(n-1)).length}d`,t):String(t)}function M(t,n,e){return null!==e?function(t,n,e){if(n<1){const s=Math.round(1e6*t),r=n*e*1e6,o=`${r}`.length,i=String(s);return parseFloat(i.substring(i.length-o))%r/(1e6*n)%e}const s=t%(n*e);return s/n}(t,n,e):function(t,n){return Math.floor(t/n)}(t,n)}e.resolution_order=["nanoseconds","microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days"],e.formatting_map={"%NS":t=>E(t,1e3),"%ns":t=>E(t,null),"%US":t=>O(t,1e3),"%us":t=>O(t,null),"%MS":t=>p(t,1e3),"%ms":t=>p(t,null),"%S":t=>g(t,60),"%s":t=>g(t,null),"%M":t=>N(t,60),"%m":t=>N(t,null),"%H":t=>m(t,24),"%h":t=>m(t,null),"%d":t=>f(t,null)};class S extends _.TickFormatter{constructor(t){super(t)}doFormat(t,n,e){if(0==t.length)return[];const s=Math.abs(t[t.length-1]-t[0])/1e3,r=s/(t.length-1),o=(0,c.is_undefined)(e)?h(r,s):e;let i=[];for(const n of t){const t=this._compute_label(n,o);i.push(t)}if(this.hide_repeats&&(i=this._hide_repeating_labels(i)),null==this.context)return i;const l=this._compute_context_labels(t,o);return this._build_full_labels(i,l)}_compute_label(t,n){const e=d(t,this[n]),{strip_leading_zeros:s}=this;if((0,c.isBoolean)(s)&&s||(0,c.isArray)(s)&&s.includes(n)){const t=e.replace(/^0+/g,"");return t==e||Number.isInteger(Number(t[0]))?t:`0${t}`}return e}_compute_context_labels(t,n){const{context:e}=this;(0,l.assert)(null!=e);const s=[];if((0,c.isString)(e))for(const n of t)s.push(d(n,e));else s.push(...e.doFormat(t,{loc:0},n));const r=this.context_which,o=s.length;for(let t=0;t<s.length;t++)("start"==r&&0!=t||"end"==r&&t!=o-1||"center"==r&&t!=Math.floor(o/2))&&(s[t]="");return s}_build_full_labels(t,n){const e=this.context_location,s=[];if(n.every((t=>""===t)))return t;for(let r=0;r<t.length;r++){const o=t[r],i=n[r],l=(()=>{switch(e){case"above":return`${i}\n${o}`;case"below":return`${o}\n${i}`;case"left":return""==i?o:`${i} ${o}`;case"right":return""==i?o:`${o} ${i}`}})();s.push(l)}return s}_hide_repeating_labels(t){if(t.length<=1)return t;const n=[t[0]];let e=0;for(let s=1;s<t.length;s++)t[e]==t[s]?n.push(""):(n.push(t[s]),e=s);return n}}e.TimedeltaTickFormatter=S,o=S,S.__name__="TimedeltaTickFormatter",o.define((({Bool:t,Nullable:n,Or:e,Ref:s,Str:r,Arrayable:l})=>({nanoseconds:[r,"%NSns"],microseconds:[r,"%USus"],milliseconds:[r,"%MSms"],seconds:[r,"%H:%M:%S"],minsec:[r,"%H:%M:%S"],minutes:[r,"%H:%M"],hourmin:[r,"%H:%M"],hours:[r,"%H:%M"],days:[r,"%d days"],strip_leading_zeros:[e(t,l(i.TimedeltaResolutionType)),!1],hide_repeats:[t,!1],context:[n(e(r,s(o))),null],context_which:[i.ContextWhich,"start"],context_location:[i.Location,"below"]})))},
function _(a,e,l,c,o){c(),o("CategoricalScale",a(116).CategoricalScale),o("CompositeScale",a(117).CompositeScale),o("ContinuousScale",a(114).ContinuousScale),o("LinearInterpolationScale",a(270).LinearInterpolationScale),o("LinearScale",a(113).LinearScale),o("LogScale",a(115).LogScale),o("Scale",a(108).Scale)},
function _(e,n,r,t,a){var i;t();const s=e(108),o=e(113),c=e(13);class _ extends s.Scale{constructor(e){super(e)}initialize(){super.initialize();const{source_range:e,target_range:n}=this.properties;e.is_unset||n.is_unset||(this.linear_scale=new o.LinearScale({source_range:e.get_value(),target_range:n.get_value()}))}connect_signals(){super.connect_signals();const{source_range:e,target_range:n}=this.properties;this.on_change([e,n],(()=>{this.linear_scale=new o.LinearScale({source_range:this.source_range,target_range:this.target_range})}))}get s_compute(){throw new Error("not implemented")}get s_invert(){throw new Error("not implemented")}compute(e){return e}v_compute(e){const{binning:n}=this,{start:r,end:t}=this.source_range,a=r,i=t,s=n.length,o=(t-r)/(s-1),_=new Float64Array(s);for(let e=0;e<s;e++)_[e]=r+e*o;const l=(0,c.map)(e,(e=>{if(e<a)return a;if(e>i)return i;const r=(0,c.left_edge_index)(e,n);if(-1==r)return a;if(r>=s-1)return i;const t=n[r],o=(e-t)/(n[r+1]-t),l=_[r];return l+o*(_[r+1]-l)}));return this.linear_scale.v_compute(l)}invert(e){return e}v_invert(e){return new Float64Array(e)}}r.LinearInterpolationScale=_,i=_,_.__name__="LinearInterpolationScale",i.internal((({Float:e,Arrayable:n,Ref:r})=>({binning:[n(e)],linear_scale:[r(o.LinearScale)]})))},
function _(a,n,e,g,R){g(),R("DataRange",a(119).DataRange),R("DataRange1d",a(118).DataRange1d),R("FactorRange",a(121).FactorRange),R("Range",a(110).Range),R("Range1d",a(111).Range1d)},
function _(t,e,i,h,o){h();const n=t(136),s=t(137),r=t(62);class _ extends s.Layoutable{constructor(){super(...arguments),this.aligns={left:!0,right:!0,top:!0,bottom:!0},this.min_border={left:0,top:0,right:0,bottom:0},this.padding={left:0,top:0,right:0,bottom:0},this.center_border_width=0}*[Symbol.iterator](){yield this.top_panel,yield this.bottom_panel,yield this.left_panel,yield this.right_panel,yield this.center_panel}_measure(t){t=new n.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left)+this.padding.left,h=this.right_panel.measure({width:0,height:t.height}),o=Math.max(h.width,this.min_border.right)+this.padding.right,s=this.top_panel.measure({width:t.width,height:0}),r=Math.max(s.height,this.min_border.top)+this.padding.top,_=this.bottom_panel.measure({width:t.width,height:0}),g=Math.max(_.height,this.min_border.bottom)+this.padding.bottom,l=new n.Sizeable(t).shrink_by({left:i,right:o,top:r,bottom:g}),a=this.center_panel.measure(l);return{width:i+a.width+o,height:r+a.height+g,inner:{left:i,right:o,top:r,bottom:g},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return{...this.aligns,fixed_width:"fixed"==t,fixed_height:"fixed"==e}})()}}_set_geometry(t,e){if(super._set_geometry(t,e),this.sizing.visible){this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),h=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),n=this.bottom_panel.measure({width:t.width,height:0}),{left:s,top:_,right:g,bottom:l}=e;this.top_panel.set_geometry(new r.BBox({left:s,right:g,bottom:_,height:o.height})),this.bottom_panel.set_geometry(new r.BBox({left:s,right:g,top:l,height:n.height})),this.left_panel.set_geometry(new r.BBox({top:_,bottom:l,right:s,width:i.width})),this.right_panel.set_geometry(new r.BBox({top:_,bottom:l,left:g,width:h.width}));const a=e.shrink_by(this.center_border_width);if(null!=this.inner_top_panel){const{left:t,right:e,top:i,width:h}=a,o=this.inner_top_panel.measure({width:h,height:0});this.inner_top_panel.set_geometry(new r.BBox({left:t,right:e,top:i,height:o.height}))}if(null!=this.inner_bottom_panel){const{left:t,right:e,bottom:i,width:h}=a,o=this.inner_bottom_panel.measure({width:h,height:0});this.inner_bottom_panel.set_geometry(new r.BBox({left:t,right:e,bottom:i,height:o.height}))}if(null!=this.inner_left_panel){const{top:t,bottom:e,left:i,height:h}=a,o=this.inner_left_panel.measure({width:0,height:h});this.inner_left_panel.set_geometry(new r.BBox({top:t,bottom:e,left:i,width:o.width}))}if(null!=this.inner_right_panel){const{top:t,bottom:e,right:i,height:h}=a,o=this.inner_right_panel.measure({width:0,height:h});this.inner_right_panel.set_geometry(new r.BBox({top:t,bottom:e,right:i,width:o.width}))}}else this.center_panel.set_geometry(new r.BBox),this.top_panel.set_geometry(new r.BBox),this.bottom_panel.set_geometry(new r.BBox),this.left_panel.set_geometry(new r.BBox),this.right_panel.set_geometry(new r.BBox),this.inner_top_panel?.set_geometry(new r.BBox),this.inner_bottom_panel?.set_geometry(new r.BBox),this.inner_left_panel?.set_geometry(new r.BBox),this.inner_right_panel?.set_geometry(new r.BBox)}}i.BorderLayout=_,_.__name__="BorderLayout"},
function _(e,s,_,i,l){var t;i();const o=e(1),r=e(274),h=o.__importStar(e(95));class p extends r.UpperLowerView{_paint_data(e){e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.apply(e),this.visuals.hatch.apply(e),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.apply(e),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,_=this._upper_sx.length;s<_;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.apply(e)}}_.BandView=p,p.__name__="BandView";class a extends r.UpperLower{constructor(e){super(e)}}_.Band=a,t=a,a.__name__="Band",t.prototype.default_view=p,t.mixins([h.Line,h.Fill,h.Hatch]),t.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,s,r,i){var n;r();const a=e(1),o=e(141),_=e(25),c=e(21),p=a.__importStar(e(19));class h extends o.DataAnnotationView{map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=this.coordinates.x_scale,r=this.coordinates.y_scale,i="height"==t?r:s,n="height"==t?s:r,a="height"==t?e.bbox.yview:e.bbox.xview,o="height"==t?e.bbox.xview:e.bbox.yview,c=(()=>{switch(this.model.properties.lower.units){case"canvas":return new _.ScreenArray(this._lower);case"screen":return a.v_compute(this._lower);case"data":return i.v_compute(this._lower)}})(),p=(()=>{switch(this.model.properties.upper.units){case"canvas":return new _.ScreenArray(this._upper);case"screen":return a.v_compute(this._upper);case"data":return i.v_compute(this._upper)}})(),h=(()=>{switch(this.model.properties.base.units){case"canvas":return new _.ScreenArray(this._base);case"screen":return o.v_compute(this._base);case"data":return n.v_compute(this._base)}})(),[u,d]="height"==t?[1,0]:[0,1],w=[c,h],l=[p,h];this._lower_sx=w[u],this._lower_sy=w[d],this._upper_sx=l[u],this._upper_sy=l[d]}}s.UpperLowerView=h,h.__name__="UpperLowerView";class u extends p.CoordinateSpec{constructor(){super(...arguments),this._value=p.unset}get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){return this._value===p.unset?"data":this._value.units??"data"}}s.XOrYCoordinateSpec=u,u.__name__="XOrYCoordinateSpec";class d extends o.DataAnnotation{constructor(e){super(e)}}s.UpperLower=d,n=d,d.__name__="UpperLower",n.define((()=>({dimension:[c.Dimension,"height"],lower:[u,{field:"lower"}],upper:[u,{field:"upper"}],base:[u,{field:"base"}]})))},
function _(t,e,o,i,r){var s,n,l;i();const a=t(1),h=t(96),_=t(52),u=t(94),c=t(118),m=a.__importStar(t(95)),b=t(21),d=t(10),p=t(62),f=t(16),g=t(8),v=t(11),w=t(12),x=t(9),y=t(124),N=a.__importStar(t(276)),B=t(197),z=a.__importStar(t(127)),A=t(57),C=t(58),V=t(121),F=t(22),E=(0,F.Or)(F.Float,V.FactorLike,(0,F.Ref)(C.Coordinate));o.EDGE_TOLERANCE=2.5;const{abs:L}=Math;class R extends _.Model{constructor(t){super(t)}}o.BoxInteractionHandles=R,s=R,R.__name__="BoxInteractionHandles",s.define((({Ref:t,Nullable:e})=>({all:[t(u.AreaVisuals)],move:[e(t(u.AreaVisuals)),null],resize:[e(t(u.AreaVisuals)),null],sides:[e(t(u.AreaVisuals)),null],corners:[e(t(u.AreaVisuals)),null],left:[e(t(u.AreaVisuals)),null],right:[e(t(u.AreaVisuals)),null],top:[e(t(u.AreaVisuals)),null],bottom:[e(t(u.AreaVisuals)),null],top_left:[e(t(u.AreaVisuals)),null],top_right:[e(t(u.AreaVisuals)),null],bottom_left:[e(t(u.AreaVisuals)),null],bottom_right:[e(t(u.AreaVisuals)),null]})));const H=()=>new R({all:new u.AreaVisuals({fill_color:"white",fill_alpha:1,line_color:"black",line_alpha:1,hover_fill_color:"lightgray",hover_fill_alpha:1})});class M extends h.AnnotationView{constructor(){super(...arguments),this._bbox=new p.BBox,this._handles_views={},this[n]=!0,this._pan_state=null,this._pinch_state=null,this._is_hovered=!1}get bbox(){return this._bbox}initialize(){super.initialize(),this._update_handles()}_update_handles(){const{editable:t,use_handles:e,handles:o}=this.model;if(t&&e){const{movable:i,resizable:r}=this,s={visible:!0,resizable:"none",left_units:"canvas",right_units:"canvas",top_units:"canvas",bottom_units:"canvas",level:this.model.level,is_handle:!0};function n(t){return{...m.attrs_of(t,"",m.Line,!0),...m.attrs_of(t,"",m.Fill,!0),...m.attrs_of(t,"",m.Hatch,!0),...m.attrs_of(t,"hover_",m.Line,!0),...m.attrs_of(t,"hover_",m.Fill,!0),...m.attrs_of(t,"hover_",m.Hatch,!0)}}const l=o,a={area:n(l.move??l.all),left:n(l.left??l.sides??l.resize??l.all),right:n(l.right??l.sides??l.resize??l.all),top:n(l.top??l.sides??l.resize??l.all),bottom:n(l.bottom??l.sides??l.resize??l.all),top_left:n(l.top_left??l.corners??l.resize??l.all),top_right:n(l.top_right??l.corners??l.resize??l.all),bottom_left:n(l.bottom_left??l.corners??l.resize??l.all),bottom_right:n(l.bottom_right??l.corners??l.resize??l.all)},{tl_cursor:h,tr_cursor:_,bl_cursor:u,br_cursor:c,ew_cursor:b,ns_cursor:d}=this.model;this._handles={area:i?new S({...s,...a.area,in_cursor:"move",movable:this.model.movable}):null,left:r.left?new S({...s,...a.left,in_cursor:b}):null,right:r.right?new S({...s,...a.right,in_cursor:b}):null,top:r.top?new S({...s,...a.top,in_cursor:d}):null,bottom:r.bottom?new S({...s,...a.bottom,in_cursor:d}):null,top_left:r.top_left?new S({...s,...a.top_left,in_cursor:h}):null,top_right:r.top_right?new S({...s,...a.top_right,in_cursor:_}):null,bottom_left:r.bottom_left?new S({...s,...a.bottom_left,in_cursor:u}):null,bottom_right:r.bottom_right?new S({...s,...a.bottom_right,in_cursor:c}):null}}else this._handles={area:null,left:null,right:null,top:null,bottom:null,top_left:null,top_right:null,bottom_left:null,bottom_right:null}}get computed_renderers(){return[...super.computed_renderers,...(0,x.values)(this._handles).filter((t=>null!=t))]}connect_signals(){super.connect_signals();const{editable:t,use_handles:e,handles:o,resizable:i,movable:r}=this.model.properties;this.on_change([t,e,o,i,r],(async()=>{this._update_handles(),await this._update_renderers()})),this.connect(this.model.change,(()=>this.request_paint()))}async _build_renderers(){const t=await super._build_renderers(),e=t=>null!=t?this._renderer_views.get(t):void 0;return this._handles_views={area:e(this._handles.area),left:e(this._handles.left),right:e(this._handles.right),top:e(this._handles.top),bottom:e(this._handles.bottom),top_left:e(this._handles.top_left),top_right:e(this._handles.top_right),bottom_left:e(this._handles.bottom_left),bottom_right:e(this._handles.bottom_right)},t}_synthetic_lrtb(){const{left:t,left_units:e,right:o,right_units:i,top:r,top_units:s,bottom:n,bottom_units:l}=this.model,{x_source:a,y_source:h}=this.coordinates,_=a instanceof V.FactorRange,u=h instanceof V.FactorRange;return{left:(()=>{if("data"==e&&!(t instanceof C.Coordinate)){if(_)return a.synthetic(t);if((0,g.isNumber)(t))return t}return NaN})(),right:(()=>{if("data"==i&&!(o instanceof C.Coordinate)){if(_)return a.synthetic(o);if((0,g.isNumber)(o))return o}return NaN})(),top:(()=>{if("data"==s&&!(r instanceof C.Coordinate)){if(u)return h.synthetic(r);if((0,g.isNumber)(r))return r}return NaN})(),bottom:(()=>{if("data"==l&&!(n instanceof C.Coordinate)){if(u)return h.synthetic(n);if((0,g.isNumber)(n))return n}return NaN})()}}bounds(){const{left:t,right:e,top:o,bottom:i}=this._synthetic_lrtb(),r=isFinite(t),s=isFinite(e),n=isFinite(o),l=isFinite(i),[a,h]=r&&s?t<=e?[t,e]:[e,t]:r?[t,t]:s?[e,e]:[NaN,NaN],[_,u]=n&&l?o<=i?[o,i]:[i,o]:n?[o,o]:l?[i,i]:[NaN,NaN];return{x0:a,x1:h,y0:_,y1:u}}log_bounds(){return(0,p.empty)()}get mappers(){function t(t,e,o,i){switch(t){case"canvas":return i;case"screen":return o;case"data":return e}}const e=this.model,{x_scale:o,y_scale:i}=this.coordinates,{x_view:r,y_view:s}=this.plot_view.frame.bbox,{x_screen:n,y_screen:l}=this.plot_view.canvas.bbox;return{left:t(e.left_units,o,r,n),right:t(e.right_units,o,r,n),top:t(e.top_units,i,s,l),bottom:t(e.bottom_units,i,s,l)}}get border_radius(){return z.border_radius(this.model.border_radius)}compute_geometry(){super.compute_geometry();const t=(()=>{const t=(t,e,o)=>e instanceof C.Coordinate?this.resolve_as_scalar(e,t):o.compute(e),{left:e,right:o,top:i,bottom:r}=this.model,{mappers:s}=this;return p.BBox.from_lrtb({left:t("x",e,s.left),right:t("x",o,s.right),top:t("y",i,s.top),bottom:t("y",r,s.bottom)})})();this._bbox=t;const e=10,o=10;function i(t,e){const{left:o,right:i,top:r,bottom:s}=e;t?.setv({left:o,right:i,top:r,bottom:s},{silent:!0})}i(this._handles.area,new p.BBox({...t.center,width:e,height:o,origin:"center"})),i(this._handles.left,new p.BBox({...t.center_left,width:e,height:o,origin:"center"})),i(this._handles.right,new p.BBox({...t.center_right,width:e,height:o,origin:"center"})),i(this._handles.top,new p.BBox({...t.top_center,width:e,height:o,origin:"center"})),i(this._handles.bottom,new p.BBox({...t.bottom_center,width:e,height:o,origin:"center"})),i(this._handles.top_left,new p.BBox({...t.top_left,width:e,height:o,origin:"center"})),i(this._handles.top_right,new p.BBox({...t.top_right,width:e,height:o,origin:"center"})),i(this._handles.bottom_left,new p.BBox({...t.bottom_left,width:e,height:o,origin:"center"})),i(this._handles.bottom_right,new p.BBox({...t.bottom_right,width:e,height:o,origin:"center"}))}_paint(t){if(!this.bbox.is_valid)return;const{_is_hovered:e,visuals:o}=this,i=e&&o.hover_fill.doit?o.hover_fill:o.fill,r=e&&o.hover_hatch.doit?o.hover_hatch:o.hatch,s=e&&o.hover_line.doit?o.hover_line:o.line;if(t.save(),this.model.inverted){t.beginPath();const e=this.layout??this.plot_view.frame,{x:o,y:n,width:l,height:a}=e.bbox;t.rect(o,n,l,a),(0,B.round_rect)(t,this.bbox,this.border_radius),i.apply(t,"evenodd"),r.apply(t,"evenodd"),t.beginPath(),(0,B.round_rect)(t,this.bbox,this.border_radius),s.apply(t)}else t.beginPath(),(0,B.round_rect)(t,this.bbox,this.border_radius),i.apply(t),r.apply(t),s.apply(t);t.restore()}interactive_bbox(){const t=this.model.line_width+o.EDGE_TOLERANCE;return this.bbox.grow_by(t)}interactive_hit(t,e){if(!this.model.visible)return!1;return this.interactive_bbox().contains(t,e)}_hit_test(t,e){const{left:i,right:r,bottom:s,top:n}=this.bbox,l=Math.max(o.EDGE_TOLERANCE,this.model.line_width/2),a=L(i-t),h=L(r-t),_=L(n-e),u=L(s-e),c={left:a<l&&a<h,right:h<l&&h<a,top:_<l&&_<u,bottom:u<l&&u<_},m=this._hittable(),b=(o,i)=>{if(!m[o])return!1;const r=this._handles_views[o];return null!=r?r.bbox.contains(t,e):i};return b("top_left",c.top&&c.left)?"top_left":b("top_right",c.top&&c.right)?"top_right":b("bottom_left",c.bottom&&c.left)?"bottom_left":b("bottom_right",c.bottom&&c.right)?"bottom_right":b("left",c.left)?"left":b("right",c.right)?"right":b("top",c.top)?"top":b("bottom",c.bottom)?"bottom":b("area",this.bbox.contains(t,e))?"area":null}get resizable(){const{resizable:t}=this.model,e="left"==t||"x"==t||"all"==t,o="right"==t||"x"==t||"all"==t,i="top"==t||"y"==t||"all"==t,r="bottom"==t||"y"==t||"all"==t;return{left:e,right:o,top:i,bottom:r,top_left:i&&e,top_right:i&&o,bottom_left:r&&e,bottom_right:r&&o}}get movable(){const t="none"!=this.model.movable;return(this.model.is_handle||this.model.editable)&&t}_hittable(){const{left:t,right:e,top:o,bottom:i}=this.resizable;return{top_left:o&&t,top_right:o&&e,bottom_left:i&&t,bottom_right:i&&e,left:t,right:e,top:o,bottom:i,area:this.movable}}_can_hit(t){const{left:e,right:o,top:i,bottom:r}=this.resizable;switch(t){case"top_left":return i&&e;case"top_right":return i&&o;case"bottom_left":return r&&e;case"bottom_right":return r&&o;case"left":return e;case"right":return o;case"top":return i;case"bottom":return r;case"area":return this.movable}}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:o}=t,i=this._hit_test(e,o);if(null!=i&&this._can_hit(i))return this._pan_state={bbox:this.bbox.clone(),target:i},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,w.assert)(null!=this._pan_state);const{mappers:e}=this,o=(t,e,o)=>e instanceof C.Coordinate?this.resolve_as_scalar(e,t):null==e?NaN:o.compute(e),i=p.BBox.from_lrtb({left:o("x",this.model.left_limit,e.left),right:o("x",this.model.right_limit,e.right),top:o("y",this.model.top_limit,e.top),bottom:o("y",this.model.bottom_limit,e.bottom)}),[r,s,n,l]=(()=>{const{dx:e,dy:o}=t,{target:i}=this._pan_state,{symmetric:r}=this.model,[s,n]=r?[-e,-o]:[0,0];switch(i){case"top_left":return[e,s,o,n];case"top_right":return[s,e,o,n];case"bottom_left":return[e,s,n,o];case"bottom_right":return[s,e,n,o];case"left":return[e,s,0,0];case"right":return[s,e,0,0];case"top":return[0,0,o,n];case"bottom":return[0,0,n,o];case"area":switch(this.model.movable){case"both":return[e,e,o,o];case"x":return[e,e,0,0];case"y":return[0,0,o,o];case"none":return[0,0,0,0]}}})(),a=(()=>{const t=(t,e)=>(0,d.min)([t,e]),e=t=>t<0?-1:t>0?1:0,{bbox:o}=this._pan_state;let{left:a,right:h,left_sign:_,right_sign:u}=(()=>{const t=o.left+r,i=o.right+s,n=e(r),l=e(s);return t<=i?{left:t,right:i,left_sign:n,right_sign:l}:{left:i,right:t,left_sign:l,right_sign:n}})(),{top:c,bottom:m,top_sign:b,bottom_sign:f}=(()=>{const t=o.top+n,i=o.bottom+l,r=e(n),s=e(l);return t<=i?{top:t,bottom:i,top_sign:r,bottom_sign:s}:{top:i,bottom:t,top_sign:s,bottom_sign:r}})();const g=a-i.left,v=i.right-h,w=t(g<0?g:NaN,v<0?v:NaN);isFinite(w)&&w<0&&(a+=-_*-w,h+=-u*-w);const x=c-i.top,y=i.bottom-m,N=t(x<0?x:NaN,y<0?y:NaN);return isFinite(N)&&N<0&&(c+=-b*-N,m+=-f*-N),p.BBox.from_lrtb({left:a,right:h,top:c,bottom:m})})(),{min_width:h,min_height:_,max_width:u,max_height:c}=this.model,{left:m,right:b,top:f,bottom:g}=this.model,x={left:e.left.invert(a.left),right:e.right.invert(a.right),top:e.top.invert(a.top),bottom:e.bottom.invert(a.bottom)};if(0<h||u<1/0)if(0!=r&&0==s){const t=x.right-u,e=x.right-h;x.left=(0,v.clamp)(x.left,t,e)}else if(0==r&&0!=s){const t=x.left+h,e=x.left+u;x.right=(0,v.clamp)(x.right,t,e)}if(0<_||c<1/0)if(0!=n&&0==l){const t=x.bottom+c,e=x.bottom+_;x.top=(0,v.clamp)(x.top,t,e)}else if(0==n&&0!=l){const t=x.top-_,e=x.top-c;x.bottom=(0,v.clamp)(x.bottom,t,e)}const y={left:m instanceof C.Coordinate?m:x.left,right:b instanceof C.Coordinate?b:x.right,top:f instanceof C.Coordinate?f:x.top,bottom:g instanceof C.Coordinate?g:x.bottom};this.model.update(y),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}on_pinch_start(t){if(this.model.visible&&this.model.editable&&"none"!=this.model.resizable){const{sx:e,sy:o}=t;if(this.bbox.contains(e,o))return this._pinch_state={bbox:this.bbox.clone()},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pinch(t){(0,w.assert)(null!=this._pinch_state);const e=(()=>{const{scale:e}=t,{bbox:o}=this._pinch_state,{left:i,top:r,right:s,bottom:n,width:l,height:a}=o,h=l*(e-1),_=a*(e-1),{resizable:u}=this,c=u.left?-h/2:0,m=u.right?h/2:0,b=u.top?-_/2:0,d=u.bottom?_/2:0;return p.BBox.from_lrtb({left:i+c,right:s+m,top:r+b,bottom:n+d})})(),o=(()=>{const{left:t,right:o,top:i,bottom:r}=this.model,{mappers:s}=this;return{left:t instanceof C.Coordinate?t:s.left.invert(e.left),right:o instanceof C.Coordinate?o:s.right.invert(e.right),top:i instanceof C.Coordinate?i:s.top.invert(e.top),bottom:r instanceof C.Coordinate?r:s.bottom.invert(e.bottom)}})();this.model.update(o),this.model.pan.emit(["pan",t.modifiers])}on_pinch_end(t){this._pinch_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t,hover_fill:e,hover_hatch:o}=this.visuals;return t.doit||e.doit||o.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const o=this._pan_state?.target??this._hit_test(t,e);if(null==o||!this._can_hit(o))return null;const{tl_cursor:i,tr_cursor:r,bl_cursor:s,br_cursor:n,ew_cursor:l,ns_cursor:a,in_cursor:h}=this.model;switch(o){case"top_left":return null==this._handles.top_left?i:this._handles.top_left.tl_cursor;case"top_right":return null==this._handles.top_right?r:this._handles.top_right.tr_cursor;case"bottom_left":return null==this._handles.bottom_left?s:this._handles.bottom_left.bl_cursor;case"bottom_right":return null==this._handles.bottom_right?n:this._handles.bottom_right.br_cursor;case"left":return null==this._handles.left?l:this._handles.left.ew_cursor;case"right":return null==this._handles.right?l:this._handles.right.ew_cursor;case"top":return null==this._handles.top?a:this._handles.top.ns_cursor;case"bottom":return null==this._handles.bottom?a:this._handles.bottom.ns_cursor;case"area":return this.movable?null==this._handles.area?null!=this._pan_state&&"grab"===h?"grabbing":h:this._handles.area.in_cursor:null}}}o.BoxAnnotationView=M,n=c.auto_ranged,M.__name__="BoxAnnotationView";class S extends h.Annotation{constructor(t){super(t),this.pan=new f.Signal(this,"pan"),this.nodes=(()=>{const t=new Map,e=e=>{let o=t.get(e);return void 0===o&&t.set(e,o=new A.Node({target:this,symbol:e})),o};return{get left(){return e("left")},get right(){return e("right")},get top(){return e("top")},get bottom(){return e("bottom")},get top_left(){return e("top_left")},get top_center(){return e("top_center")},get top_right(){return e("top_right")},get center_left(){return e("center_left")},get center(){return e("center")},get center_right(){return e("center_right")},get bottom_left(){return e("bottom_left")},get bottom_center(){return e("bottom_center")},get bottom_right(){return e("bottom_right")},get width(){return e("width")},get height(){return e("height")}}})()}clone(t){return super.clone(t)}update({left:t,right:e,top:o,bottom:i}){this.setv({left:t,right:e,top:o,bottom:i,visible:!0})}clear(){this.visible=!1}}o.BoxAnnotation=S,l=S,S.__name__="BoxAnnotation",l.prototype.default_view=M,l.mixins([m.Line,m.Fill,m.Hatch,["hover_",m.Line],["hover_",m.Fill],["hover_",m.Hatch]]),l.define((({Bool:t,Float:e,Ref:o,NonNegative:i,Positive:r})=>({top:[E,()=>new A.Node({target:"frame",symbol:"top"})],bottom:[E,()=>new A.Node({target:"frame",symbol:"bottom"})],left:[E,()=>new A.Node({target:"frame",symbol:"left"})],right:[E,()=>new A.Node({target:"frame",symbol:"right"})],top_units:[b.CoordinateUnits,"data"],bottom_units:[b.CoordinateUnits,"data"],left_units:[b.CoordinateUnits,"data"],right_units:[b.CoordinateUnits,"data"],top_limit:[N.Limit,null],bottom_limit:[N.Limit,null],left_limit:[N.Limit,null],right_limit:[N.Limit,null],min_width:[i(e),0],min_height:[i(e),0],max_width:[r(e),1/0],max_height:[r(e),1/0],border_radius:[y.BorderRadius,0],editable:[t,!1],resizable:[N.Resizable,"all"],movable:[N.Movable,"both"],symmetric:[t,!1],use_handles:[t,!1],handles:[o(R),H],inverted:[t,!1]}))),l.internal((({Str:t,Bool:e})=>({tl_cursor:[t,"nwse-resize"],tr_cursor:[t,"nesw-resize"],bl_cursor:[t,"nesw-resize"],br_cursor:[t,"nwse-resize"],ew_cursor:[t,"ew-resize"],ns_cursor:[t,"ns-resize"],in_cursor:[t,"grab"],is_handle:[e,!1]}))),l.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3,hover_fill_color:null,hover_fill_alpha:.4,hover_line_color:null,hover_line_alpha:.3})},
function _(t,o,e,n,l){n();const r=t(22),m=t(57);e.Corner=(0,r.Enum)("top_left","top_right","bottom_left","bottom_right"),e.Edge=(0,r.Enum)("left","right","top","bottom"),e.HitTarget=(0,r.Enum)(...e.Corner,...e.Edge,"area"),e.Resizable=(0,r.Enum)("none","left","right","top","bottom","x","y","all"),e.Movable=(0,r.Enum)("none","x","y","both"),e.Limit=(0,r.Nullable)((0,r.Or)(r.Float,(0,r.Ref)(m.Node)))},
function _(e,i,n,t,a){var o;t();const l=e(184),r=e(278),s=e(256),_=e(230),c=e(284),h=e(271),p=e(269),g=e(213),m=e(10),d=e(12);class u extends l.BaseColorBarView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.color_mapper.change,(async()=>{this._title_view.remove(),this._axis_view.remove(),this.initialize(),await this.lazy_initialize(),this.plot_view.invalidate_layout()})),this.connect(this.model.color_mapper.metrics_change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_low.change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_high.change,(()=>this._metrics_changed()))}get color_mapper(){let e=this.model.color_mapper;return e instanceof c.WeightedStackColorMapper&&(e=e.alpha_mapper),e}update_layout(){super.update_layout(),this._set_canvas_image()}_create_axis(){const{color_mapper:e}=this;return e instanceof c.CategoricalColorMapper?new r.CategoricalAxis:e instanceof c.LogColorMapper?new r.LogAxis:new r.LinearAxis}_create_formatter(){const{color_mapper:e}=this;return this._ticker instanceof g.LogTicker?new s.LogTickFormatter:e instanceof c.CategoricalColorMapper?new s.CategoricalTickFormatter:new s.BasicTickFormatter}_create_major_range(){const{color_mapper:e}=this;if(e instanceof c.CategoricalColorMapper)return new h.FactorRange({factors:e.factors});if(e instanceof c.ContinuousColorMapper){const{min:i,max:n}=this._continuous_metrics(e);return new h.Range1d({start:i,end:n})}(0,d.unreachable)()}_create_major_scale(){const{color_mapper:e}=this;return e instanceof c.LinearColorMapper?new p.LinearScale:e instanceof c.LogColorMapper?new p.LogScale:e instanceof c.ScanningColorMapper?new p.LinearInterpolationScale({binning:this._scanning_binning(e)}):e instanceof c.CategoricalColorMapper?new p.CategoricalScale:void(0,d.unreachable)()}_create_ticker(){const{color_mapper:e}=this;return e instanceof c.LogColorMapper?new g.LogTicker:e instanceof c.ScanningColorMapper?new g.BinnedTicker({mapper:e}):e instanceof c.CategoricalColorMapper?new g.CategoricalTicker:new g.BasicTicker}_continuous_metrics(e){const{display_low:i,display_high:n}=this.model;let{min:t,max:a}=e.metrics;if(null!=n&&null!=i&&n<i)return this._index_low=0,this._index_high=-1,{min:NaN,max:NaN};if(this._index_high=null,null!=n){const i=e.palette.length,t=e.value_to_index(n,i);t<i-1&&(this._index_high=t,a=e.index_to_value(t+1))}if(this._index_low=null,null!=i){const n=e.value_to_index(i,e.palette.length);n>0&&(this._index_low=n,t=e.index_to_value(n))}return{min:t,max:a}}_get_major_size_factor(){return this.color_mapper.palette.length}_metrics_changed(){const e=this._major_range,i=this._major_scale,{color_mapper:n}=this;if(n instanceof c.ScanningColorMapper&&i instanceof p.LinearInterpolationScale){const e=this._scanning_binning(n);i.binning=e;const t="vertical"==this.orientation,a=t?this._frame_view.y_scale:this._frame_view.x_scale;if(a instanceof p.LinearInterpolationScale){a.binning=e;const i=t?this._frame_view.y_range:this._frame_view.x_range;i instanceof h.Range1d&&(i.start=e[0],i.end=e[e.length-1])}}else if(n instanceof c.ContinuousColorMapper&&e instanceof h.Range1d){const{min:i,max:t}=this._continuous_metrics(n);e.setv({start:i,end:t})}this._set_canvas_image(),this.plot_view.request_layout()}_paint_colors(e,i){const{x:n,y:t,width:a,height:o}=i;e.save(),e.globalAlpha=this.model.scale_alpha,null!=this._image&&(e.imageSmoothingEnabled=!1,e.drawImage(this._image,n,t,a,o)),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(e),e.strokeRect(n,t,a,o)),e.restore()}_scanning_binning(e){let{binning:i,force_low_cutoff:n}=e.metrics;const{display_high:t}=this.model;let{display_low:a}=this.model;if(n&&(null==a||e.metrics.min>a)&&(a=e.metrics.min),null!=t&&null!=a&&t<a)return this._index_low=0,this._index_high=-1,[NaN];if(this._index_high=null,null!=t){const n=e.value_to_index(t,i.length);n<i.length-1&&(this._index_high=n)}if(this._index_low=null,null!=a){const n=e.value_to_index(a,i.length);n>0&&(this._index_low=n)}if(null!=this._index_low||null!=this._index_high){const e=null!=this._index_low?this._index_low:0,n=(null!=this._index_high?this._index_high+1:i.length-1)-e+1;if(n>0){const t=new Array(n);for(let a=0;a<n;a++)t[a]=i[a+e];i=t}else i=[NaN]}return i}_set_canvas_image(){const{orientation:e}=this;let{palette:i}=this.color_mapper;if(null==this._index_high&&null==this._index_low||(i=i.slice(null!=this._index_low?this._index_low:0,null!=this._index_high?this._index_high+1:i.length)),i.length<1)return void(this._image=null);"vertical"==e&&(i=(0,m.reversed)(i));const[n,t]="vertical"==e?[1,i.length]:[i.length,1],a=this._image=document.createElement("canvas");a.width=n,a.height=t;const o=a.getContext("2d"),l=o.getImageData(0,0,n,t),r=new c.LinearColorMapper({palette:i}).rgba_mapper.v_compute((0,m.range)(0,i.length));l.data.set(r),o.putImageData(l,0,0)}}n.ColorBarView=u,u.__name__="ColorBarView";class w extends l.BaseColorBar{constructor(e){super(e)}}n.ColorBar=w,o=w,w.__name__="ColorBar",o.prototype.default_view=u,o.define((({Alpha:e,Nullable:i,Float:n,Ref:t})=>({color_mapper:[t(_.ColorMapper)],display_low:[i(n),null],display_high:[i(n),null],scale_alpha:[e,1]})))},
function _(i,s,x,A,e){A(),e("Axis",i(202).Axis),e("CategoricalAxis",i(279).CategoricalAxis),e("ContinuousAxis",i(208).ContinuousAxis),e("DatetimeAxis",i(280).DatetimeAxis),e("LinearAxis",i(207).LinearAxis),e("LogAxis",i(281).LogAxis),e("MercatorAxis",i(282).MercatorAxis),e("TimedeltaAxis",i(283).TimedeltaAxis)},
function _(t,s,e,o,i){var a;o();const r=t(1),l=t(202),_=t(214),n=t(257),c=r.__importStar(t(95)),p=t(21),h=t(192),m=t(8);class u extends l.AxisView{_hit_value(t,s){const[e]=this.ranges,{start:o,end:i,span:a}=e;switch(this.dimension){case 0:{const{x0:s,width:i}=this.bbox;return e.factor(a*(t-s)/i+o)}case 1:{const{y0:t,height:o}=this.bbox;return e.factor(i-a*(s-t)/o)}}}_paint(t){const{tick_coords:s,extents:e}=this;super._paint(t),this._draw_group_separators(t,e,s)}_draw_group_separators(t,s,e){const[o]=this.ranges,[i,a]=this.computed_bounds,{factors:r}=o,{tops:l}=o.mapper;if(null==l||l.length<2||!this.visuals.separator_line.doit)return;const _=this.dimension,n=1-_,c=[[],[]];let p=0;for(let t=0;t<l.length-1;t++){let s,e;for(let o=p;o<r.length;o++)if(r[o][0]==l[t+1]){[s,e]=[r[o-1],r[o]],p=o;break}const h=(o.synthetic(s)+o.synthetic(e))/2;h>i&&h<a&&(c[_].push(h),c[n].push(this.loc))}const h=this.extents.tick_label;this._draw_ticks(t,c,-3,h-6,this.visuals.separator_line)}_draw_major_labels(t,s,e){const o=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let e=0;e<o.length;e++){const[a,r,l,_]=o[e];this._draw_oriented_labels(t,a,r,l,i,_),i+=s.tick_labels[e]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[e,,o,i]of t){const t=this._oriented_labels_extent(e,o,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,e]=this.computed_bounds,o=this.loc,i=this.model.ticker.get_ticks(s,e,t,o),a=this.tick_coords,r=[],l=t=>new h.GraphicsBoxes(t.map((t=>(0,m.isString)(t)?new h.TextBox({text:t}):t))),_=t=>l(this.model.formatter.doFormat(t,this));switch(t.mapper.levels){case 1:{const t=_(i.major);r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text]);break}case 2:{const t=_(i.major.map((t=>t[1])));r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([l(i.tops),a.tops,this.model.group_label_orientation,this.visuals.group_text]);break}case 3:{const t=_(i.major.map((t=>t[2]))),s=i.mids.map((t=>t[1]));r.push([t,a.major,this.model.major_label_orientation,this.visuals.major_label_text]),r.push([l(s),a.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),r.push([l(i.tops),a.tops,this.model.group_label_orientation,this.visuals.group_text]);break}}return r}get tick_coords(){const t=this.dimension,s=1-t,[e]=this.ranges,[o,i]=this.computed_bounds,a=this.model.ticker.get_ticks(o,i,e,this.loc),r={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};r.major[t]=a.major,r.major[s]=a.major.map((()=>this.loc));const{levels:l}=e.mapper;return 3==l&&(r.mids[t]=a.mids,r.mids[s]=a.mids.map((()=>this.loc))),l>1&&(r.tops[t]=a.tops,r.tops[s]=a.tops.map((()=>this.loc))),r}}e.CategoricalAxisView=u,u.__name__="CategoricalAxisView";class d extends l.Axis{constructor(t){super(t)}}e.CategoricalAxis=d,a=d,d.__name__="CategoricalAxis",a.prototype.default_view=u,a.mixins([["separator_",c.Line],["group_",c.Text],["subgroup_",c.Text]]),a.define((({Float:t,Or:s})=>({group_label_orientation:[s(p.LabelOrientation,t),"parallel"],subgroup_label_orientation:[s(p.LabelOrientation,t),"parallel"]}))),a.override({ticker:()=>new _.CategoricalTicker,formatter:()=>new n.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},
function _(e,t,i,s,a){var n;s();const o=e(208),r=e(258),m=e(217);class _ extends o.ContinuousAxisView{}i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";class c extends o.ContinuousAxis{constructor(e){super(e)}}i.DatetimeAxis=c,n=c,c.__name__="DatetimeAxis",n.prototype.default_view=_,n.override({ticker:()=>new m.DatetimeTicker,formatter:()=>new r.DatetimeTickFormatter})},
function _(t,e,s,i,o){var n;i();const r=t(208),c=t(264),a=t(224);class _ extends r.ContinuousAxisView{_hit_value(t,e){const[s]=this.ranges,{start:i,end:o}=s,{log10:n}=Math;switch(this.dimension){case 0:{const{x0:e,width:s}=this.bbox;return n(o/i)*(t-e)/s+n(i)}case 1:{const{y0:t,height:s}=this.bbox;return n(o)-n(o/i)*(e-t)/s}}}}s.LogAxisView=_,_.__name__="LogAxisView";class u extends r.ContinuousAxis{constructor(t){super(t)}}s.LogAxis=u,n=u,u.__name__="LogAxis",n.prototype.default_view=_,n.override({ticker:()=>new a.LogTicker,formatter:()=>new c.LogTickFormatter})},
function _(e,r,t,i,a){var o;i();const s=e(207),n=e(265),c=e(225);class _ extends s.LinearAxisView{}t.MercatorAxisView=_,_.__name__="MercatorAxisView";class x extends s.LinearAxis{constructor(e){super(e)}}t.MercatorAxis=x,o=x,x.__name__="MercatorAxis",o.prototype.default_view=_,o.override({ticker:()=>new c.MercatorTicker({dimension:"lat"}),formatter:()=>new n.MercatorTickFormatter({dimension:"lat"})})},
function _(e,i,t,s,a){var n;s();const o=e(208),r=e(268),d=e(226);class m extends o.ContinuousAxisView{}t.TimedeltaAxisView=m,m.__name__="TimedeltaAxisView";class _ extends o.ContinuousAxis{constructor(e){super(e)}}t.TimedeltaAxis=_,n=_,_.__name__="TimedeltaAxis",n.prototype.default_view=m,n.override({ticker:()=>new d.TimedeltaTicker,formatter:()=>new r.TimedeltaTickFormatter})},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(285).CategoricalColorMapper),e("CategoricalMarkerMapper",r(287).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(288).CategoricalPatternMapper),e("ContinuousColorMapper",r(229).ContinuousColorMapper),e("ColorMapper",r(230).ColorMapper),e("LinearColorMapper",r(289).LinearColorMapper),e("LogColorMapper",r(290).LogColorMapper),e("ScanningColorMapper",r(228).ScanningColorMapper),e("EqHistColorMapper",r(291).EqHistColorMapper),e("StackColorMapper",r(292).StackColorMapper),e("WeightedStackColorMapper",r(293).WeightedStackColorMapper)},
function _(t,o,a,r,e){var c;r();const l=t(286),s=t(230),n=t(121);class _ extends s.ColorMapper{constructor(t){super(t)}_v_compute(t,o,a,{nan_color:r}){(0,l.cat_v_compute)(t,this.factors,a,o,this.start,this.end,r)}}a.CategoricalColorMapper=_,c=_,_.__name__="CategoricalColorMapper",c.define((({Float:t,Nullable:o})=>({factors:[n.FactorSeq],start:[t,0],end:[o(t),null]})))},
function _(n,t,e,o,i){o(),e._cat_equals=l,e.cat_v_compute=function(n,t,e,o,i,r,s){let u=0;for(const _ of n){let n;if((0,f.isArray)(_)){const e=_.slice(i,r??void 0);n=1==e.length?(0,c.index_of)(t,e[0]):(0,c.find_index)(t,(n=>l(n,e)))}else n=(0,c.index_of)(t,_);const d=n in e?e[n]:s;o[u++]=d}};const c=n(13),f=n(8);function l(n,t){if(n.length!=t.length)return!1;const e=n.length;for(let o=0;o<e;o++)if(n[o]!==t[o])return!1;return!0}},
function _(e,r,a,t,s){var c;t();const l=e(286),n=e(121),o=e(231),u=e(21);class i extends o.Mapper{constructor(e){super(e)}v_compute(e){const r=new Array(e.length);return(0,l.cat_v_compute)(e,this.factors,this.markers,r,this.start,this.end,this.default_value),r}}a.CategoricalMarkerMapper=i,c=i,i.__name__="CategoricalMarkerMapper",c.define((({Float:e,List:r,Nullable:a})=>({factors:[n.FactorSeq],markers:[r(u.MarkerType)],start:[e,0],end:[a(e),null],default_value:[u.MarkerType,"circle"]})))},
function _(t,e,a,r,n){var s;r();const c=t(286),l=t(121),o=t(231),p=t(21);class u extends o.Mapper{constructor(t){super(t)}v_compute(t){const e=new Array(t.length);return(0,c.cat_v_compute)(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=u,s=u,u.__name__="CategoricalPatternMapper",s.define((({Float:t,List:e,Nullable:a})=>({factors:[l.FactorSeq],patterns:[e(p.HatchPatternType)],start:[t,0],end:[a(t),null],default_value:[p.HatchPatternType," "]})))},
function _(n,r,o,t,a){t();const e=n(229),i=n(13),s=n(11);class _ extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:(0,i.min)(n),t=null!=this.high?this.high:(0,i.max)(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}index_to_value(n){const r=this._scan_data;return r.min+r.normed_interval*n/r.norm_factor}value_to_index(n,r){const o=this._scan_data;if(n==o.max)return r-1;const t=(n-o.min)*o.norm_factor,a=Math.floor(t/o.normed_interval);return(0,s.clamp)(a,-1,r)}}o.LinearColorMapper=_,_.__name__="LinearColorMapper"},
function _(n,t,a,o,s){o();const r=n(229),e=n(13),i=n(11);class l extends r.ContinuousColorMapper{constructor(n){super(n)}scan(n,t){const a=null!=this.low?this.low:(0,e.min)(n),o=null!=this.high?this.high:(0,e.max)(n);return{max:o,min:a,scale:t/Math.log(o/a)}}index_to_value(n){const t=this._scan_data;return t.min*Math.exp(n/t.scale)}value_to_index(n,t){const a=this._scan_data;if(n==a.max)return t-1;if(n>a.max)return t;if(n<a.min)return-1;const o=Math.log(n/a.min),s=Math.floor(o*a.scale);return(0,i.clamp)(s,-1,t)}}a.LogColorMapper=l,l.__name__="LogColorMapper"},
function _(e,n,s,t,l){var o;t();const i=e(228),r=e(13),c=e(10);class a extends i.ScanningColorMapper{constructor(e){super(e)}scan(e,n){const s=null!=this.low?this.low:(0,r.min)(e),t=null!=this.high?this.high:(0,r.max)(e),l=this.bins,o=(0,c.linspace)(s,t,l+1),i=(0,r.bin_counts)(e,o);let a=0;for(let e=0;e<l;e++)0!=i[e]&&a++;const _=new Array(a+1),h=new Array(a+1);for(let e=0,n=1;e<l;e++)0!=i[e]&&(_[n]=i[e],h[n]=(o[e]+o[e+1])/2,n++);_[0]=0,h[0]=2*h[1]-h[a];const f=(0,c.cumsum)(_),p=f[1],u=f[a]-p;for(let e=1;e<=a;e++)f[e]=(f[e]-p)/u;f[0]=-1;let{rescale_discrete_levels:m}=this,d=0;if(m){const e=-.5/98,n=e*a+(1.5-2*e);n>1?d=1-n:m=!1}const g=(0,c.linspace)(d,1,n+1),w=(0,r.interpolate)(g,f,h);let b=!1;if(m){const e=(0,r.sorted_index)(w,s);s<w[e]&&e>0&&(w[e-1]=s),b=!0}else w[0]=s;return w[w.length-1]=t,{min:s,max:t,binning:w,force_low_cutoff:b}}}s.EqHistColorMapper=a,o=a,a.__name__="EqHistColorMapper",o.define((({Bool:e,Int:n})=>({bins:[n,65536],rescale_discrete_levels:[e,!1]})))},
function _(o,r,a,c,e){c();const p=o(230);class t extends p.ColorMapper{constructor(o){super(o)}}a.StackColorMapper=t,t.__name__="StackColorMapper"},
function _(e,t,o,r,a){var l;r();const n=e(230),s=e(229),c=e(292),i=e(25),_=e(13),p=e(12),h=e(23);class u extends c.StackColorMapper{constructor(e){super(e)}_mix_colors(e,t,o,r){if(isNaN(r))return t;let a=0,l=0,n=0,s=0;const c=o.length;if(0!=r)for(let t=0;t<c;t++){if(isNaN(o[t]))continue;const c=o[t]/r;a+=e[4*t]*c,l+=e[4*t+1]*c,n+=e[4*t+2]*c,s+=e[4*t+3]*c}else{let t=0;for(let r=0;r<c;r++)0==o[r]&&(a+=e[4*r],l+=e[4*r+1],n+=e[4*r+2],s+=e[4*r+3],t++);a/=t,l/=t,n/=t,s/=t}return(0,h.encode_rgba)([(0,h.byte)(a),(0,h.byte)(l),(0,h.byte)(n),(0,h.byte)(s)])}_v_compute(e,t,o,r){const a=t.length,l=o.length,s=e.length/a;(0,p.assert)(s==l,`Expected ${s} not ${l} colors in palette`);const c=new i.RGBAArray(4*l);for(let e=0;e<l;e++){const[t,r,a,l]=(0,h.decode_rgba)(o[e]);c[4*e]=t,c[4*e+1]=r,c[4*e+2]=a,c[4*e+3]=l}const u=this.color_baseline,f=u??(0,_.min)(e),{nan_color:b}=r,N=new Array(a),m=new Array(l);for(let o=0;o<a;o++){let r=NaN;for(let t=0;t<l;t++){const a=o*l+t,n=0==f?e[a]:Math.max(e[a]-f,0);m[t]=n,isNaN(n)||(isNaN(r)?r=n:r+=n)}t[o]=this._mix_colors(c,b,m,r),N[o]=r+f*l}const y=(0,n.convert_to_uint32_palette)(this.alpha_mapper.palette),d=new Uint32Array(a);this.alpha_mapper._v_compute(N,d,y,r);for(let e=0;e<a;e++){const o=(0,h.byte)((255&t[e])*(255&d[e])/255);t[e]=4294967040&t[e]|o}}}o.WeightedStackColorMapper=u,l=u,u.__name__="WeightedStackColorMapper",l.define((({List:e,Nullable:t,Float:o,Ref:r,Str:a})=>({alpha_mapper:[r(s.ContinuousColorMapper)],color_baseline:[t(o),null],stack_labels:[t(e(a)),null]})))},
function _(e,t,i,r,l){var n;r();const o=e(184),s=e(271),a=e(232),_=e(69),h=e(12);class d extends o.BaseColorBarView{*children(){yield*super.children(),yield this._fill_view,yield this._line_view}async lazy_initialize(){await super.lazy_initialize();const{fill_renderer:e,line_renderer:t}=this.model;this._fill_view=await(0,_.build_view)(e,{parent:this.parent}),this._line_view=await(0,_.build_view)(t,{parent:this.parent})}remove(){this._fill_view.remove(),this._line_view.remove(),super.remove()}_create_major_range(){const e=this.model.levels;return e.length>0?new s.Range1d({start:e[0],end:e[e.length-1]}):new s.Range1d({start:0,end:1})}_paint_colors(e,t){const i="vertical"==this.orientation,r=this.model.levels,l=this._major_scale;l.source_range=this._major_range,l.target_range=i?new s.Range1d({start:t.bottom,end:t.top}):new s.Range1d({start:t.left,end:t.right});const n=l.v_compute(r),o=this._fill_view.glyph,a=o.data_size;if(a>0){(0,h.assert)(r.length==a+1,"Inconsistent number of filled contour levels"),e.save();for(let r=0;r<a;r++)e.beginPath(),i?e.rect(t.left,n[r],t.width,n[r+1]-n[r]):e.rect(n[r],t.top,n[r+1]-n[r],t.height),o.visuals.fill.apply(e,r),o.visuals.hatch.apply(e,r);e.restore()}const _=this._line_view.glyph,d=_.data_size;if(d>0){(0,h.assert)(r.length==d,"Inconsistent number of line contour levels"),e.save();for(let r=0;r<d;r++)e.beginPath(),i?(e.moveTo(t.left,n[r]),e.lineTo(t.right,n[r])):(e.moveTo(n[r],t.bottom),e.lineTo(n[r],t.top)),_.visuals.line.set_vectorize(e,r),e.stroke();e.restore()}}}i.ContourColorBarView=d,d.__name__="ContourColorBarView";class v extends o.BaseColorBar{constructor(e){super(e)}}i.ContourColorBar=v,n=v,v.__name__="ContourColorBar",n.prototype.default_view=d,n.define((({List:e,Float:t,Ref:i})=>({fill_renderer:[i(a.GlyphRenderer)],line_renderer:[i(a.GlyphRenderer)],levels:[e(t),[]]})))},
function _(t,e,n,s,a){var i;s();const o=t(1),r=t(186),_=t(11),l=t(21),h=t(12),c=t(16),u=t(73),d=t(124),x=o.__importStar(t(127)),p=t(58);function m(t,e){return{x:t,y:e}}class g extends r.TextAnnotationView{constructor(){super(...arguments),this._pan_state=null}get mappers(){function t(t,e,n,s){switch(t){case"canvas":return s;case"screen":return n;case"data":return e}}const e=this.model,n=this.layout??this.plot_view.frame,{x_scale:s,y_scale:a}=this.coordinates,{x_view:i,y_view:o}=n.bbox,{x_screen:r,y_screen:_}=this.plot_view.canvas.bbox;return{x:t(e.x_units,s,i,r),y:t(e.y_units,a,o,_)}}get anchor(){const{align:t,baseline:e}=this.visuals.text.values();return x.text_anchor(this.model.anchor,t,e)}get angle(){const{angle:t,angle_units:e,direction:n}=this.model;return(0,_.compute_angle)(t,e,n)}get origin(){const{mappers:t}=this,{x:e,y:n,x_offset:s,y_offset:a}=this.model,i=(t,e,n)=>e instanceof p.Coordinate?this.resolve_as_scalar(e,t):n.compute(e);return{sx:i("x",e,t.x)+s,sy:i("y",n,t.y)-a}}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&"area"==this._hit_test(t,e)}_hit_test(t,e){const{sx:n,sy:s,anchor:a,angle:i,width:o,height:r}=this._rect,{x:_,y:l}=(0,u.rotate_around)(m(t,e),m(n,s),-i),h=n-a.x*o,c=s-a.y*r;return h<=_&&_<=h+o&&c<=l&&l<=c+r?"area":null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:n}=t,s=this._hit_test(e,n);if(null!=s&&this._can_hit(s))return this._pan_state={angle:this.angle,base:{sx:e,sy:n},target:s,action:"rotate"},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,h.assert)(null!=this._pan_state);const{dx:e,dy:n}=t,{angle:s,base:a}=this._pan_state,{origin:i}=this,o=(0,_.atan2)([i.sx,i.sy],[a.sx,a.sy]),r=(s+((0,_.atan2)([i.sx,i.sy],[a.sx+e,a.sy+n])-o))%(2*Math.PI),{angle_units:l,direction:c}=this.model;this.model.angle=(0,_.invert_angle)(r,l,c),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}cursor(t,e){const n=this._pan_state?.target??this._hit_test(t,e);return null!=n&&this._can_hit(n)?"var(--bokeh-cursor-rotate)":null}}n.LabelView=g,g.__name__="LabelView";class y extends r.TextAnnotation{constructor(t){super(t),this.pan=new c.Signal(this,"pan")}}n.Label=y,i=y,y.__name__="Label",i.prototype.default_view=g,i.define((({Bool:t,Float:e,Angle:n,Or:s,Ref:a})=>({anchor:[d.TextAnchor,"auto"],x:[s(e,a(p.Coordinate))],y:[s(e,a(p.Coordinate))],x_units:[l.CoordinateUnits,"data"],y_units:[l.CoordinateUnits,"data"],x_offset:[e,0],y_offset:[e,0],angle:[n,0],angle_units:[l.AngleUnits,"rad"],direction:[l.Direction,"anticlock"],editable:[t,!1]})))},
function _(t,e,i,s,a){var n;s();const o=t(1),l=t(141),r=o.__importStar(t(95)),c=t(21),_=t(192),u=o.__importStar(t(19)),h=t(25);class d extends l.DataAnnotationView{map_data(){const{x_scale:t,y_scale:e}=this.coordinates,i=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new h.ScreenArray(this._x);case"screen":return i.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new h.ScreenArray(this._y);case"screen":return i.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}_paint_data(t){for(let e=0,i=this.text.length;e<i;e++){const i=this.x_offset.get(e),s=this.y_offset.get(e),a=this.sx[e]+i,n=this.sy[e]-s,o=this.angle.get(e),l=this.text.get(e);isFinite(a+n+o)&&null!=l&&this._paint_text(t,e,`${l}`,a,n,o)}}_paint_text(t,e,i,s,a,n){const o=new _.TextBox({text:i});o.angle=n,o.position={sx:s,sy:a},o.visuals=this.visuals.text.values(e);const{background_fill:l,background_hatch:r,border_line:c}=this.visuals;if(l.doit||r.doit||c.doit){const{p0:i,p1:s,p2:a,p3:n}=o.rect();t.beginPath(),t.moveTo(i.x,i.y),t.lineTo(s.x,s.y),t.lineTo(a.x,a.y),t.lineTo(n.x,n.y),t.closePath(),this.visuals.background_fill.apply(t,e),this.visuals.background_hatch.apply(t,e),this.visuals.border_line.apply(t,e)}this.visuals.text.doit&&o.paint(t)}}i.LabelSetView=d,d.__name__="LabelSetView";class x extends l.DataAnnotation{constructor(t){super(t)}}i.LabelSet=x,n=x,x.__name__="LabelSet",n.prototype.default_view=d,n.mixins([r.TextVector,["border_",r.LineVector],["background_",r.FillVector],["background_",r.HatchVector]]),n.define((()=>({x:[u.XCoordinateSpec,{field:"x"}],y:[u.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[u.NullStringSpec,{field:"text"}],angle:[u.AngleSpec,0],x_offset:[u.NumberSpec,{value:0}],y_offset:[u.NumberSpec,{value:0}]}))),n.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,s,n){var o;s();const l=t(1),r=t(96),a=t(298),c=t(21),_=l.__importStar(t(95)),d=t(187),h=t(62),u=t(10),p=t(9),g=t(8),b=t(14),m=t(80),v=t(61),f=t(192),x=l.__importStar(t(299)),y=t(124),w=t(197),$=l.__importStar(t(127)),{ceil:k}=Math;class L extends r.AnnotationView{constructor(){super(...arguments),this._bbox=new h.BBox,this.grid_el=(0,v.div)({class:x.grid}),this.title_el=(0,v.div)(),this.entries=[]}get is_dual_renderer(){return!0}_get_size(){const{width:t,height:e}=this.bbox,{margin:i}=this.model;return{width:t+2*i,height:e+2*i}}update_layout(){this.update_geometry();const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size())):void 0}initialize(){super.initialize(),this._resize_observer=new ResizeObserver((t=>this.request_layout())),this._resize_observer.observe(this.el,{box:"border-box"})}remove(){this._resize_observer.disconnect(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.rerender()));const{items:t}=this.model.properties;this.on_transitive_change(t,(()=>this._render_items()))}get bbox(){return this._bbox}get padding(){const t=null!=this.model.border_line_color?this.model.padding:0;return $.padding(t)}get border_radius(){return $.border_radius(this.model.border_radius)}stylesheets(){return[...super.stylesheets(),x.default]}_paint_glyphs(){const{glyph_width:t,glyph_height:e}=this.model,i=t,s=e;for(const{glyph:n,item:o,label:l}of this.entries){const r=o.get_field_from_label_prop();n.resize(t,e);const a=n.prepare();for(const t of o.renderers){const e=this.plot_view.views.find_one(t);e?.draw_legend(a,0,i,0,s,r,l,o.index)}n.finish()}}get labels(){const t=[];for(const e of this.model.items){const i=e.get_labels_list_from_label_prop();for(const s of i)t.push({item:e,label:s})}return t}get _should_rerender_items(){const{entries:t,labels:e}=this;if(t.length!=e.length)return!0;for(const[i,{item:s,label:n}]of(0,b.zip)(t,e))if(i.item!=s||i.label!=n)return!0;return!1}_toggle_inactive({el:t,item:e}){t.classList.toggle(x.inactive,!this.is_active(e))}_render_items(){this.entries=[];const{click_policy:t}=this;let e=0;for(const i of this.model.items){const s=i.get_labels_list_from_label_prop();for(const n of s){const s=this.plot_view.canvas.create_layer();s.el.classList.add(x.glyph);const o=s.canvas,l=(0,v.div)({class:x.label},`${n}`),r=(0,v.div)({class:x.overlay}),a=(0,v.div)({class:x.item},o,l,r);a.classList.toggle(x.hidden,!i.visible);const c={el:a,glyph:s,label_el:l,item:i,label:n,i:e++,row:0,col:0};this.entries.push(c),a.addEventListener("pointerdown",(()=>{this.model.trigger_event(new m.LegendItemClick(this.model,i));for(const e of i.renderers)t(e);this._toggle_inactive(c)}))}}const i="vertical"==this.model.orientation,{nc:s,nr:n}=(()=>{const{ncols:t,nrows:e}=this.model,s=this.entries.length;let n,o;return"auto"!=t&&"auto"!=e?(n=t,o=e):"auto"!=t?(n=t,o=k(s/t)):"auto"!=e?(n=k(s/e),o=e):i?(n=1,o=s):(n=s,o=1),{nc:n,nr:o}})();let o=0,l=0;for(const t of this.entries)t.el.id=`item_${o}_${l}`,t.row=o,t.col=l,i?(o+=1,o>=n&&(o=0,l+=1)):(l+=1,l>=s&&(l=0,o+=1));for(const t of this.entries)this._toggle_inactive(t);for(const{el:t,i:e,row:i,col:s}of this.entries)this.has_item_background(e,i,s)&&t.classList.add(x.styled);(0,v.empty)(this.grid_el),this.grid_el.style.setProperty("--ncols",`${s}`),this.grid_el.style.setProperty("--nrows",`${n}`),this.grid_el.append(...this.entries.map((({el:t})=>t)))}render(){super.render();const{orientation:t}=this.model,e="vertical"==t;this.el.classList.toggle(x.interactive,this.is_interactive),this.el.classList.toggle(x.vertical,e);const i=(0,v.div)({class:x.title},this.model.title);this.title_el.remove(),this.title_el=i;const{writing_mode:s,rotate:n}=(()=>{switch(new d.SidePanel(this.model.title_location).face_adjusted_side){case"above":case"below":return{writing_mode:"horizontal-tb",rotate:0};case"left":return{writing_mode:"vertical-rl",rotate:180};case"right":return{writing_mode:"vertical-rl",rotate:0}}})(),o=this.visuals.title_text.computed_values();this.style.append(`\n    .${x.title} {\n      font: ${o.font};\n      color: ${o.color};\n      -webkit-text-stroke: 1px ${o.outline_color};\n      writing-mode: ${s};\n      rotate: ${n}deg;\n    }\n    `);const l=this.visuals.label_text.computed_values();this.style.append(`\n    .${x.item} .${x.label} {\n      font: ${l.font};\n      color: ${l.color};\n      -webkit-text-stroke: 1px ${l.outline_color};\n    }\n    `);const{anchor:r}=this;if(this.style.append(`\n    :host {\n      transform: translate(-${100*r.x}%, -${100*r.y}%);\n    }\n    `),this.style.append(`\n    :host {\n      gap: ${(0,v.px)(this.model.title_standoff)};\n    }\n    .${x.grid} {\n      gap: ${(0,v.px)(this.model.spacing)};\n    }\n    .${x.item} {\n      gap: ${(0,v.px)(this.model.label_standoff)};\n    }\n    .${x.item} .${x.glyph} {\n      width: ${(0,v.px)(this.model.glyph_width)};\n      height: ${(0,v.px)(this.model.glyph_height)};\n    }\n    .${x.item} .${x.label} {\n      min-width: ${(0,v.px)(this.model.label_width)};\n      min-height: ${(0,v.px)(this.model.label_height)};\n    }\n    `),this.visuals.item_background_fill.doit){const{color:t}=this.visuals.item_background_fill.computed_values();this.style.append(`\n      .${x.item} {\n        --item-background-color: ${t};\n      }\n      `)}if(this.visuals.inactive_fill.doit){const{color:t}=this.visuals.inactive_fill.computed_values();this.style.append(`\n      .${x.item} {\n        --item-background-inactive-color: ${t};\n      }\n      `)}const a=(()=>{switch(this.model.title_location){case"above":case"below":return"row";case"left":case"right":return"column"}})();this.style.append(`\n      :host {\n        grid-auto-flow: ${a};\n      }\n    `),this.shadow_el.append(...(()=>{switch(this.model.title_location){case"above":case"left":return[i,this.grid_el];case"below":case"right":return[this.grid_el,i]}})());const{padding:c,border_radius:_}=this;if(this.style.append(`\n    :host {\n      padding-left: ${c.left}px;\n      padding-right: ${c.right}px;\n      padding-top: ${c.top}px;\n      padding-bottom: ${c.bottom}px;\n\n      border-top-left-radius: ${_.top_left}px;\n      border-top-right-radius: ${_.top_right}px;\n      border-bottom-right-radius: ${_.bottom_right}px;\n      border-bottom-left-radius: ${_.bottom_left}px;\n    }\n    `),this.visuals.background_fill.doit){const{color:t}=this.visuals.background_fill.computed_values();this.style.append(`\n      :host {\n        background-color: ${t};\n      }\n      `)}if(this.visuals.border_line.doit){const{color:t,width:e,dash:i}=this.visuals.border_line.computed_values();this.style.append(`\n      :host {\n        border-color: ${t};\n        border-width: ${e}px;\n        border-style: ${(0,g.isString)(i)?i:i.length<2?"solid":"dashed"};\n      }\n      `)}this._render_items()}after_render(){super.after_render(),this.update_position(),this.request_paint()}get location(){const{location:t}=this.model;if((0,g.isString)(t)){const e=(()=>{switch(t){case"top":return"top_center";case"bottom":return"bottom_center";case"left":return"center_left";case"center":return"center_center";case"right":return"center_right";default:return t}})(),[i,s]=e.split("_");return{x:s,y:i}}{const[e,i]=t;return{x:e,y:i}}}get anchor(){const{location:t}=this;return{x:(()=>{switch(t.x){case"left":default:return 0;case"center":return.5;case"right":return 1}})(),y:(()=>{switch(t.y){case"top":return 0;case"center":return.5;default:return 1}})()}}get css_position(){const{location:t}=this,{margin:e}=this.model,i=this.layout??this.plot_view.frame;return{x:(()=>{const{x:s}=t;switch(s){case"left":return`calc(0% + ${(0,v.px)(e)})`;case"center":return"50%";case"right":return`calc(100% - ${(0,v.px)(e)})`;default:return(0,v.px)(i.bbox.relative().x_view.compute(s))}})(),y:(()=>{const{y:s}=t;switch(s){case"top":return`calc(0% + ${(0,v.px)(e)})`;case"center":return"50%";case"bottom":return`calc(100% - ${(0,v.px)(e)})`;default:return(0,v.px)(i.bbox.relative().y_view.compute(s))}})()}}get is_visible(){const{visible:t,items:e}=this.model;return t&&0!=e.length&&(0,u.some)(e,(t=>t.visible))}update_position(){if(this.is_visible){const{x:t,y:e}=this.css_position;this.position.replace(`\n      :host {\n        position: ${null!=this.layout?"relative":"absolute"};\n        left: ${t};\n        top:  ${e};\n      }\n      `)}else this.position.replace("\n      :host {\n        display: none;\n      }\n      ");const t=(0,v.bounding_box)(this.el),e=(0,v.bounding_box)(this.plot_view.canvas.el);this._bbox=t.relative_to(e)}get is_interactive(){return"none"!=this.model.click_policy||(0,p.dict)(this.model.js_event_callbacks).has("legend_item_click")}get click_policy(){switch(this.model.click_policy){case"hide":return t=>t.visible=!t.visible;case"mute":return t=>t.muted=!t.muted;case"none":return t=>{}}}get is_active(){switch(this.model.click_policy){case"none":return t=>!0;case"hide":return t=>(0,u.every)(t.renderers,(t=>t.visible));case"mute":return t=>(0,u.every)(t.renderers,(t=>!t.muted))}}has_item_background(t,e,i){if(!this.visuals.item_background_fill.doit&&!this.visuals.item_background_hatch.doit)return!1;switch(this.model.item_background_policy){case"every":return!0;case"even":return e%2==0==(i%2==0);case"odd":return e%2==0!=(i%2==0);case"none":return!1}}_paint(t){if(this.is_visible)if(this.is_dual_renderer&&!this.parent.is_forcing_paint)this._should_rerender_items&&this._render_items(),this._paint_glyphs();else{t.save();const e=(0,v.bounding_box)(this.plot_view.canvas.el);this._draw_legend_box(t,e),this._draw_title(t,e),this._draw_legend_items(t,e),t.restore()}}_draw_legend_box(t,e){t.beginPath();const i=(0,v.bounding_box)(this.el).relative_to(e);(0,w.round_rect)(t,i,this.border_radius),this.visuals.background_fill.apply(t),this.visuals.background_hatch.apply(t),this.visuals.border_line.apply(t)}_draw_title(t,e){const{title:i}=this.model;if(null==i||0==i.length||!this.visuals.title_text.doit)return;const s=this.title_el.textContent,n=new f.TextBox({text:s}),o=(0,v.bounding_box)(this.title_el).relative_to(e);let{x:l,y:r}=o;switch(this.model.title_location){case"left":r+=o.height;break;case"right":l+=o.width}n.position={sx:l,sy:r,x_anchor:"left",y_anchor:"top"},n.visuals=this.visuals.title_text.values();const a=new d.SidePanel(this.model.title_location);n.angle=a.get_label_angle_heuristic("parallel"),n.paint(t)}_draw_legend_items(t,e){const{is_active:i}=this;for(const{el:s,glyph:n,label_el:o,item:l,i:r,row:a,col:c}of this.entries){const _=(0,v.bounding_box)(s).relative_to(e);this.has_item_background(r,a,c)&&(t.beginPath(),t.rect_bbox(_),this.visuals.item_background_fill.apply(t),this.visuals.item_background_hatch.apply(t)),t.layer.undo_transform((()=>{const i=n.canvas,s=(0,v.bounding_box)(i).relative_to(e).scale(t.layer.pixel_ratio);t.drawImage(i,s.x,s.y)}));const d=o.textContent,h=new f.TextBox({text:d}),{x:u,vcenter:p}=(0,v.bounding_box)(o).relative_to(e);h.position={sx:u,sy:p,x_anchor:"left",y_anchor:"center"},h.visuals=this.visuals.label_text.values(),h.paint(t),i(l)||(t.beginPath(),t.rect_bbox(_),this.visuals.inactive_fill.apply(t),this.visuals.inactive_hatch.apply(t))}}}i.LegendView=L,L.__name__="LegendView";class z extends r.Annotation{constructor(t){super(t)}}i.Legend=z,o=z,z.__name__="Legend",o.prototype.default_view=L,o.mixins([["label_",_.Text],["title_",_.Text],["inactive_",_.Fill],["inactive_",_.Hatch],["border_",_.Line],["background_",_.Fill],["background_",_.Hatch],["item_background_",_.Fill],["item_background_",_.Hatch]]),o.define((({Float:t,Int:e,Str:i,List:s,Tuple:n,Or:o,Ref:l,Nullable:r,Positive:_,Auto:d})=>({orientation:[c.Orientation,"vertical"],ncols:[o(_(e),d),"auto"],nrows:[o(_(e),d),"auto"],location:[o(c.LegendLocation,n(t,t)),"top_right"],title:[r(i),null],title_location:[c.Location,"above"],title_standoff:[t,5],label_standoff:[t,5],glyph_width:[t,20],glyph_height:[t,20],label_width:[t,20],label_height:[o(t,d),"auto"],margin:[t,10],padding:[y.Padding,10],border_radius:[y.BorderRadius,0],spacing:[t,3],items:[s(l(a.LegendItem)),[]],click_policy:[c.LegendClickPolicy,"none"],item_background_policy:[c.AlternationPolicy,"none"]}))),o.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,item_background_fill_color:"#f1f1f1",item_background_fill_alpha:.8,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,r,l,n,t){var s;n();const i=e(1),o=e(52),_=e(232),a=e(142),u=e(29),d=i.__importStar(e(19)),c=e(20),f=e(10);class h extends o.Model{constructor(e){super(e)}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(!(0,f.includes)(r.columns(),e))return!1}return!0}initialize(){super.initialize();this._check_data_sources_on_renderers()||c.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||c.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return(0,u.isField)(e)?e.field:null}get_labels_list_from_label_prop(){if(!this.visible)return[];const{index:e}=this;if(null!=e&&this.renderers.every((r=>!r.view.indices_map.has(e))))return[];if((0,u.isValue)(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const r=this.get_field_from_label_prop();if(null!=r){let e;if(0==this.renderers.length)return["No source found"];if(e=this.renderers[0].data_source,e instanceof a.ColumnarDataSource){const l=e.get_column(r);return null!=l?(0,f.uniq)(Array.from(l)):["Invalid field"]}}return[]}}l.LegendItem=h,s=h,h.__name__="LegendItem",s.define((({Bool:e,Int:r,List:l,Ref:n,Nullable:t})=>({label:[d.NullStringSpec,null],renderers:[l(n(_.GlyphRenderer)),[]],index:[t(r),null],visible:[e,!0]})))},
function _(e,t,i,o,r){o(),i.hidden="bk-hidden",i.title="bk-title",i.label="bk-label",i.grid="bk-grid",i.vertical="bk-vertical",i.item="bk-item",i.styled="bk-styled",i.interactive="bk-interactive",i.glyph="bk-glyph",i.overlay="bk-overlay",i.inactive="bk-inactive",i.default=":host{position:relative;display:grid;grid-template-rows:auto;grid-template-columns:auto;pointer-events:all;}.bk-hidden{display:none;}.bk-title{position:relative;white-space:pre;cursor:auto;}.bk-title:empty{display:none;}.bk-label{position:relative;white-space:pre;cursor:auto;width:fit-content;height:fit-content;display:flex;align-items:center;}.bk-grid{position:relative;display:grid;grid-auto-flow:row;grid-template-rows:repeat(var(--nrows), max-content);grid-template-columns:repeat(var(--ncols), max-content);width:max-content;height:max-content;}:host(.bk-vertical) .bk-grid{grid-auto-flow:column;}.bk-item{position:relative;display:flex;flex-direction:row;flex-wrap:nowrap;align-items:center;}.bk-item.bk-styled{background-color:var(--item-background-color);}:host(.bk-interactive) .bk-item{cursor:pointer;}.bk-glyph{position:relative;}.bk-overlay{position:absolute;left:0;top:0;width:100%;height:100%;pointer-events:none;}.bk-item.bk-inactive .bk-overlay{background-color:var(--item-background-inactive-color);}"},
function _(t,e,s,n,i){var o,a;n();const l=t(1),r=t(96),h=t(118),_=l.__importStar(t(95)),c=t(21),p=t(243),y=t(16),d=t(62),u=t(13),v=t(12);class x{constructor(t=[],e=[]){this.xs=t,this.ys=e,(0,v.assert)(t.length==e.length)}clone(){return new x(this.xs.slice(),this.ys.slice())}[Symbol.iterator](){return this.nodes()}*nodes(){const{xs:t,ys:e,n:s}=this;for(let n=0;n<s;n++)yield[t[n],e[n],n]}*edges(){const{xs:t,ys:e,n:s}=this;for(let n=1;n<s;n++){const s={x:t[n-1],y:e[n-1]},i={x:t[n],y:e[n]};yield[s,i,n-1]}if(s>=3){const n={x:t[s-1],y:e[s-1]},i={x:t[0],y:e[0]};yield[n,i,s-1]}}contains(t,e){return(0,p.point_in_poly)(t,e,this.xs,this.ys)}get bbox(){const[t,e,s,n]=(0,u.minmax2)(this.xs,this.ys);return new d.BBox({x0:t,x1:e,y0:s,y1:n})}get n(){return this.xs.length}translate(t,e,...s){const n=this.clone(),{xs:i,ys:o,n:a}=n;if(0!=s.length)for(const n of s){const s=n%a;i[s]+=t,o[s]+=e}else for(let s=0;s<a;s++)i[s]+=t,o[s]+=e;return n}}x.__name__="Polygon";class m extends r.AnnotationView{constructor(){super(...arguments),this.poly=new x,this[o]=!0,this._pan_state=null,this._is_hovered=!1}get bbox(){return this.poly.bbox}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_paint()))}bounds(){const{xs_units:t,ys_units:e}=this.model;if("data"==t&&"data"==e){const{xs:t,ys:e}=this.model,[s,n,i,o]=(0,u.minmax2)(t,e);return{x0:s,x1:n,y0:i,y1:o}}return(0,d.empty)()}log_bounds(){return(0,d.empty)()}_mappers(){const t=(t,e,s,n)=>{switch(t){case"canvas":return n;case"screen":return s;case"data":return e}},e=this.model,{frame:s,canvas:n}=this.plot_view,{x_scale:i,y_scale:o}=s,{x_view:a,y_view:l}=s.bbox,{x_screen:r,y_screen:h}=n.bbox;return{x:t(e.xs_units,i,a,r),y:t(e.ys_units,o,l,h)}}_paint(t){const{xs:e,ys:s}=this.model;(0,v.assert)(e.length==s.length),this.poly=(()=>{const{x:t,y:n}=this._mappers();return new x(t.v_compute(e),n.v_compute(s))})(),t.beginPath();for(const[e,s]of this.poly)t.lineTo(e,s);const{_is_hovered:n,visuals:i}=this,o=n&&i.hover_fill.doit?i.hover_fill:i.fill,a=n&&i.hover_hatch.doit?i.hover_hatch:i.hatch,l=n&&i.hover_line.doit?i.hover_line:i.line;this.poly.n>=3&&(t.closePath(),o.apply(t),a.apply(t)),l.apply(t)}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&this.poly.contains(t,e)}_hit_test(t,e){const{abs:s}=Math,n=Math.max(2.5,this.model.line_width/2);for(const[i,o,a]of this.poly)if(s(i-t)<n&&s(o-e)<n)return{type:"node",i:a};const i={x:t,y:e};let o=null,a=1/0;for(const[t,e,s]of this.poly.edges()){const l=(0,p.dist_to_segment)(i,t,e);l<n&&l<a&&(a=l,o=s)}return null!=o?{type:"edge",i:o}:this.poly.contains(t,e)?{type:"area"}:null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:s}=t,n=this._hit_test(e,s);if(null!=n&&this._can_hit(n))return this._pan_state={poly:this.poly.clone(),target:n},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){(0,v.assert)(null!=this._pan_state);const e=(()=>{const{poly:e,target:s}=this._pan_state,{dx:n,dy:i}=t;switch(s.type){case"node":{const{i:t}=s;return e.translate(n,i,t)}case"edge":{const{i:t}=s;return e.translate(n,i,t,t+1)}case"area":return e.translate(n,i)}})(),{x:s,y:n}=this._mappers(),i=s.v_invert(e.xs),o=n.v_invert(e.ys);this.model.update({xs:i,ys:o}),this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t,hover_fill:e,hover_hatch:s}=this.visuals;return t.doit||e.doit||s.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const s=this._pan_state?.target??this._hit_test(t,e);if(null==s||!this._can_hit(s))return null;switch(s.type){case"node":case"edge":case"area":return"move"}}}s.PolyAnnotationView=m,o=h.auto_ranged,m.__name__="PolyAnnotationView";class f extends r.Annotation{constructor(t){super(t),this.pan=new y.Signal(this,"pan")}update({xs:t,ys:e}){this.setv({xs:t.slice(),ys:e.slice(),visible:!0})}clear(){this.setv({xs:[],ys:[],visible:!1})}}s.PolyAnnotation=f,a=f,f.__name__="PolyAnnotation",a.prototype.default_view=m,a.mixins([_.Line,_.Fill,_.Hatch,["hover_",_.Line],["hover_",_.Fill],["hover_",_.Hatch]]),a.define((({Bool:t,Float:e,Arrayable:s})=>({xs:[s(e),[]],ys:[s(e),[]],xs_units:[c.CoordinateUnits,"data"],ys_units:[c.CoordinateUnits,"data"],editable:[t,!1]}))),a.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3,hover_fill_color:null,hover_fill_alpha:.4,hover_line_color:null,hover_line_alpha:.3})},
function _(t,e,i,a,n){var o;a();const s=t(1),r=t(96),l=t(302),c=t(110),h=t(111),_=t(21),u=s.__importStar(t(21)),d=s.__importStar(t(95)),g=t(192),b=t(187),x=t(62),w=t(135),p=t(139),m=t(207),f=t(204),y=t(223),v=t(113),z=t(116),S=t(107),k=t(69),L=t(11),A=t(12),B=t(14),F=t(8),T=t(259),R=t(22),O=t(124),V=s.__importStar(t(127)),C=t(121),{round:E}=Math,M=(0,R.Or)(u.Anchor,(0,R.Tuple)((0,R.Or)(R.Float,C.Factor,_.HAlign),(0,R.Or)(R.Float,C.Factor,_.VAlign))),P=(0,R.Enum)("data","screen","view","percent"),q=(0,R.Enum)("screen","data","percent"),H=(0,R.Enum)("adaptive","exact");class N extends r.AnnotationView{constructor(){super(...arguments),this._bbox=new x.BBox}get bbox(){return this._bbox}_get_size(){const{width:t,height:e}=this.bbox,{margin:i}=this.model;return{width:t+2*i,height:e+2*i}}initialize(){super.initialize();const{ticker:t}=this.model;this.axis=new m.LinearAxis({ticker:t,...d.attrs_of(this.model,"bar_",d.Line,"axis_")}),this.range=(()=>{const{range:t,orientation:e}=this.model;if("auto"!=t)return t;{const{frame:t}=this.parent;switch(e){case"horizontal":return t.x_range;case"vertical":return t.y_range}}})()}async lazy_initialize(){await super.lazy_initialize();const t=(()=>{const t=new h.Range1d,e=new h.Range1d,i=new h.Range1d,a=new h.Range1d;return this.axis_scale=new v.LinearScale({source_range:t,target_range:e}),this.cross_scale=new v.LinearScale({source_range:i,target_range:a}),"horizontal"==this.model.orientation?new S.CoordinateTransform(this.axis_scale,this.cross_scale):new S.CoordinateTransform(this.cross_scale,this.axis_scale)})();this.axis_view=await(0,k.build_view)(this.axis,{parent:this.plot_view}),this.axis_view.coordinates=t,this.axis_view.panel=new b.SidePanel("horizontal"==this.model.orientation?"below":"right"),this.axis_view.update_layout()}remove(){this.axis_view.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this.request_paint()})),this.connect(this.range.change,(()=>{this.request_paint()}))}update_layout(){this.update_geometry();const{panel:t}=this;this.layout=null!=t?new b.SideLayout(t,(()=>this.get_size())):void 0}update_geometry(){super.update_geometry()}get horizontal(){return"horizontal"==this.model.orientation}text_layout(t){const{text:e,location:i,align:a,visuals:n}=t,{orientation:o}=this.model,s=new g.TextBox({text:e}),r=new b.SidePanel(i);s.visuals=n.values();const l=(()=>{switch(i){case"above":case"below":return"horizontal";default:return o}})();s.angle=r.get_label_angle_heuristic(l),s.base_font_size=this.plot_view.base_font_size,s.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},s.align="auto";const c=new w.TextLayout(s);c.absolute=!0;const h="horizontal"==o,_=h?a:void 0,u=h?void 0:a;return c.set_sizing({width_policy:"min",height_policy:"min",visible:""!=e&&n.doit,halign:_,valign:u}),c}compute_geometry(){super.compute_geometry();const{orientation:t,length_sizing:e,padding:i,margin:a}=this.model,{border_line:n,bar_line:o}=this.visuals,s=o.line_width.get_value(),r=n.line_width.get_value(),{frame:l}=this.parent,c="horizontal"==t?l.bbox.width:l.bbox.height,h=(()=>{const{bar_length:e,bar_length_units:i}=this.model;switch(i){case"screen":return 0<=e&&e<=1?e:(0,L.clamp)(e/c,0,1);case"data":{const i="horizontal"==t?this.coordinates.x_scale:this.coordinates.y_scale;(0,A.assert)(i instanceof v.LinearScale||i instanceof z.CategoricalScale);const[a,n]=i.r_compute(0,e);return Math.abs(n-a)/c}case"percent":return(0,L.clamp)(e,0,1)}})(),{new_value:_,new_unit:u,scale_factor:d,exact:g}=(()=>{const{unit:t,dimensional:i}=this.model,a=this.range.span*h;return i.compute(a,t,"exact"==e)})(),b=E(c*h*d),m=(()=>{const{label:t}=this.model;return(0,T.process_placeholders)(t,((t,e,i)=>{switch(e){case"value":return g?null!=i?(0,T.sprintf)(i,_):_.toFixed(2):`${_}`;case"unit":if("short"===(i??"short"))return u;default:return null}}))})();this.label_layout=this.text_layout({text:m,location:this.model.label_location,align:this.model.label_align,visuals:this.visuals.label_text}),this.title_layout=this.text_layout({text:this.model.title,location:this.model.title_location,align:this.model.title_align,visuals:this.visuals.title_text});const f="horizontal"==t?{width:b,height:s}:{width:s,height:b},y=this.axis_view.layout;(0,A.assert)(null!=y),this.axis_layout=y,y.absolute=!0,"horizontal"==t?y.set_sizing({width_policy:"fixed",width:f.width,height_policy:"min",valign:"center"}):y.set_sizing({width_policy:"min",height_policy:"fixed",height:f.height,halign:"center"}),this.box_layout=(()=>{const t={above:[],below:[],left:[],right:[]};function e(e,i,a){e.visible&&t[i].push(function(t,e){const i=new w.FixedLayout;return i.absolute=!0,i.set_sizing("left"==t||"right"==t?{width_policy:"fixed",width:e}:{height_policy:"fixed",height:e}),i}(i,a),e)}e(this.label_layout,this.model.label_location,this.model.label_standoff),e(this.title_layout,this.model.title_location,this.model.title_standoff);const i=t.above.length,a=t.left.length,n=[{layout:y,row:i,col:a}];for(const[e,o]of(0,B.enumerate)(t.above))n.push({layout:e,row:i-o-1,col:a});for(const[e,o]of(0,B.enumerate)(t.below))n.push({layout:e,row:i+o+1,col:a});for(const[e,o]of(0,B.enumerate)(t.left))n.push({layout:e,row:i,col:a-o-1});for(const[e,o]of(0,B.enumerate)(t.right))n.push({layout:e,row:i,col:a+o+1});return new p.Grid(n)})();const{box_layout:S}=this;S.absolute=!0,S.position={left:i,top:i},S.set_sizing(),S.compute();const[k,R]=(()=>{const{x_range:e,y_range:i}=this.axis_view.bbox;return"horizontal"==t?[e,i]:[i,e]})();this.axis_scale.source_range.end=_,this.axis_scale.target_range.setv(k),this.cross_scale.source_range.end=1,this.cross_scale.target_range.setv(R);const O=(()=>{const{location:t}=this.model;if((0,F.isString)(t)){const e=(()=>{switch(t){case"top":return"top_center";case"bottom":return"bottom_center";case"left":return"center_left";case"center":return"center_center";case"right":return"center_right";default:return t}})(),[i,a]=e.split("_");return{x:a,y:i}}{const[e,i]=t;return{x:e,y:i}}})(),{x:C,y:M}=(()=>{const{bbox:t}=this.layout??this.plot_view.frame,e=t.shrink_by(a),i=(()=>{const{x:i}=O;switch(i){case"left":return e.left;case"center":return e.x_center;case"right":return e.right}return(()=>{switch(this.model.x_units){case"data":return this.coordinates.x_scale;case"screen":return t.x_screen;case"view":return t.x_view;case"percent":return t.x_percent}})().compute(i)})(),n=(()=>{const{y:i}=O;switch(i){case"top":return e.top;case"center":return e.y_center;case"bottom":return e.bottom}return(()=>{switch(this.model.y_units){case"data":return this.coordinates.y_scale;case"screen":return t.y_screen;case"view":return t.y_view;case"percent":return t.y_percent}})().compute(i)})();return{x:i,y:n}})(),P=(()=>{const t=V.anchor(this.model.anchor);return{x:(()=>{if("auto"!=t.x)return t.x;switch(O.x){case"left":return 0;case"center":default:return.5;case"right":return 1}})(),y:(()=>{if("auto"!=t.y)return t.y;switch(O.y){case"top":return 0;case"center":default:return.5;case"bottom":return 1}})()}})(),q=r+i+S.bbox.width+i+r,H=r+i+S.bbox.height+i+r,N=C-P.x*q,D=M-P.y*H;this._bbox=new x.BBox({left:N,top:D,width:q,height:H})}_draw_box(t){const{width:e,height:i}=this.bbox;t.beginPath(),t.rect(0,0,e,i),this.visuals.background_fill.apply(t),this.visuals.background_hatch.apply(t),this.visuals.border_line.apply(t)}_draw_axis(t){this.axis_view.paint(t)}_draw_text(t,e,i){const{bbox:a}=e,[n,o]=(()=>{const{orientation:t}=this.model,e="horizontal"==t;switch(i){case"left":return e?[0,0]:[0,a.height];case"right":return e?[0,0]:[a.width,0];case"above":case"below":return[0,0]}})(),{left:s,top:r}=a.translate(n,o);t.translate(s,r),e.text.paint(t),t.translate(-s,-r)}_draw_label(t){this._draw_text(t,this.label_layout,this.model.label_location)}_draw_title(t){this._draw_text(t,this.title_layout,this.model.title_location)}_paint(t){const{left:e,top:i}=this.bbox;t.translate(e,i),this.box_layout.visible&&this._draw_box(t),this.axis_layout.visible&&this._draw_axis(t),this.label_layout.visible&&this._draw_label(t),this.title_layout.visible&&this._draw_title(t),t.translate(-e,-i)}}i.ScaleBarView=N,N.__name__="ScaleBarView";class D extends r.Annotation{constructor(t){super(t)}}i.ScaleBar=D,o=D,D.__name__="ScaleBar",o.prototype.default_view=N,o.mixins([["background_",d.Fill],["background_",d.Hatch],["bar_",d.Line],["border_",d.Line],["label_",d.Text],["title_",d.Text]]),o.define((({NonNegative:t,Float:e,Str:i,Ref:a,Or:n,Auto:o})=>({anchor:[O.AutoAnchor,"auto"],bar_length:[t(e),.2],bar_length_units:[q,"screen"],dimensional:[a(l.Dimensional),()=>new l.MetricLength],label:[i,"@{value} @{unit}"],label_align:[_.Align,"center"],label_location:[_.Location,"below"],label_standoff:[e,5],length_sizing:[H,"adaptive"],location:[M,"top_right"],margin:[e,10],orientation:[_.Orientation,"horizontal"],padding:[e,10],range:[n(a(c.Range),o),"auto"],ticker:[a(f.Ticker),()=>new y.FixedTicker({ticks:[]})],title:[i,""],title_align:[_.Align,"center"],title_location:[_.Location,"above"],title_standoff:[e,5],unit:[i,"m"],x_units:[P,"data"],y_units:[P,"data"]}))),o.override({background_fill_alpha:.95,background_fill_color:"#ffffff",bar_line_width:2,border_line_alpha:.5,border_line_color:"#e5e5e5",border_line_width:1,label_text_baseline:"middle",label_text_font_size:"13px",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,t,n,s,r){var i,c,a,o,l,u,_;s();const m=e(52),d=e(12),f=e(9),p=e(13),{min:h}=Math;class g extends m.Model{constructor(e){super(e)}compute(e,t,n){const s=(()=>{const{include:e,exclude:t}=this,n=(0,f.entries)(this.get_basis()).map((([e,[t,n,s]])=>({name:e,factor:t,tex_name:n,long_name:s}))).filter((({name:n})=>(null==e||e.includes(n))&&!t.includes(n)));return(0,p.sort_by)(n,(({factor:e})=>e))})(),{ticks:r}=this,i=s.find((({name:e})=>e==t));(0,d.assert)(null!=i);const c=e*i.factor,[a,o]=(()=>{const e=(0,p.bisect_right_by)(s,c,(({factor:e})=>e));if(e>0){const{name:t,factor:n}=s[e-1];return[t,c/n]}return[t,c]})();n=n??0==r.length;const l=(()=>{if(n)return o;{const e=(0,p.bisect_right)(r,o);return r[h(e,r.length-1)]}})();return{new_value:l,new_unit:a,scale_factor:l*(c/o)/e/i.factor,exact:n}}}n.Dimensional=g,i=g,g.__name__="Dimensional",i.define((({Nullable:e,List:t,Str:n,Float:s})=>({ticks:[t(s)],include:[e(t(n)),null],exclude:[t(n),[]]})));class b extends g{constructor(e){super(e)}get_basis(){return this.basis}}n.CustomDimensional=b,c=b,b.__name__="CustomDimensional",c.define((({Dict:e,Tuple:t,Float:n,Str:s,Or:r})=>({basis:[e(r(t(n,s),t(n,s,s)))]})));class x extends g{constructor(e){super(e)}get_basis(){const{base_unit:e,full_unit:t}=this,n={};for(const[s,r,i,c]of a._metric_basis){const a=`${i}${e}`,o=null!=t?`${c}${t}`:void 0;n[`${s}${e}`]=[r,a,o]}return n}}n.Metric=x,a=x,x.__name__="Metric",a.define((({Str:e,Nullable:t})=>({base_unit:[e],full_unit:[t(e),null]}))),a.override({ticks:[1,2,5,10,15,20,25,50,75,100,125,150,200,250,500,750]}),x._metric_basis=[["Q",1e30,"Q","quetta"],["R",1e27,"R","ronna"],["Y",1e24,"Y","yotta"],["Z",1e21,"Z","zetta"],["E",1e18,"E","exa"],["P",1e15,"P","peta"],["T",1e12,"T","tera"],["G",1e9,"G","giga"],["M",1e6,"M","mega"],["k",1e3,"k","kilo"],["h",100,"h","hecto"],["",1,"",""],["d",.1,"d","deci"],["c",.01,"c","centi"],["m",.001,"m","milli"],["\xb5",1e-6,"\\mu","micro"],["n",1e-9,"n","nano"],["p",1e-12,"p","pico"],["f",1e-15,"f","femto"],["a",1e-18,"a","atto"],["z",1e-21,"z","zepto"],["y",1e-24,"y","yocto"],["r",1e-27,"r","ronto"],["q",1e-30,"q","quecto"]];class M extends x{constructor(e){super(e)}get_basis(){const e=super.get_basis(),t={};for(const[n,[s,r]]of(0,f.entries)(e))t[`${n}\u207b1`]=[s**-1,`${r}^{-1}`];return t}}n.ReciprocalMetric=M,M.__name__="ReciprocalMetric";class y extends x{constructor(e){super(e)}}n.MetricLength=y,o=y,y.__name__="MetricLength",o.override({base_unit:"m",exclude:["dm","hm"]});class k extends M{constructor(e){super(e)}}n.ReciprocalMetricLength=k,l=k,k.__name__="ReciprocalMetricLength",l.override({base_unit:"m",exclude:["dm","hm"]});class v extends b{constructor(e){super(e)}}n.ImperialLength=v,u=v,v.__name__="ImperialLength",u.override({basis:{in:[1/12,"in","inch"],ft:[1,"ft","foot"],yd:[3,"yd","yard"],ch:[66,"ch","chain"],fur:[660,"fur","furlong"],mi:[5280,"mi","mile"],lea:[15840,"lea","league"]},ticks:[1,3,6,12,60]});class $ extends b{constructor(e){super(e)}}n.Angular=$,_=$,$.__name__="Angular",_.override({basis:{"\xb0":[1,"^\\circ","degree"],"'":[1/60,"^\\prime","minute"],"''":[1/3600,"^{\\prime\\prime}","second"]},ticks:[1,3,6,12,60,120,240,360]})},
function _(e,t,r,i,a){var s,o,n;i();const _=e(1),l=e(304),c=e(305),h=e(232),m=e(71),d=e(269),u=e(111),p=e(207),g=_.__importStar(e(95)),f=_.__importStar(e(40)),y=e(147),x=e(8),w=e(185),v=e(306),b=e(209),k=e(211),j=e(223),z=e(10),B=e(20),V=e(343),L=e(62),S=e(272);class R extends S.BorderLayout{constructor(){super(...arguments),this.offset_position={x:0,y:0}}set_geometry(e){const{outer:t,inner:r}=this._compute(e);this.offset_position={x:e.x,y:e.y},super.set_geometry(t,r)}}R.__name__="InternalBorderLayout";class T extends v.PlotView{initialize(){super.initialize(),this._range_manager.warn_initial_ranges=!1}_make_layout(){return new R}_after_resize(){}}T.__name__="InternalPlotView";class F extends v.Plot{constructor(e){super(e)}}s=F,F.__name__="InternalPlot",s.prototype.default_view=T;class G extends l.BaseBarView{constructor(){super(...arguments),this._last_bbox=new L.BBox,this[o]=!0}get align(){const{location:e}=this.model;if(!(0,x.isString)(e))return{v:"end",h:"start"};switch(e){case"top_left":return{v:"start",h:"start"};case"top":case"top_center":return{v:"start",h:"center"};case"top_right":return{v:"start",h:"end"};case"bottom_left":return{v:"end",h:"start"};case"bottom":case"bottom_center":return{v:"end",h:"center"};case"bottom_right":return{v:"end",h:"end"};case"left":case"center_left":return{v:"center",h:"start"};case"center":case"center_center":return{v:"center",h:"center"};case"right":case"center_right":return{v:"center",h:"end"}}}get orientation(){const{orientation:e}=this.model,{align:t}=this;return"auto"==e?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==t.h||"end"==t.h||"center"==t.v?"vertical":"horizontal":e}initialize(){super.initialize();const{orientation:e}=this;this._major_range=new u.Range1d,this._major_scale=new d.LinearScale,this._minor_range=new u.Range1d,this._minor_scale=new d.LinearScale;const t=new(0,(this.renderer??new h.GlyphRenderer({glyph:new V.Circle})).glyph.constructor)({x:{field:"x"},y:{field:"y"},radius:{field:"s",units:"screen"},...g.attrs_of(this.model,"glyph_",g.LineVector),...g.attrs_of(this.model,"glyph_",g.FillVector),...g.attrs_of(this.model,"glyph_",g.HatchVector)});this._data_source=new y.ColumnDataSource({data:{x:[],y:[],s:[]}});const r=new h.GlyphRenderer({data_source:this._data_source,glyph:t}),{ticker:i,formatter:a}=this.model;this._major_ticker="auto"!=i?i:new j.FixedTicker({ticks:[]}),this._major_formatter="auto"!=a?a:new b.BasicTickFormatter,this._major_axis=new p.LinearAxis({ticker:this._major_ticker,formatter:this._major_formatter,axis_line_color:null,major_label_standoff:this.model.label_standoff,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,...g.attrs_of(this.model,"major_label_",g.Text,!0),...g.attrs_of(this.model,"major_tick_",g.Line,!0),...g.attrs_of(this.model,"minor_tick_",g.Line,!0)});const{width:s,height:o}=this.model,n={renderers:[r],toolbar_location:null,title:new w.Title({text:this.model.title??void 0,standoff:this.model.title_standoff,...g.attrs_of(this.model,"title_",g.Text,!1)}),...g.attrs_of(this.model,"background_",g.Fill,!0),...g.attrs_of(this.model,"background_",g.Hatch,!0),...g.attrs_of(this.model,"border_",g.Line,!0),...g.attrs_of(this.model,"bar_",g.Line,"outline_")};switch(e){case"horizontal":this._size_bar=new F({width_policy:"max"==s?"max":"fit",height_policy:"max"==o?"max":"fit",frame_width:"max"==s?void 0:s,frame_height:"max"==o?void 0:o,below:[this._major_axis],x_range:this._major_range,y_range:this._minor_range,x_scale:this._major_scale,y_scale:this._minor_scale,...n});break;case"vertical":this._size_bar=new F({width_policy:"max"==o?"max":"fit",height_policy:"max"==s?"max":"fit",frame_width:"max"==o?void 0:o,frame_height:"max"==s?void 0:s,right:[this._major_axis],x_range:this._minor_range,y_range:this._major_range,x_scale:this._minor_scale,y_scale:this._major_scale,...n})}}get computed_elements(){return[...super.computed_elements,this._size_bar]}async lazy_initialize(){await super.lazy_initialize(),this._size_bar_view=this._element_views.get(this._size_bar)}update_layout(){this.layout=this._size_bar_view.layout,this.layout.on_resize((e=>{e.equals(this._last_bbox)||(this._last_bbox=e,this.parent.request_layout(!0))}))}get renderer(){const{renderer:e}=this.model;if("auto"!=e)return e;{const e=this.plot_view.model.renderers.filter((e=>e instanceof h.GlyphRenderer&&e.glyph instanceof c.RadialGlyph));switch(e.length){case 0:return B.logger.warn("can't find any radial glyph renderers"),null;case 1:return e[0];default:return B.logger.warn("found multiple radial glyph renderers; choosing the first one"),e[0]}}}get glyph_view(){const{renderer:e}=this;if(null==e)return null;return this.plot_view.views.get_one(e).glyph_view}_paint(e){const{glyph_view:t}=this;if(null==t)return;const r=(()=>{const{bounds:e}=this.model;return"auto"==e?[-1/0,1/0]:e})(),i=Math.max(f.min(t.radius),r[0]),a=Math.min(f.max(t.radius),r[1]),s=a==i,o=1e-6,n=s?Math.max(i-o,0):i,_=s?a+o:a,l=s?1:5,c=new k.AdaptiveTicker({desired_num_ticks:l}).get_ticks(0==n?_*o:n,_,new u.Range1d,NaN).major;"auto"==this.model.ticker&&this._major_ticker instanceof j.FixedTicker&&(this._major_ticker.ticks=c);const h=c,m=(0,z.repeat)(0,h.length),d=(()=>{if("data"!=t.model.properties.radius.units)return c;{const e=()=>t.sdist(t.renderer.xscale,(0,z.repeat)(0,c.length),new f.UniformVector(c)),r=()=>t.sdist(t.renderer.yscale,(0,z.repeat)(0,c.length),new f.UniformVector(c)),{radius_dimension:i}=t.model;switch(i){case"x":return e();case"y":return r();case"min":case"max":return(0,z.elementwise)(e(),r(),Math[i])}}})();this._major_range.setv({start:n,end:_}),this._minor_range.setv({start:-_,end:_}),this._data_source.data=(()=>{switch(this.orientation){case"horizontal":return{x:h,y:m,s:d};case"vertical":return{x:m,y:h,s:d}}})()}export(e="auto",t=!0){return this._size_bar_view.export(e,t)}get bbox(){const{bbox:e,offset_position:{x:t,y:r}}=this.layout;return e.translate(t,r)}}r.SizeBarView=G,o=m.exportable,G.__name__="SizeBarView";class M extends l.BaseBar{constructor(e){super(e)}}r.SizeBar=M,n=M,M.__name__="SizeBar",n.prototype.default_view=G,n.mixins([["glyph_",g.LineVector],["glyph_",g.FillVector],["glyph_",g.HatchVector]]),n.override({glyph_line_color:null}),n.define((({Ref:e,Auto:t,Or:r,Float:i,Tuple:a})=>({renderer:[r(e(h.GlyphRenderer),t),"auto"],bounds:[r(a(i,i),t),"auto"]})))},
function _(t,e,i,o,a){var _;o();const r=t(1),l=t(96),n=t(202),c=t(223),m=t(205),s=t(206),u=t(188),f=t(21),d=r.__importStar(t(95));class b extends l.AnnotationView{}i.BaseBarView=b,b.__name__="BaseBarView";class k extends l.Annotation{constructor(t){super(t)}}i.BaseBar=k,_=k,k.__name__="BaseBar",_.mixins([["title_",d.Text],["major_label_",d.Text],["major_tick_",d.Line],["minor_tick_",d.Line],["background_",d.Fill],["background_",d.Hatch],["border_",d.Line],["bar_",d.Line]]),_.define((({Float:t,Str:e,Tuple:i,Or:o,Ref:a,Enum:_,Auto:r,Nullable:l})=>({location:[o(f.Anchor,i(t,t)),"top_right"],orientation:[o(f.Orientation,r),"auto"],width:[o(t,_("max")),200],height:[o(t,_("max")),50],margin:[t,30],padding:[t,10],title:[l(o(e,a(u.BaseText))),null],title_standoff:[t,2],ticker:[o(a(c.FixedTicker),r),"auto"],formatter:[o(a(m.TickFormatter),r),"auto"],major_label_overrides:[n.LabelOverrides,new Map],major_label_policy:[a(s.LabelingPolicy),()=>new s.NoOverlap],label_standoff:[t,5],major_tick_in:[t,5],major_tick_out:[t,0],minor_tick_in:[t,0],minor_tick_out:[t,0]}))),_.override({background_fill_color:"#ffffff",background_fill_alpha:.95,border_line_color:null,bar_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"black",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(i,e,t,s,r){var a;s();const n=i(1),d=i(235),h=i(236),_=i(95),c=i(25),u=i(21),l=n.__importStar(i(19)),o=i(10);class x extends d.XYGlyphView{_index_data(i){const{x:e,y:t,radius:s,data_size:r}=this;for(let a=0;a<r;a++){const r=e[a],n=t[a],d=s.get(a);i.add_rect(r-d,n-d,r+d,n+d)}}_map_data(){this._define_or_inherit_attr("sradius",(()=>{if("data"!=this.model.properties.radius.units)return this.inherited_sradius?h.inherit:(0,c.to_screen)(this.radius);{const i=()=>this.sdist(this.renderer.xscale,this.x,this.radius),e=()=>this.sdist(this.renderer.yscale,this.y,this.radius),{radius_dimension:t}=this.model;switch(t){case"x":return this.inherited_x&&this.inherited_radius?h.inherit:i();case"y":return this.inherited_y&&this.inherited_radius?h.inherit:e();case"min":case"max":return this.inherited_x&&this.inherited_y&&this.inherited_radius?h.inherit:(0,o.elementwise)(i(),e(),Math[t])}}}))}_mask_data(){const{frame:i}=this.renderer.plot_view,e=i.x_target,t=i.y_target;let s,r;return"data"==this.model.properties.radius.units?(s=e.map((i=>this.renderer.xscale.invert(i))).widen(this.max_radius),r=t.map((i=>this.renderer.yscale.invert(i))).widen(this.max_radius)):(s=e.widen(this.max_radius).map((i=>this.renderer.xscale.invert(i))),r=t.widen(this.max_radius).map((i=>this.renderer.yscale.invert(i)))),this.index.indices({x0:s.start,x1:s.end,y0:r.start,y1:r.end})}draw_legend_for_index(i,{x0:e,y0:t,x1:s,y1:r},a){const n=a+1,d=new Array(n);d[a]=(e+s)/2;const h=new Array(n);h[a]=(t+r)/2;const _=new Array(n);_[a]=.2*Math.min(Math.abs(s-e),Math.abs(r-t)),this._paint(i,[a],{sx:d,sy:h,sradius:_})}}t.RadialGlyphView=x,x.__name__="RadialGlyphView";class m extends d.XYGlyph{constructor(i){super(i)}}t.RadialGlyph=m,a=m,m.__name__="RadialGlyph",a.mixins([_.LineVector,_.FillVector,_.HatchVector]),a.define((()=>({radius:[l.DistanceSpec],radius_dimension:[u.RadiusDimension,"x"]})))},
function _(e,t,o,r,n){var l;r();const a=e(1),i=a.__importStar(e(95)),s=a.__importStar(e(19)),_=e(16),d=e(21),c=e(10),h=e(45),u=e(8),b=e(131),m=e(202),f=e(307),g=e(96),w=e(185),p=e(113),y=e(308),v=e(133),S=e(110),x=e(108),R=e(147),A=e(98),L=e(233),T=e(232),k=e(309),D=e(118),P=e(56),E=e(328);n("PlotView",E.PlotView);class O extends b.LayoutDOM{constructor(e){super(e),this.use_map=!1,this.reset=new _.Signal0(this,"reset")}add_layout(e,t="center"){this.remove_layout(e);const o=this.properties[t].get_value();this.setv({[t]:[...o,e]})}remove_layout(e){(0,c.remove)(this.left,e),(0,c.remove)(this.right,e),(0,c.remove)(this.above,e),(0,c.remove)(this.below,e),(0,c.remove)(this.center,e)}get data_renderers(){return this.renderers.filter((e=>e instanceof L.DataRenderer))}add_renderers(...e){this.renderers=[...this.renderers,...e]}add_glyph(e,t=new R.ColumnDataSource,o={}){const r=new T.GlyphRenderer({...o,data_source:t,glyph:e});return this.add_renderers(r),r}add_tools(...e){const t=e.map((e=>e instanceof k.Tool?e:k.Tool.from_string(e)));this.toolbar.tools=[...this.toolbar.tools,...t]}remove_tools(...e){this.toolbar.tools=[...(0,h.difference)(new Set(this.toolbar.tools),new Set(e))]}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:o,right:r}=this;return(0,c.concat)([e,t,o,r])}}o.Plot=O,l=O,O.__name__="Plot",l.prototype.default_view=E.PlotView,l.mixins([["outline_",i.Line],["background_",i.Fill],["background_",i.Hatch],["border_",i.Line],["border_",i.Fill],["border_",i.Hatch]]),l.define((({Bool:e,Float:t,Str:o,List:r,Dict:n,Or:l,Ref:a,Null:i,Nullable:_,Struct:c,Opt:h})=>({toolbar:[a(y.Toolbar),()=>new y.Toolbar],toolbar_location:[_(d.Location),"right"],toolbar_sticky:[e,!0],toolbar_inner:[e,!1],frame_width:[_(t),null],frame_height:[_(t),null],frame_align:[l(e,c({left:h(e),right:h(e),top:h(e),bottom:h(e)})),!0],title:[l(a(w.Title),o,i),"",{convert:e=>(0,u.isString)(e)?new w.Title({text:e}):e}],title_location:[_(d.Location),"above"],above:[r(l(a(g.Annotation),a(m.Axis),a(P.StyledElement))),[]],below:[r(l(a(g.Annotation),a(m.Axis),a(P.StyledElement))),[]],left:[r(l(a(g.Annotation),a(m.Axis),a(P.StyledElement))),[]],right:[r(l(a(g.Annotation),a(m.Axis),a(P.StyledElement))),[]],center:[r(l(a(g.Annotation),a(f.Grid),a(P.StyledElement))),[]],renderers:[r(a(A.Renderer)),[]],x_range:[a(S.Range),()=>new D.DataRange1d],y_range:[a(S.Range),()=>new D.DataRange1d],x_scale:[a(x.Scale),()=>new p.LinearScale],y_scale:[a(x.Scale),()=>new p.LinearScale],extra_x_ranges:[n(a(S.Range)),{}],extra_y_ranges:[n(a(S.Range)),{}],extra_x_scales:[n(a(x.Scale)),{}],extra_y_scales:[n(a(x.Scale)),{}],window_axis:[d.WindowAxis,"none"],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[_(t),2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[d.OutputBackend,"canvas"],min_border:[_(t),5],min_border_top:[_(t),null],min_border_left:[_(t),null],min_border_bottom:[_(t),null],min_border_right:[_(t),null],inner_width:[t,s.unset,{readonly:!0}],inner_height:[t,s.unset,{readonly:!0}],outer_width:[t,s.unset,{readonly:!0}],outer_height:[t,s.unset,{readonly:!0}],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[d.ResetPolicy,"standard"],hold_render:[e,!1],attribution:[r(l(o,a(v.HTML))),[]]}))),l.override({width:600,height:600,outline_line_color:"#e5e5e5",border_line_color:null,border_fill_color:"#ffffff",background_fill_color:"#ffffff",context_menu:"auto"})},
function _(i,e,s,n,t){var r;n();const o=i(1),a=i(278),d=i(203),_=i(204),l=o.__importStar(i(95)),h=i(8);class u extends d.GuideRendererView{_paint(i){i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_paint()))}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;const[e,s]=this.grid_coords("major",!1);for(let n=0;n<e.length-1;n++){if(n%2!=1)continue;const[t,r]=this.coordinates.map_to_screen(e[n],s[n]),[o,a]=this.coordinates.map_to_screen(e[n+1],s[n+1]);i.beginPath(),i.rect(t[0],r[0],o[1]-t[0],a[1]-r[0]),this.visuals.band_fill.apply(i),this.visuals.band_hatch.apply(i)}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,s]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,s)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,s]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,s)}_draw_grid_helper(i,e,s,n){e.set_value(i),i.beginPath();for(let e=0;e<s.length;e++){const[t,r]=this.coordinates.map_to_screen(s[e],n[e]);i.moveTo(Math.round(t[0]),Math.round(r[0]));for(let e=1;e<t.length;e++)i.lineTo(Math.round(t[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=1-i,{ranges:s}=this.coordinates;return[s[i],s[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,s=[i.min,i.max];let n,t;if((0,h.isArray)(e))n=Math.min(e[0],e[1]),t=Math.max(e[0],e[1]),n<s[0]&&(n=s[0]),t>s[1]&&(t=s[1]);else{[n,t]=s;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([n,t]=i.computed_bounds)}return[n,t]}grid_coords(i,e=!0){const s=this.model.dimension,n=1-s,[t,r]=this.ranges(),[o,a]=(()=>{const[i,e]=this.computed_bounds();return[Math.min(i,e),Math.max(i,e)]})(),d=[[],[]],_=this.model.get_ticker();if(null==_)return d;const l=_.get_ticks(o,a,t,r.min)[i],h=t.min,u=t.max,[c,m]=(()=>{const{cross_bounds:i}=this.model;return"auto"==i?[r.min,r.max]:i})();e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=u&&l.push(u));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==u)&&e)continue;const t=[],r=[],o=2;for(let e=0;e<o;e++){const s=c+(m-c)/(o-1)*e;t.push(l[i]),r.push(s)}d[s].push(t),d[n].push(r)}return d}}s.GridView=u,u.__name__="GridView";class c extends d.GuideRenderer{constructor(i){super(i)}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}s.Grid=c,r=c,c.__name__="Grid",r.prototype.default_view=u,r.mixins([["grid_",l.Line],["minor_grid_",l.Line],["band_",l.Fill],["band_",l.Hatch]]),r.define((({Float:i,Auto:e,Enum:s,Ref:n,Tuple:t,Or:r,Nullable:o})=>({bounds:[r(t(i,i),e),"auto"],cross_bounds:[r(t(i,i),e),"auto"],dimension:[s(0,1),0],axis:[o(n(a.Axis)),null],ticker:[o(n(_.Ticker)),null]}))),r.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},
function _(t,e,o,s,i){var l;s();const n=t(1),r=t(20),a=t(61),c=t(69),_=t(55),h=t(21),u=t(10),v=t(14),p=t(9),f=t(8),d=t(309),g=t(313),m=t(314),b=t(315),w=t(320),y=t(322),T=t(323),x=t(325),z=t(310),L=t(317),I=t(16),P=t(3),k=n.__importStar(t(326)),$=k,C=n.__importStar(t(327)),A=C,S=n.__importDefault(t(76));class B extends _.UIElementView{constructor(){super(...arguments),this._tool_button_views=new Map,this._items=[],this._visible=null,this._our_proxies=[]}get tool_buttons(){return this._tool_buttons.flat()}get tool_button_views(){return this.tool_buttons.map((t=>this._tool_button_views.get(t))).filter((t=>null!=t))}get overflow_el(){return this._overflow_el}get visible(){return!!this.model.visible&&(!this.model.autohide||(this._visible??!1))}*children(){yield*super.children(),yield*this._tool_button_views.values()}has_finished(){if(!super.has_finished())return!1;for(const t of this._tool_button_views.values())if(!t.has_finished())return!1;return!0}initialize(){super.initialize();const{location:t}=this.model,e="left"==t||"above"==t,o=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new L.ContextMenu([],{target:this.el,orientation:o,reversed:e,prevent_hide:t=>t.composedPath().includes(this._overflow_el)})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals();const{buttons:t,tools:e,location:o,autohide:s,group:i,group_types:l}=this.model.properties;this.on_change([t,e,i,l],(async()=>{await this._build_tool_button_views(),this.rerender()})),this.on_change(o,(()=>{this.rerender()})),this.on_change(s,(()=>{this._on_visible_change()})),this.on_transitive_change(e,(()=>{this.rerender()}),{signal:t=>t.properties.visible.change})}stylesheets(){return[...super.stylesheets(),k.default,C.default,S.default]}remove(){(0,c.remove_views)(this._tool_button_views),this._destroy_proxies(),super.remove()}_destroy_proxies(){for(const t of this._our_proxies)t.destroy();(0,u.clear)(this._our_proxies)}_group_tools(t){const{group_types:e}=this.model,o=new Map;for(const[s,i]of(0,v.enumerate)(t)){if(null!=e.find((t=>d.Tool.is_alias_of(s,t)))&&!1!==s.group){const t=!0===s.group?s.type:`${s.type}_${s.group}`,e=o.get(t);null!=e?e.push(s):o.set(t,[s])}else o.set(`${i}`,[s])}return Array.from(o.values(),(t=>{if(t.length>1){const e=new m.ToolGroup({tools:t});return this._our_proxies.push(e),e}return t[0]}))}async _build_tool_button_views(){this._destroy_proxies(),this._tool_buttons=(()=>{const{buttons:t}=this.model;if("auto"==t){const t=[...(0,p.values)(this.model.gestures).map((t=>t.tools)),this.model.actions,this.model.inspectors,this.model.auxiliaries],{group:e}=this.model;return t.map((t=>(e?this._group_tools(t):t).map((t=>t.tool_button()))))}return(0,u.split)(t,null)})(),await(0,c.build_views)(this._tool_button_views,this._tool_buttons.flat(),{parent:this})}set_visibility(t){t!=this._visible&&(this._visible=t,this._on_visible_change())}_on_visible_change(){this.el.classList.toggle($.hidden,!this.visible)}_after_resize(){super._after_resize(),this._after_render()}_menu_at(){switch(this.model.location){case"right":return{left_of:this._overflow_el};case"left":return{right_of:this._overflow_el};case"above":return{below:this._overflow_el};case"below":return{above:this._overflow_el}}}toggle_menu(){this._overflow_menu.toggle(this._menu_at())}render(){super.render(),this.el.classList.add($[this.model.location]),this.el.classList.toggle($.inner,this.model.inner),this._on_visible_change();const{horizontal:t}=this.model;if(this._overflow_el=(0,a.div)({class:$.tool_overflow,tabIndex:0},t?"\u22ee":"\u22ef"),this._overflow_el.addEventListener("click",(t=>{this.toggle_menu()})),this._overflow_el.addEventListener("keydown",(t=>{"Enter"==t.key&&this.toggle_menu()})),this._items=[],null!=this.model.logo){const t="grey"===this.model.logo?A.grey:null,e=(0,a.a)({href:"https://bokeh.org/",target:"_blank",class:[A.logo,A.logo_small,t],title:`Bokeh ${P.version}`});this._items.push(e),this.shadow_el.appendChild(e)}for(const[,t]of this._tool_button_views)t.render();const e=this._tool_buttons.map((t=>t.filter((t=>t.tool.visible)).map((t=>this._tool_button_views.get(t))).filter((t=>null!=t)).map((t=>t.el)))).filter((t=>0!=t.length)),o=()=>(0,a.div)({class:$.divider});for(const t of(0,v.join)(e,o))this._items.push(t);this.shadow_el.append(...this._items)}_after_render(){super._after_render(),(0,u.clear)(this._overflow_menu.items),this.shadow_el.contains(this._overflow_el)&&this.shadow_el.removeChild(this._overflow_el);for(const t of this._items)this.shadow_el.contains(t)||this.shadow_el.append(t);const{horizontal:t}=this.model,{bbox:e}=this,o=t?$.right:$.above;let s=0,i=!1;for(const l of this._items)if(i)this.shadow_el.removeChild(l),this._overflow_menu.items.push({custom:l,class:o});else{const{width:n,height:r}=l.getBoundingClientRect();s+=t?n:r,i=t?s>e.width-15:s>e.height-15,i&&(this.shadow_el.removeChild(l),this.shadow_el.appendChild(this._overflow_el),this._overflow_menu.items.push({custom:l,class:o}))}this._overflow_menu.is_open&&this._overflow_menu.show(this._menu_at());for(const t of this.tool_button_views)t.update_bbox()}toggle_auto_scroll(t){if("auto"==this.model.active_scroll)for(const e of this.model.tools)if(e.event_types.includes("scroll")){e.active=t??!e.active;break}}}o.ToolbarView=B,B.__name__="ToolbarView";const E=t(22),R=(0,E.Or)((0,E.Ref)(w.GestureTool),(0,E.Ref)(g.ToolProxy)),M=(0,E.Struct)({tools:(0,E.List)(R),active:(0,E.Nullable)(R)}),N=(0,E.Struct)({pan:M,scroll:M,pinch:M,rotate:M,move:M,tap:M,doubletap:M,press:M,pressup:M,multi:M});function G(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},multi:{tools:[],active:null}}}o.Inspection=d.Tool;class O extends _.UIElement{constructor(t){super(t)}get horizontal(){return"above"==this.location||"below"==this.location}get vertical(){return"left"==this.location||"right"==this.location}connect_signals(){super.connect_signals();const{tools:t,active_drag:e,active_inspect:o,active_scroll:s,active_tap:i,active_multi:l}=this.properties;this.on_change([t,e,o,s,i,l],(()=>{this._init_tools(),this._activate_tools()}))}initialize(){super.initialize(),this.active_changed=new I.Signal0(this,"active_changed"),this._init_tools(),this._activate_tools()}_init_tools(){const t=new Set;function e(e,o){const s=e.underlying instanceof o;return s&&t.add(e),s}const o=this.tools.filter((t=>e(t,y.InspectTool)));this.inspectors=o;const s=this.tools.filter((t=>e(t,x.HelpTool)));this.help=s;const i=this.tools.filter((t=>e(t,T.ActionTool)));this.actions=i;const l={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)e(t,w.GestureTool)&&l[t.event_role].tools.push(t);for(const t of(0,p.typed_keys)(l)){const e=this.gestures[t];e.tools=(0,u.sort_by)(l[t].tools,(t=>t.default_order)),null!=e.active&&(0,u.every)(e.tools,(t=>t.id!=e.active?.id))&&(e.active=null)}const n=this.tools.filter((e=>!t.has(e)));this.auxiliaries=n}_activate_tools(){if("auto"==this.active_inspect);else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;else if((0,f.isArray)(this.active_inspect)){const t=(0,u.intersection)(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)(0,u.includes)(this.active_inspect,t)||(t.active=!1)}else{let t=!1;for(const e of this.inspectors)e!=this.active_inspect?e.active=!1:t=!0;t||(this.active_inspect=null)}const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of(0,p.values)(this.gestures))for(const e of t.tools)this.connect(e.properties.active.change,(()=>{this._active_change(e),this.active_changed.emit()}));function e(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi";default:return null}}function o(t,e){return"tap"==t||"pan"==t||e.supports_auto()}const s=t=>this.tools.includes(t)||t instanceof d.Tool&&this.tools.some((e=>e instanceof g.ToolProxy&&e.tools.includes(t)));for(const[i,l]of(0,p.entries)(this.gestures)){const n=i,r=e(n);if(null!=r){const e=this[r];if("auto"==e){if(0!=l.tools.length){const[e]=l.tools;o(n,e)&&t(e)}}else if(null!=e)s(e)?t(e):this[r]=null;else{this.gestures[n].active=null;for(const t of this.gestures[n].tools)t.active=!1}}}this.active_changed.emit()}_active_change(t){const{event_types:e}=t;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(r.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,r.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}to_menu(){const t=[...(0,p.values)(this.gestures).map((t=>t.tools)),this.actions,this.inspectors,this.auxiliaries].filter((t=>0!=t.length)).map((t=>t.map((t=>t.menu_item())))),e=[...(0,v.join)(t,(()=>new z.DividerItem))];return new z.Menu({items:e})}}o.Toolbar=O,l=O,O.__name__="Toolbar",l.prototype.default_view=B,l.define((({Bool:t,List:e,Or:s,Ref:i,Nullable:l,Auto:n})=>({tools:[e(s(i(d.Tool),i(g.ToolProxy))),[]],logo:[l(h.Logo),"normal"],autohide:[t,!1],group:[t,!0],group_types:[e(h.ToolName),["hover"]],active_drag:[l(s(R,n)),"auto"],active_inspect:[l(s(i(o.Inspection),e(i(o.Inspection)),i(g.ToolProxy),n)),"auto"],active_scroll:[l(s(R,n)),"auto"],active_tap:[l(s(R,n)),"auto"],active_multi:[l(s(R,n)),"auto"]}))),l.internal((({List:t,Bool:e,Ref:o,Or:s,Null:i,Auto:l})=>({buttons:[s(t(s(o(b.ToolButton),i)),l),"auto"],location:[h.Location,"right"],inner:[e,!1],gestures:[N,G],actions:[t(s(o(T.ActionTool),o(g.ToolProxy))),[]],inspectors:[t(s(o(y.InspectTool),o(g.ToolProxy))),[]],auxiliaries:[t(s(o(d.Tool),o(g.ToolProxy))),[]],help:[t(s(o(x.HelpTool),o(g.ToolProxy))),[]]})))},
function _(t,e,n,i,o){var s;i();const r=t(65),a=t(10),l=t(9),c=t(8),u=t(27),_=t(52),h=t(310),p=t(124);class d extends r.View{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>{this.model.active?this.activate():this.deactivate()}))}get overlays(){return[]}activate(){}deactivate(){}}n.ToolView=d,d.__name__="ToolView";class m extends _.Model{constructor(t){super(t)}get event_role(){const{event_type:t}=this;return(0,c.isString)(t)?t:"multi"}get event_types(){const{event_type:t}=this;return null==t?[]:(0,c.isString)(t)?[t]:t}menu_item(){const t=new h.MenuItem({icon:this.computed_icon,label:this.tool_name,tooltip:this.tooltip!=this.tool_name?this.tooltip:void 0,checked:()=>this.active,disabled:()=>this.disabled,action:()=>this.active=!this.active}),e=this.menu;return null!=e&&(t.menu=new h.Menu({items:e})),t}get tooltip(){return this.description??this.tool_name}get computed_icon(){const{icon:t,tool_icon:e}=this;return t??(null!=e?`.${e}`:void 0)}get menu(){return null}supports_auto(){return!1}_get_dim_limits([t,e],[n,i],o,s){const r=o.bbox.h_range;let l;"width"==s||"both"==s?(l=[(0,a.min)([t,n]),(0,a.max)([t,n])],l=[(0,a.max)([l[0],r.start]),(0,a.min)([l[1],r.end])]):l=[r.start,r.end];const c=o.bbox.v_range;let u;return"height"==s||"both"==s?(u=[(0,a.min)([e,i]),(0,a.max)([e,i])],u=[(0,a.max)([u[0],c.start]),(0,a.min)([u[1],c.end])]):u=[c.start,c.end],[l,u]}_get_dim_tooltip(t){const{description:e,tool_name:n}=this;return null!=e?e:"both"==t?n:"auto"==t?`${n} (either x, y or both dimensions)`:`${n} (${"width"==t?"x":"y"}-axis)`}static register_alias(t,e){const n=e(),i=n.dirty_attributes,o=new u.Comparator;this.prototype._known_aliases.set(t,{fn:e,query:t=>{if(!(t instanceof n.constructor))return!1;for(const[e,n]of(0,l.entries)(i))if(!o.eq(n,t.property(e).get_value()))return!1;return!0}})}static is_alias_of(t,e){const n=this.prototype._known_aliases.get(e);return n?.query(t.underlying)??!1}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e.fn();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}get underlying(){return this}}n.Tool=m,s=m,m.__name__="Tool",s.prototype._known_aliases=new Map,s.define((({Bool:t,Or:e,Str:n,Nullable:i})=>({icon:[i(p.IconLike),null],description:[i(n),null],visible:[t,!0],group:[e(n,t),!0]}))),s.internal((({Bool:t})=>({active:[t,!1],disabled:[t,!1]})))},
function _(e,t,m,n,I){n();var i=e(122);I("Menu",i.Menu),I("MenuItemLike",i.MenuItemLike),I("MenuItem",e(123).MenuItem),I("ActionItem",e(311).ActionItem),I("CheckableItem",e(312).CheckableItem),I("DividerItem",e(126).DividerItem)},
function _(t,n,e,c,o){c();const s=t(123);class _ extends s.MenuItem{constructor(t){super(t)}}e.ActionItem=_,_.__name__="ActionItem"},
function _(e,t,c,n,s){n();const _=e(123);class a extends _.MenuItem{constructor(e){super(e)}}c.CheckableItem=a,a.__name__="CheckableItem"},
function _(t,o,e,s,n){var i;s();const l=t(16),r=t(52),c=t(310),u=t(309),a=t(14),h=t(51);class _ extends r.Model{constructor(t){super(t)}get underlying(){const t=this.tools[0];return t instanceof i?t.underlying:t}tool_button(){const t=this.tools[0].tool_button();return t.tool=this,t}menu_item(){return this.tools[0].menu_item()}get event_type(){return this.tools[0].event_type}get event_role(){return this.tools[0].event_role}get event_types(){return this.tools[0].event_types}get default_order(){return this.tools[0].default_order}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get computed_icon(){return this.tools[0].computed_icon}get toggleable(){const t=this.tools[0];return"toggleable"in t&&t.toggleable}get group(){return this.tools[0].group}initialize(){super.initialize(),this.do=new l.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,(()=>this.doit())),this.connect(this.properties.active.change,(()=>this.set_active()));for(const t of this.tools)this.connect(t.properties.active.change,(()=>{this.active=t.active}))}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,s]of(0,a.enumerate)(t))if(null==e)o.push(null);else{const t=()=>{for(const t of this.tools){const{menu:o}=t;if(null==o)continue;const e=o[s];e instanceof c.MenuItem&&null!=e.action&&(0,h.execute)(e.action,new c.Menu,{item:e})}};o.push(e.clone({action:t}))}return o}supports_auto(){return this.tools[0].supports_auto()}}e.ToolProxy=_,i=_,_.__name__="ToolProxy",i.define((({Bool:t,List:o,Ref:e,Or:s})=>({tools:[o(s(e(u.Tool),e(i))),[]],visible:[t,t=>(0,a.some)(t.tools,(t=>t.visible))],active:[t,t=>(0,a.some)(t.tools,(t=>t.active))],disabled:[t,!1]})))},
function _(o,t,n,r,s){var e;r();const l=o(313);class u extends l.ToolProxy{constructor(o){super(o)}get tooltip(){return this.tools.map((o=>o.tooltip)).join("\n")}}n.ToolGroup=u,e=u,u.__name__="ToolGroup",e.define((({Bool:o})=>({show_count:[o,!1]})))},
function _(e,t,s,o,i){var n;o();const l=e(1),a=e(55),r=e(124),h=e(127),c=e(309),d=e(313),u=e(314),_=e(316),p=e(61),m=e(317),g=e(10),v=l.__importStar(e(319)),f=v,w=l.__importDefault(e(76));class b extends a.UIElementView{initialize(){super.initialize();const{location:e}=this.parent.model,t="left"==e||"above"==e,s=this.parent.model.horizontal?"vertical":"horizontal",o=this.model.tool.menu??[];this._menu=new m.ContextMenu(t?(0,g.reversed)(o):o,{target:this.parent.el,orientation:s,prevent_hide:e=>e.composedPath().includes(this.el),labels:!1}),this._ui_gestures=new _.UIGestures(this.el,{on_tap:e=>{this._menu.is_open?this._menu.hide():e.native.composedPath().includes(this.el)&&this.tap()},on_press:()=>{this.press()}}),this.el.addEventListener("keydown",(e=>{switch(e.key){case"Enter":this.tap();break;case" ":this.press()}}))}connect_signals(){super.connect_signals(),this._ui_gestures.connect_signals(),this.connect(this.model.change,(()=>this.render())),this.connect(this.model.tool.change,(()=>this.render()))}remove(){this._ui_gestures.remove(),this._menu.remove(),super.remove()}stylesheets(){return[...super.stylesheets(),v.default,w.default]}render(){super.render();const{tool:e}=this.model;this.class_list.add(f[this.parent.model.location]),this.class_list.toggle(f.hidden,!e.visible),this.class_list.toggle(f.disabled,e.disabled);const t=(0,p.div)({class:f.tool_icon});this.shadow_el.append(t);const s=this.model.icon??e.computed_icon;if(null!=s&&(0,h.apply_icon)(t,s),null!=e.menu){const e=(0,p.div)({class:f.tool_chevron});this.shadow_el.append(e)}if(e instanceof u.ToolGroup&&e.show_count){const t=(0,p.div)({class:f.count},`${e.tools.length}`);this.shadow_el.append(t)}const o=this.model.tooltip??e.tooltip;this.el.title=o,this.el.tabIndex=0}press(){const e=(()=>{switch(this.parent.model.location){case"right":return{left_of:this.el};case"left":return{right_of:this.el};case"above":return{below:this.el};case"below":return{above:this.el}}})();this._menu.toggle(e)}}s.ToolButtonView=b,b.__name__="ToolButtonView";class T extends a.UIElement{constructor(e){super(e)}}s.ToolButton=T,n=T,T.__name__="ToolButton",n.define((({Str:e,Ref:t,Nullable:s,Or:o})=>({tool:[o(t(c.Tool),t(d.ToolProxy))],icon:[s(r.IconLike),null],tooltip:[s(e),null]})))},
function _(t,s,e,i,n){i();const a=t(61),_=t(12);class r{constructor(t,s,e={}){this.phase="idle",this.pointers=new Map,this.press_timer=null,this.tap_timestamp=-1/0,this.last_scale=null,this.last_rotation=null,this.hit_area=t,this.handlers=s,this.must_be_target=e.must_be_target??!1,this._pointer_over=this._pointer_over.bind(this),this._pointer_out=this._pointer_out.bind(this),this._pointer_down=this._pointer_down.bind(this),this._pointer_move=this._pointer_move.bind(this),this._pointer_up=this._pointer_up.bind(this),this._pointer_cancel=this._pointer_cancel.bind(this)}connect_signals(){this.hit_area.addEventListener("pointerover",this._pointer_over),this.hit_area.addEventListener("pointerout",this._pointer_out),this.hit_area.addEventListener("pointerdown",this._pointer_down),this.hit_area.addEventListener("pointermove",this._pointer_move),this.hit_area.addEventListener("pointerup",this._pointer_up),this.hit_area.addEventListener("pointercancel",this._pointer_cancel)}disconnect_signals(){this.hit_area.removeEventListener("pointerover",this._pointer_over),this.hit_area.removeEventListener("pointerout",this._pointer_out),this.hit_area.removeEventListener("pointerdown",this._pointer_down),this.hit_area.removeEventListener("pointermove",this._pointer_move),this.hit_area.removeEventListener("pointerup",this._pointer_up),this.hit_area.removeEventListener("pointercancel",this._pointer_cancel)}remove(){this.disconnect_signals()}_self_is_target(t){return t.composedPath()[0]==this.hit_area}_is_event_target(t){return!this.must_be_target||this._self_is_target(t)}reset(){this._cancel_timeout(),this._user_select(!0),this.phase="idle",this.pointers.clear(),this.press_timer=null,this.tap_timestamp=-1/0,this.last_scale=null,this.last_rotation=null}_user_select(t){this.hit_area.style.userSelect=t?"":"none"}get _is_multi_gesture(){return this.pointers.size>=2}_within_threshold(t){const{dx:s,dy:e}=this._movement(t);return s**2+e**2<=r.move_threshold**2}get _any_movement(){return[...this.pointers.values()].some((t=>!this._within_threshold(t)))}_start_timeout(){(0,_.assert)(null==this.press_timer),this.press_timer=setTimeout((()=>this._pointer_timeout()),r.press_threshold)}_cancel_timeout(){const{press_timer:t}=this;null!=t&&(clearTimeout(t),this.press_timer=null)}_pointer_timeout(){(0,_.assert)("started"==this.phase),(0,_.assert)(!this._is_multi_gesture),this.phase="pressing",this.press_timer=null;const[t]=this.pointers.values();this.on_press(t.init)}_pointer_over(t){this._is_event_target(t)&&t.isPrimary&&this.on_enter(t)}_pointer_out(t){this._is_event_target(t)&&t.isPrimary&&this.on_leave(t)}_pointer_down(t){if(this._is_event_target(t)&&!this._is_multi_gesture&&!this.pointers.has(t.pointerId)&&(!t.isPrimary||"mouse"!=t.pointerType||t.buttons==a.MouseButton.Left)&&this.hit_area.isConnected)switch(this.pointers.set(t.pointerId,{init:t,last:t}),this.hit_area.setPointerCapture(t.pointerId),this._user_select(!1),this.phase){case"idle":this.phase="started",this._start_timeout();break;case"started":this._cancel_timeout()}}_pointer_move(t){if(!this._is_event_target(t))return;t.isPrimary&&this.on_move(t);const s=this.pointers.get(t.pointerId);if(null!=s)switch(s.last=t,this.phase){case"idle":this.reset(),(0,_.unreachable)();case"started":case"transitional":if(!this._any_movement)return;if(this._cancel_timeout(),this._is_multi_gesture){const[t,s]=this.pointers.values(),e=this._scale(t,s),i=this._rotation(t,s);Math.abs(e-1)>r.pinch_threshold?(this.phase="pinching",this.on_pinch_start(t.init,s.init,1),this.on_pinch(t.last,s.last,e),this.last_scale=e):Math.abs(i)>r.rotate_threshold&&(this.phase="rotating",this.on_rotate_start(t.init,s.init,0),this.on_rotate(s.last,s.last,i),this.last_rotation=i)}else{this.phase="panning";const[t]=this.pointers.values(),{dx:s,dy:e}=this._movement(t);this.on_pan_start(t.init,0,0),this.on_pan(t.last,s,e)}break;case"pressing":break;case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan(t,e,i);break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);e!=this.last_scale&&(this.on_pinch(t.last,s.last,e),this.last_scale=e);break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);e!=this.last_rotation&&(this.on_rotate(t.last,s.last,e),this.last_rotation=e);break}}}_pointer_up(t){if(!this._is_event_target(t))return;const s=this.pointers.get(t.pointerId);if(null!=s){switch(s.last=t,this._cancel_timeout(),this.phase){case"idle":this.reset(),(0,_.unreachable)();case"started":{const[t]=this.pointers.values(),{tap_timestamp:s}=this;t.last.timeStamp-s<r.doubletap_threshold?(this.tap_timestamp=-1/0,this.on_doubletap(t.last)):(this.tap_timestamp=t.last.timeStamp,this.on_tap(t.last)),this.phase="idle";break}case"transitional":this.phase="idle";break;case"pressing":{const[t]=this.pointers.values();this.on_pressup(t.last),this.phase="idle";break}case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan_end(t,e,i),this.phase="idle";break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);this.on_pinch_end(t.last,s.last,e),this.phase="transitional",this.last_scale=null;break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);this.on_rotate_end(t.last,s.last,e),this.phase="transitional",this.last_rotation=null;break}}if(this.pointers.delete(t.pointerId),"transitional"==this.phase){const[t]=this.pointers.values();t.init=t.last}0==this.pointers.size&&this._user_select(!0)}}_pointer_cancel(t){if(this.pointers.has(t.pointerId)){switch(this._cancel_timeout(),this.phase){case"idle":this.reset(),(0,_.unreachable)();case"started":case"pressing":case"transitional":this.phase="idle";break;case"panning":{const[s]=this.pointers.values(),{dx:e,dy:i}=this._movement(s);this.on_pan_end(t,e,i),this.phase="idle";break}case"pinching":{const[t,s]=this.pointers.values(),e=this._scale(t,s);this.on_pinch_end(t.last,s.last,e),this.phase="transitional",this.last_scale=null;break}case"rotating":{const[t,s]=this.pointers.values(),e=this._rotation(t,s);this.on_rotate_end(t.last,s.last,e),this.phase="transitional",this.last_rotation=null;break}}if(this.pointers.delete(t.pointerId),"transitional"==this.phase){const[t]=this.pointers.values();t.init=t.last}0==this.pointers.size&&this._user_select(!0)}}on_tap(t){const{on_tap:s}=this.handlers;null!=s&&s(this._tap_event("tap",t))}on_doubletap(t){const{on_doubletap:s}=this.handlers;null!=s&&s(this._tap_event("double_tap",t))}on_press(t){const{on_press:s}=this.handlers;null!=s&&s(this._tap_event("press",t))}on_pressup(t){const{on_pressup:s}=this.handlers;null!=s&&s(this._tap_event("press_up",t))}on_enter(t){const{on_enter:s}=this.handlers;null!=s&&s(this._move_event("enter",t))}on_move(t){const{on_move:s}=this.handlers;null!=s&&s(this._move_event("move",t))}on_leave(t){const{on_leave:s}=this.handlers;null!=s&&s(this._move_event("leave",t))}on_pan_start(t,s,e){const{on_pan_start:i}=this.handlers;null!=i&&i(this._pan_event("pan_start",t,s,e))}on_pan(t,s,e){const{on_pan:i}=this.handlers;null!=i&&i(this._pan_event("pan",t,s,e))}on_pan_end(t,s,e){const{on_pan_end:i}=this.handlers;null!=i&&i(this._pan_event("pan_end",t,s,e))}on_pinch_start(t,s,e){const{on_pinch_start:i}=this.handlers;null!=i&&i(this._pinch_event("pinch_start",t,s,e))}on_pinch(t,s,e){const{on_pinch:i}=this.handlers;null!=i&&i(this._pinch_event("pinch",t,s,e))}on_pinch_end(t,s,e){const{on_pinch_end:i}=this.handlers;null!=i&&i(this._pinch_event("pinch_end",t,s,e))}on_rotate_start(t,s,e){const{on_rotate_start:i}=this.handlers;null!=i&&i(this._rotate_event("rotate_start",t,s,e))}on_rotate(t,s,e){const{on_rotate:i}=this.handlers;null!=i&&i(this._rotate_event("rotate",t,s,e))}on_rotate_end(t,s,e){const{on_rotate_end:i}=this.handlers;null!=i&&i(this._rotate_event("rotate_end",t,s,e))}_get_sxy(t){const{pageX:s,pageY:e}=t,{left:i,top:n}=(0,a.offset_bbox)(this.hit_area);return{sx:s-i,sy:e-n}}_get_modifiers(t){return{shift:t.shiftKey,ctrl:t.ctrlKey,alt:t.altKey}}_tap_event(t,s){return{type:t,...this._get_sxy(s),modifiers:this._get_modifiers(s),native:s}}_move_event(t,s){return{type:t,...this._get_sxy(s),modifiers:this._get_modifiers(s),native:s}}_pan_event(t,s,e,i){return{type:t,...this._get_sxy(s),dx:e,dy:i,modifiers:this._get_modifiers(s),native:s}}_pinch_event(t,s,e,i){const{sx:n,sy:a}=this._get_sxy(s),{sx:_,sy:r}=this._get_sxy(e);return{type:t,sx:(n+_)/2,sy:(a+r)/2,scale:i,modifiers:this._get_modifiers(s),native:s}}_rotate_event(t,s,e,i){const{sx:n,sy:a}=this._get_sxy(s),{sx:_,sy:r}=this._get_sxy(e);return{type:t,sx:(n+_)/2,sy:(a+r)/2,rotation:i,modifiers:this._get_modifiers(s),native:s}}_movement(t){return{dx:t.last.x-t.init.x,dy:t.last.y-t.init.y}}_distance(t,s){const e=s.x-t.x,i=s.y-t.y;return Math.sqrt(e**2+i**2)}_angle(t,s){const e=s.x-t.x,i=s.y-t.y;return 180*Math.atan2(i,e)/Math.PI}_scale(t,s){return this._distance(t.last,s.last)/this._distance(t.init,s.init)}_rotation(t,s){return this._angle(s.last,t.last)+this._angle(s.init,t.init)}}e.UIGestures=r,r.__name__="UIGestures",r.move_threshold=5,r.press_threshold=300,r.doubletap_threshold=300,r.pinch_threshold=0,r.rotate_threshold=0},
function _(t,e,i,s,n){s();const o=t(1),l=t(61),h=t(10),r=t(8),a=t(51),d=o.__importStar(t(318)),c=d,_=o.__importDefault(t(76)),u=o.__importDefault(t(70)),p=t(310),m=t(127);class f{get is_open(){return this._open}get can_open(){return 0!=this.items.length}constructor(t,e){this.el=(0,l.div)(),this._open=!1,this._item_click=t=>{null!=t.action&&((0,r.isPlainObject)(t)?t.action():(0,a.execute)(t.action,new p.Menu,{item:t})),this.hide()},this._on_mousedown=t=>{t.composedPath().includes(this.el)||this.prevent_hide?.(t)||this.hide()},this._on_keydown=t=>{"Escape"==t.key&&this.hide()},this._on_blur=()=>{this.hide()},this.items=t,this.target=e.target,this.orientation=e.orientation??"vertical",this.reversed=e.reversed??!1,this.labels=e.labels??!0,this.prevent_hide=e.prevent_hide,this.extra_styles=e.extra_styles??[],this.shadow_el=this.el.attachShadow({mode:"open"}),this.class_list=new l.ClassList(this.el.classList)}remove(){this._unlisten(),this.el.remove()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=(()=>{if("left_of"in t){const{left:e,top:i}=t.left_of.getBoundingClientRect();return{right:e,top:i}}if("right_of"in t){const{top:e,right:i}=t.right_of.getBoundingClientRect();return{left:i,top:e}}if("below"in t){const{left:e,bottom:i}=t.below.getBoundingClientRect();return{left:e,top:i}}if("above"in t){const{left:e,top:i}=t.above.getBoundingClientRect();return{left:e,bottom:i}}return t})(),i=this.el.offsetParent??document.body,s=(()=>{const t=i.getBoundingClientRect(),e=getComputedStyle(i);return{left:t.left-parseFloat(e.marginLeft),right:t.right+parseFloat(e.marginRight),top:t.top-parseFloat(e.marginTop),bottom:t.bottom+parseFloat(e.marginBottom)}})(),{style:n}=this.el;n.left=null!=e.left?e.left-s.left+"px":"auto",n.top=null!=e.top?e.top-s.top+"px":"auto",n.right=null!=e.right?s.right-e.right+"px":"auto",n.bottom=null!=e.bottom?s.bottom-e.bottom+"px":"auto"}stylesheets(){return[u.default,d.default,_.default,...this.extra_styles]}empty(){(0,l.empty)(this.shadow_el),this.class_list.clear()}render(){this.empty();for(const t of this.stylesheets()){((0,r.isString)(t)?new l.InlineStyleSheet(t):t).install(this.shadow_el)}this.class_list.add(c[this.orientation]);const t=this.reversed?(0,h.reversed)(this.items):this.items;for(const e of t){let t;if(null==e||e instanceof p.DividerItem)t=(0,l.div)({class:c.divider});else{if((0,r.isBoolean)(e.disabled)?e.disabled:e.disabled?.())continue;if((0,r.isPlainObject)(e)&&null!=e.custom)t=e.custom;else{const i=(()=>{if(null!=e.icon){const t=(0,l.div)({class:c.menu_icon});return(0,m.apply_icon)(t,e.icon),t}return null})(),s=((0,r.isBoolean)(e.checked)?e.checked:e.checked?.())?c.active:null,n=this.labels?e.label:null;t=(0,l.div)({class:[s],title:e.tooltip,tabIndex:0},i,n),(0,r.isPlainObject)(e)&&(null!=e.class&&t.classList.add(e.class),null!=e.content&&t.append(e.content)),t.addEventListener("click",(()=>{this._item_click(e)})),t.addEventListener("keydown",(t=>{"Enter"==t.key&&this._item_click(e)}))}}this.shadow_el.appendChild(t)}}show(t){0!=this.items.length&&(this.render(),0!=this.shadow_el.children.length&&((this.target.shadowRoot??this.target).appendChild(this.el),this._position(t??{left:0,top:0}),this._listen(),this._open=!0))}hide(){this._open&&(this._open=!1,this._unlisten(),this.el.remove())}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=f,f.__name__="ContextMenu"},
function _(r,o,e,i,t){i(),e.menu_icon="bk-menu-icon",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.default=".bk-menu-icon{width:28px;height:28px;mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}:host{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:var(--bokeh-top-level);cursor:pointer;font-size:var(--font-size);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);box-shadow:2px 4px 8px rgba(0, 0, 0, 0.175);}:host(.bk-horizontal){flex-direction:row;}:host(.bk-vertical){flex-direction:column;}.bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}:host(.bk-horizontal) > .bk-divider{width:1px;margin:5px 0;}:host(.bk-vertical) > .bk-divider{height:1px;margin:0 5px;}:host > :not(.bk-divider){border:1px solid transparent;}:host > :not(.bk-divider).bk-active{border-color:var(--highlight-color);}:host > :not(.bk-divider):hover{background-color:#f9f9f9;}:host > :not(.bk-divider):focus,:host > :not(.bk-divider):focus-visible{outline:1px dotted var(--highlight-color);outline-offset:-1px;}:host > :not(.bk-divider)::-moz-focus-inner{border:0;}:host(.bk-horizontal) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-bottom-left-radius:var(--border-radius);}:host(.bk-horizontal) > :not(.bk-divider):last-child{border-top-right-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):last-child{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}"},
function _(o,t,e,r,i){r(),e.tool_icon="bk-tool-icon",e.disabled="bk-disabled",e.hidden="bk-hidden",e.count="bk-count",e.tool_chevron="bk-tool-chevron",e.above="bk-above",e.below="bk-below",e.left="bk-left",e.right="bk-right",e.active="bk-active",e.default=":host{--button-width:30px;--button-height:30px;--button-color:lightgray;--button-border:2px;--active-tool-border:var(--button-border) solid transparent;}:host{position:relative;width:var(--button-width);height:var(--button-height);cursor:pointer;user-select:none;-webkit-user-select:none;touch-action:none;}.bk-tool-icon{position:relative;top:calc(var(--button-border)/2);width:calc(var(--button-width) - var(--button-border));height:calc(var(--button-height) - var(--button-border));mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60% 60%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}:host(.bk-disabled) .bk-tool-icon{background-color:var(--icon-color-disabled);cursor:not-allowed;}:host(.bk-hidden){display:none;}.bk-count{position:absolute;top:0;right:0;--height:1.1em;height:var(--height);line-height:var(--height);text-align:center;aspect-ratio:1 / 1;font-size:80%;border-radius:50%;color:white;background-color:var(--icon-color);}.bk-tool-chevron{position:absolute;visibility:hidden;width:8px;height:8px;mask-size:100% 100%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:100% 100%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;}:host(:hover) .bk-tool-chevron{visibility:visible;}:host(.bk-above) .bk-tool-chevron{right:0;bottom:0;background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}:host(.bk-below) .bk-tool-chevron{right:0;top:0;background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}:host(.bk-left) .bk-tool-chevron{right:0;bottom:0;background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}:host(.bk-right) .bk-tool-chevron{left:0;bottom:0;background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}:host(:hover){background-color:rgba(192, 192, 192, 0.15);}:host(:focus),:host(:focus-visible){outline:1px dotted var(--highlight-color);outline-offset:-1px;}:host::-moz-focus-inner{border:0;}:host(.bk-above){border-bottom:var(--active-tool-border);}:host(.bk-above.bk-active){border-bottom-color:var(--highlight-color);}:host(.bk-below){border-top:var(--active-tool-border);}:host(.bk-below.bk-active){border-top-color:var(--highlight-color);}:host(.bk-right){border-left:var(--active-tool-border);}:host(.bk-right.bk-active){border-left-color:var(--highlight-color);}:host(.bk-left){border-right:var(--active-tool-border);}:host(.bk-left.bk-active){border-right-color:var(--highlight-color);}"},
function _(e,o,t,n,s){n();const r=e(309),l=e(321);class u extends r.ToolView{get plot_view(){return this.parent}}t.GestureToolView=u,u.__name__="GestureToolView";class _ extends r.Tool{constructor(e){super(e)}tool_button(){return new l.OnOffButton({tool:this})}}t.GestureTool=_,_.__name__="GestureTool"},
function _(t,e,o,n,s){var i;n();const c=t(1),_=t(315),l=c.__importStar(t(319));class a extends _.ToolButtonView{_toggle_active(){this.class_list.toggle(l.active,this.model.tool.active)}connect_signals(){super.connect_signals();const{active:t}=this.model.tool.properties;this.on_change(t,(()=>{this._toggle_active()}))}render(){super.render(),this._toggle_active()}tap(){const{active:t}=this.model.tool;this.model.tool.active=!t}}o.OnOffButtonView=a,a.__name__="OnOffButtonView";class r extends _.ToolButton{constructor(t){super(t)}}o.OnOffButton=r,i=r,r.__name__="OnOffButton",i.prototype.default_view=a},
function _(e,t,o,n,s){var i;n();const l=e(1),r=e(309),_=e(321),c=l.__importStar(e(19));class a extends r.ToolView{get plot_view(){return this.parent}}o.InspectToolView=a,a.__name__="InspectToolView";class p extends r.Tool{constructor(e){super(e),this.event_type="move"}tool_button(){return new _.OnOffButton({tool:this})}}o.InspectTool=p,i=p,p.__name__="InspectTool",i.define((()=>({toggleable:[new c.PropertyAlias("visible")]}))),i.override({active:!0})},
function _(o,t,n,e,i){e();const s=o(309),c=o(324),l=o(16);class _ extends s.ToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,(o=>this.doit(o)))}}n.ActionToolView=_,_.__name__="ActionToolView";class u extends s.Tool{constructor(o){super(o),this.do=new l.Signal(this,"do")}tool_button(){return new c.ClickButton({tool:this})}menu_item(){const o=super.menu_item();return o.action=()=>this.do.emit(void 0),o}}n.ActionTool=u,u.__name__="ActionTool"},
function _(t,o,n,e,i){var c;e();const s=t(321);class u extends s.OnOffButtonView{tap(){this.model.tool.do.emit(void 0)}}n.ClickButtonView=u,u.__name__="ClickButtonView";class _ extends s.OnOffButton{constructor(t){super(t)}}n.ClickButton=_,c=_,_.__name__="ClickButton",c.prototype.default_view=u},
function _(o,e,t,l,i){var n;l();const s=o(323),r=o(76);class c extends s.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=c,c.__name__="HelpToolView";class _ extends s.ActionTool{constructor(o){super(o),this.tool_name="Help",this.tool_icon=r.tool_icon_help}}t.HelpTool=_,n=_,_.__name__="HelpTool",n.prototype.default_view=c,n.define((({Str:o})=>({redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/interaction/tools.html"]}))),n.override({description:"Click the question mark to learn more about Bokeh plot tools."}),n.register_alias("help",(()=>new n))},
function _(o,t,e,i,l){i(),e.inner="bk-inner",e.hidden="bk-hidden",e.logo="bk-logo",e.above="bk-above",e.below="bk-below",e.left="bk-left",e.right="bk-right",e.divider="bk-divider",e.tool_overflow="bk-tool-overflow",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.default=':host{--button-width:30px;--button-height:30px;--button-color:lightgray;}:host{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-webkit-user-select:none;pointer-events:all;}:host(.bk-inner){background-color:white;opacity:0.8;}:host(.bk-hidden){visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-logo{flex-shrink:0;}:host(.bk-above),:host(.bk-below){flex-direction:row;justify-content:flex-end;}:host(.bk-above) .bk-logo,:host(.bk-below) .bk-logo{order:1;margin-left:5px;margin-right:0px;}:host(.bk-left),:host(.bk-right){flex-direction:column;justify-content:flex-start;}:host(.bk-left) .bk-logo,:host(.bk-right) .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-divider{content:" ";display:inline-block;background-color:var(--button-color);}:host(.bk-above) .bk-divider,:host(.bk-below) .bk-divider{height:10px;width:1px;}:host(.bk-left) .bk-divider,:host(.bk-right) .bk-divider{height:1px;width:10px;}.bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-tool-overflow:focus,.bk-tool-overflow:focus-visible{outline:var(--outline-width) var(--outline-style) var(--highlight-color);outline-offset:-1px;}.bk-tool-overflow::-moz-focus-inner{border:0;}:host(.bk-above) .bk-tool-overflow,:host(.bk-below) .bk-tool-overflow,:host(.bk-horizontal) .bk-tool-overflow{width:calc(var(--button-width)/2);height:var(--button-height);flex-direction:row;}:host(.bk-left) .bk-tool-overflow,:host(.bk-right) .bk-tool-overflow,:host(.bk-vertical) .bk-tool-overflow{width:var(--button-width);height:calc(var(--button-height)/2);flex-direction:column;}'},
function _(A,l,g,o,d){o(),g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.default=".bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-logo.bk-grey{filter:grayscale(100%);}.bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}"},
function _(e,t,i,s,n){s();const a=e(1),r=e(198),o=e(199),_=e(329),l=e(98),h=e(97),d=e(313),c=e(333),p=e(131),u=e(96),m=e(185),g=e(202),f=e(202),w=e(334),b=e(118),v=e(335),y=e(337),x=e(80),z=e(69),k=e(99),S=e(20),P=e(80),$=e(16),C=e(338),M=e(8),N=e(10),V=e(14),q=e(71),T=e(135),R=e(138),A=e(272),L=e(139),B=e(187),D=e(62),H=e(193),E=e(339),F=e(340),I=e(30),O=e(61),U=e(57),j=a.__importStar(e(341)),G=a.__importStar(e(332)),J=a.__importStar(e(342)),{max:K}=Math;class Q extends p.LayoutDOMView{constructor(){super(...arguments),this._render_count=0,this.repainted=new $.Signal0(this,"repainted"),this._computed_style=new O.InlineStyleSheet("","computed"),this._inner_bbox=new D.BBox,this._needs_paint=!0,this._invalidated_painters=new Set,this._invalidate_all=!0,this.computed_renderers=[],this.renderer_views=new Map,this.tool_views=new Map,this._is_paused=0,this._needs_notify=!1,this._needs_layout=!1,this._force_paint=!1,this._messages=new Map}get frame(){return this.frame_view}get canvas(){return this.canvas_view}stylesheets(){return[...super.stylesheets(),j.default,this._computed_style]}get toolbar_panel(){return null!=this._toolbar?this.views.find_one(this._toolbar):null}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}get computed_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e))).filter((e=>null!=e))}get all_renderer_views(){const e=[];for(const t of this.computed_renderer_views)e.push(t),t instanceof h.CompositeRendererView&&e.push(...t.computed_renderer_views);return e}get auto_ranged_renderers(){return this.computed_renderer_views.filter(b.is_auto_ranged)}get base_font_size(){const e=getComputedStyle(this.el).fontSize,t=(0,H.parse_css_font_size)(e);if(null!=t){const{value:e,unit:i}=t;if("px"==i)return e}return null}*children(){yield*super.children(),yield*this.renderer_views.values(),yield*this.tool_views.values()}get child_models(){return[]}get is_paused(){return 0!=this._is_paused}pause(){this._is_paused+=1}unpause(e=!1){this._is_paused=K(this._is_paused-1,0),this.is_paused||e||this.request_repaint()}notify_finished_after_paint(){this._needs_notify=!0}request_repaint(){this.request_paint()}request_paint(...e){this.invalidate_painters(...e),this.schedule_paint()}invalidate_painters(...e){if(0!=e.length)for(const t of e){const e=(()=>t instanceof l.RendererView?t:this.views.get_one(t))();this._invalidated_painters.add(e)}else this._invalidate_all=!0}schedule_paint(){this.is_paused||this._await_ready(this.throttled_paint())}request_layout(e=!1){e&&(this._needs_layout=!0),this.request_repaint()}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new x.Reset)}remove(){(0,z.remove_views)(this.renderer_views),(0,z.remove_views)(this.tool_views),super.remove()}_provide_context_menu(){return new c.ToolMenu({toolbar:this.model.toolbar})}get_context_menu(e){const{x:t,y:i}=e;for(const e of(0,N.reversed)([...this.renderer_views.values()]))if(null!=e.context_menu&&1==e.interactive_hit?.(t,i))return e.context_menu;return super.get_context_menu(e)}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new k.Visuals(this),this._initial_state={selection:new Map},this._top_panel=new o.CanvasPanel({place:"above"}),this._bottom_panel=new o.CanvasPanel({place:"below"}),this._left_panel=new o.CanvasPanel({place:"left"}),this._right_panel=new o.CanvasPanel({place:"right"}),this._inner_top_panel=new o.CanvasPanel({place:"above",inner:!0}),this._inner_bottom_panel=new o.CanvasPanel({place:"below",inner:!0}),this._inner_left_panel=new o.CanvasPanel({place:"left",inner:!0}),this._inner_right_panel=new o.CanvasPanel({place:"right",inner:!0}),this._frame=new r.CartesianFrame({place:"center",x_scale:this.model.x_scale,y_scale:this.model.y_scale,x_range:this.model.x_range,y_range:this.model.y_range,extra_x_ranges:this.model.extra_x_ranges,extra_y_ranges:this.model.extra_y_ranges,extra_x_scales:this.model.extra_x_scales,extra_y_scales:this.model.extra_y_scales,aspect_scale:this.model.aspect_scale,match_aspect:this.model.match_aspect}),this._range_manager=new E.RangeManager(this),this._state_manager=new F.StateManager(this,this._initial_state),this.throttled_paint=(0,C.throttle)((()=>{this.is_destroyed||this.repaint()}),1e3/60);const{title_location:e,title:t}=this.model;null!=e&&null!=t&&(this._title=t instanceof m.Title?t:new m.Title({text:t}));const{toolbar_location:i,toolbar_inner:s,toolbar:n}=this.model;null!=i&&(this._toolbar=new w.ToolbarPanel({toolbar:n}),n.location=i,n.inner=s);const{hidpi:a,output_backend:l}=this.model;this._canvas=new _.Canvas({hidpi:a,output_backend:l}),this._attribution=new v.Panel({position:new U.Node({target:"frame",symbol:"bottom_right"}),anchor:"bottom_right",elements:[],css_variables:{"--max-width":new U.Node({target:"frame",symbol:"width"})},stylesheets:[J.default]}),this._notifications=new v.Panel({position:new U.Node({target:this.model,symbol:"top_center"}),anchor:"top_center",elements:[],stylesheets:["\n        :host {\n          display: flex;\n          flex-direction: column;\n          gap: 1em;\n          width: max-content;\n          max-width: 80%;\n        }\n\n        :host:empty {\n          display: none;\n        }\n\n        :host > div {\n          padding: 0.5em;\n          border: 1px solid gray;\n          border-radius: 0.5em;\n          opacity: 0.8;\n        }\n      "]})}get elements(){return[this._canvas,this._frame,this._top_panel,this._bottom_panel,this._left_panel,this._right_panel,this._inner_top_panel,this._inner_bottom_panel,this._inner_left_panel,this._inner_right_panel,this._attribution,this._notifications,...super.elements]}async lazy_initialize(){await super.lazy_initialize(),this.canvas_view=this._element_views.get(this._canvas),this.canvas_view.plot_views=[this],this.frame_view=this._element_views.get(this._frame),this.top_panel=this._element_views.get(this._top_panel),this.bottom_panel=this._element_views.get(this._bottom_panel),this.left_panel=this._element_views.get(this._left_panel),this.right_panel=this._element_views.get(this._right_panel),this.inner_top_panel=this._element_views.get(this._inner_top_panel),this.inner_bottom_panel=this._element_views.get(this._inner_bottom_panel),this.inner_left_panel=this._element_views.get(this._inner_left_panel),this.inner_right_panel=this._element_views.get(this._inner_right_panel),await this.build_tool_views(),await this.build_renderer_views(),this._range_manager.update_dataranges(),this._update_touch_action()}box_sizing(){const{width_policy:e,height_policy:t,...i}=super.box_sizing(),{frame_width:s,frame_height:n}=this.model;return{...i,width_policy:null!=s&&"auto"==e?"fit":e,height_policy:null!=n&&"auto"==t?"fit":t}}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_compute_layout_panels(){const e=(0,N.copy)(this.model.above),t=(0,N.copy)(this.model.below),i=(0,N.copy)(this.model.left),s=(0,N.copy)(this.model.right),n=[],a=[],r=[],o=[],_=(_,l=!1)=>{switch(_){case"above":return l?n:e;case"below":return l?a:t;case"left":return l?r:i;case"right":return l?o:s}},{title_location:l}=this.model;if(null!=l&&null!=this._title&&_(l).push(this._title),null!=this._toolbar){const{location:e}=this._toolbar.toolbar;if(this.model.toolbar_inner){_(e,!0).push(this._toolbar)}else{const t=_(e);let i=!0;if(this.model.toolbar_sticky)for(let s=0;s<t.length;s++){const n=t[s];if(n instanceof m.Title){t[s]="above"==e||"below"==e?[n,this._toolbar]:[this._toolbar,n],i=!1;break}}i&&t.push(this._toolbar)}}return{outer_above:e,outer_below:t,outer_left:i,outer_right:s,inner_above:n,inner_below:a,inner_left:r,inner_right:o}}_make_layout(){return new A.BorderLayout}_update_layout(){super._update_layout(),this._invalidate_all=!0,this._needs_paint=!0;const e=this._make_layout(),{frame_align:t}=this.model;if(e.aligns=(()=>{if((0,M.isBoolean)(t))return{left:t,right:t,top:t,bottom:t};{const{left:e=!0,right:i=!0,top:s=!0,bottom:n=!0}=t;return{left:e,right:i,top:s,bottom:n}}})(),e.set_sizing({width_policy:"max",height_policy:"max"}),this.visuals.outline_line.doit){const t=this.visuals.outline_line.line_width.get_value();e.center_border_width=t}const i=(e,t)=>{if(t instanceof u.Annotation||t instanceof g.Axis){const i=this.views.get_one(t);return i.panel=new B.SidePanel(e),i.update_layout?.(),i.layout}{const e=this.views.get_one(t),i=new T.ElementLayout(e.el);return i.set_sizing({width_policy:"fixed",height_policy:"fixed"}),i}},s=(e,t)=>{const s="above"==e||"below"==e,n=[];for(const a of t)if((0,M.isArray)(a)){const t=a.map((t=>{const n=i(e,t);if(null!=n){if(t instanceof w.ToolbarPanel){const e=s?"width_policy":"height_policy";n.set_sizing({...n.sizing,[e]:"min"})}return n}})).filter((e=>null!=e));let r;s?(r=new L.Row(t),r.set_sizing({width_policy:"max",height_policy:"min"})):(r=new L.Column(t),r.set_sizing({width_policy:"min",height_policy:"max"})),r.absolute=!0,n.push(r)}else{const t=i(e,a);null!=t&&n.push(t)}return n},n=this.model.min_border??0;e.min_border={left:this.model.min_border_left??n,top:this.model.min_border_top??n,right:this.model.min_border_right??n,bottom:this.model.min_border_bottom??n};const a=new R.NodeLayout,r=new R.VStack,o=new R.VStack,_=new R.HStack,l=new R.HStack,h=new R.VStack,d=new R.VStack,c=new R.HStack,p=new R.HStack;a.absolute=!0,r.absolute=!0,o.absolute=!0,_.absolute=!0,l.absolute=!0,h.absolute=!0,d.absolute=!0,c.absolute=!0,p.absolute=!0,a.children=this.model.center.filter((e=>e instanceof u.Annotation)).map((e=>{const t=this.views.get_one(e);return t.update_layout?.(),t.layout})).filter((e=>null!=e));const{frame_width:m,frame_height:f}=this.model;a.set_sizing({...null!=m?{width_policy:"fixed",width:m}:{width_policy:"fit"},...null!=f?{height_policy:"fixed",height:f}:{height_policy:"fit"}}),a.on_resize((e=>this.frame.set_geometry(e))),r.on_resize((e=>this.top_panel.set_geometry(e))),o.on_resize((e=>this.bottom_panel.set_geometry(e))),_.on_resize((e=>this.left_panel.set_geometry(e))),l.on_resize((e=>this.right_panel.set_geometry(e)));const{outer_above:b,outer_below:v,outer_left:y,outer_right:x,inner_above:z,inner_below:k,inner_left:S,inner_right:P}=this._compute_layout_panels();r.children=(0,N.reversed)(s("above",b)),o.children=s("below",v),_.children=(0,N.reversed)(s("left",y)),l.children=s("right",x),h.on_resize((e=>this.inner_top_panel.set_geometry(e))),d.on_resize((e=>this.inner_bottom_panel.set_geometry(e))),c.on_resize((e=>this.inner_left_panel.set_geometry(e))),p.on_resize((e=>this.inner_right_panel.set_geometry(e))),h.children=s("above",z),d.children=s("below",k),c.children=s("left",S),p.children=s("right",P),r.set_sizing({width_policy:"fit",height_policy:"min"}),o.set_sizing({width_policy:"fit",height_policy:"min"}),_.set_sizing({width_policy:"min",height_policy:"fit"}),l.set_sizing({width_policy:"min",height_policy:"fit"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),d.set_sizing({width_policy:"fit",height_policy:"min"}),c.set_sizing({width_policy:"min",height_policy:"fit"}),p.set_sizing({width_policy:"min",height_policy:"fit"}),e.center_panel=a,e.top_panel=r,e.bottom_panel=o,e.left_panel=_,e.right_panel=l,e.inner_top_panel=h,e.inner_bottom_panel=d,e.inner_left_panel=c,e.inner_right_panel=p,this.layout=e;const $=(e,t)=>(0,O.div)({style:{display:"flex",flex_direction:e,width:"100%",height:"100%"}},t),C=(e,t)=>e.map((e=>{if(!(0,M.isArray)(e))return this.views.get_one(e).el;{const i=this.views.select(e).map((e=>{const{el:t}=e;return t.style.flex=e.model instanceof w.ToolbarPanel?"1":"none",t}));switch(t){case"x":return $("row",i);case"y":return $("column",i)}}})),V=C(b,"x"),q=C(v,"x"),A=C(y,"y"),D=C(x,"y");this.top_panel.shadow_el.append(...(0,N.reversed)(V)),this.bottom_panel.shadow_el.append(...q),this.left_panel.shadow_el.append(...(0,N.reversed)(A)),this.right_panel.shadow_el.append(...D);const H=C(z,"x"),E=C(k,"x"),F=C(S,"y"),I=C(P,"y");this.inner_top_panel.shadow_el.append(...(0,N.reversed)(H)),this.inner_bottom_panel.shadow_el.append(...E),this.inner_left_panel.shadow_el.append(...(0,N.reversed)(F)),this.inner_right_panel.shadow_el.append(...I);const U=this.views.select(this.model.center).map((e=>e.el)),j=this.views.select(this.model.renderers).map((e=>e.el));this.frame.shadow_el.append(...j,...U)}_measure_layout(){const{frame_width:e,frame_height:t}=this.model,i=null==e?"1fr":(0,O.px)(e),s=null==t?"1fr":(0,O.px)(t),{layout:n}=this,a=n.top_panel.measure({width:1/0,height:1/0}),r=n.bottom_panel.measure({width:1/0,height:1/0}),o=n.left_panel.measure({width:1/0,height:1/0}),_=n.right_panel.measure({width:1/0,height:1/0}),l=K(a.height,n.min_border.top),h=K(r.height,n.min_border.bottom),d=K(o.width,n.min_border.left),c=K(_.width,n.min_border.right);this._computed_style.replace(`\n      :host {\n        grid-template-rows: ${l}px ${s} ${h}px;\n        grid-template-columns: ${d}px ${i} ${c}px;\n      }\n    `)}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof f.AxisView&&e.push(t);return e}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.pause(),this._range_manager.reset(),this.unpause(),this.trigger_ranges_update_event()}trigger_ranges_update_event(e=[]){const{x_ranges:t,y_ranges:i}=this._range_manager.ranges(),s=[...t,...i,...e],n=new Set(s.flatMap((e=>[...e.linked_plots])));for(const e of n){const{x_range:t,y_range:i}=e.model,s=new P.RangesUpdate(t.start,t.end,i.start,i.end);e.model.trigger_event(s)}}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout_if_needed(){(()=>{if(this._needs_layout)return this.invalidate_painters(),!0;for(const e of this.model.side_panels){const t=this.renderer_views.get(e);if(null!=t&&t.layout?.has_size_changed())return this.invalidate_painters(t),!0}return!1})()&&(this._needs_layout=!1,this.compute_layout())}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:n,renderers:a}=this.model;yield*a,yield*[...e,...t,...i,...s,...n],null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const[,e]of this.tool_views)yield*e.overlays}_update_attribution(){const e=[...this.model.attribution,...this.computed_renderer_views.map((e=>e.attribution))].filter((e=>null!=e)).map((e=>(0,M.isString)(e)?new y.Div({children:[e]}):e));this._attribution.elements=e}async _build_renderers(){this.computed_renderers=[...this._compute_renderers()];const e=await(0,z.build_views)(this.renderer_views,this.computed_renderers,{parent:e=>e instanceof p.LayoutDOM?null:this});return this._update_attribution(),e}async _update_renderers(){const{created:e}=await this._build_renderers(),t=new Set(e);for(const e of this.renderer_views.values()){const i=t.has(e),s=e.rendering_target()??this.self_target;i?e.render_to(s):s.append(e.el)}this.r_after_render()}async build_renderer_views(){await this._build_renderers()}async build_tool_views(){const e=(0,V.flat_map)(this.model.toolbar.tools,(e=>e instanceof d.ToolProxy?e.tools:[e])),{created:t}=await(0,z.build_views)(this.tool_views,[...e],{parent:this});t.map((e=>this.canvas_view.ui_event_bus.register_tool(e)))}connect_signals(){super.connect_signals();const{x_range:e,y_range:t,x_scale:i,y_scale:s,extra_x_ranges:n,extra_y_ranges:a,extra_x_scales:r,extra_y_scales:o,aspect_scale:_,match_aspect:l}=this.model.properties;this.on_change([e,t,i,s,n,a,r,o,_,l],(()=>{const{x_range:e,y_range:t,x_scale:i,y_scale:s,extra_x_ranges:n,extra_y_ranges:a,extra_x_scales:r,extra_y_scales:o,aspect_scale:_,match_aspect:l}=this.model;this._frame.setv({x_range:e,y_range:t,x_scale:i,y_scale:s,extra_x_ranges:n,extra_y_ranges:a,extra_x_scales:r,extra_y_scales:o,aspect_scale:_,match_aspect:l})}));const{above:h,below:d,left:c,right:p,center:u,renderers:m}=this.model.properties;this.on_change([h,d,c,p,u,m],(async()=>{await this._update_renderers(),this.invalidate_layout()})),this.connect(this.model.toolbar.properties.tools.change,(async()=>{await this.build_tool_views(),await this._update_renderers()}));const{x_ranges:g,y_ranges:f}=this.frame;for(const[,e]of g)this.connect(e.change,(()=>{this.request_repaint()}));for(const[,e]of f)this.connect(e.change,(()=>{this.request_repaint()}));this.connect(this.model.change,(()=>this.request_repaint())),this.connect(this.model.reset,(()=>this.reset()));const{toolbar_location:b}=this.model.properties;this.on_change(b,(async()=>{const{toolbar_location:e}=this.model;if(null!=this._toolbar)null!=e?this._toolbar.toolbar.location=e:(this._toolbar=void 0,await this._update_renderers());else if(null!=e){const{toolbar:t,toolbar_inner:i}=this.model;this._toolbar=new w.ToolbarPanel({toolbar:t}),t.location=e,t.inner=i,await this._update_renderers()}this.invalidate_layout()}));const{hold_render:v}=this.model.properties;this.on_change(v,(()=>{this.model.hold_render||this.request_repaint()})),this.model.toolbar.active_changed.connect((()=>this._update_touch_action())),null!=visualViewport&&visualViewport.addEventListener("resize",(()=>{this.canvas.resize()&&this.request_repaint()}))}_update_touch_action(){const{toolbar:e}=this.model;let t=!1,i=!1;for(const s of e.tools)if(s.active){const{event_types:e}=s;if(e.includes("pan")&&(t=!0),e.includes("scroll")&&(i=!0),t&&i)break}const s=t||i?t?i?"none":"pinch-zoom":"pan-x pan-y":"auto";this.canvas.touch_action.replace(`\n      .${G.events} {\n        touch-action: ${s};\n      }\n    `)}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}_after_layout(){super._after_layout(),this.unpause(!0);const e=this.layout.left_panel.bbox,t=this.layout.right_panel.bbox,i=this.layout.center_panel.bbox,s=this.layout.top_panel.bbox,n=this.layout.bottom_panel.bbox,{bbox:a}=this,r=s.bottom,o=a.height-n.top,_=e.right,l=a.width-t.left;this.canvas.parent_style.replace(`\n      .bk-events {\n        grid-template-rows: ${(0,O.px)(r)} ${(0,O.px)(i.height)} ${(0,O.px)(o)};\n        grid-template-columns: ${(0,O.px)(_)} ${(0,O.px)(i.width)} ${(0,O.px)(l)};\n      }\n    `);for(const[,e]of this.renderer_views)e instanceof u.AnnotationView&&e.after_layout?.();this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.bbox.width),outer_height:Math.round(this.bbox.height)},{no_change:!0}),this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),this.canvas_view.update_bbox()&&(this._invalidate_all=!0,this._needs_paint=!0);const{inner_bbox:h}=this.layout;this._inner_bbox.equals(h)||(this._inner_bbox=h,this._invalidate_all=!0,this._needs_paint=!0),this._needs_paint&&this.paint()}render(){super.render();for(const e of this.computed_renderer_views){const t=e.rendering_target()??this.self_target;e.render_to(t)}}repaint(){this._invalidate_layout_if_needed(),this.paint()}paint(){if(!this.is_paused&&!this.model.hold_render){if(this.is_displayed)S.logger.trace(`${this.toString()}.paint()`),this._actual_paint();else for(const e of this.computed_renderer_views)e.force_finished();this._needs_notify&&(this._needs_notify=!1,this.notify_finished())}}_actual_paint(){S.logger.trace(`${this.toString()}._actual_paint ${this._render_count} start`);const{document:e}=this.model;if(null!=e){const t=e.interactive_duration();t>=0&&t<this.model.lod_interval?setTimeout((()=>{e.interactive_duration()>this.model.lod_timeout&&e.interactive_stop(),this.request_repaint()}),this.model.lod_timeout):e.interactive_stop()}(this._range_manager.invalidate_dataranges||"none"!=this.model.window_axis)&&(this._range_manager.update_dataranges(),this._invalidate_layout_if_needed());let t=!1,i=!1;if(this._invalidate_all)t=!0,i=!0;else for(const e of this._invalidated_painters){const{level:s}=e.model;if("overlay"!=s?t=!0:i=!0,t&&i)break}if(this._invalidated_painters.clear(),this._invalidate_all=!1,t){const{primary:e}=this.canvas_view,t=e.prepare();this._paint_primary(t),e.finish()}if(i||I.settings.wireframe){const{overlays:e}=this.canvas_view,t=e.prepare();this._paint_overlays(t),e.finish()}null==this._initial_state.range&&(this._initial_state.range=this._range_manager.compute_initial()??void 0);for(const e of this.element_views)e.reposition();this._needs_paint=!1,this.repainted.emit(),S.logger.trace(`${this.toString()}._actual_paint ${this._render_count} end`),this._render_count++}_paint_primary(e){const t=this.frame.bbox;this.canvas_view.prepare_webgl(t),this._paint_empty(e,t),this._paint_outline(e,t),this._paint_levels(e,"image",t,!0),this._paint_levels(e,"underlay",t,!0),this._paint_levels(e,"glyph",t,!0),this._paint_levels(e,"guide",t,!1),this._paint_levels(e,"annotation",t,!1)}_paint_overlays(e){const t=this.frame.bbox;this._paint_levels(e,"overlay",t,!1),I.settings.wireframe&&this.paint_layout(e,this.layout)}_paint_levels(e,t,i,s){for(const n of this.computed_renderer_views)n.model.level==t&&(e.save(),(s||n.needs_clip)&&(e.beginPath(),e.rect(...i.args),e.clip()),n.paint(e),e.restore(),n.has_webgl&&this.canvas_view.blit_webgl(e))}paint_layout(e,t){const{x:i,y:s,width:n,height:a}=t.bbox;e.strokeStyle="blue",e.strokeRect(i,s,n,a);for(const n of t)e.save(),t.absolute||e.translate(i,s),this.paint_layout(e,n),e.restore()}_shrink_to_canvas(e){let{x:t,y:i,width:s,height:n}=e;return s>0&&t+s==this.bbox.width&&(s-=1),n>0&&i+n==this.bbox.height&&(n-=1),new D.BBox({x:t,y:i,width:s,height:n})}_paint_empty(e,t){const i=this.bbox.relative(),{border_fill:s,border_hatch:n}=this.visuals;(s.doit||n.doit)&&(e.save(),e.beginPath(),e.rect_bbox(i),e.rect_bbox(t),e.clip("evenodd"),e.beginPath(),e.rect_bbox(i),s.apply(e),n.apply(e),e.restore());const{border_line:a}=this.visuals;a.doit&&(e.beginPath(),e.rect_bbox(this._shrink_to_canvas(i)),a.apply(e));const{background_fill:r,background_hatch:o}=this.visuals;(r.doit||o.doit)&&(e.beginPath(),e.rect_bbox(t),r.apply(e),o.apply(e))}_paint_outline(e,t){const{outline_line:i}=this.visuals;if(i.doit){i.set_value(e);const{x:s,y:n,width:a,height:r}=this._shrink_to_canvas(t);e.strokeRect(s,n,a,r)}}get is_forcing_paint(){return this._force_paint}force_paint(e){try{this._force_paint=!0,e()}finally{this._force_paint=!1}}export(e="auto",t=!0){const i=(()=>{switch(e){case"auto":return this.canvas_view.model.output_backend;case"png":return"canvas";case"svg":return"svg"}})(),s=new q.CanvasLayer(i,t),{width:n,height:a}=this.bbox;if(s.resize(n,a),0!=n&&0!=a){this.force_paint((()=>{const e=s.prepare();this._paint_primary(e),this._paint_overlays(e),s.finish()}));for(const i of this.renderer_views.values())if((0,q.is_Exportable)(i)){const n=i.export(e,t),{x:a,y:r}=i.bbox.scale(s.pixel_ratio);s.ctx.drawImage(n.canvas,a,r)}}return s}resolve_frame(){return this.frame}resolve_canvas(){return this.canvas}resolve_plot(){return this}resolve_xy(e){const{x:t,y:i}=e,s=this.frame.x_scale.compute(t),n=this.frame.y_scale.compute(i);return this.frame.bbox.contains(s,n)?{x:s,y:n}:{x:NaN,y:NaN}}resolve_indexed(e){const{index:t,renderer:i}=e,s=this.views.find_one(i);if(null!=s&&s.has_finished()){const[e,i]=s.glyph.scenterxy(t,NaN,NaN);if(this.frame.bbox.contains(e,i))return{x:e,y:i}}return{x:NaN,y:NaN}}notify_about(e){if(this._messages.has(e))return;const t=new y.Div({children:[e]}),i=setTimeout((()=>{this._messages.delete(e),this._notifications.elements=this._notifications.elements.filter((e=>e!=t))}),2e3);this._messages.set(e,i),this._notifications.elements=[...this._notifications.elements,t],S.logger.info(e)}serializable_children(){return super.serializable_children().filter((e=>e.model instanceof r.CartesianFrame||!(e.model instanceof o.CanvasPanel)))}}i.PlotView=Q,Q.__name__="PlotView"},
function _(e,t,i,s,a){var r;s();const l=e(1),n=e(30),h=e(20),o=e(61),_=e(21),c=e(330),u=e(195),p=e(71),d=e(55),b=e(61),g=l.__importStar(e(332)),v=l.__importDefault(e(76));const w=(()=>{let t;return async()=>void 0!==t?t:t=await async function(){const t=document.createElement("canvas"),i=t.getContext("webgl",{alpha:!0,antialias:!1,depth:!1,premultipliedAlpha:!0});if(null!=i){const s=await(0,u.load_module)(Promise.resolve().then((()=>l.__importStar(e(565)))));if(null!=s){const e=s.get_regl(i);if(e.has_webgl)return{canvas:t,regl_wrapper:e};h.logger.trace("WebGL is supported, but not the required extensions")}else h.logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available")}else h.logger.trace("WebGL is not supported");return null}()})();class y extends d.UIElementView{constructor(){super(...arguments),this.webgl=null,this._size=new b.InlineStyleSheet("","size"),this.touch_action=new b.InlineStyleSheet("","touch-action"),this.plot_views=[]}initialize(){super.initialize(),this.underlays_el=(0,o.div)({class:g.layer}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=(0,o.div)({class:g.layer}),this.events_el=(0,o.div)({class:[g.layer,g.events],tabIndex:0}),this.ui_event_bus=new c.UIEventBus(this)}get layers(){return[this.underlays_el,this.primary,this.overlays,this.overlays_el,this.events_el]}async lazy_initialize(){if(await super.lazy_initialize(),"webgl"==this.model.output_backend&&(this.webgl=await w(),n.settings.force_webgl&&null==this.webgl))throw new Error("webgl is not available")}remove(){this.ui_event_bus.remove(),super.remove()}stylesheets(){return[...super.stylesheets(),g.default,v.default,this._size,this.touch_action]}render(){super.render();const e=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];this.shadow_el.append(...e)}get pixel_ratio(){return this.primary.pixel_ratio}get pixel_ratio_changed(){return this.primary.pixel_ratio_changed}_update_bbox(){const e=super._update_bbox()||this.pixel_ratio_changed;if(e){const{width:e,height:t}=this.bbox;this._size.replace(`.${g.layer}`,{width:(0,o.px)(e),height:(0,o.px)(t)}),this.primary.resize(e,t),this.overlays.resize(e,t)}return e}after_resize(){0!=this.plot_views.length?this.finish():super.after_resize()}_after_resize(){super._after_resize();const{width:e,height:t}=this.bbox;this.primary.resize(e,t),this.overlays.resize(e,t)}resize(){const e=this._update_bbox();return this._after_resize(),e}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:i,height:s}=this.bbox;t.canvas.width=this.pixel_ratio*i,t.canvas.height=this.pixel_ratio*s;const{x:a,y:r,width:l,height:n}=e,{xview:h,yview:o}=this.bbox,_=h.compute(a),c=o.compute(r+n),u=this.pixel_ratio;t.regl_wrapper.set_scissor(u*_,u*c,u*l,u*n),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t&&t.canvas.width*t.canvas.height>0){if(h.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{regl_wrapper:t,canvas:i}=e;t.clear(i.width,i.height)}}compose(){const e=this.create_layer(),{width:t,height:i}=this.bbox;return e.resize(t,i),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e}create_layer(){const{output_backend:e,hidpi:t}=this.model;return new p.CanvasLayer(e,t)}to_blob(){return this.compose().to_blob()}}i.CanvasView=y,y.__name__="CanvasView";class m extends d.UIElement{constructor(e){super(e)}}i.Canvas=m,r=m,m.__name__="Canvas",r.prototype.default_view=y,r.define((({Bool:e})=>({hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"]})))},
function _(t,e,n,i,s){i(),n.is_Tapable=function(t){return(0,l.isObject)(t)&&"on_tap"in t},n.is_Moveable=p,n.is_Pannable=v,n.is_Pinchable=d,n.is_Rotatable=g,n.is_Scrollable=function(t){return(0,l.isObject)(t)&&"on_scroll"in t},n.is_Keyable=function(t){return(0,l.isObject)(t)&&"on_keydown"in t&&"on_keyup"in t};const r=t(1),_=t(316),o=t(16),a=t(61),h=r.__importStar(t(80)),c=t(331),u=t(10),l=t(8);function p(t){return(0,l.isObject)(t)&&"on_enter"in t&&"on_move"in t&&"on_leave"in t}function v(t){return(0,l.isObject)(t)&&"on_pan_start"in t&&"on_pan"in t&&"on_pan_end"in t}function d(t){return(0,l.isObject)(t)&&"on_pinch_start"in t&&"on_pinch"in t&&"on_pinch_end"in t}function g(t){return(0,l.isObject)(t)&&"on_rotate_start"in t&&"on_rotate"in t&&"on_rotate_end"in t}class w{constructor(t){this.pan_start=new o.Signal(this,"pan:start"),this.pan=new o.Signal(this,"pan"),this.pan_end=new o.Signal(this,"pan:end"),this.pinch_start=new o.Signal(this,"pinch:start"),this.pinch=new o.Signal(this,"pinch"),this.pinch_end=new o.Signal(this,"pinch:end"),this.rotate_start=new o.Signal(this,"rotate:start"),this.rotate=new o.Signal(this,"rotate"),this.rotate_end=new o.Signal(this,"rotate:end"),this.tap=new o.Signal(this,"tap"),this.doubletap=new o.Signal(this,"doubletap"),this.press=new o.Signal(this,"press"),this.pressup=new o.Signal(this,"pressup"),this.move_enter=new o.Signal(this,"move:enter"),this.move=new o.Signal(this,"move"),this.move_exit=new o.Signal(this,"move:exit"),this.scroll=new o.Signal(this,"scroll"),this.keydown=new o.Signal(this,"keydown"),this.keyup=new o.Signal(this,"keyup"),this.focus=new o.Signal0(this,"focus"),this.blur=new o.Signal0(this,"blur"),this._tools=new Map,this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._current_interactive_tool_view=null,this._current_pan_view=null,this._current_pinch_view=null,this._current_rotate_view=null,this._current_move_views=[],this.canvas_view=t,this.hit_area=t.events_el,this.on_tap=this.on_tap.bind(this),this.on_doubletap=this.on_doubletap.bind(this),this.on_press=this.on_press.bind(this),this.on_pressup=this.on_pressup.bind(this),this.on_enter=this.on_enter.bind(this),this.on_move=this.on_move.bind(this),this.on_leave=this.on_leave.bind(this),this.on_pan_start=this.on_pan_start.bind(this),this.on_pan=this.on_pan.bind(this),this.on_pan_end=this.on_pan_end.bind(this),this.on_pinch_start=this.on_pinch_start.bind(this),this.on_pinch=this.on_pinch.bind(this),this.on_pinch_end=this.on_pinch_end.bind(this),this.on_rotate_start=this.on_rotate_start.bind(this),this.on_rotate=this.on_rotate.bind(this),this.on_rotate_end=this.on_rotate_end.bind(this),this.on_context_menu=this.on_context_menu.bind(this),this.on_mouse_wheel=this.on_mouse_wheel.bind(this),this.on_key_down=this.on_key_down.bind(this),this.on_key_up=this.on_key_up.bind(this),this.on_focus=this.on_focus.bind(this),this.on_blur=this.on_blur.bind(this),this.ui_gestures=new _.UIGestures(this.hit_area,this,{must_be_target:!0}),this.ui_gestures.connect_signals(),this.hit_area.addEventListener("contextmenu",this.on_context_menu),this.hit_area.addEventListener("wheel",this.on_mouse_wheel),this.hit_area.addEventListener("focus",this.on_focus),this.hit_area.addEventListener("blur",this.on_blur),this.hit_area.addEventListener("keydown",this.on_key_down),this.hit_area.addEventListener("keyup",this.on_key_up)}remove(){this.ui_gestures.remove(),this.hit_area.removeEventListener("contextmenu",this.on_context_menu),this.hit_area.removeEventListener("wheel",this.on_mouse_wheel),document.removeEventListener("keydown",this.on_key_down),document.removeEventListener("keyup",this.on_key_up)}register_tool(t){const{model:e}=t;if(this._tools.has(e))throw new Error(`${e} already registered`);this._tools.set(e,t)}hit_test_renderers(t,e,n){const i=[];for(const s of(0,u.reversed)(t.all_renderer_views))s.interactive_hit?.(e,n)&&i.push(s);return i}set_cursor(t){this.hit_area.style.cursor=t??"default"}hit_test_frame(t,e,n){return t.frame.bbox.contains(e,n)}hit_test_plot(t,e){for(const n of this.canvas_view.plot_views)if(n.bbox.relative().contains(t,e))return n;return null}_trigger(t,e){if(!this.hit_area.isConnected)return;const{sx:n,sy:i,native:s}=e,r=this.hit_test_plot(n,i),_=t=>{const[s,r]=[n,i];return{...e,sx:s,sy:r}};if("pan_start"==e.type||"pan"==e.type||"pan_end"==e.type){let n;if("pan_start"==e.type&&null!=r?(this._curr_pan={plot_view:r},n=r):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"pan_end"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinch_start"==e.type||"pinch"==e.type||"pinch_end"==e.type){let n;if("pinch_start"==e.type&&null!=r?(this._curr_pinch={plot_view:r},n=r):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinch_end"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotate_start"==e.type||"rotate"==e.type||"rotate_end"==e.type){let n;if("rotate_start"==e.type&&null!=r?(this._curr_rotate={plot_view:r},n=r):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotate_end"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("enter"==e.type||"move"==e.type||"leave"==e.type){const o=this._prev_move?.plot_view;if(null!=o&&("leave"==e.type||o!=r)){const{sx:t,sy:e}=_();this.__trigger(o,this.move_exit,{type:"leave",sx:t,sy:e,modifiers:{shift:!1,ctrl:!1,alt:!1},native:s},s)}if(null!=r&&("enter"==e.type||o!=r)){const{sx:t,sy:e}=_();this.__trigger(r,this.move_enter,{type:"enter",sx:t,sy:e,modifiers:{shift:!1,ctrl:!1,alt:!1},native:s},s)}if(null!=r&&"move"==e.type){const e=_();this.__trigger(r,t,e,s)}this._prev_move={sx:n,sy:i,plot_view:r}}else if(null!=r){const e=_();this.__trigger(r,t,e,s)}}__trigger(t,e,n,i){const s=t.model.toolbar.gestures,r=e.name,_=r.split(":")[0],o=this.hit_test_renderers(t,n.sx,n.sy);if("pan"==_){const t=n;if(null!=this._current_pan_view)return"pan"==r?this._current_pan_view.on_pan(t):"pan:end"==r&&(this._current_pan_view.on_pan_end(t),this.set_cursor(this._current_pan_view.cursor(t.sx,t.sy)),this._current_pan_view=null),void i.preventDefault();if("pan:start"==r)for(const e of o)if(v(e)&&e.on_pan_start(t))return this._current_pan_view=e,void i.preventDefault()}else if("pinch"==_){const t=n;if(null!=this._current_pinch_view)return"pinch"==r?this._current_pinch_view.on_pinch(t):"pinch:end"==r&&(this._current_pinch_view.on_pinch_end(t),this._current_pinch_view=null),void i.preventDefault();if("pinch:start"==r)for(const e of o)if(d(e)&&e.on_pinch_start(t))return this._current_pinch_view=e,void i.preventDefault()}else if("rotate"==_){const t=n;if(null!=this._current_rotate_view)return"rotate"==r?this._current_rotate_view.on_rotate(t):"rotate:end"==r&&(this._current_rotate_view.on_rotate_end(t),this._current_rotate_view=null),void i.preventDefault();if("rotate:start"==r)for(const e of o)if(g(e)&&e.on_rotate_start(t))return this._current_rotate_view=e,void i.preventDefault()}else if("move"==_){const t=n,e=new Set(o),i=new Set(this._current_move_views);this._current_move_views=[];for(const n of i)e.has(n)||(i.delete(n),n.on_leave(t));for(const e of o)p(e)&&(i.has(e)?(this._current_move_views.push(e),e.on_move(t)):e.on_enter(n)&&this._current_move_views.push(e))}function a(e){return null!=e?t.tool_views.get(e.underlying)??null:null}const h=o.at(0);switch(_){case"move":{const i=s.move.active;null!=i&&this.trigger(e,n,i);const r=t.model.toolbar.inspectors.filter((t=>t.active)),_=(()=>{const e=this._current_interactive_tool_view??this._current_pan_view??this._current_pinch_view??this._current_rotate_view??this._current_move_views.at(0)??h??a(i);if(null!=e){const t=e.cursor(n.sx,n.sy);if(null!=t)return t}return this.hit_test_frame(t,n.sx,n.sy)&&!(0,u.is_empty)(r)?"crosshair":null})();this.set_cursor(_),r.map((t=>this.trigger(e,n,t)));break}case"tap":{const r=i.composedPath();if(0!=r.length&&r[0]!=this.hit_area)return;if(h?.on_hit?.(n.sx,n.sy),this.hit_test_frame(t,n.sx,n.sy)){const t=s.tap.active;null!=t&&this.trigger(e,n,t)}break}case"doubletap":if(this.hit_test_frame(t,n.sx,n.sy)){const t=s.doubletap.active??s.tap.active;null!=t&&this.trigger(e,n,t)}break;case"press":if(this.hit_test_frame(t,n.sx,n.sy)){const t=s.press.active??s.tap.active;null!=t&&this.trigger(e,n,t)}break;case"pinch":{const t=s.pinch.active??s.scroll.active;null!=t&&this.trigger(e,n,t)&&(i.preventDefault(),i.stopPropagation());break}case"scroll":{const t=s.scroll.active;null!=t&&this.trigger(e,n,t)&&(i.preventDefault(),i.stopPropagation());break}case"pan":{const t=s.pan.active,_=a(t);if(null!=_){switch(r){case"pan:start":this._current_interactive_tool_view=_;break;case"pan:end":this._current_interactive_tool_view=null}this.trigger(e,n,t)&&(i.preventDefault(),i.stopPropagation());const s=_.cursor(n.sx,n.sy);this.set_cursor(s)}break}default:{const t=s[_].active;null!=t&&this.trigger(e,n,t)}}this._trigger_bokeh_event(t,n)}trigger(t,e,n=null){const i=n=>{const i=this._tools.get(n);if(null==i)return!1;const s=(()=>{switch(t){case this.pan_start:return i._pan_start;case this.pan:return i._pan;case this.pan_end:return i._pan_end;case this.pinch_start:return i._pinch_start;case this.pinch:return i._pinch;case this.pinch_end:return i._pinch_end;case this.rotate_start:return i._rotate_start;case this.rotate:return i._rotate;case this.rotate_end:return i._rotate_end;case this.move_enter:return i._move_enter;case this.move:return i._move;case this.move_exit:return i._move_exit;case this.tap:return i._tap;case this.doubletap:return i._doubletap;case this.press:return i._press;case this.pressup:return i._pressup;case this.scroll:return i._scroll;case this.keydown:return i._keydown;case this.keyup:return i._keyup;default:return null}})();if(null==s)return!1;const r=s.bind(i)(e);return!(0,l.isBoolean)(r)||r};if(null!=n)return i(n);{let t=!1;for(const e of this._tools.keys()){const n=i(e);t||(t=n)}return t}}_trigger_bokeh_event(t,e){const n=(()=>{const{sx:n,sy:i,modifiers:s}=e,r=t.frame.x_scale.invert(n),_=t.frame.y_scale.invert(i);switch(e.type){case"wheel":return new h.MouseWheel(n,i,r,_,e.delta,s);case"enter":return new h.MouseEnter(n,i,r,_,s);case"move":return new h.MouseMove(n,i,r,_,s);case"leave":return new h.MouseLeave(n,i,r,_,s);case"tap":return new h.Tap(n,i,r,_,s);case"double_tap":return new h.DoubleTap(n,i,r,_,s);case"press":return new h.Press(n,i,r,_,s);case"press_up":return new h.PressUp(n,i,r,_,s);case"pan_start":return new h.PanStart(n,i,r,_,s);case"pan":return new h.Pan(n,i,r,_,e.dx,e.dy,s);case"pan_end":return new h.PanEnd(n,i,r,_,s);case"pinch_start":return new h.PinchStart(n,i,r,_,s);case"pinch":return new h.Pinch(n,i,r,_,e.scale,s);case"pinch_end":return new h.PinchEnd(n,i,r,_,s);case"rotate_start":return new h.RotateStart(n,i,r,_,s);case"rotate":return new h.Rotate(n,i,r,_,e.rotation,s);case"rotate_end":return new h.RotateEnd(n,i,r,_,s);default:return null}})();null!=n&&t.model.trigger_event(n)}_get_sxy(t){const{pageX:e,pageY:n}=t,{left:i,top:s}=(0,a.offset_bbox)(this.hit_area);return{sx:e-i,sy:n-s}}_get_modifiers(t){return{shift:t.shiftKey,ctrl:t.ctrlKey,alt:t.altKey}}_scroll_event(t){return{type:t.type,...this._get_sxy(t),delta:(0,c.getDeltaY)(t),modifiers:this._get_modifiers(t),native:t}}_key_event(t){return{type:t.type,key:t.key,modifiers:this._get_modifiers(t),native:t}}on_tap(t){this._trigger(this.tap,t)}on_doubletap(t){this._trigger(this.doubletap,t)}on_press(t){this._trigger(this.press,t)}on_pressup(t){this._trigger(this.pressup,t)}on_enter(t){this._trigger(this.move_enter,t)}on_move(t){this._trigger(this.move,t)}on_leave(t){this._trigger(this.move_exit,t)}on_pan_start(t){this._trigger(this.pan_start,t)}on_pan(t){this._trigger(this.pan,t)}on_pan_end(t){this._trigger(this.pan_end,t)}on_pinch_start(t){this._trigger(this.pinch_start,t)}on_pinch(t){this._trigger(this.pinch,t)}on_pinch_end(t){this._trigger(this.pinch_end,t)}on_rotate_start(t){this._trigger(this.rotate_start,t)}on_rotate(t){this._trigger(this.rotate,t)}on_rotate_end(t){this._trigger(this.rotate_end,t)}on_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t))}on_context_menu(t){}on_key_down(t){this.trigger(this.keydown,this._key_event(t))}on_key_up(t){this.trigger(this.keyup,this._key_event(t))}on_focus(){this.focus.emit()}on_blur(){this.blur.emit()}}n.UIEventBus=w,w.__name__="UIEventBus"},
function _(t,e,n,a,r){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function o(t){const e=getComputedStyle(t).fontSize,n=parseInt(e,10);return isNaN(n)?null:n}a(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=o((n=t.target).offsetParent??document.body)??o(n)??16;break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n;return e}},
function _(e,t,o,i,l){i(),o.layer="bk-layer",o.events="bk-events",o.default='.bk-layer{position:absolute;top:0;left:0;width:100%;height:100%;overflow:hidden;}.bk-events{display:grid;grid-template-areas:".    above  .    " "left center right" ".    below  .    ";touch-action:none;overflow:visible;cursor:default;}.bk-events:focus,.bk-events:focus-visible{outline:var(--outline-width) var(--outline-style) var(--highlight-color);outline-offset:-1px;}'},
function _(e,o,n,t,s){var _;t();const i=e(122),u=e(308);class a extends i.MenuView{_compute_menu_items(){const{items:e}=this.model.toolbar.to_menu();return e}connect_signals(){super.connect_signals();const{toolbar:e}=this.model.properties;this.on_transitive_change(e,(()=>this._update_menu_items()))}}n.ToolMenuView=a,a.__name__="ToolMenuView";class l extends i.Menu{constructor(e){super(e)}}n.ToolMenu=l,_=l,l.__name__="ToolMenu",_.prototype.default_view=a,_.define((({Ref:e})=>({toolbar:[e(u.Toolbar)]})))},
function _(e,t,i,o,s){var l;o();const n=e(96),a=e(308),r=e(69),h=e(187);class _ extends n.AnnotationView{update_layout(){this.layout=new h.SideLayout(this.panel,(()=>this.get_size()),!0)}after_layout(){this.toolbar_view.after_render()}has_finished(){return super.has_finished()&&this.toolbar_view.has_finished()}*children(){yield*super.children(),yield this.toolbar_view}async lazy_initialize(){await super.lazy_initialize(),this.toolbar_view=await(0,r.build_view)(this.model.toolbar,{parent:this.canvas})}connect_signals(){super.connect_signals(),this.plot_view.mouseenter.connect((()=>{this.toolbar_view.set_visibility(!0)})),this.plot_view.mouseleave.connect((()=>{this.toolbar_view.set_visibility(!1)})),this.plot_view.canvas.ui_event_bus.focus.connect((()=>{this.toolbar_view.toggle_auto_scroll(!0)})),this.plot_view.canvas.ui_event_bus.blur.connect((()=>{this.toolbar_view.toggle_auto_scroll(!1)}))}remove(){this.toolbar_view.remove(),super.remove()}render(){super.render(),this.toolbar_view.render_to(this.shadow_el)}get is_horizontal(){return this.toolbar_view.model.horizontal}_paint(){const{style:e}=this.toolbar_view.el;this.is_horizontal?(e.width="100%",e.height="unset"):(e.width="unset",e.height="100%"),this.is_horizontal?(this.el.style.minWidth="0",this.el.style.minHeight="unset"):(this.el.style.minWidth="unset",this.el.style.minHeight="0")}_get_size(){const{tools:e,logo:t}=this.model.toolbar;return{width:30*e.length+(null!=t?25:0)+15,height:30}}}i.ToolbarPanelView=_,_.__name__="ToolbarPanelView";class u extends n.Annotation{constructor(e){super(e)}}i.ToolbarPanel=u,l=u,u.__name__="ToolbarPanel",l.prototype.default_view=_,l.define((({Ref:e})=>({toolbar:[e(a.Toolbar)]})))},
function _(e,t,s,o,n){var i;o();const r=e(1),a=e(132),l=e(58),h=e(57),c=e(124),p=r.__importStar(e(127)),_=e(61),d=r.__importStar(e(336));class u extends a.PaneView{stylesheets(){return[...super.stylesheets(),d.default]}connect_signals(){super.connect_signals();const{position:e,anchor:t,width:s,height:o,elements:n}=this.model.properties;this.on_change([t,s,o,n],(()=>this.reposition())),this.on_transitive_change(e,(()=>this.reposition()))}reposition(e){super.reposition(e);const{position:t,visible:s,anchor:o,elements:n}=this.model;if(0==e||!s||0==n.length)return void this.el.remove();const{x:i,y:r}=this.resolve_as_xy(t);if(!isFinite(i+r))return void this.el.remove();const a=this.parent?.el??document.body,l=a.shadowRoot??a;this.el.isConnected||l.append(this.el),this.el.style.left=(0,_.px)(i),this.el.style.top=(0,_.px)(r);const h=p.anchor(o);this.el.style.transform=`translate(${-100*h.x}%, ${-100*h.y}%)`}}s.PanelView=u,u.__name__="PanelView";class m extends a.Pane{constructor(e){super(e)}}s.Panel=m,i=m,m.__name__="Panel",i.prototype.default_view=u,i.define((({Ref:e,Or:t,Auto:s,Int:o})=>({position:[e(l.Coordinate)],anchor:[c.Anchor,"top_left"],width:[t(s,o,e(h.Node)),"auto"],height:[t(s,o,e(h.Node)),"auto"]})))},
function _(o,a,c,n,r){n(),c.default=":host{position:absolute;background-color:var(--background-color);}"},
function _(e,a,_,n,t){var l,s,i,m;n();const w=e(134);class o extends w.DOMElementView{}_.SpanView=o,o.__name__="SpanView",o.tag_name="span";class d extends w.DOMElement{}_.Span=d,l=d,d.__name__="Span",l.prototype.default_view=o;class p extends w.DOMElementView{}_.DivView=p,p.__name__="DivView",p.tag_name="div";class D extends w.DOMElement{}_.Div=D,s=D,D.__name__="Div",s.prototype.default_view=p;class V extends w.DOMElementView{}_.TableView=V,V.__name__="TableView",V.tag_name="table";class c extends w.DOMElement{}_.Table=c,i=c,c.__name__="Table",i.prototype.default_view=V;class v extends w.DOMElementView{}_.TableRowView=v,v.__name__="TableRowView",v.tag_name="tr";class b extends w.DOMElement{}_.TableRow=b,m=b,b.__name__="TableRow",m.prototype.default_view=v},
function _(n,t,e,l,u){l(),e.throttle=function(n,t){let e,l=null,u=null,o=0,i=!1;const r=function(){return new Promise(((r,c)=>{e=r;const a=function(){o=Date.now(),l=null,u=null,i=!1;try{n(),r()}catch(n){c(n)}},m=Date.now(),s=t-(m-o);s<=0&&!i?(null!=l&&clearTimeout(l),i=!0,u=requestAnimationFrame(a)):null!=l||i?r():l=setTimeout((()=>u=requestAnimationFrame(a)),s)}))};return r.stop=function(){null!=l&&clearTimeout(l),null!=u&&cancelAnimationFrame(u),e()},r}},
function _(t,n,a,e,s){e();const o=t(118),r=t(20);class i{constructor(t){this.warn_initial_ranges=!0,this.invalidate_dataranges=!0,this.parent=t}get frame(){return this.parent.frame}update(t,n={}){const a=n.panning??!1,e=n.scrolling??!1,s=n.maintain_focus??!1,o=new Map;for(const[n,a]of t.xrs)o.set(n,a);for(const[n,a]of t.yrs)o.set(n,a);e&&s&&this._update_ranges_together(o),this._update_ranges_individually(o,{panning:a,scrolling:e,maintain_focus:s})}ranges(){const t=new Set,n=new Set;for(const n of this.frame.x_ranges.values())t.add(n);for(const t of this.frame.y_ranges.values())n.add(t);for(const a of this.parent.model.data_renderers){const{coordinates:e}=a;null!=e&&(t.add(e.x_source),n.add(e.y_source))}return{x_ranges:[...t],y_ranges:[...n]}}reset(){const{x_ranges:t,y_ranges:n}=this.ranges();for(const n of t)n.reset();for(const t of n)t.reset();this.update_dataranges()}_update_dataranges(t){const n=new Map,a=new Map;let e=!1;for(const[,n]of t.x_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(e=!0);for(const[,n]of t.y_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(e=!0);for(const t of this.parent.auto_ranged_renderers){const s=t.bounds(this.parent.model.window_axis);if(n.set(t.model,s),e){const n=t.log_bounds();a.set(t.model,n)}}let s=!1,i=!1;const l=t.x_target.span,d=t.y_target.span;let _;!1!==this.parent.model.match_aspect&&0!=l&&0!=d&&(_=1/this.parent.model.aspect_scale*(l/d));for(const[,e]of t.x_ranges){if(e instanceof o.DataRange1d){const t="log"==e.scale_hint?a:n;e.update(t,0,this.parent,_),null!=e.follow&&(s=!0)}null!=e.bounds&&(i=!0)}for(const[,e]of t.y_ranges){if(e instanceof o.DataRange1d){const t="log"==e.scale_hint?a:n;e.update(t,1,this.parent,_),null!=e.follow&&(s=!0)}null!=e.bounds&&(i=!0)}if(s&&i){r.logger.warn("Follow enabled so bounds are unset.");for(const[,n]of t.x_ranges)n.bounds=null;for(const[,n]of t.y_ranges)n.bounds=null}}update_dataranges(){this._update_dataranges(this.frame);for(const t of this.parent.auto_ranged_renderers){const{coordinates:n}=t.model;null!=n&&this._update_dataranges(n)}null!=this.compute_initial()&&(this.invalidate_dataranges=!1)}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:a}=this.frame,e=new Map,s=new Map;for(const[,a]of n){const{start:n,end:s}=a;if(isNaN(n+s)){t=!1;break}e.set(a,{start:n,end:s})}if(t)for(const[,n]of a){const{start:a,end:e}=n;if(isNaN(a+e)){t=!1;break}s.set(n,{start:a,end:e})}return t?{xrs:e,yrs:s}:(this.warn_initial_ranges&&r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[a,e]of t)n=Math.min(n,this._get_weight_to_constrain_interval(a,e));if(n<1)for(const[a,e]of t)e.start=n*e.start+(1-n)*a.start,e.end=n*e.end+(1-n)*a.end}_update_ranges_individually(t,n){const{panning:a,scrolling:e,maintain_focus:s}=n;let o=!1;for(const[n,r]of t){if(!e||s){const t=this._get_weight_to_constrain_interval(n,r);t<1&&(r.start=t*r.start+(1-t)*n.start,r.end=t*r.end+(1-t)*n.end)}if(null!=n.bounds){const[t,s]=n.computed_bounds,i=Math.abs(r.end-r.start);n.is_reversed?(t>r.end&&(o=!0,r.end=t,(a||e)&&(r.start=t+i)),s<r.start&&(o=!0,r.start=s,(a||e)&&(r.end=s-i))):(t>r.start&&(o=!0,r.start=t,(a||e)&&(r.end=t+i)),s<r.end&&(o=!0,r.end=s,(a||e)&&(r.start=s-i)))}}if(!(e&&o&&s))for(const[n,a]of t)n.have_updated_interactively=!0,n.start==a.start&&n.end==a.end||n.setv(a)}_get_weight_to_constrain_interval(t,n){const{min_interval:a}=t;let{max_interval:e}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,a]=t.bounds;if(null!=n&&null!=a){const t=Math.abs(a-n);e=null!=e?Math.min(e,t):t}}let s=1;if(null!=a||null!=e){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=a&&a>0&&r<a&&(s=(o-a)/(o-r)),null!=e&&e>0&&r>e&&(s=(e-o)/(r-o)),s=Math.max(0,Math.min(1,s))}return s}}a.RangeManager=i,i.__name__="RangeManager"},
function _(t,i,e,s,n){s();const h=t(16);class a{constructor(t,i){this.history=[],this.index=-1,this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed")}_do_state_change(t){const i=t in this.history?this.history[t].state:this.initial_state;return null!=i.range&&this.parent.update_range(i.range),null!=i.selection&&this.parent.update_selection(i.selection),i}peek(){return this.can_undo?this.history[this.index]:null}push(t,i){const{history:e,index:s}=this,n=s in e?e[s].state:{},h={...this.initial_state,...n,...i};this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){if(this.can_undo){this.index-=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}redo(){if(this.can_redo){this.index+=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}e.StateManager=a,a.__name__="StateManager"},
function _(a,r,t,e,n){e(),t.Canvas="bk-Canvas",t.default=':host{display:grid;grid-template-areas:".    above  .    " "left center right" ".    below  .    ";grid-template-rows:0px 1fr 0px;grid-template-columns:0px 1fr 0px;}.bk-Canvas{grid-row-start:1;grid-row-end:span 3;grid-column-start:1;grid-column-end:span 3;}'},
function _(o,e,i,a,l){a(),i.default=":host{display:flex;flex-direction:column;flex-wrap:nowrap;padding:2px;background-color:rgba(255, 255, 255, 0.5);font-size:0.5625rem;line-height:1.05;white-space:nowrap;max-width:var(--max-width);}:host > *{overflow:hidden;text-overflow:ellipsis;text-align:right;}a{color:var(--color);}"},
function _(s,e,i,t,r){var n;t();const c=s(1),o=s(305),a=c.__importStar(s(243)),h=s(13),l=s(144);class d extends o.RadialGlyphView{async load_glglyph(){const{CircleGL:e}=await Promise.resolve().then((()=>c.__importStar(s(587))));return e}_paint(s,e,i){const{sx:t,sy:r,sradius:n}={...this,...i};for(const i of e){const e=t[i],c=r[i],o=n[i];isFinite(e+c+o)&&(s.beginPath(),s.arc(e,c,o,0,2*Math.PI,!1),this.visuals.fill.apply(s,i),this.visuals.hatch.apply(s,i),this.visuals.line.apply(s,i))}}_hit_point(s){const{sx:e,sy:i}=s,t=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),{hit_dilation:n}=this.model,[c,o,a,h]=(()=>{if("data"==this.model.properties.radius.units){const s=this.max_radius*n;return[t-s,t+s,r-s,r+s]}{const s=this.max_radius*n,t=e-s,r=e+s,c=i-s,o=i+s,[a,h]=this.renderer.xscale.r_invert(t,r),[l,d]=this.renderer.yscale.r_invert(c,o);return[a,h,l,d]}})(),d=this.index.indices({x0:c,x1:o,y0:a,y1:h}),_=[];if("data"==this.model.properties.radius.units)for(const s of d){const e=(this.sradius[s]*n)**2,[i,c]=this.renderer.xscale.r_compute(t,this.x[s]),[o,a]=this.renderer.yscale.r_compute(r,this.y[s]);(i-c)**2+(o-a)**2<=e&&_.push(s)}else for(const s of d){const t=(this.sradius[s]*n)**2;(this.sx[s]-e)**2+(this.sy[s]-i)**2<=t&&_.push(s)}return new l.Selection({indices:_})}_hit_span(s){const{sx:e,sy:i}=s,t=this.bounds(),[r,n,c,o]=(()=>{const r=this.max_radius;if("h"==s.direction){const s=e-r,i=e+r,[n,c]=this.renderer.xscale.r_invert(s,i),{y0:o,y1:a}=t;return[n,c,o,a]}{const s=i-r,e=i+r,{x0:n,x1:c}=t,[o,a]=this.renderer.yscale.r_invert(s,e);return[n,c,o,a]}})(),a=[...this.index.indices({x0:r,x1:n,y0:c,y1:o})];return new l.Selection({indices:a})}_hit_rect(s){const{sx0:e,sx1:i,sy0:t,sy1:r}=s,[n,c]=this.renderer.xscale.r_invert(e,i),[o,a]=this.renderer.yscale.r_invert(t,r),h=this.index.indices({x0:n,x1:c,y0:o,y1:a}),d=[];for(const s of h){const n=this.sx[s],c=this.sy[s];e<=n&&n<=i&&t<=c&&c<=r&&d.push(s)}return new l.Selection({indices:d})}_hit_poly(s){const{sx:e,sy:i}=s,t=(()=>{const[s,t,r,n]=(0,h.minmax2)(e,i),[c,o]=this.renderer.xscale.r_invert(s,t),[a,l]=this.renderer.yscale.r_invert(r,n);return this.index.indices({x0:c,x1:o,y0:a,y1:l})})(),r=[];for(const s of t)a.point_in_poly(this.sx[s],this.sy[s],e,i)&&r.push(s);return new l.Selection({indices:r})}}i.CircleView=d,d.__name__="CircleView";class _ extends o.RadialGlyph{constructor(s){super(s)}}i.Circle=_,n=_,_.__name__="Circle",n.prototype.default_view=d,n.define((({Float:s})=>({hit_dilation:[s,1]})))},
function _(o,l,e,i,t){var n;i();const s=o(1),a=o(96),_=s.__importStar(o(95));class c extends a.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_paint()))}_paint(o){const{gradient:l,y_intercept:e}=this.model;if(null==l||null==e)return;const{frame:i}=this.plot_view,t=this.coordinates.x_scale,n=this.coordinates.y_scale,[s,a,_,c]=(()=>{if(0==l){const o=n.compute(e),l=o;return[i.bbox.left,i.bbox.right,o,l]}{const o=i.bbox.top,s=i.bbox.bottom,a=n.invert(o),_=n.invert(s),c=(a-e)/l,h=(_-e)/l,b=t.compute(c),r=t.compute(h);return b<=r?[b,r,o,s]:[r,b,s,o]}})();if(o.save(),this.visuals.above_fill.doit||this.visuals.above_hatch.doit){const{left:l,right:e,top:t,bottom:n}=i.bbox;o.beginPath(),o.moveTo(s,_),o.lineTo(s,_),o.lineTo(a,c),o.lineTo(a,c),_<=c?(a<e&&o.lineTo(e,n),o.lineTo(e,t),o.lineTo(l,t)):(o.lineTo(e,t),o.lineTo(l,t),s>l&&o.lineTo(l,n)),o.closePath(),this.visuals.above_fill.apply(o),this.visuals.above_hatch.apply(o)}if(this.visuals.below_fill.doit||this.visuals.below_hatch.doit){const{left:l,right:e,top:t,bottom:n}=i.bbox;o.beginPath(),o.moveTo(s,_),o.lineTo(s,_),o.lineTo(a,c),_<=c?(o.lineTo(e,n),o.lineTo(l,n),s>l&&o.lineTo(l,t)):(a<e&&o.lineTo(e,t),o.lineTo(e,n),o.lineTo(l,n)),o.closePath(),this.visuals.below_fill.apply(o),this.visuals.below_hatch.apply(o)}o.beginPath(),o.moveTo(s,_),o.lineTo(a,c),this.visuals.line.apply(o),o.restore()}}e.SlopeView=c,c.__name__="SlopeView";class h extends a.Annotation{constructor(o){super(o)}}e.Slope=h,n=h,h.__name__="Slope",n.prototype.default_view=c,n.mixins([_.Line,["above_",_.Fill],["above_",_.Hatch],["below_",_.Fill],["below_",_.Hatch]]),n.define((({Float:o,Nullable:l})=>({gradient:[l(o),null],y_intercept:[l(o),null]}))),n.override({line_color:"black",above_fill_color:null,above_fill_alpha:.4,below_fill_color:null,below_fill_alpha:.4})},
function _(t,e,i,n,s){var o;n();const a=t(1),l=t(96),r=a.__importStar(t(95)),h=t(21),_=t(243),c=t(16),d=t(12);class u{constructor(t,e){this.p0=t,this.p1=e}clone(){return new u({...this.p0},{...this.p1})}hit_test(t,e=2.5){return(0,_.dist_to_segment)(t,this.p0,this.p1)<e}translate(t,e){const{p0:i,p1:n}=this,s={x:i.x+t,y:i.y+e},o={x:n.x+t,y:n.y+e};return new u(s,o)}}u.__name__="Line";class p extends l.AnnotationView{constructor(){super(...arguments),this._pan_state=null,this._is_hovered=!1}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_paint(this)))}_paint(t){const{location:e,location_units:i}=this.model;if(null==e)return;function n(t,e,i,n,s){switch(e){case"canvas":return s.compute(t);case"screen":return n.compute(t);case"data":return i.compute(t)}}const{frame:s,canvas:o}=this.plot_view,{x_scale:a,y_scale:l}=this.coordinates;let r,h,_,c;"width"==this.model.dimension?(_=n(e,i,l,s.bbox.yview,o.bbox.y_screen),h=s.bbox.left,c=s.bbox.width,r=this.model.line_width):(_=s.bbox.top,h=n(e,i,a,s.bbox.xview,o.bbox.y_screen),c=this.model.line_width,r=s.bbox.height);const d={x:h,y:_},p={x:h+c,y:_+r};this.line=new u(d,p);const{_is_hovered:m,visuals:v}=this,b=m&&v.hover_line.doit?v.hover_line:v.line;t.save(),t.beginPath(),this.visuals.line.set_value(t),t.moveTo(h,_),"width"==this.model.dimension?t.lineTo(h+c,_):t.lineTo(h,_+r),b.apply(t),t.restore()}interactive_hit(t,e){return!(!this.model.visible||!this.model.editable)&&null!=this._hit_test(t,e)}_hit_test(t,e){const i=Math.max(2.5,this.model.line_width/2);return this.line.hit_test({x:t,y:e},i)?"edge":null}_can_hit(t){return!0}on_pan_start(t){if(this.model.visible&&this.model.editable){const{sx:e,sy:i}=t,n=this._hit_test(e,i);if(null!=n&&this._can_hit(n))return this._pan_state={line:this.line.clone(),target:n},this.model.pan.emit(["pan:start",t.modifiers]),!0}return!1}on_pan(t){function e(t,e,i,n,s){switch(e){case"canvas":return s.invert(t);case"screen":return n.invert(t);case"data":return i.invert(t)}}(0,d.assert)(null!=this._pan_state);const i=(()=>{const{dx:e,dy:i}=t,{line:n}=this._pan_state;return"width"==this.model.dimension?n.translate(0,i).p0.y:n.translate(e,0).p0.x})(),n=(()=>{const{location_units:t}=this.model,{frame:n,canvas:s}=this.plot_view,{x_scale:o,y_scale:a}=this.coordinates;return"width"==this.model.dimension?e(i,t,a,n.bbox.yview,s.bbox.y_screen):e(i,t,o,n.bbox.xview,s.bbox.y_screen)})();this.model.location=n,this.model.pan.emit(["pan",t.modifiers])}on_pan_end(t){this._pan_state=null,this.model.pan.emit(["pan:end",t.modifiers])}get _has_hover(){const{hover_line:t}=this.visuals;return t.doit}on_enter(t){const{_has_hover:e}=this;return e&&(this._is_hovered=!0,this.request_paint()),e}on_move(t){}on_leave(t){this._has_hover&&(this._is_hovered=!1,this.request_paint())}cursor(t,e){const i=this._pan_state?.target??this._hit_test(t,e);return null!=i&&this._can_hit(i)?"width"==this.model.dimension?"ns-resize":"ew-resize":null}}i.SpanView=p,p.__name__="SpanView";class m extends l.Annotation{constructor(t){super(t),this.pan=new c.Signal(this,"pan")}}i.Span=m,o=m,m.__name__="Span",o.prototype.default_view=p,o.mixins([r.Line,["hover_",r.Line]]),o.define((({Bool:t,Float:e,Nullable:i})=>({location:[i(e),null],location_units:[h.CoordinateUnits,"data"],dimension:[h.Dimension,"width"],editable:[t,!1]}))),o.override({line_color:"black",hover_line_color:null,hover_line_alpha:.3})},
function _(e,t,i,s,a){var l;s();const r=e(274),_=e(182),h=e(25),n=e(69),o=e(95);class d extends r.UpperLowerView{*children(){yield*super.children();const{lower_head:e,upper_head:t}=this;null!=e&&(yield e),null!=t&&(yield t)}async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model;null!=e&&(this.lower_head=await(0,n.build_view)(e,{parent:this})),null!=t&&(this.upper_head=await(0,n.build_view)(t,{parent:this}))}set_data(e){super.set_data(e);const t=h.Indices.all_set(this._lower.length);this.lower_head?.set_data(e,t),this.upper_head?.set_data(e,t)}_paint_data(e){if(this.visuals.line.doit)for(let t=0,i=this._lower_sx.length;t<i;t++)e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),this.visuals.line.apply(e,t);const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let i=0,s=this._lower_sx.length;i<s;i++)e.save(),e.translate(this._lower_sx[i],this._lower_sy[i]),e.rotate(t+Math.PI),this.lower_head.paint(e,i),e.restore();if(null!=this.upper_head)for(let i=0,s=this._upper_sx.length;i<s;i++)e.save(),e.translate(this._upper_sx[i],this._upper_sy[i]),e.rotate(t),this.upper_head.paint(e,i),e.restore()}}i.WhiskerView=d,d.__name__="WhiskerView";class p extends r.UpperLower{constructor(e){super(e)}}i.Whisker=p,l=p,p.__name__="Whisker",l.prototype.default_view=d,l.mixins(o.LineVector),l.define((({Ref:e,Nullable:t})=>({lower_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})],upper_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})]}))),l.override({level:"underlay"})},
function _(L,e,T,l,H){l(),H("HTMLLabel",L(348).HTMLLabel),H("HTMLLabelSet",L(350).HTMLLabelSet),H("HTMLTitle",L(351).HTMLTitle)},
function _(t,e,s,i,o){var n;i();const a=t(1),l=t(349),r=t(11),_=t(21),u=t(192),c=t(187),d=a.__importStar(t(95));class h extends l.TextAnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new c.SideLayout(t,(()=>this.get_size()),!1):void 0}_get_size(){const{text:t}=this.model,e=new u.TextBox({text:t}),{angle:s,angle_units:i}=this.model;e.angle=(0,r.compute_angle)(s,i),e.visuals=this.visuals.text.values();const o=e.size(),{padding:n}=this;return{width:o.width+n.left+n.right,height:o.height+n.top+n.bottom}}_paint(t){const{angle:e,angle_units:s}=this.model,i=(0,r.compute_angle)(e,s),o=null!=this.layout?this.layout:this.plot_view.frame,n=this.coordinates.x_scale,a=this.coordinates.y_scale;let l=(()=>{switch(this.model.x_units){case"canvas":return this.model.x;case"screen":return o.bbox.xview.compute(this.model.x);case"data":return n.compute(this.model.x)}})(),_=(()=>{switch(this.model.y_units){case"canvas":return this.model.y;case"screen":return o.bbox.yview.compute(this.model.y);case"data":return a.compute(this.model.y)}})();l+=this.model.x_offset,_-=this.model.y_offset,this._paint_text(t,this.model.text,l,_,i)}}s.HTMLLabelView=h,h.__name__="HTMLLabelView";class m extends l.TextAnnotation{constructor(t){super(t)}}s.HTMLLabel=m,n=m,m.__name__="HTMLLabel",n.prototype.default_view=h,n.mixins([d.Text,["border_",d.Line],["background_",d.Fill],["background_",d.Hatch]]),n.define((({Float:t,Str:e,Angle:s})=>({x:[t],x_units:[_.CoordinateUnits,"data"],y:[t],y_units:[_.CoordinateUnits,"data"],text:[e,""],angle:[s,0],angle_units:[_.AngleUnits,"rad"],x_offset:[t,0],y_offset:[t,0]}))),n.override({background_fill_color:null,background_hatch_color:null,border_line_color:null})},
function _(t,e,n,i,s){var o;i();const r=t(1),a=t(96),l=t(61),d=t(187),p=t(124),h=r.__importStar(t(127));class u extends a.AnnotationView{rendering_target(){return this.plot_view.canvas_view.overlays_el}update_layout(){const{panel:t}=this;this.layout=null!=t?new d.SideLayout(t,(()=>this.get_size()),!0):void 0}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.paint(this.layer.ctx)))}paint(t){this.model.visible?super.paint(t):(0,l.undisplay)(this.el)}get padding(){return h.padding(this.model.padding)}get border_radius(){return h.border_radius(this.model.border_radius)}render(){super.render(),this.text_el=document.createTextNode(""),this.shadow_el.append(this.text_el)}_paint_text(t,e,n,i,s){const{el:o}=this;(0,l.undisplay)(o),this.text_el.textContent=e,this.visuals.text.set_value(t);const{padding:r,border_radius:a}=this;if(null!=this.layout)this.position.replace("\n      :host {\n        position: relative;\n      }\n      ");else{const t=this.plot_view.frame,[e,s]=t.bbox.relativize(n,i);this.position.replace(`\n      :host {\n        position: absolute;\n        left: ${e}px;\n        top: ${s}px;\n      }\n      `)}if(this.style.replace(`\n    :host {\n      width: max-content;\n      height: max-content;\n\n      color: ${t.fillStyle};\n      -webkit-text-stroke: 1px ${t.strokeStyle};\n      font: ${t.font};\n      white-space: pre;\n\n      padding-left: ${r.left}px;\n      padding-right: ${r.right}px;\n      padding-top: ${r.top}px;\n      padding-bottom: ${r.bottom}px;\n\n      border-top-left-radius: ${a.top_left}px;\n      border-top-right-radius: ${a.top_right}px;\n      border-bottom-right-radius: ${a.bottom_right}px;\n      border-bottom-left-radius: ${a.bottom_left}px;\n    }\n    `),null!=this.layout)0!=s&&this.style.append("\n        :host {\n          writing-mode: vertical-rl;\n          rotate: 180deg;\n          align-self: end;\n        }\n        ");else{const t=(()=>{switch(this.visuals.text.text_align.get_value()){case"left":return"0%";case"center":return"50%";case"right":return"100%"}})(),e=(()=>{switch(this.visuals.text.text_baseline.get_value()){case"top":return"0%";case"middle":default:return"50%";case"bottom":return"100%"}})();this.style.append(`\n      :host {\n        transform-origin: ${t} ${e};\n        transform: translate(-${t}, -${e}) rotate(${s}rad);\n      }\n      `)}this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),this.style.append(`\n      :host {\n        background-color: ${t.fillStyle};\n      }\n      `)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),this.style.append(`\n      :host {\n        border-style: ${t.getLineDash().length<2?"solid":"dashed"};\n        border-width: ${t.lineWidth}px;\n        border-color: ${t.strokeStyle};\n      }\n      `)),(0,l.display)(o)}}n.TextAnnotationView=u,u.__name__="TextAnnotationView";class _ extends a.Annotation{constructor(t){super(t)}}n.TextAnnotation=_,o=_,_.__name__="TextAnnotation",o.define((()=>({padding:[p.Padding,0],border_radius:[p.BorderRadius,0]})))},
function _(t,e,s,i,r){var l;i();const a=t(1),o=t(141),n=a.__importStar(t(95)),c=t(21),_=t(61),h=a.__importStar(t(19)),u=t(25),d=t(12);class y extends o.DataAnnotationView{constructor(){super(...arguments),this.els=[]}set_data(t){super.set_data(t),this.els.forEach((t=>t.remove())),this.els=[...this.text.map((()=>(0,_.div)({style:{display:"none"}})))],this.plot_view.canvas_view.overlays_el.append(...this.els)}remove(){this.els.forEach((t=>t.remove())),this.els=[],super.remove()}_rerender(){this.paint(this.layer.ctx)}map_data(){const{x_scale:t,y_scale:e}=this.coordinates,s=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new u.ScreenArray(this._x);case"screen":return s.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new u.ScreenArray(this._y);case"screen":return s.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}_paint_data(t){for(let e=0,s=this.text.length;e<s;e++){const s=this.x_offset.get(e),i=this.y_offset.get(e),r=this.sx[e]+s,l=this.sy[e]-i,a=this.angle.get(e),o=this.text.get(e);isFinite(r+l+a)&&null!=o&&this._paint_text(t,e,o,r,l,a)}}_paint_text(t,e,s,i,r,l){(0,d.assert)(e in this.els);const a=this.els[e];a.textContent=s,this.visuals.text.set_vectorize(t,e),a.style.position="absolute",a.style.left=`${i}px`,a.style.top=`${r}px`,a.style.color=t.fillStyle,a.style.webkitTextStroke=`1px ${t.strokeStyle}`,a.style.font=t.font,a.style.lineHeight="normal",a.style.whiteSpace="pre";const[o,n]=(()=>{switch(this.visuals.text.text_align.get(e)){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[c,h]=(()=>{switch(this.visuals.text.text_baseline.get(e)){case"top":return["top","0%"];case"middle":default:return["center","-50%"];case"bottom":return["bottom","-100%"]}})();let u=`translate(${n}, ${h})`;0!=l&&(u+=`rotate(${l}rad)`),a.style.transformOrigin=`${o} ${c}`,a.style.transform=u,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),a.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),a.style.borderStyle=t.getLineDash().length<2?"solid":"dashed",a.style.borderWidth=`${t.lineWidth}px`,a.style.borderColor=t.strokeStyle),(0,_.display)(a)}}s.HTMLLabelSetView=y,y.__name__="HTMLLabelSetView";class p extends o.DataAnnotation{constructor(t){super(t)}}s.HTMLLabelSet=p,l=p,p.__name__="HTMLLabelSet",l.prototype.default_view=y,l.mixins([n.TextVector,["border_",n.LineVector],["background_",n.FillVector]]),l.define((()=>({x:[h.XCoordinateSpec,{field:"x"}],y:[h.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[h.NullStringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,{value:0}],y_offset:[h.NumberSpec,{value:0}]}))),l.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,o,a){var l;o();const s=t(1),n=t(349),r=t(21),c=t(192),h=s.__importStar(t(95));class _ extends n.TextAnnotationView{_get_location(){const t=this.model.offset,e=this.model.standoff/2;let i,o;const{bbox:a}=this.layout;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":o=a.top+e;break;case"middle":o=a.vcenter;break;case"bottom":o=a.bottom-e}switch(this.model.align){case"left":i=a.left+t;break;case"center":i=a.hcenter;break;case"right":i=a.right-t}break;case"left":switch(this.model.vertical_align){case"top":i=a.left+e;break;case"middle":i=a.hcenter;break;case"bottom":i=a.right-e}switch(this.model.align){case"left":o=a.bottom-t;break;case"center":o=a.vcenter;break;case"right":o=a.top+t}break;case"right":switch(this.model.vertical_align){case"top":i=a.right-e;break;case"middle":i=a.hcenter;break;case"bottom":i=a.left+e}switch(this.model.align){case"left":o=a.top+t;break;case"center":o=a.vcenter;break;case"right":o=a.bottom-t}}return[i,o]}_paint(t){const{text:e}=this.model;if(0==e.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[i,o]=this._get_location(),a=this.panel.get_label_angle_heuristic("parallel");this._paint_text(t,e,i,o,a)}_get_size(){const{text:t}=this.model,e=new c.TextBox({text:t});e.visuals=this.visuals.text.values();const i=e.size(),{padding:o}=this,a=i.width+o.left+o.right,l=i.height+o.top+o.bottom;return{width:a,height:0==l?0:2+l+this.model.standoff}}}i.HTMLTitleView=_,_.__name__="HTMLTitleView";class d extends n.TextAnnotation{constructor(t){super(t)}}i.HTMLTitle=d,l=d,d.__name__="HTMLTitle",l.prototype.default_view=_,l.mixins([h.Text,["border_",h.Line],["background_",h.Fill],["background_",h.Hatch]]),l.define((({Float:t,Str:e})=>({text:[e,""],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[t,0],standoff:[t,10]}))),l.prototype._props.text_align.options.internal=!0,l.prototype._props.text_baseline.options.internal=!0,l.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,background_hatch_color:null,border_line_color:null})},
function _(i,e,l,o,g){o(),g("CustomJS",i(353).CustomJS),g("OpenURL",i(354).OpenURL),g("SetValue",i(355).SetValue),g("ToggleVisibility",i(356).ToggleVisibility),g("OpenDialog",i(357).OpenDialog),g("CloseDialog",i(361).CloseDialog)},
function _(require,module,exports,__esModule,__esExport){var _a;__esModule();const callback_1=require(125),object_1=require(9),array_1=require(10),string_1=require(41),logging_1=require(20),types_1=require(8),standalone_1=require(81);class CustomJS extends callback_1.Callback{constructor(t){super(t),this._state=null}connect_signals(){super.connect_signals();const{args:t,code:e,module:s}=this.properties;this.on_change([t,e,s],(()=>this._state=null))}async _compile_module(){const url=URL.createObjectURL(new Blob([this.code],{type:"text/javascript"}));try{const module=await eval(`import("${url}")`);return(0,types_1.isFunction)(module.default)?module.default:(logging_1.logger.warn("custom ES module didn't export a default function"),()=>{})}finally{URL.revokeObjectURL(url)}}async _compile_function(){const[t=[],e=[]]=(0,array_1.unzip)((0,object_1.entries)(this.args)),s=(0,string_1.use_strict)(this.code),o=new Function(...t,"cb_obj","cb_data","cb_context",s);return function(...t){return o.call(this,...e,...t)}}_is_es_module(t){return t.split("\n").some((t=>t.trimStart().startsWith("export default")))}async _compile(){const t=(()=>"auto"==this.module?this._is_es_module(this.code):this.module)();return t?{func:await this._compile_module(),module:t}:{func:await this._compile_function(),module:t}}async compile(){null==this._state&&(this._state=await this._compile())}async state(){return null==this._state&&(this._state=await this._compile()),this._state}async execute(t,e={}){const{func:s,module:o}=await this.state(),n={index:standalone_1.index};return o?s((0,object_1.to_object)(this.args),t,e,n):s.call(t,t,e,n)}execute_sync(t,e={}){if(null==this._state)throw new Error(`${this.type} needs to be compiled first`);const{func:s,module:o}=this._state,n={index:standalone_1.index};return o?s((0,object_1.to_object)(this.args),t,e,n):s.call(t,t,e,n)}}exports.CustomJS=CustomJS,_a=CustomJS,CustomJS.__name__="CustomJS",_a.define((({Unknown:t,Str:e,Dict:s,Auto:o,Or:n,Bool:i})=>({args:[s(t),{}],code:[e],module:[n(o,i),"auto"]})))},
function _(e,t,o,n,s){var i;n();const c=e(125),r=e(259),a=e(8);class d extends c.Callback{constructor(e){super(e)}navigate(e){this.same_tab?window.location.href=e:window.open(e)}execute(e,{source:t}){const o=e=>{const o=(0,r.replace_placeholders)(this.url,t,e,void 0,void 0,encodeURI);if(!(0,a.isString)(o))throw new Error("HTML output is not supported in this context");this.navigate(o)},{selected:n}=t;for(const e of n.indices)o(e);for(const e of n.line_indices)o(e)}}o.OpenURL=d,i=d,d.__name__="OpenURL",i.define((({Bool:e,Str:t})=>({url:[t,"http://"],same_tab:[e,!1]})))},
function _(e,t,r,o,a){var n;o();const s=e(125),c=e(15),l=e(20);class u extends s.Callback{constructor(e){super(e)}execute(){const{obj:e,attr:t,value:r}=this;t in e.properties?e.setv({[t]:r}):l.logger.error(`${e.type}.${t} is not a property`)}}r.SetValue=u,n=u,u.__name__="SetValue",n.define((({Str:e,Unknown:t,Ref:r})=>({obj:[r(c.HasProps)],attr:[e],value:[t]})))},
function _(e,i,t,s,l){var n;s();const c=e(125),a=e(55);class o extends c.Callback{constructor(e){super(e)}execute(){const{target:e}=this;e.visible=!e.visible}}t.ToggleVisibility=o,n=o,o.__name__="ToggleVisibility",n.define((({Ref:e})=>({target:[e(a.UIElement)]})))},
function _(e,n,a,i,l){var o;i();const t=e(125),c=e(358);class s extends t.Callback{constructor(e){super(e)}async execute(){const{dialog:e}=this,n=e.document?.views_manager;if(null!=n){let a=n.find_one(e);null==a&&(a=await n.build_view(e)),a.open()}}}a.OpenDialog=s,o=s,s.__name__="OpenDialog",o.define((({Ref:e})=>({dialog:[e(c.Dialog)]})))},
function _(t,e,i,s,n){var o;s();const l=t(1),r=t(55),a=t(130),h=t(359),_=t(16),m=t(61),c=t(8),d=t(69),p=t(62),b=t(10),u=t(14),g=t(12),f=l.__importStar(t(276)),x=t(58),v=t(22),z=l.__importStar(t(360)),y=z,w=l.__importDefault(t(76)),L=((0,v.Or)((0,v.Ref)(r.UIElement),(0,v.Ref)(a.DOMNode)),[]),E=(()=>{const t=(0,m.div)(),e=t.attachShadow({mode:"open"});return new m.InlineStyleSheet("\n:host {\n  display: flex;\n  flex-direction: column;\n  flex-wrap: nowrap;\n  position: fixed;\n  left: 0;\n  bottom: 0;\n  width: max-content;\n  height: max-content;\n}\n:host:empty {\n  display: none;\n}\n").install(e),(0,m.dom_ready)().then((()=>document.body.append(t))),t})();class N extends r.UIElementView{constructor(){super(...arguments),this._position=new m.InlineStyleSheet,this._stacking=new m.InlineStyleSheet,this._has_rendered=!1,this._pinned=!1,this._normal_bbox=null,this._collapsed=!1,this._minimized=!1,this._maximized=!1,this.displayed=new _.Signal(this,"displayed")}*children(){yield*super.children(),yield this._title,yield this._content}stylesheets(){return[...super.stylesheets(),z.default,w.default,this._position,this._stacking]}async lazy_initialize(){await super.lazy_initialize();const t=(()=>{const{title:t}=this.model;return(0,c.isString)(t)||null==t?new h.Text({content:t??""}):t})(),e=(()=>{const{content:t}=this.model;return(0,c.isString)(t)?new h.Text({content:t}):t})();this._title=await(0,d.build_view)(t,{parent:this}),this._content=await(0,d.build_view)(e,{parent:this})}connect_signals(){super.connect_signals();const{visible:t}=this.model.properties;this.connect(t.change,(()=>this._toggle(this.model.visible)))}remove(){(0,b.remove)(L,this),this._content.remove(),this._title.remove(),super.remove()}_reposition(t){this._position.replace(":host",{left:"left"in t?(0,m.px)(t.left):"unset",right:"right"in t?(0,m.px)(t.right):"unset",top:"top"in t?(0,m.px)(t.top):"unset",bottom:"bottom"in t?(0,m.px)(t.bottom):"unset",width:"width"in t?(0,m.px)(t.width):"unset",height:"height"in t?(0,m.px)(t.height):"unset"}),this.update_bbox()}render(){super.render(),this._title.render(),this._content.render();const t=(0,m.div)({class:y.inner});this.shadow_el.append(t);const e=(0,m.div)({class:y.header}),i=(0,m.div)({class:y.content},this._content.el),s=(0,m.div)({class:y.footer});t.append(e),t.append(i),t.append(s);const n=(0,m.div)({class:y.grip}),o=(0,m.div)({class:y.title},n,this._title.el),l=(0,m.div)({class:y.controls});e.append(o,l);const r=(0,m.div)({class:[y.ctrl,y.pin],title:"Pin"});r.addEventListener("click",(()=>this.pin())),this._pin_el=r;const a=(0,m.div)({class:[y.ctrl,y.collapse],title:"Collapse"});a.addEventListener("click",(()=>this.collapse())),this._collapse_el=a;const h=(0,m.div)({class:[y.ctrl,y.minimize],title:"Minimize"});h.addEventListener("click",(()=>this.minimize())),this._minimize_el=h;const _=(0,m.div)({class:[y.ctrl,y.maximize],title:"Maximize"});_.addEventListener("click",(()=>this.maximize())),this._maximize_el=_;const c=(0,m.div)({class:[y.ctrl,y.close],title:"Close"});c.addEventListener("click",(()=>this.close())),this._close_el=c,this.model.pinnable&&l.append(r),this.model.collapsible&&l.append(a),this.model.minimizable&&l.append(h),this.model.maximizable&&l.append(_),this.model.closable&&l.append(c);const d=this._handles={area:o,top:(0,m.div)({class:[y.handle,y.resize_top]}),bottom:(0,m.div)({class:[y.handle,y.resize_bottom]}),left:(0,m.div)({class:[y.handle,y.resize_left]}),right:(0,m.div)({class:[y.handle,y.resize_right]}),top_left:(0,m.div)({class:[y.handle,y.resize_top_left]}),top_right:(0,m.div)({class:[y.handle,y.resize_top_right]}),bottom_left:(0,m.div)({class:[y.handle,y.resize_bottom_left]}),bottom_right:(0,m.div)({class:[y.handle,y.resize_bottom_right]})};this.shadow_el.append(d.top,d.bottom,d.left,d.right,d.top_left,d.top_right,d.bottom_left,d.bottom_right);let p=null;const b=()=>{p=null,document.removeEventListener("pointermove",u),document.removeEventListener("pointerup",f),document.removeEventListener("keydown",x),this.el.classList.remove(y.interacting)},u=t=>{(0,g.assert)(null!=p),t.preventDefault(),this.el.classList.add(y.interacting);const e=t.x-p.xy.x,i=t.y-p.xy.y,{target:s,bbox:n}=p,o=this._move_bbox(s,n,e,i);this._reposition(o)},f=t=>{(0,g.assert)(null!=p),t.preventDefault(),b()},x=t=>{if("Escape"==t.key){(0,g.assert)(null!=p),t.preventDefault();const{left:e,top:i,width:s,height:n}=p.bbox;this._reposition({left:e,top:i,width:s,height:n}),b()}};this.el.addEventListener("pointerdown",(t=>{(0,g.assert)(null==p),this.bring_to_front();const e=this._hit_target(t.composedPath());if(null==e||!this._can_hit(e))return;t.preventDefault();const{x:i,y:s}=t;p={bbox:(0,m.bounding_box)(this.el),xy:{x:i,y:s},target:e},document.addEventListener("pointermove",u),document.addEventListener("pointerup",f),document.addEventListener("keydown",x);this._handles[e].setPointerCapture(t.pointerId)})),o.addEventListener("wheel",(t=>{const e=t.deltaY;(e<0&&!this._collapsed||e>0&&this._collapsed)&&(t.preventDefault(),t.stopPropagation(),this.collapse())})),this._has_rendered=!0,this.model.visible&&this.bring_to_front()}get resizable(){const{resizable:t}=this.model;return{left:"left"==t||"x"==t||"all"==t,right:"right"==t||"x"==t||"all"==t,top:"top"==t||"y"==t||"all"==t,bottom:"bottom"==t||"y"==t||"all"==t}}_hit_target(t){const{_handles:e}=this;for(const i of t)switch(i){case e.area:return"area";case e.top:return"top";case e.bottom:return"bottom";case e.left:return"left";case e.right:return"right";case e.top_left:return"top_left";case e.top_right:return"top_right";case e.bottom_left:return"bottom_left";case e.bottom_right:return"bottom_right"}return null}_can_hit(t){if(this._minimized||this._maximized)return!1;const{left:e,right:i,top:s,bottom:n}=this.resizable;switch(t){case"top_left":return s&&e;case"top_right":return s&&i;case"bottom_left":return n&&e;case"bottom_right":return n&&i;case"left":return e;case"right":return i;case"top":return s;case"bottom":return n;case"area":return"none"!=this.model.movable}}_move_bbox(t,e,i,s){const n=(t,e)=>e instanceof x.Coordinate?this.resolve_as_scalar(e,t):NaN,o=p.BBox.from_lrtb({left:n("x",this.model.left_limit),right:n("x",this.model.right_limit),top:n("y",this.model.top_limit),bottom:n("y",this.model.bottom_limit)}),[l,r,a,h]=(()=>{const{symmetric:e}=this.model,[n,o]=e?[-i,-s]:[0,0];switch(t){case"top_left":return[i,n,s,o];case"top_right":return[n,i,s,o];case"bottom_left":return[i,n,o,s];case"bottom_right":return[n,i,o,s];case"left":return[i,n,0,0];case"right":return[n,i,0,0];case"top":return[0,0,s,o];case"bottom":return[0,0,o,s];case"area":switch(this.model.movable){case"both":return[i,i,s,s];case"x":return[i,i,0,0];case"y":return[0,0,s,s];case"none":return[0,0,0,0]}}})(),_=(t,e)=>(0,b.min)([t,e]),m=t=>t<0?-1:t>0?1:0;let{left:c,right:d,left_sign:u,right_sign:g}=(()=>{const t=e.left+l,i=e.right+r,s=m(l),n=m(r);return t<=i?{left:t,right:i,left_sign:s,right_sign:n}:{left:i,right:t,left_sign:n,right_sign:s}})(),{top:f,bottom:v,top_sign:z,bottom_sign:y}=(()=>{const t=e.top+a,i=e.bottom+h,s=m(a),n=m(h);return t<=i?{top:t,bottom:i,top_sign:s,bottom_sign:n}:{top:i,bottom:t,top_sign:n,bottom_sign:s}})();const w=c-o.left,L=o.right-d,E=_(w<0?w:NaN,L<0?L:NaN);isFinite(E)&&E<0&&(c+=-u*-E,d+=-g*-E);const N=f-o.top,k=o.bottom-v,D=_(N<0?N:NaN,k<0?k:NaN);return isFinite(D)&&D<0&&(f+=-z*-D,v+=-y*-D),p.BBox.from_lrtb({left:c,right:d,top:f,bottom:v})}pin(){const{_pinned:t}=this;for(const e of L)e==this?this._pin(!t):e._pin(!1);t||this.bring_to_front()}_pin(t){this._pinned!=t&&(this._pinned=t,this.el.classList.toggle(y.pinned,this._pinned),this._pin_el.title=this._pinned?"Unpin":"Pin")}collapse(){const t=(()=>{if(this._collapsed){const{_normal_bbox:t}=this;return(0,g.assert)(null!=t),this._normal_bbox=null,t}{this._minimize(!1),this._maximize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,m.bounding_box)(this.el));const{left:t,top:e,width:i}=this._normal_bbox;return{left:t,top:e,width:i,height:"max-content"}}})();this._reposition(t),this._collapse(!this._collapsed)}_collapse(t){this._collapsed!=t&&(this._collapsed=t,this.el.classList.toggle(y.collapsed,this._collapsed),this._collapse_el.title=this._collapsed?"Restore":"Collapse")}minimize(){const t=(()=>{if(this._minimized){const{_normal_bbox:t}=this;return(0,g.assert)(null!=t),this._normal_bbox=null,t}return this._pin(!1),this._collapse(!1),this._maximize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,m.bounding_box)(this.el)),{width:"auto",height:"max-content"}})();this._reposition(t),this._minimize(!this._minimized)}_minimize(t){if(this._minimized!=t){this._minimized=t;(t?E.shadowRoot??E:document.body).append(this.el),this.el.classList.toggle(y.minimized,this._minimized),this._minimize_el.title=this._minimized?"Restore":"Minimize"}}maximize(){const t=(()=>{if(this._maximized){const{_normal_bbox:t}=this;return(0,g.assert)(null!=t),this._normal_bbox=null,t}return this._collapse(!1),this._minimize(!1),null==this._normal_bbox&&(this._normal_bbox=(0,m.bounding_box)(this.el)),{left:0,top:0,width:"100%",height:"100%"}})();this._reposition(t),this._maximize(!this._maximized)}_maximize(t){this._maximized!=t&&(this._maximized=t,this.el.classList.toggle(y.maximized,this._maximized),this._maximize_el.title=this._maximized?"Restore":"Maximize")}restore(){this._collapse(!1),this._minimize(!1),this._maximize(!1);const{_normal_bbox:t}=this;null!=t&&(this._reposition(t),this._normal_bbox=null)}_toggle(t){if(t){const t=document.body;this._has_rendered||(this.render_to(t),this.r_after_render()),this.el.isConnected||t.append(this.el),this.bring_to_front()}else(0,b.remove)(L,this),this.el.remove()}get is_open(){return this.model.visible}toggle(t){const e=t??!this.model.visible;this.model.setv({visible:e},{check_eq:!1}),this.displayed.emit(e)}open(){this.toggle(!0)}close(){switch(this.model.close_action){case"hide":this.toggle(!1);break;case"destroy":this.remove()}}bring_to_front(){L.includes(this)||L.push(this);const t=(0,b.find)(L,(t=>t._pinned));null!=t&&(0,b.remove)(L,t),(0,b.remove)(L,this),L.push(this),null!=t&&L.push(t);for(const[t,e]of(0,u.enumerate)(L))t._stacking.replace(":host",{"z-index":`${1e3+e}`})}}i.DialogView=N,N.__name__="DialogView";class k extends r.UIElement{constructor(t){super(t)}}i.Dialog=k,o=k,k.__name__="Dialog",o.prototype.default_view=N,o.define((({Bool:t,Str:e,Ref:i,Or:s,Nullable:n,Enum:o})=>({title:[n(s(e,i(a.DOMNode),i(r.UIElement))),null],content:[s(e,i(a.DOMNode),i(r.UIElement))],pinnable:[t,!0],collapsible:[t,!0],minimizable:[t,!0],maximizable:[t,!0],closable:[t,!0],close_action:[o("hide","destroy"),"destroy"],resizable:[f.Resizable,"all"],movable:[f.Movable,"both"],symmetric:[t,!1],top_limit:[f.Limit,null],bottom_limit:[f.Limit,null],left_limit:[f.Limit,null],right_limit:[f.Limit,null]})))},
function _(e,t,n,s,o){var r;s();const c=e(130);class i extends c.DOMNodeView{connect_signals(){super.connect_signals();const{content:e}=this.model.properties;this.on_change(e,(()=>this.render()))}render(){this.el.textContent=this.model.content}after_render(){this.finish()}_create_element(){return document.createTextNode("")}}n.TextView=i,i.__name__="TextView";class _ extends c.DOMNode{constructor(e){super(e)}}n.Text=_,r=_,_.__name__="Text",r.prototype.default_view=i,r.define((({Str:e})=>({content:[e,""]})))},
function _(e,i,o,r,t){r(),o.interacting="bk-interacting",o.inner="bk-inner",o.header="bk-header",o.content="bk-content",o.collapsed="bk-collapsed",o.minimized="bk-minimized",o.footer="bk-footer",o.grip="bk-grip",o.title="bk-title",o.controls="bk-controls",o.ctrl="bk-ctrl",o.pin="bk-pin",o.pinned="bk-pinned",o.collapse="bk-collapse",o.minimize="bk-minimize",o.maximize="bk-maximize",o.maximized="bk-maximized",o.close="bk-close",o.handle="bk-handle",o.resize_top="bk-resize-top",o.resize_bottom="bk-resize-bottom",o.resize_left="bk-resize-left",o.resize_right="bk-resize-right",o.resize_top_left="bk-resize-top-left",o.resize_top_right="bk-resize-top-right",o.resize_bottom_left="bk-resize-bottom-left",o.resize_bottom_right="bk-resize-bottom-right",o.default=":host{--bokeh-bg-color:var(--background-color);--bokeh-border-color:var(--divider-color);--bokeh-shadow-color:var(--divider-color);--bokeh-ctrl-size:16px;--bokeh-ctrl-color:var(--shortcut-color);}:host{position:fixed;left:200px;top:200px;width:600px;height:600px;width:80vw;height:60vh;}:host(.bk-interacting){opacity:0.9;}.bk-inner{position:relative;display:flex;flex-direction:column;flex-wrap:nowrap;width:100%;height:100%;overflow:hidden;border-radius:4px;background-color:var(--bokeh-bg-color);border:1px solid var(--bokeh-border-color);box-shadow:5px 5px 10px var(--bokeh-shadow-color);}.bk-header{position:relative;display:flex;flex:0;gap:1em;padding:5px;background-color:var(--border-color);}.bk-content{position:relative;display:flex;flex:1;overflow:auto;}:host(.bk-collapsed) .bk-content,:host(.bk-minimized) .bk-content,:host(.bk-collapsed) .bk-footer,:host(.bk-minimized) .bk-footer{display:none;}.bk-footer{position:relative;display:flex;flex:0;}.bk-grip{width:var(--bokeh-ctrl-size);height:var(--bokeh-ctrl-size);background-color:var(--bokeh-ctrl-color);background-color:var(--color);mask-image:var(--bokeh-icon-y-grip);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-y-grip);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-title{position:relative;display:flex;flex:1;cursor:move;white-space:nowrap;}.bk-controls{position:relative;display:flex;flex:0;}.bk-ctrl{width:var(--bokeh-ctrl-size);height:var(--bokeh-ctrl-size);cursor:pointer;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-color:var(--bokeh-ctrl-color);}.bk-ctrl:hover{background-color:var(--hover-color);}.bk-pin{mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}:host(.bk-pinned) .bk-pin{mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-collapse{mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}:host(.bk-collapsed) .bk-collapse{mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-minimize{mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}:host(.bk-minimized) .bk-minimize{mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-maximize{mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}:host(.bk-maximized) .bk-maximize{mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-close{mask-image:var(--bokeh-icon-x);-webkit-mask-image:var(--bokeh-icon-x);}:host{--resize-radius:3px;--resize-depth:calc(2*var(--resize-radius));}:host(.bk-minimized){position:relative;}:host(.bk-minimized) .bk-handle,:host(.bk-maximized) .bk-handle{display:none;}:host(.bk-minimized) .bk-title,:host(.bk-maximized) .bk-title{cursor:default;}.bk-resize-top{position:absolute;top:0;left:var(--resize-radius);width:calc(100% - var(--resize-depth));height:var(--resize-depth);transform:translate(0, -50%);cursor:ns-resize;}.bk-resize-bottom{position:absolute;bottom:0;left:var(--resize-radius);width:calc(100% - var(--resize-depth));height:var(--resize-depth);transform:translate(0, 50%);cursor:ns-resize;}.bk-resize-left{position:absolute;left:0;top:var(--resize-radius);width:var(--resize-depth);height:calc(100% - var(--resize-depth));transform:translate(-50%, 0);cursor:ew-resize;}.bk-resize-right{position:absolute;right:0;top:var(--resize-radius);width:var(--resize-depth);height:calc(100% - var(--resize-depth));transform:translate(50%, 0);cursor:ew-resize;}.bk-resize-top-left{position:absolute;top:0;left:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(-50%, -50%);cursor:nw-resize;}.bk-resize-top-right{position:absolute;top:0;right:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(50%, -50%);cursor:ne-resize;}.bk-resize-bottom-left{position:absolute;bottom:0;left:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(-50%, 50%);cursor:sw-resize;}.bk-resize-bottom-right{position:absolute;bottom:0;right:0;width:var(--resize-depth);height:var(--resize-depth);transform:translate(50%, 50%);cursor:se-resize;}"},
function _(e,o,a,n,s){var c;n();const l=e(125),i=e(358);class t extends l.Callback{constructor(e){super(e)}async execute(){const{dialog:e}=this;e.document?.views_manager?.find_one(e)?.close()}}a.CloseDialog=t,c=t,t.__name__="CloseDialog",c.define((({Ref:e})=>({dialog:[e(i.Dialog)]})))},
function _(a,n,e,r,s){r(),s("Canvas",a(329).Canvas),s("CartesianFrame",a(198).CartesianFrame)},
function _(o,a,m,C,n){C(),n("Comparison",o(364).Comparison),n("CustomJSCompare",o(365).CustomJSCompare),n("NanCompare",o(366).NanCompare)},
function _(o,n,s,c,e){c();const r=o(52);class t extends r.Model{constructor(o){super(o)}}s.Comparison=t,t.__name__="Comparison"},
function _(e,s,t,n,r){var u;n();const a=e(364),o=e(9),c=e(41);class i extends a.Comparison{constructor(e){super(e)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}_make_func(){const e=(0,c.use_strict)(this.code);return new Function("x","y",...this.names,e)}compute(e,s){return this._make_func()(e,s,this.values)}}t.CustomJSCompare=i,u=i,i.__name__="CustomJSCompare",u.define((({Unknown:e,Str:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(s,e,i,n,r){var a;n();const t=s(364),o=s(8);class N extends t.Comparison{constructor(s){super(s)}compute(s,e){return(0,o.isNumber)(s)&&isNaN(s)?this.ascending_first?-1:1:(0,o.isNumber)(e)&&isNaN(e)?this.ascending_first?1:-1:(0,o.isNumber)(s)&&(0,o.isNumber)(e)?s==e?0:s<e?-1:1:0}}i.NanCompare=N,a=N,N.__name__="NanCompare",a.define((({Bool:s})=>({ascending_first:[s,!1]})))},
function _(d,e,n,o,i){o(),i("CoordinateMapping",d(107).CoordinateMapping),i("Node",d(57).Node),i("XY",d(66).XY),i("Indexed",d(67).Indexed)},
function _(m,o,n,r,a){r(),a("Expression",m(369).Expression),a("CustomJSExpr",m(370).CustomJSExpr),a("Stack",m(371).Stack),a("CumSum",m(372).CumSum),a("ScalarExpression",m(369).ScalarExpression),a("Minimum",m(373).Minimum),a("Maximum",m(374).Maximum);var s=m(375);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(376).PolarTransform)},
function _(e,t,s,i,r){i();const n=e(52);class _ extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}v_compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=_,_.__name__="Expression";class o extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._compute(e),this._result.set(e,t)),t}}s.ScalarExpression=o,o.__name__="ScalarExpression"},
function _(e,s,t,n,r){var a;n();const o=e(15),c=e(369),i=e(25),u=e(10),l=e(9),h=e(41),g=e(8);class p extends c.Expression{constructor(e){super(e)}connect_signals(){super.connect_signals();for(const e of(0,l.values)(this.args))e instanceof o.HasProps&&e.change.connect((()=>{this._result.clear(),this.change.emit()}))}get names(){return(0,l.keys)(this.args)}get values(){return(0,l.values)(this.args)}get func(){const e=(0,h.use_strict)(this.code);return new i.GeneratorFunction(...this.names,e)}_v_compute(e){const s=this.func.apply(e,this.values);let t=s.next();if(t.done&&void 0!==t.value){const{value:s}=t;return(0,g.isArray)(s)||(0,g.isTypedArray)(s)?s:(0,g.isIterable)(s)?[...s]:(0,u.repeat)(s,e.length)}{const e=[];do{e.push(t.value),t=s.next()}while(!t.done);return e}}}t.CustomJSExpr=p,a=p,p.__name__="CustomJSExpr",a.define((({Unknown:e,Str:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(t,n,e,s,o){var c;s();const r=t(369),a=t(9);class i extends r.Expression{constructor(t){super(t)}_v_compute(t){const n=t.get_length()??0,e=new Float64Array(n);for(const s of this.fields){const o=(0,a.dict)(t.data).get(s);if(null!=o){const t=Math.min(n,o.length);for(let n=0;n<t;n++)e[n]+=o[n]}}return e}}e.Stack=i,c=i,i.__name__="Stack",c.define((({Str:t,List:n})=>({fields:[n(t),[]]})))},
function _(e,t,n,o,r){var i;o();const s=e(369),u=e(9);class c extends s.Expression{constructor(e){super(e)}_v_compute(e){const t=new Float64Array(e.get_length()??0),n=(0,u.dict)(e.data).get(this.field)??[],o=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+n[e-o];return t}}n.CumSum=c,i=c,c.__name__="CumSum",i.define((({Bool:e,Str:t})=>({field:[t],include_zero:[e,!1]})))},
function _(i,t,n,e,a){var s;e();const c=i(369),r=i(9),m=i(10);class o extends c.ScalarExpression{constructor(i){super(i)}_compute(i){const t=(0,r.dict)(i.data).get(this.field)??[];return Math.min(this.initial,(0,m.min)(t))}}n.Minimum=o,s=o,o.__name__="Minimum",s.define((({Float:i,Str:t})=>({field:[t],initial:[i,1/0]})))},
function _(t,i,a,e,n){var s;e();const c=t(369),r=t(9),m=t(10);class o extends c.ScalarExpression{constructor(t){super(t)}_compute(t){const i=(0,r.dict)(t.data).get(this.field)??[];return Math.max(this.initial,(0,m.max)(i))}}a.Maximum=o,s=o,o.__name__="Maximum",s.define((({Float:t,Str:i})=>({field:[i],initial:[t,-1/0]})))},
function _(n,e,t,o,r){var s;o();const _=n(369);class m extends _.Expression{constructor(n){super(n)}get x(){return new c({transform:this})}get y(){return new u({transform:this})}}t.CoordinateTransform=m,m.__name__="CoordinateTransform";class a extends _.Expression{constructor(n){super(n)}}t.XYComponent=a,s=a,a.__name__="XYComponent",s.define((({Ref:n})=>({transform:[n(m)]})));class c extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).x}}t.XComponent=c,c.__name__="XComponent";class u extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).y}}t.YComponent=u,u.__name__="YComponent"},
function _(r,t,e,n,o){var i;n();const a=r(1),s=r(375),c=r(21),l=a.__importStar(r(19));class d extends s.CoordinateTransform{constructor(r){super(r)}_v_compute(r){const t=this.properties.radius.uniform(r),e=this.properties.angle.uniform(r),n="anticlock"==this.direction?-1:1,o=Math.min(t.length,e.length),i=new Float64Array(o),a=new Float64Array(o);for(let r=0;r<o;r++){const o=t.get(r),s=e.get(r)*n;i[r]=o*Math.cos(s),a[r]=o*Math.sin(s)}return{x:i,y:a}}}e.PolarTransform=d,i=d,d.__name__="PolarTransform",i.define((({})=>({radius:[l.DistanceSpec,{field:"radius"}],angle:[l.AngleSpec,{field:"angle"}],direction:[c.Direction,"anticlock"]})))},
function _(e,i,r,t,l){t(),l("BooleanFilter",e(378).BooleanFilter),l("CustomJSFilter",e(379).CustomJSFilter),l("Filter",e(252).Filter),l("GroupFilter",e(380).GroupFilter),l("IndexFilter",e(381).IndexFilter),l("AllIndices",e(253).AllIndices),l("InversionFilter",e(382).InversionFilter),l("IntersectionFilter",e(254).IntersectionFilter),l("UnionFilter",e(383).UnionFilter),l("DifferenceFilter",e(384).DifferenceFilter),l("SymmetricDifferenceFilter",e(385).SymmetricDifferenceFilter)},
function _(e,l,n,o,t){var s;o();const a=e(252),r=e(25);class c extends a.Filter{constructor(e){super(e)}compute_indices(e){const l=e.get_length()??1,{booleans:n}=this;return null==n?r.Indices.all_set(l):r.Indices.from_booleans(l,n)}}n.BooleanFilter=c,s=c,c.__name__="BooleanFilter",s.define((({Bool:e,Iterable:l,Nullable:n})=>({booleans:[n(l(e)),null]})))},
function _(e,r,s,t,n){var i;t();const o=e(252),c=e(25),u=e(9),a=e(8),l=e(41);class f extends o.Filter{constructor(e){super(e)}get names(){return(0,u.keys)(this.args)}get values(){return(0,u.values)(this.args)}get func(){const e=(0,l.use_strict)(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const r=e.get_length()??1,s=this.func(...this.values,e);if(null==s)return c.Indices.all_set(r);if((0,a.isArrayOf)(s,a.isInteger))return c.Indices.from_indices(r,s);if((0,a.isArrayOf)(s,a.isBoolean))return c.Indices.from_booleans(r,s);throw new Error(`expect an array of integers or booleans, or null, got ${s}`)}}s.CustomJSFilter=f,i=f,f.__name__="CustomJSFilter",i.define((({Unknown:e,Str:r,Dict:s})=>({args:[s(e),{}],code:[r,""]})))},
function _(n,e,t,o,r){var s;o();const u=n(252),c=n(25),i=n(20),l=n(27);class a extends u.Filter{constructor(n){super(n)}compute_indices(n){const e=n.get_column(this.column_name),t=n.get_length()??1;if(null==e)return i.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),c.Indices.all_set(t);{const n=new c.Indices(t,0),o=new l.Comparator;for(let t=0;t<n.size;t++)o.eq(e[t],this.group)&&n.set(t);return n}}}t.GroupFilter=a,s=a,a.__name__="GroupFilter",s.define((({Str:n,Unknown:e})=>({column_name:[n],group:[e]})))},
function _(e,n,t,i,l){var s;i();const c=e(252),r=e(25);class d extends c.Filter{constructor(e){super(e)}compute_indices(e){const n=e.get_length()??1,{indices:t}=this;return null==t?r.Indices.all_set(n):r.Indices.from_indices(n,t)}}t.IndexFilter=d,s=d,d.__name__="IndexFilter",s.define((({Int:e,Iterable:n,Nullable:t})=>({indices:[t(n(e)),null]})))},
function _(e,n,t,s,o){var i;s();const r=e(252);class c extends r.Filter{constructor(e){super(e)}connect_signals(){super.connect_signals();const e=()=>{this.change.emit()},n=n=>{for(const t of n)this.connect(t.change,e)},t=n=>{for(const t of n)this.disconnect(t.change,e)};let s=(()=>{const{operand:e}=this.properties;return e.is_unset?[]:[e.get_value()]})();n(s),this.on_change(this.properties.operand,(()=>{t(s),s=[this.operand],n(s)}))}compute_indices(e){const n=this.operand.compute_indices(e);return n.invert(),n}}t.InversionFilter=c,i=c,c.__name__="InversionFilter",i.define((({Ref:e})=>({operand:[e(r.Filter)]})))},
function _(n,e,o,t,i){t();const s=n(255);class _ extends s.CompositeFilter{constructor(n){super(n)}_inplace_op(n,e){n.add(e)}}o.UnionFilter=_,_.__name__="UnionFilter"},
function _(e,t,c,n,r){n();const i=e(255);class s extends i.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.subtract(t)}}c.DifferenceFilter=s,s.__name__="DifferenceFilter"},
function _(e,t,c,r,i){r();const n=e(255);class s extends n.CompositeFilter{constructor(e){super(e)}_inplace_op(e,t){e.symmetric_subtract(t)}}c.SymmetricDifferenceFilter=s,s.__name__="SymmetricDifferenceFilter"},
function _(e,a,t,l,r){l(),r("AnnularWedge",e(387).AnnularWedge),r("Annulus",e(388).Annulus),r("Arc",e(389).Arc),r("Bezier",e(390).Bezier),r("Block",e(392).Block),r("Circle",e(343).Circle),r("Ellipse",e(394).Ellipse),r("Glyph",e(236).Glyph),r("HArea",e(248).HArea),r("HAreaStep",e(245).HAreaStep),r("HBar",e(396).HBar),r("HexTile",e(397).HexTile),r("HSpan",e(398).HSpan),r("HStrip",e(399).HStrip),r("Image",e(400).Image),r("ImageRGBA",e(402).ImageRGBA),r("ImageStack",e(403).ImageStack),r("ImageURL",e(404).ImageURL),r("Line",e(234).Line),r("MathMLGlyph",e(405).MathMLGlyph),r("MultiLine",e(408).MultiLine),r("MultiPolygons",e(409).MultiPolygons),r("Ngon",e(410).Ngon),r("Patch",e(244).Patch),r("Patches",e(411).Patches),r("Quad",e(412).Quad),r("Quadratic",e(413).Quadratic),r("Ray",e(414).Ray),r("Rect",e(415).Rect),r("Scatter",e(416).Scatter),r("Segment",e(419).Segment),r("Spline",e(420).Spline),r("Step",e(422).Step),r("TeXGlyph",e(423).TeXGlyph),r("Text",e(407).Text),r("VArea",e(250).VArea),r("VAreaStep",e(249).VAreaStep),r("VBar",e(424).VBar),r("VSpan",e(425).VSpan),r("VStrip",e(426).VStrip),r("Wedge",e(427).Wedge)},
function _(e,t,i,s,r){var n;s();const a=e(1),_=e(235),d=e(236),h=e(242),o=e(95),u=e(25),l=e(21),c=a.__importStar(e(19)),g=e(11),x=e(144),p=e(13);class f extends _.XYGlyphView{async load_glglyph(){const{AnnularWedgeGL:t}=await Promise.resolve().then((()=>a.__importStar(e(578))));return t}_index_data(e){const{x:t,y:i,outer_radius:s,data_size:r}=this;for(let n=0;n<r;n++){const r=t[n],a=i[n],_=s.get(n);e.add_rect(r-_,a-_,r+_,a+_)}}_map_data(){this._define_or_inherit_attr("sinner_radius",(()=>"data"==this.model.properties.inner_radius.units?this.inherited_x&&this.inherited_inner_radius?d.inherit:this.sdist(this.renderer.xscale,this.x,this.inner_radius):this.inherited_inner_radius?d.inherit:(0,u.to_screen)(this.inner_radius))),this._define_or_inherit_attr("souter_radius",(()=>"data"==this.model.properties.outer_radius.units?this.inherited_x&&this.inherited_outer_radius?d.inherit:this.sdist(this.renderer.xscale,this.x,this.outer_radius):this.inherited_outer_radius?d.inherit:(0,u.to_screen)(this.outer_radius))),this._define_or_inherit_attr("max_souter_radius",(()=>(0,p.max)(this.souter_radius)))}_paint(e,t,i){const{sx:s,sy:r,start_angle:n,end_angle:a,sinner_radius:_,souter_radius:d}={...this,...i},h="anticlock"==this.model.direction;for(const i of t){const t=s[i],o=r[i],u=_[i],l=d[i],c=n.get(i),g=a.get(i);if(!isFinite(t+o+u+l+c+g))continue;const x=g-c;e.translate(t,o),e.rotate(c),e.beginPath(),e.moveTo(l,0),e.arc(0,0,l,0,x,h),e.rotate(x),e.lineTo(u,0),e.arc(0,0,u,0,-x,!h),e.closePath(),e.rotate(-x-c),e.translate(-t,-o),this.visuals.fill.apply(e,i),this.visuals.hatch.apply(e,i),this.visuals.line.apply(e,i)}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(i),n=t-this.max_souter_radius,a=t+this.max_souter_radius,[_,d]=this.renderer.xscale.r_invert(n,a),h=i-this.max_souter_radius,o=i+this.max_souter_radius,[u,l]=this.renderer.yscale.r_invert(h,o),c=[];for(const e of this.index.indices({x0:_,x1:d,y0:u,y1:l})){const t=this.souter_radius[e]**2,i=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(s,this.x[e]),[_,d]=this.renderer.yscale.r_compute(r,this.y[e]),h=(n-a)**2+(_-d)**2;h<=t&&h>=i&&c.push(e)}const p="anticlock"==this.model.direction,f=[];for(const e of c){const s=Math.atan2(i-this.sy[e],t-this.sx[e]);(Math.abs(this.start_angle.get(e)-this.end_angle.get(e))>=2*Math.PI||(0,g.angle_between)(-s,-this.start_angle.get(e),-this.end_angle.get(e),p))&&f.push(e)}return new x.Selection({indices:f})}draw_legend_for_index(e,t,i){(0,h.generic_area_vector_legend)(this.visuals,e,t,i)}scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,i=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(i),this.sy[e]+t*Math.sin(i)]}}i.AnnularWedgeView=f,f.__name__="AnnularWedgeView";class m extends _.XYGlyph{constructor(e){super(e)}}i.AnnularWedge=m,n=m,m.__name__="AnnularWedge",n.prototype.default_view=f,n.mixins([o.LineVector,o.FillVector,o.HatchVector]),n.define((({})=>({direction:[l.Direction,"anticlock"],inner_radius:[c.DistanceSpec,{field:"inner_radius"}],outer_radius:[c.DistanceSpec,{field:"outer_radius"}],start_angle:[c.AngleSpec,{field:"start_angle"}],end_angle:[c.AngleSpec,{field:"end_angle"}]})))},
function _(i,s,e,t,r){var n;t();const a=i(1),_=i(235),u=i(236),d=i(25),h=i(95),o=a.__importStar(i(19)),c=i(144);class l extends _.XYGlyphView{async load_glglyph(){const{AnnulusGL:s}=await Promise.resolve().then((()=>a.__importStar(i(585))));return s}_index_data(i){const{x:s,y:e,outer_radius:t,data_size:r}=this;for(let n=0;n<r;n++){const r=s[n],a=e[n],_=t.get(n);i.add_rect(r-_,a-_,r+_,a+_)}}_map_data(){this._define_or_inherit_attr("sinner_radius",(()=>"data"==this.model.properties.inner_radius.units?this.inherited_x&&this.inherited_inner_radius?u.inherit:this.sdist(this.renderer.xscale,this.x,this.inner_radius):this.inherited_inner_radius?u.inherit:(0,d.to_screen)(this.inner_radius))),this._define_or_inherit_attr("souter_radius",(()=>"data"==this.model.properties.outer_radius.units?this.inherited_x&&this.inherited_outer_radius?u.inherit:this.sdist(this.renderer.xscale,this.x,this.outer_radius):this.inherited_outer_radius?u.inherit:(0,d.to_screen)(this.outer_radius)))}_paint(i,s,e){const{sx:t,sy:r,sinner_radius:n,souter_radius:a}={...this,...e};for(const e of s){const s=t[e],_=r[e],u=n[e],d=a[e];isFinite(s+_+u+d)&&(i.beginPath(),i.arc(s,_,u,0,2*Math.PI,!0),i.moveTo(s+d,_),i.arc(s,_,d,2*Math.PI,0,!1),this.visuals.fill.apply(i,e),this.visuals.hatch.apply(i,e),this.visuals.line.apply(i,e))}}_hit_point(i){const{sx:s,sy:e}=i,t=this.renderer.xscale.invert(s),r=this.renderer.yscale.invert(e);let n,a,_,u;if("data"==this.model.properties.outer_radius.units)n=t-this.max_outer_radius,_=t+this.max_outer_radius,a=r-this.max_outer_radius,u=r+this.max_outer_radius;else{const i=s-this.max_outer_radius,t=s+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(i,t);const r=e-this.max_outer_radius,d=e+this.max_outer_radius;[a,u]=this.renderer.yscale.r_invert(r,d)}const d=[];for(const i of this.index.indices({x0:n,x1:_,y0:a,y1:u})){const s=this.souter_radius[i]**2,e=this.sinner_radius[i]**2,[n,a]=this.renderer.xscale.r_compute(t,this.x[i]),[_,u]=this.renderer.yscale.r_compute(r,this.y[i]),h=(n-a)**2+(_-u)**2;h<=s&&h>=e&&d.push(i)}return new c.Selection({indices:d})}draw_legend_for_index(i,{x0:s,y0:e,x1:t,y1:r},n){const a=n+1,_=new Array(a);_[n]=(s+t)/2;const u=new Array(a);u[n]=(e+r)/2;const d=.5*Math.min(Math.abs(t-s),Math.abs(r-e)),h=new Array(a);h[n]=.4*d;const o=new Array(a);o[n]=.8*d,this._paint(i,[n],{sx:_,sy:u,sinner_radius:h,souter_radius:o})}}e.AnnulusView=l,l.__name__="AnnulusView";class x extends _.XYGlyph{constructor(i){super(i)}}e.Annulus=x,n=x,x.__name__="Annulus",n.prototype.default_view=l,n.mixins([h.LineVector,h.FillVector,h.HatchVector]),n.define((({})=>({inner_radius:[o.DistanceSpec,{field:"inner_radius"}],outer_radius:[o.DistanceSpec,{field:"outer_radius"}]})))},
function _(e,i,t,s,n){var r;s();const a=e(1),o=e(235),d=e(236),c=e(242),_=e(95),l=e(25),h=e(21),u=a.__importStar(e(19));class p extends o.XYGlyphView{_map_data(){this._define_or_inherit_attr("sradius",(()=>"data"==this.model.properties.radius.units?this.inherited_x&&this.inherited_radius?d.inherit:this.sdist(this.renderer.xscale,this.x,this.radius):this.inherited_radius?d.inherit:(0,l.to_screen)(this.radius)))}_paint(e,i,t){if(!this.visuals.line.doit)return;const{sx:s,sy:n,sradius:r,start_angle:a,end_angle:o}={...this,...t},d="anticlock"==this.model.direction;for(const t of i){const i=s[t],c=n[t],_=r[t],l=a.get(t),h=o.get(t);isFinite(i+c+_+l+h)&&(this._render_decorations(e,t,i,c,_,l,h,d),e.beginPath(),e.arc(i,c,_,l,h,d),this.visuals.line.apply(e,t))}}_render_decorations(e,i,t,s,n,r,a,o){const{sin:d,cos:c,PI:_}=Math;for(const o of this.decorations.values()){if(e.save(),"start"==o.model.node){const i=n*c(r)+t,a=n*d(r)+s;e.translate(i,a),e.rotate(r+_)}else if("end"==o.model.node){const i=n*Math.cos(a)+t,r=n*Math.sin(a)+s;e.translate(i,r),e.rotate(a)}o.marking.paint(e,i),e.restore()}}draw_legend_for_index(e,i,t){(0,c.generic_line_vector_legend)(this.visuals,e,i,t)}}t.ArcView=p,p.__name__="ArcView";class f extends o.XYGlyph{constructor(e){super(e)}}t.Arc=f,r=f,f.__name__="Arc",r.prototype.default_view=p,r.mixins(_.LineVector),r.define((({})=>({direction:[h.Direction,"anticlock"],radius:[u.DistanceSpec,{field:"radius"}],start_angle:[u.AngleSpec,{field:"start_angle"}],end_angle:[u.AngleSpec,{field:"end_angle"}]})))},
function _(e,i,t,s,c){var o;s();const n=e(1),r=e(95),d=e(236),x=e(242),y=e(391),a=n.__importStar(e(19));class _ extends d.GlyphView{_project_data(){this._project_xy("x0",this.x0,"y0",this.y0),this._project_xy("x1",this.x1,"y1",this.y1)}_index_data(e){const{data_size:i,x0:t,y0:s,x1:c,y1:o,cx0:n,cy0:r,cx1:d,cy1:x}=this;for(let a=0;a<i;a++){const i=t[a],_=s[a],l=c[a],p=o[a],f=n[a],h=r[a],u=d[a],C=x[a];if(isFinite(i+l+_+p+f+h+u+C)){const{x0:t,y0:s,x1:c,y1:o}=(0,y.cbb)(i,_,f,h,u,C,l,p);e.add_rect(t,s,c,o)}else e.add_empty()}}_paint(e,i,t){if(!this.visuals.line.doit)return;const{sx0:s,sy0:c,sx1:o,sy1:n,scx0:r,scy0:d,scx1:x,scy1:y}={...this,...t};for(const t of i){const i=s[t],a=c[t],_=o[t],l=n[t],p=r[t],f=d[t],h=x[t],u=y[t];isFinite(i+a+_+l+p+f+h+u)&&(e.beginPath(),e.moveTo(i,a),e.bezierCurveTo(p,f,h,u,_,l),this.visuals.line.apply(e,t))}}draw_legend_for_index(e,i,t){(0,x.generic_line_vector_legend)(this.visuals,e,i,t)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}t.BezierView=_,_.__name__="BezierView";class l extends d.Glyph{constructor(e){super(e)}}t.Bezier=l,o=l,l.__name__="Bezier",o.prototype.default_view=_,o.define((({})=>({x0:[a.XCoordinateSpec,{field:"x0"}],y0:[a.YCoordinateSpec,{field:"y0"}],x1:[a.XCoordinateSpec,{field:"x1"}],y1:[a.YCoordinateSpec,{field:"y1"}],cx0:[a.XCoordinateSpec,{field:"cx0"}],cy0:[a.YCoordinateSpec,{field:"cy0"}],cx1:[a.XCoordinateSpec,{field:"cx1"}],cy1:[a.YCoordinateSpec,{field:"cy1"}]}))),o.mixins(r.LineVector)},
function _(n,t,o,c,s){c(),o.qbb=function(n,t,o,c,s,r){function u(n,t,o){if(t==(n+o)/2)return[n,o];{const c=(n-t)/(n-2*t+o),s=n*(1-c)**2+2*t*(1-c)*c+o*c**2;return[i(n,o,s),f(n,o,s)]}}const[e,a]=u(n,o,s),[x,y]=u(t,c,r);return{x0:e,x1:a,y0:x,y1:y}},o.cbb=function(n,t,o,c,s,i,f,a){const x=f,y=a;f=o,a=c;const b=s,h=i,l=[];for(let o=0;o<=2;o++){let c,s,r;if(0==o?(s=6*n-12*f+6*b,c=-3*n+9*f-9*b+3*x,r=3*f-3*n):(s=6*t-12*a+6*h,c=-3*t+9*a-9*h+3*y,r=3*a-3*t),u(c)<1e-12){if(u(s)<1e-12)continue;const n=-r/s;0<n&&n<1&&l.push(n);continue}const i=s**2-4*r*c,m=e(i);if(i<0)continue;const p=(-s+m)/(2*c);0<p&&p<1&&l.push(p);const q=(-s-m)/(2*c);0<q&&q<1&&l.push(q)}const m=l.length;let p=m;const q=Array(m+2),A=Array(m+2);for(;p-- >0;){const o=l[p],c=1-o,s=c**3*n+3*c**2*o*f+3*c*o**2*b+o**3*x,r=c**3*t+3*c**2*o*a+3*c*o**2*h+o**3*y;q[p]=s,A[p]=r}q[m]=n,A[m]=t,q[m+1]=x,A[m+1]=y;const[g,M,_,d]=(0,r.minmax2)(q,A);return{x0:g,x1:M,y0:_,y1:d}};const r=n(13),{abs:u,sqrt:e,min:i,max:f}=Math},
function _(t,e,i,s,r){var h;s();const n=t(1),_=t(393),a=t(11),o=t(25),c=n.__importStar(t(19));class d extends _.LRTBView{scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){const e=this.x[t],i=this.y[t],s=this.width.get(t),r=this.height.get(t),[h,n]=(0,a.minmax)(e,e+s),[_,o]=(0,a.minmax)(i,i+r);return{l:h,r:n,t:o,b:_}}_map_data(){const{sx:t,sy:e}=this,i=t.length;if(this.inherited_x&&this.inherited_width)this._inherit_attr("sleft"),this._inherit_attr("sright");else{const e=this.sdist(this.renderer.xscale,this.x,this.width,"edge"),s=new o.ScreenArray(i),r=new o.ScreenArray(i);for(let h=0;h<i;h++)s[h]=t[h],r[h]=t[h]+e[h];this._define_attr("sleft",s),this._define_attr("sright",r)}if(this.inherited_y&&this.inherited_height)this._inherit_attr("stop"),this._inherit_attr("sbottom");else{const t=this.sdist(this.renderer.yscale,this.y,this.height,"edge"),s=new o.ScreenArray(i),r=new o.ScreenArray(i);for(let h=0;h<i;h++)s[h]=e[h]-t[h],r[h]=e[h];this._define_attr("stop",s),this._define_attr("sbottom",r)}this._clamp_to_viewport()}}i.BlockView=d,d.__name__="BlockView";class l extends _.LRTB{constructor(t){super(t)}}i.Block=l,h=l,l.__name__="Block",h.prototype.default_view=d,h.define((({})=>({x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}],width:[c.DistanceSpec,{value:1}],height:[c.DistanceSpec,{value:1}]})))},
function _(t,e,r,s,i){var n;s();const a=t(1),o=t(95),_=t(236),c=t(242),h=t(144),d=t(62),l=t(13),p=t(124),x=a.__importStar(t(127)),m=t(197);class u extends _.GlyphView{async load_glglyph(){const{LRTBGL:e}=await Promise.resolve().then((()=>a.__importStar(t(593))));return e}get_anchor_point(t,e,r){const s=Math.min(this.sleft[e],this.sright[e]),i=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:s,y:n};case"top":case"top_center":return{x:(s+i)/2,y:n};case"top_right":return{x:i,y:n};case"bottom_left":return{x:s,y:a};case"bottom":case"bottom_center":return{x:(s+i)/2,y:a};case"bottom_right":return{x:i,y:a};case"left":case"center_left":return{x:s,y:(n+a)/2};case"center":case"center_center":return{x:(s+i)/2,y:(n+a)/2};case"right":case"center_right":return{x:i,y:(n+a)/2}}}_set_data(t){super._set_data(t),this.border_radius=x.border_radius(this.model.border_radius)}_index_data(t){const{min:e,max:r}=Math,{data_size:s}=this;for(let i=0;i<s;i++){const{l:s,r:n,t:a,b:o}=this._lrtb(i);t.add_rect(e(s,n),e(a,o),r(n,s),r(a,o))}}_paint(t,e,r){const{sleft:s,sright:i,stop:n,sbottom:a,border_radius:o}={...this,...r};for(const r of e){const e=s[r],_=n[r],c=i[r],h=a[r];if(!isFinite(e+_+c+h))continue;t.beginPath();const l=d.BBox.from_lrtb({left:e,right:c,top:_,bottom:h});(0,m.round_rect)(t,l,o),this.visuals.fill.apply(t,r),this.visuals.hatch.apply(t,r),this.visuals.line.apply(t,r)}}_clamp_to_viewport(){const{min:t,max:e}=Math,{h_range:r,v_range:s}=this.renderer.plot_view.frame.bbox;this.inherited_sleft||(0,l.inplace_map)(this.sleft,(t=>e(t,r.start))),this.inherited_sright||(0,l.inplace_map)(this.sright,(e=>t(e,r.end))),this.inherited_stop||(0,l.inplace_map)(this.stop,(t=>e(t,s.start))),this.inherited_sbottom||(0,l.inplace_map)(this.sbottom,(e=>t(e,s.end)))}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:r}=t,s=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(r),n=[...this.index.indices({x0:s,y0:i,x1:s,y1:i})];return new h.Selection({indices:n})}_hit_span(t){const{sx:e,sy:r}=t;let s;if("v"==t.direction){const t=this.renderer.yscale.invert(r),e=this.renderer.plot_view.frame.bbox.h_range,[i,n]=this.renderer.xscale.r_invert(e.start,e.end);s=[...this.index.indices({x0:i,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),r=this.renderer.plot_view.frame.bbox.v_range,[i,n]=this.renderer.yscale.r_invert(r.start,r.end);s=[...this.index.indices({x0:t,y0:i,x1:t,y1:n})]}return new h.Selection({indices:s})}draw_legend_for_index(t,e,r){(0,c.generic_area_vector_legend)(this.visuals,t,e,r)}}r.LRTBView=u,u.__name__="LRTBView";class y extends _.Glyph{constructor(t){super(t)}}r.LRTB=y,n=y,y.__name__="LRTB",n.mixins([o.LineVector,o.FillVector,o.HatchVector]),n.define((()=>({border_radius:[p.BorderRadius,0]})))},
function _(t,i,e,s,h){var r;s();const n=t(1),a=t(395),_=t(236),d=n.__importStar(t(243)),l=t(25),o=t(144),c=n.__importStar(t(19));class p extends a.CenterRotatableView{_map_data(){this._define_or_inherit_attr("swidth",(()=>"data"==this.model.properties.width.units?this.inherited_x&&this.inherited_width?_.inherit:this.sdist(this.renderer.xscale,this.x,this.width,"center"):this.inherited_width?_.inherit:(0,l.to_screen)(this.width))),this._define_or_inherit_attr("sheight",(()=>"data"==this.model.properties.height.units?this.inherited_y&&this.inherited_height?_.inherit:this.sdist(this.renderer.yscale,this.y,this.height,"center"):this.inherited_height?_.inherit:(0,l.to_screen)(this.height)))}_paint(t,i,e){const{sx:s,sy:h,swidth:r,sheight:n,angle:a}={...this,...e};for(const e of i){const i=s[e],_=h[e],d=r[e],l=n[e],o=a.get(e);isFinite(i+_+d+l+o)&&(t.beginPath(),t.ellipse(i,_,d/2,l/2,o,0,2*Math.PI),this.visuals.fill.apply(t,e),this.visuals.hatch.apply(t,e),this.visuals.line.apply(t,e))}}_hit_point(t){let i,e,s,h,r,n,a,_,l;const{sx:c,sy:p}=t,w=this.renderer.xscale.invert(c),x=this.renderer.yscale.invert(p);"data"==this.model.properties.width.units?(i=w-this.max_width,e=w+this.max_width):(n=c-this.max_width,a=c+this.max_width,[i,e]=this.renderer.xscale.r_invert(n,a)),"data"==this.model.properties.height.units?(s=x-this.max_height,h=x+this.max_height):(_=p-this.max_height,l=p+this.max_height,[s,h]=this.renderer.yscale.r_invert(_,l));const g=this.index.indices({x0:i,x1:e,y0:s,y1:h}),y=[];for(const t of g)r=d.point_in_ellipse(c,p,this.angle.get(t),this.sheight[t]/2,this.swidth[t]/2,this.sx[t],this.sy[t]),r&&y.push(t);return new o.Selection({indices:y})}draw_legend_for_index(t,{x0:i,y0:e,x1:s,y1:h},r){const n=r+1,a=new Array(n);a[r]=(i+s)/2;const _=new Array(n);_[r]=(e+h)/2;const d=this.swidth[r]/this.sheight[r],l=.8*Math.min(Math.abs(s-i),Math.abs(h-e)),o=new Array(n),p=new Array(n);d>1?(o[r]=l,p[r]=l/d):(o[r]=l*d,p[r]=l);const w=new c.UniformScalar(0,n);this._paint(t,[r],{sx:a,sy:_,swidth:o,sheight:p,angle:w})}}e.EllipseView=p,p.__name__="EllipseView";class w extends a.CenterRotatable{constructor(t){super(t)}}e.Ellipse=w,r=w,w.__name__="Ellipse",r.prototype.default_view=p},
function _(e,t,i,a,n){var r;a();const s=e(1),h=e(235),o=e(95),_=s.__importStar(e(19));class c extends h.XYGlyphView{get max_w2(){return"data"==this.model.properties.width.units?this.max_width/2:0}get max_h2(){return"data"==this.model.properties.height.units?this.max_height/2:0}_bounds({x0:e,x1:t,y0:i,y1:a}){const{max_w2:n,max_h2:r}=this;return{x0:e-n,x1:t+n,y0:i-r,y1:a+r}}}i.CenterRotatableView=c,c.__name__="CenterRotatableView";class l extends h.XYGlyph{constructor(e){super(e)}}i.CenterRotatable=l,r=l,l.__name__="CenterRotatable",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({})=>({angle:[_.AngleSpec,0],width:[_.DistanceSpec,{field:"width"}],height:[_.DistanceSpec,{field:"height"}]})))},
function _(t,e,i,s,r){var h;s();const n=t(1),a=t(393),_=t(25),o=n.__importStar(t(19));class c extends a.LRTBView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){const e=this.left[t],i=this.right[t],s=this.y[t],r=this.height.get(t)/2;return{l:Math.min(e,i),r:Math.max(e,i),t:s+r,b:s-r}}_map_data(){if(this.inherited_y&&this.inherited_height)this._inherit_attr("sheight"),this._inherit_attr("stop"),this._inherit_attr("sbottom");else{const t=this.sdist(this.renderer.yscale,this.y,this.height,"center"),{sy:e}=this,i=this.sy.length,s=new _.ScreenArray(i),r=new _.ScreenArray(i);for(let h=0;h<i;h++){const i=e[h],n=t[h];s[h]=i-n/2,r[h]=i+n/2}this._define_attr("sheight",t),this._define_attr("stop",s),this._define_attr("sbottom",r)}this._clamp_to_viewport()}}i.HBarView=c,c.__name__="HBarView";class d extends a.LRTB{constructor(t){super(t)}}i.HBar=d,h=d,d.__name__="HBar",h.prototype.default_view=c,h.define((({})=>({left:[o.XCoordinateSpec,{value:0}],y:[o.YCoordinateSpec,{field:"y"}],height:[o.DistanceSpec,{value:1}],right:[o.XCoordinateSpec,{field:"right"}]})))},
function _(e,t,s,i,r){var n;i();const a=e(1),o=e(236),c=a.__importStar(e(243)),l=a.__importStar(e(19)),_=e(95),h=e(21),d=e(242),p=e(144);class x extends o.GlyphView{async load_glglyph(){const{HexTileGL:t}=await Promise.resolve().then((()=>a.__importStar(e(589))));return t}scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const{orientation:e,size:t,aspect_scale:s}=this.model,{q:i,r}=this,n=this.q.length,a=new Float64Array(n),o=new Float64Array(n),c=Math.sqrt(3);if("pointytop"==e)for(let e=0;e<n;e++){const n=i.get(e),l=r.get(e)/2;a[e]=t*c*(n+l)/s,o[e]=-3*t*l}else for(let e=0;e<n;e++){const n=i.get(e)/2,l=r.get(e);a[e]=3*t*n,o[e]=-t*c*(l+n)*s}this._define_attr("x",a),this._define_attr("y",o)}_project_data(){this._project_xy("x",this.x,"y",this.y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{x:i,y:r,data_size:n}=this;for(let a=0;a<n;a++){const n=i[a],o=r[a];e.add_rect(n-s,o-t,n+s,o+t)}}map_data(){const[e,t]=this.renderer.coordinates.map_to_screen(this.x,this.y),[s,i]=this._get_unscaled_vertices();this._define_attr("sx",e),this._define_attr("sy",t),this._define_attr("svx",s),this._define_attr("svy",i),this.has_webgl()&&this.glglyph.set_data_mapped()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_paint(e,t,s){const{sx:i,sy:r,svx:n,svy:a,scale:o}={...this,...s};for(const s of t){const t=i[s],c=r[s],l=o.get(s);if(isFinite(t+c+l)){e.translate(t,c),e.beginPath();for(let t=0;t<6;t++)e.lineTo(n[t]*l,a[t]*l);e.closePath(),e.translate(-t,-c),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of n)c.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new p.Selection({indices:a})}_hit_span(e){const t=(()=>{if("v"==e.direction){const{sy:t}=e,s=this.renderer.yscale.invert(t),i=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(i.start,i.end);return{x0:r,y0:s,x1:n,y1:s}}{const{sx:t}=e,s=this.renderer.xscale.invert(t),i=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(i.start,i.end);return{x0:s,y0:r,x1:s,y1:n}}})(),s=[...this.index.indices(t)];return new p.Selection({indices:s})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[o,c]=this.renderer.yscale.r_invert(i,r),l=[...this.index.indices({x0:n,x1:a,y0:o,y1:c})];return new p.Selection({indices:l})}draw_legend_for_index(e,t,s){(0,d.generic_area_vector_legend)(this.visuals,e,t,s)}}s.HexTileView=x,x.__name__="HexTileView";class y extends o.Glyph{constructor(e){super(e)}}s.HexTile=y,n=y,y.__name__="HexTile",n.prototype.default_view=x,n.mixins([_.LineVector,_.FillVector,_.HatchVector]),n.define((({Float:e})=>({r:[l.NumberSpec,{field:"r"}],q:[l.NumberSpec,{field:"q"}],scale:[l.NumberSpec,1],size:[e,1],aspect_scale:[e,1],orientation:[h.HexTileOrientation,"pointytop"]}))),n.override({line_color:null})},
function _(t,e,i,n,s){var _;n();const r=t(1),a=t(236),o=t(242),d=t(144),c=t(95),h=r.__importStar(t(40)),p=t(13),l=t(10),y=r.__importStar(t(19)),{abs:f,max:u}=Math;class x extends a.GlyphView{after_visuals(){super.after_visuals(),this.max_line_width=h.max(this.line_width)}_index_data(t){for(const e of this.y)t.add_point(0,e)}_bounds(t){const{y0:e,y1:i}=t;return{x0:NaN,x1:NaN,y0:e,y1:i}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sy){const e=(0,p.map)(this.sy,(e=>t(e)));this._define_attr("sy",e)}}scenterxy(t){const{hcenter:e}=this.renderer.plot_view.frame.bbox;return[e,this.sy[t]]}_paint(t,e,i){const{sy:n}={...this,...i},{left:s,right:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=n[i];isFinite(e)&&(t.beginPath(),t.moveTo(s,e),t.lineTo(_,e),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_line_width:i}=this,[n,s]=this.renderer.yscale.r_invert(t-i,(e??t)+i);return this.index.indices({x0:0,x1:0,y0:n,y1:s})}_find_spans(t,e){const{sy:i,line_width:n}=this,s=[];for(const _ of t){e(i[_],n.get(_))&&s.push(_)}return s}_hit_point(t){const{sy:e}=t,i=this._get_candidates(e),n=this._find_spans(i,((t,i)=>f(t-e)<=u(i/2,2)));return new d.Selection({indices:n})}_hit_span(t){const e=(()=>{if("v"==t.direction)return(0,l.range)(0,this.data_size);{const{sy:e}=t,i=this._get_candidates(e);return this._find_spans(i,((t,i)=>f(t-e)<=u(i/2,2)))}})();return new d.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sy0:e,sy1:i}=t,n=this._get_candidates(e,i);return this._find_spans(n,((t,n)=>e-n/2<=t&&t<=i+n/2))})();return new d.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_line_vector_legend)(this.visuals,t,e,i)}}i.HSpanView=x,x.__name__="HSpanView";class m extends a.Glyph{constructor(t){super(t)}}i.HSpan=m,_=m,m.__name__="HSpan",_.prototype.default_view=x,_.mixins([c.LineVector]),_.define((()=>({y:[y.YCoordinateSpec,{field:"y"}]})))},
function _(t,e,i,s,r){var n;s();const a=t(1),_=t(236),o=t(242),h=t(144),c=t(95),d=t(25),l=t(13),p=a.__importStar(t(14)),y=t(10),f=a.__importStar(t(19));class u extends _.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>a.__importStar(t(593))));this.glglyph=new i(e.regl_wrapper,this)}}get sleft(){const{left:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get sright(){const{right:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get stop(){return this.sy0}get sbottom(){return this.sy1}_set_data(t){super._set_data(t);const{abs:e}=Math,{max:i,map:s,zip:r}=p,{y0:n,y1:a}=this;if(this.inherited_y0&&this.inherited_y1)this._inherit_attr("max_height");else{const t=i(s(r(n,a),(([t,i])=>e(t-i))));this._define_attr("max_height",t)}}_index_data(t){const{y0:e,y1:i,data_size:s}=this;for(let r=0;r<s;r++){const s=e[r],n=i[r];t.add_rect(0,s,0,n)}}_bounds(t){const{y0:e,y1:i}=t;return{x0:NaN,x1:NaN,y0:e,y1:i}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sy0){const e=(0,l.map)(this.sy0,(e=>t(e)));this._define_attr("sy0",e)}if(!this.inherited_sy1){const e=(0,l.map)(this.sy1,(e=>t(e)));this._define_attr("sy1",e)}}scenterxy(t){const{hcenter:e}=this.renderer.plot_view.frame.bbox;return[e,(this.sy0[t]+this.sy1[t])/2]}_paint(t,e,i){const{sy0:s,sy1:r}={...this,...i},{left:n,right:a,width:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=s[i],o=r[i];isFinite(e+o)&&(t.beginPath(),t.rect(n,e,_,o-e),this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),t.beginPath(),t.moveTo(n,e),t.lineTo(a,e),t.moveTo(n,o),t.lineTo(a,o),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_height:i}=this,[s,r]=this.renderer.yscale.r_invert(t,e??t),n=s-i,a=r+i;return this.index.indices({x0:0,x1:0,y0:n,y1:a})}_find_strips(t,e){function i(t,i){return t<=i?e(t,i):e(i,t)}const{sy0:s,sy1:r}=this,n=[];for(const e of t){i(s[e],r[e])&&n.push(e)}return n}_hit_point(t){const{sy:e}=t,i=this._get_candidates(e),s=this._find_strips(i,((t,i)=>t<=e&&e<=i));return new h.Selection({indices:s})}_hit_span(t){const e=(()=>{if("v"==t.direction)return(0,y.range)(0,this.data_size);{const{sy:e}=t,i=this._get_candidates(e);return this._find_strips(i,((t,i)=>t<=e&&e<=i))}})();return new h.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sy0:e,sy1:i}=t,s=this._get_candidates(e,i);return this._find_strips(s,((t,s)=>e<=t&&t<=i&&e<=s&&s<=i))})();return new h.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_area_vector_legend)(this.visuals,t,e,i)}}i.HStripView=u,u.__name__="HStripView";class g extends _.Glyph{constructor(t){super(t)}}i.HStrip=g,n=g,g.__name__="HStrip",n.prototype.default_view=u,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((()=>({y0:[f.YCoordinateSpec,{field:"y0"}],y1:[f.YCoordinateSpec,{field:"y1"}]})))},
function _(e,t,r,a,n){var i,o,_=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,a,n)}:function(e,t,r,a){void 0===a&&(a=r),e[a]=t[r]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),c=this&&this.__importStar||(i=function(e){return i=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t},i(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r=i(e),a=0;a<r.length;a++)"default"!==r[a]&&_(t,e,r[a]);return s(t,e),t});a();const l=e(401),u=e(230),p=e(289);class f extends l.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>c(e(590))));return t}connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}_update_image(){this.has_webgl()&&this.glglyph.set_image_changed(),null!=this.image_data&&(this._set_data(null),this.renderer.request_paint())}get _can_inherit_image_data(){return super._can_inherit_image_data&&this._can_inherit_from(this.model.properties.color_mapper,this.base)}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}r.ImageView=f,f.__name__="ImageView";class d extends l.ImageBase{constructor(e){super(e)}}r.Image=d,o=d,d.__name__="Image",o.prototype.default_view=f,o.define((({Ref:e})=>({color_mapper:[e(u.ColorMapper),()=>new p.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})))},
function _(t,e,i,s,a){var r;s();const n=t(1),h=t(235),_=t(236),o=t(25),d=t(21),g=n.__importStar(t(19)),c=n.__importStar(t(95)),l=t(144),m=t(12),u=t(124),x=t(127),f=t(115);class y extends h.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_paint()))}get image_dimension(){return 2}get xy_scale(){switch(this.model.origin){case"bottom_left":return{x:1,y:-1};case"top_left":return{x:1,y:1};case"bottom_right":return{x:-1,y:-1};case"top_right":return{x:-1,y:1}}}get xy_offset(){switch(this.model.origin){case"bottom_left":return{x:0,y:1};case"top_left":return{x:0,y:0};case"bottom_right":return{x:1,y:1};case"top_right":return{x:1,y:0}}}get xy_anchor(){return(0,x.anchor)(this.model.anchor)}get xy_sign(){const t=this.renderer.xscale.source_range,e=this.renderer.yscale.source_range;return{x:t.is_reversed?-1:1,y:e.is_reversed?-1:1}}_paint(t,e,i){const{image_data:s,sx:a,sy:r,sdw:n,sdh:h}={...this,...i},{xy_sign:_,xy_scale:o,xy_offset:d,xy_anchor:g}=this;if((0,m.assert)(null!=s),t.save(),t.imageSmoothingEnabled=!1,this.visuals.image.doit)for(const i of e){const e=s[i],c=a[i],l=r[i],m=n[i],u=h[i];if(null==e||!isFinite(c+l+m+u))continue;const x=_.x*g.x*m,f=_.y*g.y*u;t.save(),t.translate(c-x,l-f),t.scale(_.x*o.x,_.y*o.y),this.visuals.image.set_vectorize(t,i),t.drawImage(e,-d.x*m,-d.y*u,m,u),t.restore()}t.restore()}get _can_inherit_image_data(){return this.inherited_image}_set_data(t){const e=this.data_size;if(this._can_inherit_image_data)this._inherit_attr("image_data"),this._inherit_attr("image_width"),this._inherit_attr("image_height");else{void 0!==this.image_data&&this.image_data.length==e||(this._define_attr("image_data",new Array(e).fill(null)),this._define_attr("image_width",new Uint32Array(e)),this._define_attr("image_height",new Uint32Array(e)));const{image_dimension:i}=this;for(let s=0;s<e;s++){if(null!=t&&!t.includes(s))continue;const e=this.image.get(s);(0,m.assert)(e.dimension==i,`expected a ${i}D array, not ${e.dimension}D`);const[a,r]=e.shape;this.image_width[s]=r,this.image_height[s]=a;const n=this._flat_img_to_buf8(e);this._set_image_data_from_buffer(s,n)}}}_index_data(t){const{data_size:e}=this;for(let i=0;i<e;i++){const[e,s,a,r]=this._lrtb(i);t.add_rect(e,r,s,a)}}_lrtb(t){const e=this.dw.get(t),i=this.dh.get(t),s=this.x[t],a=this.y[t],{xy_anchor:r}=this,[n,h]=[s-r.x*e,s+(1-r.x)*e],[_,o]=[a+r.y*i,a-(1-r.y)*i],[d,g]=n<=h?[n,h]:[h,n],[c,l]=_<=o?[_,o]:[o,_];return[d,g,l,c]}_get_or_create_canvas(t){(0,m.assert)(null!=this.image_data);const e=this.image_data[t];if(null!=e&&e.width==this.image_width[t]&&e.height==this.image_height[t])return e;{const e=document.createElement("canvas");return e.width=this.image_width[t],e.height=this.image_height[t],e}}_set_image_data_from_buffer(t,e){(0,m.assert)(null!=this.image_data);const i=this._get_or_create_canvas(t),s=i.getContext("2d",{willReadFrequently:!0});(0,m.assert)(null!=s);const a=s.getImageData(0,0,this.image_width[t],this.image_height[t]);a.data.set(e),s.putImageData(a,0,0),this.image_data[t]=i}_map_data(){this._define_or_inherit_attr("sdw",(()=>"data"==this.model.properties.dw.units?this.inherited_x&&this.inherited_dw?_.inherit:this.sdist(this.renderer.xscale,this.x,this.dw,"edge",this.model.dilate):this.inherited_dw?_.inherit:(0,o.to_screen)(this.dw))),this._define_or_inherit_attr("sdh",(()=>"data"==this.model.properties.dh.units?this.inherited_y&&this.inherited_dh?_.inherit:this.sdist(this.renderer.yscale,this.y,this.dh,"edge",this.model.dilate):this.inherited_dh?_.inherit:(0,o.to_screen)(this.dh)))}_image_index(t,e,i){const[s,a,r,n]=this._lrtb(t),h=this.image_width[t],_=this.image_height[t],o=(()=>this.renderer.xscale instanceof f.LogScale?Math.log(e/s)/Math.log(a/s):(e-s)/(a-s))(),d=(()=>this.renderer.yscale instanceof f.LogScale?Math.log(i/n)/Math.log(r/n):(i-n)/(r-n))(),g=Math.floor(o*h),c=Math.floor(d*_);return{index:t,i:g,j:c,flat_index:c*h+g}}_hit_point(t){const{sx:e,sy:i}=t,s=this.renderer.xscale.invert(e),a=this.renderer.yscale.invert(i),r=this.index.indices({x0:s,x1:s,y0:a,y1:a}),n=new l.Selection,h=[];for(const t of r)isFinite(e)&&isFinite(i)&&(h.push(t),n.image_indices.push(this._image_index(t,s,a)));return n.indices=h,n}}i.ImageBaseView=y,y.__name__="ImageBaseView";class w extends h.XYGlyph{constructor(t){super(t)}}i.ImageBase=w,r=w,w.__name__="ImageBase",r.mixins(c.ImageVector),r.define((({Bool:t})=>({image:[g.NDArraySpec,{field:"image"}],dw:[g.DistanceSpec,{field:"dw"}],dh:[g.DistanceSpec,{field:"dh"}],dilate:[t,!1],origin:[d.ImageOrigin,"bottom_left"],anchor:[u.Anchor,"bottom_left"]})))},
function _(e,t,r,n,a){var i,o,u=this&&this.__createBinding||(Object.create?function(e,t,r,n){void 0===n&&(n=r);var a=Object.getOwnPropertyDescriptor(t,r);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[r]}}),Object.defineProperty(e,n,a)}:function(e,t,r,n){void 0===n&&(n=r),e[n]=t[r]}),c=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(i=function(e){return i=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t},i(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var r=i(e),n=0;n<r.length;n++)"default"!==r[n]&&u(t,e,r[n]);return c(t,e),t});n();const l=e(401),f=e(8);class _ extends l.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>s(e(590))));return t}_flat_img_to_buf8(e){const t=(0,f.isTypedArray)(e)?e:new Uint32Array(e);return new Uint8ClampedArray(t.buffer)}}r.ImageRGBAView=_,_.__name__="ImageRGBAView";class g extends l.ImageBase{constructor(e){super(e)}}r.ImageRGBA=g,o=g,g.__name__="ImageRGBA",o.prototype.default_view=_},
function _(e,t,a,r,n){var i,o,_=this&&this.__createBinding||(Object.create?function(e,t,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,r,n)}:function(e,t,a,r){void 0===r&&(r=a),e[r]=t[a]}),s=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),c=this&&this.__importStar||(i=function(e){return i=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t},i(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a=i(e),r=0;r<a.length;r++)"default"!==a[r]&&_(t,e,a[r]);return s(t,e),t});r();const l=e(401),u=e(292);class g extends l.ImageBaseView{async load_glglyph(){const{ImageGL:t}=await Promise.resolve().then((()=>c(e(590))));return t}connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}get image_dimension(){return 3}_update_image(){this.has_webgl()&&this.glglyph.set_image_changed(),null!=this.image_data&&(this._set_data(null),this.renderer.request_paint())}get _can_inherit_image_data(){return super._can_inherit_image_data&&this._can_inherit_from(this.model.properties.color_mapper,this.base)}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}a.ImageStackView=g,g.__name__="ImageStackView";class p extends l.ImageBase{constructor(e){super(e)}}a.ImageStack=p,o=p,p.__name__="ImageStack",o.prototype.default_view=g,o.define((({Ref:e})=>({color_mapper:[e(u.StackColorMapper)]})))},
function _(e,t,i,s,r){var n;s();const a=e(1),h=e(235),l=e(236),o=e(25),d=e(21),_=a.__importStar(e(19)),c=e(10),u=e(13),m=e(191),g=a.__importStar(e(127));class p extends h.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1,this.image=new Array(0),this._set_data_iteration=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_paint()))}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++)e.add_empty()}_set_data(){if(this.inherited_url)return;this._set_data_iteration++;const{url:e}=this,t=e.length;this.image=(0,c.resize)(this.image,t,null),this.loaders=new Array(t).fill(null),this.resolved=new o.Indices(t);const{retry_attempts:i,retry_timeout:s}=this.model,{_set_data_iteration:r}=this;for(let n=0;n<t;n++){const t=e.get(n);if(""==t)continue;const a=new m.ImageLoader(t,{loaded:e=>{this._set_data_iteration!=r||this.resolved.get(n)||(this.resolved.set(n),this.image[n]=e,this.loaders[n]=null,this.renderer.request_paint())},failed:()=>{if(this._set_data_iteration==r){this.resolved.set(n),this.loaders[n]=null;null!=this.image[n]&&(this.image[n]=null,this.renderer.request_paint())}},attempts:i+1,timeout:s});this.loaders[n]=a}const n="data"==this.model.properties.w.units,a="data"==this.model.properties.h.units,h=this.data_size,l=new o.ScreenArray(n?2*h:h),d=new o.ScreenArray(a?2*h:h);this.anchor=g.anchor(this.model.anchor);const{x:_,y:p}=this.anchor;function f(e,t){const i=e-_*t;return[i,i+t]}function w(e,t){const i=e+p*t;return[i,i-t]}if(n)for(let e=0;e<h;e++)[l[e],l[h+e]]=f(this.x[e],this.w.get(e)??0);else l.set(this.x,0);if(a)for(let e=0;e<h;e++)[d[e],d[h+e]]=w(this.y[e],this.h.get(e)??0);else d.set(this.y,0);const[y,x,b,v]=(0,u.minmax2)(l,d);this._bounds_rect={x0:y,x1:x,y0:b,y1:v}}has_finished(){return super.has_finished()&&this._images_rendered}_map_data(){const e=()=>this.w.map((e=>e??NaN)),t=()=>this.h.map((e=>e??NaN));this._define_or_inherit_attr("sw",(()=>"data"==this.model.properties.w.units?this.inherited_x&&this.inherited_w?l.inherit:this.sdist(this.renderer.xscale,this.x,e(),"edge",this.model.dilate):this.inherited_w?l.inherit:(0,o.to_screen)(e()))),this._define_or_inherit_attr("sh",(()=>"data"==this.model.properties.h.units?this.inherited_y&&this.inherited_h?l.inherit:this.sdist(this.renderer.yscale,this.y,t(),"edge",this.model.dilate):this.inherited_h?l.inherit:(0,o.to_screen)(t())))}_paint(e,t,i){const{sx:s,sy:r,sw:n,sh:a,angle:h,global_alpha:l}={...this,...i},{image:o,loaders:d,resolved:_}=this,{frame:c}=this.renderer.plot_view,{left:u,top:m,width:g,height:p}=c.bbox;e.beginPath(),e.rect(u+1,m+1,g-2,p-2),e.clip();let f=!0;for(const i of t){const t=d[i];if(!isFinite(s[i]+r[i]+h.get(i)+l.get(i)))continue;_.get(i)||(null!=t&&t.image.complete?(o[i]=t.image,d[i]=null,_.set(i)):f=!1);const c=o[i];null!=c&&(0==c.naturalWidth&&0==c.naturalHeight||this._render_image(e,i,c,s,r,n,a,h,l))}f&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_render_image(e,t,i,s,r,n,a,h,l){isFinite(n[t])||(n[t]=i.width),isFinite(a[t])||(a[t]=i.height);const o=n[t],d=a[t],{anchor:_}=this,c=_.x*o,u=_.y*d,m=s[t]-c,g=r[t]-u,p=h.get(t),f=l.get(t);e.save(),e.globalAlpha=f;const w=o/2,y=d/2;0!=p?(e.translate(m,g),e.translate(w,y),e.rotate(p),e.translate(-w,-y),e.drawImage(i,0,0,o,d),e.translate(w,y),e.rotate(-p),e.translate(-w,-y),e.translate(-m,-g)):e.drawImage(i,m,g,o,d),e.restore()}bounds(){return this._bounds_rect}}i.ImageURLView=p,p.__name__="ImageURLView";class f extends h.XYGlyph{constructor(e){super(e)}}i.ImageURL=f,n=f,f.__name__="ImageURL",n.prototype.default_view=p,n.define((({Bool:e,Int:t})=>({url:[_.StringSpec,{field:"url"}],anchor:[d.Anchor,"top_left"],global_alpha:[_.NumberSpec,{value:1}],angle:[_.AngleSpec,0],w:[_.NullDistanceSpec,null],h:[_.NullDistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]})))},
function _(t,e,a,h,l){var M;h();const _=t(406),n=t(190);class p extends _.MathTextGlyphView{_build_label(t){return new n.MathML({text:t})}}a.MathMLGlyphView=p,p.__name__="MathMLGlyphView";class s extends _.MathTextGlyph{constructor(t){super(t)}}a.MathMLGlyph=s,M=s,s.__name__="MathMLGlyph",M.prototype.default_view=p},
function _(e,t,s,i,l){i();const a=e(407),n=e(190),r=e(69),h=e(14);class _ extends a.TextView{constructor(){super(...arguments),this._label_views=new Map}remove(){(0,r.remove_views)(this._label_views),super.remove()}*children(){yield*super.children(),yield*this._label_views.values()}has_finished(){if(!super.has_finished())return!1;for(const e of this._label_views.values())if(!e.has_finished())return!1;return!0}async _build_labels(e){const t=Array.from(e,(e=>null==e?null:this._build_label(e)));return await(0,r.build_views)(this._label_views,t.filter((e=>null!=e)),{parent:this.renderer}),t.map((e=>null==e?null:this._label_views.get(e).graphics()))}async after_lazy_visuals(){await super.after_lazy_visuals();const e=[...this._label_views.values()].map((e=>e instanceof n.MathTextView?e.request_image():null));await Promise.allSettled(e);const{left:t,right:s,top:i,bottom:l}=this.padding;for(const[e,a]of(0,h.enumerate)(this.labels)){if(null==e)continue;if(!(e instanceof n.MathTextView))continue;const r=e.size(),h=t+r.width+s,_=i+r.height+l;this.swidth[a]=h,this.sheight[a]=_}}}s.MathTextGlyphView=_,_.__name__="MathTextGlyphView";class u extends a.Text{constructor(e){super(e)}}s.MathTextGlyph=u,u.__name__="MathTextGlyph"},
function _(t,e,a,i,s){var n;i();const o=t(1),r=t(235),l=o.__importStar(t(95)),h=o.__importStar(t(19)),c=t(40),_=t(144),d=t(62),u=t(14),x=t(73),p=t(192),g=t(124),f=o.__importStar(t(127)),y=t(197),b=t(11);class w extends h.DataSpec{}w.__name__="TextAnchorSpec";class m extends h.DataSpec{}m.__name__="OutlineShapeSpec";class v extends r.XYGlyphView{async _build_labels(t){return Array.from(t,(t=>{if(null==t)return null;{const e=`${t}`;return new p.TextBox({text:e})}}))}async _set_lazy_data(){this.inherited_text?this._inherit_attr("labels"):this._define_attr("labels",await this._build_labels(this.text))}after_visuals(){super.after_visuals();const t=this.data_size,{anchor:e}=this.base??this,{padding:a,border_radius:i}=this.model,{text_align:s,text_baseline:n}=this.visuals.text;if(e.is_Scalar()&&"auto"!=e.value)this.anchor_=new c.UniformScalar(f.anchor(e.value),t);else if(e.is_Scalar()&&s.is_Scalar()&&n.is_Scalar())this.anchor_=new c.UniformScalar(f.text_anchor(e.value,s.value,n.value),t);else{const a=new Array(t);for(let i=0;i<t;i++){const t=e.get(i),o=s.get(i),r=n.get(i);a[i]=f.text_anchor(t,o,r)}this.anchor_=new c.UniformVector(a)}this.padding=f.padding(a),this.border_radius=f.border_radius(i),this.swidth=new Float32Array(t),this.sheight=new Float32Array(t);const{left:o,right:r,top:l,bottom:h}=this.padding;for(const[t,e]of(0,u.enumerate)(this.labels)){if(null==t)continue;t.visuals=this.visuals.text.values(e),t.position={sx:0,sy:0,x_anchor:"left",y_anchor:"top"},t.align="auto";const a=t.size(),i=o+a.width+r,s=l+a.height+h;this.swidth[e]=i,this.sheight[e]=s}}_paint(t,e,a){const{sx:i,sy:s,x_offset:n,y_offset:o,angle:r,outline_shape:l}={...this,...a},{text:h,background_fill:c,background_hatch:_,border_line:u}=this.visuals,{anchor_:x,border_radius:p,padding:g}=this,{labels:f,swidth:y,sheight:b}=this;for(const a of e){const e=i[a]+n.get(a),w=s[a]+o.get(a),m=r.get(a),v=f[a],T=l.get(a);if(!isFinite(e+w+m)||null==v)continue;const S=y[a],N=b[a],k=x.get(a),B=k.x*S,P=k.y*N;if(t.translate(e,w),t.rotate(m),t.translate(-B,-P),"none"!=T&&(c.v_doit(a)||_.v_doit(a)||u.v_doit(a))){const e=new d.BBox({x:0,y:0,width:S,height:N}),i={fill:c,hatch:_,line:u};this._paint_shape(t,a,T,e,i,p)}if(h.v_doit(a)){const{left:e,top:i}=g;t.translate(e,i),v.visuals=h.values(a),v.paint(t),t.translate(-e,-i)}t.translate(B,P),t.rotate(-m),t.translate(-e,-w)}}_paint_shape(t,e,a,i,s,n){switch(t.beginPath(),a){case"none":break;case"box":case"rectangle":(0,y.round_rect)(t,i,n);break;case"square":{const e=(()=>{const{x:t,y:e,width:a,height:s}=i;if(a>s){const i=(a-s)/2;return new d.BBox({x:t,y:e-i,width:a,height:a})}{const i=(s-a)/2;return new d.BBox({x:t-i,y:e,width:s,height:s})}})();(0,y.round_rect)(t,e,n);break}case"circle":{const e=i.x_center,a=i.y_center,s=(0,b.sqrt)(i.width**2+i.height**2)/2;t.arc(e,a,s,0,2*b.PI,!1);break}case"ellipse":{const e=i.x_center,a=i.y_center,s=1.5,n=i.width/2,o=i.height/2,r=(0,b.sqrt)(n**2+n**(2/s)*o**(2-2/s)),l=(0,b.sqrt)(o**2+o**(2/s)*n**(2-2/s));t.ellipse(e,a,r,l,0,0,2*b.PI);break}case"trapezoid":{const{left:e,right:a,top:s,bottom:n,width:o}=i,r=.2*o;t.moveTo(e,s),t.lineTo(a,s),t.lineTo(a+r,n),t.lineTo(e-r,n),t.closePath();break}case"parallelogram":{const{left:e,right:a,top:s,bottom:n,width:o}=i,r=.2*o;t.moveTo(e,s),t.lineTo(a+r,s),t.lineTo(a,n),t.lineTo(e-r,n),t.closePath();break}case"diamond":{const{x_center:e,y_center:a,width:s,height:n}=i;t.moveTo(e,a-n),t.lineTo(s+s/2,a),t.lineTo(e,a+n),t.lineTo(-s/2,a),t.closePath();break}case"triangle":{const e=i.width,a=i.height,s=(0,b.sqrt)(3)/2*e,n=a+s;t.translate(e/2,-s),t.moveTo(0,0),t.lineTo(n/2,n),t.lineTo(-n/2,n),t.closePath(),t.translate(-e/2,s);break}}s.fill.apply(t,e),s.hatch.apply(t,e),s.line.apply(t,e)}_hit_point(t){const e={x:t.sx,y:t.sy},{sx:a,sy:i,x_offset:s,y_offset:n,angle:o,labels:r}=this,{anchor_:l}=this,{swidth:h,sheight:c}=this,d=this.data_size,u=[];for(let t=0;t<d;t++){const _=a[t]+s.get(t),d=i[t]+n.get(t),p=o.get(t),g=r[t];if(!isFinite(_+d+p)||null==g)continue;const f=h[t],y=c[t],b=l.get(t),w=b.x*f,m=b.y*y,{x:v,y:T}=(0,x.rotate_around)(e,{x:_,y:d},-p),S=_-w,N=d-m;S<=v&&v<=S+f&&N<=T&&T<=N+y&&u.push(t)}return new _.Selection({indices:u})}rect_i(t){const{sx:e,sy:a,x_offset:i,y_offset:s,angle:n,labels:o}=this,{anchor_:r}=this,{swidth:l,sheight:h}=this,c=e[t]+i.get(t),_=a[t]+s.get(t),u=n.get(t),p=o[t];if(!isFinite(c+_+u)||null==p)return{p0:{x:NaN,y:NaN},p1:{x:NaN,y:NaN},p2:{x:NaN,y:NaN},p3:{x:NaN,y:NaN}};const g=l[t],f=h[t],y=r.get(t),b=y.x*g,w=y.y*f,m=new d.BBox({x:c-b,y:_-w,width:g,height:f}),{rect:v}=m;if(0==u)return v;{const t=new x.AffineTransform;return t.rotate_around(c,_,u),t.apply_rect(v)}}scenterxy(t){const{p0:e,p1:a,p2:i,p3:s}=this.rect_i(t);return[(e.x+a.x+i.x+s.x)/4,(e.y+a.y+i.y+s.y)/4]}}a.TextView=v,v.__name__="TextView";class T extends r.XYGlyph{constructor(t){super(t)}}a.Text=T,n=T,T.__name__="Text",n.prototype.default_view=v,n.mixins([l.TextVector,["border_",l.LineVector],["background_",l.FillVector],["background_",l.HatchVector]]),n.define((()=>({text:[h.NullStringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,0],y_offset:[h.NumberSpec,0],anchor:[w,{value:"auto"}],padding:[g.Padding,0],border_radius:[g.BorderRadius,0],outline_shape:[m,"box"]}))),n.override({border_line_color:null,background_fill_color:null,background_hatch_color:null})},
function _(t,e,s,i,n){var o;i();const r=t(1),l=t(95),_=r.__importStar(t(243)),a=r.__importStar(t(19)),c=t(13),h=t(236),d=t(242),x=t(144);class g extends h.GlyphView{async load_glglyph(){const{MultiLineGL:e}=await Promise.resolve().then((()=>r.__importStar(t(594))));return e}_project_data(){this._project_xy("xs",this.xs.data,"ys",this.ys.data)}_index_data(t){const{data_size:e}=this;for(let s=0;s<e;s++){const e=this.xs.get(s),i=this.ys.get(s),[n,o,r,l]=(0,c.minmax2)(e,i);t.add_rect(n,r,o,l)}}_paint(t,e,s){const{sxs:i,sys:n}={...this,...s};for(const s of e){const e=i.get(s),o=n.get(s),r=Math.min(e.length,o.length);let l=!0;t.beginPath();for(let s=0;s<r;s++){const i=e[s],n=o[s];isFinite(i+n)?l?(t.moveTo(i,n),l=!1):t.lineTo(i,n):l=!0}this.visuals.line.set_vectorize(t,s),t.stroke()}}_hit_point(t){const e={x:t.sx,y:t.sy};let s=9999;const i=new Map;for(let t=0,n=this.sxs.length;t<n;t++){const n=Math.max(2,this.line_width.get(t)/2),o=this.sxs.get(t),r=this.sys.get(t);let l=null;for(let t=0,i=o.length-1;t<i;t++){const i={x:o[t],y:r[t]},a={x:o[t+1],y:r[t+1]},c=_.dist_to_segment(e,i,a);c<n&&c<s&&(s=c,l=[t])}null!=l&&i.set(t,l)}return new x.Selection({indices:[...i.keys()],multiline_indices:i})}_hit_span(t){const{sx:e,sy:s}=t;let i,n;"v"==t.direction?(i=this.renderer.yscale.invert(s),n=this.ys):(i=this.renderer.xscale.invert(e),n=this.xs);const o=new Map;for(let t=0,e=n.length;t<e;t++){const e=n.get(t),s=[];for(let t=0,n=e.length-1;t<n;t++)e[t]<=i&&i<=e[t+1]&&s.push(t);s.length>0&&o.set(t,s)}return new x.Selection({indices:[...o.keys()],multiline_indices:o})}get_interpolation_hit(t,e,s){const i=this.xs.get(t),n=this.ys.get(t),o=i[e],r=n[e],l=i[e+1],_=n[e+1];return(0,d.line_interpolation)(this.renderer,s,o,r,l,_)}draw_legend_for_index(t,e,s){(0,d.generic_line_vector_legend)(this.visuals,t,e,s)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}s.MultiLineView=g,g.__name__="MultiLineView";class y extends h.Glyph{constructor(t){super(t)}}s.MultiLine=y,o=y,y.__name__="MultiLine",o.prototype.default_view=g,o.define((({})=>({xs:[a.XCoordinateSeqSpec,{field:"xs"}],ys:[a.YCoordinateSeqSpec,{field:"ys"}]}))),o.mixins(l.LineVector)},
function _(t,e,s,n,i){var o;n();const r=t(1),l=t(238),h=t(236),a=t(242),_=t(13),c=t(13),d=t(95),y=r.__importStar(t(243)),f=r.__importStar(t(19)),x=t(144),g=t(12);class p extends h.GlyphView{_project_data(){}_index_data(t){const{min:e,max:s}=Math,{data_size:n}=this;for(let i=0;i<n;i++){const n=this.xs[i],o=this.ys[i];if(0==n.length||0==o.length){t.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let t=0,i=n.length;t<i;t++){const i=n[t][0],c=o[t][0];if(0!=i.length&&0!=c.length){const[t,n,o,d]=(0,_.minmax2)(i,c);r=e(r,t),l=s(l,n),h=e(h,o),a=s(a,d)}}t.add_rect(r,h,l,a)}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:t,max:e}=Math,{data_size:s}=this,n=new l.SpatialIndex(s);for(let i=0;i<s;i++){const s=this.xs[i],o=this.ys[i];if(0==s.length||0==o.length){n.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let n=0,i=s.length;n<i;n++){const i=s[n],c=o[n];if(i.length>1&&c.length>1)for(let s=1,n=i.length;s<n;s++){const[n,o,d,y]=(0,_.minmax2)(i[s],c[s]);r=t(r,n),l=e(l,o),h=t(h,d),a=e(a,y)}}n.add_rect(r,h,l,a)}return n.finish(),n}_mask_data(){const{x_source:t,y_source:e}=this.renderer.coordinates;return this.index.indices({x0:t.min,x1:t.max,y0:e.min,y1:e.max})}_paint(t,e,s){if(!this.visuals.fill.doit&&!this.visuals.line.doit)return;const{sxs:n,sys:i}={...this,...s};for(const s of e){t.beginPath();const e=n[s],o=i[s],r=Math.min(e.length,o.length);for(let s=0;s<r;s++){const n=e[s],i=o[s],r=Math.min(n.length,i.length);for(let e=0;e<r;e++){const s=n[e],o=i[e],r=Math.min(s.length,o.length);for(let e=0;e<r;e++){const n=s[e],i=o[e];0==e?t.moveTo(n,i):t.lineTo(n,i)}t.closePath()}}this.visuals.fill.apply(t,s,"evenodd"),this.visuals.hatch.apply(t,s,"evenodd"),this.visuals.line.apply(t,s)}}_hit_poly(t){const{sx:e,sy:s,greedy:n=!1}=t,i=(()=>{const t=this.renderer.xscale.v_invert(e),n=this.renderer.yscale.v_invert(s),[i,o,r,l]=(0,_.minmax2)(t,n);return this.index.indices({x0:i,x1:o,y0:r,y1:l})})(),o=[];for(const t of i){const i=this.sxs[t],r=this.sys[t];let l=!n;const h=i.length;for(let t=0;t<h;t++){const o=i[t][0],h=r[t][0],a=o.length;for(let t=0;t<a;t++){const i=o[t],r=h[t];if(y.point_in_poly(i,r,e,s)){if(n){l=!0;break}}else if(!n){l=!1;break}}if(n){if(l)break}else if(!l)break}l&&o.push(t)}return new x.Selection({indices:o})}_hit_rect(t){const{sx0:e,sx1:s,sy0:n,sy1:i,greedy:o}=t,r=[e,s,s,e],l=[n,n,i,i];return this._hit_poly({type:"poly",sx:r,sy:l,greedy:o})}_hit_point(t){const{sx:e,sy:s}=t,n=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(s),o=this.index.indices({x0:n,y0:i,x1:n,y1:i}),r=this._hole_index.indices({x0:n,y0:i,x1:n,y1:i}),l=[];for(const t of o){const n=this.sxs[t],i=this.sys[t];for(let o=0,h=n.length;o<h;o++){const h=n[o].length;if(y.point_in_poly(e,s,n[o][0],i[o][0]))if(1==h)l.push(t);else if(r.get(t)){if(h>1){let r=!1;for(let t=1;t<h;t++){const l=n[o][t],h=i[o][t];if(y.point_in_poly(e,s,l,h)){r=!0;break}}r||l.push(t)}}else l.push(t)}}return new x.Selection({indices:l})}_get_snap_coord(t){return(0,c.sum)(t)/t.length}scenterxy(t,e,s){if(1==this.sxs[t].length){return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])]}{const n=this.sxs[t],i=this.sys[t];for(let t=0,o=n.length;t<o;t++)if(y.point_in_poly(e,s,n[t][0],i[t][0])){return[this._get_snap_coord(n[t][0]),this._get_snap_coord(i[t][0])]}}(0,g.unreachable)()}map_data(){if(this.inherited_xs&&this.inherited_ys)this._inherit_attr("sxs"),this._inherit_attr("sys");else{const{xs:t,ys:e}=this,s=t.length,n=new Array(s),i=new Array(s);for(let o=0;o<s;o++){const s=t[o].length;n[o]=new Array(s),i[o]=new Array(s);for(let r=0;r<s;r++){const s=t[o][r].length;n[o][r]=new Array(s),i[o][r]=new Array(s);for(let l=0;l<s;l++){const[s,h]=this.renderer.coordinates.map_to_screen(t[o][r][l],e[o][r][l]);n[o][r][l]=s,i[o][r][l]=h}}}this._define_attr("sxs",n),this._define_attr("sys",i)}}draw_legend_for_index(t,e,s){(0,a.generic_area_vector_legend)(this.visuals,t,e,s)}}s.MultiPolygonsView=p,p.__name__="MultiPolygonsView";class u extends h.Glyph{constructor(t){super(t)}}s.MultiPolygons=u,o=u,u.__name__="MultiPolygons",o.prototype.default_view=p,o.define((({})=>({xs:[f.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[f.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}))),o.mixins([d.LineVector,d.FillVector,d.HatchVector])},
function _(e,n,t,s,i){var r;s();const o=e(1),c=e(305),a=e(13),l=e(243),h=o.__importStar(e(19)),y=e(144);function _(e,n,t,s,i){const r=new Float32Array(s),o=new Float32Array(s),c=2*Math.PI/s;for(let a=0;a<s;a++){const s=a*c+i;r[a]=e+t*Math.sin(s),o[a]=n+t*-Math.cos(s)}return[r,o]}class d extends c.RadialGlyphView{async load_glglyph(){const{NgonGL:n}=await Promise.resolve().then((()=>o.__importStar(e(596))));return n}_paint(e,n,t){const{sx:s,sy:i,sradius:r,angle:o,n:c}={...this,...t};for(const t of n){const n=s[t],a=i[t],l=r[t],h=o.get(t),y=c.get(t);if(y<3||!isFinite(n+a+l+h+y))continue;const[d,p]=_(n,a,l,y,h);e.beginPath(),e.moveTo(d[0],p[0]);for(let n=1;n<=y;n++)e.lineTo(d[n],p[n]);e.closePath(),this.visuals.fill.apply(e,t),this.visuals.hatch.apply(e,t),this.visuals.line.apply(e,t)}}_ngon(e){const{sx:n,sy:t,sradius:s,angle:i,n:r}={...this},o=n[e],c=t[e],a=s[e],l=i.get(e);return _(o,c,a,r.get(e),l)}_hit_point(e){const n=this.renderer.xscale.invert(e.sx),t=this.renderer.yscale.invert(e.sy),s=this.index.indices({x0:n,y0:t,x1:n,y1:t}),i=[];for(const n of s){const[t,s]=this._ngon(n);(0,l.point_in_poly)(e.sx,e.sy,t,s)&&i.push(n)}return new y.Selection({indices:i})}_hit_span(e){const{sx:n,sy:t}=e,{x0:s,x1:i,y0:r,y1:o}=this.bounds(),[c,a,l]=(()=>{switch(e.direction){case"v":{const e=this.renderer.yscale.invert(t),n=this.index.indices({x0:s,y0:e,x1:i,y1:e});return[t,1,n]}case"h":{const e=this.renderer.xscale.invert(n),t=this.index.indices({x0:e,y0:r,x1:e,y1:o});return[n,0,t]}}})(),h=[];for(const e of l){const n=this._ngon(e)[a];for(let t=0;t<n.length-1;t++)if(n[t]<=c&&c<=n[t+1]||n[t+1]<=c&&c<=n[t]){h.push(e);break}}return new y.Selection({indices:h})}_hit_poly(e){const{sx:n,sy:t}=e,s=(()=>{const e=this.renderer.xscale.v_invert(n),s=this.renderer.yscale.v_invert(t),[i,r,o,c]=(0,a.minmax2)(e,s);return this.index.indices({x0:i,x1:r,y0:o,y1:c})})(),i=[];for(const e of s){const[s,r]=this._ngon(e);(0,l.vertex_overlap)(s,r,n,t)?i.push(e):(0,l.edge_intersection)(s,r,n,t)&&i.push(e)}return new y.Selection({indices:i})}_hit_rect(e){const{sx0:n,sx1:t,sy0:s,sy1:i}=e,r=[n,t,t,n],o=[s,s,i,i];return this._hit_poly({type:"poly",sx:r,sy:o})}}t.NgonView=d,d.__name__="NgonView";class p extends c.RadialGlyph{constructor(e){super(e)}}t.Ngon=p,r=p,p.__name__="Ngon",r.prototype.default_view=d,r.define((()=>({angle:[h.AngleSpec,0],n:[h.NumberSpec,{field:"n"}]})))},
function _(e,t,s,i,n){var r;i();const o=e(1),a=e(236),c=e(242),_=e(13),h=e(95),l=o.__importStar(e(243)),y=o.__importStar(e(19)),d=e(144),x=e(12);class p extends a.GlyphView{_project_data(){this._project_xy("xs",this.xs.data,"ys",this.ys.data)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this.xs.get(s),i=this.ys.get(s),[n,r,o,a]=(0,_.minmax2)(t,i);e.add_rect(n,o,r,a)}}_mask_data(){const{x_source:e,y_source:t}=this.renderer.coordinates;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_paint(e,t,s){const{sxs:i,sys:n}={...this,...s};for(const s of t){const t=i.get(s),r=n.get(s);let o=!0;e.beginPath();const a=Math.min(t.length,r.length);for(let s=0;s<a;s++){const i=t[s],n=r[s];isFinite(i+n)?o?(e.moveTo(i,n),o=!1):e.lineTo(i,n):(e.closePath(),o=!0)}e.closePath(),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}_hit_poly(e){const{sx:t,sy:s,greedy:i=!1}=e,n=(()=>{const e=this.renderer.xscale.v_invert(t),i=this.renderer.yscale.v_invert(s),[n,r,o,a]=(0,_.minmax2)(e,i);return this.index.indices({x0:n,x1:r,y0:o,y1:a})})(),r=[];for(const e of n){const n=this.sxs.get(e),o=this.sys.get(e),a=n.length;if(0==a)continue;let c=!i;for(let e=0;e<a;e++){const r=n[e],a=o[e];if(l.point_in_poly(r,a,t,s)){if(i){c=!0;break}}else if(!i){c=!1;break}}c&&r.push(e)}return new d.Selection({indices:r})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n,greedy:r}=e,o=[t,s,s,t],a=[i,i,n,n];return this._hit_poly({type:"poly",sx:o,sy:a,greedy:r})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let a=0,c=0;;c++){if(isNaN(i[c])||c==r){const r=i.subarray(a,c),_=n.subarray(a,c);if(l.point_in_poly(t,s,r,_)){o.push(e);break}a=c+1}if(c==r)break}}return new d.Selection({indices:o})}_get_snap_coord(e){return(0,_.sum)(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let o=!1;for(let e=0,a=0;;a++){const c=isNaN(i[a]);if(o=o||c,a==r&&!o){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(c||a==r){const r=i.subarray(e,a),o=n.subarray(e,a);if(l.point_in_poly(t,s,r,o)){return[this._get_snap_coord(r),this._get_snap_coord(o)]}e=a+1}if(a==r)break}(0,x.unreachable)()}draw_legend_for_index(e,t,s){(0,c.generic_area_vector_legend)(this.visuals,e,t,s)}}s.PatchesView=p,p.__name__="PatchesView";class f extends a.Glyph{constructor(e){super(e)}}s.Patches=f,r=f,f.__name__="Patches",r.prototype.default_view=p,r.define((({})=>({xs:[y.XCoordinateSeqSpec,{field:"xs"}],ys:[y.YCoordinateSeqSpec,{field:"ys"}]}))),r.mixins([h.LineVector,h.FillVector,h.HatchVector])},
function _(t,e,i,o,r){var s;o();const d=t(1),n=t(393),a=d.__importStar(t(19));class l extends n.LRTBView{scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){return{l:this.left[t],r:this.right[t],t:this.top[t],b:this.bottom[t]}}}i.QuadView=l,l.__name__="QuadView";class _ extends n.LRTB{constructor(t){super(t)}}i.Quad=_,s=_,_.__name__="Quad",s.prototype.default_view=l,s.define((({})=>({right:[a.XCoordinateSpec,{field:"right"}],bottom:[a.YCoordinateSpec,{field:"bottom"}],left:[a.XCoordinateSpec,{field:"left"}],top:[a.YCoordinateSpec,{field:"top"}]})))},
function _(e,i,t,s,n){var o;s();const c=e(1),a=e(95),r=e(236),d=e(242),_=e(391),x=c.__importStar(e(19));class y extends r.GlyphView{_project_data(){this._project_xy("x0",this.x0,"y0",this.y0),this._project_xy("x1",this.x1,"y1",this.y1)}_index_data(e){const{x0:i,x1:t,y0:s,y1:n,cx:o,cy:c,data_size:a}=this;for(let r=0;r<a;r++){const a=i[r],d=t[r],x=s[r],y=n[r],l=o[r],p=c[r];if(isFinite(a+d+x+y+l+p)){const{x0:i,y0:t,x1:s,y1:n}=(0,_.qbb)(a,x,l,p,d,y);e.add_rect(i,t,s,n)}else e.add_empty()}}_paint(e,i,t){if(!this.visuals.line.doit)return;const{sx0:s,sy0:n,sx1:o,sy1:c,scx:a,scy:r}={...this,...t};for(const t of i){const i=s[t],d=n[t],_=o[t],x=c[t],y=a[t],l=r[t];isFinite(i+d+_+x+y+l)&&(e.beginPath(),e.moveTo(i,d),e.quadraticCurveTo(y,l,_,x),this.visuals.line.apply(e,t))}}draw_legend_for_index(e,i,t){(0,d.generic_line_vector_legend)(this.visuals,e,i,t)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}t.QuadraticView=y,y.__name__="QuadraticView";class l extends r.Glyph{constructor(e){super(e)}}t.Quadratic=l,o=l,l.__name__="Quadratic",o.prototype.default_view=y,o.define((({})=>({x0:[x.XCoordinateSpec,{field:"x0"}],y0:[x.YCoordinateSpec,{field:"y0"}],x1:[x.XCoordinateSpec,{field:"x1"}],y1:[x.YCoordinateSpec,{field:"y1"}],cx:[x.XCoordinateSpec,{field:"cx"}],cy:[x.YCoordinateSpec,{field:"cy"}]}))),o.mixins(a.LineVector)},
function _(e,t,i,n,s){var h;n();const r=e(1),a=e(235),l=e(236),_=e(242),o=e(95),d=e(25),g=r.__importStar(e(19));class c extends a.XYGlyphView{_map_data(){if(this._define_or_inherit_attr("slength",(()=>"data"==this.model.properties.length.units?this.inherited_x&&this.inherited_length?l.inherit:this.sdist(this.renderer.xscale,this.x,this.length):this.inherited_length?l.inherit:(0,d.to_screen)(this.length))),!this.inherited_slength){const{width:e,height:t}=this.renderer.plot_view.frame.bbox,i=2*(e+t),{slength:n}=this,s=n.length;for(let e=0;e<s;e++)0==n[e]&&(n[e]=i)}}_paint(e,t,i){if(!this.visuals.line.doit)return;const{sx:n,sy:s,slength:h,angle:r}={...this,...i};for(const i of t){const t=n[i],a=s[i],l=r.get(i),_=h[i];isFinite(t+a+l+_)&&(e.translate(t,a),e.rotate(l),e.beginPath(),e.moveTo(0,0),e.lineTo(_,0),this.visuals.line.apply(e,i),e.rotate(-l),e.translate(-t,-a))}}draw_legend_for_index(e,t,i){(0,_.generic_line_vector_legend)(this.visuals,e,t,i)}}i.RayView=c,c.__name__="RayView";class p extends a.XYGlyph{constructor(e){super(e)}}i.Ray=p,h=p,p.__name__="Ray",h.prototype.default_view=c,h.mixins(o.LineVector),h.define((({})=>({length:[g.DistanceSpec,0],angle:[g.AngleSpec,0]})))},
function _(t,e,i,s,r){var _;s();const n=t(1),h=t(395),a=t(242),d=t(25),o=t(13),l=t(144),c=t(62),x=t(73),y=t(124),f=n.__importStar(t(127)),g=t(197),{abs:w,sqrt:u}=Math;class p extends h.CenterRotatableView{async load_glglyph(){const{RectGL:e}=await Promise.resolve().then((()=>n.__importStar(t(597))));return e}_set_data(t){super._set_data(t),this.border_radius=f.border_radius(this.model.border_radius)}_map_data(){const t=this.data_size;if(this.inherited_x&&this.inherited_width)this._inherit_attr("swidth"),this._inherit_attr("sx0");else{let e,i;if("data"==this.model.properties.width.units)[e,i]=this._map_dist_corner_for_data_side_length(this.x,this.width,this.renderer.xscale);else{e=(0,d.to_screen)(this.width),i=new d.ScreenArray(t);const{sx:s}=this;for(let r=0;r<t;r++)i[r]=s[r]-e[r]/2}this._define_attr("swidth",e),this._define_attr("sx0",i)}if(this.inherited_y&&this.inherited_height)this._inherit_attr("sheight"),this._inherit_attr("sy1");else{let e,i;if("data"==this.model.properties.height.units)[e,i]=this._map_dist_corner_for_data_side_length(this.y,this.height,this.renderer.yscale);else{e=(0,d.to_screen)(this.height),i=new d.ScreenArray(t);const{sy:s}=this;for(let r=0;r<t;r++)i[r]=s[r]-e[r]/2}this._define_attr("sheight",e),this._define_attr("sy1",i)}if(this.inherited_swidth&&this.inherited_sheight)this._inherit_attr("max_x2_ddist"),this._inherit_attr("max_y2_ddist");else{const{sx0:e,sy1:i,swidth:s,sheight:r}=this,_=new d.ScreenArray(t);for(let e=0;e<t;e++){const t=s[e],i=r[e];_[e]=u(t**2+i**2)/2}const n=new d.ScreenArray(t),h=new d.ScreenArray(t);for(let _=0;_<t;_++)n[_]=e[_]+s[_]/2,h[_]=i[_]+r[_]/2;const a=(0,o.max)(this._ddist(0,n,_)),l=(0,o.max)(this._ddist(1,h,_));this._define_attr("max_x2_ddist",a),this._define_attr("max_y2_ddist",l)}}_paint(t,e,i){const{sx:s,sy:r,sx0:_,sy1:n,swidth:h,sheight:a,angle:d,border_radius:o}={...this,...i};for(const i of e){const e=s[i],l=r[i],x=_[i],y=n[i],f=h[i],w=a[i],u=d.get(i);if(isFinite(e+l+x+y+f+w+u)&&(0!=f&&0!=w)){if(t.beginPath(),0!=u){t.translate(e,l),t.rotate(u);const i=new c.BBox({x:-f/2,y:-w/2,width:f,height:w});(0,g.round_rect)(t,i,o),t.rotate(-u),t.translate(-e,-l)}else{const e=new c.BBox({x,y,width:f,height:w});(0,g.round_rect)(t,e,o)}this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),this.visuals.line.apply(t,i)}}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const e={x:t.sx,y:t.sy},i=this.renderer.xscale.invert(e.x),s=this.renderer.yscale.invert(e.y),r=this.index.indices({x0:i-this.max_x2_ddist,x1:i+this.max_x2_ddist,y0:s-this.max_y2_ddist,y1:s+this.max_y2_ddist}),{sx:_,sy:n,sx0:h,sy1:a,swidth:d,sheight:o,angle:c}=this,y=[];for(const t of r){const i=_[t],s=n[t],r=h[t],l=a[t],f=d[t],g=o[t],w=c.get(t),u=(0,x.rotate_around)(e,{x:i,y:s},-w),p=u.x-r,m=u.y-l;0<=p&&p<=f&&0<=m&&m<=g&&y.push(t)}return new l.Selection({indices:y})}_map_dist_corner_for_data_side_length(t,e,i){const s=t.length,r=new Float64Array(s),_=new Float64Array(s);for(let i=0;i<s;i++){const s=t[i],n=e.get(i)/2;r[i]=s-n,_[i]=s+n}const n=i.v_compute(r),h=i.v_compute(_),a=this.sdist(i,r,e,"edge",this.model.dilate);let d=n;for(let t=0;t<s;t++){const e=n[t],i=h[t];if(!isNaN(e+i)&&e!=i){d=e<i?n:h;break}}return[a,d]}_ddist(t,e,i){const s=(0,d.infer_type)(e,i),r=0==t?this.renderer.xscale:this.renderer.yscale,_=e,n=_.length,h=new s(n);for(let t=0;t<n;t++)h[t]=_[t]+i[t];const a=r.v_invert(_),o=r.v_invert(h),l=a.length,c=new s(l);for(let t=0;t<l;t++)c[t]=w(o[t]-a[t]);return c}draw_legend_for_index(t,e,i){(0,a.generic_area_vector_legend)(this.visuals,t,e,i)}}i.RectView=p,p.__name__="RectView";class m extends h.CenterRotatable{constructor(t){super(t)}}i.Rect=m,_=m,m.__name__="Rect",_.prototype.default_view=p,_.define((({Bool:t})=>({border_radius:[y.BorderRadius,0],dilate:[t,!1]})))},
function _(e,t,s,a,i){var r;a();const n=e(1),l=e(417),c=e(21),o=e(418),_=n.__importStar(e(19)),u=n.__importStar(e(40)),d=e(353),p=e(51),f=e(9);function h(e){return c.MarkerType.valid(e)}class m extends l.MarkerView{async load_glglyph(){const{MultiMarkerGL:t}=await Promise.resolve().then((()=>n.__importStar(e(595))));return t}_compute_can_use_webgl(){return(0,f.is_empty)(this.model.defs)||u.every(this.marker,h)}async _update_defs(){for(const e of(0,f.dict)(this.model.defs).values())e instanceof d.CustomJS&&await e.compile()}connect_signals(){super.connect_signals();const{defs:e}=this.model.properties;this.on_change(e,(()=>this._update_defs()))}async lazy_initialize(){await super.lazy_initialize(),await this._update_defs()}_paint(e,t,s){const{sx:a,sy:i,size:r,angle:n,marker:l}={...this,...s},c=(0,f.dict)(this.model.defs),{visuals:_}=this;for(const s of t){const t=a[s],u=i[s],d=r.get(s),f=n.get(s),m=l.get(s);if(!isFinite(t+u+d+f)||null==m)continue;e.beginPath(),e.translate(t,u),0!=f&&e.rotate(f);const y=d/2;if(h(m))o.marker_funcs[m](e,s,y,_);else{const t=c.get(m);if(null!=t){const a=(0,p.execute_sync)(t,this.model,{ctx:e,i:s,r:y,visuals:_});a instanceof Path2D&&(this.visuals.fill.apply(e,s,a),this.visuals.hatch.apply(e,s,a),this.visuals.line.apply(e,s,a))}}0!=f&&e.rotate(-f),e.translate(-t,-u)}}draw_legend_for_index(e,{x0:t,x1:s,y0:a,y1:i},r){const n=r+1,l=this.marker.get(r),c={...this._get_legend_args({x0:t,x1:s,y0:a,y1:i},r),marker:new _.UniformScalar(l,n)};this._paint(e,[r],c)}}s.ScatterView=m,m.__name__="ScatterView";class y extends l.Marker{constructor(e){super(e)}}s.Scatter=y,r=y,y.__name__="Scatter",r.prototype.default_view=m,r.define((({KeyVal:e,Or:t,Func:s,Ref:a})=>({marker:[_.MarkerSpec,{value:"circle"}],defs:[e(_.ExtMarkerType,t(s(),a(d.CustomJS))),{}]})))},
function _(e,t,s,i,n){var r;i();const a=e(1),c=e(235),o=e(95),_=a.__importStar(e(243)),h=a.__importStar(e(19)),x=e(13),d=e(144);class l extends c.XYGlyphView{_paint(e,t,s){const{sx:i,sy:n,size:r,angle:a}={...this,...s};for(const s of t){const t=i[s],c=n[s],o=r.get(s),_=a.get(s);if(!isFinite(t+c+o+_))continue;const h=o/2;e.beginPath(),e.translate(t,c),0!=_&&e.rotate(_),this._render_one(e,s,h,this.visuals),0!=_&&e.rotate(-_),e.translate(-t,-c)}}_mask_data(){const{x_target:e,y_target:t}=this.renderer.plot_view.frame,s=e.widen(this.max_size).map((e=>this.renderer.xscale.invert(e))),i=t.widen(this.max_size).map((e=>this.renderer.yscale.invert(e)));return this.index.indices({x0:s.start,x1:s.end,y0:i.start,y1:i.end})}_hit_point(e){const{sx:t,sy:s}=e,{max_size:i}=this,{hit_dilation:n}=this.model,r=t-i*n,a=t+i*n,[c,o]=this.renderer.xscale.r_invert(r,a),_=s-i*n,h=s+i*n,[x,l]=this.renderer.yscale.r_invert(_,h),y=this.index.indices({x0:c,x1:o,y0:x,y1:l}),m=[];for(const e of y){const i=this.size.get(e)/2*n;Math.abs(this.sx[e]-t)<=i&&Math.abs(this.sy[e]-s)<=i&&m.push(e)}return new d.Selection({indices:m})}_hit_span(e){const{sx:t,sy:s}=e,i=this.bounds(),n=this.max_size/2,[r,a,c,o]=(()=>{if("h"==e.direction){const{y0:e,y1:s}=i,r=t-n,a=t+n,[c,o]=this.renderer.xscale.r_invert(r,a);return[c,o,e,s]}{const{x0:e,x1:t}=i,r=s-n,a=s+n,[c,o]=this.renderer.yscale.r_invert(r,a);return[e,t,c,o]}})(),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new d.Selection({indices:_})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[r,a]=this.renderer.xscale.r_invert(t,s),[c,o]=this.renderer.yscale.r_invert(i,n),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new d.Selection({indices:_})}_hit_poly(e){const{sx:t,sy:s}=e,i=(()=>{const e=this.renderer.xscale.v_invert(t),i=this.renderer.yscale.v_invert(s),[n,r,a,c]=(0,x.minmax2)(e,i);return this.index.indices({x0:n,x1:r,y0:a,y1:c})})(),n=[];for(const e of i)_.point_in_poly(this.sx[e],this.sy[e],t,s)&&n.push(e);return new d.Selection({indices:n})}_get_legend_args({x0:e,x1:t,y0:s,y1:i},n){const r=n+1,a=new Array(r),c=new Array(r);a[n]=(e+t)/2,c[n]=(s+i)/2;const o=.4*Math.min(Math.abs(t-e),Math.abs(i-s));return{sx:a,sy:c,size:new h.UniformScalar(o,r),angle:new h.UniformScalar(0,r)}}draw_legend_for_index(e,{x0:t,x1:s,y0:i,y1:n},r){const a=this._get_legend_args({x0:t,x1:s,y0:i,y1:n},r);this._paint(e,[r],a)}}s.MarkerView=l,l.__name__="MarkerView";class y extends c.XYGlyph{constructor(e){super(e)}}s.Marker=y,r=y,y.__name__="Marker",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({Float:e})=>({size:[h.ScreenSizeSpec,{value:4}],angle:[h.AngleSpec,0],hit_dilation:[e,1]})))},
function _(l,n,o,i,a){i();const t=Math.sqrt(3),e=Math.sqrt(5),p=(e+1)/4,c=Math.sqrt((5-e)/8),h=(e-1)/4,u=Math.sqrt((5+e)/8);function f(l,n){l.rotate(Math.PI/4),y(l,n),l.rotate(-Math.PI/4)}function r(l,n){const o=n*t,i=o/3;l.moveTo(-o/2,-i),l.lineTo(0,0),l.lineTo(o/2,-i),l.lineTo(0,0),l.lineTo(0,n)}function y(l,n){l.moveTo(0,n),l.lineTo(0,-n),l.moveTo(-n,0),l.lineTo(n,0)}function T(l,n){l.moveTo(0,n),l.lineTo(n/1.5,0),l.lineTo(0,-n),l.lineTo(-n/1.5,0),l.closePath()}function s(l,n){const o=n*t,i=o/3;l.moveTo(-n,i),l.lineTo(n,i),l.lineTo(0,i-o),l.closePath()}function v(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function d(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function P(l,n,o,i){!function(l,n){l.beginPath(),l.arc(0,0,n/4,0,2*Math.PI,!1),l.closePath()}(l,o),i.line.set_vectorize(l,n),l.fillStyle=l.strokeStyle,l.fill()}function m(l,n,o,i){!function(l,n){const o=n/2,i=t*o;l.moveTo(n,0),l.lineTo(o,-i),l.lineTo(-o,-i),l.lineTo(-n,0),l.lineTo(-o,i),l.lineTo(o,i),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function _(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function q(l,n,o,i){!function(l,n){const o=Math.sqrt(5-2*e)*n;l.moveTo(0,-n),l.lineTo(o*h,o*u-n),l.lineTo(o*(1+h),o*u-n),l.lineTo(o*(1+h-p),o*(u+c)-n),l.lineTo(o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(0,2*o*u-n),l.lineTo(-o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(-o*(1+h-p),o*(u+c)-n),l.lineTo(-o*(1+h),o*u-n),l.lineTo(-o*h,o*u-n),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function M(l,n,o,i){s(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}o.marker_funcs={asterisk:function(l,n,o,i){y(l,o),f(l,o),i.line.apply(l,n)},circle:v,circle_cross:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},circle_dot:function(l,n,o,i){v(l,n,o,i),P(l,n,o,i)},circle_y:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),r(l,o),i.line.apply(l,n)},circle_x:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),f(l,o),i.line.apply(l,n)},cross:function(l,n,o,i){y(l,o),i.line.apply(l,n)},diamond:d,diamond_dot:function(l,n,o,i){d(l,n,o,i),P(l,n,o,i)},diamond_cross:function(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o/1.5,0),l.lineTo(o/1.5,0),i.line.apply(l,n)},dot:P,hex:m,hex_dot:function(l,n,o,i){m(l,n,o,i),P(l,n,o,i)},inverted_triangle:function(l,n,o,i){l.rotate(Math.PI),s(l,o),l.rotate(-Math.PI),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},plus:function(l,n,o,i){const a=3*o/8,t=[a,a,o,o,a,a,-a,-a,-o,-o,-a,-a],e=[o,a,a,-a,-a,-o,-o,-a,-a,a,a,o];l.beginPath();for(let n=0;n<12;n++)l.lineTo(t[n],e[n]);l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square:_,square_cross:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},square_dot:function(l,n,o,i){_(l,n,o,i),P(l,n,o,i)},square_pin:function(l,n,o,i){const a=3*o/8;l.moveTo(-o,-o),l.quadraticCurveTo(0,-a,o,-o),l.quadraticCurveTo(a,0,o,o),l.quadraticCurveTo(0,a,-o,o),l.quadraticCurveTo(-a,0,-o,-o),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square_x:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(-o,o),l.lineTo(o,-o),l.moveTo(-o,-o),l.lineTo(o,o),i.line.apply(l,n)},star:q,star_dot:function(l,n,o,i){q(l,n,o,i),P(l,n,o,i)},triangle:M,triangle_dot:function(l,n,o,i){M(l,n,o,i),P(l,n,o,i)},triangle_pin:function(l,n,o,i){const a=o*t,e=a/3,p=3*e/8;l.moveTo(-o,e),l.quadraticCurveTo(0,p,o,e),l.quadraticCurveTo(t*p/2,p/2,0,e-a),l.quadraticCurveTo(-t*p/2,p/2,-o,e),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},dash:function(l,n,o,i){!function(l,n){l.moveTo(-n,0),l.lineTo(n,0)}(l,o),i.line.apply(l,n)},x:function(l,n,o,i){f(l,o),i.line.apply(l,n)},y:function(l,n,o,i){r(l,o),i.line.apply(l,n)}}},
function _(e,t,s,i,n){var r;i();const o=e(1),a=o.__importStar(e(243)),h=o.__importStar(e(19)),d=e(95),c=e(11),_=e(236),x=e(242),y=e(144);class l extends _.GlyphView{_project_data(){this._project_xy("x0",this.x0,"y0",this.y0),this._project_xy("x1",this.x1,"y1",this.y1)}_index_data(e){const{min:t,max:s}=Math,{x0:i,x1:n,y0:r,y1:o,data_size:a}=this;for(let h=0;h<a;h++){const a=i[h],d=n[h],c=r[h],_=o[h];e.add_rect(t(a,d),t(c,_),s(a,d),s(c,_))}}_paint(e,t,s){if(!this.visuals.line.doit)return;const{sx0:i,sy0:n,sx1:r,sy1:o}={...this,...s};for(const s of t){const t=i[s],a=n[s],h=r[s],d=o[s];isFinite(t+a+h+d)&&(this._render_decorations(e,s,t,a,h,d),e.beginPath(),e.moveTo(t,a),e.lineTo(h,d),this.visuals.line.apply(e,s))}}_render_decorations(e,t,s,i,n,r){const{PI:o}=Math,a=(0,c.atan2)([s,i],[n,r])+o/2;for(const h of this.decorations.values())e.save(),"start"==h.model.node?(e.translate(s,i),e.rotate(a+o)):"end"==h.model.node&&(e.translate(n,r),e.rotate(a)),h.marking.paint(e,t),e.restore()}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[o,h]=this.renderer.yscale.r_invert(s-2,s+2),d=this.index.indices({x0:n,y0:o,x1:r,y1:h}),c=[];for(const e of d){const t=Math.max(2,this.line_width.get(e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};a.dist_to_segment_squared(i,s,n)<t&&c.push(e)}return new y.Selection({indices:c})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,o,a;"v"==e.direction?(a=this.renderer.yscale.invert(n),[r,o]=[this.y0,this.y1]):(a=this.renderer.xscale.invert(i),[r,o]=[this.x0,this.x1]);const h=[],[d,c]=this.renderer.xscale.r_invert(t.start,t.end),[_,x]=this.renderer.yscale.r_invert(s.start,s.end),l=this.index.indices({x0:d,y0:_,x1:c,y1:x});for(const t of l){(r[t]<=a&&a<=o[t]||o[t]<=a&&a<=r[t])&&h.push(t);const s=1.5+this.line_width.get(t)/2;r[t]==o[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&h.push(t):Math.abs(this.sy0[t]-n)<=s&&h.push(t))}return new y.Selection({indices:h})}scenterxy(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]}draw_legend_for_index(e,t,s){(0,x.generic_line_vector_legend)(this.visuals,e,t,s)}}s.SegmentView=l,l.__name__="SegmentView";class p extends _.Glyph{constructor(e){super(e)}}s.Segment=p,r=p,p.__name__="Segment",r.prototype.default_view=l,r.define((({})=>({x0:[h.XCoordinateSpec,{field:"x0"}],y0:[h.YCoordinateSpec,{field:"y0"}],x1:[h.XCoordinateSpec,{field:"x1"}],y1:[h.YCoordinateSpec,{field:"y1"}]}))),r.mixins(d.LineVector)},
function _(t,e,s,i,n){var _;i();const o=t(1),a=t(235),l=o.__importStar(t(95)),c=t(421);class r extends a.XYGlyphView{_set_data(){const{tension:t,closed:e}=this.model,[s,i]=(0,c.catmullrom_spline)(this.x,this.y,20,t,e);this._define_attr("xt",s),this._define_attr("yt",i)}_map_data(){const{x_scale:t,y_scale:e}=this.renderer.coordinates,s=t.v_compute(this.xt),i=e.v_compute(this.yt);this._define_attr("sxt",s),this._define_attr("syt",i)}_paint(t,e,s){const{sxt:i,syt:n}={...this,...s};let _=!0;t.beginPath();const o=i.length;for(let e=0;e<o;e++){const s=i[e],o=n[e];isFinite(s+o)?_?(t.moveTo(s,o),_=!1):t.lineTo(s,o):_=!0}this.visuals.line.set_value(t),t.stroke()}}s.SplineView=r,r.__name__="SplineView";class h extends a.XYGlyph{constructor(t){super(t)}}s.Spline=h,_=h,h.__name__="Spline",_.prototype.default_view=r,_.mixins(l.LineScalar),_.define((({Bool:t,Float:e})=>({tension:[e,.5],closed:[t,!1]})))},
function _(n,t,e,o,s){o(),e.catmullrom_spline=function(n,t,e=10,o=.5,s=!1){(0,l.assert)(n.length==t.length);const r=n.length,f=s?r+1:r,w=(0,c.infer_type)(n,t),i=new w(f+2),u=new w(f+2);i.set(n,1),u.set(t,1),s?(i[0]=n[r-1],u[0]=t[r-1],i[f]=n[0],u[f]=t[0],i[f+1]=n[1],u[f+1]=t[1]):(i[0]=n[0],u[0]=t[0],i[f+1]=n[r-1],u[f+1]=t[r-1]);const g=new w(4*(e+1));for(let n=0,t=0;n<=e;n++){const o=n/e,s=o**2,c=o*s;g[t++]=2*c-3*s+1,g[t++]=-2*c+3*s,g[t++]=c-2*s+o,g[t++]=c-s}const h=new w((f-1)*(e+1)),_=new w((f-1)*(e+1));for(let n=1,t=0;n<f;n++){const s=(i[n+1]-i[n-1])*o,c=(u[n+1]-u[n-1])*o,l=(i[n+2]-i[n])*o,r=(u[n+2]-u[n])*o;for(let o=0;o<=4*e;t++){const e=g[o++],f=g[o++],w=g[o++],a=g[o++];h[t]=e*i[n]+f*i[n+1]+w*s+a*l,_[t]=e*u[n]+f*u[n+1]+w*c+a*r}}return[h,_]};const c=n(25),l=n(12)},
function _(e,t,n,s,i){var r;s();const _=e(1),a=e(235),l=e(242),o=_.__importStar(e(95)),h=e(21),c=e(12);class d extends a.XYGlyphView{async load_glglyph(){const{StepGL:t}=await Promise.resolve().then((()=>_.__importStar(e(598))));return t}_paint(e,t,n){if(t.length<2)return;let s=[];for(let i=0;i<t.length;i++)0==i?s.push(t[i]):t[i]-1!=t[i-1]?(this._paint_consecutive(e,s,n),s=[t[i]]):(s.push(t[i]),i+1==t.length&&this._paint_consecutive(e,s,n))}_paint_consecutive(e,t,n){const{sx:s,sy:i}={...this,...n},r=this.model.mode;this.visuals.line.set_value(e);let _=!1,a=!1;const l=t[0];let o=isFinite(s[l]+i[l]);"center"==r&&(_=this._render_xy(e,_,o?s[l]:NaN,i[l]));for(let n=0;n<t.length;n++){const l=t[n],h=isFinite(s[l+1]+i[l+1])&&t[n+1]==l+1;switch(r){case"before":_=this._render_xy(e,_,o?s[l]:NaN,i[l]),l<s.length-1&&(_=this._render_xy(e,_,o&&h?s[l]:NaN,i[l+1]));break;case"after":_=this._render_xy(e,_,o?s[l]:NaN,i[l]),l<s.length-1&&(_=this._render_xy(e,_,o&&h?s[l+1]:NaN,i[l]));break;case"center":if(o&&h){const t=(s[l]+s[l+1])/2;_=this._render_xy(e,_,t,i[l]),_=this._render_xy(e,_,t,i[l+1])}else a&&(_=this._render_xy(e,_,o?s[l]:NaN,i[l])),_=this._render_xy(e,_,h?s[l+1]:NaN,i[l+1]);break;default:(0,c.unreachable)()}a=o,o=h}if(_){const n=t[t.length-1];this._render_xy(e,_,o?s[n]:NaN,i[n])&&e.stroke()}}_render_xy(e,t,n,s){return isFinite(n+s)?t?e.lineTo(n,s):(e.beginPath(),e.moveTo(n,s),t=!0):t&&(e.stroke(),t=!1),t}draw_legend_for_index(e,t,n){(0,l.generic_line_scalar_legend)(this.visuals,e,t)}}n.StepView=d,d.__name__="StepView";class p extends a.XYGlyph{constructor(e){super(e)}}n.Step=p,r=p,p.__name__="Step",r.prototype.default_view=d,r.mixins(o.LineScalar),r.define((()=>({mode:[h.StepMode,"before"]})))},
function _(e,t,i,l,n){var s;l();const a=e(406),o=e(190),r=e(22),c=e(189);i.DisplayMode=(0,r.Or)((0,r.Enum)("inline","block"),r.Auto);class p extends a.MathTextGlyphView{_build_label(e){const{macros:t,display:i}=this.model;if("auto"==i){const i=(0,c.parse_delimited_string)(e);return i instanceof o.TeX&&(i.macros=t),i}return new o.TeX({text:e,macros:t,inline:"inline"==i})}}i.TeXGlyphView=p,p.__name__="TeXGlyphView";class _ extends a.MathTextGlyph{constructor(e){super(e)}}i.TeXGlyph=_,s=_,_.__name__="TeXGlyph",s.prototype.default_view=p,s.define((({Float:e,Str:t,Dict:l,Tuple:n,Or:s})=>({macros:[l(s(t,n(t,e))),{}],display:[i.DisplayMode,"auto"]})))},
function _(t,e,i,s,r){var h;s();const n=t(1),a=t(393),_=t(25),o=n.__importStar(t(19));class d extends a.LRTBView{scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){const e=this.width.get(t)/2,i=this.x[t],s=this.top[t],r=this.bottom[t];return{l:i-e,r:i+e,t:Math.max(s,r),b:Math.min(s,r)}}_map_data(){if(this.inherited_x&&this.inherited_width)this._inherit_attr("swidth"),this._inherit_attr("sleft"),this._inherit_attr("sright");else{const t=this.sdist(this.renderer.xscale,this.x,this.width,"center"),{sx:e}=this,i=e.length,s=new _.ScreenArray(i),r=new _.ScreenArray(i);for(let h=0;h<i;h++){const i=e[h],n=t[h];s[h]=i-n/2,r[h]=i+n/2}this._define_attr("swidth",t),this._define_attr("sleft",s),this._define_attr("sright",r)}this._clamp_to_viewport()}}i.VBarView=d,d.__name__="VBarView";class c extends a.LRTB{constructor(t){super(t)}}i.VBar=c,h=c,c.__name__="VBar",h.prototype.default_view=d,h.define((({})=>({x:[o.XCoordinateSpec,{field:"x"}],bottom:[o.YCoordinateSpec,{value:0}],width:[o.DistanceSpec,{value:1}],top:[o.YCoordinateSpec,{field:"top"}]})))},
function _(t,e,i,n,s){var _;n();const r=t(1),a=t(236),o=t(242),d=t(144),c=t(95),h=r.__importStar(t(40)),x=t(13),p=t(10),l=r.__importStar(t(19)),{abs:u,max:f}=Math;class m extends a.GlyphView{after_visuals(){super.after_visuals(),this.max_line_width=h.max(this.line_width)}_index_data(t){for(const e of this.x)t.add_point(e,0)}_bounds(t){const{x0:e,x1:i}=t;return{x0:e,x1:i,y0:NaN,y1:NaN}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sx){const e=(0,x.map)(this.sx,(e=>t(e)));this._define_attr("sx",e)}}scenterxy(t){const{vcenter:e}=this.renderer.plot_view.frame.bbox;return[this.sx[t],e]}_paint(t,e,i){const{sx:n}={...this,...i},{top:s,bottom:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=n[i];isFinite(e)&&(t.beginPath(),t.moveTo(e,s),t.lineTo(e,_),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_line_width:i}=this,[n,s]=this.renderer.xscale.r_invert(t-i,(e??t)+i);return this.index.indices({x0:n,x1:s,y0:0,y1:0})}_find_spans(t,e){const{sx:i,line_width:n}=this,s=[];for(const _ of t){e(i[_],n.get(_))&&s.push(_)}return s}_hit_point(t){const{sx:e}=t,i=this._get_candidates(e),n=this._find_spans(i,((t,i)=>u(t-e)<=f(i,2)));return new d.Selection({indices:n})}_hit_span(t){const e=(()=>{if("h"==t.direction)return(0,p.range)(0,this.data_size);{const{sx:e}=t,i=this._get_candidates(e);return this._find_spans(i,((t,i)=>u(t-e)<=f(i/2,2)))}})();return new d.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sx0:e,sx1:i}=t,n=this._get_candidates(e,i);return this._find_spans(n,((t,n)=>e-n/2<=t&&t<=i+n/2))})();return new d.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_line_vector_legend)(this.visuals,t,e,i)}}i.VSpanView=m,m.__name__="VSpanView";class w extends a.Glyph{constructor(t){super(t)}}i.VSpan=w,_=w,w.__name__="VSpan",_.prototype.default_view=m,_.mixins([c.LineVector]),_.define((()=>({x:[l.XCoordinateSpec,{field:"x"}]})))},
function _(t,e,i,s,r){var n;s();const a=t(1),_=t(236),o=t(242),h=t(144),c=t(95),d=t(25),l=t(13),p=a.__importStar(t(14)),x=t(10),f=a.__importStar(t(19));class u extends _.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>a.__importStar(t(593))));this.glglyph=new i(e.regl_wrapper,this)}}get sleft(){return this.sx0}get sright(){return this.sx1}get stop(){const{top:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}get sbottom(){const{bottom:t}=this.renderer.plot_view.frame.bbox,e=this.data_size,i=new d.ScreenArray(e);return i.fill(t),i}_set_data(t){super._set_data(t);const{abs:e}=Math,{max:i,map:s,zip:r}=p,{x0:n,x1:a}=this;if(this.inherited_x0&&this.inherited_x1)this._inherit_attr("max_width");else{const t=i(s(r(n,a),(([t,i])=>e(t-i))));this._define_attr("max_width",t)}}_index_data(t){const{x0:e,x1:i,data_size:s}=this;for(let r=0;r<s;r++){const s=e[r],n=i[r];t.add_rect(s,0,n,0)}}_bounds(t){const{x0:e,x1:i}=t;return{x0:e,x1:i,y0:NaN,y1:NaN}}_map_data(){super._map_data();const{round:t}=Math;if(!this.inherited_sx0){const e=(0,l.map)(this.sx0,(e=>t(e)));this._define_attr("sx0",e)}if(!this.inherited_sx1){const e=(0,l.map)(this.sx1,(e=>t(e)));this._define_attr("sx1",e)}}scenterxy(t){const{vcenter:e}=this.renderer.plot_view.frame.bbox;return[(this.sx0[t]+this.sx1[t])/2,e]}_paint(t,e,i){const{sx0:s,sx1:r}={...this,...i},{top:n,bottom:a,height:_}=this.renderer.plot_view.frame.bbox;for(const i of e){const e=s[i],o=r[i];isFinite(e+o)&&(t.beginPath(),t.rect(e,n,o-e,_),this.visuals.fill.apply(t,i),this.visuals.hatch.apply(t,i),t.beginPath(),t.moveTo(e,n),t.lineTo(e,a),t.moveTo(o,n),t.lineTo(o,a),this.visuals.line.apply(t,i))}}_get_candidates(t,e){const{max_width:i}=this,[s,r]=this.renderer.xscale.r_invert(t,e??t),n=s-i,a=r+i;return this.index.indices({x0:n,x1:a,y0:0,y1:0})}_find_strips(t,e){function i(t,i){return t<=i?e(t,i):e(i,t)}const{sx0:s,sx1:r}=this,n=[];for(const e of t){i(s[e],r[e])&&n.push(e)}return n}_hit_point(t){const{sx:e}=t,i=this._get_candidates(e),s=this._find_strips(i,((t,i)=>t<=e&&e<=i));return new h.Selection({indices:s})}_hit_span(t){const e=(()=>{if("h"==t.direction)return(0,x.range)(0,this.data_size);{const{sx:e}=t,i=this._get_candidates(e);return this._find_strips(i,((t,i)=>t<=e&&e<=i))}})();return new h.Selection({indices:e})}_hit_rect(t){const e=(()=>{const{sx0:e,sx1:i}=t,s=this._get_candidates(e,i);return this._find_strips(s,((t,s)=>e<=t&&t<=i&&e<=s&&s<=i))})();return new h.Selection({indices:e})}draw_legend_for_index(t,e,i){(0,o.generic_area_vector_legend)(this.visuals,t,e,i)}}i.VStripView=u,u.__name__="VStripView";class w extends