# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateInvoiceDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amount': 'float',
        'num_payments': 'float',
        'currency': 'str',
        'description': 'str',
        'hidden_message': 'str',
        'callback_url': 'str',
        'payload': 'str',
        'expired_in': 'float'
    }

    attribute_map = {
        'amount': 'amount',
        'num_payments': 'numPayments',
        'currency': 'currency',
        'description': 'description',
        'hidden_message': 'hiddenMessage',
        'callback_url': 'callbackUrl',
        'payload': 'payload',
        'expired_in': 'expiredIn'
    }

    def __init__(self, amount=None, num_payments=1, currency='TONCOIN', description=None, hidden_message=None, callback_url=None, payload=None, expired_in=0):  # noqa: E501
        """CreateInvoiceDto - a model defined in Swagger"""  # noqa: E501
        self._amount = None
        self._num_payments = None
        self._currency = None
        self._description = None
        self._hidden_message = None
        self._callback_url = None
        self._payload = None
        self._expired_in = None
        self.discriminator = None
        self.amount = amount
        self.num_payments = num_payments
        self.currency = currency
        if description is not None:
            self.description = description
        if hidden_message is not None:
            self.hidden_message = hidden_message
        if callback_url is not None:
            self.callback_url = callback_url
        if payload is not None:
            self.payload = payload
        if expired_in is not None:
            self.expired_in = expired_in

    @property
    def amount(self):
        """Gets the amount of this CreateInvoiceDto.  # noqa: E501

        Invoice amount. 9 decimal places, others cut off  # noqa: E501

        :return: The amount of this CreateInvoiceDto.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this CreateInvoiceDto.

        Invoice amount. 9 decimal places, others cut off  # noqa: E501

        :param amount: The amount of this CreateInvoiceDto.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def num_payments(self):
        """Gets the num_payments of this CreateInvoiceDto.  # noqa: E501

        Num payments for invoice  # noqa: E501

        :return: The num_payments of this CreateInvoiceDto.  # noqa: E501
        :rtype: float
        """
        return self._num_payments

    @num_payments.setter
    def num_payments(self, num_payments):
        """Sets the num_payments of this CreateInvoiceDto.

        Num payments for invoice  # noqa: E501

        :param num_payments: The num_payments of this CreateInvoiceDto.  # noqa: E501
        :type: float
        """
        if num_payments is None:
            raise ValueError("Invalid value for `num_payments`, must not be `None`")  # noqa: E501

        self._num_payments = num_payments

    @property
    def currency(self):
        """Gets the currency of this CreateInvoiceDto.  # noqa: E501

        Currency of transfer, info /currencies/available  # noqa: E501

        :return: The currency of this CreateInvoiceDto.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this CreateInvoiceDto.

        Currency of transfer, info /currencies/available  # noqa: E501

        :param currency: The currency of this CreateInvoiceDto.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def description(self):
        """Gets the description of this CreateInvoiceDto.  # noqa: E501

        Description for invoice  # noqa: E501

        :return: The description of this CreateInvoiceDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateInvoiceDto.

        Description for invoice  # noqa: E501

        :param description: The description of this CreateInvoiceDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def hidden_message(self):
        """Gets the hidden_message of this CreateInvoiceDto.  # noqa: E501

        Hidden message after invoice is paid  # noqa: E501

        :return: The hidden_message of this CreateInvoiceDto.  # noqa: E501
        :rtype: str
        """
        return self._hidden_message

    @hidden_message.setter
    def hidden_message(self, hidden_message):
        """Sets the hidden_message of this CreateInvoiceDto.

        Hidden message after invoice is paid  # noqa: E501

        :param hidden_message: The hidden_message of this CreateInvoiceDto.  # noqa: E501
        :type: str
        """

        self._hidden_message = hidden_message

    @property
    def callback_url(self):
        """Gets the callback_url of this CreateInvoiceDto.  # noqa: E501

        Url for Return button after invoice is paid  # noqa: E501

        :return: The callback_url of this CreateInvoiceDto.  # noqa: E501
        :rtype: str
        """
        return self._callback_url

    @callback_url.setter
    def callback_url(self, callback_url):
        """Sets the callback_url of this CreateInvoiceDto.

        Url for Return button after invoice is paid  # noqa: E501

        :param callback_url: The callback_url of this CreateInvoiceDto.  # noqa: E501
        :type: str
        """

        self._callback_url = callback_url

    @property
    def payload(self):
        """Gets the payload of this CreateInvoiceDto.  # noqa: E501

        Any data. Invisible to user, will be returned in callback  # noqa: E501

        :return: The payload of this CreateInvoiceDto.  # noqa: E501
        :rtype: str
        """
        return self._payload

    @payload.setter
    def payload(self, payload):
        """Sets the payload of this CreateInvoiceDto.

        Any data. Invisible to user, will be returned in callback  # noqa: E501

        :param payload: The payload of this CreateInvoiceDto.  # noqa: E501
        :type: str
        """

        self._payload = payload

    @property
    def expired_in(self):
        """Gets the expired_in of this CreateInvoiceDto.  # noqa: E501

        Invoice expire time in seconds, max 1 day, 0 - none expired  # noqa: E501

        :return: The expired_in of this CreateInvoiceDto.  # noqa: E501
        :rtype: float
        """
        return self._expired_in

    @expired_in.setter
    def expired_in(self, expired_in):
        """Sets the expired_in of this CreateInvoiceDto.

        Invoice expire time in seconds, max 1 day, 0 - none expired  # noqa: E501

        :param expired_in: The expired_in of this CreateInvoiceDto.  # noqa: E501
        :type: float
        """

        self._expired_in = expired_in

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateInvoiceDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateInvoiceDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
