# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppImageConfigResult',
    'AwaitableGetAppImageConfigResult',
    'get_app_image_config',
    'get_app_image_config_output',
]

@pulumi.output_type
class GetAppImageConfigResult:
    def __init__(__self__, app_image_config_arn=None, kernel_gateway_image_config=None):
        if app_image_config_arn and not isinstance(app_image_config_arn, str):
            raise TypeError("Expected argument 'app_image_config_arn' to be a str")
        pulumi.set(__self__, "app_image_config_arn", app_image_config_arn)
        if kernel_gateway_image_config and not isinstance(kernel_gateway_image_config, dict):
            raise TypeError("Expected argument 'kernel_gateway_image_config' to be a dict")
        pulumi.set(__self__, "kernel_gateway_image_config", kernel_gateway_image_config)

    @property
    @pulumi.getter(name="appImageConfigArn")
    def app_image_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_arn")

    @property
    @pulumi.getter(name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(self) -> Optional['outputs.AppImageConfigKernelGatewayImageConfig']:
        """
        The KernelGatewayImageConfig.
        """
        return pulumi.get(self, "kernel_gateway_image_config")


class AwaitableGetAppImageConfigResult(GetAppImageConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppImageConfigResult(
            app_image_config_arn=self.app_image_config_arn,
            kernel_gateway_image_config=self.kernel_gateway_image_config)


def get_app_image_config(app_image_config_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppImageConfigResult:
    """
    Resource Type definition for AWS::SageMaker::AppImageConfig


    :param str app_image_config_name: The Name of the AppImageConfig.
    """
    __args__ = dict()
    __args__['appImageConfigName'] = app_image_config_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getAppImageConfig', __args__, opts=opts, typ=GetAppImageConfigResult).value

    return AwaitableGetAppImageConfigResult(
        app_image_config_arn=__ret__.app_image_config_arn,
        kernel_gateway_image_config=__ret__.kernel_gateway_image_config)


@_utilities.lift_output_func(get_app_image_config)
def get_app_image_config_output(app_image_config_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppImageConfigResult]:
    """
    Resource Type definition for AWS::SageMaker::AppImageConfig


    :param str app_image_config_name: The Name of the AppImageConfig.
    """
    ...
