# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['OriginEndpointArgs', 'OriginEndpoint']

@pulumi.input_type
class OriginEndpointArgs:
    def __init__(__self__, *,
                 channel_id: pulumi.Input[str],
                 authorization: Optional[pulumi.Input['OriginEndpointAuthorizationArgs']] = None,
                 cmaf_package: Optional[pulumi.Input['OriginEndpointCmafPackageArgs']] = None,
                 dash_package: Optional[pulumi.Input['OriginEndpointDashPackageArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_package: Optional[pulumi.Input['OriginEndpointHlsPackageArgs']] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 mss_package: Optional[pulumi.Input['OriginEndpointMssPackageArgs']] = None,
                 origination: Optional[pulumi.Input['OriginEndpointOrigination']] = None,
                 startover_window_seconds: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointTagArgs']]]] = None,
                 time_delay_seconds: Optional[pulumi.Input[int]] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a OriginEndpoint resource.
        :param pulumi.Input[str] channel_id: The ID of the Channel the OriginEndpoint is associated with.
        :param pulumi.Input[str] description: A short text description of the OriginEndpoint.
        :param pulumi.Input[str] manifest_name: A short string appended to the end of the OriginEndpoint URL.
        :param pulumi.Input['OriginEndpointOrigination'] origination: Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        :param pulumi.Input[int] startover_window_seconds: Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OriginEndpointTagArgs']]] tags: A collection of tags associated with a resource
        :param pulumi.Input[int] time_delay_seconds: Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelist: A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if cmaf_package is not None:
            pulumi.set(__self__, "cmaf_package", cmaf_package)
        if dash_package is not None:
            pulumi.set(__self__, "dash_package", dash_package)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hls_package is not None:
            pulumi.set(__self__, "hls_package", hls_package)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if mss_package is not None:
            pulumi.set(__self__, "mss_package", mss_package)
        if origination is not None:
            pulumi.set(__self__, "origination", origination)
        if startover_window_seconds is not None:
            pulumi.set(__self__, "startover_window_seconds", startover_window_seconds)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_delay_seconds is not None:
            pulumi.set(__self__, "time_delay_seconds", time_delay_seconds)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Input[str]:
        """
        The ID of the Channel the OriginEndpoint is associated with.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['OriginEndpointAuthorizationArgs']]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['OriginEndpointAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="cmafPackage")
    def cmaf_package(self) -> Optional[pulumi.Input['OriginEndpointCmafPackageArgs']]:
        return pulumi.get(self, "cmaf_package")

    @cmaf_package.setter
    def cmaf_package(self, value: Optional[pulumi.Input['OriginEndpointCmafPackageArgs']]):
        pulumi.set(self, "cmaf_package", value)

    @property
    @pulumi.getter(name="dashPackage")
    def dash_package(self) -> Optional[pulumi.Input['OriginEndpointDashPackageArgs']]:
        return pulumi.get(self, "dash_package")

    @dash_package.setter
    def dash_package(self, value: Optional[pulumi.Input['OriginEndpointDashPackageArgs']]):
        pulumi.set(self, "dash_package", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A short text description of the OriginEndpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hlsPackage")
    def hls_package(self) -> Optional[pulumi.Input['OriginEndpointHlsPackageArgs']]:
        return pulumi.get(self, "hls_package")

    @hls_package.setter
    def hls_package(self, value: Optional[pulumi.Input['OriginEndpointHlsPackageArgs']]):
        pulumi.set(self, "hls_package", value)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[pulumi.Input[str]]:
        """
        A short string appended to the end of the OriginEndpoint URL.
        """
        return pulumi.get(self, "manifest_name")

    @manifest_name.setter
    def manifest_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_name", value)

    @property
    @pulumi.getter(name="mssPackage")
    def mss_package(self) -> Optional[pulumi.Input['OriginEndpointMssPackageArgs']]:
        return pulumi.get(self, "mss_package")

    @mss_package.setter
    def mss_package(self, value: Optional[pulumi.Input['OriginEndpointMssPackageArgs']]):
        pulumi.set(self, "mss_package", value)

    @property
    @pulumi.getter
    def origination(self) -> Optional[pulumi.Input['OriginEndpointOrigination']]:
        """
        Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        """
        return pulumi.get(self, "origination")

    @origination.setter
    def origination(self, value: Optional[pulumi.Input['OriginEndpointOrigination']]):
        pulumi.set(self, "origination", value)

    @property
    @pulumi.getter(name="startoverWindowSeconds")
    def startover_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        """
        return pulumi.get(self, "startover_window_seconds")

    @startover_window_seconds.setter
    def startover_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "startover_window_seconds", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointTagArgs']]]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginEndpointTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeDelaySeconds")
    def time_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        """
        return pulumi.get(self, "time_delay_seconds")

    @time_delay_seconds.setter
    def time_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_delay_seconds", value)

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        """
        return pulumi.get(self, "whitelist")

    @whitelist.setter
    def whitelist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "whitelist", value)


class OriginEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['OriginEndpointAuthorizationArgs']]] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 cmaf_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointCmafPackageArgs']]] = None,
                 dash_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointDashPackageArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointHlsPackageArgs']]] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 mss_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointMssPackageArgs']]] = None,
                 origination: Optional[pulumi.Input['OriginEndpointOrigination']] = None,
                 startover_window_seconds: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OriginEndpointTagArgs']]]]] = None,
                 time_delay_seconds: Optional[pulumi.Input[int]] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaPackage::OriginEndpoint

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_id: The ID of the Channel the OriginEndpoint is associated with.
        :param pulumi.Input[str] description: A short text description of the OriginEndpoint.
        :param pulumi.Input[str] manifest_name: A short string appended to the end of the OriginEndpoint URL.
        :param pulumi.Input['OriginEndpointOrigination'] origination: Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        :param pulumi.Input[int] startover_window_seconds: Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OriginEndpointTagArgs']]]] tags: A collection of tags associated with a resource
        :param pulumi.Input[int] time_delay_seconds: Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] whitelist: A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OriginEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaPackage::OriginEndpoint

        :param str resource_name: The name of the resource.
        :param OriginEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['OriginEndpointAuthorizationArgs']]] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 cmaf_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointCmafPackageArgs']]] = None,
                 dash_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointDashPackageArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hls_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointHlsPackageArgs']]] = None,
                 manifest_name: Optional[pulumi.Input[str]] = None,
                 mss_package: Optional[pulumi.Input[pulumi.InputType['OriginEndpointMssPackageArgs']]] = None,
                 origination: Optional[pulumi.Input['OriginEndpointOrigination']] = None,
                 startover_window_seconds: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OriginEndpointTagArgs']]]]] = None,
                 time_delay_seconds: Optional[pulumi.Input[int]] = None,
                 whitelist: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginEndpointArgs.__new__(OriginEndpointArgs)

            __props__.__dict__["authorization"] = authorization
            if channel_id is None and not opts.urn:
                raise TypeError("Missing required property 'channel_id'")
            __props__.__dict__["channel_id"] = channel_id
            __props__.__dict__["cmaf_package"] = cmaf_package
            __props__.__dict__["dash_package"] = dash_package
            __props__.__dict__["description"] = description
            __props__.__dict__["hls_package"] = hls_package
            __props__.__dict__["manifest_name"] = manifest_name
            __props__.__dict__["mss_package"] = mss_package
            __props__.__dict__["origination"] = origination
            __props__.__dict__["startover_window_seconds"] = startover_window_seconds
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_delay_seconds"] = time_delay_seconds
            __props__.__dict__["whitelist"] = whitelist
            __props__.__dict__["arn"] = None
            __props__.__dict__["url"] = None
        super(OriginEndpoint, __self__).__init__(
            'aws-native:mediapackage:OriginEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OriginEndpoint':
        """
        Get an existing OriginEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OriginEndpointArgs.__new__(OriginEndpointArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["authorization"] = None
        __props__.__dict__["channel_id"] = None
        __props__.__dict__["cmaf_package"] = None
        __props__.__dict__["dash_package"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["hls_package"] = None
        __props__.__dict__["manifest_name"] = None
        __props__.__dict__["mss_package"] = None
        __props__.__dict__["origination"] = None
        __props__.__dict__["startover_window_seconds"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["time_delay_seconds"] = None
        __props__.__dict__["url"] = None
        __props__.__dict__["whitelist"] = None
        return OriginEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional['outputs.OriginEndpointAuthorization']]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Output[str]:
        """
        The ID of the Channel the OriginEndpoint is associated with.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="cmafPackage")
    def cmaf_package(self) -> pulumi.Output[Optional['outputs.OriginEndpointCmafPackage']]:
        return pulumi.get(self, "cmaf_package")

    @property
    @pulumi.getter(name="dashPackage")
    def dash_package(self) -> pulumi.Output[Optional['outputs.OriginEndpointDashPackage']]:
        return pulumi.get(self, "dash_package")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A short text description of the OriginEndpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hlsPackage")
    def hls_package(self) -> pulumi.Output[Optional['outputs.OriginEndpointHlsPackage']]:
        return pulumi.get(self, "hls_package")

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> pulumi.Output[Optional[str]]:
        """
        A short string appended to the end of the OriginEndpoint URL.
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="mssPackage")
    def mss_package(self) -> pulumi.Output[Optional['outputs.OriginEndpointMssPackage']]:
        return pulumi.get(self, "mss_package")

    @property
    @pulumi.getter
    def origination(self) -> pulumi.Output[Optional['OriginEndpointOrigination']]:
        """
        Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
        """
        return pulumi.get(self, "origination")

    @property
    @pulumi.getter(name="startoverWindowSeconds")
    def startover_window_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum duration (seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
        """
        return pulumi.get(self, "startover_window_seconds")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.OriginEndpointTag']]]:
        """
        A collection of tags associated with a resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeDelaySeconds")
    def time_delay_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of delay (seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
        """
        return pulumi.get(self, "time_delay_seconds")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the packaged OriginEndpoint for consumption.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def whitelist(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
        """
        return pulumi.get(self, "whitelist")

