# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LoadBalancerTlsCertificateArgs', 'LoadBalancerTlsCertificate']

@pulumi.input_type
class LoadBalancerTlsCertificateArgs:
    def __init__(__self__, *,
                 certificate_domain_name: pulumi.Input[str],
                 certificate_name: pulumi.Input[str],
                 load_balancer_name: pulumi.Input[str],
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_attached: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a LoadBalancerTlsCertificate resource.
        :param pulumi.Input[str] certificate_domain_name: The domain name (e.g., example.com ) for your SSL/TLS certificate.
        :param pulumi.Input[str] certificate_name: The SSL/TLS certificate name.
        :param pulumi.Input[str] load_balancer_name: The name of your load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_alternative_names: An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        :param pulumi.Input[bool] is_attached: When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        pulumi.set(__self__, "certificate_domain_name", certificate_domain_name)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if certificate_alternative_names is not None:
            pulumi.set(__self__, "certificate_alternative_names", certificate_alternative_names)
        if is_attached is not None:
            pulumi.set(__self__, "is_attached", is_attached)

    @property
    @pulumi.getter(name="certificateDomainName")
    def certificate_domain_name(self) -> pulumi.Input[str]:
        """
        The domain name (e.g., example.com ) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_domain_name")

    @certificate_domain_name.setter
    def certificate_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_domain_name", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[str]:
        """
        The SSL/TLS certificate name.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Input[str]:
        """
        The name of your load balancer.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="certificateAlternativeNames")
    def certificate_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_alternative_names")

    @certificate_alternative_names.setter
    def certificate_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificate_alternative_names", value)

    @property
    @pulumi.getter(name="isAttached")
    def is_attached(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        return pulumi.get(self, "is_attached")

    @is_attached.setter
    def is_attached(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_attached", value)


class LoadBalancerTlsCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_domain_name: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 is_attached: Optional[pulumi.Input[bool]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lightsail::LoadBalancerTlsCertificate

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_alternative_names: An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        :param pulumi.Input[str] certificate_domain_name: The domain name (e.g., example.com ) for your SSL/TLS certificate.
        :param pulumi.Input[str] certificate_name: The SSL/TLS certificate name.
        :param pulumi.Input[bool] is_attached: When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        :param pulumi.Input[str] load_balancer_name: The name of your load balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerTlsCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lightsail::LoadBalancerTlsCertificate

        :param str resource_name: The name of the resource.
        :param LoadBalancerTlsCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerTlsCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_domain_name: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 is_attached: Optional[pulumi.Input[bool]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerTlsCertificateArgs.__new__(LoadBalancerTlsCertificateArgs)

            __props__.__dict__["certificate_alternative_names"] = certificate_alternative_names
            if certificate_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_domain_name'")
            __props__.__dict__["certificate_domain_name"] = certificate_domain_name
            if certificate_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_name'")
            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["is_attached"] = is_attached
            if load_balancer_name is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_name'")
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["load_balancer_tls_certificate_arn"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancerTlsCertificate, __self__).__init__(
            'aws-native:lightsail:LoadBalancerTlsCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LoadBalancerTlsCertificate':
        """
        Get an existing LoadBalancerTlsCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LoadBalancerTlsCertificateArgs.__new__(LoadBalancerTlsCertificateArgs)

        __props__.__dict__["certificate_alternative_names"] = None
        __props__.__dict__["certificate_domain_name"] = None
        __props__.__dict__["certificate_name"] = None
        __props__.__dict__["is_attached"] = None
        __props__.__dict__["load_balancer_name"] = None
        __props__.__dict__["load_balancer_tls_certificate_arn"] = None
        __props__.__dict__["status"] = None
        return LoadBalancerTlsCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAlternativeNames")
    def certificate_alternative_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of strings listing alternative domains and subdomains for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_alternative_names")

    @property
    @pulumi.getter(name="certificateDomainName")
    def certificate_domain_name(self) -> pulumi.Output[str]:
        """
        The domain name (e.g., example.com ) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_domain_name")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[str]:
        """
        The SSL/TLS certificate name.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="isAttached")
    def is_attached(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
        """
        return pulumi.get(self, "is_attached")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The name of your load balancer.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerTlsCertificateArn")
    def load_balancer_tls_certificate_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "load_balancer_tls_certificate_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The validation status of the SSL/TLS certificate.
        """
        return pulumi.get(self, "status")

