# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AlarmArgs', 'Alarm']

@pulumi.input_type
class AlarmArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[str],
                 evaluation_periods: pulumi.Input[int],
                 metric_name: pulumi.Input[str],
                 monitored_resource_name: pulumi.Input[str],
                 threshold: pulumi.Input[float],
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 contact_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[int]] = None,
                 notification_enabled: Optional[pulumi.Input[bool]] = None,
                 notification_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 treat_missing_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Alarm resource.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        :param pulumi.Input[int] evaluation_periods: The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N.
        :param pulumi.Input[str] metric_name: The name of the metric to associate with the alarm.
        :param pulumi.Input[str] monitored_resource_name: The validation status of the SSL/TLS certificate.
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared.
        :param pulumi.Input[str] alarm_name: The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_protocols: The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both.
        :param pulumi.Input[int] datapoints_to_alarm: The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M.
        :param pulumi.Input[bool] notification_enabled: Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_triggers: The alarm states that trigger a notification.
        :param pulumi.Input[str] treat_missing_data: Sets how this alarm will handle missing data points.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "monitored_resource_name", monitored_resource_name)
        pulumi.set(__self__, "threshold", threshold)
        if alarm_name is not None:
            pulumi.set(__self__, "alarm_name", alarm_name)
        if contact_protocols is not None:
            pulumi.set(__self__, "contact_protocols", contact_protocols)
        if datapoints_to_alarm is not None:
            pulumi.set(__self__, "datapoints_to_alarm", datapoints_to_alarm)
        if notification_enabled is not None:
            pulumi.set(__self__, "notification_enabled", notification_enabled)
        if notification_triggers is not None:
            pulumi.set(__self__, "notification_triggers", notification_triggers)
        if treat_missing_data is not None:
            pulumi.set(__self__, "treat_missing_data", treat_missing_data)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[str]:
        """
        The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Input[int]:
        """
        The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: pulumi.Input[int]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric to associate with the alarm.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="monitoredResourceName")
    def monitored_resource_name(self) -> pulumi.Input[str]:
        """
        The validation status of the SSL/TLS certificate.
        """
        return pulumi.get(self, "monitored_resource_name")

    @monitored_resource_name.setter
    def monitored_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitored_resource_name", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        The value against which the specified statistic is compared.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_name", value)

    @property
    @pulumi.getter(name="contactProtocols")
    def contact_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both.
        """
        return pulumi.get(self, "contact_protocols")

    @contact_protocols.setter
    def contact_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_protocols", value)

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> Optional[pulumi.Input[int]]:
        """
        The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @datapoints_to_alarm.setter
    def datapoints_to_alarm(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "datapoints_to_alarm", value)

    @property
    @pulumi.getter(name="notificationEnabled")
    def notification_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter.
        """
        return pulumi.get(self, "notification_enabled")

    @notification_enabled.setter
    def notification_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notification_enabled", value)

    @property
    @pulumi.getter(name="notificationTriggers")
    def notification_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The alarm states that trigger a notification.
        """
        return pulumi.get(self, "notification_triggers")

    @notification_triggers.setter
    def notification_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_triggers", value)

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> Optional[pulumi.Input[str]]:
        """
        Sets how this alarm will handle missing data points.
        """
        return pulumi.get(self, "treat_missing_data")

    @treat_missing_data.setter
    def treat_missing_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "treat_missing_data", value)


class Alarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 contact_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[int]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 monitored_resource_name: Optional[pulumi.Input[str]] = None,
                 notification_enabled: Optional[pulumi.Input[bool]] = None,
                 notification_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 treat_missing_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lightsail::Alarm

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alarm_name: The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
        :param pulumi.Input[str] comparison_operator: The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_protocols: The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both.
        :param pulumi.Input[int] datapoints_to_alarm: The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M.
        :param pulumi.Input[int] evaluation_periods: The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N.
        :param pulumi.Input[str] metric_name: The name of the metric to associate with the alarm.
        :param pulumi.Input[str] monitored_resource_name: The validation status of the SSL/TLS certificate.
        :param pulumi.Input[bool] notification_enabled: Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_triggers: The alarm states that trigger a notification.
        :param pulumi.Input[float] threshold: The value against which the specified statistic is compared.
        :param pulumi.Input[str] treat_missing_data: Sets how this alarm will handle missing data points.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lightsail::Alarm

        :param str resource_name: The name of the resource.
        :param AlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 contact_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 datapoints_to_alarm: Optional[pulumi.Input[int]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 monitored_resource_name: Optional[pulumi.Input[str]] = None,
                 notification_enabled: Optional[pulumi.Input[bool]] = None,
                 notification_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 treat_missing_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmArgs.__new__(AlarmArgs)

            __props__.__dict__["alarm_name"] = alarm_name
            if comparison_operator is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_operator'")
            __props__.__dict__["comparison_operator"] = comparison_operator
            __props__.__dict__["contact_protocols"] = contact_protocols
            __props__.__dict__["datapoints_to_alarm"] = datapoints_to_alarm
            if evaluation_periods is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_periods'")
            __props__.__dict__["evaluation_periods"] = evaluation_periods
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            if monitored_resource_name is None and not opts.urn:
                raise TypeError("Missing required property 'monitored_resource_name'")
            __props__.__dict__["monitored_resource_name"] = monitored_resource_name
            __props__.__dict__["notification_enabled"] = notification_enabled
            __props__.__dict__["notification_triggers"] = notification_triggers
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
            __props__.__dict__["treat_missing_data"] = treat_missing_data
            __props__.__dict__["alarm_arn"] = None
            __props__.__dict__["state"] = None
        super(Alarm, __self__).__init__(
            'aws-native:lightsail:Alarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Alarm':
        """
        Get an existing Alarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AlarmArgs.__new__(AlarmArgs)

        __props__.__dict__["alarm_arn"] = None
        __props__.__dict__["alarm_name"] = None
        __props__.__dict__["comparison_operator"] = None
        __props__.__dict__["contact_protocols"] = None
        __props__.__dict__["datapoints_to_alarm"] = None
        __props__.__dict__["evaluation_periods"] = None
        __props__.__dict__["metric_name"] = None
        __props__.__dict__["monitored_resource_name"] = None
        __props__.__dict__["notification_enabled"] = None
        __props__.__dict__["notification_triggers"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["threshold"] = None
        __props__.__dict__["treat_missing_data"] = None
        return Alarm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "alarm_arn")

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Output[str]:
        """
        The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
        """
        return pulumi.get(self, "alarm_name")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Output[str]:
        """
        The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="contactProtocols")
    def contact_protocols(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The contact protocols to use for the alarm, such as Email, SMS (text messaging), or both.
        """
        return pulumi.get(self, "contact_protocols")

    @property
    @pulumi.getter(name="datapointsToAlarm")
    def datapoints_to_alarm(self) -> pulumi.Output[Optional[int]]:
        """
        The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (datapointsToAlarm) is the M.
        """
        return pulumi.get(self, "datapoints_to_alarm")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Output[int]:
        """
        The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (evaluationPeriods) is the N.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[str]:
        """
        The name of the metric to associate with the alarm.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="monitoredResourceName")
    def monitored_resource_name(self) -> pulumi.Output[str]:
        """
        The validation status of the SSL/TLS certificate.
        """
        return pulumi.get(self, "monitored_resource_name")

    @property
    @pulumi.getter(name="notificationEnabled")
    def notification_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the alarm is enabled. Notifications are enabled by default if you don't specify this parameter.
        """
        return pulumi.get(self, "notification_enabled")

    @property
    @pulumi.getter(name="notificationTriggers")
    def notification_triggers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The alarm states that trigger a notification.
        """
        return pulumi.get(self, "notification_triggers")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the alarm.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[float]:
        """
        The value against which the specified statistic is compared.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="treatMissingData")
    def treat_missing_data(self) -> pulumi.Output[Optional[str]]:
        """
        Sets how this alarm will handle missing data points.
        """
        return pulumi.get(self, "treat_missing_data")

