# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetDataCatalogResult',
    'AwaitableGetDataCatalogResult',
    'get_data_catalog',
    'get_data_catalog_output',
]

@pulumi.output_type
class GetDataCatalogResult:
    def __init__(__self__, description=None, parameters=None, tags=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the data catalog to be created. 
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Specifies the Lambda function or functions to use for creating the data catalog. This is a mapping whose values depend on the catalog type. 
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DataCatalogTag']]:
        """
        A list of comma separated tags to add to the data catalog that is created. 
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['DataCatalogType']:
        """
        The type of data catalog to create: LAMBDA for a federated catalog, GLUE for AWS Glue Catalog, or HIVE for an external hive metastore. 
        """
        return pulumi.get(self, "type")


class AwaitableGetDataCatalogResult(GetDataCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataCatalogResult(
            description=self.description,
            parameters=self.parameters,
            tags=self.tags,
            type=self.type)


def get_data_catalog(name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataCatalogResult:
    """
    Resource schema for AWS::Athena::DataCatalog


    :param str name: The name of the data catalog to create. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters. 
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:athena:getDataCatalog', __args__, opts=opts, typ=GetDataCatalogResult).value

    return AwaitableGetDataCatalogResult(
        description=__ret__.description,
        parameters=__ret__.parameters,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_data_catalog)
def get_data_catalog_output(name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataCatalogResult]:
    """
    Resource schema for AWS::Athena::DataCatalog


    :param str name: The name of the data catalog to create. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters. 
    """
    ...
