#pragma once
/*
Copyright (C) 2017 Ming-Shing Chen

This file is part of BitPolyMul.

BitPolyMul is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BitPolyMul is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BitPolyMul.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "libOTe/config.h"
#ifdef ENABLE_SILENTOT


#include "stdint.h"



namespace bpm {


    alignas(32) const uint64_t beta_mul_64_bm4r_ext_8[2 * 128 * 4 * 2] = {
    0x8d8cadac21200100,0x9c9dbcbd30311011,0x8d8cadac21200100,0x9c9dbcbd30311011,
    0xfe769810ee668800,0x8008e66e9018f67e,0xfe769810ee668800,0x8008e66e9018f67e,
    0xb2b25454e6e60000,0xa2a24444f6f61010,0xb2b25454e6e60000,0xa2a24444f6f61010,
    0xbf50cf209f70ef00,0xdc33ac43fc138c63,0xbf50cf209f70ef00,0xdc33ac43fc138c63,
    0xe3e3707093930000,0xc7c75454b7b72424,0xe3e3707093930000,0xc7c75454b7b72424,
    0xc5f4a8995c6d3100,0xaa9bc7f633025e6f,0xc5f4a8995c6d3100,0xaa9bc7f633025e6f,
    0xc7c7d7d710100000,0x3c3c2c2cebebfbfb,0xc7c7d7d710100000,0x3c3c2c2cebebfbfb,
    0x5f51ddd38c820e00,0xf0fe727c232da1af,0x5f51ddd38c820e00,0xf0fe727c232da1af,
    0x8080949414140000,0x8181959515150101,0x8080949414140000,0x8181959515150101,
    0x4de4d37a379ea900,0x57fec9602d84b31a,0x4de4d37a379ea900,0x57fec9602d84b31a,
    0x5d5d141449490000,0xa3a3eaeab7b7fefe,0x5d5d141449490000,0xa3a3eaeab7b7fefe,
    0xd357119546c28400,0xe8acc489b1f59dd,0xd357119546c28400,0xe8acc489b1f59dd,
    0xe9e91a1af3f30000,0x303f0f01919eaea,0xe9e91a1af3f30000,0x303f0f01919eaea,
    0xf0646bff0f9b9400,0xdc4847d323b7b82c,0xf0646bff0f9b9400,0xdc4847d323b7b82c,
    0x5050777727270000,0x5d5d7a7a2a2a0d0d,0x5050777727270000,0x5d5d7a7a2a2a0d0d,
    0x7e5aeecab4902400,0xffdb6f4b3511a581,0x7e5aeecab4902400,0xffdb6f4b3511a581,
    0xede1333fd2de0c00,0xa6aa78749995474b,0xede1333fd2de0c00,0xa6aa78749995474b,
    0x7688be4036c8fe00,0xe41a2cd2a45a6c92,0x7688be4036c8fe00,0xe41a2cd2a45a6c92,
    0x7a583a1862402200,0x1b395b7903214361,0x7a583a1862402200,0x1b395b7903214361,
    0xea90a7dd374d7a00,0x6b11265cb6ccfb81,0xea90a7dd374d7a00,0x6b11265cb6ccfb81,
    0x5273d9f8aa8b2100,0xfbda7051032288a9,0x5273d9f8aa8b2100,0xfbda7051032288a9,
    0xf534d819ec2dc100,0x46876baa5f9e72b3,0xf534d819ec2dc100,0x46876baa5f9e72b3,
    0xd4c3c3d400171700,0xd0c7c7d004131304,0xd4c3c3d400171700,0xd0c7c7d004131304,
    0xf9d6230cf5da2f00,0x827d2fd042bdef1,0xf9d6230cf5da2f00,0x827d2fd042bdef1,
    0x4ca91cf9b550e500,0x39dc698cc0259075,0x4ca91cf9b550e500,0x39dc698cc0259075,
    0xc2a57710d2b56700,0x661b3d41671a3c4,0xc2a57710d2b56700,0x661b3d41671a3c4,
    0x515dbbb7e6ea0c00,0xd0dc3a36676b8d81,0x515dbbb7e6ea0c00,0xd0dc3a36676b8d81,
    0x7bf68c017af78d00,0x489f37e0588f27f,0x7bf68c017af78d00,0x489f37e0588f27f,
    0x1262b4c4d6a67000,0x4838ee9e8cfc2a5a,0x1262b4c4d6a67000,0x4838ee9e8cfc2a5a,
    0xbf58709728cfe700,0x1ef9d136896e46a1,0xbf58709728cfe700,0x1ef9d136896e46a1,
    0x8c5ded3cb061d100,0x9140f021ad7ccc1d,0x8c5ded3cb061d100,0x9140f021ad7ccc1d,
    0x51eaeb5001babb00,0xa31819a2f34849f2,0x51eaeb5001babb00,0xa31819a2f34849f2,
    0x6e54261c72483a00,0x90aad8e28cb6c4fe,0x6e54261c72483a00,0x90aad8e28cb6c4fe,
    0xd4f0e4c41034200,0x490b4a0805470644,0xd4f0e4c41034200,0x490b4a0805470644,
    0xac29d653ff7a8500,0xa520df5af6738c09,0xac29d653ff7a8500,0xa520df5af6738c09,
    0x3296a90d3f9ba400,0x2581be1a288cb317,0x3296a90d3f9ba400,0x2581be1a288cb317,
    0x61f6b02746d19700,0xc4531582e37432a5,0x61f6b02746d19700,0xc4531582e37432a5,
    0x74ddd47d09a0a900,0x5aca50c78d1d871,0x74ddd47d09a0a900,0x5aca50c78d1d871,
    0xb288566cdee43a00,0x7e449aa01228f6cc,0xb288566cdee43a00,0x7e449aa01228f6cc,
    0xf9d7cae41d332e00,0xc6e8f5db220c113f,0xf9d7cae41d332e00,0xc6e8f5db220c113f,
    0xc088d29a5a124800,0x4b035911d199c38b,0xc088d29a5a124800,0x4b035911d199c38b,
    0xd4220bfd29dff600,0x18eec731e5133acc,0xd4220bfd29dff600,0x18eec731e5133acc,
    0x3417715266452300,0xeecdab88bc9ff9da,0x3417715266452300,0xeecdab88bc9ff9da,
    0xbc74d61ea26ac800,0x3cb69a11dd577bf,0xbc74d61ea26ac800,0x3cb69a11dd577bf,
    0xbe30149a24aa8e00,0xba34109e20ae8a04,0xbe30149a24aa8e00,0xba34109e20ae8a04,
    0x7157c3e594b22600,0xcaec785e2f099dbb,0x7157c3e594b22600,0xcaec785e2f099dbb,
    0xfc268d57ab71da00,0xf12b805aa67cd70d,0xfc268d57ab71da00,0xf12b805aa67cd70d,
    0x22a3b8391b9a8100,0xbd3c27a684051e9f,0x22a3b8391b9a8100,0xbd3c27a684051e9f,
    0x8bfc1265ee997700,0x4235dbac2750bec9,0x8bfc1265ee997700,0x4235dbac2750bec9,
    0xfb2c4a9d66b1d700,0xb36402d52ef99f48,0xfb2c4a9d66b1d700,0xb36402d52ef99f48,
    0x2c30a8b498841c00,0xb1ad35290519819d,0x2c30a8b498841c00,0xb1ad35290519819d,
    0xc41378af6bbcd700,0xda0d66b175a2c91e,0xc41378af6bbcd700,0xda0d66b175a2c91e,
    0x52535b5a08090100,0xf3f2fafba9a8a0a1,0x52535b5a08090100,0xf3f2fafba9a8a0a1,
    0x82519142c013d300,0x27f434e765b676a5,0x82519142c013d300,0x27f434e765b676a5,
    0x5c2094e8b4c87c00,0xb6ca7e025e2296ea,0x5c2094e8b4c87c00,0xb6ca7e025e2296ea,
    0x4848fefeb6b60000,0xaaaa1c1c5454e2e2,0x4848fefeb6b60000,0xaaaa1c1c5454e2e2,
    0x4f142e753a615b00,0xa0fbc19ad58eb4ef,0x4f142e753a615b00,0xa0fbc19ad58eb4ef,
    0x750c7801740d7900,0x423b4f36433a4e37,0x750c7801740d7900,0x423b4f36433a4e37,
    0x36da26cafc10ec00,0x22ce32dee804f814,0x36da26cafc10ec00,0x22ce32dee804f814,
    0x61bac31879a2db00,0x419ae3385982fb20,0x61bac31879a2db00,0x419ae3385982fb20,
    0x8eb70a33bd843900,0xe6df625bd5ec5168,0x8eb70a33bd843900,0xe6df625bd5ec5168,
    0xc6b9fa85433c7f00,0xa1de9de2245b1867,0xc6b9fa85433c7f00,0xa1de9de2245b1867,
    0xf248813bc973ba00,0xb70dc47e8c36ff45,0xf248813bc973ba00,0xb70dc47e8c36ff45,
    0xb2c5f38436417700,0xf285b3c476013740,0xb2c5f38436417700,0xf285b3c476013740,
    0x5898bb7b23e3c000,0x4c8caf6f37f7d414,0x5898bb7b23e3c000,0x4c8caf6f37f7d414,
    0x76b31edbad68c500,0x9653fe3b4d8825e0,0x76b31edbad68c500,0x9653fe3b4d8825e0,
    0xd064ac18c87cb400,0x52e62e9a4afe3682,0xd064ac18c87cb400,0x52e62e9a4afe3682,
    0x519664a3f235c700,0xa562905706c133f4,0x519664a3f235c700,0xa562905706c133f4,
    0x7b64322d56491f00,0x8d92c4dba0bfe9f6,0x7b64322d56491f00,0x8d92c4dba0bfe9f6,
    0x4f02723f703d4d00,0xcd80f0bdf2bfcf82,0x4f02723f703d4d00,0xcd80f0bdf2bfcf82,
    0xf139cd05f43cc800,0x76be4a8273bb4f87,0xf139cd05f43cc800,0x76be4a8273bb4f87,
    0xecb06539d5895c00,0x5c89d53965b0ec,0xecb06539d5895c00,0x5c89d53965b0ec,
    0xa63959c660ff9f00,0x50cfaf30960969f6,0xa63959c660ff9f00,0x50cfaf30960969f6,
    0x7d1e82e19cff6300,0xd3b02c4f3251cdae,0x7d1e82e19cff6300,0xd3b02c4f3251cdae,
    0xab28bd3e95168300,0x86059013b83bae2d,0xab28bd3e95168300,0x86059013b83bae2d,
    0x6109f39bfa926800,0x325aa0c8a9c13b53,0x6109f39bfa926800,0x325aa0c8a9c13b53,
    0xf6864a3accbc7000,0xc6b67a0afc8c4030,0xf6864a3accbc7000,0xc6b67a0afc8c4030,
    0xa9690bcb62a2c000,0xd61674b41dddbf7f,0xa9690bcb62a2c000,0xd61674b41dddbf7f,
    0xe8b25f05edb75a00,0x7c26cb917923ce94,0xe8b25f05edb75a00,0x7c26cb917923ce94,
    0x67e5da583fbd8200,0xcc4e71f3941629ab,0x67e5da583fbd8200,0xcc4e71f3941629ab,
    0x8e750df67883fb00,0x44bfc73cb24931ca,0x8e750df67883fb00,0x44bfc73cb24931ca,
    0xe451fc49ad18b500,0x95208d38dc69c471,0xe451fc49ad18b500,0x95208d38dc69c471,
    0x51a34dbfee1cf200,0x3f11fedbc4ea052,0x51a34dbfee1cf200,0x3f11fedbc4ea052,
    0x7dcaa21568dfb700,0xe0573f88f5422a9d,0x7dcaa21568dfb700,0xe0573f88f5422a9d,
    0x67d702b2d565b000,0x5beb3e8ee9598c3c,0x67d702b2d565b000,0x5beb3e8ee9598c3c,
    0xb428811da9359c00,0x9804ad318519b02c,0xb428811da9359c00,0x9804ad318519b02c,
    0xb3f31050e3a34000,0x9cdc3f7fcc8c6f2f,0xb3f31050e3a34000,0x9cdc3f7fcc8c6f2f,
    0x3d00734e734e3d00,0x4d70033e033e4d70,0x3d00734e734e3d00,0x4d70033e033e4d70,
    0xdf4c22b16efd9300,0xbe2d43d00f9cf261,0xdf4c22b16efd9300,0xbe2d43d00f9cf261,
    0x36e9419ea877df00,0xb768c01f29f65e81,0x36e9419ea877df00,0xb768c01f29f65e81,
    0xd499afe2367b4d00,0xd39ea8e5317c4a07,0xd499afe2367b4d00,0xd39ea8e5317c4a07,
    0xcfc9edeb24220600,0x5c5a7e78b7b19593,0xcfc9edeb24220600,0x5c5a7e78b7b19593,
    0xc5c3dfd91c1a0600,0x9a9c80864345595f,0xc5c3dfd91c1a0600,0x9a9c80864345595f,
    0x9387120695811400,0xdfcb5e4ad9cd584c,0x9387120695811400,0xdfcb5e4ad9cd584c,
    0xbc469d67db21fa00,0x728853a915ef34ce,0xbc469d67db21fa00,0x728853a915ef34ce,
    0x52c555c290079700,0x980f9f085acd5dca,0x52c555c290079700,0x980f9f085acd5dca,
    0xd7549f1ccb488300,0xc142890add5e9516,0xd7549f1ccb488300,0xc142890add5e9516,
    0x21a8d25b7af38900,0xc44d37be9f166ce5,0x21a8d25b7af38900,0xc44d37be9f166ce5,
    0x8bba5e6fe4d53100,0x5c6d89b83302e6d7,0x8bba5e6fe4d53100,0x5c6d89b83302e6d7,
    0xc565df7fba1aa000,0x9f3f8525e040fa5a,0xc565df7fba1aa000,0x9f3f8525e040fa5a,
    0x17c457849340d300,0x70a330e3f427b467,0x17c457849340d300,0x70a330e3f427b467,
    0xac286eea46c28400,0x6de9af2b870345c1,0xac286eea46c28400,0x6de9af2b870345c1,
    0xf96f29bf46d09600,0xbe286ef80197d147,0xf96f29bf46d09600,0xbe286ef80197d147,
    0xf444bb0bff4fb000,0x76c639897dcd3282,0xf444bb0bff4fb000,0x76c639897dcd3282,
    0xc4f93805c1fc3d00,0x3a07c6fb3f02c3fe,0xc4f93805c1fc3d00,0x3a07c6fb3f02c3fe,
    0x58ca9a0850c29200,0x861444d68e1c4cde,0x58ca9a0850c29200,0x861444d68e1c4cde,
    0x5e045208560c5a00,0x6832643e603a6c36,0x5e045208560c5a00,0x6832643e603a6c36,
    0xa9aac8cb62610300,0x1a197b78d1d2b0b3,0xa9aac8cb62610300,0x1a197b78d1d2b0b3,
    0xf87dac29d1548500,0x47c213966eeb3abf,0xf87dac29d1548500,0x47c213966eeb3abf,
    0x663ffea7c1985900,0xc89150096f36f7ae,0x663ffea7c1985900,0xc89150096f36f7ae,
    0x926e3ec250acfc00,0x897525d94bb7e71b,0x926e3ec250acfc00,0x897525d94bb7e71b,
    0x208f02ad8d22af00,0x369914bb9b34b916,0x208f02ad8d22af00,0x369914bb9b34b916,
    0x2a0b24052f0e2100,0xdffed1f0dafbd4f5,0x2a0b24052f0e2100,0xdffed1f0dafbd4f5,
    0xf1bccd8d7c31400,0xc3d700141b0fd8cc,0xf1bccd8d7c31400,0xc3d700141b0fd8cc,
    0xce0aca0ec004c400,0xe521e125eb2fef2b,0xce0aca0ec004c400,0xe521e125eb2fef2b,
    0xdd97f1bb662c4a00,0x96dcbaf02d67014b,0xdd97f1bb662c4a00,0x96dcbaf02d67014b,
    0x8756fd2cab7ad100,0xbda71a027f65d8c,0x8756fd2cab7ad100,0xbda71a027f65d8c,
    0x410b206a2b614a00,0xd69cb7fdbcf6dd97,0x410b206a2b614a00,0xd69cb7fdbcf6dd97,
    0x754acfff8ab5300,0x2f7c84d7d0837b28,0x754acfff8ab5300,0x2f7c84d7d0837b28,
    0xa9b4766bc2df1d00,0xeef3312c85985a47,0xa9b4766bc2df1d00,0xeef3312c85985a47,
    0x49820dc68f44cb00,0x8e45ca0148830cc7,0x49820dc68f44cb00,0x8e45ca0148830cc7,
    0xe97cc752bb2e9500,0x7ce952c72ebb0095,0xe97cc752bb2e9500,0x7ce952c72ebb0095,
    0x687d9c89e1f41500,0xd2c726335b4eafba,0x687d9c89e1f41500,0xd2c726335b4eafba,
    0x73eadc4536af9900,0x3da4920b78e1d74e,0x73eadc4536af9900,0x3da4920b78e1d74e,
    0xb8ad0a1fa7b21500,0x1005a2b70f1abda8,0xb8ad0a1fa7b21500,0x1005a2b70f1abda8,
    0x44f3fd4a0eb9b700,0xf4434dfabe0907b0,0x44f3fd4a0eb9b700,0xf4434dfabe0907b0,
    0x4e97f42d63bad900,0xa87112cb855c3fe6,0x4e97f42d63bad900,0xa87112cb855c3fe6,
    0x4d7e45763b083300,0x86b58ebdf0c3f8cb,0x4d7e45763b083300,0x86b58ebdf0c3f8cb,
    0x73b75f9be82cc400,0x71b55d99ea2ec602,0x73b75f9be82cc400,0x71b55d99ea2ec602,
    0x7b7ca3a4dfd80700,0x86815e592225fafd,0x7b7ca3a4dfd80700,0x86815e592225fafd,
    0x24ebe6290dc2cf00,0xae616ca38748458a,0x24ebe6290dc2cf00,0xae616ca38748458a,
    0x243cbba3879f1800,0xb3ab2c3410088f97,0x243cbba3879f1800,0xb3ab2c3410088f97,
    0xed17fd07ea10fa00,0x33c923d934ce24de,0xed17fd07ea10fa00,0x33c923d934ce24de,
    0x33b20f8ebd3c8100,0x9e1fa22310912cad,0x33b20f8ebd3c8100,0x9e1fa22310912cad,
    0x9ef0026cf29c6e00,0xa3cd3f51cfa1533d,0x9ef0026cf29c6e00,0xa3cd3f51cfa1533d,
    0x7768c0dfa8b71f00,0xe7f8504f38278f90,0x7768c0dfa8b71f00,0xe7f8504f38278f90,
    0x375bb2dee9856c00,0x2844adc1f69a731f,0x375bb2dee9856c00,0x2844adc1f69a731f,
    0xaf992f19b6803600,0x93a513258abc0a3c,0xaf992f19b6803600,0x93a513258abc0a3c,
    0x7a0f87f288fd7500,0xf1840c790376fe8b,0x7a0f87f288fd7500,0xf1840c790376fe8b,
    0x8015c752d2479500,0xcc598b1e9e0bd94c,0x8015c752d2479500,0xcc598b1e9e0bd94c,
    0x8023be1d9d3ea300,0x48eb76d555f66bc8,0x8023be1d9d3ea300,0x48eb76d555f66bc8,
    0x9c2f21920ebdb300,0x15a6a81b87343a89,0x9c2f21920ebdb300,0x15a6a81b87343a89,
    0x30d356b58566e300,0x8e6de80b3bd85dbe,0x30d356b58566e300,0x8e6de80b3bd85dbe,
    0xa9a6222d848b0f00,0xded1555af3fc7877,0xa9a6222d848b0f00,0xded1555af3fc7877,
    0xa7c9d9b7107e6e00,0x76180866c1afbfd1,0xa7c9d9b7107e6e00,0x76180866c1afbfd1,
    0x6c02f59bf7996e00,0x8ae4137d117f88e6,0x6c02f59bf7996e00,0x8ae4137d117f88e6,
    0xb31f2884379bac00,0xcc6057fb48e4d37f,0xb31f2884379bac00,0xcc6057fb48e4d37f,
    0x24dcd62e0af2f800,0x89717b83a75f55ad,0x24dcd62e0af2f800,0x89717b83a75f55ad,
    0xe29fdca1433e7d00,0xe79ad9a4463b7805,0xe29fdca1433e7d00,0xe79ad9a4463b7805,
    0x4f75caf0bf853a00,0xcdf748723d07b882,0x4f75caf0bf853a00,0xcdf748723d07b882,
    0x9ed3d69b05484d00,0x6924216cf2bfbaf7,0x9ed3d69b05484d00,0x6924216cf2bfbaf7,
    0x4bba837239c8f100,0x4bba837239c8f100,0x4bba837239c8f100,0x4bba837239c8f100,
    0xf0fe2a24d4da0e00,0x353befe1111fcbc5,0xf0fe2a24d4da0e00,0x353befe1111fcbc5,
    0xa1c3a5c766046200,0xb6d4b2d071137517,0xa1c3a5c766046200,0xb6d4b2d071137517,
    0x733a94ddaee74900,0xfeb71950236ac48d,0x733a94ddaee74900,0xfeb71950236ac48d,
    0x43b2906122d3f100,0x7081a35211e0c233,0x43b2906122d3f100,0x7081a35211e0c233,
    0x7281906311e2f300,0x9c6f7e8dff0c1dee,0x7281906311e2f300,0x9c6f7e8dff0c1dee,
    0x681709761e617f00,0x1a657b046c130d72,0x681709761e617f00,0x1a657b046c130d72,
    0xa7876040e7c7200,0xc7e7002087a7406,0xa7876040e7c7200,0xc7e7002087a7406,
    0xe747d2729535a000,0x379702a245e570d0,0xe747d2729535a000,0x379702a245e570d0,
    0x1914a6abb2bf0d00,0x5b56e4e9f0fd4f42,0x1914a6abb2bf0d00,0x5b56e4e9f0fd4f42,
    0xea8a4020caaa600,0x1bbdb11719bfb315,0xea8a4020caaa600,0x1bbdb11719bfb315,
    0xfd5343ed10beae00,0x832d3d936ec0d07e,0xfd5343ed10beae00,0x832d3d936ec0d07e,
    0xa5a5b3b316160000,0x71716767c2c2d4d4,0xa5a5b3b316160000,0x71716767c2c2d4d4,
    0x4ae8c262288aa00,0x2e84a60c08a2802a,0x4ae8c262288aa00,0x2e84a60c08a2802a,
    0xb5017ace7bcfb400,0xb4007bcf7aceb501,0xb5017ace7bcfb400,0xb4007bcf7aceb501,
    0xdddf42429f9d000,0xd2022bfbf6260fdf,0xdddf42429f9d000,0xd2022bfbf6260fdf,
    0xf3c9ffc5360c3a00,0xd2e8dee4172d1b21,0xf3c9ffc5360c3a00,0xd2e8dee4172d1b21,
    0x966f847deb12f900,0xf60fe41d8b729960,0x966f847deb12f900,0xf60fe41d8b729960,
    0xeca5ffb65a134900,0xe5acf6bf531a4009,0xeca5ffb65a134900,0xe5acf6bf531a4009,
    0xd286c49042165400,0x72266430e2b6f4a0,0xd286c49042165400,0x72266430e2b6f4a0,
    0xb02146d767f69100,0x62f39405b52443d2,0xb02146d767f69100,0x62f39405b52443d2,
    0xc563b214d177a600,0xe2449533f6508127,0xc563b214d177a600,0xe2449533f6508127,
    0x8d48ae6be623c500,0x509573b63bfe18dd,0x8d48ae6be623c500,0x509573b63bfe18dd,
    0xdc702d815df1ac00,0xf75b06aa76da872b,0xdc702d815df1ac00,0xf75b06aa76da872b,
    0x7452b395e1c72600,0x90b657710523c2e4,0x7452b395e1c72600,0x90b657710523c2e4,
    0xb8480cfc44b4f000,0x50a0e414ac5c18e8,0xb8480cfc44b4f000,0x50a0e414ac5c18e8,
    0xc11072a362b3d100,0xc61775a465b4d607,0xc11072a362b3d100,0xc61775a465b4d607,
    0x97bfa28a1d352800,0xc9e1fcd4436b765e,0x97bfa28a1d352800,0xc9e1fcd4436b765e,
    0xf62cd00afc26da00,0x429864be48926eb4,0xf62cd00afc26da00,0x429864be48926eb4,
    0x340cdee6d2ea3800,0x2b13c1f9cdf5271f,0x340cdee6d2ea3800,0x2b13c1f9cdf5271f,
    0x5fc8c156099e9700,0xd84f46d18e191087,0x5fc8c156099e9700,0xd84f46d18e191087,
    0x4cf36cd39f20bf00,0x11ae318ec27de25d,0x4cf36cd39f20bf00,0x11ae318ec27de25d,
    0xed2f2def02c0c200,0xaf6d6fad40828042,0xed2f2def02c0c200,0xaf6d6fad40828042,
    0x190da8bca5b11400,0xbfab0e1a0317b2a6,0x190da8bca5b11400,0xbfab0e1a0317b2a6,
    0x6d276e2449034a00,0x4309400a672d642e,0x6d276e2449034a00,0x4309400a672d642e,
    0xb3bda2ac1f110e00,0x323c232d9e908f81,0xb3bda2ac1f110e00,0x323c232d9e908f81,
    0x30e213c1f123d200,0x6cbe4f9dad7f8e5c,0x30e213c1f123d200,0x6cbe4f9dad7f8e5c,
    0x97ec790295ee7b00,0x4d36a3d84f34a1da,0x97ec790295ee7b00,0x4d36a3d84f34a1da,
    0x5cebbc0b57e0b700,0x6bdc8b3c60d78037,0x5cebbc0b57e0b700,0x6bdc8b3c60d78037,
    0x30380f07373f0800,0x60685f57676f5850,0x30380f07373f0800,0x60685f57676f5850,
    0xdc3dc121fd1ce00,0xe12f30fef33d22ec,0xdc3dc121fd1ce00,0xe12f30fef33d22ec,
    0xc7894a04c38d4e00,0x1d5390de195794da,0xc7894a04c38d4e00,0x1d5390de195794da,
    0xbb19ac0eb517a200,0x1bb90cae15b702a0,0xbb19ac0eb517a200,0x1bb90cae15b702a0,
    0x1e2c3d0f11233200,0xc3e2f1d03312012,0x1e2c3d0f11233200,0xc3e2f1d03312012,
    0x7af3e56c169f8900,0xd84921b61e8fe77,0x7af3e56c169f8900,0xd84921b61e8fe77,
    0xaa72409832ead800,0xfe2614cc66be8c54,0xaa72409832ead800,0xfe2614cc66be8c54,
    0xdcdd80815d5c0100,0xf2f3aeaf73722f2e,0xdcdd80815d5c0100,0xf2f3aeaf73722f2e,
    0xd8eae2d20a38300,0xbb38189b961535b6,0xd8eae2d20a38300,0xbb38189b961535b6,
    0x5add65e2b83f8700,0x68139bee463db5c,0x5add65e2b83f8700,0x68139bee463db5c,
    0x3b8450efd46bbf00,0xf946922d16a97dc2,0x3b8450efd46bbf00,0xf946922d16a97dc2,
    0x2d903885a815bd00,0x79c46cd1fc41e954,0x2d903885a815bd00,0x79c46cd1fc41e954,
    0xe3111def0cfef200,0xb3414dbf5caea250,0xe3111def0cfef200,0xb3414dbf5caea250,
    0xe19e2e51b0cf7f00,0x778c8b7562999e6,0xe19e2e51b0cf7f00,0x778c8b7562999e6,
    0x974cd803944fdb00,0x449f0bd0479c08d3,0x974cd803944fdb00,0x449f0bd0479c08d3,
    0xd92bf002db29f200,0x6f42fdd04f62ddf,0xd92bf002db29f200,0x6f42fdd04f62ddf,
    0xcb56a538f36e9d00,0x4996af73ca152cf,0xcb56a538f36e9d00,0x4996af73ca152cf,
    0x26238386a0a50500,0x838626230500a0a5,0x26238386a0a50500,0x838626230500a0a5,
    0xd6843c6eb8ea5200,0x7c2e96c41240f8aa,0xd6843c6eb8ea5200,0x7c2e96c41240f8aa,
    0x6f41e0cea18f2e00,0x755bfad4bb95341a,0x6f41e0cea18f2e00,0x755bfad4bb95341a,
    0x982e2e9800b6b600,0x67d1d167ff4949ff,0x982e2e9800b6b600,0x67d1d167ff4949ff,
    0xc2acd5bb79176e00,0xe688f19f5d334a24,0xc2acd5bb79176e00,0xe688f19f5d334a24,
    0x44aa14fabe50ee00,0x9876c826628c32dc,0x44aa14fabe50ee00,0x9876c826628c32dc,
    0x34a21482b6209600,0x63f543d5e177c157,0x34a21482b6209600,0x63f543d5e177c157,
    0x620cb8d6b4da6e00,0x46289cf290fe4a24,0x620cb8d6b4da6e00,0x46289cf290fe4a24,
    0xef7d0e9c73e19200,0x9f0d7eec0391e270,0xef7d0e9c73e19200,0x9f0d7eec0391e270,
    0x90f17d1c8ced6100,0xb0d15d3caccd4120,0x90f17d1c8ced6100,0xb0d15d3caccd4120,
    0xba7cd016ac6ac600,0xe4228e48f234985e,0xba7cd016ac6ac600,0xe4228e48f234985e,
    0xdb88ce9d46155300,0xa591f4c97c482d1,0xdb88ce9d46155300,0xa591f4c97c482d1,
    0xccf6734985bf3a00,0x7f45c0fa360c89b3,0xccf6734985bf3a00,0x7f45c0fa360c89b3,
    0xa6fee5bd1b435800,0xe4bca7ff59011a42,0xa6fee5bd1b435800,0xe4bca7ff59011a42,
    0x3ab029a399138a00,0x41cb52d8e268f17b,0x3ab029a399138a00,0x41cb52d8e268f17b,
    0x9b924d44dfd60900,0x343de2eb7079a6af,0x9b924d44dfd60900,0x343de2eb7079a6af,
    0x44ddc9591d84900,0x7039a8e1e5ac3d74,0x44ddc9591d84900,0x7039a8e1e5ac3d74,
    0xa1b1f8e849591000,0x617138288999d0c0,0xa1b1f8e849591000,0x617138288999d0c0,
    0xe26b4ac321a88900,0x1198b930d25b7af3,0xe26b4ac321a88900,0x1198b930d25b7af3,
    0x5940160f564f1900,0x372e78613821776e,0x5940160f564f1900,0x372e78613821776e,
    0xdbb2127ba0c96900,0x6a03a3ca1178d8b1,0xdbb2127ba0c96900,0x6a03a3ca1178d8b1,
    0x92639c6dff0ef100,0x72837c8d1fee11e0,0x92639c6dff0ef100,0x72837c8d1fee11e0,
    0xafa2bfb21d100d00,0x878a979a35382528,0xafa2bfb21d100d00,0x878a979a35382528,
    0xc9ede8cc05212400,0x1f3b3e1ad3f7f2d6,0xc9ede8cc05212400,0x1f3b3e1ad3f7f2d6,
    0xa9a28289202b0b00,0x4f44646fc6cdede6,0xa9a28289202b0b00,0x4f44646fc6cdede6,
    0xa4f592c367365100,0x6b3a5d0ca8f99ecf,0xa4f592c367365100,0x6b3a5d0ca8f99ecf,
    0xe3304c9f7cafd300,0xfd2e528162b1cd1e,0xe3304c9f7cafd300,0xfd2e528162b1cd1e,
    0xe6ca0529cfe32c00,0xdff33c10f6da1539,0xe6ca0529cfe32c00,0xdff33c10f6da1539,
    0xcd403cb17cf18d00,0xc74a36bb76fb870a,0xcd403cb17cf18d00,0xc74a36bb76fb870a,
    0xeda64f04e9a24b00,0x92d9307b96dd347f,0xeda64f04e9a24b00,0x92d9307b96dd347f,
    0x86be7941c7ff3800,0xf6ce0931b78f4870,0x86be7941c7ff3800,0xf6ce0931b78f4870,
    0x71a4a87d0cd9d500,0xcb1e12c7b6636fba,0x71a4a87d0cd9d500,0xcb1e12c7b6636fba,
    0x757d848cf9f10800,0x1911e8e0959d646c,0x757d848cf9f10800,0x1911e8e0959d646c,
    0xf0349e5aaa6ec400,0x9cd67a353973df9,0xf0349e5aaa6ec400,0x9cd67a353973df9,
    0x2d18d2e7caff3500,0x72478db895a06a5f,0x2d18d2e7caff3500,0x72478db895a06a5f,
    0x9e148a0a941e800,0x31d970989179d038,0x9e148a0a941e800,0x31d970989179d038,
    0xac55af56fa03f900,0x38c13bc26e976d94,0xac55af56fa03f900,0x38c13bc26e976d94,
    0x3c04a898a49c300,0xdc1f955655961cdf,0x3c04a898a49c300,0xdc1f955655961cdf,
    0x71cbc97302b8ba00,0x3b9bb0170cac872,0x71cbc97302b8ba00,0x3b9bb0170cac872,
    0xcecdf6f53b380300,0x7a7942418f8cb7b4,0xcecdf6f53b380300,0x7a7942418f8cb7b4,
    0x85d9f7ab2e725c00,0x48143a66e3bf91cd,0x85d9f7ab2e725c00,0x48143a66e3bf91cd,
    0x7275313644430700,0x90e4a4d3f387c7b,0x7275313644430700,0x90e4a4d3f387c7b,
    0x8e1fef7ef0619100,0x3aab5bca44d525b4,0x8e1fef7ef0619100,0x3aab5bca44d525b4,
    0x11e28e7d6c9ff300,0xdd2e42b1a0533fcc,0x11e28e7d6c9ff300,0xdd2e42b1a0533fcc,
    0x933bcb63f058a800,0xd27a8a22b119e941,0x933bcb63f058a800,0xd27a8a22b119e941,
    0x2c00012d012d2c00,0xf0dcddf1ddf1f0dc,0x2c00012d012d2c00,0xf0dcddf1ddf1f0dc,
    0x469033e5a375d600,0xd701a27432e44791,0x469033e5a375d600,0xd701a27432e44791,
    0x5237fb9ecca96500,0x1f7ab6d381e4284d,0x5237fb9ecca96500,0x1f7ab6d381e4284d,
    0x7e7f3c3d43420100,0x8180c3c2bcbdfeff,0x7e7f3c3d43420100,0x8180c3c2bcbdfeff,
    0x68688f8fe7e70000,0xe7e7000068688f8f,0x68688f8fe7e70000,0xe7e7000068688f8f,
    0x2211d8ebc9fa3300,0xddee27143605ccff,0x2211d8ebc9fa3300,0xddee27143605ccff,
    0x4e4e8484caca0000,0xf2f238387676bcbc,0x4e4e8484caca0000,0xf2f238387676bcbc,
    0x543dbad387ee6900,0xd3ba3d540069ee87,0x543dbad387ee6900,0xd3ba3d540069ee87,
    0xcccc1212dede0000,0x1b1bc5c50909d7d7,0xcccc1212dede0000,0x1b1bc5c50909d7d7,
    0xac45719834dde900,0x678eba53ff1622cb,0xac45719834dde900,0x678eba53ff1622cb,
    0x4b4b030348480000,0xfdfdb5b5fefeb6b6,0x4b4b030348480000,0xfdfdb5b5fefeb6b6,
    0x4e1d21723c6f5300,0x580b37642a794516,0x4e1d21723c6f5300,0x580b37642a794516,
    0x8a8a1e1e94940000,0xeaea7e7ef4f46060,0x8a8a1e1e94940000,0xeaea7e7ef4f46060,
    0xa1a8a5ac0d040900,0x8f868b82232a272e,0xa1a8a5ac0d040900,0x8f868b82232a272e,
    0xf9f9b7b74e4e0000,0xe4e4aaaa53531d1d,0xf9f9b7b74e4e0000,0xe4e4aaaa53531d1d,
    0xcbeecce922072500,0x8bae8ca962476540,0xcbeecce922072500,0x8bae8ca962476540,
    0xd5d53434e1e10000,0x606e7e73232d3d3,0xd5d53434e1e10000,0x606e7e73232d3d3,
    0x1897d8574fc08f00,0x36b9f67961eea12e,0x1897d8574fc08f00,0x36b9f67961eea12e,
    0x4949dede97970000,0xf8f86f6f2626b1b1,0x4949dede97970000,0xf8f86f6f2626b1b1,
    0x34e3f72014c3d700,0x35e2f62115c2d601,0x34e3f72014c3d700,0x35e2f62115c2d601,
    0x23f2e13112c3d00,0x576a7b4644796855,0x23f2e13112c3d00,0x576a7b4644796855,
    0x9a92424ad0d80800,0x6e66b6be242cfcf4,0x9a92424ad0d80800,0x6e66b6be242cfcf4,
    0x7874c9c5bdb10c00,0xe3ef525e262a979b,0x7874c9c5bdb10c00,0xe3ef525e262a979b,
    0x1083a93a2ab99300,0x891a30a3b3200a99,0x1083a93a2ab99300,0x891a30a3b3200a99,
    0xa4aa5d53f7f90e00,0x737d8a84202ed9d7,0xa4aa5d53f7f90e00,0x737d8a84202ed9d7,
    0x8cd5540d81d85900,0x851d089055cdd84,0x8cd5540d81d85900,0x851d089055cdd84,
    0x4047060141460700,0x4542030444430205,0x4047060141460700,0x4542030444430205,
    0x4fa4be551af1eb00,0x2ac1db307f948e65,0x4fa4be551af1eb00,0x2ac1db307f948e65,
    0xdded3303deee3000,0xdded3303deee3000,0xdded3303deee3000,0xdded3303deee3000,
    0x90a85868f8c0300,0x2122adaea7a42b28,0x90a85868f8c0300,0x2122adaea7a42b28,
    0x901f3ab525aa8f00,0xa827028d1d92b738,0x901f3ab525aa8f00,0xa827028d1d92b738,
    0x4c12b4eaa6f85e00,0x5709aff1bde3451b,0x4c12b4eaa6f85e00,0x5709aff1bde3451b,
    0x7025e1b4c4915500,0x90c501542471b5e0,0x7025e1b4c4915500,0x90c501542471b5e0,
    0xc1b45227e6937500,0x4336d0a56411f782,0xc1b45227e6937500,0x4336d0a56411f782,
    0xfe1011ff01efee00,0x28c6c729d73938d6,0xfe1011ff01efee00,0x28c6c729d73938d6,
    0x8228ba109238aa00,0x7ad3f9517bd2f85,0x8228ba109238aa00,0x7ad3f9517bd2f85,
    0xb79b200cbb972c00,0x19358ea2153982ae,0xb79b200cbb972c00,0x19358ea2153982ae,
    0x6fa25b96f934cd00,0x458871bcd31ee72a,0x6fa25b96f934cd00,0x458871bcd31ee72a,
    0x21e2c40726e5c300,0xf13214d7f63513d0,0x21e2c40726e5c300,0xf13214d7f63513d0,
    0x8c8aded854520600,0xdbdd898f03055157,0x8c8aded854520600,0xdbdd898f03055157,
    0x6e190d7a14637700,0x92e5f186e89f8bfc,0x6e190d7a14637700,0x92e5f186e89f8bfc,
    0x4fdd099bd4469200,0x168450c28d1fcb59,0x4fdd099bd4469200,0x168450c28d1fcb59,
    0xec7e92927eec00,0x5db123cfcf23b15d,0xec7e92927eec00,0x5db123cfcf23b15d,
    0x7e10177907696e00,0xe08e89e799f7f09e,0x7e10177907696e00,0xe08e89e799f7f09e,
    0xbb5dd2348f69e600,0xcb2da244ff199670,0xbb5dd2348f69e600,0xcb2da244ff199670,
    0x87f62151d6a7700,0x88ffe2959deaf780,0x87f62151d6a7700,0x88ffe2959deaf780,
    0x791cb9dca5c06500,0x5e3b9efb82e74227,0x791cb9dca5c06500,0x5e3b9efb82e74227,
    0x87b3a39710243400,0xa49080b433071723,0x87b3a39710243400,0xa49080b433071723,
    0xde2ec737e919f000,0x6f9f768658a841b1,0xde2ec737e919f000,0x6f9f768658a841b1,
    0x5ab74dadf71ae00,0x228c53fdf8568927,0x5ab74dadf71ae00,0x228c53fdf8568927,
    0xbb832018a39b3800,0x84bc1f279ca4073f,0xbb832018a39b3800,0x84bc1f279ca4073f,
    0xb0f8b2fa4a024800,0x84cc86ce7e367c34,0xb0f8b2fa4a024800,0x84cc86ce7e367c34,
    0x6f1e42335c2d7100,0xc0b1ed9cf382deaf,0x6f1e42335c2d7100,0xc0b1ed9cf382deaf,
    0x7a8ea0542edaf400,0xcd3917e3996d43b7,0x7a8ea0542edaf400,0xcd3917e3996d43b7,
    0x7f33175b24684c00,0x3d715519662a0e42,0x7f33175b24684c00,0x3d715519662a0e42,
    0xf7c41221d6e53300,0x8dbe685bac9f497a,0xf7c41221d6e53300,0x8dbe685bac9f497a,
    0x4fbbf4f4bb4f00,0xffb0440b0b44b0ff,0x4fbbf4f4bb4f00,0xffb0440b0b44b0ff,
    0x8405f170f4758100,0xd455a120a425d150,0x8405f170f4758100,0xd455a120a425d150,
    0xb240a85ae81af200,0x699b738133c129db,0xb240a85ae81af200,0x699b738133c129db,
    0xdead5724fa897300,0x592ad0a37d0ef487,0xdead5724fa897300,0x592ad0a37d0ef487,
    0x68201c543c744800,0x723a064e266e521a,0x68201c543c744800,0x723a064e266e521a,
    0x219acb7051eabb00,0x9b2071caeb5001ba,0x219acb7051eabb00,0x9b2071caeb5001ba,
    0x80b75562e2d53700,0x536486b13106e4d3,0x80b75562e2d53700,0x536486b13106e4d3,
    0x6d91f9056894fc00,0x6995fd016c90f804,0x6d91f9056894fc00,0x6995fd016c90f804,
    0x5cb17895c924ed00,0x668b42aff31ed73a,0x5cb17895c924ed00,0x668b42aff31ed73a,
    0x5a4f55451f0a100,0x1abbea4b4eefbe1f,0x5a4f55451f0a100,0x1abbea4b4eefbe1f,
    0x32bcaa2416988e00,0x73fdeb6557d9cf41,0x32bcaa2416988e00,0x73fdeb6557d9cf41,
    0xda3d44a3799ee700,0x43a4dd3ae0077e99,0xda3d44a3799ee700,0x43a4dd3ae0077e99,
    0xf9d25b7089a22b00,0x6e45cce71e35bc97,0xf9d25b7089a22b00,0x6e45cce71e35bc97,
    0x67c341e58226a400,0xe94dcf6b0ca82a8e,0x67c341e58226a400,0xe94dcf6b0ca82a8e,
    0xdbae7b0ed5a07500,0x205580f52e5b8efb,0xdbae7b0ed5a07500,0x205580f52e5b8efb,
    0x5d8528f8a57dd00,0x24f973aeab76fc21,0x5d8528f8a57dd00,0x24f973aeab76fc21,
    0xac027cd27ed0ae00,0xea0de70dc720ca2,0xac027cd27ed0ae00,0xea0de70dc720ca2,
    0x1c90da564ac68c00,0x911d57dbc74b018d,0x1c90da564ac68c00,0x911d57dbc74b018d,
    0xc04c5ad6169a8c00,0x1a96800ccc4056da,0xc04c5ad6169a8c00,0x1a96800ccc4056da,
    0xfadf2c09f3d62500,0x3411e2c73d18ebce,0xfadf2c09f3d62500,0x3411e2c73d18ebce,
    0xcf77e35b942cb800,0xb901952de25ace76,0xcf77e35b942cb800,0xb901952de25ace76,
    0xf46a9806f26c9e00,0x31af5dc337a95bc5,0xf46a9806f26c9e00,0x31af5dc337a95bc5,
    0xf0fee9e717190e00,0xb4baada3535d4a44,0xf0fee9e717190e00,0xb4baada3535d4a44,
    0x845b06d95d82df00,0xf12e73ac28f7aa75,0x845b06d95d82df00,0xf12e73ac28f7aa75,
    0x2b745b042f705f00,0xda85aaf5de81aef1,0x2b745b042f705f00,0xda85aaf5de81aef1,
    0x2f65561c33794a00,0x713b08426d27145e,0x2f65561c33794a00,0x713b08426d27145e,
    0x21f25586a774d300,0x33e04794b566c112,0x21f25586a774d300,0x33e04794b566c112,
    0xb3d27d1cafce6100,0xe0812e4ffc9d3253,0xb3d27d1cafce6100,0xe0812e4ffc9d3253,
    0x11fc34d9c825ed00,0xa74a826f7e935bb6,0x11fc34d9c825ed00,0xa74a826f7e935bb6,
    0x596d77431a2e3400,0x3f0b11257c485266,0x596d77431a2e3400,0x3f0b11257c485266,
    0x5c7f684b17342300,0x1c3f280b57746340,0x5c7f684b17342300,0x1c3f280b57746340,
    0xfee4b5af514b1a00,0x554f1e04fae0b1ab,0xfee4b5af514b1a00,0x554f1e04fae0b1ab,
    0x573c7a11462d6b00,0x5932741f4823650e,0x573c7a11462d6b00,0x5932741f4823650e,
    0x624e476b09252c00,0xe222b076549406c,0x624e476b09252c00,0xe222b076549406c,
    0xf58f6e14e19b7a00,0x2258b9c3364cadd7,0xf58f6e14e19b7a00,0x2258b9c3364cadd7,
    0x24e65a98bc7ec200,0x75b70bc9ed2f9351,0x24e65a98bc7ec200,0x75b70bc9ed2f9351,
    0xafb4445ff0eb1b00,0x8c97677cd3c83823,0xafb4445ff0eb1b00,0x8c97677cd3c83823,
    0xd2277f8a58adf500,0xe81d45b06297cf3a,0xd2277f8a58adf500,0xe81d45b06297cf3a,
    0xdef1b39c426d2f00,0x113e7c538da2e0cf,0xdef1b39c426d2f00,0x113e7c538da2e0cf,
    0x99667d821be4ff00,0xce312ad54cb3a857,0x99667d821be4ff00,0xce312ad54cb3a857,
    0xc62dfe15d338eb00,0x5eb5668d4ba07398,0xc62dfe15d338eb00,0x5eb5668d4ba07398,
    0xfbe60d1de6fb100,0x3e8f51e0ef5e8031,0xfbe60d1de6fb100,0x3e8f51e0ef5e8031,
    0x63d544f29127b600,0x3b52492f147d660,0x63d544f29127b600,0x3b52492f147d660,
    0x2ce728e3cf04cb00,0xaf64ab604c874883,0x2ce728e3cf04cb00,0xaf64ab604c874883,
    0xefda7a4fa0953500,0x8bbe1e2bc4f15164,0xefda7a4fa0953500,0x8bbe1e2bc4f15164,
    0x160f435a4c551900,0x3128647d6b723e27,0x160f435a4c551900,0x3128647d6b723e27,
    0x6ef775ec821b9900,0xcf56d44d23ba38a1,0x6ef775ec821b9900,0xcf56d44d23ba38a1,
    0xde0f11c11fced00,0xa74a5bb6bb5647aa,0xde0f11c11fced00,0xa74a5bb6bb5647aa,
    0xdb953f71aae44e00,0x82cc6628f3bd1759,0xdb953f71aae44e00,0x82cc6628f3bd1759,
    0xf42b37e81cc3df00,0xd30c10cf3be4f827,0xf42b37e81cc3df00,0xd30c10cf3be4f827,
    0x7c51c6eb97ba2d00,0x406dfad7ab86113c,0x7c51c6eb97ba2d00,0x406dfad7ab86113c,
    0x1c39ffdac6e32500,0x604583a6ba9f597c,0x1c39ffdac6e32500,0x604583a6ba9f597c,
    0x8ef7126be59c7900,0xfb82671e90e90c75,0x8ef7126be59c7900,0xfb82671e90e90c75,
    0xffafaafa05555000,0xfcaca9f906565303,0xffafaafa05555000,0xfcaca9f906565303,
    0x3f041b2b142f300,0xcf3c8d7e7d8e3fcc,0x3f041b2b142f300,0xcf3c8d7e7d8e3fcc,
    0x9f4aa277e83dd500,0x1fca22f768bd5580,0x9f4aa277e83dd500,0x1fca22f768bd5580,
    0x6b01b6dcb7dd6a00,0x244ef993f892254f,0x6b01b6dcb7dd6a00,0x244ef993f892254f,
    0x76f9da5523ac8f00,0xaa250689ff7053dc,0x76f9da5523ac8f00,0xaa250689ff7053dc,
    0x166bf78a9ce17d00,0x7d009ce1f78a166b,0x166bf78a9ce17d00,0x7d009ce1f78a166b,
    0x30e6e33505d3d600,0x78aeab7d4d9b9e48,0x30e6e33505d3d600,0x78aeab7d4d9b9e48,
    0x20b2a03212809200,0xa93b29bb9b091b89,0x20b2a03212809200,0xa93b29bb9b091b89,
    0xf3aff6aa59055c00,0x570b520efda1f8a4,0xf3aff6aa59055c00,0x570b520efda1f8a4,
    0xfba60c51aaf75d00,0xb5e8421fe4b9134e,0xfba60c51aaf75d00,0xb5e8421fe4b9134e,
    0xa3628849ea2bc100,0xa0618b4ae928c203,0xa3628849ea2bc100,0xa0618b4ae928c203,
    0xd1fc2d00d1fc2d00,0xcee3321fcee3321f,0xd1fc2d00d1fc2d00,0xcee3321fcee3321f,
    0x4d00a5e8a5e84d00,0xb46e3aee3ae0b46,0x4d00a5e8a5e84d00,0xb46e3aee3ae0b46,
    0x8647dc1d9b5ac100,0xa465fe3fb978e322,0x8647dc1d9b5ac100,0xa465fe3fb978e322,
    0xb9bd84843d39000,0x2dbdfe6e65f5b626,0xb9bd84843d39000,0x2dbdfe6e65f5b626,
    0x82ab577efcd52900,0x5a738fa6240df1d8,0x82ab577efcd52900,0x5a738fa6240df1d8,
    0xb1f9246cdd954800,0x18508dc5743ce1a9,0xb1f9246cdd954800,0x18508dc5743ce1a9,
    0x5697814117d6c00,0xed8190fcf99584e8,0x5697814117d6c00,0xed8190fcf99584e8,
    0x2249e78caec56b00,0x660da3c8ea812f44,0x2249e78caec56b00,0x660da3c8ea812f44,
    0x93f0610291f26300,0xe6851477e4871675,0x93f0610291f26300,0xe6851477e4871675,
    0x4a84c8064c82ce00,0x65abe72963ade12f,0x4a84c8064c82ce00,0x65abe72963ade12f,
    0x8670ce38be48f600,0x7f8937c147b10ff9,0x8670ce38be48f600,0x7f8937c147b10ff9,
    0xbfd2cea31c716d00,0x6e031f72cda0bcd1,0xbfd2cea31c716d00,0x6e031f72cda0bcd1,
    0x89167be46df29f00,0xd74825ba33acc15e,0x89167be46df29f00,0xd74825ba33acc15e,
    0x6b3d2472194f5600,0xe7b1a8fe95c3da8c,0x6b3d2472194f5600,0xe7b1a8fe95c3da8c,
    0x80ce80ce4e004e00,0x501e501e9ed09ed0,0x80ce80ce4e004e00,0x501e501e9ed09ed0,
    0x5ac31089d34a9900,0x77ee3da4fe67b42d,0x5ac31089d34a9900,0x77ee3da4fe67b42d,
    0x775398bccbef2400,0x2b0fc4e097b3785c,0x775398bccbef2400,0x2b0fc4e097b3785c,
    0xa7f21742e5b05500,0x5104e1b41346a3f6,0xa7f21742e5b05500,0x5104e1b41346a3f6,
    0xceb2fc8c423e700,0x29ce0aede106c225,0xceb2fc8c423e700,0x29ce0aede106c225,
    0x67ffe57d1a829800,0x56ced44c2bb3a931,0x67ffe57d1a829800,0x56ced44c2bb3a931,
    0xb42767f440d39300,0x59ca8a19ad3e7eed,0xb42767f440d39300,0x59ca8a19ad3e7eed,
    0x4f612d034c622e00,0xd3fdb19fd0feb29c,0x4f612d034c622e00,0xd3fdb19fd0feb29c,
    0x9750c90e995ec700,0xf433aa6dfa3da463,0x9750c90e995ec700,0xf433aa6dfa3da463,
    0x645ffbc0a49f3b00,0xd0eb4f74102b8fb4,0x645ffbc0a49f3b00,0xd0eb4f74102b8fb4,
    0x931b951d8e068800,0xd850b831098169e,0x931b951d8e068800,0xd850b831098169e,
    0x7e50a28cf2dc2e00,0xf2dc2e007e50a28c,0x7e50a28cf2dc2e00,0xf2dc2e007e50a28c,
    0xa3548671d225f700,0x2cdb09fe5daa788f,0xa3548671d225f700,0x2cdb09fe5daa788f,
    0x1d41184459055c00,0xc29ec79b86da83df,0x1d41184459055c00,0xc29ec79b86da83df,
    0x7ace1ca8d266b400,0xa511c3770db96bdf,0x7ace1ca8d266b400,0xa511c3770db96bdf,
    0x392d697d44501400,0x8c98dcc8f1e5a1b5,0x392d697d44501400,0x8c98dcc8f1e5a1b5,
    0x6b74554a213e1f00,0x9a85a4bbd0cfeef1,0x6b74554a213e1f00,0x9a85a4bbd0cfeef1,
    0xd0eb073cecd73b00,0xbd866a5181ba566d,0xd0eb073cecd73b00,0xbd866a5181ba566d,
    0xb44c25dd6991f800,0x1ee68f77c33b52aa,0xb44c25dd6991f800,0x1ee68f77c33b52aa,
    0xe65a338f69d5bc00,0x942841fd1ba7ce72,0xe65a338f69d5bc00,0x942841fd1ba7ce72,
    0xe32c8f40a36ccf00,0xa966c50ae926854a,0xe32c8f40a36ccf00,0xa966c50ae926854a,
    0x1fa2813c239ebd00,0x84391aa7b805269b,0x1fa2813c239ebd00,0x84391aa7b805269b,
    0x83ddfca2217f5e00,0xffa180de5d03227c,0x83ddfca2217f5e00,0xffa180de5d03227c,
    0x486c0521694d2400,0x76523b1f57731a3e,0x486c0521694d2400,0x76523b1f57731a3e,
    0xb37b3af24189c800,0xc20a4b8330f8b971,0xb37b3af24189c800,0xc20a4b8330f8b971,
    0xd5a0205580f57500,0x2055d5a0750080f5,0xd5a0205580f57500,0x2055d5a0750080f5,
    0xebef84806b6f0400,0xeeea81856e6a0105,0xebef84806b6f0400,0xeeea81856e6a0105,
    0xef2033fc13dccf00,0xcf0013dc33fcef20,0xef2033fc13dccf00,0xcf0013dc33fcef20,
    0x3f983493ac0ba700,0xac0ba7003f983493,0x3f983493ac0ba700,0xac0ba7003f983493,
    0x29483c5d74156100,0xd0b1c5a48dec98f9,0x29483c5d74156100,0xd0b1c5a48dec98f9,
    0xfbc34b7388b03800,0xf8c048708bb33b03,0xfbc34b7388b03800,0xf8c048708bb33b03,
    0x86d8b6e86e305e00,0x732d431d9bc5abf5,0x86d8b6e86e305e00,0x732d431d9bc5abf5,
    0x6626014127674000,0xc484a3e385c5e2a2,0x6626014127674000,0xc484a3e385c5e2a2,
    0x37cea0596e97f900,0x6b92fc0532cba55c,0x37cea0596e97f900,0x6b92fc0532cba55c,
    0x1bbc73d4cf68a700,0xff5897302b8c43e4,0x1bbc73d4cf68a700,0xff5897302b8c43e4,
    0x3ca6e27844de9a00,0xf95d14b77eda933,0x3ca6e27844de9a00,0xf95d14b77eda933,
    0x1da2e25d40ffbf00,0xdc63239c813e7ec1,0x1da2e25d40ffbf00,0xdc63239c813e7ec1,
    0x3ebcde5c62e08200,0x47c5a7251b99fb79,0x3ebcde5c62e08200,0x47c5a7251b99fb79,
    0x6110cbbadbaa7100,0xbbca11600170abda,0x6110cbbadbaa7100,0xbbca11600170abda,
    0x53fead0d5ef3a00,0xbe84516b6e5481bb,0x53fead0d5ef3a00,0xbe84516b6e5481bb,
    0x5ac17fe4be259b00,0x33a8168dd74cf269,0x5ac17fe4be259b00,0x33a8168dd74cf269,
    0x873ec47dfa43b900,0x62db21981fa65ce5,0x873ec47dfa43b900,0x62db21981fa65ce5,
    0xad2b4fc964e28600,0xc14723a5088eea6c,0xad2b4fc964e28600,0xc14723a5088eea6c,
    0xdda5ceb66b137800,0x463e552df088e39b,0xdda5ceb66b137800,0x463e552df088e39b,
    0x5c349ef6aac26800,0x1a72d8b0ec842e46,0x5c349ef6aac26800,0x1a72d8b0ec842e46,
    0xca96e3bf75295c00,0x4a16633ff5a9dc80,0xca96e3bf75295c00,0x4a16633ff5a9dc80,
    0xc26ecc6cae02a00,0x3319d3f9f5df153f,0xc26ecc6cae02a00,0x3319d3f9f5df153f,
    0xf9d55e728ba72c00,0xc5e9624eb79b103c,0xf9d55e728ba72c00,0xc5e9624eb79b103c,
    0x42bdd12e6c93ff00,0xe31c708fcd325ea1,0x42bdd12e6c93ff00,0xe31c708fcd325ea1,
    0xb594ba9b2e0f2100,0x31103e1faa8ba584,0xb594ba9b2e0f2100,0x31103e1faa8ba584,
    0xfd6b3bad50c69600,0xc9aca5ca13767f1,0xfd6b3bad50c69600,0xc9aca5ca13767f1,
    0xe3a77034d7934400,0xade93e7a99dd0a4e,0xe3a77034d7934400,0xade93e7a99dd0a4e,
    0x48763709417f3e00,0x3d03427c340a4b75,0x48763709417f3e00,0x3d03427c340a4b75,
    0x2228c8c2e0ea0a00,0x868c6c66444eaea4,0x2228c8c2e0ea0a00,0x868c6c66444eaea4,
    0x9cfff4970b686300,0x23404b28b4d7dcbf,0x9cfff4970b686300,0x23404b28b4d7dcbf,
    0xdc65ef568a33b900,0xe75ed46db108823b,0xdc65ef568a33b900,0xe75ed46db108823b,
    0x3867e7b880df5f00,0x732cacf3cb94144b,0x3867e7b880df5f00,0x732cacf3cb94144b,
    0x963f7fd640e9a900,0x359cdc75e34a0aa3,0x963f7fd640e9a900,0x359cdc75e34a0aa3,
    0x31b58f0b3abe8400,0xdf5b61e5d4506aee,0x31b58f0b3abe8400,0xdf5b61e5d4506aee,
    0xea316fb45e85db00,0xa8732df61cc79942,0xea316fb45e85db00,0xa8732df61cc79942,
    0xb5b54949fcfc0000,0x747488883d3dc1c1,0xb5b54949fcfc0000,0x747488883d3dc1c1,
    0x43d2910142d3900,0xedd4c0f9fdc4d0e9,0x43d2910142d3900,0xedd4c0f9fdc4d0e9,
    0xb31ea508bb16ad00,0x76db60cd7ed368c5,0xb31ea508bb16ad00,0x76db60cd7ed368c5,
    0xf6822e5aacd87400,0x1460ccb84e3a96e2,0xf6822e5aacd87400,0x1460ccb84e3a96e2,
    0xa78ae9c4634e2d00,0xe8c5a68b2c01624f,0xa78ae9c4634e2d00,0xe8c5a68b2c01624f,
    0x1dabcf7964d2b600,0xfd4b2f99843256e0,0x1dabcf7964d2b600,0xfd4b2f99843256e0,
    0xa315e452f147b600,0x259362d477c13086,0xa315e452f147b600,0x259362d477c13086,
    0x81d27320a1f25300,0x491abbe8693a9bc8,0x81d27320a1f25300,0x491abbe8693a9bc8,
    0xe7268b4aad6cc100,0x21e04d8c6baa07c6,0xe7268b4aad6cc100,0x21e04d8c6baa07c6,
    0x5a4e44540e1a100,0x2786c66762c38322,0x5a4e44540e1a100,0x2786c66762c38322,
    0x5d98b6732eebc500,0xe32608cd90557bbe,0x5d98b6732eebc500,0xe32608cd90557bbe,
    0x91943732a3a60500,0xc4c16267f6f35055,0x91943732a3a60500,0xc4c16267f6f35055,
    0x3e9008a69836ae00,0x5cf26ac4fa54cc62,0x3e9008a69836ae00,0x5cf26ac4fa54cc62,
    0x1f94d9524dc68b00,0xe9622fa4bb307df6,0x1f94d9524dc68b00,0xe9622fa4bb307df6,
    0xedbb1640adfb5600,0x194fe2b4590fa2f4,0xedbb1640adfb5600,0x194fe2b4590fa2f4,
    0x1836745a426c2e00,0xfed092bca48ac8e6,0x1836745a426c2e00,0xfed092bca48ac8e6,
    0xb7110dab1cbaa600,0x5ef8e442f5534fe9,0xb7110dab1cbaa600,0x5ef8e442f5534fe9,
    0x6347c2e685a12400,0xc8ec694d2e0a8fab,0x6347c2e685a12400,0xc8ec694d2e0a8fab,
    0xf3d59fb94a6c2600,0x89afe5c330165c7a,0xf3d59fb94a6c2600,0x89afe5c330165c7a,
    0xa5053c9c3999a000,0x4dedd474d17148e8,0xa5053c9c3999a000,0x4dedd474d17148e8,
    0xef21f43ad51bce00,0xc50bde10ff31e42a,0xef21f43ad51bce00,0xc50bde10ff31e42a,
    0x6263626301000100,0x585958593b3a3b3a,0x6263626301000100,0x585958593b3a3b3a,
    0xf9e4c6db223f1d00,0x1f02203dc4d9fbe6,0xf9e4c6db223f1d00,0x1f02203dc4d9fbe6,
    0xfe067f877981f800,0x1ae29b639d651ce4,0xfe067f877981f800,0x1ae29b639d651ce4,
    0xfb35e22cd719ce00,0xee20f739c20cdb15,0xfb35e22cd719ce00,0xee20f739c20cdb15,
    0xd262da6ab808b000,0x95259d2dff4ff747,0xd262da6ab808b000,0x95259d2dff4ff747,
    0x53c031a2f1629300,0xac3fce5d0e9d6cff,0x53c031a2f1629300,0xac3fce5d0e9d6cff,
    0x5b7bfede85a52000,0x86a623035878fddd,0x5b7bfede85a52000,0x86a623035878fddd,
    0xf9d43518e1cc2d00,0x8fa2436e97ba5b76,0xf9d43518e1cc2d00,0x8fa2436e97ba5b76,
    0x4edc63f1bf2d9200,0x68fa45d7990bb426,0x4edc63f1bf2d9200,0x68fa45d7990bb426,
    0xc964973af35ead00,0x45e81bb67fd2218c,0xc964973af35ead00,0x45e81bb67fd2218c,
    0x6f3d21731c4e5200,0x2f7d61335c0e1240,0x6f3d21731c4e5200,0x2f7d61335c0e1240,
    0x101df7faeae70d00,0x68658f82929f7578,0x101df7faeae70d00,0x68658f82929f7578,
    0x24aaa6280c828e00,0xa9272ba5810f038d,0x24aaa6280c828e00,0xa9272ba5810f038d,
    0xb34652a714e1f500,0x8d786c992adfcb3e,0xb34652a714e1f500,0x8d786c992adfcb3e,
    0x72bb8f4634fdc900,0x3af3c70e7cb58148,0x72bb8f4634fdc900,0x3af3c70e7cb58148,
    0xdff4361dc2e92b00,0xdbf03219c6ed2f04,0xdff4361dc2e92b00,0xdbf03219c6ed2f04,
    0x17e81ee1f609ff00,0x4db244bbac53a55a,0x17e81ee1f609ff00,0x4db244bbac53a55a,
    0xe3492e8467cdaa00,0xc66c0ba142e88f25,0xe3492e8467cdaa00,0xc66c0ba142e88f25,
    0xb062bd6fdf0dd200,0x13c11ecc7cae71a3,0xb062bd6fdf0dd200,0x13c11ecc7cae71a3,
    0xdbb1e68c573d6a00,0x6c06513be08addb7,0xdbb1e68c573d6a00,0x6c06513be08addb7,
    0x754797a5d0e23200,0x586aba88fdcf1f2d,0x754797a5d0e23200,0x586aba88fdcf1f2d,
    0xd5273cce1be9f200,0x83716a984dbfa456,0xd5273cce1be9f200,0x83716a984dbfa456,
    0xa522e767c245800,0x277f035b5109752d,0xa522e767c245800,0x277f035b5109752d,
    0xf302c938cb3af100,0xe415de2fdc2de617,0xf302c938cb3af100,0xe415de2fdc2de617,
    0x7a61d4cfb5ae1b00,0x869d28334952e7fc,0x7a61d4cfb5ae1b00,0x869d28334952e7fc,
    0x9b98797ae1e20300,0x5655b4b72c2fcecd,0x9b98797ae1e20300,0x5655b4b72c2fcecd,
    0x6601462147206700,0x6a0d4a2d4b2c6b0c,0x6601462147206700,0x6a0d4a2d4b2c6b0c,
    0x2e3668705e461800,0x140c524a647c223a,0x2e3668705e461800,0x140c524a647c223a,
    0x3223213002131100,0xeafbf9e8dacbc9d8,0x3223213002131100,0xeafbf9e8dacbc9d8,
    0x617a233859421b00,0x1c075e45243f667d,0x617a233859421b00,0x1c075e45243f667d,
    0x582df085dda87500,0xd1a4790c5421fc89,0x582df085dda87500,0xd1a4790c5421fc89,
    0xce8c3c7eb0f24200,0xf5b707458bc9793b,0xce8c3c7eb0f24200,0xf5b707458bc9793b,
    0x79743d3049440d00,0x808dc4c9b0bdf4f9,0x79743d3049440d00,0x808dc4c9b0bdf4f9,
    0x787edcdaa2a40600,0x5452f0f68e882a2c,0x787edcdaa2a40600,0x5452f0f68e882a2c,
    0xe427e427c300c300,0x93509350b477b477,0xe427e427c300c300,0x93509350b477b477,
    0xe1ab2d6786cc4a00,0xb9f3753fde941258,0xe1ab2d6786cc4a00,0xb9f3753fde941258,
    0x5b63d3ebb0883800,0xad95251d467ecef6,0x5b63d3ebb0883800,0xad95251d467ecef6,
    0xa6aebfb711190800,0x9b93828a2c24353d,0xa6aebfb711190800,0x9b93828a2c24353d,
    0xa84c28cc6480e400,0x42a6c2268e6a0eea,0xa84c28cc6480e400,0x42a6c2268e6a0eea,
    0xfd2827f20fdad500,0xa4717eab56838c59,0xfd2827f20fdad500,0xa4717eab56838c59,
    0xcb68f7549f3ca300,0x5dfe61c209aa3596,0xcb68f7549f3ca300,0x5dfe61c209aa3596,
    0x91fbb8d243296a00,0x9cf6b5df4e24670d,0x91fbb8d243296a00,0x9cf6b5df4e24670d,
    0x89da1546cf9c5300,0x7526e9ba3360affc,0x89da1546cf9c5300,0x7526e9ba3360affc,
    0xe6b22d799fcb5400,0xaafe6135d387184c,0xe6b22d799fcb5400,0xaafe6135d387184c,
    0xd5587dfd28a5800,0xf6ae7c242971a3fb,0xd5587dfd28a5800,0xf6ae7c242971a3fb,
    };


    alignas(32) const uint64_t i_beta_mul_64_bm4r_ext_8[2 * 128 * 4 * 2] = {
    0xb8b96a6bd3d20100,0x3e3feced55548786,0xb8b96a6bd3d20100,0x3e3feced55548786,
    0x80a06e4eceee2000,0x4d6da3830323edcd,0x80a06e4eceee2000,0x4d6da3830323edcd,
    0x8484a3a327270000,0xc1c1e6e662624545,0x8484a3a327270000,0xc1c1e6e662624545,
    0x34bf20ab9f148b00,0xf279e66d59d24dc6,0x34bf20ab9f148b00,0xf279e66d59d24dc6,
    0xe0e0cfcf2f2f0000,0x9595baba5a5a7575,0xe0e0cfcf2f2f0000,0x9595baba5a5a7575,
    0xbaf4420cb6f84e00,0x6f2197d9632d9bd5,0xbaf4420cb6f84e00,0x6f2197d9632d9bd5,
    0x9f9f5b5bc4c40000,0x606c2c25d5d9999,0x9f9f5b5bc4c40000,0x606c2c25d5d9999,
    0xc7a2e48146236500,0x82e7a1c403662045,0xc7a2e48146236500,0x82e7a1c403662045,
    0x606434345450000,0x2e2e6b6b6d6d2828,0x606434345450000,0x2e2e6b6b6d6d2828,
    0x5560182d784d3500,0xcbfe86b3e6d3ab9e,0x5560182d784d3500,0xcbfe86b3e6d3ab9e,
    0x48482e2e66660000,0x6767010149492f2f,0x48482e2e66660000,0x6767010149492f2f,
    0x286fd592bafd4700,0xbff842052d6ad097,0x286fd592bafd4700,0xbff842052d6ad097,
    0xc2c23434f6f60000,0x3d3dcbcb0909ffff,0xc2c23434f6f60000,0x3d3dcbcb0909ffff,
    0xc822d03af218ea00,0x4ca654be769c6e84,0xc822d03af218ea00,0x4ca654be769c6e84,
    0x3939d5d5ecec0000,0x66668a8ab3b35f5f,0x3939d5d5ecec0000,0x66668a8ab3b35f5f,
    0x1b858a140f919e00,0x6ff1fe607be5ea74,0x1b858a140f919e00,0x6ff1fe607be5ea74,
    0x7809f687ff8e7100,0xccbd42334b3ac5b4,0x7809f687ff8e7100,0xccbd42334b3ac5b4,
    0xa38f96ba19352c00,0x79554c60c3eff6da,0xa38f96ba19352c00,0x79554c60c3eff6da,
    0x434b2f27646c0800,0xcfc7a3abe8e0848c,0x434b2f27646c0800,0xcfc7a3abe8e0848c,
    0x5d0359075a045e00,0x1648124c114f154b,0x5d0359075a045e00,0x1648124c114f154b,
    0xd1df5e50818f0e00,0x4a44c5cb1a14959b,0xd1df5e50818f0e00,0x4a44c5cb1a14959b,
    0xacdfcab915667300,0x344752218dfeeb98,0xacdfcab915667300,0x344752218dfeeb98,
    0xaf3a15802fba9500,0x1a8fa0359a0f20b5,0xaf3a15802fba9500,0x1a8fa0359a0f20b5,
    0x9531d074e145a400,0x54f011b5208465c1,0x9531d074e145a400,0x54f011b5208465c1,
    0xbe1813b50bada600,0xa50308ae10b6bd1b,0xbe1813b50bada600,0xa50308ae10b6bd1b,
    0x5fd3d9550a868c00,0xbe3238b4eb676de1,0x5fd3d9550a868c00,0xbe3238b4eb676de1,
    0xacd1f58824597d00,0x304d6914b8c5e19c,0xacd1f58824597d00,0x304d6914b8c5e19c,
    0xfd6903976afe9400,0x72e68c18e5711b8f,0xfd6903976afe9400,0x72e68c18e5711b8f,
    0x8e6437dd53b9ea00,0xfe5b65cd2386b81,0x8e6437dd53b9ea00,0xfe5b65cd2386b81,
    0xe52cb970955cc900,0x1fd6438a6fa633fa,0xe52cb970955cc900,0x1fd6438a6fa633fa,
    0x17ad82382f95ba00,0x6cd6f94354eec17b,0x17ad82382f95ba00,0x6cd6f94354eec17b,
    0x30b3cb4878fb8300,0x3ebdc54676f58d0e,0x30b3cb4878fb8300,0x3ebdc54676f58d0e,
    0xc16d0fa362ceac00,0x16bad874b5197bd7,0xc16d0fa362ceac00,0x16bad874b5197bd7,
    0xbfab998d32261400,0xf1b293d8296a4b0,0xbfab998d32261400,0xf1b293d8296a4b0,
    0xc2f02113d1e33200,0xdbe9380ac8fa2b19,0xc2f02113d1e33200,0xdbe9380ac8fa2b19,
    0x5d04fba2ffa65900,0x154cb3eab7ee1148,0x5d04fba2ffa65900,0x154cb3eab7ee1148,
    0xdff8c5e23d1a2700,0x3c1b2601def9c4e3,0xdff8c5e23d1a2700,0x3c1b2601def9c4e3,
    0xbda7e2f8455f1a00,0x455f1a00bda7e2f8,0xbda7e2f8455f1a00,0x455f1a00bda7e2f8,
    0xe632ca1ef82cd400,0x29fd05d137e31bcf,0xe632ca1ef82cd400,0x29fd05d137e31bcf,
    0xe916b04fa659ff00,0x7c8325da33cc6a95,0xe916b04fa659ff00,0x7c8325da33cc6a95,
    0xf4a6ce9c683a5200,0x2270184abeec84d6,0xf4a6ce9c683a5200,0x2270184abeec84d6,
    0xc0b896ee2e567800,0x572f0179b9c1ef97,0xc0b896ee2e567800,0x572f0179b9c1ef97,
    0x2bb962f2d94b900,0x5ce5c87173cae75e,0x2bb962f2d94b900,0x5ce5c87173cae75e,
    0xee7055cb25bb9e00,0x5ec0e57b950b2eb0,0xee7055cb25bb9e00,0x5ec0e57b950b2eb0,
    0xee0a64846a8ee00,0x638dcb252bc5836d,0xee0a64846a8ee00,0x638dcb252bc5836d,
    0x2a483c5e74166200,0x593b4f2d07651173,0x2a483c5e74166200,0x593b4f2d07651173,
    0x49d02eb7fe679900,0x69f00e97de47b920,0x49d02eb7fe679900,0x69f00e97de47b920,
    0x9d978c861b110a00,0x8f859e9409031812,0x9d978c861b110a00,0x8f859e9409031812,
    0xe0d8073fdfe73800,0x6f5788b05068b78f,0xe0d8073fdfe73800,0x6f5788b05068b78f,
    0xe3219052b173c200,0xcd0fbe7c9f5dec2e,0xe3219052b173c200,0xcd0fbe7c9f5dec2e,
    0xf6b5c3837536400,0x593d0a6e61053256,0xf6b5c3837536400,0x593d0a6e61053256,
    0xd34abc25f66f9900,0x6bf2049d4ed721b8,0xd34abc25f66f9900,0x6bf2049d4ed721b8,
    0x8b55ad73f826de00,0x75ab538d06d820fe,0x8b55ad73f826de00,0x75ab538d06d820fe,
    0x4766d9f8bf9e2100,0xe9c8775611308fae,0x4766d9f8bf9e2100,0xe9c8775611308fae,
    0x3cfce2221edec000,0xa66678b884445a9a,0x3cfce2221edec000,0xa66678b884445a9a,
    0xfc51913cc06dad00,0x4de0208d71dc1cb1,0xfc51913cc06dad00,0x4de0208d71dc1cb1,
    0x876524c641a3e200,0xdf3d7c9e19fbba58,0x876524c641a3e200,0xdf3d7c9e19fbba58,
    0x4a8a985812d2c000,0x13d3c1014b8b9959,0x4a8a985812d2c000,0x13d3c1014b8b9959,
    0x5288449ecc16da00,0x23f935efbd67ab71,0x5288449ecc16da00,0x23f935efbd67ab71,
    0x4237126725507500,0x9eebcebbf98ca9dc,0x4237126725507500,0x9eebcebbf98ca9dc,
    0x3fe6954c73aad900,0x4f96e53c03daa970,0x3fe6954c73aad900,0x4f96e53c03daa970,
    0x47cfc64e09818800,0x24aca52d6ae2eb63,0x47cfc64e09818800,0x24aca52d6ae2eb63,
    0xb98b4476cffd3200,0xb587487ac3f13e0c,0xb98b4476cffd3200,0xb587487ac3f13e0c,
    0xe7b90e5eb9e7500,0xccb95227295cb7c2,0xe7b90e5eb9e7500,0xccb95227295cb7c2,
    0x3eff71b08e4fc100,0xe524aa6b55941adb,0x3eff71b08e4fc100,0xe524aa6b55941adb,
    0x476184a2e5c32600,0x99bf5a7c3b1df8de,0x476184a2e5c32600,0x99bf5a7c3b1df8de,
    0x63f89a0162f99b00,0x7ce7851e7de6841f,0x63f89a0162f99b00,0x7ce7851e7de6841f,
    0x4eba1de9a753f400,0x29dd7a8ec0349367,0x4eba1de9a753f400,0x29dd7a8ec0349367,
    0xe25fa914f64bbd00,0xec51a71af845b30e,0xe25fa914f64bbd00,0xec51a71af845b30e,
    0x52f72386d471a500,0x52f72386d471a500,0x52f72386d471a500,0x52f72386d471a500,
    0xf9c4023fc6fb3d00,0xa994526f96ab6d50,0xf9c4023fc6fb3d00,0xa994526f96ab6d50,
    0x925b25ec7eb7c900,0xea235d9406cfb178,0x925b25ec7eb7c900,0xea235d9406cfb178,
    0xbf963e17a8812900,0x755cf4dd624be3ca,0xbf963e17a8812900,0x755cf4dd624be3ca,
    0xe1b1baea0b5b5000,0x45151e4eaffff4a4,0xe1b1baea0b5b5000,0x45151e4eaffff4a4,
    0xaee791d8763f4900,0xa2eb9dd47a33450c,0xaee791d8763f4900,0xa2eb9dd47a33450c,
    0x17a511a3b406b200,0x17a511a3b406b200,0x17a511a3b406b200,0x17a511a3b406b200,
    0x2e6a9edaf4b04400,0xd59165210f4bbffb,0x2e6a9edaf4b04400,0xd59165210f4bbffb,
    0x87972e3eb9a91000,0x3a2a93830414adbd,0x87972e3eb9a91000,0x3a2a93830414adbd,
    0xe1bea0ff1e415f00,0xe4bba5fa1b445a05,0xe1bea0ff1e415f00,0xe4bba5fa1b445a05,
    0x689a7d8fe715f200,0x11e304f69e6c8b79,0x689a7d8fe715f200,0x11e304f69e6c8b79,
    0x4e20e48ac4aa6e00,0xc2ac68064826e28c,0x4e20e48ac4aa6e00,0xc2ac68064826e28c,
    0x91a40633a2973500,0xecd97b4edfea487d,0x91a40633a2973500,0xecd97b4edfea487d,
    0xe8e76b648c830f00,0xeee16d628a850906,0xe8e76b648c830f00,0xeee16d628a850906,
    0x462894fabcd26e00,0x8ce25e307618a4ca,0x462894fabcd26e00,0x8ce25e307618a4ca,
    0x5eddd0530d8e8300,0x82010c8fd1525fdc,0x5eddd0530d8e8300,0x82010c8fd1525fdc,
    0xbbba5e5fe4e50100,0xb0b15554efee0a0b,0xbbba5e5fe4e50100,0xb0b15554efee0a0b,
    0xff4363df209cbc00,0xbb7972bd46848f4,0xff4363df209cbc00,0xbb7972bd46848f4,
    0xe76235b057d28500,0x46c39411f67324a1,0xe76235b057d28500,0x46c39411f67324a1,
    0xfcd589a9557c200,0x589a0fcdc2009557,0xfcd589a9557c200,0x589a0fcdc2009557,
    0xda40cb518b119a00,0x4fd55ec41e840f95,0xda40cb518b119a00,0x4fd55ec41e840f95,
    0xeb7d17816afc9600,0xd84e24b259cfa533,0xeb7d17816afc9600,0xd84e24b259cfa533,
    0x86945e4ccad81200,0x1705cfdd5b498391,0x86945e4ccad81200,0x1705cfdd5b498391,
    0x496093baf3da2900,0x674ebd94ddf4072e,0x496093baf3da2900,0x674ebd94ddf4072e,
    0x43f8259edd66bb00,0x76cd10abe8538e35,0x43f8259edd66bb00,0x76cd10abe8538e35,
    0x82d6194dcf9b5400,0x5c08c79311458ade,0x82d6194dcf9b5400,0x5c08c79311458ade,
    0x2969195970304000,0xedaddd9db4f484c4,0x2969195970304000,0xedaddd9db4f484c4,
    0x886258b23ad0ea00,0x1ebd13bb3596389,0x886258b23ad0ea00,0x1ebd13bb3596389,
    0x2d15b888a59d300,0x13c04a999b48c211,0x2d15b888a59d300,0x13c04a999b48c211,
    0x28759fc2eab75d00,0xda876d301845aff2,0x28759fc2eab75d00,0xda876d301845aff2,
    0x88a8301098b82000,0x2c0c94b43c1c84a4,0x88a8301098b82000,0x2c0c94b43c1c84a4,
    0xa029008929a08900,0x73fad35afa735ad3,0xa029008929a08900,0x73fad35afa735ad3,
    0x6230ebb9db895200,0xa5f72c7e1c4e95c7,0x6230ebb9db895200,0xa5f72c7e1c4e95c7,
    0x4a76407c360a3c00,0xba86b08cc6faccf0,0x4a76407c360a3c00,0xba86b08cc6faccf0,
    0xf9d2ddf60f242b00,0xfad1def50c272803,0xf9d2ddf60f242b00,0xfad1def50c272803,
    0x4d4fd2d29f9d000,0xcdcf52521f1d808,0x4d4fd2d29f9d000,0xcdcf52521f1d808,
    0x82777c890bfef500,0x13e6ed189a6f6491,0x82777c890bfef500,0x13e6ed189a6f6491,
    0x135be8a0b3fb4800,0x99d1622a3971c28a,0x135be8a0b3fb4800,0x99d1622a3971c28a,
    0x35268a99acbf1300,0x5d4ee2f1c4d77b68,0x35268a99acbf1300,0x5d4ee2f1c4d77b68,
    0x881b74e76ffc9300,0x8f1c73e068fb9407,0x881b74e76ffc9300,0x8f1c73e068fb9407,
    0xb6acecf6405a1a00,0xf4eeaeb402185842,0xb6acecf6405a1a00,0xf4eeaeb402185842,
    0x1ad0559f854fca00,0x864cc90319d3569c,0x1ad0559f854fca00,0x864cc90319d3569c,
    0x632dc48ae9a74e00,0x9bd53c72115fb6f8,0x632dc48ae9a74e00,0x9bd53c72115fb6f8,
    0x6d0e4a2944276300,0x563571127f1c583b,0x6d0e4a2944276300,0x563571127f1c583b,
    0x5a2e24540e7a700,0x2b8ccc6b6ec9892e,0x5a2e24540e7a700,0x2b8ccc6b6ec9892e,
    0x9749fe2eb967d00,0x3e43a8d5dca14a37,0x9749fe2eb967d00,0x3e43a8d5dca14a37,
    0x42f53780c275b700,0x18af6dda982fed5a,0x42f53780c275b700,0x18af6dda982fed5a,
    0xef2dea28c705c200,0xa86aad6f80428547,0xef2dea28c705c200,0xa86aad6f80428547,
    0x884007cf478fc800,0x2ae2a56de52d6aa2,0x884007cf478fc800,0x2ae2a56de52d6aa2,
    0x959915198c800c00,0xbbb73b37a2ae222e,0x959915198c800c00,0xbbb73b37a2ae222e,
    0xf0209343b363d000,0xada69b949992afa,0xf0209343b363d000,0xada69b949992afa,
    0x5e9e90500ecec00,0xe90505e9ec0000ec,0x5e9e90500ecec00,0xe90505e9ec0000ec,
    0x9da5350d90a83800,0x774fdfe77a42d2ea,0x9da5350d90a83800,0x774fdfe77a42d2ea,
    0xf45f8328dc77ab00,0x2c875bf004af73d8,0xf45f8328dc77ab00,0x2c875bf004af73d8,
    0x40dd5ac7871a9d00,0x920f881555c84fd2,0x40dd5ac7871a9d00,0x920f881555c84fd2,
    0x35e7855762b0d200,0xcc1e7cae9b492bf9,0x35e7855762b0d200,0xcc1e7cae9b492bf9,
    0xd41beb24f03fcf00,0xae61915e8a45b57a,0xd41beb24f03fcf00,0xae61915e8a45b57a,
    0x424ce5eba9a70e00,0xb3bd141a5856fff1,0x424ce5eba9a70e00,0xb3bd141a5856fff1,
    0xa24630d47692e400,0xf612648022c6b054,0xa24630d47692e400,0xf612648022c6b054,
    0x24d033c7e317f400,0x20d437c3e713f004,0x24d033c7e317f400,0x20d437c3e713f004,
    0x39dad83b02e1e300,0x618280635ab9bb58,0x39dad83b02e1e300,0x618280635ab9bb58,
    0x79b4e12c5598cd00,0x74b9ec215895c00d,0x79b4e12c5598cd00,0x74b9ec215895c00d,
    0x35ddeb0336dee800,0xc62e18f0c52d1bf3,0x35ddeb0336dee800,0xc62e18f0c52d1bf3,
    0x6da45a93fe37c900,0x76bf4188e52cd21b,0x6da45a93fe37c900,0x76bf4188e52cd21b,
    0x7f0438433c477b00,0xa714d3649320e75,0x7f0438433c477b00,0xa714d3649320e75,
    0x6c85ee076b82e900,0x29c0ab422ec7ac45,0x6c85ee076b82e900,0x29c0ab422ec7ac45,
    0x977da74dda30ea00,0x3fd50fe5729842a8,0x977da74dda30ea00,0x3fd50fe5729842a8,
    0x7bcb08b8c373b000,0x6ddd1eaed565a616,0x7bcb08b8c373b000,0x6ddd1eaed565a616,
    0x8480cfcb4f4b0400,0xc4c08f8b0f0b4440,0x8480cfcb4f4b0400,0xc4c08f8b0f0b4440,
    0x3cea5a8cb066d600,0xe73181576bbd0ddb,0x3cea5a8cb066d600,0xe73181576bbd0ddb,
    0x23c5f61033d5e600,0xaf497a9cbf596a8c,0x23c5f61033d5e600,0xaf497a9cbf596a8c,
    0xd10ed40bda05df00,0xc21dc718c916cc13,0xd10ed40bda05df00,0xc21dc718c916cc13,
    0x3922cad1e8f31b00,0x2239d1caf3e8001b,0x3922cad1e8f31b00,0x2239d1caf3e8001b,
    0x71a2835322f1d00,0xa3be8c91968bb9a4,0x71a2835322f1d00,0xa3be8c91968bb9a4,
    0x7907403e47397e00,0xd0aee997ee90d7a9,0x7907403e47397e00,0xd0aee997ee90d7a9,
    0x6ba2ae670cc5c900,0x34fdf138539a965f,0x6ba2ae670cc5c900,0x34fdf138539a965f,
    0x34a18e1b2fba9500,0x42d7f86d59cce376,0x34a18e1b2fba9500,0x42d7f86d59cce376,
    0x36b6ba3a0c8c8000,0x47c7cb4b7dfdf171,0x36b6ba3a0c8c8000,0x47c7cb4b7dfdf171,
    0xa4d61b69cdbf7200,0x7d0fc2b01466abd9,0xa4d61b69cdbf7200,0x7d0fc2b01466abd9,
    0x83b92d1794ae3a00,0x9ea4300a89b3271d,0x83b92d1794ae3a00,0x9ea4300a89b3271d,
    0x6ecc8d2f41e3a200,0xa20041e38d2f6ecc,0x6ecc8d2f41e3a200,0xa20041e38d2f6ecc,
    0xf672fe7a8c088400,0x5ade52d620a428ac,0xf672fe7a8c088400,0x5ade52d620a428ac,
    0xc7785fe02798bf00,0x229dba05c27d5ae5,0xc7785fe02798bf00,0x229dba05c27d5ae5,
    0xbccbadda66117700,0x33442255e99ef88f,0xbccbadda66117700,0x33442255e99ef88f,
    0xec23d817fb34cf00,0xb9768d42ae619a55,0xec23d817fb34cf00,0xb9768d42ae619a55,
    0xf0095aa353aaf900,0x20d98a73837a29d0,0xf0095aa353aaf900,0x20d98a73837a29d0,
    0xb25329c87a9be100,0x7190ea0bb95822c3,0xb25329c87a9be100,0x7190ea0bb95822c3,
    0x5a963ff3a965cc00,0x7cb62aef438915d,0x5a963ff3a965cc00,0x7cb62aef438915d,
    0xe6d57d4ea89b3300,0x15268ebd5b68c0f3,0xe6d57d4ea89b3300,0x15268ebd5b68c0f3,
    0xe4c02404e0c4200,0x67256b2927652b69,0xe4c02404e0c4200,0x67256b2927652b69,
    0x9ef81177e98f6600,0xa2c42d4bd5b35a3c,0x9ef81177e98f6600,0xa2c42d4bd5b35a3c,
    0x21628fccedae4300,0x682bc685a4e70a49,0x21628fccedae4300,0x682bc685a4e70a49,
    0x97a399ad3a0e3400,0xdaeed4e07743794d,0x97a399ad3a0e3400,0xdaeed4e07743794d,
    0x3147f385b4c27600,0xd4a21660512793e5,0x3147f385b4c27600,0xd4a21660512793e5,
    0xf86d45d028bd9500,0x93062ebb43d6fe6b,0xf86d45d028bd9500,0x93062ebb43d6fe6b,
    0xa8f392c9613a5b00,0xb8e382d9712a4b10,0xa8f392c9613a5b00,0xb8e382d9712a4b10,
    0x7cf854d0ac288400,0xb135991d61e549cd,0x7cf854d0ac288400,0xb135991d61e549cd,
    0x95b8ad8015382d00,0xfed3c6eb7e53466b,0x95b8ad8015382d00,0xfed3c6eb7e53466b,
    0xac9f88bb17243300,0xbc8f98ab07342310,0xac9f88bb17243300,0xbc8f98ab07342310,
    0xe30920ca29c3ea00,0xec062fc526cce50f,0xe30920ca29c3ea00,0xec062fc526cce50f,
    0xf3d1f5d724062200,0x33113517e4c6e2c0,0xf3d1f5d724062200,0x33113517e4c6e2c0,
    0xc5ab523cf9976e00,0x9af40d63a6c8315f,0xc5ab523cf9976e00,0x9af40d63a6c8315f,
    0x3c5c84e4d8b86000,0x3e5e86e6daba6202,0x3c5c84e4d8b86000,0x3e5e86e6daba6202,
    0xe0207cbc5c9cc000,0xe92975b55595c909,0xe0207cbc5c9cc000,0xe92975b55595c909,
    0xc3a5355390f66600,0xf89e0e68abcd5d3b,0xc3a5355390f66600,0xf89e0e68abcd5d3b,
    0x92ab5168fac33900,0x3b02f8c1536a90a9,0x92ab5168fac33900,0x3b02f8c1536a90a9,
    0xb7014cfa4dfbb600,0x15a3ee58ef5914a2,0xb7014cfa4dfbb600,0x15a3ee58ef5914a2,
    0xf268ab31c3599a00,0xab31f2689a00c359,0xf268ab31c3599a00,0xab31f2689a00c359,
    0xe17f76e809979e00,0xb72920be5fc1c856,0xe17f76e809979e00,0xb72920be5fc1c856,
    0x3f76f9b08fc64900,0xfdb43b724d048bc2,0x3f76f9b08fc64900,0xfdb43b724d048bc2,
    0x31289c85b4ad1900,0xa8b1051c2d348099,0x31289c85b4ad1900,0xa8b1051c2d348099,
    0xa75e3bc2659cf900,0x6e97f20bac5530c9,0xa75e3bc2659cf900,0x6e97f20bac5530c9,
    0x222c414f6d630e00,0x6b650806242a4749,0x222c414f6d630e00,0x6b650806242a4749,
    0x52deb23e6ce08c00,0x800c60ecbe325ed2,0x52deb23e6ce08c00,0x800c60ecbe325ed2,
    0x414cfcf1b0bd0d00,0xeae7575a1b16a6ab,0x414cfcf1b0bd0d00,0xeae7575a1b16a6ab,
    0x8bb589b73c023e00,0x19271b25ae90ac92,0x8bb589b73c023e00,0x19271b25ae90ac92,
    0x764a9cacdae6300,0x566abc8cfac6102,0x764a9cacdae6300,0x566abc8cfac6102,
    0x81bdab97162a3c00,0x201c0a36b78b9da1,0x81bdab97162a3c00,0x201c0a36b78b9da1,
    0x8a3d992ea413b700,0x6add79ce44f357e0,0x8a3d992ea413b700,0x6add79ce44f357e0,
    0xbab43c3288860e00,0xfaf47c72c8c64e40,0xbab43c3288860e00,0xfaf47c72c8c64e40,
    0x33917edcef4da200,0x1ebc53f1c2608f2d,0x33917edcef4da200,0x1ebc53f1c2608f2d,
    0x29efdc1a33f5c600,0x4482b1775e98ab6d,0x29efdc1a33f5c600,0x4482b1775e98ab6d,
    0xe17e0e9170ef9f00,0x3da2d24dac3343dc,0xe17e0e9170ef9f00,0x3da2d24dac3343dc,
    0xa7bbffe344581c00,0xd2ce8a96312d6975,0xa7bbffe344581c00,0xd2ce8a96312d6975,
    0x1ca004b8a418bc00,0xbf03a71b07bb1fa3,0x1ca004b8a418bc00,0xbf03a71b07bb1fa3,
    0x7e66948cf2ea1800,0x948c7e661800f2ea,0x7e66948cf2ea1800,0x948c7e661800f2ea,
    0x224ca2ccee806e00,0x355bb5dbf9977917,0x224ca2ccee806e00,0x355bb5dbf9977917,
    0x4c52405e120c1e00,0xb1afbda3eff1e3fd,0x4c52405e120c1e00,0xb1afbda3eff1e3fd,
    0x80ec563abad66c00,0xb8d46e0282ee5438,0x80ec563abad66c00,0xb8d46e0282ee5438,
    0xeeb3d588663b5d00,0x64395f02ecb1d78a,0xeeb3d588663b5d00,0x64395f02ecb1d78a,
    0x53dfb73b68e48c00,0x64e8800c5fd3bb37,0x53dfb73b68e48c00,0x64e8800c5fd3bb37,
    0xfc5059f509a5ac00,0x3a969f33cf636ac6,0xfc5059f509a5ac00,0x3a969f33cf636ac6,
    0xcbd02932f9e21b00,0x51ee7fc372cd5ce,0xcbd02932f9e21b00,0x51ee7fc372cd5ce,
    0x5ba640bde61bfd00,0x9a67817c27da3cc1,0x5ba640bde61bfd00,0x9a67817c27da3cc1,
    0x565d8d86d0db0b00,0x565d8d86d0db0b00,0x565d8d86d0db0b00,0x565d8d86d0db0b00,
    0x8696afbf39291000,0x4f5f6676f0e0d9c9,0x8696afbf39291000,0x4f5f6676f0e0d9c9,
    0x916fc33dac52fe00,0xe51bb749d8268a74,0x916fc33dac52fe00,0xe51bb749d8268a74,
    0x92d47a3caee84600,0xda9c3274e6a00e48,0x92d47a3caee84600,0xda9c3274e6a00e48,
    0x26e9549bbd72cf00,0x1ed16ca3854af738,0x26e9549bbd72cf00,0x1ed16ca3854af738,
    0x32cb27deec15f900,0xaa53bf46748d6198,0x32cb27deec15f900,0xaa53bf46748d6198,
    0xcdb3e39d502e7e00,0xe896c6b8750b5b25,0xcdb3e39d502e7e00,0xe896c6b8750b5b25,
    0xc999bded24745000,0x21715505cc9cb8e8,0xc999bded24745000,0x21715505cc9cb8e8,
    0x280c6b4f67432400,0x795d3a1e36127551,0x280c6b4f67432400,0x795d3a1e36127551,
    0xd0ca859f4f551a00,0xf155a40908ac5df,0xd0ca859f4f551a00,0xf155a40908ac5df,
    0x5167d6e0b1873600,0x94a213257442f3c5,0x5167d6e0b1873600,0x94a213257442f3c5,
    0x43defd6d2eb3900,0xe0d90b32360fdde4,0x43defd6d2eb3900,0xe0d90b32360fdde4,
    0x417f98a6e7d93e00,0x13fd8e6a7997e40,0x417f98a6e7d93e00,0x13fd8e6a7997e40,
    0x34e96eb3875add00,0x20fd7aa7934ec914,0x34e96eb3875add00,0x20fd7aa7934ec914,
    0xaaa2464ee4ec0800,0x535bbfb71d15f1f9,0xaaa2464ee4ec0800,0x535bbfb71d15f1f9,
    0xf2a07725d7855200,0x7022f5a75507d082,0xf2a07725d7855200,0x7022f5a75507d082,
    0x89b34b71f8c23a00,0x7e44bc860f35cdf7,0x89b34b71f8c23a00,0x7e44bc860f35cdf7,
    0x47b6e11057a6f100,0xe71641b0f70651a0,0x47b6e11057a6f100,0xe71641b0f70651a0,
    0x1bc7fe2239e5dc00,0xb76b528e954970ac,0x1bc7fe2239e5dc00,0xb76b528e954970ac,
    0x5488db07538fdc00,0xe23e6db1e5396ab6,0x5488db07538fdc00,0xe23e6db1e5396ab6,
    0xf22c588674aade00,0xd80672ac5e80f42a,0xf22c588674aade00,0xd80672ac5e80f42a,
    0x6e1ccdbfd1a37200,0x8cfe2f5d334190e2,0x6e1ccdbfd1a37200,0x8cfe2f5d334190e2,
    0xde2ac430ee1af400,0x2f618ec32c628dc,0xde2ac430ee1af400,0x2f618ec32c628dc,
    0x3a0b8bba80b13100,0xf4c545744e7fffce,0x3a0b8bba80b13100,0xf4c545744e7fffce,
    0x2cdb1cebc730f700,0x9265a255798e49be,0x2cdb1cebc730f700,0x9265a255798e49be,
    0x56141d5f094b4200,0xf6b4bdffa9ebe2a0,0x56141d5f094b4200,0xf6b4bdffa9ebe2a0,
    0xb7ac455ee9f21b00,0xe7fc150eb9a24b50,0xb7ac455ee9f21b00,0xe7fc150eb9a24b50,
    0x968ad8c4524e1c00,0x21e4c50c6da8894,0x968ad8c4524e1c00,0x21e4c50c6da8894,
    0x1ddacc0b16d1c700,0x2cebfd3a27e0f631,0x1ddacc0b16d1c700,0x2cebfd3a27e0f631,
    0x28539be0c8b37b00,0x99e22a517902cab1,0x28539be0c8b37b00,0x99e22a517902cab1,
    0xc38281c003424100,0x91d0d39251101352,0xc38281c003424100,0x91d0d39251101352,
    0x8681beb93f380700,0xbeb9868107003f38,0x8681beb93f380700,0xbeb9868107003f38,
    0xefd77b43ac943800,0x122a86be5169c5fd,0xefd77b43ac943800,0x122a86be5169c5fd,
    0x9ec67e26b8e05800,0x366ed68e1048f0a8,0x9ec67e26b8e05800,0x366ed68e1048f0a8,
    0x875fed35b26ad800,0x71a91bc3449c2ef6,0x875fed35b26ad800,0x71a91bc3449c2ef6,
    0x2bc23ad3f811e900,0x78916980ab42ba53,0x2bc23ad3f811e900,0x78916980ab42ba53,
    0x2211417250633300,0xf0c393a082b1e1d2,0x2211417250633300,0xf0c393a082b1e1d2,
    0x6966303f56590f00,0xefe0b6b9d0df8986,0x6966303f56590f00,0xefe0b6b9d0df8986,
    0x1d93850b16988e00,0x38d9b150886901e,0x1d93850b16988e00,0x38d9b150886901e,
    0x6b48b497fcdf2300,0x81a25e7d1635c9ea,0x6b48b497fcdf2300,0x81a25e7d1635c9ea,
    0x40094a03430a4900,0xde97d49ddd94d79e,0x40094a03430a4900,0xde97d49ddd94d79e,
    0x74019aef9bee7500,0x4b3ea5d0a4d14a3f,0x74019aef9bee7500,0x4b3ea5d0a4d14a3f,
    0x36691c43752a5f00,0x2f70055a6c334619,0x36691c43752a5f00,0x2f70055a6c334619,
    0xbba91507bcae1200,0xcfdd6173c8da6674,0xbba91507bcae1200,0xcfdd6173c8da6674,
    0x2980993910b9a00,0xa90019b99039208,0x2980993910b9a00,0xa90019b99039208,
    0xfc3bb0778b4cc700,0xac6be027db1c9750,0xfc3bb0778b4cc700,0xac6be027db1c9750,
    0x70ed1f82f26f9d00,0x118c7ee3930efc61,0x70ed1f82f26f9d00,0x118c7ee3930efc61,
    0x8c5ac7119d4bd600,0xeb3da076fa2cb167,0x8c5ac7119d4bd600,0xeb3da076fa2cb167,
    0x8a18fe6ce6749200,0x9a08ee7cf6648210,0x8a18fe6ce6749200,0x9a08ee7cf6648210,
    0xfa5b48e913b2a100,0x75d4c7669c3d2e8f,0xfa5b48e913b2a100,0x75d4c7669c3d2e8f,
    0x6d660d066b600b00,0xd066d660b006b60,0x6d660d066b600b00,0xd066d660b006b60,
    0xc5c16763a6a20400,0xa8ac0a0ecbcf696d,0xc5c16763a6a20400,0xa8ac0a0ecbcf696d,
    0x1b48f2a1bae95300,0x4112a8fbe0b3095a,0x1b48f2a1bae95300,0x4112a8fbe0b3095a,
    0xcaca47478d8d0000,0x5c5cd1d11b1b9696,0xcaca47478d8d0000,0x5c5cd1d11b1b9696,
    0x56ac83792fd5fa00,0x976d42b8ee143bc1,0x56ac83792fd5fa00,0x976d42b8ee143bc1,
    0x9f9febeb74740000,0x13136767f8f88c8c,0x9f9febeb74740000,0x13136767f8f88c8c,
    0x13dbfd3526eec800,0x5098be7665ad8b43,0x13dbfd3526eec800,0x5098be7665ad8b43,
    0x65659f9ffafa0000,0x5252a8a8cdcd3737,0x65659f9ffafa0000,0x5252a8a8cdcd3737,
    0x96bf8da4321b2900,0x153c0e27b198aa83,0x96bf8da4321b2900,0x153c0e27b198aa83,
    0xf1f10909f8f80000,0x5656aeae5f5fa7a7,0xf1f10909f8f80000,0x5656aeae5f5fa7a7,
    0xf4d29bbd496f2600,0x2246d4bbf99d0f6,0xf4d29bbd496f2600,0x2246d4bbf99d0f6,
    0x3d3d0a0a37370000,0xe7e7d0d0ededdada,0x3d3d0a0a37370000,0xe7e7d0d0ededdada,
    0x1e4a8bdfc1955400,0xf4a061352b7fbeea,0x1e4a8bdfc1955400,0xf4a061352b7fbeea,
    0x1e1e565648480000,0x4c4c04041a1a5252,0x1e1e565648480000,0x4c4c04041a1a5252,
    0x5fbe36d78869e100,0xf5149c7d22c34baa,0x5fbe36d78869e100,0xf5149c7d22c34baa,
    0x7373efef9c9c0000,0x8f8f13136060fcfc,0x7373efef9c9c0000,0x8f8f13136060fcfc,
    0x1fe840b7a85ff700,0x4f35bacb344ec1b,0x1fe840b7a85ff700,0x4f35bacb344ec1b,
    0x6666ddddbbbb0000,0x6969d2d2b4b40f0f,0x6666ddddbbbb0000,0x6969d2d2b4b40f0f,
    0x423fa1dc9ee37d00,0x5e23bdc082ff611c,0x423fa1dc9ee37d00,0x5e23bdc082ff611c,
    0xca4b1b9a50d18100,0x1c9dcd4c860757d6,0xca4b1b9a50d18100,0x1c9dcd4c860757d6,
    0xba8993a3192a300,0xb81b2a89822110b3,0xba8993a3192a300,0xb81b2a89822110b3,
    0xa5ce99f2573c6b00,0xa8c394ff5a31660d,0xa5ce99f2573c6b00,0xa8c394ff5a31660d,
    0xab2831b2199a8300,0x5fdcc546ed6e77f4,0xab2831b2199a8300,0x5fdcc546ed6e77f4,
    0xf607a958ae5ff100,0xc83997669061cf3e,0xf607a958ae5ff100,0xc83997669061cf3e,
    0xa531fa6ecb5f9400,0x9b0fc450f561aa3e,0xa531fa6ecb5f9400,0x9b0fc450f561aa3e,
    0x7f39afe996d04600,0x9cda4c0a7533a5e3,0x7f39afe996d04600,0x9cda4c0a7533a5e3,
    0x7d1588e09df56800,0x86ee731b660e93fb,0x7d1588e09df56800,0x86ee731b660e93fb,
    0x52013f6c3e6d5300,0xaffcc291c390aefd,0x52013f6c3e6d5300,0xaffcc291c390aefd,
    0x488c79bdf531c400,0xdf1bee2a62a65397,0x488c79bdf531c400,0xdf1bee2a62a65397,
    0xd7a77303d4a47000,0xd2a27606d1a17505,0xd7a77303d4a47000,0xd2a27606d1a17505,
    0xb7ff7e3681c94800,0x145cdd95226aeba3,0xb7ff7e3681c94800,0x145cdd95226aeba3,
    0x6399c03a59a3fa00,0xd72d748eed174eb4,0x6399c03a59a3fa00,0xd72d748eed174eb4,
    0xd7ceb1a87f661900,0xf1e8978e59403f26,0xd7ceb1a87f661900,0xf1e8978e59403f26,
    0x5f3e98f9a6c76100,0x86e741207f1eb8d9,0x5f3e98f9a6c76100,0x86e741207f1eb8d9,
    0xcc31af529e63fd00,0x6c910ff23ec35da0,0xcc31af529e63fd00,0x6c910ff23ec35da0,
    0xe6a1b3f412554700,0xabecfeb95f180a4d,0xe6a1b3f412554700,0xabecfeb95f180a4d,
    0x37012f192e183600,0x6157794f784e6056,0x37012f192e183600,0x6157794f784e6056,
    0x286eca8ca4e24600,0x4600a4e2ca8c286e,0x286eca8ca4e24600,0x4600a4e2ca8c286e,
    0xca68f2509a38a200,0x8e2cb614de7ce644,0xca68f2509a38a200,0x8e2cb614de7ce644,
    0x5db2ee015cb3ef00,0xbc530fe0bd520ee1,0x5db2ee015cb3ef00,0xbc530fe0bd520ee1,
    0xf92f00d62ff9d600,0x15c3ec3ac3153aec,0xf92f00d62ff9d600,0x15c3ec3ac3153aec,
    0xb25147a416f5e300,0xf41701e250b3a546,0xb25147a416f5e300,0xf41701e250b3a546,
    0x9dbd22029fbf2000,0xad8d1232af8f1030,0x9dbd22029fbf2000,0xad8d1232af8f1030,
    0x4ce911b4f85da500,0x3f9a62c78b2ed673,0x4ce911b4f85da500,0x3f9a62c78b2ed673,
    0xf9ca6556af9c3300,0xc6f55a6990a30c3f,0xf9ca6556af9c3300,0xc6f55a6990a30c3f,
    0x4e9865b3fd2bd600,0xc412ef3977a15c8a,0x4e9865b3fd2bd600,0xc412ef3977a15c8a,
    0x4677625315243100,0xf0c1d4e5a39287b6,0x4677625315243100,0xf0c1d4e5a39287b6,
    0x2e601d537d334e00,0x86c8b5fbd59be6a8,0x2e601d537d334e00,0x86c8b5fbd59be6a8,
    0x44c455d591118000,0x890998185cdc4dcd,0x44c455d591118000,0x890998185cdc4dcd,
    0x3e1d6447795a2300,0x9ab9c0e3ddfe87a4,0x3e1d6447795a2300,0x9ab9c0e3ddfe87a4,
    0x2167561031774600,0x442733514526325,0x2167561031774600,0x442733514526325,
    0xf371078576f48200,0xe8cfa788b097ffd,0xf371078576f48200,0xe8cfa788b097ffd,
    0xa719912f8836be00,0x843ab20cab159d23,0xa719912f8836be00,0x843ab20cab159d23,
    0x89c5115dd4984c00,0xb5f92d61e8a4703c,0x89c5115dd4984c00,0xb5f92d61e8a4703c,
    0x50cce47828b49c00,0xd44860fcac301884,0x50cce47828b49c00,0xd44860fcac301884,
    0xa1b1869637271000,0xefffc8d879695e4e,0xa1b1869637271000,0xefffc8d879695e4e,
    0x1f3b391d02262400,0x4c686a4e51757753,0x1f3b391d02262400,0x4c686a4e51757753,
    0x3237fbfeccc90500,0xbcb9757042478b8e,0x3237fbfeccc90500,0xbcb9757042478b8e,
    0x6077d7c7a7b0100,0x2d2c565751502a2b,0x6077d7c7a7b0100,0x2d2c565751502a2b,
    0x2e268f87a9a10800,0xfff75e567870d9d1,0x2e268f87a9a10800,0xfff75e567870d9d1,
    0x73212e7c0f5d5200,0x72202f7d0e5c5301,0x73212e7c0f5d5200,0x72202f7d0e5c5301,
    0x458d38f0b57dc800,0x9951e42c69a114dc,0x458d38f0b57dc800,0x9951e42c69a114dc,
    0x7b0bc7b7ccbc7000,0x373bfcfb4c40878,0x7b0bc7b7ccbc7000,0x373bfcfb4c40878,
    0x4b148fdf94cb500,0x299c65d0d461982d,0x4b148fdf94cb500,0x299c65d0d461982d,
    0xd591145481c5400,0xfbafe7b3beeaa2f6,0xd591145481c5400,0xfbafe7b3beeaa2f6,
    0xc32aa34a8960e900,0xc32aa34a8960e900,0xc32aa34a8960e900,0xc32aa34a8960e900,
    0x235ab6cfec957900,0x4b32dea784fd1168,0x235ab6cfec957900,0x4b32dea784fd1168,
    0xe30eb558bb56ed00,0x43ae15f81bf64da0,0xe30eb558bb56ed00,0x43ae15f81bf64da0,
    0x5ddffa7825a78200,0xf67451d38e0c29ab,0x5ddffa7825a78200,0xf67451d38e0c29ab,
    0x9b96dad74c410d00,0xd004c41dad79b96,0x9b96dad74c410d00,0xd004c41dad79b96,
    0xf0965432c2a46600,0x4e28ea8c7c1ad8be,0xf0965432c2a46600,0x4e28ea8c7c1ad8be,
    0xfcb5b1f8044d4900,0x95dcd8916d242069,0xfcb5b1f8044d4900,0x95dcd8916d242069,
    0x5d24ef96cbb27900,0xa8d11a633e478cf5,0x5d24ef96cbb27900,0xa8d11a633e478cf5,
    0xfae6839f65791c00,0x504c2935cfd3b6aa,0xfae6839f65791c00,0x504c2935cfd3b6aa,
    0xab0ef257fc59a500,0x4aef13b61db844e1,0xab0ef257fc59a500,0x4aef13b61db844e1,
    0x12bd3f90822daf00,0xe946c46b79d654fb,0x12bd3f90822daf00,0xe946c46b79d654fb,
    0x4dbe23d39e6df00,0xf62910cfcb142df2,0x4dbe23d39e6df00,0xf62910cfcb142df2,
    0xe3abb8f81b53400,0x6d59d8ece2d65763,0xe3abb8f81b53400,0x6d59d8ece2d65763,
    0xeaf6f9e50f131c00,0x839f908c667a7569,0xeaf6f9e50f131c00,0x839f908c667a7569,
    0xe171f06081119000,0x4ada5bcb2aba3bab,0xe171f06081119000,0x4ada5bcb2aba3bab,
    0x9d95838b161e0800,0x848c9a920f071119,0x9d95838b161e0800,0x848c9a920f071119,
    0xbc5e24c67a98e200,0xd4364cae12f08a68,0xbc5e24c67a98e200,0xd4364cae12f08a68,
    0x2e7833654b1d5600,0x30662d7b5503481e,0x2e7833654b1d5600,0x30662d7b5503481e,
    0xf9e1e0f801191800,0xa9b1b0a851494850,0xf9e1e0f801191800,0xa9b1b0a851494850,
    0x6177b6a6c7d1100,0xeffe92838594f8e9,0x6177b6a6c7d1100,0xeffe92838594f8e9,
    0x6bf9a93b50c29200,0x8c1e4edcb72575e7,0x6bf9a93b50c29200,0x8c1e4edcb72575e7,
    0x7ed997304ee9a700,0x3b9cd2750bace245,0x7ed997304ee9a700,0x3b9cd2750bace245,
    0x58bf1bfca443e700,0x9f78dc3b638420c7,0x58bf1bfca443e700,0x9f78dc3b638420c7,
    0x13ea34cdde27f900,0xfd04da2330c917ee,0x13ea34cdde27f900,0xfd04da2330c917ee,
    0xd2eba39a48713900,0xa198d0e93b024a73,0xd2eba39a48713900,0xa198d0e93b024a73,
    0xd3a284f526577100,0xb0c1e79645341263,0xd3a284f526577100,0xb0c1e79645341263,
    0x891e05921b8c9700,0x83140f9811869d0a,0x891e05921b8c9700,0x83140f9811869d0a,
    0x1fa33c809f23bc00,0xb30f902c338f10ac,0x1fa33c809f23bc00,0xb30f902c338f10ac,
    0x2542cbac89ee6700,0x166ef88adca4324,0x2542cbac89ee6700,0x166ef88adca4324,
    0x15342b0a1f3e2100,0x86a7b8998cadb293,0x15342b0a1f3e2100,0x86a7b8998cadb293,
    0x32d05bb98b69e200,0xfc1e957745a72cce,0x32d05bb98b69e200,0xfc1e957745a72cce,
    0xed3ffc2ec311d200,0x2bf93ae805d714c6,0xed3ffc2ec311d200,0x2bf93ae805d714c6,
    0x5b3f64643f5b00,0xf2a9cd9696cda9f2,0x5b3f64643f5b00,0xf2a9cd9696cda9f2,
    0xb18885bc0d343900,0x774e437acbf2ffc6,0xb18885bc0d343900,0x774e437acbf2ffc6,
    0x7a1f41245e3b6500,0x9affa1c4bedb85e0,0x7a1f41245e3b6500,0x9affa1c4bedb85e0,
    0x11aa0db6a71cbb00,0x2893348f9e258239,0x11aa0db6a71cbb00,0x2893348f9e258239,
    0x2defad6f4280c200,0xc90b498ba66426e4,0x2defad6f4280c200,0xc90b498ba66426e4,
    0x5e51fdf2aca30f00,0x6768c4cb959a3639,0x5e51fdf2aca30f00,0x6768c4cb959a3639,
    0xded84b4d93950600,0x2721b2b46a6cfff9,0xded84b4d93950600,0x2721b2b46a6cfff9,
    0xad54c33a976ef900,0x1ce5728b26df48b1,0xad54c33a976ef900,0x1ce5728b26df48b1,
    0xb6f1d99e286f4700,0x82c5edaa1c5b7334,0xb6f1d99e286f4700,0x82c5edaa1c5b7334,
    0x3681cb7c4afdb700,0x3285cf784ef9b304,0x3681cb7c4afdb700,0x3285cf784ef9b304,
    0x9f3e51f06fcea100,0xa1006fce51f09f3e,0x9f3e51f06fcea100,0xa1006fce51f09f3e,
    0x9288a2b82a301a00,0x415b716bf9e3c9d3,0x9288a2b82a301a00,0x415b716bf9e3c9d3,
    0x7b072458235f7c00,0x770b28542f53700c,0x7b072458235f7c00,0x770b28542f53700c,
    0xd7da6e63b4b90d00,0x808d3934e3ee5a57,0xd7da6e63b4b90d00,0x808d3934e3ee5a57,
    0x2b9b40f0db6bb00,0xb40f02b9bb000db6,0x2b9b40f0db6bb00,0xb40f02b9bb000db6,
    0x32264b5f6d791400,0x1d09647042563b2f,0x32264b5f6d791400,0x1d09647042563b2f,
    0x8803cb4bc348800,0x2ba31f979f17ab23,0x8803cb4bc348800,0x2ba31f979f17ab23,
    0x58ea49fba311b200,0xa91bb80a52e043f1,0x58ea49fba311b200,0xa91bb80a52e043f1,
    0xb0698c55e53cd900,0x3fe603da6ab3568f,0xb0698c55e53cd900,0x3fe603da6ab3568f,
    0x2178376e4f165900,0xe7bef1a889d09fc6,0x2178376e4f165900,0xe7bef1a889d09fc6,
    0xb141a959e818f000,0xb848a050e111f909,0xb141a959e818f000,0xb848a050e111f909,
    0x5d951cd48941c800,0xd81099510cc44d85,0x5d951cd48941c800,0xd81099510cc44d85,
    0xa21d7dc260dfbf00,0x69d6b609ab1474cb,0xa21d7dc260dfbf00,0x69d6b609ab1474cb,
    0x23ba3ea7841d9900,0xac35b1280b92168f,0x23ba3ea7841d9900,0xac35b1280b92168f,
    0x56e9912e78c7bf00,0xeb1c976209fe758,0x56e9912e78c7bf00,0xeb1c976209fe758,
    0xc60ce228ee24ca00,0xe329c70dcb01ef25,0xc60ce228ee24ca00,0xe329c70dcb01ef25,
    0xef8a2d48a7c26500,0x97f25530dfba1d78,0xef8a2d48a7c26500,0x97f25530dfba1d78,
    0x46ab18f5b35eed00,0xa64bf81553be0de0,0x46ab18f5b35eed00,0xa64bf81553be0de0,
    0xe67f54cd2bb29900,0x930a21b85ec7ec75,0xe67f54cd2bb29900,0x930a21b85ec7ec75,
    0xf01cde32c22eec00,0x40ac6e82729e5cb0,0xf01cde32c22eec00,0x40ac6e82729e5cb0,
    0xd612cb0fd91dc400,0xdb1fc602d410c90d,0xd612cb0fd91dc400,0xdb1fc602d410c90d,
    0x885f69be36e1d700,0xaf784e9911c6f027,0x885f69be36e1d700,0xaf784e9911c6f027,
    0xa1b05544e5f41100,0x6b7a9f8e2f3edbca,0xa1b05544e5f41100,0x6b7a9f8e2f3edbca,
    0x3e126448765a2c00,0x8ba7d1fdc3ef99b5,0x3e126448765a2c00,0x8ba7d1fdc3ef99b5,
    0x4ebb1beea055f500,0xc03595602edb7b8e,0x4ebb1beea055f500,0xc03595602edb7b8e,
    0xcbfbaa9a51613000,0xae9ecfff34045565,0xcbfbaa9a51613000,0xae9ecfff34045565,
    0x6e970ff69861f900,0xe41d857c12eb738a,0x6e970ff69861f900,0xe41d857c12eb738a,
    0x94dbaae5713e4f00,0x216e1f50c48bfab5,0x94dbaae5713e4f00,0x216e1f50c48bfab5,
    0x2ad4be406a94fe00,0xbb452fd1fb056f91,0x2ad4be406a94fe00,0xbb452fd1fb056f91,
    0x84c7783bbffc4300,0x4003bcff7b3887c4,0x84c7783bbffc4300,0x4003bcff7b3887c4,
    0x508969b9e930d00,0x505dc3cecbc65855,0x508969b9e930d00,0x505dc3cecbc65855,
    0xe85a4ffd15a7b200,0xbf0d18aa42f0e557,0xe85a4ffd15a7b200,0xbf0d18aa42f0e557,
    0x16739df8ee8b6500,0xa8cd23465035dbbe,0x16739df8ee8b6500,0xa8cd23465035dbbe,
    0x175594d6c1834200,0x6f2decaeb9fb3a78,0x175594d6c1834200,0x6f2decaeb9fb3a78,
    0xee901f618ff17e00,0x5b25aad43a44cbb5,0xee901f618ff17e00,0x5b25aad43a44cbb5,
    0x98a65c62fac43e00,0x221ce6d8407e84ba,0x98a65c62fac43e00,0x221ce6d8407e84ba,
    0x10f32ac9d93ae300,0x4e73eddcd2ef714,0x10f32ac9d93ae300,0x4e73eddcd2ef714,
    0xd31123e132f0c200,0x69ab995b884a78ba,0xd31123e132f0c200,0x69ab995b884a78ba,
    0x695daa9ef7c33400,0xb28671452c18efdb,0x695daa9ef7c33400,0xb28671452c18efdb,
    0xffb5cf857a304a00,0xeea4de946b215b11,0xffb5cf857a304a00,0xeea4de946b215b11,
    0xfd08aa5fa257f500,0x9065c732cf3a986d,0xfd08aa5fa257f500,0x9065c732cf3a986d,
    0xce604be52b85ae00,0xd17f54fa349ab11f,0xce604be52b85ae00,0xd17f54fa349ab11f,
    0xd7ac6a11c6bd7b00,0x6813d5ae7902c4bf,0xd7ac6a11c6bd7b00,0x6813d5ae7902c4bf,
    0x9b4a66b72cfdd100,0x3cedc1108b5a76a7,0x9b4a66b72cfdd100,0x3cedc1108b5a76a7,
    0x98ab5261f9ca3300,0xdfec1526be8d7447,0x98ab5261f9ca3300,0xdfec1526be8d7447,
    0x2ce1bf725e93cd00,0xd71a4489a56836fb,0x2ce1bf725e93cd00,0xd71a4489a56836fb,
    0xb6adb4af19021b00,0xc5dec7dc6a716873,0xb6adb4af19021b00,0xc5dec7dc6a716873,
    0xa960935af33ac900,0x6ea7549d34fd0ec7,0xa960935af33ac900,0x6ea7549d34fd0ec7,
    0xe2a57e39db9c4700,0x8ccb1057b5f2296e,0xe2a57e39db9c4700,0x8ccb1057b5f2296e,
    0x357a9ad5e0af4f00,0x1956b6f9cc83632c,0x357a9ad5e0af4f00,0x1956b6f9cc83632c,
    0x2583832500a6a600,0xd37575d3f65050f6,0x2583832500a6a600,0xd37575d3f65050f6,
    0x6d646f660b020900,0xa6afa4adc0c9c2cb,0x6d646f660b020900,0xa6afa4adc0c9c2cb,
    0x8135c672f347b400,0xb105f642c3778430,0x8135c672f347b400,0xb105f642c3778430,
    0x4916c29dd48b5f00,0x5a05d18ec7984c13,0x4916c29dd48b5f00,0x5a05d18ec7984c13,
    0xa45cfb03a75ff800,0x52aa0df551a90ef6,0xa45cfb03a75ff800,0x52aa0df551a90ef6,
    0xcfefdafa35152000,0x14340121eecefbdb,0xcfefdafa35152000,0x14340121eecefbdb,
    0xce7c2a9856e4b200,0x7bc99f2de35107b5,0xce7c2a9856e4b200,0x7bc99f2de35107b5,
    0xf006e711e117f600,0x996f8e78887e9f69,0xf006e711e117f600,0x996f8e78887e9f69,
    0x520b94cd9fc65900,0xcd940b520059c69f,0x520b94cd9fc65900,0xcd940b520059c69f,
    0x534ca7b8ebf41f00,0x78678c93c0df342b,0x534ca7b8ebf41f00,0x78678c93c0df342b,
    0x7d668b90edf61b00,0x776c819ae7fc110a,0x7d668b90edf61b00,0x776c819ae7fc110a,
    0xf2dfcde0123f2d00,0x210c1e33c1ecfed3,0xf2dfcde0123f2d00,0x210c1e33c1ecfed3,
    0xfe0a5fab55a1f400,0x6c98cd39c7336692,0xfe0a5fab55a1f400,0x6c98cd39c7336692,
    0xb8b26c66ded40a00,0x707aa4ae161cc2c8,0xb8b26c66ded40a00,0x707aa4ae161cc2c8,
    0xcfde0e1fd0c11100,0xe5f42435faeb3b2a,0xcfde0e1fd0c11100,0xe5f42435faeb3b2a,
    0xa9947b46efd23d00,0x211cf3ce675ab588,0xa9947b46efd23d00,0x211cf3ce675ab588,
    0xd96be95b8230b200,0xb80a883ae351d361,0xd96be95b8230b200,0xb80a883ae351d361,
    0x707bdbd0a0ab0b00,0xbeb5151e6e65c5ce,0x707bdbd0a0ab0b00,0xbeb5151e6e65c5ce,
    0x9cef790a96e57300,0xd4a73142dead3b48,0x9cef790a96e57300,0xd4a73142dead3b48,
    0x9f065ec758c19900,0xd24b138a158cd44d,0x9f065ec758c19900,0xd24b138a158cd44d,
    0xfe8d2457a9da7300,0xe291384bb5c66f1c,0xfe8d2457a9da7300,0xe291384bb5c66f1c,
    0xd5ef0e34e1db3a00,0x251ffec4112bcaf0,0xd5ef0e34e1db3a00,0x251ffec4112bcaf0,
    0x97f61879ee8f6100,0x7e1ff190076688e9,0x97f61879ee8f6100,0x7e1ff190076688e9,
    0x4040040444440000,0xf3f3b7b7f7f7b3b3,0x4040040444440000,0xf3f3b7b7f7f7b3b3,
    0xa8a7333c949b0f00,0x1817838c242bbfb0,0xa8a7333c949b0f00,0x1817838c242bbfb0,
    0x50a34dbeee1df300,0x2cdf31c292618f7c,0x50a34dbeee1df300,0x2cdf31c292618f7c,
    0xaebb2c3997821500,0x4055c2d7796cfbee,0xaebb2c3997821500,0x4055c2d7796cfbee,
    0x1743d48493c7500,0x97e2abdedfaae396,0x1743d48493c7500,0x97e2abdedfaae396,
    0x9b983033a8ab0300,0x8a892122b9ba1211,0x9b983033a8ab0300,0x8a892122b9ba1211,
    0x442b026d29466f00,0x4629006f2b446d02,0x442b026d29466f00,0x4629006f2b446d02,
    0x2d96d06b46fdbb00,0x8c3771cae75c1aa1,0x2d96d06b46fdbb00,0x8c3771cae75c1aa1,
    0x765d466d1b302b00,0x84afb49fe9c2d9f2,0x765d466d1b302b00,0x84afb49fe9c2d9f2,
    0xecf94555b9ac100,0x80411adbd5144f8e,0xecf94555b9ac100,0x80411adbd5144f8e,
    0xbb354ece75fb800,0x348c6bd3d860873f,0xbb354ece75fb800,0x348c6bd3d860873f,
    0xec67840fe3688b00,0xf972911af67d9e15,0xec67840fe3688b00,0xf972911af67d9e15,
    0x611f522c4d337e00,0x84fab7c9a8d69be5,0x611f522c4d337e00,0x84fab7c9a8d69be5,
    0xf55079dc298ca500,0x49ecc560953019bc,0xf55079dc298ca500,0x49ecc560953019bc,
    0xe35845fe1da6bb00,0x10abb60dee5548f3,0xe35845fe1da6bb00,0x10abb60dee5548f3,
    0x11a408bdac19b500,0x6bde72c7d663cf7a,0x11a408bdac19b500,0x6bde72c7d663cf7a,
    0x3b612f754e145a00,0x9fc58bd1eab0fea4,0x3b612f754e145a00,0x9fc58bd1eab0fea4,
    0xf6ff8d84727b0900,0x373e4c45b3bac8c1,0xf6ff8d84727b0900,0x373e4c45b3bac8c1,
    0xa7339307a0349400,0x31a5059136a20296,0xa7339307a0349400,0x31a5059136a20296,
    0x601d7d00601d7d00,0x4f32522f4f32522f,0x601d7d00601d7d00,0x4f32522f4f32522f,
    0xb9d1593188e06800,0x5830b8d0690189e1,0xb9d1593188e06800,0x5830b8d0690189e1,
    0x9c7319f66a85ef00,0x937c16f9658ae00f,0x9c7319f66a85ef00,0x937c16f9658ae00f,
    0xb769ca14a37dde00,0x27f95a8433ed4e90,0xb769ca14a37dde00,0x27f95a8433ed4e90,
    0xc32134d615f7e200,0x9674618340a2b755,0xc32134d615f7e200,0x9674618340a2b755,
    0x4e6c6a4806242200,0x391b1d3f71535577,0x4e6c6a4806242200,0x391b1d3f71535577,
    0x68312f761e475900,0xb9e0fea7cf9688d1,0x68312f761e475900,0xb9e0fea7cf9688d1,
    0xd30571a774a2d600,0x9c4a3ee83bed994f,0xd30571a774a2d600,0x9c4a3ee83bed994f,
    0x8990dfc64f561900,0x7e672831b8a1eef7,0x8990dfc64f561900,0x7e672831b8a1eef7,
    0x2023a2a181820300,0xbfbc3d3e1e1d9c9f,0x2023a2a181820300,0xbfbc3d3e1e1d9c9f,
    0xe26956dd3fb48b00,0xac27189371fac54e,0xe26956dd3fb48b00,0xac27189371fac54e,
    0xd95f2ea871f78600,0x66e09117ce4839bf,0xd95f2ea871f78600,0x66e09117ce4839bf,
    0x159d76feeb638800,0x1d957ef6e36b8008,0x159d76feeb638800,0x1d957ef6e36b8008,
    0xebebc3c328280000,0x24240c0ce7e7cfcf,0xebebc3c328280000,0x24240c0ce7e7cfcf,
    0x95ba022db8972f00,0x3f10a887123d85aa,0x95ba022db8972f00,0x3f10a887123d85aa,
    0x4a53554c061f1900,0xd3caccd59f868099,0x4a53554c061f1900,0xd3caccd59f868099,
    0xebd3f6ce251d3800,0xb189ac947f47625a,0xebd3f6ce251d3800,0xb189ac947f47625a,
    0x7db9e92d5094c400,0xc1055591ec2878bc,0x7db9e92d5094c400,0xc1055591ec2878bc,
    0x6ac00aaac06aa00,0x4de74be1e74de14b,0x6ac00aaac06aa00,0x4de74be1e74de14b,
    0x37669fcef9a85100,0xd4857c2d1a4bb2e3,0x37669fcef9a85100,0xd4857c2d1a4bb2e3,
    0xd618c00ed816ce00,0x3af42ce234fa22ec,0xd618c00ed816ce00,0x3af42ce234fa22ec,
    0x22cd739cbe51ef00,0x9a75cb2406e957b8,0x22cd739cbe51ef00,0x9a75cb2406e957b8,
    0xa2b64652f0e41400,0x617585913327d7c3,0xa2b64652f0e41400,0x617585913327d7c3,
    0x3c0de1d1eddc300,0xb47769aaa96a74b7,0x3c0de1d1eddc300,0xb47769aaa96a74b7,
    0xaa771dcd67bad00,0x2c8157faf05d8b26,0xaa771dcd67bad00,0x2c8157faf05d8b26,
    0x870aa429ae238d00,0x61ec42cf48c56be6,0x870aa429ae238d00,0x61ec42cf48c56be6,
    0x5ae3b90953eab00,0xca61f45f5af164cf,0x5ae3b90953eab00,0xca61f45f5af164cf,
    0xbc215bc67ae79d00,0xf16c168b37aad04d,0xbc215bc67ae79d00,0xf16c168b37aad04d,
    0x4cd01b87cb579c00,0xc458930f43df1488,0x4cd01b87cb579c00,0xc458930f43df1488,
    0x7405651460117100,0xfd8cec9de998f889,0x7405651460117100,0xfd8cec9de998f889,
    0xf812d832ca20ea00,0x816ba14bb3599379,0xf812d832ca20ea00,0x816ba14bb3599379,
    0xdf7c53f02f8ca300,0xf55679da05a6892a,0xdf7c53f02f8ca300,0xf55679da05a6892a,
    0x16685e2036487e00,0x57b4d33255b6d13,0x16685e2036487e00,0x57b4d33255b6d13,
    0x4d24e78ec3aa6900,0x69aac38ee7244d,0x4d24e78ec3aa6900,0x69aac38ee7244d,
    0xf4853c4db9c87100,0x413089f80c7dc4b5,0xf4853c4db9c87100,0x413089f80c7dc4b5,
    0x237a451c3f665900,0xecb58ad3f0a996cf,0x237a451c3f665900,0xecb58ad3f0a996cf,
    0x5206b4e4b6e2500,0x83a6edc8cde8a386,0x5206b4e4b6e2500,0x83a6edc8cde8a386,
    0x434358581b1b0000,0xacacb7b7f4f4efef,0x434358581b1b0000,0xacacb7b7f4f4efef,
    0x2ccc9a7a56b6e000,0x907026c6ea0a5cbc,0x2ccc9a7a56b6e000,0x907026c6ea0a5cbc,
    0x5825a7da82ff7d00,0x88f5770a522fadd0,0x5825a7da82ff7d00,0x88f5770a522fadd0,
    0x26fb7da0865bdd00,0x7ea325f8de038558,0x26fb7da0865bdd00,0x7ea325f8de038558,
    0x133c002f3c132f00,0xecc3ffd0c3ecd0ff,0x133c002f3c132f00,0xecc3ffd0c3ecd0ff,
    0x8aa97556dcff2300,0xb695496ae0c31f3c,0x8aa97556dcff2300,0xb695496ae0c31f3c,
    0x7d067b0b760d700,0x7aad1acdca1daa7d,0x7d067b0b760d700,0x7aad1acdca1daa7d,
    0xb0c3e49727547300,0xc5b691e252210675,0xb0c3e49727547300,0xc5b691e252210675,
    0x420cc789cb854e00,0x622ce7a9eba56e20,0x420cc789cb854e00,0x622ce7a9eba56e20,
    0x4d3abbcc81f67700,0x5225a4d39ee9681f,0x4d3abbcc81f67700,0x5225a4d39ee9681f,
    0x5192e32071b2c300,0xbe7d0ccf9e5d2cef,0x5192e32071b2c300,0xbe7d0ccf9e5d2cef,
    0x3b7482cdf6b94f00,0xca85733c0748bef1,0x3b7482cdf6b94f00,0xca85733c0748bef1,
    0xfb451ca259e7be00,0xb00e57e912acf54b,0xfb451ca259e7be00,0xb00e57e912acf54b,
    0x8f1ee372fd6c9100,0x9809f465ea7b8617,0x8f1ee372fd6c9100,0x9809f465ea7b8617,
    0x7784956611e2f300,0xa85b4ab9ce3d2cdf,0x7784956611e2f300,0xa85b4ab9ce3d2cdf,
    0xc0de5e4e8e90100,0xa0be3e2eeef0706,0xc0de5e4e8e90100,0xa0be3e2eeef0706,
    0xe92b8644ad6fc200,0x5a9835f71edc71b3,0xe92b8644ad6fc200,0x5a9835f71edc71b3,
    0x67256b294e0c4200,0xda98d694f3b1ffbd,0x67256b294e0c4200,0xda98d694f3b1ffbd,
    0xc7dd4a5a9d87100,0xd3a20b7a7607aedf,0xc7dd4a5a9d87100,0xd3a20b7a7607aedf,
    0x90e68bfd6d1b7600,0xb0c6abdd4d3b5620,0x90e68bfd6d1b7600,0xb0c6abdd4d3b5620,
    0x2b73fba388d05800,0xc79f174f643cb4ec,0x2b73fba388d05800,0xc79f174f643cb4ec,
    0xbe91022d93bc2f00,0xa38c1f308ea1321d,0xbe91022d93bc2f00,0xa38c1f308ea1321d,
    0x79e622bdc45b9f00,0xb926e27d049b5fc0,0x79e622bdc45b9f00,0xb926e27d049b5fc0,
    };



}

#endif
