# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sherlock']

package_data = \
{'': ['*']}

extras_require = \
{'all': ['filelock>=3.7.1,<4.0.0',
         'kubernetes>=24.2.0,<25.0.0',
         'redis>=4.3.4,<5.0.0',
         'pylibmc>=1.6.1,<2.0.0'],
 'etcd': ['python-etcd>=0.4.5,<0.5.0'],
 'filelock': ['filelock>=3.7.1,<4.0.0'],
 'kubernetes': ['kubernetes>=24.2.0,<25.0.0'],
 'memcached': ['pylibmc>=1.6.1,<2.0.0'],
 'redis': ['redis>=4.3.4,<5.0.0']}

setup_kwargs = {
    'name': 'sherlock',
    'version': '0.4.0',
    'description': 'Distributed inter-process locks with a choice of backend',
    'long_description': "\nSherlock: Distributed Locks with a choice of backend\n====================================================\n\nSherlock is a library that provides easy-to-use distributed inter-process\nlocks and also allows you to choose a backend of your choice for lock\nsynchronization.\n\n|Build Status| |Coverage Status|\n\n.. |Build Status| image:: https://github.com/py-sherlock/sherlock/actions/workflows/ci.yml/badge.svg\n   :target: https://github.com/py-sherlock/sherlock/actions?query=workflow%3ACI/CD\n\n.. |Coverage Status| image:: https://codecov.io/gh/py-sherlock/sherlock/branch/master/graph/badge.svg?token=QJXCZVSAEF\n :target: https://codecov.io/gh/py-sherlock/sherlock\n\nOverview\n--------\n\nWhen you are working with resources which are accessed by multiple services or\ndistributed services, more than often you need some kind of locking mechanism\nto make it possible to access some resources at a time.\n\nDistributed Locks or Mutexes can help you with this. Sherlock provides\nthe exact same facility, with some extra goodies. It provides an easy-to-use API\nthat resembles standard library's `threading.Lock` semantics.\n\nApart from this, Sherlock gives you the flexibility of using a backend of\nyour choice for managing locks.\n\nSherlock also makes it simple for you to extend Sherlock to use\nbackends that are not supported.\n\nFeatures\n++++++++\n\n* API similar to standard library's `threading.Lock`.\n* Support for With statement, to cleanly acquire and release locks.\n* Backend agnostic: supports File, `Redis`_, `Memcached`_, `Etcd`_, and `Kubernetes`_ as choice of\n  backends.\n* Extendable: can be easily extended to work with any other of backend of\n  choice by extending base lock class. Read ``extending``.\n\n.. _Redis: http://redis.io\n.. _Memcached: http://memcached.org\n.. _Etcd: http://github.com/coreos/etcd\n.. _Kubernetes: https://kubernetes.io\n\nSupported Backends and Client Libraries\n+++++++++++++++++++++++++++++++++++++++\n\nFollowing client libraries are supported for every supported backend:\n\n* File: `filelock <https://github.com/tox-dev/py-filelock>`__\n* Redis: `redis-py <https://github.com/redis/redis-py/tree/master/redis>`__\n* Memcached: `pylibmc <https://github.com/lericson/pylibmc>`__\n* Etcd: `python-etcd <https://github.com/jplana/python-etcd>`__\n* Kubernetes: `kubernetes <https://github.com/kubernetes-client/python>`__\n\nAs of now, only the above mentioned libraries are supported. Although\nSherlock takes custom client objects so that you can easily provide\nsettings that you want to use for that backend store, but Sherlock also\nchecks if the provided client object is an instance of the supported clients\nand accepts client objects which pass this check, even if the APIs are the\nsame. Sherlock might get rid of this issue later, if need be and if\nthere is a demand for that.\n\nInstallation\n------------\n\nInstallation is simple.\n\n.. code:: bash\n\n    pip install sherlock[all]\n\n.. note:: Sherlock will install all the client libraries for all the\n          supported backends.\n\nBasic Usage\n-----------\n\nSherlock is simple to use as at the API and semantics level, it tries to\nconform to standard library's ``threading.Lock`` APIs.\n\n.. code-block:: python\n\n    import sherlock\n    from sherlock import Lock\n\n    # Configure Sherlock's locks to use Redis as the backend,\n    # never expire locks and retry acquiring an acquired lock after an\n    # interval of 0.1 second.\n    sherlock.configure(backend=sherlock.backends.REDIS,\n                       expire=None,\n                       retry_interval=0.1)\n\n    # Note: configuring sherlock to use a backend does not limit you\n    # another backend at the same time. You can import backend specific locks\n    # like RedisLock, MCLock and EtcdLock and use them just the same way you\n    # use a generic lock (see below). In fact, the generic Lock provided by\n    # sherlock is just a proxy that uses these specific locks under the hood.\n\n    # acquire a lock called my_lock\n    lock = Lock('my_lock')\n\n    # acquire a blocking lock\n    lock.acquire()\n\n    # check if the lock has been acquired or not\n    lock.locked() == True\n\n    # attempt to renew the lock\n    lock.renew()\n\n    # release the lock\n    lock.release()\n\nSupport for ``with`` statement\n++++++++++++++++++++++++++++++\n\n.. code-block:: python\n\n    # using with statement\n    with Lock('my_lock') as lock:\n        # do something constructive with your locked resource here\n        pass\n\nBlocking and Non-blocking API\n+++++++++++++++++++++++++++++\n\n.. code-block:: python\n\n    # acquire non-blocking lock\n    lock1 = Lock('my_lock')\n    lock2 = Lock('my_lock')\n\n    # successfully acquire lock1\n    lock1.acquire()\n\n    # try to acquire lock in a non-blocking way\n    lock2.acquire(False) == True # returns False\n\n    # try to acquire lock in a blocking way\n    lock2.acquire() # blocks until lock is acquired to timeout happens\n\nUsing two backends at the same time\n+++++++++++++++++++++++++++++++++++\n\nConfiguring Sherlock to use a backend does not limit you from using\nanother backend at the same time. You can import backend specific locks like\nRedisLock, MCLock and EtcdLock and use them just the same way you use a generic\nlock (see below). In fact, the generic Lock provided by Sherlock is just\na proxy that uses these specific locks under the hood.\n\n.. code-block:: python\n\n    import sherlock\n    from sherlock import Lock\n\n    # Configure Sherlock's locks to use Redis as the backend\n    sherlock.configure(backend=sherlock.backends.REDIS)\n\n    # Acquire a lock called my_lock, this lock uses Redis\n    lock = Lock('my_lock')\n\n    # Now acquire locks in Memcached\n    from sherlock import MCLock\n    mclock = MCLock('my_mc_lock')\n    mclock.acquire()\n\nTests\n-----\n\nTo run all the tests (including integration), you have to make sure that all\nthe databases are running. Make sure all the services are running:\n\n.. code:: bash\n\n    # memcached\n    memcached\n\n    # redis-server\n    redis-server\n\n    # etcd (etcd is probably not available as package, here is the simplest way\n    # to run it).\n    wget https://github.com/coreos/etcd/releases/download/<version>/etcd-<version>-<platform>.tar.gz\n    tar -zxvf etcd-<version>-<platform>.gz\n    ./etcd-<version>-<platform>/etcd\n\nRun tests like so:\n\n.. code:: bash\n\n    python setup.py test\n\nDocumentation\n-------------\n\nAvailable `here`_.\n\n.. _here: http://sher-lock.readthedocs.org\n\nLicense\n-------\n\nSee `LICENSE`_.\n\n**In short**: This is an open-source project and exists for anyone to use it\nand/or modify it for personal use. Just be nice and attribute the credits\nwherever you can. :)\n\n.. _LICENSE: http://github.com/vaidik/sherlock/blob/master/LICENSE.rst\n\nQuestions?\n----------\n\nYou are encouraged to ask questions using `issues`_ as that helps everyone and\nmyself when people with better know-how contribute to the discussion. However,\nif you wish to get in touch with me personally, then I can be contacted at\n**kapoor.vaidik++github+sherlock@gmail.com**.\n\n.. _issues: https://github.com/vaidik/sherlock/issues\n\nDistributed Locking in Other Languages\n--------------------------------------\n\n* NodeJS - https://github.com/thedeveloper/warlock\n\n",
    'author': 'Vaidik Kapoor',
    'author_email': 'kapoor.vaidik@gmail.com',
    'maintainer': 'Vaidik Kapoor',
    'maintainer_email': 'kapoor.vaidik@gmail.com',
    'url': 'https://github.com/py-sherlock/sherlock',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
