# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/04_wandb_viz.ipynb (unless otherwise specified).

__all__ = ['plot_basic_charts']

# Cell
import os
import wandb
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

# Cell
def plot_basic_charts(chart_type='line', x_data=None, y_data=None, x_name=None,
                      y_name=None, chart_title=None, wandb_chart_name='basic-chart'):
    """
    Plot basic W&B charts.

    Parameters
    ----------
    chart_type: str
        Choose a basic chart type to plot.
        - 'line'
        - 'bar'
        - 'scatter'
    x_data : list, optional
        x-axis data.
    y_data : list, optional
        y-axis data.
    x_name : str, optional
        x-axis name.
    y_name : str, optional
        y-axis name.
    chart_title : str, optional
        Chart title.
    wandb_chart_name : str, optional
        Chart name.

    Returns
    -------
    None

    Examples
    --------
    # Plot a simple line chart.
    plot_basic_charts(chart_type='line', x_data=[1,2,3,4,5], y_data=[1,2,3,4,5], x_name="x", y_name="y", chart_title="Simple line chart")

    # Plot a simple bar chart.
    plot_basic_charts(chart_type='bar', x_data=['a','b','c','d','e'], y_data=[1,2,3,4,5], x_name="x", y_name="y", chart_title="Simple bar chart")
    Note: When plotting a bar chart, x_data is the labels while y_data is the values.

    # Plot a simple scatter plot.
    plot_basic_charts(chart_type='scatter', x_data=[1,2,3,4,5], y_data=[1,2,3,4,5], x_name="x", y_name="y", chart_title="Simple scatter chart")
    """
    # [TODO] Should we initialize W&B run inside the function?

    data = [[x, y] for (x, y) in zip(x_data, y_data)]
    table = wandb.Table(data=data, columns = [x_name, y_name])

    if chart_type == 'line':
        wandb.log({f"{wandb_chart_name}" : wandb.plot.line(table, x_name, y_name, title=chart_title)})
    elif chart_type == 'bar':
        wandb.log({f"{wandb_chart_name}" : wandb.plot.bar(table, x_name, y_name, title=chart_title)})
    elif chart_type == 'scatter':
        wandb.log({f"{wandb_chart_name}" : wandb.plot.scatter(table, x_name, y_name, title=chart_title)})
