# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_wandb_utils.ipynb (unless otherwise specified).

__all__ = ['log_data_as_artifact', 'log_model_as_artifact', 'log_df_as_tables']

# Cell
import os
import wandb
import pandas as pd

# Cell
def log_data_as_artifact(wandb_run, path_to_data, artifact_name, artifact_type='dataset', log='file'):
    """
    Logs a file or directory as an artifact.

    Params:
        wandb_run: wandb.init() run
        path_to_data: path to file or directory to be logged
            - 'file'
            - 'dir'
        artifact_name: name of artifact
        artifact_type: type of artifact (default: dataset)
        log: log type (default: file)
    """

    artifact = wandb.Artifact(artifact_name, type=artifact_type)

    if log == 'file':
        artifact.add_file(path_to_data)
    elif log == 'dir':
        artifact.add_dir(path_to_data)

    wandb_run.log_artifact(artifact)

# Cell
def log_model_as_artifact(wandb_run, path_to_model, artifact_name, artifact_type='model', log='file'):
    """
    Logs a file or directory as an artifact.

    Params:
        wandb_run: wandb.init() run
        path_to_model: path to file or directory to be logged
            - 'file'
            - 'dir'
        artifact_name: name of artifact
        artifact_type: type of artifact (default: model)
        log: log type (default: file)
    """

    artifact = wandb.Artifact(artifact_name, type=artifact_type)

    if log == 'file':
        artifact.add_file(path_to_model)
    elif log == 'dir':
        artifact.add_dir(path_to_model)

    wandb_run.log_artifact(artifact)

# Cell
def log_df_as_tables(wandb_run, df, table_name="dataframe"):
    """
    Logs a dataframe as a table.

    Params:
        wandb_run: wandb.init() run
        df: dataframe to be logged
        table_name: name of table
    """
    # create W&B tables object
    tables = wandb.Table(dataframe=df)
    wandb.log({f"{table_name}": tables})