# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/survey_scenario/modules/ajout_individus.ipynb.

# %% auto 0
__all__ = [
    "config",
    "tc",
    "annee_erfs",
    "annee_pote",
    "annee_de_calcul",
    "ajout_gens",
    "create_ppl_HR",
    "get_similar_sample",
    "calibrate_new_ff",
    "save_new_ff_to_ind",
    "add_missing_indiv",
]

# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 5
import random
import unittest
from collections import Counter

import pandas as pd
from leximpact_socio_fisca_simu_etat.config import Configuration

from leximpact_prepare_data.helpers_survey_scenario import (
    distrib_to_quantiles,
    get_quantiles_casd,
    individus_to_entity,
    pote_comparison,
)

config = Configuration(project_folder="leximpact-prepare-data")
tc = unittest.TestCase()

# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 8
# Import des années
annee_erfs = config.get("YEAR_ERFS")
annee_pote = config.get("YEAR_POTE")
annee_de_calcul = config.get("YEAR_COMPUTATION")

# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 12
"""
    Ajout de foyers (qui sont égaux à un unique individu) dans la distribution
"""


def ajout_gens(erfs_ind, var_name, Distrib_POTE, Distrib_ERFS):
    initial_length = len(erfs_ind)
    buckets = Distrib_ERFS.bucket_list
    list_missing = []
    # On parcourt les buckets
    for i in range(len(buckets)):
        idx = buckets[str(i)].nb
        # Si on a un bucket vide alors que le quantile n'est pas vide, et qu'on n'est pas dans le 1er bucket
        if (
            (buckets[str(i)].nb_ff == 0)
            and (Distrib_POTE.bucket_list[str(i)].nb != 0)
            and (idx != 0)
        ):
            list_missing.append(idx)

    print("List missing", list_missing)  # debug

    # Si besoin on crée des individus
    if len(list_missing) > 0:
        print("On a ", len(list_missing), "buckets vides")
        new_ff = create_ppl_HR(
            erfs_ind, var_name, list_missing, Distrib_POTE, Distrib_ERFS
        )
        tc.assertGreater(len(new_ff), 0)
        # On sauvegarde cela dans la nouvelle base
        erfs_ind_new = save_new_ff_to_ind(erfs_ind, new_ff)

        assert initial_length < len(erfs_ind_new)
    else:
        erfs_ind_new = erfs_ind.copy(deep=True)

    return erfs_ind_new


# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 14
"""
    Création de nouvelles personnes
    On notera qu'on ajoute uniquement des déclarants principaux, donc ici foyer=gens
"""


def create_ppl_HR(erfs_ind, var_name, list_missing, Distrib_POTE, Distrib_ERFS):
    # On pioche pour chaque bucket le nombre de personnes manquantes
    for id_x in list_missing:
        # 0 - Choix de l'échantillon où piocher
        erfs_ff = individus_to_entity(erfs_ind, "foyer_fiscal")
        echantillon_ou_piocher = get_similar_sample(
            id_x, erfs_ff, var_name, list_missing, Distrib_POTE, Distrib_ERFS
        )
        assert (
            echantillon_ou_piocher.empty is False
        ), "Attention, l'échantillon où piocher est vide"

        # 1 - Choix du nombre de foyers que l'on doit ajouter
        Nb_wanted = Distrib_POTE.bucket_list[str(id_x)].nb_ff
        seuil_inf = Distrib_POTE.bucket_list[str(id_x)].seuil_inf
        seuil_max = Distrib_POTE.bucket_list[str(id_x)].seuil_max
        # Si c'est trop, on en prend au max 0.5% de la population
        if Nb_wanted > 1000:
            Nb = int(round(len(erfs_ff) / 200, 0))
            # print("inf 1000", Nb)
        else:
            Nb = int(Nb_wanted)
            # print("Else", Nb)

        # 2 - Sélection au hasard de gens
        print(
            "On ajoute ",
            Nb,
            " personnes dans le bucket ",
            id_x,
            "entre ",
            seuil_inf,
            " et ",
            seuil_max,
        )
        # Si on peut, on essaye de ne pas prendre plusieurs fois le meme foyer
        if Nb >= len(echantillon_ou_piocher):
            new_ff = echantillon_ou_piocher.sample(n=Nb, replace=True).reset_index(
                drop=True
            )
        else:
            new_ff = echantillon_ou_piocher.sample(n=Nb, replace=False).reset_index(
                drop=True
            )
            # print("echantillon \n", echantillon_ou_piocher)
        # TODO : on fixe le random-state pour plus de stabilité?

        # 3 - On calibre
        sum_wanted = Distrib_POTE.bucket_list[str(id_x)].sum_
        new_ff_cal = calibrate_new_ff(
            new_ff, Nb_wanted, var_name, seuil_inf, seuil_max, sum_wanted
        )

        print("new_ff", len(new_ff_cal))  # debug

        #
        save_new_ff_to_ind

    return new_ff_cal


# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 16
def get_similar_sample(
    id_, erfs_ff, var_name, list_missing, Distrib_POTE, Distrib_ERFS
):
    """On décide de sélectionner des profils "proches",
    donc dans les 2 buckets non vides précédant le bucket vide,
    ou les 2 suivants s'il n'y en a pas
    """

    not_missing = list(
        (
            Counter(Distrib_POTE.df.index.values.astype(int)) - Counter(list_missing)
        ).elements()
    )
    # We do not account for the first bucket
    if not_missing[0] == 0:
        not_missing = not_missing[1:]

    # Getting last 2 not empty
    ids = []
    for i in reversed(not_missing):
        # Finding 2 buckets below
        if (i < id_) and (len(ids) < 2):
            ids.append(i)
    # If we couldn't find 2 buckets below
    if len(ids) < 2:
        for i in not_missing:
            if (i > id_) and (len(ids) < 2):
                ids.append(i)
    assert len(ids) == 2

    # Selected sample
    id_min = min(ids)
    id_max = max(ids)
    sample = erfs_ff.loc[
        (erfs_ff[var_name] >= Distrib_POTE.bucket_list[str(id_min)].seuil_inf)
        & (erfs_ff[var_name] < Distrib_POTE.bucket_list[str(id_max)].seuil_max)
    ].copy(deep=True)
    assert sample.empty is False, "Attention, l'échantillon où piocher est vide"

    return sample


# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 18
def calibrate_new_ff(new_ff, Nb_wanted, var_name, seuil_inf, seuil_max, sum_wanted):
    # Calibration des poids
    rate = Nb_wanted / (new_ff["wprm"].sum())
    new_ff.loc[:, "wprm"] = new_ff["wprm"].apply(lambda row: row * rate)
    tc.assertAlmostEqual(new_ff["wprm"].sum(), Nb_wanted)

    # Calibration de la variable d'intéret
    # 1 - On leur attribue une valeur comprise dans le bucket (+/- 5% pour avoir une marge)
    new_ff.loc[:, var_name] = [
        random.randint(
            round(seuil_inf, 0) + 10, round(seuil_max, 0) - 10
        )  # round(1.05*seuil_inf), round(0.95*seuil_max))
        for ppl in range(len(new_ff))
    ]
    sum_ponderee = (new_ff[var_name] * new_ff["wprm"]).sum()

    # 2 - On recalibre
    error = 1
    while error > 0.001:
        coef = sum_wanted / sum_ponderee
        # On update les valeurs
        new_ff.loc[:, var_name] = new_ff[var_name].apply(
            lambda row: max(min((row * coef), seuil_max - 1), seuil_inf + 1)
        )
        sum_ponderee = (new_ff[var_name] * new_ff["wprm"]).sum()
        error = (sum_ponderee - sum_wanted) / sum_wanted

    tc.assertAlmostEqual(error, 0, places=0)

    return new_ff


# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 20
""" Mise en forme des foyers créés dans la base en individus """


def save_new_ff_to_ind(erfs_ind, new_ff):
    # On cherche les individus qui composent les nouveaux foyers fiscaux
    id_list = list(new_ff["foyer_fiscal_id"])
    new_people = erfs_ind[erfs_ind["foyer_fiscal_id"].isin(id_list)]

    # On leur attribue les nouveaux poids calibrés
    for id_foy in id_list:
        new_people[new_people["foyer_fiscal_id"] == id_foy]["wprm"] = new_ff[
            new_ff["foyer_fiscal_id"] == id_foy
        ]["wprm"]

    # new_people = new_people.copy().reset_index(drop=True)
    new_people = new_people.reset_index(drop=True)

    # Création des Idfoy, Idfam, Idmen uniques
    max_idfoy = (
        max(erfs_ind["foyer_fiscal_id"]) + 1
    )  # S'update à chaque ajout de bucket
    dict_ = {}
    i = 1
    new_people["new_foyer_fiscal_id"] = new_people["foyer_fiscal_id"]
    for id_foy in id_list:
        dict_[id_foy] = max_idfoy + i
        new_people[new_people["foyer_fiscal_id"] == id_foy]["famille_id"] = (
            max_idfoy + i
        )
        new_people[new_people["foyer_fiscal_id"] == id_foy]["menage_id"] = max_idfoy + i
        new_people[new_people["foyer_fiscal_id"] == id_foy]["new_foyer_fiscal_id"] = (
            max_idfoy + i
        )
        i += 1

    new_people["foyer_fiscal_id"] = new_people["new_foyer_fiscal_id"]
    new_people.drop("new_foyer_fiscal_id", axis=1)
    # TODO PROPAGER AUX POIDS des autres entites

    tc.assertEqual(new_people.isna().sum().sum(), 0)

    # On ajoute ces gens dans notre base en individus
    # new_ff.drop(['index'], axis=1)
    erfs_av = erfs_ind.copy()  # Pour le test
    erfs_ind = pd.concat([erfs_ind, new_people])
    erfs_ind = erfs_ind.reset_index(drop=True)
    tc.assertEqual(len(erfs_ind), len(erfs_av) + len(new_people))

    return erfs_ind


# %% ../notebooks/survey_scenario/modules/ajout_individus.ipynb 23
def add_missing_indiv(scenario, annee_ajout, variable):
    # On va chercher le fichier de quantiles
    quantiles = get_quantiles_casd(variable)

    # On va chercher la base individus
    var_list = scenario._leximpact_variables
    base_indiv = scenario.create_data_frame_by_entity(
        variables=var_list, period=annee_ajout, merge=True
    )

    # On découpe la base en buckets de notre variable d'intérêt
    Distrib_BASE, Distrib_POTE, quantiles = distrib_to_quantiles(
        individus_to_entity(base_indiv, "foyer_fiscal"), variable, quantiles
    )

    # On identifie les buckets vides, on fabrique des individus et on les mets dans la base individus
    new_base_ind = ajout_gens(base_indiv, variable, Distrib_POTE, Distrib_BASE)
    new_base_ff = individus_to_entity(new_base_ind, "foyer_fiscal")

    # Plot des histogrammes de la new base
    fig, error_df, final_error = pote_comparison(
        individus_to_entity(base_indiv, "foyer_fiscal"),
        variable,
        title_suffix="",
        log=True,
        base_ff_cal=new_base_ff,
    )
    print("Avant", len(base_indiv), "apres", len(new_base_ind))

    # On remplace la base par la nouvelle base dans notre scenario
    print(
        "ATTENTION TRAVAIL EN COURS \n Il faudra encore inserer cette base dans un scenario"
    )

    return new_base_ind, Distrib_BASE
