import { CfnGatewayRoute, CfnRoute } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * The type returned from the `bind()` method in {@link HttpRoutePathMatch}.
 *
 * @stability stable
 */
export interface HttpRoutePathMatchConfig {
    /**
     * Route configuration for matching on the complete URL path of the request.
     *
     * @default - no matching will be performed on the complete URL path
     * @stability stable
     */
    readonly wholePathMatch?: CfnRoute.HttpPathMatchProperty;
    /**
     * Route configuration for matching on the prefix of the URL path of the request.
     *
     * @default - no matching will be performed on the prefix of the URL path
     * @stability stable
     */
    readonly prefixPathMatch?: string;
}
/**
 * Defines HTTP route matching based on the URL path of the request.
 *
 * @stability stable
 */
export declare abstract class HttpRoutePathMatch {
    /**
     * The value of the path must match the specified value exactly.
     *
     * The provided `path` must start with the '/' character.
     *
     * @param path the exact path to match on.
     * @stability stable
     */
    static exactly(path: string): HttpRoutePathMatch;
    /**
     * The value of the path must match the specified regex.
     *
     * @param regex the regex used to match the path.
     * @stability stable
     */
    static regex(regex: string): HttpRoutePathMatch;
    /**
     * The value of the path must match the specified prefix.
     *
     * @param prefix the value to use to match the beginning of the path part of the URL of the request.
     * @stability stable
     */
    static startsWith(prefix: string): HttpRoutePathMatch;
    /**
     * Returns the route path match configuration.
     *
     * @stability stable
     */
    abstract bind(scope: Construct): HttpRoutePathMatchConfig;
}
/**
 * The type returned from the `bind()` method in {@link HttpGatewayRoutePathMatch}.
 *
 * @stability stable
 */
export interface HttpGatewayRoutePathMatchConfig {
    /**
     * Gateway route configuration for matching on the complete URL path of the request.
     *
     * @default - no matching will be performed on the complete URL path
     * @stability stable
     */
    readonly wholePathMatch?: CfnGatewayRoute.HttpPathMatchProperty;
    /**
     * Gateway route configuration for matching on the prefix of the URL path of the request.
     *
     * @default - no matching will be performed on the prefix of the URL path
     * @stability stable
     */
    readonly prefixPathMatch?: string;
    /**
     * Gateway route configuration for rewriting the complete URL path of the request..
     *
     * @default - no rewrite will be performed on the request's complete URL path
     * @stability stable
     */
    readonly wholePathRewrite?: CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty;
    /**
     * Gateway route configuration for rewriting the prefix of the URL path of the request.
     *
     * @default - rewrites the request's URL path to '/'
     * @stability stable
     */
    readonly prefixPathRewrite?: CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty;
}
/**
 * Defines HTTP gateway route matching based on the URL path of the request.
 *
 * @stability stable
 */
export declare abstract class HttpGatewayRoutePathMatch {
    /**
     * The value of the path must match the specified prefix.
     *
     * @param prefix the value to use to match the beginning of the path part of the URL of the request.
     * @param rewriteTo Specify either disabling automatic rewrite or rewriting to specified prefix path.
     * @stability stable
     */
    static startsWith(prefix: string, rewriteTo?: string): HttpGatewayRoutePathMatch;
    /**
     * The value of the path must match the specified value exactly.
     *
     * The provided `path` must start with the '/' character.
     *
     * @param path the exact path to match on.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     * @stability stable
     */
    static exactly(path: string, rewriteTo?: string): HttpGatewayRoutePathMatch;
    /**
     * The value of the path must match the specified regex.
     *
     * @param regex the regex used to match the path.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     * @stability stable
     */
    static regex(regex: string, rewriteTo?: string): HttpGatewayRoutePathMatch;
    /**
     * Returns the gateway route path match configuration.
     *
     * @stability stable
     */
    abstract bind(scope: Construct): HttpGatewayRoutePathMatchConfig;
}
