"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserVpcAuthorization = exports.UserVpcAuthorizationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pvtz_generated_1 = require("./pvtz.generated");
Object.defineProperty(exports, "UserVpcAuthorizationProperty", { enumerable: true, get: function () { return pvtz_generated_1.RosUserVpcAuthorization; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PVTZ::UserVpcAuthorization`, which is used to associate virtual private clouds (VPCs) across accounts.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosUserVpcAuthorization`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pvtz-uservpcauthorization
 */
class UserVpcAuthorization extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosUserVpcAuthorization = new pvtz_generated_1.RosUserVpcAuthorization(this, id, {
            authCode: props.authCode,
            authChannel: props.authChannel,
            authorizedUserId: props.authorizedUserId,
            authType: props.authType,
            ignoreDeletionForbidden: props.ignoreDeletionForbidden === undefined || props.ignoreDeletionForbidden === null ? false : props.ignoreDeletionForbidden,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUserVpcAuthorization;
        this.attrAuthType = rosUserVpcAuthorization.attrAuthType;
        this.attrAuthorizedUserId = rosUserVpcAuthorization.attrAuthorizedUserId;
    }
}
exports.UserVpcAuthorization = UserVpcAuthorization;
//# sourceMappingURL=data:application/json;base64,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