# Generated by ariadne-codegen
# Source: queries.graphql

from datetime import datetime
from decimal import Decimal
from typing import Any, List, Literal, Optional, Union

from pydantic import Field

from architect_py.scalars import OrderDir

from .base_model import BaseModel
from .enums import CmeSecurityType, MinOrderQuantityUnit, OrderSource, OrderStateFlags


class ProductFields(BaseModel):
    typename__: str = Field(alias="__typename")
    id: str
    name: str
    kind: str
    mark_usd: Optional[Decimal] = Field(alias="markUsd")


class MarketFields(BaseModel):
    typename__: str = Field(alias="__typename")
    venue: "MarketFieldsVenue"
    exchange_symbol: str = Field(alias="exchangeSymbol")
    id: str
    cme_product_group_info: Optional["MarketFieldsCmeProductGroupInfo"] = Field(
        alias="cmeProductGroupInfo"
    )
    kind: Union[
        "MarketFieldsKindExchangeMarketKind",
        "MarketFieldsKindPoolMarketKind",
        "MarketFieldsKindUnknownMarketKind",
    ] = Field(discriminator="typename__")
    name: str
    tick_size: Decimal = Field(alias="tickSize")
    step_size: Decimal = Field(alias="stepSize")
    min_order_quantity: Decimal = Field(alias="minOrderQuantity")
    min_order_quantity_unit: MinOrderQuantityUnit = Field(alias="minOrderQuantityUnit")
    route: "MarketFieldsRoute"
    is_favorite: bool = Field(alias="isFavorite")


class MarketFieldsVenue(BaseModel):
    id: str
    name: str


class MarketFieldsCmeProductGroupInfo(BaseModel):
    product_name: Optional[str] = Field(alias="productName")
    security_type: CmeSecurityType = Field(alias="securityType")
    category: Optional[str]
    sub_category: Optional[str] = Field(alias="subCategory")
    main_fraction: Optional[int] = Field(alias="mainFraction")
    price_band: Optional[str] = Field(alias="priceBand")


class MarketFieldsKindExchangeMarketKind(BaseModel):
    typename__: Literal["ExchangeMarketKind"] = Field(alias="__typename")
    base: "MarketFieldsKindExchangeMarketKindBase"
    quote: "MarketFieldsKindExchangeMarketKindQuote"


class MarketFieldsKindExchangeMarketKindBase(ProductFields):
    pass


class MarketFieldsKindExchangeMarketKindQuote(ProductFields):
    pass


class MarketFieldsKindPoolMarketKind(BaseModel):
    typename__: Literal["PoolMarketKind"] = Field(alias="__typename")
    products: List["MarketFieldsKindPoolMarketKindProducts"]


class MarketFieldsKindPoolMarketKindProducts(ProductFields):
    pass


class MarketFieldsKindUnknownMarketKind(BaseModel):
    typename__: Literal["UnknownMarketKind"] = Field(alias="__typename")


class MarketFieldsRoute(BaseModel):
    id: str
    name: str


class AccountSummariesFields(BaseModel):
    snapshot_ts: datetime = Field(alias="snapshotTs")
    by_account: List["AccountSummariesFieldsByAccount"] = Field(alias="byAccount")


class AccountSummariesFieldsByAccount(BaseModel):
    account: Optional["AccountSummariesFieldsByAccountAccount"]
    balances: List["AccountSummariesFieldsByAccountBalances"]
    positions: List["AccountSummariesFieldsByAccountPositions"]


class AccountSummariesFieldsByAccountAccount(BaseModel):
    id: str
    name: str


class AccountSummariesFieldsByAccountBalances(BaseModel):
    product: Optional["AccountSummariesFieldsByAccountBalancesProduct"]
    account: Optional["AccountSummariesFieldsByAccountBalancesAccount"]
    venue: Optional["AccountSummariesFieldsByAccountBalancesVenue"]
    amount: Optional[Decimal]
    total_margin: Optional[Decimal] = Field(alias="totalMargin")
    position_margin: Optional[Decimal] = Field(alias="positionMargin")
    purchasing_power: Optional[Decimal] = Field(alias="purchasingPower")
    cash_excess: Optional[Decimal] = Field(alias="cashExcess")
    yesterday_balance: Optional[Decimal] = Field(alias="yesterdayBalance")


class AccountSummariesFieldsByAccountBalancesProduct(ProductFields):
    pass


class AccountSummariesFieldsByAccountBalancesAccount(BaseModel):
    id: str
    name: str


class AccountSummariesFieldsByAccountBalancesVenue(BaseModel):
    id: str
    name: str


class AccountSummariesFieldsByAccountPositions(BaseModel):
    account: Optional["AccountSummariesFieldsByAccountPositionsAccount"]
    venue: Optional["AccountSummariesFieldsByAccountPositionsVenue"]
    market: Optional["AccountSummariesFieldsByAccountPositionsMarket"]
    dir: OrderDir
    quantity: Optional[Decimal]
    average_price: Optional[Decimal] = Field(alias="averagePrice")
    trade_date: Optional[Any] = Field(alias="tradeDate")
    trade_time: Optional[datetime] = Field(alias="tradeTime")


class AccountSummariesFieldsByAccountPositionsAccount(BaseModel):
    id: str
    name: str


class AccountSummariesFieldsByAccountPositionsVenue(BaseModel):
    id: str
    name: str


class AccountSummariesFieldsByAccountPositionsMarket(MarketFields):
    pass


class CandleFields(BaseModel):
    time: datetime
    open: Decimal
    high: Decimal
    low: Decimal
    close: Decimal
    volume: Decimal


class MarketSnapshotFields(BaseModel):
    typename__: str = Field(alias="__typename")
    market_id: str = Field(alias="marketId")
    market: Optional["MarketSnapshotFieldsMarket"]
    high_24_h: Optional[Decimal] = Field(alias="high24h")
    last_price: Optional[Decimal] = Field(alias="lastPrice")
    low_24_h: Optional[Decimal] = Field(alias="low24h")
    volume_24_h: Optional[Decimal] = Field(alias="volume24h")
    open_24_h: Optional[Decimal] = Field(alias="open24h")
    bid_price: Optional[Decimal] = Field(alias="bidPrice")
    ask_price: Optional[Decimal] = Field(alias="askPrice")


class MarketSnapshotFieldsMarket(BaseModel):
    name: str


class OrderFields(BaseModel):
    id: str
    market_id: str = Field(alias="marketId")
    market: "OrderFieldsMarket"
    dir: OrderDir
    quantity: Decimal
    account_id: Optional[str] = Field(alias="accountId")
    order_type: Union[
        "OrderFieldsOrderTypeLimitOrderType",
        "OrderFieldsOrderTypeStopLossLimitOrderType",
        "OrderFieldsOrderTypeTakeProfitLimitOrderType",
    ] = Field(alias="orderType", discriminator="typename__")
    time_in_force: "OrderFieldsTimeInForce" = Field(alias="timeInForce")
    quote_id: Optional[str] = Field(alias="quoteId")
    source: OrderSource


class OrderFieldsMarket(MarketFields):
    pass


class OrderFieldsOrderTypeLimitOrderType(BaseModel):
    typename__: Literal["LimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")
    post_only: bool = Field(alias="postOnly")


class OrderFieldsOrderTypeStopLossLimitOrderType(BaseModel):
    typename__: Literal["StopLossLimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")
    trigger_price: Decimal = Field(alias="triggerPrice")


class OrderFieldsOrderTypeTakeProfitLimitOrderType(BaseModel):
    typename__: Literal["TakeProfitLimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")
    trigger_price: Decimal = Field(alias="triggerPrice")


class OrderFieldsTimeInForce(BaseModel):
    instruction: str
    good_til_date: Optional[datetime] = Field(alias="goodTilDate")


class OrderLogFields(BaseModel):
    typename__: str = Field(alias="__typename")
    timestamp: datetime
    order: "OrderLogFieldsOrder"
    order_state: List[OrderStateFlags] = Field(alias="orderState")
    filled_qty: Decimal = Field(alias="filledQty")
    avg_fill_price: Optional[Decimal] = Field(alias="avgFillPrice")
    reject_reason: Optional[str] = Field(alias="rejectReason")


class OrderLogFieldsOrder(BaseModel):
    id: str
    market: "OrderLogFieldsOrderMarket"
    dir: OrderDir
    quantity: Decimal
    order_type: Union[
        "OrderLogFieldsOrderOrderTypeLimitOrderType",
        "OrderLogFieldsOrderOrderTypeStopLossLimitOrderType",
        "OrderLogFieldsOrderOrderTypeTakeProfitLimitOrderType",
    ] = Field(alias="orderType", discriminator="typename__")
    time_in_force: "OrderLogFieldsOrderTimeInForce" = Field(alias="timeInForce")


class OrderLogFieldsOrderMarket(MarketFields):
    pass


class OrderLogFieldsOrderOrderTypeLimitOrderType(BaseModel):
    typename__: Literal["LimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")


class OrderLogFieldsOrderOrderTypeStopLossLimitOrderType(BaseModel):
    typename__: Literal["StopLossLimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")
    trigger_price: Decimal = Field(alias="triggerPrice")


class OrderLogFieldsOrderOrderTypeTakeProfitLimitOrderType(BaseModel):
    typename__: Literal["TakeProfitLimitOrderType"] = Field(alias="__typename")
    limit_price: Decimal = Field(alias="limitPrice")
    trigger_price: Decimal = Field(alias="triggerPrice")


class OrderLogFieldsOrderTimeInForce(BaseModel):
    instruction: str
    good_til_date: Optional[datetime] = Field(alias="goodTilDate")


ProductFields.model_rebuild()
MarketFields.model_rebuild()
AccountSummariesFields.model_rebuild()
CandleFields.model_rebuild()
MarketSnapshotFields.model_rebuild()
OrderFields.model_rebuild()
OrderLogFields.model_rebuild()
