# architect_py

## Example usage

```python
import asyncio
from architect_py.async_client import AsyncClient


async def main():
    c = AsyncClient(
        host="<your installation domain>",
        api_key="<api key>",
        api_secret="<api secret>"
    )
    print(await c.execute("query { me { userId email } }"))
    s = c.subscribe_trades("BTC Crypto/USD*COINBASE/DIRECT")
    async for trade in s:
        print(trade)


asyncio.run(main())
```

## Running additional examples from this package

Clone this repository to run examples in the `examples` directory.  This package
uses poetry for dependency management.  To enter a poetry virtual environment, make
sure you have [poetry](https://python-poetry.org/docs/) installed and run the 
following from the repository root.

```bash
poetry shell
poetry install --sync 

export ARCHITECT_HOST="<your installation domain>"
export ARCHITECT_API_KEY="<api key>"
export ARCHITECT_API_SECRET="<api secret>"

python -m examples.trades
```

You can exit the poetry shell by running `exit`.  Environment variables set
within the shell are not persisted.

## Maintainers

Python type conversions for scalars should be added to the codegen toml files, if needed.

Important files:
- `schema.graphql`: autogenerated from `architect-gql schema`
- `queries.graphql`: add any new queries/mutations
- `generate_protocol.py`: autogenerates the `architect_py/protocol/client_protocol.py`
- `architect_py/protocol/client_protocol.py`: autogenerated from `generate_protocol.py`, contains the class that the sync client inherits from
- `architect_py/async_client.py`: inherits from the ariadne generated base client
- `architect_py/client.py`: contains the sync client, delegates functions calls to a composed AsyncClient in the innards, inherits from the client_protocl to give the correct type hinting from Pylance
- `tests` and `examples`: self-explanatory

On any update, please run `update.sh`

In addition, any new function should have a test included in test.py

To run tests:
`export $(cat pytest.env | xargs)`
`pytest tests/*`


### What does `update.sh` do?

1. Uses ariadne-codegen to generate the async client
2. Autogenerates the protocol that the sync client inherits from
3. Runs the tests

