# `changelogging`

[![License][License Badge]][License]
[![Version][Version Badge]][Package]
[![Downloads][Downloads Badge]][Package]
[![Discord][Discord Badge]][Discord]

[![Documentation][Documentation Badge]][Documentation]
[![Check][Check Badge]][Actions]
[![Test][Test Badge]][Actions]
[![Coverage][Coverage Badge]][Coverage]

> *Building changelogs from fragments.*

## Installing

**Python 3.7 or above is required.**

### pip

Installing the library with `pip` is quite simple:

```console
$ pip install changelogging
```

Alternatively, the library can be installed from source:

```console
$ git clone https://github.com/nekitdev/changelogging.git
$ cd changelogging
$ python -m pip install .
```

### poetry

You can add `changelogging` as a dependency with the following command:

```console
$ poetry add changelogging
```

Or by directly specifying it in the configuration like so:

```toml
[tool.poetry.dependencies]
changelogging = "^1.0.0"
```

Alternatively, you can add it directly from the source:

```toml
[tool.poetry.dependencies.changelogging]
git = "https://github.com/nekitdev/changelogging.git"
```

## Documentation

You can find the documentation [here][Documentation].

## Support

If you need support with the library, you can send an [email][Email]
or refer to the official [Discord server][Discord].

## Changelog

You can find the changelog [here][Changelog].

## Security Policy

You can find the Security Policy of `changelogging` [here][Security].

## Contributing

If you are interested in contributing to `changelogging`, make sure to take a look at the
[Contributing Guide][Contributing Guide], as well as the [Code of Conduct][Code of Conduct].

## License

`changelogging` is licensed under the MIT License terms. See [License][License] for details.

[Email]: mailto:support@nekit.dev

[Discord]: https://nekit.dev/discord

[Actions]: https://github.com/nekitdev/changelogging/actions

[Changelog]: https://github.com/nekitdev/changelogging/blob/main/CHANGELOG.md
[Code of Conduct]: https://github.com/nekitdev/changelogging/blob/main/CODE_OF_CONDUCT.md
[Contributing Guide]: https://github.com/nekitdev/changelogging/blob/main/CONTRIBUTING.md
[Security]: https://github.com/nekitdev/changelogging/blob/main/SECURITY.md

[License]: https://github.com/nekitdev/changelogging/blob/main/LICENSE

[Package]: https://pypi.org/project/changelogging
[Coverage]: https://codecov.io/gh/nekitdev/changelogging
[Documentation]: https://nekitdev.github.io/changelogging

[Discord Badge]: https://img.shields.io/badge/chat-discord-5865f2
[License Badge]: https://img.shields.io/pypi/l/changelogging
[Version Badge]: https://img.shields.io/pypi/v/changelogging
[Downloads Badge]: https://img.shields.io/pypi/dm/changelogging

[Documentation Badge]: https://github.com/nekitdev/changelogging/workflows/docs/badge.svg
[Check Badge]: https://github.com/nekitdev/changelogging/workflows/check/badge.svg
[Test Badge]: https://github.com/nekitdev/changelogging/workflows/test/badge.svg
[Coverage Badge]: https://codecov.io/gh/nekitdev/changelogging/branch/main/graph/badge.svg
