# CodiMD
- https://github.com/hackmdio/codimd
- https://github.com/codimd/cli#api-endpoints

> These server endpoints are used by this project and can be unstable and
> undocumented, but may be of use if you're developing your own projects that
> need API access to CodiMD

- login fields are email and password
  https://github.com/codimd/cli/blob/b9d91223e5b86e2252883576da67fb924e8ae400/bin/codimd#L258
- md download is `/${note_id}/download`
  https://github.com/codimd/cli/blob/b9d91223e5b86e2252883576da67fb924e8ae400/bin/codimd#L208

```
SELECT
  url,
  note_id,
  substring(md FOR 40),
  ts_headline('english', md, websearch_to_tsquery('vim or emacs'))
FROM codimd_note
WHERE to_tsvector(md) @@ websearch_to_tsquery('vim or emacs')
;
```
Be careful with `ts_headline`:
https://www.postgresql.org/docs/current/textsearch-controls.html#TEXTSEARCH-HEADLINE


# The Interface (TM)
Even though I love Django apps, their overhead is huge for something as simple
as "fetch some data and put it into a table".

Could we maybe define puddl plugins with a  simpler interface? Like:

- a python module
- with a name
- owning the following tables [^1]
- (optional) I am a django app

[^1]: We must fail early if there are conflicts, but I don't like "namespaced"
      tables, i.e. `someapp_foo`. It makes SQL queries even more cumbersome to
      write than they already are.

On the other hand: just thinking about stuff like DB models, migrations,
timezone-awareness and - god forbid - HTTP web stuff, makes me realize how
precious the Django-based approach is...

Let's go the cookie-cutter route for now, i.e.: make it as easy as possible to
create a new app.
