// Generated by CoffeeScript 1.9.1
(function() {
  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(function() {
    var ListFilter;
    return ListFilter = (function() {
      function ListFilter(filter, filter_skel) {
        this.filter = filter;
        this.filter_skel = filter_skel;
        this.onKeypress = bind(this.onKeypress, this);
        this.resetFilter = bind(this.resetFilter, this);
        this.filterCallback = bind(this.filterCallback, this);
        this.drawFilterCallback = bind(this.drawFilterCallback, this);
        this.drawFilterBOCallback = bind(this.drawFilterBOCallback, this);
        this.drawFilter = bind(this.drawFilter, this);
        this.showFilter = bind(this.showFilter, this);
        this.hideFilter = bind(this.hideFilter, this);
        this.mode = "django";
      }

      ListFilter.prototype.hideFilter = function() {
        if (this.filter == null) {
          return;
        }
        return $(this.filter).hide().addClass("hidden");
      };

      ListFilter.prototype.showFilter = function(all) {
        var br, hide, i, input, j, k, len, len1, len2, ref, ref1, ref2, select, show;
        if (this.filter == null) {
          return;
        }
        hide = function(elt) {
          var fom_group;
          fom_group = $(elt).closest(".form-group");
          if (fom_group.length > 0) {
            fom_group.hide();
          } else {
            $(elt).hide();
          }
          return $(elt.label).hide();
        };
        show = function(elt) {
          var fom_group;
          fom_group = $(elt).closest(".form-group");
          if (fom_group.length > 0) {
            fom_group.show();
          } else {
            $(elt).show();
          }
          return $(elt.label).show();
        };
        ref = $("INPUT", this.form);
        for (i = 0, len = ref.length; i < len; i++) {
          input = ref[i];
          if (input.getAttribute("type") === "checkbox") {
            if (!all && input.getAttribute("checked") !== "checked") {
              hide(input);
            } else {
              if (input.id !== "") {
                show(input);
              }
            }
          } else {
            if (!all && input.value === "") {
              hide(input);
            } else {
              show(input);
            }
          }
        }
        ref1 = $("select", this.form);
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          select = ref1[j];
          if (!all && select.querySelectorAll("option[selected]").length === 0) {
            hide(select);
          } else {
            show(select);
          }
        }
        ref2 = $("br", this.form);
        for (k = 0, len2 = ref2.length; k < len2; k++) {
          br = ref2[k];
          if (all) {
            $(br).show();
          } else {
            $(br).hide();
          }
        }
        return $(this.filter).show().removeClass("hidden");
      };

      ListFilter.prototype.drawFilter = function(after) {
        var bocall;
        if (this.filter == null) {
          return;
        }
        this.hideFilter();
        bocall = new BOCall;
        bocall.done = (function(_this) {
          return function() {
            _this.drawFilterBOCallback(bocall);
            return typeof after === "function" ? after() : void 0;
          };
        })(this);
        return bocall.postFacet(null, this.filter_skel, this.mode);
      };

      ListFilter.prototype.drawFilterBOCallback = function(bocall) {
        if (bocall != null) {
          $(this.filter).html(bocall.responseText);
        }
        return this.drawFilterCallback();
      };

      ListFilter.prototype.drawFilterCallback = function() {
        var elem, form, i, label, len, ref;
        form = $("form", this.filter);
        if (form.length === 0) {
          return;
        }
        this.form = form.get(0);
        $('#plus', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            return _this.showFilter(true);
          };
        })(this));
        $('#moins', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            _this.resetFilter();
            return _this.filterCallback(evt);
          };
        })(this));
        $('#go', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            return _this.filterCallback(evt);
          };
        })(this));
        $(this.form).on('submit', this.filterCallback);
        $(this.form).on('keypress', this.onKeypress);
        ref = $('label');
        for (i = 0, len = ref.length; i < len; i++) {
          label = ref[i];
          if (!(label.htmlFor !== '')) {
            continue;
          }
          elem = document.getElementById(label.htmlFor);
          if (elem != null) {
            elem.label = label;
          }
        }
        return this.showFilter();
      };

      ListFilter.prototype.filterCallback = function(evt) {
        var data, ref;
        if (evt != null) {
          evt.preventDefault();
        }
        if (this.form != null) {
          data = new FormData(this.form);
        }
        return (ref = this.list) != null ? ref.drawList(null, data, this.drawFilter) : void 0;
      };

      ListFilter.prototype.resetFilter = function() {
        var i, input, j, k, len, len1, len2, option, ref, ref1, ref2, results, select;
        ref = $("input", this.form);
        for (i = 0, len = ref.length; i < len; i++) {
          input = ref[i];
          if (input.id !== 'nbre_ligne') {
            $(input).val('');
          }
        }
        ref1 = $("select", this.form);
        results = [];
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          select = ref1[j];
          ref2 = $("option", select).val();
          for (k = 0, len2 = ref2.length; k < len2; k++) {
            option = ref2[k];
            option.selected = false;
          }
          results.push(select.querySelector("option").selected = true);
        }
        return results;
      };

      ListFilter.prototype.onKeypress = function(evt) {
        if (evt.which === 13) {
          return this.filterCallback(evt);
        }
      };

      return ListFilter;

    })();
  });

}).call(this);
