// Generated by CoffeeScript 1.9.1
(function() {
  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(function() {
    var ListeEditForm;
    return ListeEditForm = (function() {
      function ListeEditForm(list1, value, form) {
        this.list = list1;
        this.value = value;
        this.form = form;
        this.hideForm = bind(this.hideForm, this);
        this.showForm = bind(this.showForm, this);
        this.close = bind(this.close, this);
        this.firstFocus = bind(this.firstFocus, this);
        this.enter = bind(this.enter, this);
        this.removeEventListenerOnInputs = bind(this.removeEventListenerOnInputs, this);
        this.addEventListenerOnInputs = bind(this.addEventListenerOnInputs, this);
        this.changed = bind(this.changed, this);
        this.cancelChange = bind(this.cancelChange, this);
        this.commitChange = bind(this.commitChange, this);
        this.cancel = bind(this.cancel, this);
        this.commit = bind(this.commit, this);
        this.inputs = this.form.querySelectorAll("input");
        this.selects = this.form.querySelectorAll("select");
        this.editionMode = true;
        this.showForm();
      }

      ListeEditForm.prototype.commit = function(evt, list) {
        return alert('edition committing to be done');
      };

      ListeEditForm.prototype.cancel = function(evt, list) {
        return list.editForm = null;
      };

      ListeEditForm.prototype.commitChange = function(evt) {
        if (!this.editionMode) {
          return;
        }
        if (evt != null) {
          evt.preventDefault();
        }
        this.close();
        if (this.changed()) {
          return this.commit(evt, this.list);
        } else {
          return this.cancel(evt, this.list);
        }
      };

      ListeEditForm.prototype.cancelChange = function(evt) {
        if (evt != null) {
          evt.preventDefault();
        }
        this.close();
        return this.cancel(evt, this.list);
      };

      ListeEditForm.prototype.changed = function() {
        var i, input, j, len, len1, new_value, old_value, ref, ref1, select;
        ref = this.inputs;
        for (i = 0, len = ref.length; i < len; i++) {
          input = ref[i];
          if (input.type === "checkbox") {
            return true;
          }
          new_value = input.value;
          old_value = input.getAttribute("value");
          if (new_value !== old_value) {
            return true;
          }
        }
        ref1 = this.selects;
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          select = ref1[j];
          new_value = select.value;
          old_value = select.getAttribute("value");
          if (new_value !== old_value) {
            return true;
          }
        }
        return false;
      };

      ListeEditForm.prototype.addEventListenerOnInputs = function() {
        var i, input, j, len, len1, ref, ref1, select;
        ref = this.inputs;
        for (i = 0, len = ref.length; i < len; i++) {
          input = ref[i];
          if (input.type === "checkbox") {
            input.addEventListener("click", this.commitChange);
            input.addEventListener("keydown", this.enter);
          } else {
            input.addEventListener("blur", this.commitChange);
            input.addEventListener("keydown", this.enter);
          }
        }
        ref1 = this.selects;
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          select = ref1[j];
          select.addEventListener("change", this.commitChange);
          select.addEventListener("keydown", this.enter);
        }
        return this.form.addEventListener("submit", this.commitChange);
      };

      ListeEditForm.prototype.removeEventListenerOnInputs = function() {
        var i, input, j, len, len1, ref, ref1, select;
        ref = this.inputs;
        for (i = 0, len = ref.length; i < len; i++) {
          input = ref[i];
          if (input.type === "checkbox") {
            input.removeEventListener("click", this.commitChange);
            input.removeEventListener("keydown", this.enter);
          } else {
            input.removeEventListener("blur", this.commitChange);
            input.removeEventListener("keydown", this.enter);
          }
        }
        ref1 = this.selects;
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          select = ref1[j];
          select.removeEventListener("change", this.commitChange);
          select.removeEventListener("keydown", this.enter);
        }
        return this.form.removeEventListener("submit", this.commitChange);
      };

      ListeEditForm.prototype.enter = function(evt) {
        if (evt.keyCode === 27) {
          evt.preventDefault();
          return this.cancelChange();
        }
      };

      ListeEditForm.prototype.firstFocus = function() {
        var input;
        input = this.form.querySelector("input");
        if (input) {
          input.focus();
          if (input.type !== "checkbox") {
            return input.select();
          }
        }
      };

      ListeEditForm.prototype.close = function() {
        this.hideForm();
        return this.editionMode = false;
      };

      ListeEditForm.prototype.showForm = function() {
        addClassName(this.value, 'hidden');
        removeClassName(this.form, 'hidden');
        return this.addEventListenerOnInputs();
      };

      ListeEditForm.prototype.hideForm = function() {
        this.removeEventListenerOnInputs();
        removeClassName(this.value, 'hidden');
        return addClassName(this.form, 'hidden');
      };

      return ListeEditForm;

    })();
  });

}).call(this);
