import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/license#id License#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/license#labels License#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/license#license_key License#license_key}
    */
    readonly licenseKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/license vsphere_license}
*/
export declare class License extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_license";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/license vsphere_license} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LicenseConfig
    */
    constructor(scope: Construct, id: string, config: LicenseConfig);
    get editionKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _licenseKey?;
    get licenseKey(): string;
    set licenseKey(value: string);
    get licenseKeyInput(): string | undefined;
    get name(): string;
    get total(): number;
    get used(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
