import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#create_directories File#create_directories}
    */
    readonly createDirectories?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#datacenter File#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#datastore File#datastore}
    */
    readonly datastore: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#destination_file File#destination_file}
    */
    readonly destinationFile: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#id File#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#source_datacenter File#source_datacenter}
    */
    readonly sourceDatacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#source_datastore File#source_datastore}
    */
    readonly sourceDatastore?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/file#source_file File#source_file}
    */
    readonly sourceFile: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/file vsphere_file}
*/
export declare class File extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/file vsphere_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileConfig
    */
    constructor(scope: Construct, id: string, config: FileConfig);
    private _createDirectories?;
    get createDirectories(): boolean | cdktf.IResolvable;
    set createDirectories(value: boolean | cdktf.IResolvable);
    resetCreateDirectories(): void;
    get createDirectoriesInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _datastore?;
    get datastore(): string;
    set datastore(value: string);
    get datastoreInput(): string | undefined;
    private _destinationFile?;
    get destinationFile(): string;
    set destinationFile(value: string);
    get destinationFileInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sourceDatacenter?;
    get sourceDatacenter(): string;
    set sourceDatacenter(value: string);
    resetSourceDatacenter(): void;
    get sourceDatacenterInput(): string | undefined;
    private _sourceDatastore?;
    get sourceDatastore(): string;
    set sourceDatastore(value: string);
    resetSourceDatastore(): void;
    get sourceDatastoreInput(): string | undefined;
    private _sourceFile?;
    get sourceFile(): string;
    set sourceFile(value: string);
    get sourceFileInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
