"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatastoreCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/datastore_cluster vsphere_datastore_cluster}
*/
class DatastoreCluster extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/datastore_cluster vsphere_datastore_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastoreClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_datastore_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.2.0',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._folder = config.folder;
        this._id = config.id;
        this._name = config.name;
        this._sdrsAdvancedOptions = config.sdrsAdvancedOptions;
        this._sdrsAutomationLevel = config.sdrsAutomationLevel;
        this._sdrsDefaultIntraVmAffinity = config.sdrsDefaultIntraVmAffinity;
        this._sdrsEnabled = config.sdrsEnabled;
        this._sdrsFreeSpaceThreshold = config.sdrsFreeSpaceThreshold;
        this._sdrsFreeSpaceThresholdMode = config.sdrsFreeSpaceThresholdMode;
        this._sdrsFreeSpaceUtilizationDifference = config.sdrsFreeSpaceUtilizationDifference;
        this._sdrsIoBalanceAutomationLevel = config.sdrsIoBalanceAutomationLevel;
        this._sdrsIoLatencyThreshold = config.sdrsIoLatencyThreshold;
        this._sdrsIoLoadBalanceEnabled = config.sdrsIoLoadBalanceEnabled;
        this._sdrsIoLoadImbalanceThreshold = config.sdrsIoLoadImbalanceThreshold;
        this._sdrsIoReservableIopsThreshold = config.sdrsIoReservableIopsThreshold;
        this._sdrsIoReservablePercentThreshold = config.sdrsIoReservablePercentThreshold;
        this._sdrsIoReservableThresholdMode = config.sdrsIoReservableThresholdMode;
        this._sdrsLoadBalanceInterval = config.sdrsLoadBalanceInterval;
        this._sdrsPolicyEnforcementAutomationLevel = config.sdrsPolicyEnforcementAutomationLevel;
        this._sdrsRuleEnforcementAutomationLevel = config.sdrsRuleEnforcementAutomationLevel;
        this._sdrsSpaceBalanceAutomationLevel = config.sdrsSpaceBalanceAutomationLevel;
        this._sdrsSpaceUtilizationThreshold = config.sdrsSpaceUtilizationThreshold;
        this._sdrsVmEvacuationAutomationLevel = config.sdrsVmEvacuationAutomationLevel;
        this._tags = config.tags;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get sdrsAdvancedOptions() {
        return this.getStringMapAttribute('sdrs_advanced_options');
    }
    set sdrsAdvancedOptions(value) {
        this._sdrsAdvancedOptions = value;
    }
    resetSdrsAdvancedOptions() {
        this._sdrsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsAdvancedOptionsInput() {
        return this._sdrsAdvancedOptions;
    }
    get sdrsAutomationLevel() {
        return this.getStringAttribute('sdrs_automation_level');
    }
    set sdrsAutomationLevel(value) {
        this._sdrsAutomationLevel = value;
    }
    resetSdrsAutomationLevel() {
        this._sdrsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsAutomationLevelInput() {
        return this._sdrsAutomationLevel;
    }
    get sdrsDefaultIntraVmAffinity() {
        return this.getBooleanAttribute('sdrs_default_intra_vm_affinity');
    }
    set sdrsDefaultIntraVmAffinity(value) {
        this._sdrsDefaultIntraVmAffinity = value;
    }
    resetSdrsDefaultIntraVmAffinity() {
        this._sdrsDefaultIntraVmAffinity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsDefaultIntraVmAffinityInput() {
        return this._sdrsDefaultIntraVmAffinity;
    }
    get sdrsEnabled() {
        return this.getBooleanAttribute('sdrs_enabled');
    }
    set sdrsEnabled(value) {
        this._sdrsEnabled = value;
    }
    resetSdrsEnabled() {
        this._sdrsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsEnabledInput() {
        return this._sdrsEnabled;
    }
    get sdrsFreeSpaceThreshold() {
        return this.getNumberAttribute('sdrs_free_space_threshold');
    }
    set sdrsFreeSpaceThreshold(value) {
        this._sdrsFreeSpaceThreshold = value;
    }
    resetSdrsFreeSpaceThreshold() {
        this._sdrsFreeSpaceThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceThresholdInput() {
        return this._sdrsFreeSpaceThreshold;
    }
    get sdrsFreeSpaceThresholdMode() {
        return this.getStringAttribute('sdrs_free_space_threshold_mode');
    }
    set sdrsFreeSpaceThresholdMode(value) {
        this._sdrsFreeSpaceThresholdMode = value;
    }
    resetSdrsFreeSpaceThresholdMode() {
        this._sdrsFreeSpaceThresholdMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceThresholdModeInput() {
        return this._sdrsFreeSpaceThresholdMode;
    }
    get sdrsFreeSpaceUtilizationDifference() {
        return this.getNumberAttribute('sdrs_free_space_utilization_difference');
    }
    set sdrsFreeSpaceUtilizationDifference(value) {
        this._sdrsFreeSpaceUtilizationDifference = value;
    }
    resetSdrsFreeSpaceUtilizationDifference() {
        this._sdrsFreeSpaceUtilizationDifference = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsFreeSpaceUtilizationDifferenceInput() {
        return this._sdrsFreeSpaceUtilizationDifference;
    }
    get sdrsIoBalanceAutomationLevel() {
        return this.getStringAttribute('sdrs_io_balance_automation_level');
    }
    set sdrsIoBalanceAutomationLevel(value) {
        this._sdrsIoBalanceAutomationLevel = value;
    }
    resetSdrsIoBalanceAutomationLevel() {
        this._sdrsIoBalanceAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoBalanceAutomationLevelInput() {
        return this._sdrsIoBalanceAutomationLevel;
    }
    get sdrsIoLatencyThreshold() {
        return this.getNumberAttribute('sdrs_io_latency_threshold');
    }
    set sdrsIoLatencyThreshold(value) {
        this._sdrsIoLatencyThreshold = value;
    }
    resetSdrsIoLatencyThreshold() {
        this._sdrsIoLatencyThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLatencyThresholdInput() {
        return this._sdrsIoLatencyThreshold;
    }
    get sdrsIoLoadBalanceEnabled() {
        return this.getBooleanAttribute('sdrs_io_load_balance_enabled');
    }
    set sdrsIoLoadBalanceEnabled(value) {
        this._sdrsIoLoadBalanceEnabled = value;
    }
    resetSdrsIoLoadBalanceEnabled() {
        this._sdrsIoLoadBalanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLoadBalanceEnabledInput() {
        return this._sdrsIoLoadBalanceEnabled;
    }
    get sdrsIoLoadImbalanceThreshold() {
        return this.getNumberAttribute('sdrs_io_load_imbalance_threshold');
    }
    set sdrsIoLoadImbalanceThreshold(value) {
        this._sdrsIoLoadImbalanceThreshold = value;
    }
    resetSdrsIoLoadImbalanceThreshold() {
        this._sdrsIoLoadImbalanceThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoLoadImbalanceThresholdInput() {
        return this._sdrsIoLoadImbalanceThreshold;
    }
    get sdrsIoReservableIopsThreshold() {
        return this.getNumberAttribute('sdrs_io_reservable_iops_threshold');
    }
    set sdrsIoReservableIopsThreshold(value) {
        this._sdrsIoReservableIopsThreshold = value;
    }
    resetSdrsIoReservableIopsThreshold() {
        this._sdrsIoReservableIopsThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservableIopsThresholdInput() {
        return this._sdrsIoReservableIopsThreshold;
    }
    get sdrsIoReservablePercentThreshold() {
        return this.getNumberAttribute('sdrs_io_reservable_percent_threshold');
    }
    set sdrsIoReservablePercentThreshold(value) {
        this._sdrsIoReservablePercentThreshold = value;
    }
    resetSdrsIoReservablePercentThreshold() {
        this._sdrsIoReservablePercentThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservablePercentThresholdInput() {
        return this._sdrsIoReservablePercentThreshold;
    }
    get sdrsIoReservableThresholdMode() {
        return this.getStringAttribute('sdrs_io_reservable_threshold_mode');
    }
    set sdrsIoReservableThresholdMode(value) {
        this._sdrsIoReservableThresholdMode = value;
    }
    resetSdrsIoReservableThresholdMode() {
        this._sdrsIoReservableThresholdMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsIoReservableThresholdModeInput() {
        return this._sdrsIoReservableThresholdMode;
    }
    get sdrsLoadBalanceInterval() {
        return this.getNumberAttribute('sdrs_load_balance_interval');
    }
    set sdrsLoadBalanceInterval(value) {
        this._sdrsLoadBalanceInterval = value;
    }
    resetSdrsLoadBalanceInterval() {
        this._sdrsLoadBalanceInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsLoadBalanceIntervalInput() {
        return this._sdrsLoadBalanceInterval;
    }
    get sdrsPolicyEnforcementAutomationLevel() {
        return this.getStringAttribute('sdrs_policy_enforcement_automation_level');
    }
    set sdrsPolicyEnforcementAutomationLevel(value) {
        this._sdrsPolicyEnforcementAutomationLevel = value;
    }
    resetSdrsPolicyEnforcementAutomationLevel() {
        this._sdrsPolicyEnforcementAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsPolicyEnforcementAutomationLevelInput() {
        return this._sdrsPolicyEnforcementAutomationLevel;
    }
    get sdrsRuleEnforcementAutomationLevel() {
        return this.getStringAttribute('sdrs_rule_enforcement_automation_level');
    }
    set sdrsRuleEnforcementAutomationLevel(value) {
        this._sdrsRuleEnforcementAutomationLevel = value;
    }
    resetSdrsRuleEnforcementAutomationLevel() {
        this._sdrsRuleEnforcementAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsRuleEnforcementAutomationLevelInput() {
        return this._sdrsRuleEnforcementAutomationLevel;
    }
    get sdrsSpaceBalanceAutomationLevel() {
        return this.getStringAttribute('sdrs_space_balance_automation_level');
    }
    set sdrsSpaceBalanceAutomationLevel(value) {
        this._sdrsSpaceBalanceAutomationLevel = value;
    }
    resetSdrsSpaceBalanceAutomationLevel() {
        this._sdrsSpaceBalanceAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsSpaceBalanceAutomationLevelInput() {
        return this._sdrsSpaceBalanceAutomationLevel;
    }
    get sdrsSpaceUtilizationThreshold() {
        return this.getNumberAttribute('sdrs_space_utilization_threshold');
    }
    set sdrsSpaceUtilizationThreshold(value) {
        this._sdrsSpaceUtilizationThreshold = value;
    }
    resetSdrsSpaceUtilizationThreshold() {
        this._sdrsSpaceUtilizationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsSpaceUtilizationThresholdInput() {
        return this._sdrsSpaceUtilizationThreshold;
    }
    get sdrsVmEvacuationAutomationLevel() {
        return this.getStringAttribute('sdrs_vm_evacuation_automation_level');
    }
    set sdrsVmEvacuationAutomationLevel(value) {
        this._sdrsVmEvacuationAutomationLevel = value;
    }
    resetSdrsVmEvacuationAutomationLevel() {
        this._sdrsVmEvacuationAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sdrsVmEvacuationAutomationLevelInput() {
        return this._sdrsVmEvacuationAutomationLevel;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            folder: cdktf.stringToTerraform(this._folder),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            sdrs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._sdrsAdvancedOptions),
            sdrs_automation_level: cdktf.stringToTerraform(this._sdrsAutomationLevel),
            sdrs_default_intra_vm_affinity: cdktf.booleanToTerraform(this._sdrsDefaultIntraVmAffinity),
            sdrs_enabled: cdktf.booleanToTerraform(this._sdrsEnabled),
            sdrs_free_space_threshold: cdktf.numberToTerraform(this._sdrsFreeSpaceThreshold),
            sdrs_free_space_threshold_mode: cdktf.stringToTerraform(this._sdrsFreeSpaceThresholdMode),
            sdrs_free_space_utilization_difference: cdktf.numberToTerraform(this._sdrsFreeSpaceUtilizationDifference),
            sdrs_io_balance_automation_level: cdktf.stringToTerraform(this._sdrsIoBalanceAutomationLevel),
            sdrs_io_latency_threshold: cdktf.numberToTerraform(this._sdrsIoLatencyThreshold),
            sdrs_io_load_balance_enabled: cdktf.booleanToTerraform(this._sdrsIoLoadBalanceEnabled),
            sdrs_io_load_imbalance_threshold: cdktf.numberToTerraform(this._sdrsIoLoadImbalanceThreshold),
            sdrs_io_reservable_iops_threshold: cdktf.numberToTerraform(this._sdrsIoReservableIopsThreshold),
            sdrs_io_reservable_percent_threshold: cdktf.numberToTerraform(this._sdrsIoReservablePercentThreshold),
            sdrs_io_reservable_threshold_mode: cdktf.stringToTerraform(this._sdrsIoReservableThresholdMode),
            sdrs_load_balance_interval: cdktf.numberToTerraform(this._sdrsLoadBalanceInterval),
            sdrs_policy_enforcement_automation_level: cdktf.stringToTerraform(this._sdrsPolicyEnforcementAutomationLevel),
            sdrs_rule_enforcement_automation_level: cdktf.stringToTerraform(this._sdrsRuleEnforcementAutomationLevel),
            sdrs_space_balance_automation_level: cdktf.stringToTerraform(this._sdrsSpaceBalanceAutomationLevel),
            sdrs_space_utilization_threshold: cdktf.numberToTerraform(this._sdrsSpaceUtilizationThreshold),
            sdrs_vm_evacuation_automation_level: cdktf.stringToTerraform(this._sdrsVmEvacuationAutomationLevel),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
        };
    }
}
exports.DatastoreCluster = DatastoreCluster;
_a = JSII_RTTI_SYMBOL_1;
DatastoreCluster[_a] = { fqn: "@cdktf/provider-vsphere.datastoreCluster.DatastoreCluster", version: "1.0.1" };
// =================
// STATIC PROPERTIES
// =================
DatastoreCluster.tfResourceType = "vsphere_datastore_cluster";
//# sourceMappingURL=data:application/json;base64,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