# An rMQR Code Generator
![reop-url](https://user-images.githubusercontent.com/14174940/172978619-accbf9d0-9dd8-4b19-b47e-ad139a68dcc9.png)


This is an rMQR Code image generator implemented in Python. This is implemented based on [ISO/IEC 23941:2022](https://www.iso.org/standard/77404.html).

## Important Notice
Please verify an image generated by this software whether it can decode correctly before use.

## Basic Usage
```py
from rmqrcode import rMQR
import rmqrcode

data = "https://oudon.xyz"
qr = rMQR.fit(
    data,
    ecc=rmqrcode.ErrorCorrectionLevel.M,
    fit_strategy=rmqrcode.FitStrategy.MINIMIZE_WIDTH
)
```

The `ecc` parameter is an enum value of rmqrcode.ErrorCorrectionLevel to select error correction level. The following values are available:
- **`ErrorCorrectionLevel.M`**: Approx. 15% Recovery Capacity.
- **`ErrorCorrectionLevel.H`**: Approx. 30% Recovery Capacity.

The `fit_strategy` parameter is enum value of rmqrcode.FitStrategy to specify how to determine size of rMQR Code. The following values are available:
- **`FitStrategy.MINIMIZE_WIDTH`**: Try to minimize width.
- **`FitStrategy.MINIMIZE_HEIGHT`**: Try to minimize height.
- **`FitStrategy.BALANCED`**: Try to keep balance of width and height.

Here is an example of images genereated by each fit strategies for data `Test test test`:
![Example of fit strategies](https://user-images.githubusercontent.com/14174940/172822478-4f2b5fb8-49bd-464f-b6b2-c7347f71cbf5.png)

## Advanced Usage
### Select rMQR Code size manually
To select rMQR Code size manually, use `rMQR()` constructor.
```py
qr = rMQR('R11x139', ErrorCorrectionLevel.H)
qr.make("https://oudon.xyz")
```

----
The word "QR Code" is registered trademark of DENSO WAVE Incorporated.<br>
http://www.denso-wave.com/qrcode/faqpatent-e.html
