# Copyright 2022 Bhargav KN
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================

"""
Initialize model dependencies
"""

from __future__ import annotations

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from dore.context.dore_context import DoreContext

from dore.model.model_dependency_graph_factory import model_dependency_graph_factory

def initialize_model_dependencies(context: DoreContext) -> None:
    """
    Initialize model dependencies
    """

    model_dependency_graph = model_dependency_graph_factory(context.model_container())
    context.set_model_dependency_graph(model_dependency_graph)
