from typing import List, Optional, Dict, Tuple, Union
from pydantic import BaseModel



class DatapipeServerInfoDO(BaseModel):
    id: str
    secret: str
    endpoint: str



class DatapipeDataInfoDO(BaseModel):
    bucket: str
    remote_path: str
    local_path: str
    timeout: int = 3



class ClusterConfigDataDO(BaseModel):
    data_server: DatapipeServerInfoDO
    data: List[DatapipeDataInfoDO]



class ClusterConfigDO(BaseModel):
    cluster_name: str
    region_id: str
    config_data: Optional[ClusterConfigDataDO] = None
    entry_point: Optional[List[str]] = None
    timeout: int = 20



class BootstrapDO(BaseModel):
    cluster_config: ClusterConfigDO
    template: str = 'normal'
    platform: str = 'aliyun'
    patch_setting: Optional[Dict] = None