/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 *     
 */

#include "sipAPI_core.h"

        #include <wx/unichar.h>



PyDoc_STRVAR(doc_wxUniChar_GetValue, "GetValue() -> value_type\n"
"\n"
"Returns Unicode code point value of the character.");

extern "C" {static PyObject *meth_wxUniChar_GetValue(PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_GetValue(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
             ::wxUniChar::value_type sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetValue();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_GetValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_IsAscii, "IsAscii() -> bool\n"
"\n"
"Returns true if the character is an ASCII character (i.e. if its value\n"
"is less than 128).");

extern "C" {static PyObject *meth_wxUniChar_IsAscii(PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_IsAscii(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsAscii();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_IsAscii, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_GetAsChar, "GetAsChar(c) -> bool\n"
"\n"
"Returns true if the character is representable as a single byte in the\n"
"current locale encoding.");

extern "C" {static PyObject *meth_wxUniChar_GetAsChar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_GetAsChar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char* c;
        const  ::wxUniChar *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bs", &sipSelf, sipType_wxUniChar, &sipCpp, &c))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAsChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_GetAsChar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_IsBMP, "IsBMP() -> bool\n"
"IsBMP(value) -> bool\n"
"\n"
"Returns true if the character is a BMP character (i.e. if its value is\n"
"less than 0x10000).\n"
"");

extern "C" {static PyObject *meth_wxUniChar_IsBMP(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_IsBMP(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsBMP();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxUint32 value;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "u", &value))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxUniChar::IsBMP(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_IsBMP, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_IsSupplementary, "IsSupplementary() -> bool\n"
"IsSupplementary(value) -> bool\n"
"\n"
"Returns true if the character is a supplementary character (i.e.\n"
"between 0x10000 and 0x10FFFF).\n"
"");

extern "C" {static PyObject *meth_wxUniChar_IsSupplementary(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_IsSupplementary(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSupplementary();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::wxUint32 value;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "u", &value))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxUniChar::IsSupplementary(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_IsSupplementary, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_HighSurrogate, "HighSurrogate() -> Uint16\n"
"HighSurrogate(value) -> Uint16\n"
"\n"
"Returns the high surrogate code unit for the supplementary character.\n"
"");

extern "C" {static PyObject *meth_wxUniChar_HighSurrogate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_HighSurrogate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
             ::wxUint16 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HighSurrogate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
         ::wxUint32 value;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "u", &value))
        {
             ::wxUint16 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxUniChar::HighSurrogate(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_HighSurrogate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUniChar_LowSurrogate, "LowSurrogate() -> Uint16\n"
"LowSurrogate(value) -> Uint16\n"
"\n"
"Returns the low surrogate code unit for the supplementary character.\n"
"");

extern "C" {static PyObject *meth_wxUniChar_LowSurrogate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUniChar_LowSurrogate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxUniChar *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxUniChar, &sipCpp))
        {
             ::wxUint16 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LowSurrogate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
         ::wxUint32 value;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "u", &value))
        {
             ::wxUint16 sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxUniChar::LowSurrogate(value);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UniChar, sipName_LowSurrogate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxUniChar(void *, int);}
static void release_wxUniChar(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxUniChar *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxUniChar(void *, Py_ssize_t, void *);}
static void assign_wxUniChar(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxUniChar *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxUniChar *>(sipSrc);
}


extern "C" {static void *copy_wxUniChar(const void *, Py_ssize_t);}
static void *copy_wxUniChar(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxUniChar(reinterpret_cast<const  ::wxUniChar *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxUniChar(sipSimpleWrapper *);}
static void dealloc_wxUniChar(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxUniChar(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxUniChar(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxUniChar(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxUniChar *sipCpp = SIP_NULLPTR;

    {
        long c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "l", &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        unsigned long c;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "m", &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxUniChar* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxUniChar, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxUniChar(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxUniChar[] = {
    {sipName_GetAsChar, SIP_MLMETH_CAST(meth_wxUniChar_GetAsChar), METH_VARARGS|METH_KEYWORDS, doc_wxUniChar_GetAsChar},
    {sipName_GetValue, meth_wxUniChar_GetValue, METH_VARARGS, doc_wxUniChar_GetValue},
    {sipName_HighSurrogate, SIP_MLMETH_CAST(meth_wxUniChar_HighSurrogate), METH_VARARGS|METH_KEYWORDS, doc_wxUniChar_HighSurrogate},
    {sipName_IsAscii, meth_wxUniChar_IsAscii, METH_VARARGS, doc_wxUniChar_IsAscii},
    {sipName_IsBMP, SIP_MLMETH_CAST(meth_wxUniChar_IsBMP), METH_VARARGS|METH_KEYWORDS, doc_wxUniChar_IsBMP},
    {sipName_IsSupplementary, SIP_MLMETH_CAST(meth_wxUniChar_IsSupplementary), METH_VARARGS|METH_KEYWORDS, doc_wxUniChar_IsSupplementary},
    {sipName_LowSurrogate, SIP_MLMETH_CAST(meth_wxUniChar_LowSurrogate), METH_VARARGS|METH_KEYWORDS, doc_wxUniChar_LowSurrogate}
};

sipVariableDef variables_wxUniChar[] = {
    {PropertyVariable, sipName_Value, &methods_wxUniChar[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxUniChar, "UniChar(c)\n"
"UniChar(c)\n"
"\n"
"This class represents a single Unicode character.");


sipClassTypeDef sipTypeDef__core_wxUniChar = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxUniChar,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_UniChar,
        {0, 0, 1},
        7, methods_wxUniChar,
        0, SIP_NULLPTR,
        1, variables_wxUniChar,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxUniChar,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxUniChar,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxUniChar,
    assign_wxUniChar,
    SIP_NULLPTR,
    copy_wxUniChar,
    release_wxUniChar,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
