/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 *     
 */

#include "sipAPI_core.h"

        #include <wx/stream.h>

        #include <wx/stream.h>
        //--------------------------------------------------------------------------
        
        static PyObject* wxPyGetMethod(PyObject* py, char* name)
        {
            if (!PyObject_HasAttrString(py, name))
                return NULL;
            PyObject* o = PyObject_GetAttrString(py, name);
            if (!PyMethod_Check(o) && !PyCFunction_Check(o)) {
                Py_DECREF(o);
                return NULL;
            }
            return o;
        }
        
        #define wxPyBlock_t_default PyGILState_UNLOCKED
        
        
        // This class can wrap a Python file-like object and allow it to be used
        // as a wxInputStream.
        class wxPyInputStream : public wxInputStream
        {
        public:
        
            // Make sure there is at least a read method
            static bool Check(PyObject* fileObj)
            {
                PyObject* method = wxPyGetMethod(fileObj, "read");
                bool rval = method != NULL;
                Py_XDECREF(method);
                return rval;
            }
        
            wxPyInputStream(PyObject* fileObj, bool block=true)
            {
                m_block = block;
                wxPyThreadBlocker blocker(m_block);
        
                m_read = wxPyGetMethod(fileObj, "read");
                m_seek = wxPyGetMethod(fileObj, "seek");
                m_tell = wxPyGetMethod(fileObj, "tell");
            }
        
            virtual ~wxPyInputStream()
            {
                wxPyThreadBlocker blocker(m_block);
                Py_XDECREF(m_read);
                Py_XDECREF(m_seek);
                Py_XDECREF(m_tell);
            }
        
            wxPyInputStream(const wxPyInputStream& other)
            {
                wxPyThreadBlocker blocker;
                m_read  = other.m_read;
                m_seek  = other.m_seek;
                m_tell  = other.m_tell;
                m_block = other.m_block;
                Py_INCREF(m_read);
                Py_INCREF(m_seek);
                Py_INCREF(m_tell);
            }
        
        protected:
        
            // implement base class virtuals
        
            wxFileOffset GetLength() const
            {
                wxPyInputStream* self = (wxPyInputStream*)this; // cast off const
                if (m_seek && m_tell) {
                    wxFileOffset temp = self->OnSysTell();
                    wxFileOffset ret = self->OnSysSeek(0, wxFromEnd);
                    self->OnSysSeek(temp, wxFromStart);
                    return ret;
                }
                else
                    return wxInvalidOffset;
            }
        
            size_t OnSysRead(void *buffer, size_t bufsize)
            {
                if (bufsize == 0)
                    return 0;
        
                wxPyThreadBlocker blocker;
                PyObject* arglist = Py_BuildValue("(i)", bufsize);
                PyObject* result = PyEval_CallObject(m_read, arglist);
                Py_DECREF(arglist);
        
                size_t o = 0;
                if ((result != NULL) && PyBytes_Check(result)) {
                    o = PyBytes_Size(result);
                    if (o == 0)
                        m_lasterror = wxSTREAM_EOF;
                    if (o > bufsize)
                        o = bufsize;
                    memcpy((char*)buffer, PyBytes_AsString(result), o);  // strings only, not unicode...
                    Py_DECREF(result);
                }
                else
                    m_lasterror = wxSTREAM_READ_ERROR;
                return o;
            }
        
            size_t OnSysWrite(const void *buffer, size_t bufsize)
            {
                m_lasterror = wxSTREAM_WRITE_ERROR;
                return 0;
            }
        
            wxFileOffset OnSysSeek(wxFileOffset off, wxSeekMode mode)
            {
                wxPyThreadBlocker blocker;
                PyObject* arglist = PyTuple_New(2);
        
                if (sizeof(wxFileOffset) > sizeof(long))
                    // wxFileOffset is a 64-bit value...
                    PyTuple_SET_ITEM(arglist, 0, PyLong_FromLongLong(off));
                else
                    PyTuple_SET_ITEM(arglist, 0, wxPyInt_FromLong(off));
        
                PyTuple_SET_ITEM(arglist, 1, wxPyInt_FromLong(mode));
        
        
                PyObject* result = PyEval_CallObject(m_seek, arglist);
                Py_DECREF(arglist);
                Py_XDECREF(result);
                return OnSysTell();
            }
        
            wxFileOffset OnSysTell() const
            {
                wxPyThreadBlocker blocker;
                PyObject* arglist = Py_BuildValue("()");
                PyObject* result = PyEval_CallObject(m_tell, arglist);
                Py_DECREF(arglist);
                wxFileOffset o = 0;
                if (result != NULL) {
                    if (PyLong_Check(result))
                        o = PyLong_AsLongLong(result);
                    else
                        o = wxPyInt_AsLong(result);
                    Py_DECREF(result);
                };
                return o;
            }
        
            bool IsSeekable() const
            {
                return (m_seek != NULL);
            }
        
        
        private:
            PyObject* m_read;
            PyObject* m_seek;
            PyObject* m_tell;
            bool      m_block;
        };
        
        //--------------------------------------------------------------------------
        // helper used by the read and readline methods to make a PyObject
        static PyObject* _makeReadBufObj(wxInputStream* self, wxMemoryBuffer& buf) {
            PyObject* obj = NULL;
        
            wxPyThreadBlocker blocker;
            wxStreamError err = self->GetLastError();  // error check
            if (err != wxSTREAM_NO_ERROR && err != wxSTREAM_EOF) {
                PyErr_SetString(PyExc_IOError,"IOError in wxInputStream");
            }
            else {
                // Return the data as a string object.  TODO: Py3
                obj = PyBytes_FromStringAndSize(buf, buf.GetDataLen());
            }
            return obj;
        }
        PyObject* _wxInputStream_readline(wxInputStream* self);
        
        // This does the real work of the readlines methods
        static PyObject* _readlinesHelper(wxInputStream* self,
                                          bool useSizeHint=false, ulong sizehint=0) {
            PyObject* pylist;
        
            // init list
            {
                wxPyThreadBlocker blocker;
                pylist = PyList_New(0);
        
                if (!pylist) {
                    PyErr_NoMemory();
                    return NULL;
                }
            }
        
            // read sizehint bytes or until EOF
            ulong i;
            for (i=0; (self->CanRead()) && (useSizeHint || (i < sizehint));) {
                PyObject* s = _wxInputStream_readline(self);
                if (s == NULL) {
                    wxPyThreadBlocker blocker;
                    Py_DECREF(pylist);
                    return NULL;
                }
                wxPyThreadBlocker blocker;
                PyList_Append(pylist, s);
                i += PyBytes_Size(s);
            }
        
            // error check
            wxStreamError err = self->GetLastError();
            if (err != wxSTREAM_NO_ERROR && err != wxSTREAM_EOF) {
                wxPyThreadBlocker blocker;
                Py_DECREF(pylist);
                PyErr_SetString(PyExc_IOError,"IOError in wxInputStream");
                return NULL;
            }
            return pylist;
        }
    void _wxInputStream_seek(wxInputStream* self, wxFileOffset offset, int whence)
    {
        self->SeekI(offset, (wxSeekMode)whence);
    }
    wxFileOffset _wxInputStream_tell(wxInputStream* self)
    {
        return self->TellI();
    }
    void _wxInputStream_close(wxInputStream* self)
    {
        // ignored for now
    }
    void _wxInputStream_flush(wxInputStream* self)
    {
        // ignored for now
    }
    bool _wxInputStream_eof(wxInputStream* self)
    {
        return self->Eof();
    }
    PyObject* _wxInputStream_read(wxInputStream* self)
    {
        wxMemoryBuffer buf;
        const ulong BUFSIZE = 1024;
        
        // read while bytes are available on the stream
        while ( self->CanRead() ) {
            self->Read(buf.GetAppendBuf(BUFSIZE), BUFSIZE);
            buf.UngetAppendBuf(self->LastRead());
        }
        return _makeReadBufObj(self, buf);
    }
    PyObject* _wxInputStream_read(wxInputStream* self, ulong size)
    {
        wxMemoryBuffer buf;
        
        // Read only size number of characters
        self->Read(buf.GetWriteBuf(size), size);
        buf.UngetWriteBuf(self->LastRead());
        return _makeReadBufObj(self, buf);
    }
    PyObject* _wxInputStream_readline(wxInputStream* self)
    {
        wxMemoryBuffer buf;
        char ch = 0;
        
        // read until \n
        while ((ch != '\n') && (self->CanRead())) {
            ch = self->GetC();
            buf.AppendByte(ch);
        }
        return _makeReadBufObj(self, buf);
    }
    PyObject* _wxInputStream_readline(wxInputStream* self, ulong size)
    {
        wxMemoryBuffer buf;
        int i;
        char ch;
        
        // read until \n or byte limit reached
        for (i=ch=0; (ch != '\n') && (self->CanRead()) && (i < size); i++) {
            ch = self->GetC();
            buf.AppendByte(ch);
        }
        return _makeReadBufObj(self, buf);
    }
    PyObject* _wxInputStream_readlines(wxInputStream* self)
    {
        return _readlinesHelper(self);
    }
    PyObject* _wxInputStream_readlines(wxInputStream* self, ulong sizehint)
    {
        return _readlinesHelper(self, true, sizehint);
    }


PyDoc_STRVAR(doc_wxInputStream_CanRead, "CanRead() -> bool\n"
"\n"
"Returns true if some data is available in the stream right now, so\n"
"that calling Read() wouldn't block.");

extern "C" {static PyObject *meth_wxInputStream_CanRead(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_CanRead(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CanRead();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_CanRead, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_Eof, "Eof() -> bool\n"
"\n"
"Returns true after an attempt has been made to read past the end of\n"
"the stream.");

extern "C" {static PyObject *meth_wxInputStream_Eof(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_Eof(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Eof();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_Eof, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_GetC, "GetC() -> int\n"
"\n"
"Returns the first character in the input queue and removes it,\n"
"blocking until it appears if necessary.");

extern "C" {static PyObject *meth_wxInputStream_GetC(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_GetC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetC();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_GetC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_LastRead, "LastRead() -> size_t\n"
"\n"
"Returns the last number of bytes read.");

extern "C" {static PyObject *meth_wxInputStream_LastRead(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_LastRead(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LastRead();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_LastRead, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_Peek, "Peek() -> char\n"
"\n"
"Returns the first character in the input queue without removing it.");

extern "C" {static PyObject *meth_wxInputStream_Peek(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_Peek(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            char sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Peek();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBytes_FromStringAndSize(&sipRes,1);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_Peek, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_Read, "Read(buffer, size) -> InputStream\n"
"Read(stream_out) -> InputStream\n"
"\n"
"Reads the specified amount of bytes and stores the data in buffer.\n"
"");

extern "C" {static PyObject *meth_wxInputStream_Read(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_Read(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        void* buffer;
        size_t size;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv=", &sipSelf, sipType_wxInputStream, &sipCpp, &buffer, &size))
        {
             ::wxInputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Read(buffer,size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxInputStream,SIP_NULLPTR);
        }
    }

    {
         ::wxOutputStream* stream_out;
        int stream_outState = 0;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream_out,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxInputStream, &sipCpp, sipType_wxOutputStream, &stream_out, &stream_outState))
        {
             ::wxInputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Read(*stream_out);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream_out, sipType_wxOutputStream, stream_outState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxInputStream,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_Read, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_ReadAll, "ReadAll(buffer, size) -> bool\n"
"\n"
"Reads exactly the specified number of bytes into the buffer.");

extern "C" {static PyObject *meth_wxInputStream_ReadAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_ReadAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        void* buffer;
        size_t size;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv=", &sipSelf, sipType_wxInputStream, &sipCpp, &buffer, &size))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReadAll(buffer,size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_ReadAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_SeekI, "SeekI(pos, mode=FromStart) -> FileOffset\n"
"\n"
"Changes the stream current position.");

extern "C" {static PyObject *meth_wxInputStream_SeekI(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_SeekI(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFileOffset pos;
         ::wxSeekMode mode = wxFromStart;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|E", &sipSelf, sipType_wxInputStream, &sipCpp, &pos, sipType_wxSeekMode, &mode))
        {
             ::wxFileOffset sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SeekI(pos,mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_SeekI, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_TellI, "TellI() -> FileOffset\n"
"\n"
"Returns the current stream position or wxInvalidOffset if it's not\n"
"available (e.g.");

extern "C" {static PyObject *meth_wxInputStream_TellI(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_TellI(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
             ::wxFileOffset sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->TellI();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_TellI, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_Ungetch, "Ungetch(buffer, size) -> size_t\n"
"Ungetch(c) -> bool\n"
"\n"
"This function is only useful in read mode.\n"
"");

extern "C" {static PyObject *meth_wxInputStream_Ungetch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_Ungetch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* buffer;
        size_t size;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv=", &sipSelf, sipType_wxInputStream, &sipCpp, &buffer, &size))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Ungetch(buffer,size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        char c;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bc", &sipSelf, sipType_wxInputStream, &sipCpp, &c))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Ungetch(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_Ungetch, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_seek, "seek(offset, whence=0)");

extern "C" {static PyObject *meth_wxInputStream_seek(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_seek(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxFileOffset offset;
        int whence = 0;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_offset,
            sipName_whence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|i", &sipSelf, sipType_wxInputStream, &sipCpp, &offset, &whence))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxInputStream_seek(sipCpp, offset, whence);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_seek, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_tell, "tell() -> FileOffset");

extern "C" {static PyObject *meth_wxInputStream_tell(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_tell(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
             ::wxFileOffset sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_tell(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_tell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_close, "close()");

extern "C" {static PyObject *meth_wxInputStream_close(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_close(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxInputStream_close(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_close, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_flush, "flush()");

extern "C" {static PyObject *meth_wxInputStream_flush(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_flush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxInputStream_flush(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_flush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_eof, "eof() -> bool");

extern "C" {static PyObject *meth_wxInputStream_eof(PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_eof(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_eof(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_eof, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_read, "read() -> PyObject\n"
"read(size) -> PyObject\n"
"");

extern "C" {static PyObject *meth_wxInputStream_read(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_read(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_read(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
         ::ulong size;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxInputStream, &sipCpp, &size))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_read(sipCpp, size);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_read, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_readline, "readline() -> PyObject\n"
"readline(size) -> PyObject\n"
"");

extern "C" {static PyObject *meth_wxInputStream_readline(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_readline(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_readline(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
         ::ulong size;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxInputStream, &sipCpp, &size))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_readline(sipCpp, size);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_readline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInputStream_readlines, "readlines() -> PyObject\n"
"readlines(sizehint) -> PyObject\n"
"");

extern "C" {static PyObject *meth_wxInputStream_readlines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInputStream_readlines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxInputStream *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxInputStream, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_readlines(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    {
         ::ulong sizehint;
         ::wxInputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sizehint,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bm", &sipSelf, sipType_wxInputStream, &sipCpp, &sizehint))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxInputStream_readlines(sipCpp, sizehint);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_InputStream, sipName_readlines, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxInputStream(void *, const sipTypeDef *);}
static void *cast_wxInputStream(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxInputStream *sipCpp = reinterpret_cast< ::wxInputStream *>(sipCppV);

    if (targetType == sipType_wxStreamBase)
        return static_cast< ::wxStreamBase *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxInputStream(void *, int);}
static void release_wxInputStream(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxInputStream *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxInputStream(sipSimpleWrapper *);}
static void dealloc_wxInputStream(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxInputStream(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static int convertTo_wxInputStream(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxInputStream(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
     ::wxInputStream **sipCppPtr = reinterpret_cast< ::wxInputStream **>(sipCppPtrV);

        // is it just a typecheck?
        if (!sipIsErr) {
            if (wxPyInputStream::Check(sipPy))
                return 1;
            return 0;
        }
        // otherwise do the conversion
        *sipCppPtr = new wxPyInputStream(sipPy);
        return 0; //sipGetState(sipTransferObj);
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxInputStream[] = {{530, 255, 1}};


static PyMethodDef methods_wxInputStream[] = {
    {sipName_CanRead, meth_wxInputStream_CanRead, METH_VARARGS, doc_wxInputStream_CanRead},
    {sipName_Eof, meth_wxInputStream_Eof, METH_VARARGS, doc_wxInputStream_Eof},
    {sipName_GetC, meth_wxInputStream_GetC, METH_VARARGS, doc_wxInputStream_GetC},
    {sipName_LastRead, meth_wxInputStream_LastRead, METH_VARARGS, doc_wxInputStream_LastRead},
    {sipName_Peek, meth_wxInputStream_Peek, METH_VARARGS, doc_wxInputStream_Peek},
    {sipName_Read, SIP_MLMETH_CAST(meth_wxInputStream_Read), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_Read},
    {sipName_ReadAll, SIP_MLMETH_CAST(meth_wxInputStream_ReadAll), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_ReadAll},
    {sipName_SeekI, SIP_MLMETH_CAST(meth_wxInputStream_SeekI), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_SeekI},
    {sipName_TellI, meth_wxInputStream_TellI, METH_VARARGS, doc_wxInputStream_TellI},
    {sipName_Ungetch, SIP_MLMETH_CAST(meth_wxInputStream_Ungetch), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_Ungetch},
    {sipName_close, meth_wxInputStream_close, METH_VARARGS, doc_wxInputStream_close},
    {sipName_eof, meth_wxInputStream_eof, METH_VARARGS, doc_wxInputStream_eof},
    {sipName_flush, meth_wxInputStream_flush, METH_VARARGS, doc_wxInputStream_flush},
    {sipName_read, SIP_MLMETH_CAST(meth_wxInputStream_read), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_read},
    {sipName_readline, SIP_MLMETH_CAST(meth_wxInputStream_readline), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_readline},
    {sipName_readlines, SIP_MLMETH_CAST(meth_wxInputStream_readlines), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_readlines},
    {sipName_seek, SIP_MLMETH_CAST(meth_wxInputStream_seek), METH_VARARGS|METH_KEYWORDS, doc_wxInputStream_seek},
    {sipName_tell, meth_wxInputStream_tell, METH_VARARGS, doc_wxInputStream_tell}
};

sipVariableDef variables_wxInputStream[] = {
    {PropertyVariable, sipName_C, &methods_wxInputStream[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxInputStream, "InputStream()\n"
"\n"
"wxInputStream is an abstract base class which may not be used\n"
"directly.");


sipClassTypeDef sipTypeDef__core_wxInputStream = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxInputStream,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_InputStream,
        {0, 0, 1},
        18, methods_wxInputStream,
        0, SIP_NULLPTR,
        1, variables_wxInputStream,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxInputStream,
    -1,
    -1,
    supers_wxInputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxInputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxInputStream,
    cast_wxInputStream,
    convertTo_wxInputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
