/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.0
 *
 *     
 */

#include "sipAPI_core.h"




extern "C" {static void assign_wxArrayString(void *, Py_ssize_t, void *);}
static void assign_wxArrayString(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxArrayString *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxArrayString *>(sipSrc);
}


extern "C" {static void *array_wxArrayString(Py_ssize_t);}
static void *array_wxArrayString(Py_ssize_t sipNrElem)
{
    return new  ::wxArrayString[sipNrElem];
}


extern "C" {static void *copy_wxArrayString(const void *, Py_ssize_t);}
static void *copy_wxArrayString(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxArrayString(reinterpret_cast<const  ::wxArrayString *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_wxArrayString(void *, int);}
static void release_wxArrayString(void *sipCppV, int)
{
     ::wxArrayString *sipCpp = reinterpret_cast< ::wxArrayString *>(sipCppV);
    Py_BEGIN_ALLOW_THREADS
    delete sipCpp;
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_wxArrayString(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxArrayString(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
     ::wxArrayString **sipCppPtr = reinterpret_cast< ::wxArrayString **>(sipCppPtrV);

        // Code to test a PyObject for compatibility
        // Verify that the object is a sequence, but not bytes or unicode
        if (!sipIsErr) {
            return (PySequence_Check(sipPy) &&
                    !(PyBytes_Check(sipPy) || PyUnicode_Check(sipPy)));
        }


        // Code to create a new wxArrayString and convert a compatible PyObject
        wxArrayString *array = new wxArrayString;
        Py_ssize_t i, len = PySequence_Length(sipPy);
        for (i=0; i<len; i++) {
            PyObject* item = PySequence_GetItem(sipPy, i);

            // Ensure each item is a bytes or string/unicode object
            if ( !PyBytes_Check(item) && !PyUnicode_Check(item) ) {
                // raise a TypeError if not
                PyErr_Format(PyExc_TypeError,
                             "Item at index %zd has type '%s' but a sequence of bytes or strings is expected",
                             i, sipPyTypeName(Py_TYPE(item)));
                delete array;
                Py_DECREF(item);
                *sipIsErr = 1;
                return 0;
            }

            // if it's a string object convert it to unicode first, assuming utf-8
            if (PyBytes_Check(item)) {
                Py_DECREF(item);
                item = PyUnicode_FromEncodedObject(item, "utf-8", "strict");
                if (PyErr_Occurred()) {
                    *sipIsErr = 1;
                    delete array;
                    Py_DECREF(item);
                    return 0;
                }
            }
            PyErr_Clear();
            wxString string;
            size_t len = PyUnicode_GET_SIZE(item);
            if (len) {
                wxPyUnicode_AsWideChar(item, wxStringBuffer(string, len), len);
            }
            if (PyErr_Occurred()) {
                *sipIsErr = 1;
                delete array;
                Py_DECREF(item);
                return 0;
            }
            array->Add(string);
            Py_DECREF(item);
        }
        *sipCppPtr = array;
        return sipGetState(sipTransferObj);
}


extern "C" {static PyObject *convertFrom_wxArrayString(void *, PyObject *);}
static PyObject *convertFrom_wxArrayString(void *sipCppV, PyObject *)
{
    ::wxArrayString *sipCpp = reinterpret_cast< ::wxArrayString *>(sipCppV);

        // Code to convert a wxArrayString to a Python list of strings.
        PyObject* list = PyList_New(0);
        for (size_t i=0; i < sipCpp->GetCount(); i++) {
            PyObject* str = wx2PyString(sipCpp->Item(i));
            PyList_Append(list, str);
            Py_DECREF(str);
        }
        return list;
}


sipMappedTypeDef sipTypeDef__core_wxArrayString = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_wxArrayString,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_wxArrayString,
    array_wxArrayString,
    copy_wxArrayString,
    release_wxArrayString,
    convertTo_wxArrayString,
    convertFrom_wxArrayString
};
