"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeActivity", "use `StepFunctionsInvokeActivity`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_InvokeActivityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeActivity#bind", "use `StepFunctionsInvokeActivity`");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
_a = JSII_RTTI_SYMBOL_1;
InvokeActivity[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.InvokeActivity", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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