# auto-generated by pywriter.py, do not edit or commit

from openpower.decoder.isa.caller import inject, instruction_info
from openpower.decoder.helpers import (EXTS, EXTS64, EXTZ64, ROTL64, ROTL32,
                                 MASK, MASK32,
                                 ne, eq, gt, ge, lt, le, ltu, gtu, length,
                                 trunc_divs, trunc_rems, MULS, DIVS, MODS,
                                 EXTS128, undefined,
                                 DOUBLE, SINGLE)
from openpower.decoder.selectable_int import SelectableInt
from openpower.decoder.selectable_int import selectconcat as concat
from openpower.decoder.orderedset import OrderedSet

class sprset:

    @inject()
    def op_mtspr(self, RS):
        n = concat(spr[5:10], spr[0:5])
        if n in [13]:
            see(Book_III_p974)
        elif n in [808, 809, 810, 811]:
            if eq(length(SPR(n)), 64):
                SPR[n] = RS
            else:
                SPR[n] = RS[32:64]
        elif eq(length(SPR(n)), 64):
            SPR[n] = RS
        else:
            SPR[n] = RS[32:64]

    @inject()
    def op_mfspr(self):
        n = concat(spr[5:10], spr[0:5])
        if n in [129]:
            see(Book_III_p975)
        elif n in [808, 809, 810, 811]:
            if eq(length(SPR(n)), 64):
                RT = SPR(n)
            else:
                RT = concat(concat(0, repeat=32), SPR(n))
        elif eq(length(SPR(n)), 64):
            RT = SPR(n)
        else:
            RT = concat(concat(0, repeat=32), SPR(n))
        return (RT,)

    @inject()
    def op_mcrxrx(self, CR):
        CR[4 * BF + 32:4 * BF + 35 + 1] = concat(XER[OV], XER[OV32], XER[CA], XER[CA32]
            )
        return (CR,)

    @inject()
    def op_mtocrf(self, RS, CR):
        n = 7
        for i in range(7, 0 + -1, -1):
            if eq(FXM[i], 1):
                n = i
        CR[4 * n + 32:4 * n + 35 + 1] = RS[4 * n + 32:4 * n + 35 + 1]
        return (CR,)

    @inject()
    def op_mtcrf(self, RS, CR):
        for n in range(0, 7 + 1):
            if eq(FXM[n], 1):
                CR[4 * n + 32:4 * n + 35 + 1] = RS[4 * n + 32:4 * n + 35 + 1]
        return (CR,)

    @inject()
    def op_mfocrf(self, RT, CR):
        done = 0
        RT = concat(0, repeat=64)
        for n in range(0, 7 + 1):
            if eq(done, 0) & eq(FXM[n], 1):
                RT[4 * n + 32:4 * n + 35 + 1] = CR[4 * n + 32:4 * n + 35 + 1]
                done = 1
        return (RT, CR,)

    @inject()
    def op_mfcr(self, CR):
        RT = concat(concat(0, repeat=32), CR)
        return (CR, RT,)

    @inject()
    def op_setb(self, CR):
        if eq(CR[4 * BFA + 32], 1):
            RT = SelectableInt(value=0xffffffffffffffff, bits=64)
        elif eq(CR[4 * BFA + 33], 1):
            RT = SelectableInt(value=0x1, bits=64)
        else:
            RT = SelectableInt(value=0x0, bits=64)
        return (CR, RT,)

    @inject()
    def op_mtmsr(self, RS, MSR):
        if eq(L1, 0):
            MSR[48] = RS[48] | RS[49]
            MSR[58] = RS[58] | RS[49]
            MSR[59] = RS[59] | RS[49]
            MSR[32:41] = RS[32:41]
            MSR[42:48] = RS[42:48]
            MSR[49:51] = RS[49:51]
            MSR[52:58] = RS[52:58]
            MSR[60:63] = RS[60:63]
        else:
            MSR[48] = RS[48]
            MSR[62] = RS[62]
        return (MSR,)

    @inject()
    def op_mtmsrd(self, RS, MSR):
        if eq(L1, 0):
            if ne(MSR[29:32], SelectableInt(value=0x2, bits=3)) | ne(RS[29:32],
                SelectableInt(value=0x0, bits=3)):
                MSR[29:32] = RS[29:32]
            MSR[48] = RS[48] | RS[49]
            MSR[58] = RS[58] | RS[49]
            MSR[59] = RS[59] | RS[49]
            MSR[0:3] = RS[0:3]
            MSR[4:29] = RS[4:29]
            MSR[32:41] = RS[32:41]
            MSR[42:48] = RS[42:48]
            MSR[49:51] = RS[49:51]
            MSR[52:58] = RS[52:58]
            MSR[60:63] = RS[60:63]
        else:
            MSR[48] = RS[48]
            MSR[62] = RS[62]
        return (MSR,)

    @inject()
    def op_mfmsr(self, MSR):
        RT = MSR
        return (MSR, RT,)

    @inject()
    def op_dcbz(self, RA, RB):
        if eq(RA, 0):
            b = 0
        else:
            b = RA
        EA = b + RB

    @inject()
    def op_tlbie(self, RB):
        IS = RB[52:54]

    sprset_instrs = {}
    sprset_instrs['mtspr'] = instruction_info(func=op_mtspr,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(),
                special_regs=OrderedSet(), op_fields=OrderedSet(['spr']),
                form='XFX',
                asmregs=[['SPR', 'RS']])
    sprset_instrs['mfspr'] = instruction_info(func=op_mfspr,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['spr']),
                form='XFX',
                asmregs=[['RT', 'SPR']])
    sprset_instrs['mcrxrx'] = instruction_info(func=op_mcrxrx,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['BF']),
                form='X',
                asmregs=[['BF']])
    sprset_instrs['mtocrf'] = instruction_info(func=op_mtocrf,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['FXM']),
                form='XFX',
                asmregs=[['FXM', 'RS']])
    sprset_instrs['mtcrf'] = instruction_info(func=op_mtcrf,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['FXM']),
                form='XFX',
                asmregs=[['FXM', 'RS']])
    sprset_instrs['mfocrf'] = instruction_info(func=op_mfocrf,
                read_regs=OrderedSet(['RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'CR']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['FXM']),
                form='XFX',
                asmregs=[['RT', 'FXM']])
    sprset_instrs['mfcr'] = instruction_info(func=op_mfcr,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR', 'RT']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(),
                form='XFX',
                asmregs=[['RT']])
    sprset_instrs['setb'] = instruction_info(func=op_setb,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['CR', 'RT']),
                special_regs=OrderedSet(['CR']), op_fields=OrderedSet(['BFA']),
                form='X',
                asmregs=[['RT', 'BFA']])
    sprset_instrs['mtmsr'] = instruction_info(func=op_mtmsr,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['MSR']),
                special_regs=OrderedSet(['MSR']), op_fields=OrderedSet(['L1']),
                form='X',
                asmregs=[['RS', 'L1']])
    sprset_instrs['mtmsrd'] = instruction_info(func=op_mtmsrd,
                read_regs=OrderedSet(['RS']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['MSR']),
                special_regs=OrderedSet(['MSR']), op_fields=OrderedSet(['L1']),
                form='X',
                asmregs=[['RS', 'L1']])
    sprset_instrs['mfmsr'] = instruction_info(func=op_mfmsr,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['MSR', 'RT']),
                special_regs=OrderedSet(['MSR']), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RT']])
    sprset_instrs['dcbz'] = instruction_info(func=op_dcbz,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RA', 'RB']])
    sprset_instrs['tlbie'] = instruction_info(func=op_tlbie,
                read_regs=OrderedSet(['RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RB', 'RS', 'RIC', 'PRS', 'R']])
