# auto-generated by pywriter.py, do not edit or commit

from openpower.decoder.isa.caller import inject, instruction_info
from openpower.decoder.helpers import (EXTS, EXTS64, EXTZ64, ROTL64, ROTL32,
                                 MASK, MASK32,
                                 ne, eq, gt, ge, lt, le, ltu, gtu, length,
                                 trunc_divs, trunc_rems, MULS, DIVS, MODS,
                                 EXTS128, undefined,
                                 DOUBLE, SINGLE)
from openpower.decoder.selectable_int import SelectableInt
from openpower.decoder.selectable_int import selectconcat as concat
from openpower.decoder.orderedset import OrderedSet

class fixedarith:

    @inject()
    def op_addi(self, RA):
        RT = GPR.getz(_RA) + EXTS(SI)
        return (RT,)

    @inject()
    def op_addis(self, RA):
        RT = GPR.getz(_RA) + EXTS(concat(SI, concat(0, repeat=16)))
        return (RT,)

    @inject()
    def op_addpcis(self):
        global NIA
        D = concat(d0, d1, d2)
        RT = NIA + EXTS(concat(D, concat(0, repeat=16)))
        return (RT,)

    @inject()
    def op_add(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_add_(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_addo(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_addo_(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_subf(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subf_(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subfo(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subfo_(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_addic(self, RA):
        RT = RA + EXTS(SI)
        return (RT,)

    @inject()
    def op_addic_(self, RA):
        RT = RA + EXTS(SI)
        return (RT,)

    @inject()
    def op_subfic(self, RA):
        RT = ~RA + EXTS(SI) + 1
        return (RT,)

    @inject()
    def op_addc(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_addc_(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_addco(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_addco_(self, RA, RB):
        RT = RA + RB
        return (RT,)

    @inject()
    def op_subfc(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subfc_(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subfco(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_subfco_(self, RA, RB):
        RT = ~RA + RB + 1
        return (RT,)

    @inject()
    def op_adde(self, RA, RB):
        RT = RA + RB + CA
        return (RT,)

    @inject()
    def op_adde_(self, RA, RB):
        RT = RA + RB + CA
        return (RT,)

    @inject()
    def op_addeo(self, RA, RB):
        RT = RA + RB + CA
        return (RT,)

    @inject()
    def op_addeo_(self, RA, RB):
        RT = RA + RB + CA
        return (RT,)

    @inject()
    def op_subfe(self, RA, RB):
        RT = ~RA + RB + CA
        return (RT,)

    @inject()
    def op_subfe_(self, RA, RB):
        RT = ~RA + RB + CA
        return (RT,)

    @inject()
    def op_subfeo(self, RA, RB):
        RT = ~RA + RB + CA
        return (RT,)

    @inject()
    def op_subfeo_(self, RA, RB):
        RT = ~RA + RB + CA
        return (RT,)

    @inject()
    def op_addme(self, RA):
        RT = RA + CA - 1
        return (RT,)

    @inject()
    def op_addme_(self, RA):
        RT = RA + CA - 1
        return (RT,)

    @inject()
    def op_addmeo(self, RA):
        RT = RA + CA - 1
        return (RT,)

    @inject()
    def op_addmeo_(self, RA):
        RT = RA + CA - 1
        return (RT,)

    @inject()
    def op_subfme(self, RA):
        RT = ~RA + CA - 1
        return (RT,)

    @inject()
    def op_subfme_(self, RA):
        RT = ~RA + CA - 1
        return (RT,)

    @inject()
    def op_subfmeo(self, RA):
        RT = ~RA + CA - 1
        return (RT,)

    @inject()
    def op_subfmeo_(self, RA):
        RT = ~RA + CA - 1
        return (RT,)

    @inject()
    def op_addex(self, RA, RB):
        if eq(CY, 0):
            RT = RA + RB + OV
        return (RT,)

    @inject()
    def op_subfze(self, RA):
        RT = ~RA + CA
        return (RT,)

    @inject()
    def op_subfze_(self, RA):
        RT = ~RA + CA
        return (RT,)

    @inject()
    def op_subfzeo(self, RA):
        RT = ~RA + CA
        return (RT,)

    @inject()
    def op_subfzeo_(self, RA):
        RT = ~RA + CA
        return (RT,)

    @inject()
    def op_addze(self, RA):
        RT = RA + CA
        return (RT,)

    @inject()
    def op_addze_(self, RA):
        RT = RA + CA
        return (RT,)

    @inject()
    def op_addzeo(self, RA):
        RT = RA + CA
        return (RT,)

    @inject()
    def op_addzeo_(self, RA):
        RT = RA + CA
        return (RT,)

    @inject()
    def op_neg(self, RA):
        RT = ~RA + 1
        return (RT,)

    @inject()
    def op_neg_(self, RA):
        RT = ~RA + 1
        return (RT,)

    @inject()
    def op_nego(self, RA):
        RT = ~RA + 1
        return (RT,)

    @inject()
    def op_nego_(self, RA):
        RT = ~RA + 1
        return (RT,)

    @inject()
    def op_mulli(self, RA):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, EXTS(SI))
        RT = prod[64:128]
        return (RT,)

    @inject()
    def op_mulhw(self, RA, RB, RT):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT[32:64] = prod[0:32]
        RT[0:32] = undefined(prod[0:32])
        return (RT,)

    @inject()
    def op_mulhw_(self, RA, RB, RT):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT[32:64] = prod[0:32]
        RT[0:32] = undefined(prod[0:32])
        return (RT,)

    @inject()
    def op_mullw(self, RA, RB):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT = prod
        overflow = ne(prod[0:33], concat(0, repeat=33)) & ne(prod[0:33], concat(1,
            repeat=33))
        return (RT, overflow,)

    @inject()
    def op_mullw_(self, RA, RB):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT = prod
        overflow = ne(prod[0:33], concat(0, repeat=33)) & ne(prod[0:33], concat(1,
            repeat=33))
        return (RT, overflow,)

    @inject()
    def op_mullwo(self, RA, RB):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT = prod
        overflow = ne(prod[0:33], concat(0, repeat=33)) & ne(prod[0:33], concat(1,
            repeat=33))
        return (RT, overflow,)

    @inject()
    def op_mullwo_(self, RA, RB):
        prod = concat(0, repeat=64)
        prod[0:64] = MULS(RA[32:64], RB[32:64])
        RT = prod
        overflow = ne(prod[0:33], concat(0, repeat=33)) & ne(prod[0:33], concat(1,
            repeat=33))
        return (RT, overflow,)

    @inject()
    def op_mulhwu(self, RA, RB, RT):
        prod = concat(0, repeat=64)
        prod[0:64] = RA[32:64] * RB[32:64]
        RT[32:64] = prod[0:32]
        RT[0:32] = undefined(prod[0:32])
        return (RT,)

    @inject()
    def op_mulhwu_(self, RA, RB, RT):
        prod = concat(0, repeat=64)
        prod[0:64] = RA[32:64] * RB[32:64]
        RT[32:64] = prod[0:32]
        RT[0:32] = undefined(prod[0:32])
        return (RT,)

    @inject()
    def op_divw(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(dividend, SelectableInt(value=0x80000000, bits=32)) & eq(divisor,
            concat(1, repeat=32)) | eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[32:64] = DIVS(dividend, divisor)
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divw_(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(dividend, SelectableInt(value=0x80000000, bits=32)) & eq(divisor,
            concat(1, repeat=32)) | eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[32:64] = DIVS(dividend, divisor)
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divwo(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(dividend, SelectableInt(value=0x80000000, bits=32)) & eq(divisor,
            concat(1, repeat=32)) | eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[32:64] = DIVS(dividend, divisor)
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divwo_(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(dividend, SelectableInt(value=0x80000000, bits=32)) & eq(divisor,
            concat(1, repeat=32)) | eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[32:64] = DIVS(dividend, divisor)
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divwu(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if ne(divisor, 0):
            RT[32:64] = dividend // divisor
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        else:
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        return (RT, overflow,)

    @inject()
    def op_divwu_(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if ne(divisor, 0):
            RT[32:64] = dividend // divisor
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        else:
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        return (RT, overflow,)

    @inject()
    def op_divwuo(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if ne(divisor, 0):
            RT[32:64] = dividend // divisor
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        else:
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        return (RT, overflow,)

    @inject()
    def op_divwuo_(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if ne(divisor, 0):
            RT[32:64] = dividend // divisor
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        else:
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        return (RT, overflow,)

    @inject()
    def op_divwe(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = EXTS64(RB[32:64])
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result32 = concat(0, repeat=64)
            result32[0:64] = EXTS64(result[32:64])
            if eq(result32, result):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divwe_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = EXTS64(RB[32:64])
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result32 = concat(0, repeat=64)
            result32[0:64] = EXTS64(result[32:64])
            if eq(result32, result):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweo(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = EXTS64(RB[32:64])
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result32 = concat(0, repeat=64)
            result32[0:64] = EXTS64(result[32:64])
            if eq(result32, result):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweo_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = EXTS64(RB[32:64])
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result32 = concat(0, repeat=64)
            result32[0:64] = EXTS64(result[32:64])
            if eq(result32, result):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweu(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = concat(concat(0, repeat=32), RB[32:64])
        if eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA[32:64], RB[32:64]):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweu_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = concat(concat(0, repeat=32), RB[32:64])
        if eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA[32:64], RB[32:64]):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweuo(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = concat(concat(0, repeat=32), RB[32:64])
        if eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA[32:64], RB[32:64]):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divweuo_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = concat(RA[32:64], concat(0, repeat=32))
        divisor = concat(0, repeat=64)
        divisor[0:64] = concat(concat(0, repeat=32), RB[32:64])
        if eq(divisor, concat(0, repeat=64)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA[32:64], RB[32:64]):
                RT[32:64] = result[32:64]
                RT[0:32] = undefined(concat(0, repeat=32))
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_modsw(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(dividend, SelectableInt(value=0x80000000, bits=32)) & eq(divisor,
            concat(1, repeat=32)) | eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[0:64] = EXTS64(MODS(dividend, divisor))
            RT[0:32] = undefined(RT[0:32])
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_moduw(self, RA, RB, RT):
        dividend = concat(0, repeat=32)
        dividend[0:32] = RA[32:64]
        divisor = concat(0, repeat=32)
        divisor[0:32] = RB[32:64]
        if eq(divisor, concat(0, repeat=32)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT[32:64] = dividend % divisor
            RT[0:32] = undefined(concat(0, repeat=32))
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_darn(self):
        RT = random(L3)
        return (RT,)

    @inject()
    def op_mulld(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[64:128]
        overflow = ne(prod[0:65], concat(0, repeat=65)) & ne(prod[0:65], concat(1,
            repeat=65))
        return (RT, overflow,)

    @inject()
    def op_mulld_(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[64:128]
        overflow = ne(prod[0:65], concat(0, repeat=65)) & ne(prod[0:65], concat(1,
            repeat=65))
        return (RT, overflow,)

    @inject()
    def op_mulldo(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[64:128]
        overflow = ne(prod[0:65], concat(0, repeat=65)) & ne(prod[0:65], concat(1,
            repeat=65))
        return (RT, overflow,)

    @inject()
    def op_mulldo_(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[64:128]
        overflow = ne(prod[0:65], concat(0, repeat=65)) & ne(prod[0:65], concat(1,
            repeat=65))
        return (RT, overflow,)

    @inject()
    def op_mulhd(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[0:64]
        return (RT,)

    @inject()
    def op_mulhd_(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        RT = prod[0:64]
        return (RT,)

    @inject()
    def op_mulhdu(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = RA * RB
        RT = prod[0:64]
        return (RT,)

    @inject()
    def op_mulhdu_(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = RA * RB
        RT = prod[0:64]
        return (RT,)

    @inject()
    def op_maddhd(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        sum = concat(0, repeat=128)
        sum[0:128] = prod + EXTS(RC)
        RT = sum[0:64]
        return (RT,)

    @inject()
    def op_maddhdu(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = RA * RB
        sum = concat(0, repeat=128)
        sum[0:128] = prod + EXTZ(RC)
        RT = sum[0:64]
        return (RT,)

    @inject()
    def op_maddld(self, RA, RB):
        prod = concat(0, repeat=128)
        prod[0:128] = MULS(RA, RB)
        sum = concat(0, repeat=128)
        sum[0:128] = prod + EXTS(RC)
        RT = sum[64:128]
        return (RT,)

    @inject()
    def op_divd(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = DIVS(dividend, divisor)
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divd_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = DIVS(dividend, divisor)
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divdo(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = DIVS(dividend, divisor)
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divdo_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = DIVS(dividend, divisor)
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divdu(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = dividend // divisor
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divdu_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = dividend // divisor
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divduo(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = dividend // divisor
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divduo_(self, RA, RB, RT):
        dividend = concat(0, repeat=64)
        dividend[0:64] = RA
        divisor = concat(0, repeat=64)
        divisor[0:64] = RB
        if eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = dividend // divisor
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_divde(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = EXTS128(RB)
        if eq(dividend,
            SelectableInt(value=0x80000000000000000000000000000000, bits=128)) & eq(
            divisor, concat(1, repeat=128)) | eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result64 = concat(0, repeat=128)
            result64[0:128] = EXTS128(result[64:128])
            if eq(result64, result):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divde_(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = EXTS128(RB)
        if eq(dividend,
            SelectableInt(value=0x80000000000000000000000000000000, bits=128)) & eq(
            divisor, concat(1, repeat=128)) | eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result64 = concat(0, repeat=128)
            result64[0:128] = EXTS128(result[64:128])
            if eq(result64, result):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeo(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = EXTS128(RB)
        if eq(dividend,
            SelectableInt(value=0x80000000000000000000000000000000, bits=128)) & eq(
            divisor, concat(1, repeat=128)) | eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result64 = concat(0, repeat=128)
            result64[0:128] = EXTS128(result[64:128])
            if eq(result64, result):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeo_(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = EXTS128(RB)
        if eq(dividend,
            SelectableInt(value=0x80000000000000000000000000000000, bits=128)) & eq(
            divisor, concat(1, repeat=128)) | eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = DIVS(dividend, divisor)
            result64 = concat(0, repeat=128)
            result64[0:128] = EXTS128(result[64:128])
            if eq(result64, result):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeu(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = concat(concat(0, repeat=64), RB)
        if eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA, RB):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeu_(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = concat(concat(0, repeat=64), RB)
        if eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA, RB):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeuo(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = concat(concat(0, repeat=64), RB)
        if eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA, RB):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_divdeuo_(self, RA, RB, RT):
        dividend = concat(0, repeat=128)
        dividend[0:128] = concat(RA, concat(0, repeat=64))
        divisor = concat(0, repeat=128)
        divisor[0:128] = concat(concat(0, repeat=64), RB)
        if eq(divisor, concat(0, repeat=128)):
            overflow = 1
        else:
            result = dividend // divisor
            if ltu(RA, RB):
                RT = result[64:128]
                overflow = 0
            else:
                overflow = 1
        if eq(overflow, 1):
            RT[0:64] = undefined(concat(0, repeat=64))
        return (RT, overflow,)

    @inject()
    def op_modsd(self, RA, RB, RT):
        dividend = RA
        divisor = RB
        if eq(dividend, SelectableInt(value=0x8000000000000000, bits=64)) & eq(divisor,
            concat(1, repeat=64)) | eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = MODS(dividend, divisor)
            overflow = 0
        return (RT, overflow,)

    @inject()
    def op_modud(self, RA, RB, RT):
        dividend = RA
        divisor = RB
        if eq(divisor, concat(0, repeat=64)):
            RT[0:64] = undefined(concat(0, repeat=64))
            overflow = 1
        else:
            RT = dividend % divisor
            overflow = 0
        return (RT, overflow,)

    fixedarith_instrs = {}
    fixedarith_instrs['addi'] = instruction_info(func=op_addi,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['addis'] = instruction_info(func=op_addis,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['addpcis'] = instruction_info(func=op_addpcis,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['d0', 'd1', 'd2']),
                form='DX',
                asmregs=[['RT', 'D']])
    fixedarith_instrs['add'] = instruction_info(func=op_add,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['add.'] = instruction_info(func=op_add_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['addo'] = instruction_info(func=op_addo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['addo.'] = instruction_info(func=op_addo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['subf'] = instruction_info(func=op_subf,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['subf.'] = instruction_info(func=op_subf_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['subfo'] = instruction_info(func=op_subfo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['subfo.'] = instruction_info(func=op_subfo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['addic'] = instruction_info(func=op_addic,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['addic.'] = instruction_info(func=op_addic_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['subfic'] = instruction_info(func=op_subfic,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['addc'] = instruction_info(func=op_addc,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['addc.'] = instruction_info(func=op_addc_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['addco'] = instruction_info(func=op_addco,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['addco.'] = instruction_info(func=op_addco_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['subfc'] = instruction_info(func=op_subfc,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['subfc.'] = instruction_info(func=op_subfc_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['subfco'] = instruction_info(func=op_subfco,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['subfco.'] = instruction_info(func=op_subfco_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['adde'] = instruction_info(func=op_adde,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['adde.'] = instruction_info(func=op_adde_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['addeo'] = instruction_info(func=op_addeo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['addeo.'] = instruction_info(func=op_addeo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['subfe'] = instruction_info(func=op_subfe,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['subfe.'] = instruction_info(func=op_subfe_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['subfeo'] = instruction_info(func=op_subfeo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['subfeo.'] = instruction_info(func=op_subfeo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['addme'] = instruction_info(func=op_addme,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['addme.'] = instruction_info(func=op_addme_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['addmeo'] = instruction_info(func=op_addmeo,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['addmeo.'] = instruction_info(func=op_addmeo_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['subfme'] = instruction_info(func=op_subfme,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['subfme.'] = instruction_info(func=op_subfme_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['subfmeo'] = instruction_info(func=op_subfmeo,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['subfmeo.'] = instruction_info(func=op_subfmeo_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['addex'] = instruction_info(func=op_addex,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='Z23',
                asmregs=[['RT', 'RA', 'RB', 'CY']])
    fixedarith_instrs['subfze'] = instruction_info(func=op_subfze,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['subfze.'] = instruction_info(func=op_subfze_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['subfzeo'] = instruction_info(func=op_subfzeo,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['subfzeo.'] = instruction_info(func=op_subfzeo_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['addze'] = instruction_info(func=op_addze,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['addze.'] = instruction_info(func=op_addze_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['addzeo'] = instruction_info(func=op_addzeo,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['addzeo.'] = instruction_info(func=op_addzeo_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['neg'] = instruction_info(func=op_neg,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['neg.'] = instruction_info(func=op_neg_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['nego'] = instruction_info(func=op_nego,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['nego.'] = instruction_info(func=op_nego_,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['mulli'] = instruction_info(func=op_mulli,
                read_regs=OrderedSet(['RA']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['SI']),
                form='D',
                asmregs=[['RT', 'RA', 'SI']])
    fixedarith_instrs['mulhw'] = instruction_info(func=op_mulhw,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=0)'])
    fixedarith_instrs['mulhw.'] = instruction_info(func=op_mulhw_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=1)'])
    fixedarith_instrs['mullw'] = instruction_info(func=op_mullw,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['mullw.'] = instruction_info(func=op_mullw_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['mullwo'] = instruction_info(func=op_mullwo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['mullwo.'] = instruction_info(func=op_mullwo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['mulhwu'] = instruction_info(func=op_mulhwu,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=0)'])
    fixedarith_instrs['mulhwu.'] = instruction_info(func=op_mulhwu_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=1)'])
    fixedarith_instrs['divw'] = instruction_info(func=op_divw,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divw.'] = instruction_info(func=op_divw_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divwo'] = instruction_info(func=op_divwo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divwo.'] = instruction_info(func=op_divwo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divwu'] = instruction_info(func=op_divwu,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divwu.'] = instruction_info(func=op_divwu_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divwuo'] = instruction_info(func=op_divwuo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divwuo.'] = instruction_info(func=op_divwuo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divwe'] = instruction_info(func=op_divwe,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divwe.'] = instruction_info(func=op_divwe_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divweo'] = instruction_info(func=op_divweo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divweo.'] = instruction_info(func=op_divweo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divweu'] = instruction_info(func=op_divweu,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divweu.'] = instruction_info(func=op_divweu_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divweuo'] = instruction_info(func=op_divweuo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divweuo.'] = instruction_info(func=op_divweuo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['modsw'] = instruction_info(func=op_modsw,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RT', 'RA', 'RB']])
    fixedarith_instrs['moduw'] = instruction_info(func=op_moduw,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RT', 'RA', 'RB']])
    fixedarith_instrs['darn'] = instruction_info(func=op_darn,
                read_regs=OrderedSet(),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(['L3']),
                form='X',
                asmregs=[['RT', 'L3']])
    fixedarith_instrs['mulld'] = instruction_info(func=op_mulld,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['mulld.'] = instruction_info(func=op_mulld_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['mulldo'] = instruction_info(func=op_mulldo,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['mulldo.'] = instruction_info(func=op_mulldo_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['mulhd'] = instruction_info(func=op_mulhd,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=0)'])
    fixedarith_instrs['mulhd.'] = instruction_info(func=op_mulhd_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=1)'])
    fixedarith_instrs['mulhdu'] = instruction_info(func=op_mulhdu,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=0)'])
    fixedarith_instrs['mulhdu.'] = instruction_info(func=op_mulhdu_,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(Rc=1)'])
    fixedarith_instrs['maddhd'] = instruction_info(func=op_maddhd,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='VA',
                asmregs=[['RT', 'RA.RB', 'RC']])
    fixedarith_instrs['maddhdu'] = instruction_info(func=op_maddhdu,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='VA',
                asmregs=[['RT', 'RA.RB', 'RC']])
    fixedarith_instrs['maddld'] = instruction_info(func=op_maddld,
                read_regs=OrderedSet(['RA', 'RB']),
                uninit_regs=OrderedSet(), write_regs=OrderedSet(['RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='VA',
                asmregs=[['RT', 'RA.RB', 'RC']])
    fixedarith_instrs['divd'] = instruction_info(func=op_divd,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divd.'] = instruction_info(func=op_divd_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divdo'] = instruction_info(func=op_divdo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divdo.'] = instruction_info(func=op_divdo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divdu'] = instruction_info(func=op_divdu,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divdu.'] = instruction_info(func=op_divdu_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divduo'] = instruction_info(func=op_divduo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divduo.'] = instruction_info(func=op_divduo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divde'] = instruction_info(func=op_divde,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divde.'] = instruction_info(func=op_divde_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divdeo'] = instruction_info(func=op_divdeo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divdeo.'] = instruction_info(func=op_divdeo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['divdeu'] = instruction_info(func=op_divdeu,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=0)'])
    fixedarith_instrs['divdeu.'] = instruction_info(func=op_divdeu_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=0', 'Rc=1)'])
    fixedarith_instrs['divdeuo'] = instruction_info(func=op_divdeuo,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=0)'])
    fixedarith_instrs['divdeuo.'] = instruction_info(func=op_divdeuo_,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['overflow', 'RT']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='XO',
                asmregs=[['RT', 'RA', 'RB'], '(OE=1', 'Rc=1)'])
    fixedarith_instrs['modsd'] = instruction_info(func=op_modsd,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RT', 'RA', 'RB']])
    fixedarith_instrs['modud'] = instruction_info(func=op_modud,
                read_regs=OrderedSet(['RA', 'RB', 'RT']),
                uninit_regs=OrderedSet(['RT']), write_regs=OrderedSet(['RT', 'overflow']),
                special_regs=OrderedSet(), op_fields=OrderedSet(),
                form='X',
                asmregs=[['RT', 'RA', 'RB']])
