# mypy-boto3-codeguru-reviewer

[![PyPI - mypy-boto3-codeguru-reviewer](https://img.shields.io/pypi/v/mypy-boto3-codeguru-reviewer.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguru-reviewer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codeguru-reviewer.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguru-reviewer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-codeguru-reviewer](#mypy-boto3-codeguru-reviewer)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.CodeGuruReviewer 1.13.25](https://boto3.amazonaws.com/v1/documentation/api/1.13.25/reference/services/codeguru-reviewer.html#CodeGuruReviewer) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-codeguru-reviewer](#mypy-boto3-codeguru-reviewer)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CodeGuruReviewer` service.

```bash
python -m pip install boto3-stubs[codeguru-reviewer]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_codeguru_reviewer` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_codeguru_reviewer import CodeGuruReviewerClient

# Now mypy can check if your code is valid.
client: CodeGuruReviewerClient = boto3.client("codeguru-reviewer")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeGuruReviewerClient = session.client("codeguru-reviewer")



# Annotated paginators are included as well

import mypy_boto3_codeguru_reviewer.paginator as codeguru_reviewer_paginators

list_repository_associations_paginator: codeguru_reviewer_paginators.ListRepositoryAssociationsPaginator = client.get_paginator("list_repository_associations")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_codeguru_reviewer` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_codeguru_reviewer as codeguru_reviewer
from mypy_boto3_codeguru_reviewer import CodeGuruReviewerClient

# with these
from mypy_boto3 import codeguru_reviewer
from mypy_boto3.codeguru_reviewer import CodeGuruReviewerClient
```