# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ComplianceDetail(Model):
    """The compliance state rollup.

    :param compliance_state: The compliance state.
    :type compliance_state: str
    :param count: Summarized count value for this compliance state.
    :type count: int
    """

    _attribute_map = {
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(self, *, compliance_state: str=None, count: int=None, **kwargs) -> None:
        super(ComplianceDetail, self).__init__(**kwargs)
        self.compliance_state = compliance_state
        self.count = count


class ComponentEventDetails(Model):
    """Component event details.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param id: Component Id.
    :type id: str
    :param type: Component type.
    :type type: str
    :param name: Component name.
    :type name: str
    :param timestamp: Timestamp for component policy event record.
    :type timestamp: datetime
    :param tenant_id: Tenant ID for the policy event record.
    :type tenant_id: str
    :param principal_oid: Principal object ID for the user who initiated the
     resource component operation that triggered the policy event.
    :type principal_oid: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_oid': {'key': 'principalOid', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, id: str=None, type: str=None, name: str=None, timestamp=None, tenant_id: str=None, principal_oid: str=None, policy_definition_action: str=None, **kwargs) -> None:
        super(ComponentEventDetails, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.type = type
        self.name = name
        self.timestamp = timestamp
        self.tenant_id = tenant_id
        self.principal_oid = principal_oid
        self.policy_definition_action = policy_definition_action


class ComponentStateDetails(Model):
    """Component state details.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param id: Component Id.
    :type id: str
    :param type: Component type.
    :type type: str
    :param name: Component name.
    :type name: str
    :param timestamp: Component compliance evaluation timestamp.
    :type timestamp: datetime
    :param compliance_state: Component compliance state.
    :type compliance_state: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, id: str=None, type: str=None, name: str=None, timestamp=None, compliance_state: str=None, **kwargs) -> None:
        super(ComponentStateDetails, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.type = type
        self.name = name
        self.timestamp = timestamp
        self.compliance_state = compliance_state


class ErrorDefinition(Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Service specific error code which serves as the substatus for
     the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinition]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info:
     list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[TypedErrorInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(Model):
    """Error response.

    :param error: The error details.
    :type error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ExpressionEvaluationDetails(Model):
    """Evaluation details of policy language expressions.

    :param result: Evaluation result.
    :type result: str
    :param expression: Expression evaluated.
    :type expression: str
    :param path: Property path if the expression is a field or an alias.
    :type path: str
    :param expression_value: Value of the expression.
    :type expression_value: object
    :param target_value: Target value to be compared with the expression
     value.
    :type target_value: object
    :param operator: Operator to compare the expression value and the target
     value.
    :type operator: str
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'expression_value': {'key': 'expressionValue', 'type': 'object'},
        'target_value': {'key': 'targetValue', 'type': 'object'},
        'operator': {'key': 'operator', 'type': 'str'},
    }

    def __init__(self, *, result: str=None, expression: str=None, path: str=None, expression_value=None, target_value=None, operator: str=None, **kwargs) -> None:
        super(ExpressionEvaluationDetails, self).__init__(**kwargs)
        self.result = result
        self.expression = expression
        self.path = path
        self.expression_value = expression_value
        self.target_value = target_value
        self.operator = operator


class IfNotExistsEvaluationDetails(Model):
    """Evaluation details of IfNotExists effect.

    :param resource_id: ID of the last evaluated resource for IfNotExists
     effect.
    :type resource_id: str
    :param total_resources: Total number of resources to which the existence
     condition is applicable.
    :type total_resources: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'total_resources': {'key': 'totalResources', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str=None, total_resources: int=None, **kwargs) -> None:
        super(IfNotExistsEvaluationDetails, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.total_resources = total_resources


class Operation(Model):
    """Operation definition.

    :param name: Operation name.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.policyinsights.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, name: str=None, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Resource provider name.
    :type provider: str
    :param resource: Resource name on which the operation is performed.
    :type resource: str
    :param operation: Operation name.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResults(Model):
    """List of available operations.

    :param odatacount: OData entity count; represents the number of operations
     returned.
    :type odatacount: int
    :param value: List of available operations.
    :type value: list[~azure.mgmt.policyinsights.models.Operation]
    """

    _validation = {
        'odatacount': {'minimum': 1},
    }

    _attribute_map = {
        'odatacount': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(self, *, odatacount: int=None, value=None, **kwargs) -> None:
        super(OperationsListResults, self).__init__(**kwargs)
        self.odatacount = odatacount
        self.value = value


class PolicyAssignmentSummary(Model):
    """Policy assignment summary.

    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_set_definition_id: Policy set definition ID, if the policy
     assignment is for a policy set.
    :type policy_set_definition_id: str
    :param results: Compliance summary for the policy assignment.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    :param policy_definitions: Policy definitions summary.
    :type policy_definitions:
     list[~azure.mgmt.policyinsights.models.PolicyDefinitionSummary]
    :param policy_groups: Policy definition group summary.
    :type policy_groups:
     list[~azure.mgmt.policyinsights.models.PolicyGroupSummary]
    """

    _attribute_map = {
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
        'policy_definitions': {'key': 'policyDefinitions', 'type': '[PolicyDefinitionSummary]'},
        'policy_groups': {'key': 'policyGroups', 'type': '[PolicyGroupSummary]'},
    }

    def __init__(self, *, policy_assignment_id: str=None, policy_set_definition_id: str=None, results=None, policy_definitions=None, policy_groups=None, **kwargs) -> None:
        super(PolicyAssignmentSummary, self).__init__(**kwargs)
        self.policy_assignment_id = policy_assignment_id
        self.policy_set_definition_id = policy_set_definition_id
        self.results = results
        self.policy_definitions = policy_definitions
        self.policy_groups = policy_groups


class PolicyDefinitionSummary(Model):
    """Policy definition summary.

    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param policy_definition_reference_id: Policy definition reference ID.
    :type policy_definition_reference_id: str
    :param policy_definition_group_names: Policy definition group names.
    :type policy_definition_group_names: list[str]
    :param effect: Policy effect, i.e. policy definition action.
    :type effect: str
    :param results: Compliance summary for the policy definition.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'policy_definition_group_names': {'key': 'policyDefinitionGroupNames', 'type': '[str]'},
        'effect': {'key': 'effect', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
    }

    def __init__(self, *, policy_definition_id: str=None, policy_definition_reference_id: str=None, policy_definition_group_names=None, effect: str=None, results=None, **kwargs) -> None:
        super(PolicyDefinitionSummary, self).__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.policy_definition_reference_id = policy_definition_reference_id
        self.policy_definition_group_names = policy_definition_group_names
        self.effect = effect
        self.results = results


class PolicyDetails(Model):
    """The policy details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar policy_definition_id: The ID of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_assignment_id: The ID of the policy assignment.
    :vartype policy_assignment_id: str
    :ivar policy_assignment_display_name: The display name of the policy
     assignment.
    :vartype policy_assignment_display_name: str
    :ivar policy_assignment_scope: The scope of the policy assignment.
    :vartype policy_assignment_scope: str
    :ivar policy_set_definition_id: The ID of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID
     within the policy set definition.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        'policy_definition_id': {'readonly': True},
        'policy_assignment_id': {'readonly': True},
        'policy_assignment_display_name': {'readonly': True},
        'policy_assignment_scope': {'readonly': True},
        'policy_set_definition_id': {'readonly': True},
        'policy_definition_reference_id': {'readonly': True},
    }

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_assignment_display_name': {'key': 'policyAssignmentDisplayName', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PolicyDetails, self).__init__(**kwargs)
        self.policy_definition_id = None
        self.policy_assignment_id = None
        self.policy_assignment_display_name = None
        self.policy_assignment_scope = None
        self.policy_set_definition_id = None
        self.policy_definition_reference_id = None


class PolicyEvaluationDetails(Model):
    """Policy evaluation details.

    :param evaluated_expressions: Details of the evaluated expressions.
    :type evaluated_expressions:
     list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
    :param if_not_exists_details: Evaluation details of IfNotExists effect.
    :type if_not_exists_details:
     ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
    """

    _attribute_map = {
        'evaluated_expressions': {'key': 'evaluatedExpressions', 'type': '[ExpressionEvaluationDetails]'},
        'if_not_exists_details': {'key': 'ifNotExistsDetails', 'type': 'IfNotExistsEvaluationDetails'},
    }

    def __init__(self, *, evaluated_expressions=None, if_not_exists_details=None, **kwargs) -> None:
        super(PolicyEvaluationDetails, self).__init__(**kwargs)
        self.evaluated_expressions = evaluated_expressions
        self.if_not_exists_details = if_not_exists_details


class PolicyEvent(Model):
    """Policy event record.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param odataid: OData entity ID; always set to null since policy event
     records do not have an entity ID.
    :type odataid: str
    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param timestamp: Timestamp for the policy event record.
    :type timestamp: datetime
    :param resource_id: Resource ID.
    :type resource_id: str
    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param effective_parameters: Effective parameters for the policy
     assignment.
    :type effective_parameters: str
    :param is_compliant: Flag which states whether the resource is compliant
     against the policy assignment it was evaluated against.
    :type is_compliant: bool
    :param subscription_id: Subscription ID.
    :type subscription_id: str
    :param resource_type: Resource type.
    :type resource_type: str
    :param resource_location: Resource location.
    :type resource_location: str
    :param resource_group: Resource group name.
    :type resource_group: str
    :param resource_tags: List of resource tags.
    :type resource_tags: str
    :param policy_assignment_name: Policy assignment name.
    :type policy_assignment_name: str
    :param policy_assignment_owner: Policy assignment owner.
    :type policy_assignment_owner: str
    :param policy_assignment_parameters: Policy assignment parameters.
    :type policy_assignment_parameters: str
    :param policy_assignment_scope: Policy assignment scope.
    :type policy_assignment_scope: str
    :param policy_definition_name: Policy definition name.
    :type policy_definition_name: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    :param policy_definition_category: Policy definition category.
    :type policy_definition_category: str
    :param policy_set_definition_id: Policy set definition ID, if the policy
     assignment is for a policy set.
    :type policy_set_definition_id: str
    :param policy_set_definition_name: Policy set definition name, if the
     policy assignment is for a policy set.
    :type policy_set_definition_name: str
    :param policy_set_definition_owner: Policy set definition owner, if the
     policy assignment is for a policy set.
    :type policy_set_definition_owner: str
    :param policy_set_definition_category: Policy set definition category, if
     the policy assignment is for a policy set.
    :type policy_set_definition_category: str
    :param policy_set_definition_parameters: Policy set definition parameters,
     if the policy assignment is for a policy set.
    :type policy_set_definition_parameters: str
    :param management_group_ids: Comma separated list of management group IDs,
     which represent the hierarchy of the management groups the resource is
     under.
    :type management_group_ids: str
    :param policy_definition_reference_id: Reference ID for the policy
     definition inside the policy set, if the policy assignment is for a policy
     set.
    :type policy_definition_reference_id: str
    :param compliance_state: Compliance state of the resource.
    :type compliance_state: str
    :param tenant_id: Tenant ID for the policy event record.
    :type tenant_id: str
    :param principal_oid: Principal object ID for the user who initiated the
     resource operation that triggered the policy event.
    :type principal_oid: str
    :param components: Components events records populated only when URL
     contains $expand=components clause.
    :type components:
     list[~azure.mgmt.policyinsights.models.ComponentEventDetails]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odataid': {'key': '@odata\\.id', 'type': 'str'},
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'effective_parameters': {'key': 'effectiveParameters', 'type': 'str'},
        'is_compliant': {'key': 'isCompliant', 'type': 'bool'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_tags': {'key': 'resourceTags', 'type': 'str'},
        'policy_assignment_name': {'key': 'policyAssignmentName', 'type': 'str'},
        'policy_assignment_owner': {'key': 'policyAssignmentOwner', 'type': 'str'},
        'policy_assignment_parameters': {'key': 'policyAssignmentParameters', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_definition_name': {'key': 'policyDefinitionName', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
        'policy_definition_category': {'key': 'policyDefinitionCategory', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_set_definition_name': {'key': 'policySetDefinitionName', 'type': 'str'},
        'policy_set_definition_owner': {'key': 'policySetDefinitionOwner', 'type': 'str'},
        'policy_set_definition_category': {'key': 'policySetDefinitionCategory', 'type': 'str'},
        'policy_set_definition_parameters': {'key': 'policySetDefinitionParameters', 'type': 'str'},
        'management_group_ids': {'key': 'managementGroupIds', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_oid': {'key': 'principalOid', 'type': 'str'},
        'components': {'key': 'components', 'type': '[ComponentEventDetails]'},
    }

    def __init__(self, *, additional_properties=None, odataid: str=None, odatacontext: str=None, timestamp=None, resource_id: str=None, policy_assignment_id: str=None, policy_definition_id: str=None, effective_parameters: str=None, is_compliant: bool=None, subscription_id: str=None, resource_type: str=None, resource_location: str=None, resource_group: str=None, resource_tags: str=None, policy_assignment_name: str=None, policy_assignment_owner: str=None, policy_assignment_parameters: str=None, policy_assignment_scope: str=None, policy_definition_name: str=None, policy_definition_action: str=None, policy_definition_category: str=None, policy_set_definition_id: str=None, policy_set_definition_name: str=None, policy_set_definition_owner: str=None, policy_set_definition_category: str=None, policy_set_definition_parameters: str=None, management_group_ids: str=None, policy_definition_reference_id: str=None, compliance_state: str=None, tenant_id: str=None, principal_oid: str=None, components=None, **kwargs) -> None:
        super(PolicyEvent, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odataid = odataid
        self.odatacontext = odatacontext
        self.timestamp = timestamp
        self.resource_id = resource_id
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_id = policy_definition_id
        self.effective_parameters = effective_parameters
        self.is_compliant = is_compliant
        self.subscription_id = subscription_id
        self.resource_type = resource_type
        self.resource_location = resource_location
        self.resource_group = resource_group
        self.resource_tags = resource_tags
        self.policy_assignment_name = policy_assignment_name
        self.policy_assignment_owner = policy_assignment_owner
        self.policy_assignment_parameters = policy_assignment_parameters
        self.policy_assignment_scope = policy_assignment_scope
        self.policy_definition_name = policy_definition_name
        self.policy_definition_action = policy_definition_action
        self.policy_definition_category = policy_definition_category
        self.policy_set_definition_id = policy_set_definition_id
        self.policy_set_definition_name = policy_set_definition_name
        self.policy_set_definition_owner = policy_set_definition_owner
        self.policy_set_definition_category = policy_set_definition_category
        self.policy_set_definition_parameters = policy_set_definition_parameters
        self.management_group_ids = management_group_ids
        self.policy_definition_reference_id = policy_definition_reference_id
        self.compliance_state = compliance_state
        self.tenant_id = tenant_id
        self.principal_oid = principal_oid
        self.components = components


class PolicyGroupSummary(Model):
    """Policy definition group summary.

    :param policy_group_name: Policy group name.
    :type policy_group_name: str
    :param results: Compliance summary for the policy definition group.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        'policy_group_name': {'key': 'policyGroupName', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
    }

    def __init__(self, *, policy_group_name: str=None, results=None, **kwargs) -> None:
        super(PolicyGroupSummary, self).__init__(**kwargs)
        self.policy_group_name = policy_group_name
        self.results = results


class PolicyMetadata(Model):
    """Policy metadata resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the
     resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: object
    :ivar description: The description of the policy metadata.
    :vartype description: str
    :ivar requirements: The requirements of the policy metadata.
    :vartype requirements: str
    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    """

    _validation = {
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
        'description': {'readonly': True},
        'requirements': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'metadata_id': {'key': 'properties.metadataId', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'owner': {'key': 'properties.owner', 'type': 'str'},
        'additional_content_url': {'key': 'properties.additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'requirements': {'key': 'properties.requirements', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PolicyMetadata, self).__init__(**kwargs)
        self.metadata_id = None
        self.category = None
        self.title = None
        self.owner = None
        self.additional_content_url = None
        self.metadata = None
        self.description = None
        self.requirements = None
        self.id = None
        self.type = None
        self.name = None


class PolicyState(Model):
    """Policy state record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param odataid: OData entity ID; always set to null since policy state
     records do not have an entity ID.
    :type odataid: str
    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param timestamp: Timestamp for the policy state record.
    :type timestamp: datetime
    :param resource_id: Resource ID.
    :type resource_id: str
    :param policy_assignment_id: Policy assignment ID.
    :type policy_assignment_id: str
    :param policy_definition_id: Policy definition ID.
    :type policy_definition_id: str
    :param effective_parameters: Effective parameters for the policy
     assignment.
    :type effective_parameters: str
    :param is_compliant: Flag which states whether the resource is compliant
     against the policy assignment it was evaluated against. This property is
     deprecated; please use ComplianceState instead.
    :type is_compliant: bool
    :param subscription_id: Subscription ID.
    :type subscription_id: str
    :param resource_type: Resource type.
    :type resource_type: str
    :param resource_location: Resource location.
    :type resource_location: str
    :param resource_group: Resource group name.
    :type resource_group: str
    :param resource_tags: List of resource tags.
    :type resource_tags: str
    :param policy_assignment_name: Policy assignment name.
    :type policy_assignment_name: str
    :param policy_assignment_owner: Policy assignment owner.
    :type policy_assignment_owner: str
    :param policy_assignment_parameters: Policy assignment parameters.
    :type policy_assignment_parameters: str
    :param policy_assignment_scope: Policy assignment scope.
    :type policy_assignment_scope: str
    :param policy_definition_name: Policy definition name.
    :type policy_definition_name: str
    :param policy_definition_action: Policy definition action, i.e. effect.
    :type policy_definition_action: str
    :param policy_definition_category: Policy definition category.
    :type policy_definition_category: str
    :param policy_set_definition_id: Policy set definition ID, if the policy
     assignment is for a policy set.
    :type policy_set_definition_id: str
    :param policy_set_definition_name: Policy set definition name, if the
     policy assignment is for a policy set.
    :type policy_set_definition_name: str
    :param policy_set_definition_owner: Policy set definition owner, if the
     policy assignment is for a policy set.
    :type policy_set_definition_owner: str
    :param policy_set_definition_category: Policy set definition category, if
     the policy assignment is for a policy set.
    :type policy_set_definition_category: str
    :param policy_set_definition_parameters: Policy set definition parameters,
     if the policy assignment is for a policy set.
    :type policy_set_definition_parameters: str
    :param management_group_ids: Comma separated list of management group IDs,
     which represent the hierarchy of the management groups the resource is
     under.
    :type management_group_ids: str
    :param policy_definition_reference_id: Reference ID for the policy
     definition inside the policy set, if the policy assignment is for a policy
     set.
    :type policy_definition_reference_id: str
    :param compliance_state: Compliance state of the resource.
    :type compliance_state: str
    :param policy_evaluation_details: Policy evaluation details.
    :type policy_evaluation_details:
     ~azure.mgmt.policyinsights.models.PolicyEvaluationDetails
    :param policy_definition_group_names: Policy definition group names.
    :type policy_definition_group_names: list[str]
    :param components: Components state compliance records populated only when
     URL contains $expand=components clause.
    :type components:
     list[~azure.mgmt.policyinsights.models.ComponentStateDetails]
    :ivar policy_definition_version: Evaluated policy definition version.
    :vartype policy_definition_version: str
    :ivar policy_set_definition_version: Evaluated policy set definition
     version.
    :vartype policy_set_definition_version: str
    :ivar policy_assignment_version: Evaluated policy assignment version.
    :vartype policy_assignment_version: str
    """

    _validation = {
        'policy_definition_version': {'readonly': True},
        'policy_set_definition_version': {'readonly': True},
        'policy_assignment_version': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'odataid': {'key': '@odata\\.id', 'type': 'str'},
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'policy_assignment_id': {'key': 'policyAssignmentId', 'type': 'str'},
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'effective_parameters': {'key': 'effectiveParameters', 'type': 'str'},
        'is_compliant': {'key': 'isCompliant', 'type': 'bool'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'resource_tags': {'key': 'resourceTags', 'type': 'str'},
        'policy_assignment_name': {'key': 'policyAssignmentName', 'type': 'str'},
        'policy_assignment_owner': {'key': 'policyAssignmentOwner', 'type': 'str'},
        'policy_assignment_parameters': {'key': 'policyAssignmentParameters', 'type': 'str'},
        'policy_assignment_scope': {'key': 'policyAssignmentScope', 'type': 'str'},
        'policy_definition_name': {'key': 'policyDefinitionName', 'type': 'str'},
        'policy_definition_action': {'key': 'policyDefinitionAction', 'type': 'str'},
        'policy_definition_category': {'key': 'policyDefinitionCategory', 'type': 'str'},
        'policy_set_definition_id': {'key': 'policySetDefinitionId', 'type': 'str'},
        'policy_set_definition_name': {'key': 'policySetDefinitionName', 'type': 'str'},
        'policy_set_definition_owner': {'key': 'policySetDefinitionOwner', 'type': 'str'},
        'policy_set_definition_category': {'key': 'policySetDefinitionCategory', 'type': 'str'},
        'policy_set_definition_parameters': {'key': 'policySetDefinitionParameters', 'type': 'str'},
        'management_group_ids': {'key': 'managementGroupIds', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'policy_evaluation_details': {'key': 'policyEvaluationDetails', 'type': 'PolicyEvaluationDetails'},
        'policy_definition_group_names': {'key': 'policyDefinitionGroupNames', 'type': '[str]'},
        'components': {'key': 'components', 'type': '[ComponentStateDetails]'},
        'policy_definition_version': {'key': 'policyDefinitionVersion', 'type': 'str'},
        'policy_set_definition_version': {'key': 'policySetDefinitionVersion', 'type': 'str'},
        'policy_assignment_version': {'key': 'policyAssignmentVersion', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, odataid: str=None, odatacontext: str=None, timestamp=None, resource_id: str=None, policy_assignment_id: str=None, policy_definition_id: str=None, effective_parameters: str=None, is_compliant: bool=None, subscription_id: str=None, resource_type: str=None, resource_location: str=None, resource_group: str=None, resource_tags: str=None, policy_assignment_name: str=None, policy_assignment_owner: str=None, policy_assignment_parameters: str=None, policy_assignment_scope: str=None, policy_definition_name: str=None, policy_definition_action: str=None, policy_definition_category: str=None, policy_set_definition_id: str=None, policy_set_definition_name: str=None, policy_set_definition_owner: str=None, policy_set_definition_category: str=None, policy_set_definition_parameters: str=None, management_group_ids: str=None, policy_definition_reference_id: str=None, compliance_state: str=None, policy_evaluation_details=None, policy_definition_group_names=None, components=None, **kwargs) -> None:
        super(PolicyState, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odataid = odataid
        self.odatacontext = odatacontext
        self.timestamp = timestamp
        self.resource_id = resource_id
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_id = policy_definition_id
        self.effective_parameters = effective_parameters
        self.is_compliant = is_compliant
        self.subscription_id = subscription_id
        self.resource_type = resource_type
        self.resource_location = resource_location
        self.resource_group = resource_group
        self.resource_tags = resource_tags
        self.policy_assignment_name = policy_assignment_name
        self.policy_assignment_owner = policy_assignment_owner
        self.policy_assignment_parameters = policy_assignment_parameters
        self.policy_assignment_scope = policy_assignment_scope
        self.policy_definition_name = policy_definition_name
        self.policy_definition_action = policy_definition_action
        self.policy_definition_category = policy_definition_category
        self.policy_set_definition_id = policy_set_definition_id
        self.policy_set_definition_name = policy_set_definition_name
        self.policy_set_definition_owner = policy_set_definition_owner
        self.policy_set_definition_category = policy_set_definition_category
        self.policy_set_definition_parameters = policy_set_definition_parameters
        self.management_group_ids = management_group_ids
        self.policy_definition_reference_id = policy_definition_reference_id
        self.compliance_state = compliance_state
        self.policy_evaluation_details = policy_evaluation_details
        self.policy_definition_group_names = policy_definition_group_names
        self.components = components
        self.policy_definition_version = None
        self.policy_set_definition_version = None
        self.policy_assignment_version = None


class PolicyTrackedResource(Model):
    """Policy tracked resource record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tracked_resource_id: The ID of the policy tracked resource.
    :vartype tracked_resource_id: str
    :ivar policy_details: The details of the policy that require the tracked
     resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar created_by: The details of the policy triggered deployment that
     created the tracked resource.
    :vartype created_by:
     ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_modified_by: The details of the policy triggered deployment
     that modified the tracked resource.
    :vartype last_modified_by:
     ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_update_utc: Timestamp of the last update to the tracked
     resource.
    :vartype last_update_utc: datetime
    """

    _validation = {
        'tracked_resource_id': {'readonly': True},
        'policy_details': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_update_utc': {'readonly': True},
    }

    _attribute_map = {
        'tracked_resource_id': {'key': 'trackedResourceId', 'type': 'str'},
        'policy_details': {'key': 'policyDetails', 'type': 'PolicyDetails'},
        'created_by': {'key': 'createdBy', 'type': 'TrackedResourceModificationDetails'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'TrackedResourceModificationDetails'},
        'last_update_utc': {'key': 'lastUpdateUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(PolicyTrackedResource, self).__init__(**kwargs)
        self.tracked_resource_id = None
        self.policy_details = None
        self.created_by = None
        self.last_modified_by = None
        self.last_update_utc = None


class QueryFailure(Model):
    """Error response.

    :param error: Error definition.
    :type error: ~azure.mgmt.policyinsights.models.QueryFailureError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'QueryFailureError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(QueryFailure, self).__init__(**kwargs)
        self.error = error


class QueryFailureException(HttpOperationError):
    """Server responsed with exception of type: 'QueryFailure'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(QueryFailureException, self).__init__(deserialize, response, 'QueryFailure', *args)


class QueryFailureError(Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Service specific error code which serves as the substatus for
     the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(QueryFailureError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class QueryOptions(Model):
    """Additional parameters for a set of operations.

    :param top: Maximum number of records to return.
    :type top: int
    :param filter: OData filter expression.
    :type filter: str
    :param order_by: Ordering expression using OData notation. One or more
     comma-separated column names with an optional "desc" (the default) or
     "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
    :type order_by: str
    :param select: Select expression using OData notation. Limits the columns
     on each record to just those requested, e.g. "$select=PolicyAssignmentId,
     ResourceId".
    :type select: str
    :param from_property: ISO 8601 formatted timestamp specifying the start
     time of the interval to query. When not specified, the service uses ($to -
     1-day).
    :type from_property: datetime
    :param to: ISO 8601 formatted timestamp specifying the end time of the
     interval to query. When not specified, the service uses request time.
    :type to: datetime
    :param apply: OData apply expression for aggregations.
    :type apply: str
    :param skip_token: Skiptoken is only provided if a previous response
     returned a partial result as a part of nextLink element.
    :type skip_token: str
    :param expand: The $expand query parameter. For example, to expand
     components use $expand=components
    :type expand: str
    """

    _attribute_map = {
        'top': {'key': '', 'type': 'int'},
        'filter': {'key': '', 'type': 'str'},
        'order_by': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'from_property': {'key': '', 'type': 'iso-8601'},
        'to': {'key': '', 'type': 'iso-8601'},
        'apply': {'key': '', 'type': 'str'},
        'skip_token': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
    }

    def __init__(self, *, top: int=None, filter: str=None, order_by: str=None, select: str=None, from_property=None, to=None, apply: str=None, skip_token: str=None, expand: str=None, **kwargs) -> None:
        super(QueryOptions, self).__init__(**kwargs)
        self.top = top
        self.filter = filter
        self.order_by = order_by
        self.select = select
        self.from_property = from_property
        self.to = to
        self.apply = apply
        self.skip_token = skip_token
        self.expand = expand


class Remediation(Model):
    """The remediation definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param policy_assignment_id: The resource ID of the policy assignment that
     should be remediated.
    :type policy_assignment_id: str
    :param policy_definition_reference_id: The policy definition reference ID
     of the individual definition that should be remediated. Required when the
     policy assignment being remediated assigns a policy set definition.
    :type policy_definition_reference_id: str
    :param resource_discovery_mode: The way resources to remediate are
     discovered. Defaults to ExistingNonCompliant if not specified. Possible
     values include: 'ExistingNonCompliant', 'ReEvaluateCompliance'
    :type resource_discovery_mode: str or
     ~azure.mgmt.policyinsights.models.ResourceDiscoveryMode
    :ivar provisioning_state: The status of the remediation.
    :vartype provisioning_state: str
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: datetime
    :ivar last_updated_on: The time at which the remediation was last updated.
    :vartype last_updated_on: datetime
    :param filters: The filters that will be applied to determine which
     resources to remediate.
    :type filters: ~azure.mgmt.policyinsights.models.RemediationFilters
    :ivar deployment_status: The deployment status summary for all deployments
     created by the remediation.
    :vartype deployment_status:
     ~azure.mgmt.policyinsights.models.RemediationDeploymentSummary
    :ivar id: The ID of the remediation.
    :vartype id: str
    :ivar type: The type of the remediation.
    :vartype type: str
    :ivar name: The name of the remediation.
    :vartype name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'deployment_status': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'policy_assignment_id': {'key': 'properties.policyAssignmentId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'properties.policyDefinitionReferenceId', 'type': 'str'},
        'resource_discovery_mode': {'key': 'properties.resourceDiscoveryMode', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'filters': {'key': 'properties.filters', 'type': 'RemediationFilters'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'RemediationDeploymentSummary'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, policy_assignment_id: str=None, policy_definition_reference_id: str=None, resource_discovery_mode=None, filters=None, **kwargs) -> None:
        super(Remediation, self).__init__(**kwargs)
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_reference_id = policy_definition_reference_id
        self.resource_discovery_mode = resource_discovery_mode
        self.provisioning_state = None
        self.created_on = None
        self.last_updated_on = None
        self.filters = filters
        self.deployment_status = None
        self.id = None
        self.type = None
        self.name = None


class RemediationDeployment(Model):
    """Details of a single deployment created by the remediation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar remediated_resource_id: Resource ID of the resource that is being
     remediated by the deployment.
    :vartype remediated_resource_id: str
    :ivar deployment_id: Resource ID of the template deployment that will
     remediate the resource.
    :vartype deployment_id: str
    :ivar status: Status of the remediation deployment.
    :vartype status: str
    :ivar resource_location: Location of the resource that is being
     remediated.
    :vartype resource_location: str
    :ivar error: Error encountered while remediated the resource.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: datetime
    :ivar last_updated_on: The time at which the remediation deployment was
     last updated.
    :vartype last_updated_on: datetime
    """

    _validation = {
        'remediated_resource_id': {'readonly': True},
        'deployment_id': {'readonly': True},
        'status': {'readonly': True},
        'resource_location': {'readonly': True},
        'error': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
    }

    _attribute_map = {
        'remediated_resource_id': {'key': 'remediatedResourceId', 'type': 'str'},
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'lastUpdatedOn', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(RemediationDeployment, self).__init__(**kwargs)
        self.remediated_resource_id = None
        self.deployment_id = None
        self.status = None
        self.resource_location = None
        self.error = None
        self.created_on = None
        self.last_updated_on = None


class RemediationDeploymentSummary(Model):
    """The deployment status summary for all deployments created by the
    remediation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total_deployments: The number of deployments required by the
     remediation.
    :vartype total_deployments: int
    :ivar successful_deployments: The number of deployments required by the
     remediation that have succeeded.
    :vartype successful_deployments: int
    :ivar failed_deployments: The number of deployments required by the
     remediation that have failed.
    :vartype failed_deployments: int
    """

    _validation = {
        'total_deployments': {'readonly': True},
        'successful_deployments': {'readonly': True},
        'failed_deployments': {'readonly': True},
    }

    _attribute_map = {
        'total_deployments': {'key': 'totalDeployments', 'type': 'int'},
        'successful_deployments': {'key': 'successfulDeployments', 'type': 'int'},
        'failed_deployments': {'key': 'failedDeployments', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(RemediationDeploymentSummary, self).__init__(**kwargs)
        self.total_deployments = None
        self.successful_deployments = None
        self.failed_deployments = None


class RemediationFilters(Model):
    """The filters that will be applied to determine which resources to remediate.

    :param locations: The resource locations that will be remediated.
    :type locations: list[str]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
    }

    def __init__(self, *, locations=None, **kwargs) -> None:
        super(RemediationFilters, self).__init__(**kwargs)
        self.locations = locations


class SlimPolicyMetadata(Model):
    """Slim version of policy metadata resource definition, excluding properties
    with large strings.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the
     resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: object
    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    """

    _validation = {
        'metadata_id': {'readonly': True},
        'category': {'readonly': True},
        'title': {'readonly': True},
        'owner': {'readonly': True},
        'additional_content_url': {'readonly': True},
        'metadata': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'metadata_id': {'key': 'properties.metadataId', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'owner': {'key': 'properties.owner', 'type': 'str'},
        'additional_content_url': {'key': 'properties.additionalContentUrl', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(SlimPolicyMetadata, self).__init__(**kwargs)
        self.metadata_id = None
        self.category = None
        self.title = None
        self.owner = None
        self.additional_content_url = None
        self.metadata = None
        self.id = None
        self.type = None
        self.name = None


class SummarizeResults(Model):
    """Summarize action results.

    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param odatacount: OData entity count; represents the number of summaries
     returned; always set to 1.
    :type odatacount: int
    :param value: Summarize action results.
    :type value: list[~azure.mgmt.policyinsights.models.Summary]
    """

    _validation = {
        'odatacount': {'maximum': 1, 'minimum': 1},
    }

    _attribute_map = {
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'odatacount': {'key': '@odata\\.count', 'type': 'int'},
        'value': {'key': 'value', 'type': '[Summary]'},
    }

    def __init__(self, *, odatacontext: str=None, odatacount: int=None, value=None, **kwargs) -> None:
        super(SummarizeResults, self).__init__(**kwargs)
        self.odatacontext = odatacontext
        self.odatacount = odatacount
        self.value = value


class Summary(Model):
    """Summary results.

    :param odataid: OData entity ID; always set to null since summaries do not
     have an entity ID.
    :type odataid: str
    :param odatacontext: OData context string; used by OData clients to
     resolve type information based on metadata.
    :type odatacontext: str
    :param results: Compliance summary for all policy assignments.
    :type results: ~azure.mgmt.policyinsights.models.SummaryResults
    :param policy_assignments: Policy assignments summary.
    :type policy_assignments:
     list[~azure.mgmt.policyinsights.models.PolicyAssignmentSummary]
    """

    _attribute_map = {
        'odataid': {'key': '@odata\\.id', 'type': 'str'},
        'odatacontext': {'key': '@odata\\.context', 'type': 'str'},
        'results': {'key': 'results', 'type': 'SummaryResults'},
        'policy_assignments': {'key': 'policyAssignments', 'type': '[PolicyAssignmentSummary]'},
    }

    def __init__(self, *, odataid: str=None, odatacontext: str=None, results=None, policy_assignments=None, **kwargs) -> None:
        super(Summary, self).__init__(**kwargs)
        self.odataid = odataid
        self.odatacontext = odatacontext
        self.results = results
        self.policy_assignments = policy_assignments


class SummaryResults(Model):
    """Compliance summary on a particular summary level.

    :param query_results_uri: HTTP POST URI for queryResults action on
     Microsoft.PolicyInsights to retrieve raw results for the compliance
     summary. This property will not be available by default in future API
     versions, but could be queried explicitly.
    :type query_results_uri: str
    :param non_compliant_resources: Number of non-compliant resources.
    :type non_compliant_resources: int
    :param non_compliant_policies: Number of non-compliant policies.
    :type non_compliant_policies: int
    :param resource_details: The resources summary at this level.
    :type resource_details:
     list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :param policy_details: The policy artifact summary at this level. For
     query scope level, it represents policy assignment summary. For policy
     assignment level, it represents policy definitions summary.
    :type policy_details:
     list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :param policy_group_details: The policy definition group summary at this
     level.
    :type policy_group_details:
     list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    """

    _validation = {
        'non_compliant_resources': {'minimum': 0},
        'non_compliant_policies': {'minimum': 0},
    }

    _attribute_map = {
        'query_results_uri': {'key': 'queryResultsUri', 'type': 'str'},
        'non_compliant_resources': {'key': 'nonCompliantResources', 'type': 'int'},
        'non_compliant_policies': {'key': 'nonCompliantPolicies', 'type': 'int'},
        'resource_details': {'key': 'resourceDetails', 'type': '[ComplianceDetail]'},
        'policy_details': {'key': 'policyDetails', 'type': '[ComplianceDetail]'},
        'policy_group_details': {'key': 'policyGroupDetails', 'type': '[ComplianceDetail]'},
    }

    def __init__(self, *, query_results_uri: str=None, non_compliant_resources: int=None, non_compliant_policies: int=None, resource_details=None, policy_details=None, policy_group_details=None, **kwargs) -> None:
        super(SummaryResults, self).__init__(**kwargs)
        self.query_results_uri = query_results_uri
        self.non_compliant_resources = non_compliant_resources
        self.non_compliant_policies = non_compliant_policies
        self.resource_details = resource_details
        self.policy_details = policy_details
        self.policy_group_details = policy_group_details


class TrackedResourceModificationDetails(Model):
    """The details of the policy triggered deployment that created or modified the
    tracked resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar policy_details: The details of the policy that created or modified
     the tracked resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar deployment_id: The ID of the deployment that created or modified the
     tracked resource.
    :vartype deployment_id: str
    :ivar deployment_time: Timestamp of the deployment that created or
     modified the tracked resource.
    :vartype deployment_time: datetime
    """

    _validation = {
        'policy_details': {'readonly': True},
        'deployment_id': {'readonly': True},
        'deployment_time': {'readonly': True},
    }

    _attribute_map = {
        'policy_details': {'key': 'policyDetails', 'type': 'PolicyDetails'},
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'deployment_time': {'key': 'deploymentTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs) -> None:
        super(TrackedResourceModificationDetails, self).__init__(**kwargs)
        self.policy_details = None
        self.deployment_id = None
        self.deployment_time = None


class TypedErrorInfo(Model):
    """Scenario specific error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of included error details.
    :vartype type: str
    :ivar info: The scenario specific error details.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(TypedErrorInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None
