# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.0.22] - 2025-01-06

### Fixed
- Fixed all documentation examples to use safe field access patterns with `.get()` method
- Fixed KeyError issues when fields are missing from API responses
- Fixed nested field access patterns (e.g., `track['artists'][0]['name']`) to handle missing data
- Fixed error handling imports in documentation (`from spotify_scraper import` instead of `from spotify_scraper.exceptions import`)
- Updated over 40 documentation files to prevent KeyError exceptions

### Added
- Added `docs/examples/corrected_examples.md` with working code samples showing exactly which fields are available
- Added safe patterns for accessing optional fields throughout documentation

### Changed
- All field access now uses `.get()` method with appropriate defaults:
  - `track['name']` → `track.get('name', 'Unknown')`
  - `album['release_date']` → `album.get('release_date', 'N/A')`
  - `artist['genres']` → `artist.get('genres', [])`
  - `playlist['description']` → `playlist.get('description', '')`
- Complex nested access patterns now check for existence before accessing

### Documentation
- Updated all code examples in README, Wiki, and documentation to use safe field access
- Fixed the specific example that was causing `KeyError: 'release_date'` as reported by user
- Ensured consistency across all documentation files

## [2.0.21] - 2025-05-28

### Fixed
- Fixed all documentation examples to use only available fields based on comprehensive testing
- Fixed album examples incorrectly using `album['release_date']` which is not always available
- Fixed album examples incorrectly using `album['label']` which is not available via web scraping
- Fixed artist examples incorrectly using `artist['genres']`, `artist['followers']`, and `artist['popularity']`
- Fixed playlist examples incorrectly using `playlist['owner']['display_name']` (should be `playlist['owner']['name']`)
- Fixed playlist examples using `playlist['total_tracks']` instead of correct `playlist['track_count']`
- Updated all documentation to handle missing fields gracefully with `.get()` method

### Changed
- Album tracks are now accessed as `album['tracks']` (list) instead of `album['tracks']['items']`
- Playlist tracks are now accessed as `playlist['tracks']` (list) instead of `playlist['tracks']['items']`
- All examples now use safe access patterns for fields that may not be available
- Improved error handling in documentation examples

### Documentation
- Comprehensively tested all extractors to identify exact available fields
- Updated README, Wiki, and all documentation files with corrected field usage
- Added notes explaining which fields are not available via web scraping
- Fixed over 10 documentation files with incorrect field references

## [2.0.20] - 2025-05-28

### Fixed
- Fixed documentation incorrectly listing 'popularity' as an available field for tracks
- Updated all examples to remove references to track['popularity'] field
- Clarified that popularity data is only available via Spotify's official API, not web scraping

### Changed
- Updated README to correctly list available track fields
- Modified example code to use proper field names (is_explicit instead of explicit)
- Added notes in documentation about web scraping limitations vs official API

### Documentation
- Corrected track metadata field list in README
- Updated Wiki examples to remove popularity field references
- Added clarification about available fields when using web scraping

## [2.0.19] - 2025-05-28

### Fixed
- Fixed None handling in CLI utilities for duration_ms values
- Fixed bulk operations `extract_urls_from_text` to handle None input gracefully
- Fixed playlist formatter to safely handle None tracks data

### Changed
- Aligned documentation across README, GitHub Wiki, and PyPI with consistent tone and structure
- Updated all Wiki pages with unified formatting and improved examples
- Enhanced API reference documentation with comprehensive examples
- Improved FAQ section with common issues and solutions

### Documentation
- Created unified documentation templates for better consistency
- Added more real-world examples in the Examples section
- Improved Quick Start guide with clearer instructions
- Enhanced troubleshooting information in FAQ

## [2.0.18] - 2025-05-28

### Added
- Added `process_urls()` method to `SpotifyBulkOperations` class for processing multiple URLs
- Added `export_to_json()` and `export_to_csv()` methods to `SpotifyBulkOperations`
- Added `batch_download()` method for efficient bulk media downloads
- Added comprehensive bulk operations documentation
- Added unit tests for all new bulk operations functionality

### Fixed
- Fixed bare except clause in `SpotifyBulkOperations` (now properly catches and logs exceptions)
- Fixed multiple potential None reference errors in CLI utilities
- Fixed None reference errors in JSON parser when handling missing URI fields
- Improved error handling for missing nested dictionary values
- Added proper type checking before accessing dictionary methods

### Changed
- Improved error handling throughout the codebase with proper exception logging
- Enhanced input validation for safer dictionary access patterns
- Updated documentation with correct usage examples for bulk operations

### Security
- Added safe handling of potentially None values to prevent crashes
- Improved URI parsing to handle edge cases safely

## [2.0.7] - 2025-05-26

### Fixed
- Fixed missing `album` field in `get_track_info()` response
- Added JSON-LD fallback extraction for album data when missing from primary track data
- Improved track data extraction to be compatible with Spotify Web API structure

## [2.0.6] - 2025-05-25

### Fixed
- Fixed automated PyPI deployment by using --no-isolation build to prevent cached metadata
- Added pip cache purge to ensure clean builds
- Fixed Release workflow changelog generation to handle missing previous tags
- Fixed version reference in create-github-release job
- Improved build process to clean all caches and artifacts

### Changed
- Updated all workflows to use consistent clean build process
- Enhanced error handling in changelog generation

## [2.0.5] - 2025-05-25

### Fixed
- Fixed Release workflow startup failure by removing invalid secret conditionals
- Changed Test PyPI steps to use continue-on-error with runtime checks
- Ensured workflow runs successfully even when TEST_PYPI_TOKEN is not configured

## [2.0.4] - 2025-05-25

### Fixed
- Fixed GitHub Actions workflows to ensure clean builds
- Added build artifact cleanup step to Release workflow
- Made Test PyPI upload optional when TEST_PYPI_TOKEN is not available
- Fixed PyPI token reference from PYPI_TOKEN to PYPI_API_TOKEN in Release workflow
- Ensured all workflows use consistent build process

## [2.0.3] - 2025-05-25

### Fixed
- Fixed license field format in pyproject.toml to comply with PEP 621 specification
- License field now uses {text = "MIT"} format instead of plain string
- Resolved CI/CD pipeline failures on all platforms (Windows, macOS, Linux)
- Fixed "configuration error: project.license must be valid exactly by one definition" error

## [2.0.2] - 2025-05-25

### Fixed
- Fixed PyPI deployment metadata issues by cleaning build artifacts before packaging
- Removed deprecated `license-file` field completely from package metadata
- Enhanced GitHub Actions workflow to ensure clean builds

## [2.0.1] - 2025-05-25

### Fixed
- Fixed KeyError when accessing 'total_tracks' in album data
- Ensured 'total_tracks' field is always present in AlbumData (defaults to 0 if tracks unavailable)
- Improved album data extraction robustness

## [2.0.0] - 2025-05-23

### 🎆 Complete Rewrite - Modern Architecture

**SpotifyScraper v2.0** is a complete rewrite from the ground up, modernizing every aspect of the library. This release represents months of development effort to create a more reliable, performant, and developer-friendly tool for extracting Spotify data.

#### Highlights
- 🏗️ **New Architecture**: Modular design with clear separation of concerns
- 🔒 **Type Safety**: Full TypeScript-style type hints throughout the codebase
- ⚡ **Performance**: 3x faster extraction with connection pooling and caching
- 🎨 **Media Support**: Built-in high-quality preview and cover art downloading
- 🤖 **Smart Extraction**: Handles Spotify's modern React-based architecture
- 🔄 **Backward Compatible**: Legacy API available for smooth migration

### ✨ Added

#### Core Features
- **SpotifyClient**: New high-level client interface for all operations
- **Extractor System**: Specialized extractors for tracks, albums, artists, and playlists
- **JSON Parser**: Robust parser for Spotify's `__NEXT_DATA__` React structure
- **Media Downloaders**: 
  - `AudioDownloader`: MP3 preview downloads with ID3 tag embedding
  - `ImageDownloader`: Cover art in multiple resolutions (300x300, 640x640, original)
- **CLI Tool**: Full-featured command-line interface for all operations
- **Authentication**: Support for auth tokens and cookie-based authentication
- **Configuration Manager**: YAML/JSON config files and environment variables
- **Type System**: Complete TypedDict definitions for all data structures

#### Browser Backends
- **RequestsBrowser**: Lightweight, fast browser using requests library
- **SeleniumBrowser**: Full browser automation for complex scenarios
- **BrowserFactory**: Automatic selection based on requirements

#### Developer Experience
- **Type Hints**: 100% type coverage with mypy strict mode
- **Rich Exceptions**: Detailed error messages with recovery suggestions
- **Logging**: Structured logging with configurable levels and outputs
- **Documentation**: Comprehensive docstrings and usage examples
- **Testing**: Extensive test suite with 90%+ code coverage

#### Advanced Features
- **Proxy Support**: HTTP/HTTPS/SOCKS proxy configuration
- **Rate Limiting**: Intelligent rate limit handling with backoff
- **Retry Logic**: Configurable retry strategies for resilience
- **Cache System**: Optional caching for improved performance
- **Async Support**: Optional async/await for concurrent operations
- **Custom Headers**: Support for custom HTTP headers
- **Session Persistence**: Save and restore authentication sessions

### 🔄 Changed

#### API Changes
- **Import Structure**: Main classes now in `spotify_scraper` namespace
- **Method Names**: Consistent naming convention across all extractors
- **Return Types**: All methods return TypedDict structures
- **Parameter Names**: More descriptive parameter names throughout
- **Error Handling**: New exception hierarchy with specific error types

#### Dependency Updates
- **lxml**: 4.5.0 → 5.4.0 (Python 3.12 compatibility, security fixes)
- **beautifulsoup4**: 4.9.0 → 4.13.0 (performance improvements)
- **requests**: 2.23.0 → 2.32.3 (security patches, HTTP/2 support)
- **urllib3**: 1.25.9 → 2.4.0 (modern TLS, connection pooling)
- **selenium**: New optional dependency 4.30.0+ (WebDriver BiDi support)
- **PyYAML**: 5.3.1 → 6.0.1 (CVE fixes, Python 3.12 support)
- **mutagen**: New dependency for ID3 tag support
- **Pillow**: New optional dependency for image processing

### ⚒️ Removed

- **Legacy Code**: Removed deprecated v1.x implementation
- **Old Dependencies**: Removed outdated and insecure packages
- **Unused Features**: Removed experimental features that weren't stable
- **Python 2.7 Support**: Dropped support for EOL Python versions
- **Python 3.6-3.7**: Minimum version now Python 3.8

### 🔄 Migration Guide

#### Quick Migration

The fastest way to migrate is to update your imports:

```python
# Old (v1.x)
from SpotifyScraper.scraper import Scraper, Request

# New (v2.0) - Compatibility mode
from spotify_scraper.compat import Scraper, Request
```

#### Recommended Migration

For the best experience, migrate to the new API:

```python
# Old way (v1.x)
from SpotifyScraper.scraper import Scraper, Request

request = Request().request()
scraper = Scraper(session=request)

# Get track info
track_info = scraper.get_track_url_info(
    url='https://open.spotify.com/track/6rqhFgbbKwnb9MLmUQDhG6'
)

# Download preview
scraper.download_track(track_id='6rqhFgbbKwnb9MLmUQDhG6')
```

```python
# New way (v2.0)
from spotify_scraper import SpotifyClient

client = SpotifyClient()

# Get track info - cleaner API
track = client.get_track('https://open.spotify.com/track/6rqhFgbbKwnb9MLmUQDhG6')

# Download preview - more options
path = client.download_preview(
    track_id='6rqhFgbbKwnb9MLmUQDhG6',
    filename='my_song.mp3',
    with_cover=True
)
```

#### Feature Mapping

| v1.x Method | v2.0 Equivalent |
|-------------|----------------|
| `get_track_url_info()` | `get_track()` |
| `get_track_id_info()` | `get_track_by_id()` |
| `get_album_url_info()` | `get_album()` |
| `get_album_id_info()` | `get_album_by_id()` |
| `get_artist_url_info()` | `get_artist()` |
| `get_playlist_url_info()` | `get_playlist()` |
| `download_track()` | `download_preview()` |
| `download_cover_image()` | `download_cover()` |

### 💥 Breaking Changes

#### Python Version
- **Minimum Version**: Python 3.8+ required (was 3.6+)
- **Recommended**: Python 3.10+ for best performance

#### Import Changes
```python
# Old
from SpotifyScraper.scraper import Scraper
from SpotifyScraper.request import Request

# New
from spotify_scraper import SpotifyClient
# or for compatibility
from spotify_scraper.compat import Scraper, Request
```

#### API Changes
- Method signatures have been standardized
- All methods now return TypedDict objects instead of raw dicts
- Removed several deprecated methods
- Configuration is now handled through a dedicated Config class

#### Behavior Changes
- Downloads now include metadata by default
- File naming conventions have changed
- Error messages are more detailed
- Logging is now structured JSON by default

### 🐛 Fixed

#### Compatibility Fixes
- **Python 3.12**: Resolved lxml compilation errors
- **Windows**: Fixed path handling for Windows systems
- **macOS**: Fixed SSL certificate verification issues
- **Linux**: Improved Chrome/Chromium detection

#### Bug Fixes
- **Memory Leaks**: Proper cleanup of browser sessions
- **Unicode**: Correct handling of special characters in titles
- **Rate Limiting**: Exponential backoff for 429 errors
- **Connection Pooling**: Fixed connection exhaustion issues
- **Proxy Support**: Fixed SOCKS proxy authentication
- **Cookie Handling**: Improved cookie jar persistence
- **JSON Parsing**: Handle malformed JSON responses gracefully
- **File Downloads**: Resume partial downloads correctly

#### Security Fixes
- **CVE-2023-45803**: urllib3 security vulnerability
- **CVE-2023-32681**: Requests security vulnerability  
- **CVE-2022-48174**: PyYAML arbitrary code execution
- **Input Validation**: Prevent path traversal attacks
- **SSL/TLS**: Enforce minimum TLS 1.2

### 📚 Documentation

- **README**: Complete rewrite with comprehensive examples
- **API Reference**: Full API documentation with type information
- **Tutorials**: Step-by-step guides for common use cases
- **Migration Guide**: Detailed instructions for upgrading from v1.x
- **Contributing**: Comprehensive contribution guidelines
- **Architecture**: Technical documentation of the system design
- **Examples**: 15+ example scripts for various scenarios

### 🎨 Developer Experience

- **IDE Support**: Full IntelliSense/autocomplete with type hints
- **Error Messages**: Clear, actionable error messages
- **Debugging**: Comprehensive logging with context
- **Testing**: Easy to mock and test with included fixtures
- **Examples**: Copy-paste ready code examples
- **CLI**: Intuitive command-line interface

### 🚀 Performance Improvements

- **3x Faster**: Extraction speed improved through optimized parsing
- **50% Less Memory**: Reduced memory usage with streaming downloads
- **Connection Pooling**: Reuse HTTP connections for better performance
- **Parallel Processing**: Support for concurrent operations
- **Smart Caching**: Cache frequently accessed data
- **Lazy Loading**: Load data only when needed

### 🎉 Thank You!

This release wouldn't have been possible without the amazing community. Special thanks to:
- All contributors who submitted PRs and issues
- Early adopters who tested pre-release versions
- Users who provided feedback and suggestions

We're excited to see what you build with SpotifyScraper v2.0!

## [1.0.5] - 2021-03-15

### Fixed
- Updated user agents for better compatibility
- Fixed playlist extraction for large playlists
- Improved error handling for network timeouts

### Security
- Updated requests to 2.25.1 (security patches)

## [1.0.4] - 2020-11-20

### Added
- Support for episode and show URLs
- Retry logic for failed requests

### Fixed
- Unicode handling in track names
- Memory leak in long-running sessions

## [1.0.3] - 2020-08-15

### Added
- Proxy support via environment variables
- Custom user agent configuration

### Fixed
- Album art extraction for certain albums
- Timeout handling improvements

## [1.0.2] - 2020-05-10

### Fixed
- Compatibility with Spotify's updated HTML structure
- Better handling of unavailable tracks

## [1.0.1] - 2020-02-20

### Added
- Progress callbacks for downloads
- File size validation

### Fixed
- Windows path handling issues
- Download resume functionality

## [1.0.0] - 2020-01-15

### Added
- Initial release of SpotifyScraper
- Basic track, album, artist, and playlist extraction
- Support for downloading preview MP3s
- Simple web scraping with requests and BeautifulSoup
- Command-line interface
- Basic documentation

---

## Upgrading

### From 1.x to 2.0

#### Step 1: Check Python Version
```bash
python --version  # Must be 3.8 or higher
```

#### Step 2: Update Package
```bash
# Uninstall old version
pip uninstall SpotifyScraper

# Install new version
pip install spotifyscraper>=2.0.0
```

#### Step 3: Update Code

Option A - Quick fix (use compatibility layer):
```python
# Change this line:
from SpotifyScraper.scraper import Scraper, Request

# To this:
from spotify_scraper.compat import Scraper, Request
```

Option B - Full migration (recommended):
```python
# Old
from SpotifyScraper.scraper import Scraper, Request
req = Request().request()
scraper = Scraper(session=req)
track = scraper.get_track_url_info(url="...")

# New 
from spotify_scraper import SpotifyClient
client = SpotifyClient()
track = client.get_track("...")
```

#### Step 4: Test
```bash
# Run your tests
pytest

# Or test manually
python -c "from spotify_scraper import SpotifyClient; print('Import successful!')"
```

### Need Help?

- 📖 [Migration Guide](https://spotifyscraper.readthedocs.io/en/latest/migration/)
- 💬 [GitHub Discussions](https://github.com/AliAkhtari78/SpotifyScraper/discussions)
- 🐛 [Report Issues](https://github.com/AliAkhtari78/SpotifyScraper/issues)

---

[Unreleased]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v2.0.0...HEAD
[2.0.0]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.5...v2.0.0
[1.0.5]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.4...v1.0.5
[1.0.4]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.3...v1.0.4
[1.0.3]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.2...v1.0.3
[1.0.2]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.1...v1.0.2
[1.0.1]: https://github.com/AliAkhtari78/SpotifyScraper/compare/v1.0.0...v1.0.1
[1.0.0]: https://github.com/AliAkhtari78/SpotifyScraper/releases/tag/v1.0.0
