"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrContainersCreateVirtualCluster = exports.EksClusterInput = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Class for supported types of EMR Containers' Container Providers
 */
var ContainerProviderTypes;
(function (ContainerProviderTypes) {
    /**
     * Supported container provider type for a EKS Cluster
     */
    ContainerProviderTypes["EKS"] = "EKS";
})(ContainerProviderTypes || (ContainerProviderTypes = {}));
/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 */
class EksClusterInput {
    /**
     * Initializes the clusterName
     *
     * @param clusterName The name of the EKS Cluster
     */
    constructor(clusterName) {
        this.clusterName = clusterName;
    }
    /**
     * Specify an existing EKS Cluster as the name for this Cluster
     */
    static fromCluster(cluster) {
        return new EksClusterInput(cluster.clusterName);
    }
    /**
     * Specify a Task Input as the name for this Cluster
     */
    static fromTaskInput(taskInput) {
        return new EksClusterInput(taskInput.value);
    }
}
exports.EksClusterInput = EksClusterInput;
_a = JSII_RTTI_SYMBOL_1;
EksClusterInput[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EksClusterInput", version: "1.152.0" };
/**
 * Task that creates an EMR Containers virtual cluster from an EKS cluster
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-emr-eks.html
 */
class EmrContainersCreateVirtualCluster extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _c;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrContainersCreateVirtualClusterProps(props);
        this.integrationPattern = (_c = props.integrationPattern) !== null && _c !== void 0 ? _c : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    /**
     * @internal
     */
    _renderTask() {
        var _c, _d;
        return {
            Resource: task_utils_1.integrationResourceArn('emr-containers', 'createVirtualCluster', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Name: (_c = this.props.virtualClusterName) !== null && _c !== void 0 ? _c : sfn.JsonPath.stringAt('States.Format(\'{}/{}\', $$.Execution.Name, $$.State.Name)'),
                ContainerProvider: {
                    Id: this.props.eksCluster.clusterName,
                    Info: {
                        EksInfo: {
                            Namespace: (_d = this.props.eksNamespace) !== null && _d !== void 0 ? _d : 'default',
                        },
                    },
                    Type: ContainerProviderTypes.EKS,
                },
                Tags: this.props.tags,
            }),
        };
    }
    ;
    createPolicyStatements() {
        return [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['emr-containers:CreateVirtualCluster'],
            }),
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'iam',
                        region: '',
                        resource: 'role/aws-service-role/emr-containers.amazonaws.com',
                        resourceName: 'AWSServiceRoleForAmazonEMRContainers',
                    }),
                ],
                actions: ['iam:CreateServiceLinkedRole'],
                conditions: {
                    StringLike: { 'iam:AWSServiceName': 'emr-containers.amazonaws.com' },
                },
            }),
        ];
    }
}
exports.EmrContainersCreateVirtualCluster = EmrContainersCreateVirtualCluster;
_b = JSII_RTTI_SYMBOL_1;
EmrContainersCreateVirtualCluster[_b] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrContainersCreateVirtualCluster", version: "1.152.0" };
EmrContainersCreateVirtualCluster.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3JlYXRlLXZpcnR1YWwtY2x1c3Rlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNyZWF0ZS12aXJ0dWFsLWNsdXN0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0Esd0NBQXdDO0FBQ3hDLGtEQUFrRDtBQUNsRCx3Q0FBc0M7QUFFdEMsc0RBQXlGO0FBRXpGOztHQUVHO0FBQ0gsSUFBSyxzQkFNSjtBQU5ELFdBQUssc0JBQXNCO0lBRXpCOztPQUVHO0lBQ0gscUNBQVcsQ0FBQTtBQUNiLENBQUMsRUFOSSxzQkFBc0IsS0FBdEIsc0JBQXNCLFFBTTFCO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGVBQWU7SUFnQjFCOzs7O09BSUc7SUFDSCxZQUE2QixXQUFtQjtRQUFuQixnQkFBVyxHQUFYLFdBQVcsQ0FBUTtLQUFLO0lBbkJyRDs7T0FFRztJQUNILE1BQU0sQ0FBQyxXQUFXLENBQUMsT0FBcUI7UUFDdEMsT0FBTyxJQUFJLGVBQWUsQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDakQ7SUFFRDs7T0FFRztJQUNILE1BQU0sQ0FBQyxhQUFhLENBQUMsU0FBd0I7UUFDM0MsT0FBTyxJQUFJLGVBQWUsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDN0M7O0FBZEgsMENBc0JDOzs7QUFrQ0Q7Ozs7R0FJRztBQUNILE1BQWEsaUNBQWtDLFNBQVEsR0FBRyxDQUFDLGFBQWE7SUFXdEUsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBbUIsS0FBNkM7O1FBQ3RHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRGlDLFVBQUssR0FBTCxLQUFLLENBQXdDOztRQUV0RyxJQUFJLENBQUMsa0JBQWtCLFNBQUcsS0FBSyxDQUFDLGtCQUFrQixtQ0FBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUM7UUFDOUYscUNBQXdCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixFQUFFLGlDQUFpQyxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFFcEgsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztLQUNuRDtJQUVEOztPQUVHO0lBQ08sV0FBVzs7UUFDbkIsT0FBTztZQUNMLFFBQVEsRUFBRSxtQ0FBc0IsQ0FBQyxnQkFBZ0IsRUFBRSxzQkFBc0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUM7WUFDbkcsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO2dCQUN0QyxJQUFJLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsbUNBQUksR0FBRyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsNERBQTRELENBQUM7Z0JBQzFILGlCQUFpQixFQUFFO29CQUNqQixFQUFFLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsV0FBVztvQkFDckMsSUFBSSxFQUFFO3dCQUNKLE9BQU8sRUFBRTs0QkFDUCxTQUFTLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLG1DQUFJLFNBQVM7eUJBQ2hEO3FCQUNGO29CQUNELElBQUksRUFBRSxzQkFBc0IsQ0FBQyxHQUFHO2lCQUNqQztnQkFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJO2FBQ3RCLENBQUM7U0FDSCxDQUFDO0tBQ0g7SUFBQSxDQUFDO0lBRU0sc0JBQXNCO1FBQzVCLE9BQU87WUFDTCxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7Z0JBQ3RCLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztnQkFDaEIsT0FBTyxFQUFFLENBQUMscUNBQXFDLENBQUM7YUFDakQsQ0FBQztZQUNGLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsU0FBUyxFQUFFO29CQUNULFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO3dCQUN2QixPQUFPLEVBQUUsS0FBSzt3QkFDZCxNQUFNLEVBQUUsRUFBRTt3QkFDVixRQUFRLEVBQUUsb0RBQW9EO3dCQUM5RCxZQUFZLEVBQUUsc0NBQXNDO3FCQUNyRCxDQUFDO2lCQUNIO2dCQUNELE9BQU8sRUFBRSxDQUFDLDZCQUE2QixDQUFDO2dCQUN4QyxVQUFVLEVBQUU7b0JBQ1YsVUFBVSxFQUFFLEVBQUUsb0JBQW9CLEVBQUUsOEJBQThCLEVBQUU7aUJBQ3JFO2FBQ0YsQ0FBQztTQUNILENBQUM7S0FDSDs7QUE5REgsOEVBK0RDOzs7QUE3RHlCLGdFQUE4QixHQUE2QjtJQUNqRixHQUFHLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCO0NBQ3hDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBla3MgZnJvbSAnQGF3cy1jZGsvYXdzLWVrcyc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgaW50ZWdyYXRpb25SZXNvdXJjZUFybiwgdmFsaWRhdGVQYXR0ZXJuU3VwcG9ydGVkIH0gZnJvbSAnLi4vcHJpdmF0ZS90YXNrLXV0aWxzJztcblxuLyoqXG4gKiBDbGFzcyBmb3Igc3VwcG9ydGVkIHR5cGVzIG9mIEVNUiBDb250YWluZXJzJyBDb250YWluZXIgUHJvdmlkZXJzXG4gKi9cbmVudW0gQ29udGFpbmVyUHJvdmlkZXJUeXBlcyB7XG5cbiAgLyoqXG4gICAqIFN1cHBvcnRlZCBjb250YWluZXIgcHJvdmlkZXIgdHlwZSBmb3IgYSBFS1MgQ2x1c3RlclxuICAgKi9cbiAgRUtTID0gJ0VLUydcbn1cblxuLyoqXG4gKiBDbGFzcyB0aGF0IHN1cHBvcnRzIG1ldGhvZHMgd2hpY2ggcmV0dXJuIHRoZSBFS1MgY2x1c3RlciBuYW1lIGRlcGVuZGluZyBvbiBpbnB1dCB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgRWtzQ2x1c3RlcklucHV0IHtcblxuICAvKipcbiAgICogU3BlY2lmeSBhbiBleGlzdGluZyBFS1MgQ2x1c3RlciBhcyB0aGUgbmFtZSBmb3IgdGhpcyBDbHVzdGVyXG4gICAqL1xuICBzdGF0aWMgZnJvbUNsdXN0ZXIoY2x1c3RlcjogZWtzLklDbHVzdGVyKTogRWtzQ2x1c3RlcklucHV0IHtcbiAgICByZXR1cm4gbmV3IEVrc0NsdXN0ZXJJbnB1dChjbHVzdGVyLmNsdXN0ZXJOYW1lKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IGEgVGFzayBJbnB1dCBhcyB0aGUgbmFtZSBmb3IgdGhpcyBDbHVzdGVyXG4gICAqL1xuICBzdGF0aWMgZnJvbVRhc2tJbnB1dCh0YXNrSW5wdXQ6IHNmbi5UYXNrSW5wdXQpOiBFa3NDbHVzdGVySW5wdXQge1xuICAgIHJldHVybiBuZXcgRWtzQ2x1c3RlcklucHV0KHRhc2tJbnB1dC52YWx1ZSk7XG4gIH1cblxuICAvKipcbiAgICogSW5pdGlhbGl6ZXMgdGhlIGNsdXN0ZXJOYW1lXG4gICAqXG4gICAqIEBwYXJhbSBjbHVzdGVyTmFtZSBUaGUgbmFtZSBvZiB0aGUgRUtTIENsdXN0ZXJcbiAgICovXG4gIHByaXZhdGUgY29uc3RydWN0b3IocmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZykgeyB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBkZWZpbmUgYSBFTVIgQ29udGFpbmVycyBDcmVhdGVWaXJ0dWFsQ2x1c3RlciBUYXNrIG9uIGFuIEVLUyBjbHVzdGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRW1yQ29udGFpbmVyc0NyZWF0ZVZpcnR1YWxDbHVzdGVyUHJvcHMgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZVByb3BzIHtcblxuICAvKipcbiAgICogRUtTIENsdXN0ZXIgb3IgdGFzayBpbnB1dCB0aGF0IGNvbnRhaW5zIHRoZSBuYW1lIG9mIHRoZSBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSBla3NDbHVzdGVyOiBFa3NDbHVzdGVySW5wdXQ7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lc3BhY2Ugb2YgYW4gRUtTIGNsdXN0ZXJcbiAgICpcbiAgICogQGRlZmF1bHQgLSAnZGVmYXVsdCdcbiAgICovXG4gIHJlYWRvbmx5IGVrc05hbWVzcGFjZT86IHN0cmluZztcblxuICAvKipcbiAgICogTmFtZSBvZiB0aGUgdmlydHVhbCBjbHVzdGVyIHRoYXQgd2lsbCBiZSBjcmVhdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRoZSBuYW1lIG9mIHRoZSBzdGF0ZSBtYWNoaW5lIGV4ZWN1dGlvbiB0aGF0IHJ1bnMgdGhpcyB0YXNrIGFuZCBzdGF0ZSBuYW1lXG4gICAqL1xuICByZWFkb25seSB2aXJ0dWFsQ2x1c3Rlck5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSB0YWdzIGFzc2lnbmVkIHRvIHRoZSB2aXJ0dWFsIGNsdXN0ZXJcbiAgICpcbiAgICogQGRlZmF1bHQge31cbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG4vKipcbiAqIFRhc2sgdGhhdCBjcmVhdGVzIGFuIEVNUiBDb250YWluZXJzIHZpcnR1YWwgY2x1c3RlciBmcm9tIGFuIEVLUyBjbHVzdGVyXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2Nvbm5lY3QtZW1yLWVrcy5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBFbXJDb250YWluZXJzQ3JlYXRlVmlydHVhbENsdXN0ZXIgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZSB7XG5cbiAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgU1VQUE9SVEVEX0lOVEVHUkFUSU9OX1BBVFRFUk5TOiBzZm4uSW50ZWdyYXRpb25QYXR0ZXJuW10gPSBbXG4gICAgc2ZuLkludGVncmF0aW9uUGF0dGVybi5SRVFVRVNUX1JFU1BPTlNFLFxuICBdO1xuXG4gIHByb3RlY3RlZCByZWFkb25seSB0YXNrTWV0cmljcz86IHNmbi5UYXNrTWV0cmljc0NvbmZpZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tQb2xpY2llcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcblxuICBwcml2YXRlIHJlYWRvbmx5IGludGVncmF0aW9uUGF0dGVybjogc2ZuLkludGVncmF0aW9uUGF0dGVybjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBFbXJDb250YWluZXJzQ3JlYXRlVmlydHVhbENsdXN0ZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuID0gcHJvcHMuaW50ZWdyYXRpb25QYXR0ZXJuID8/IHNmbi5JbnRlZ3JhdGlvblBhdHRlcm4uUkVRVUVTVF9SRVNQT05TRTtcbiAgICB2YWxpZGF0ZVBhdHRlcm5TdXBwb3J0ZWQodGhpcy5pbnRlZ3JhdGlvblBhdHRlcm4sIEVtckNvbnRhaW5lcnNDcmVhdGVWaXJ0dWFsQ2x1c3Rlci5TVVBQT1JURURfSU5URUdSQVRJT05fUEFUVEVSTlMpO1xuXG4gICAgdGhpcy50YXNrUG9saWNpZXMgPSB0aGlzLmNyZWF0ZVBvbGljeVN0YXRlbWVudHMoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfcmVuZGVyVGFzaygpOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICBSZXNvdXJjZTogaW50ZWdyYXRpb25SZXNvdXJjZUFybignZW1yLWNvbnRhaW5lcnMnLCAnY3JlYXRlVmlydHVhbENsdXN0ZXInLCB0aGlzLmludGVncmF0aW9uUGF0dGVybiksXG4gICAgICBQYXJhbWV0ZXJzOiBzZm4uRmllbGRVdGlscy5yZW5kZXJPYmplY3Qoe1xuICAgICAgICBOYW1lOiB0aGlzLnByb3BzLnZpcnR1YWxDbHVzdGVyTmFtZSA/PyBzZm4uSnNvblBhdGguc3RyaW5nQXQoJ1N0YXRlcy5Gb3JtYXQoXFwne30ve31cXCcsICQkLkV4ZWN1dGlvbi5OYW1lLCAkJC5TdGF0ZS5OYW1lKScpLFxuICAgICAgICBDb250YWluZXJQcm92aWRlcjoge1xuICAgICAgICAgIElkOiB0aGlzLnByb3BzLmVrc0NsdXN0ZXIuY2x1c3Rlck5hbWUsXG4gICAgICAgICAgSW5mbzoge1xuICAgICAgICAgICAgRWtzSW5mbzoge1xuICAgICAgICAgICAgICBOYW1lc3BhY2U6IHRoaXMucHJvcHMuZWtzTmFtZXNwYWNlID8/ICdkZWZhdWx0JyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgICBUeXBlOiBDb250YWluZXJQcm92aWRlclR5cGVzLkVLUyxcbiAgICAgICAgfSxcbiAgICAgICAgVGFnczogdGhpcy5wcm9wcy50YWdzLFxuICAgICAgfSksXG4gICAgfTtcbiAgfTtcblxuICBwcml2YXRlIGNyZWF0ZVBvbGljeVN0YXRlbWVudHMoKTogaWFtLlBvbGljeVN0YXRlbWVudFtdIHtcbiAgICByZXR1cm4gW1xuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICByZXNvdXJjZXM6IFsnKiddLCAvLyBXZSBuZWVkICogcGVybWlzc2lvbnMgZm9yIGNyZWF0aW5nIGEgdmlydHVhbCBjbHVzdGVyIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9lbXIvbGF0ZXN0L0VNUi1vbi1FS1MtRGV2ZWxvcG1lbnRHdWlkZS9zZXR0aW5nLXVwLWlhbS5odG1sXG4gICAgICAgIGFjdGlvbnM6IFsnZW1yLWNvbnRhaW5lcnM6Q3JlYXRlVmlydHVhbENsdXN0ZXInXSxcbiAgICAgIH0pLFxuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICByZXNvdXJjZXM6IFtcbiAgICAgICAgICBTdGFjay5vZih0aGlzKS5mb3JtYXRBcm4oe1xuICAgICAgICAgICAgc2VydmljZTogJ2lhbScsXG4gICAgICAgICAgICByZWdpb246ICcnLFxuICAgICAgICAgICAgcmVzb3VyY2U6ICdyb2xlL2F3cy1zZXJ2aWNlLXJvbGUvZW1yLWNvbnRhaW5lcnMuYW1hem9uYXdzLmNvbScsXG4gICAgICAgICAgICByZXNvdXJjZU5hbWU6ICdBV1NTZXJ2aWNlUm9sZUZvckFtYXpvbkVNUkNvbnRhaW5lcnMnLFxuICAgICAgICAgIH0pLFxuICAgICAgICBdLFxuICAgICAgICBhY3Rpb25zOiBbJ2lhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZSddLFxuICAgICAgICBjb25kaXRpb25zOiB7XG4gICAgICAgICAgU3RyaW5nTGlrZTogeyAnaWFtOkFXU1NlcnZpY2VOYW1lJzogJ2Vtci1jb250YWluZXJzLmFtYXpvbmF3cy5jb20nIH0sXG4gICAgICAgIH0sXG4gICAgICB9KSxcbiAgICBdO1xuICB9XG59XG4iXX0=