"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallAwsService = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions task to call an AWS service API
 */
class CallAwsService extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_CallAwsServiceProps(props);
        if (this.props.integrationPattern === sfn.IntegrationPattern.RUN_JOB) {
            throw new Error('The RUN_JOB integration pattern is not supported for CallAwsService');
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: props.iamResources,
                // The prefix and the action name are case insensitive
                // https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
                actions: [(_b = props.iamAction) !== null && _b !== void 0 ? _b : `${props.service}:${props.action}`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        var _b;
        let service = this.props.service;
        if (!core_1.Token.isUnresolved(service)) {
            service = service.toLowerCase();
        }
        return {
            Resource: task_utils_1.integrationResourceArn('aws-sdk', `${service}:${this.props.action}`, this.props.integrationPattern),
            Parameters: (_b = sfn.FieldUtils.renderObject(this.props.parameters)) !== null && _b !== void 0 ? _b : {},
        };
    }
}
exports.CallAwsService = CallAwsService;
_a = JSII_RTTI_SYMBOL_1;
CallAwsService[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallAwsService", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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