"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AthenaGetQueryResults = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * Get an Athena Query Results as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 */
class AthenaGetQueryResults extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_AthenaGetQueryResultsProps(props);
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaGetQueryResults.SUPPORTED_INTEGRATION_PATTERNS);
        const policyStatements = [
            new iam.PolicyStatement({
                resources: ['*'],
                actions: ['athena:getQueryResults'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:GetObject'],
            resources: ['*'],
        }));
        this.taskPolicies = policyStatements;
    }
    /**
     * Provides the Athena get query results service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('athena', 'getQueryResults', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueryExecutionId: this.props.queryExecutionId,
                NextToken: this.props.nextToken,
                MaxResults: this.props.maxResults,
            }),
        };
    }
}
exports.AthenaGetQueryResults = AthenaGetQueryResults;
_a = JSII_RTTI_SYMBOL_1;
AthenaGetQueryResults[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.AthenaGetQueryResults", version: "1.152.0" };
AthenaGetQueryResults.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
//# sourceMappingURL=data:application/json;base64,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