"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Skill = exports.SkillType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const alexa_ask_1 = require("aws-cdk-lib/alexa-ask");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * Enumeration for different Alexa Skill types.
 */
var SkillType;
(function (SkillType) {
    SkillType["CUSTOM"] = "CUSTOM";
    SkillType["SMART_HOME"] = "SMART_HOME";
})(SkillType || (exports.SkillType = SkillType = {}));
/**
 * Base class for the Alexa Skill construct.
 */
class SkillBase extends aws_cdk_lib_1.Resource {
}
/**
 * Alexa Skill construct for managing an Alexa Skill via CloudFormation.
 */
class Skill extends SkillBase {
    /**
     * Factory method to create an Alexa Skill from its ID.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param skillId - The ID of the Alexa Skill.
     * @returns The Alexa Skill construct.
     */
    static fromSkillId(scope, id, skillId) {
        return new (class extends SkillBase {
            constructor() {
                super(...arguments);
                this.skillId = skillId;
            }
            get skillType() {
                throw new Error('Access to skillType is not supported when using fromSkillId');
            }
            get skillStage() {
                throw new Error('Access to skillStage is not supported when using fromSkillId');
            }
        })(scope, id);
    }
    /**
     * Factory method to create an Alexa Skill from its attributes.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param attributes - The attributes of the Alexa Skill.
     * @returns The Alexa Skill construct.
     */
    static fromAttributes(scope, id, attributes) {
        return new (class extends SkillBase {
            constructor() {
                super(...arguments);
                this.skillId = attributes.skillId;
                this.skillType = attributes.skillType;
                this.skillStage = attributes.skillStage;
            }
        })(scope, id);
    }
    /**
     * Creates an instance of the Alexa Skill construct.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Alexa Skill properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.packageRole = new aws_iam_1.Role(this, 'PackageRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('alexa-appkit.amazon.com'),
        });
        this.resource = new alexa_ask_1.CfnSkill(this, 'Default', {
            skillPackage: {
                s3Bucket: props.skillPackage.asset.s3BucketName,
                s3Key: props.skillPackage.asset.s3ObjectKey,
                s3BucketRole: this.packageRole.roleArn,
                overrides: {
                    ...props.skillPackage.overrides,
                    manifest: {
                        ...props.skillPackage.overrides?.manifest,
                        publishingInformation: {
                            category: props.skillType,
                            ...props.skillPackage.overrides?.manifest?.publishingInformation,
                        },
                    },
                },
            },
            vendorId: props.vendorId,
            authenticationConfiguration: props.authenticationConfiguration,
        });
        this.resource.node.addDependency(this.packageRole);
        this.resource.node.addDependency(props.skillPackage.asset);
        props.skillPackage.asset.grantRead(this.packageRole);
        this.skillId = this.resource.ref;
        this.skillStage = props.skillStage;
        this.skillType = props.skillType;
    }
}
exports.Skill = Skill;
_a = JSII_RTTI_SYMBOL_1;
Skill[_a] = { fqn: "cdk-skill-management.Skill", version: "1.0.11" };
//# sourceMappingURL=data:application/json;base64,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