import { Construct, IDependable } from 'constructs';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { ISkill, SkillType } from './skill';
/**
 * Properties for configuring a Skill Endpoint Permission.
 */
export interface SkillEndpointProps {
    /** The AWS Lambda function handler to configure the permission for. */
    readonly handler: IFunction;
    /** The Type of the Skill, which will be created later */
    readonly skillType: SkillType;
}
/**
 * Interface representing a Skill Endpoint Permission.
 */
export interface ISkillEndpointPermission {
    /**
     * Configures a Skill Endpoint Permission for a specific skill.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param skill - The skill to configure the permission for.
     * @returns An IDependable object representing the configured permission.
     */
    configureSkillId(scope: Construct, id: string, skill: ISkill): IDependable;
}
/**
 * Class for configuring and managing Skill Endpoint Permissions.
 */
export declare class SkillEndpointPermission extends Construct implements ISkillEndpointPermission {
    private readonly principals;
    private readonly skillType;
    private readonly handler;
    private readonly permission;
    private readonly policy;
    /**
     * Creates an instance of the Skill Endpoint Permission.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Skill Endpoint properties.
     */
    constructor(scope: Construct, id: string, props: SkillEndpointProps);
    /**
     * Configures a Skill Endpoint Permission for a specific skill.
     * This replaces the initially created permission with a new permission checking for the SkillId.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param skill - The skill to configure the permission for.
     * @returns An IDependable object representing the configured permission.
     */
    configureSkillId(scope: Construct, id: string, skill: ISkill): IDependable;
    private removePermissionCall;
    private addPermissionCall;
}
