"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountLinking = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ask_custom_resource_1 = require("../ask/ask-custom-resource");
/**
 * Represents an Account Linking resource for an Alexa Skill.
 */
class AccountLinking extends aws_cdk_lib_1.Resource {
    /**
     * Creates an instance of the Account Linking resource.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Account Linking properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.resource = new ask_custom_resource_1.AskCustomResource(this, 'Default', {
            authenticationConfiguration: props.authenticationConfiguration,
            onUpdate: {
                action: 'updateAccountLinkingInfoV1',
                parameters: [props.skill.skillId, props.skill.skillStage, { accountLinkingRequest: props.request }],
            },
            onDelete: {
                action: 'deleteAccountLinkingInfoV1',
                parameters: [props.skill.skillId, props.skill.skillStage],
            },
        });
        this.resource.node.addDependency(props.skill);
    }
}
exports.AccountLinking = AccountLinking;
_a = JSII_RTTI_SYMBOL_1;
AccountLinking[_a] = { fqn: "cdk-skill-management.AccountLinking", version: "1.0.11" };
//# sourceMappingURL=data:application/json;base64,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